/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.memberLeave;

import com.seeyon.cap4.form.modules.formlist.CAP4FormListManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.organization.memberleave.bo.MemberLeaveDetail;
import com.seeyon.ctp.organization.memberleave.manager.AbstractMemberLeaveClearItem;
import com.seeyon.ctp.organization.memberleave.manager.MemberLeaveClearItemInterface;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cap4MemberLeaveClearItemFormImpl
extends AbstractMemberLeaveClearItem {
    private CAP4FormListManager cap4FormListManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private OrgManager orgManager;

    public void updateAuthority(Long oldMemberId, Long newMemberId, List<String> formIds) throws BusinessException {
        String authNames = this.getAuthNames(oldMemberId, formIds, new String[]{"title"});
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < formIds.size(); ++i) {
            sb.append(formIds.get(i)).append(",");
        }
        V3xOrgMember newMember = this.orgManager.getMemberById(newMemberId);
        this.cap4FormListManager.changeOwner(sb.toString().substring(0, sb.toString().length() - 1), newMember.getOrgAccountId(), newMemberId);
        this.saveLog(oldMemberId, newMemberId, authNames);
    }

    public MemberLeaveClearItemInterface.Category getCategory() {
        return MemberLeaveClearItemInterface.Category.BusinessCap4;
    }

    public List<MemberLeaveDetail> getItems(long memberId) throws BusinessException {
        ArrayList<MemberLeaveDetail> result = new ArrayList<MemberLeaveDetail>();
        V3xOrgMember member = this.orgManager.getMemberById(Long.valueOf(memberId));
        if (member == null) {
            return result;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ownerId", memberId);
        FlipInfo fi = new FlipInfo();
        fi.setNeedTotal(false);
        List<Map<String, Object>> data = this.cap4FormCacheManager.getCap4FormDefinitionDAO().showFormListByOwner(fi, params);
        if (!Strings.isEmpty(data)) {
            HashMap<Long, String> map = new HashMap<Long, String>();
            String accountName = "";
            for (Map<String, Object> m : data) {
                if (map.containsKey(m.get("orgAccountId"))) {
                    accountName = (String)map.get(m.get("orgAccountId"));
                } else {
                    Long accountId = Long.valueOf(m.get("orgAccountId").toString());
                    V3xOrgAccount v3xOrgAccount = this.orgManager.getAccountById(accountId);
                    accountName = v3xOrgAccount.getName();
                    map.put(accountId, accountName);
                }
                MemberLeaveDetail memberLeaveDetail = new MemberLeaveDetail();
                memberLeaveDetail.setId(m.get("id").toString());
                memberLeaveDetail.setDealInterfaceClassName(((Object)((Object)this)).getClass().getSimpleName());
                memberLeaveDetail.setType(ResourceUtil.getString((String)"member.leave.form.title"));
                memberLeaveDetail.setAccountName(accountName);
                memberLeaveDetail.setAccountId(Long.valueOf(Long.parseLong(m.get("orgAccountId").toString())));
                memberLeaveDetail.setContent(member.getName());
                memberLeaveDetail.setTitle(m.get("formName").toString());
                result.add(memberLeaveDetail);
            }
        }
        return result;
    }

    public Integer getSortId() {
        return 1;
    }

    public void setCap4FormListManager(CAP4FormListManager cap4FormListManager) {
        this.cap4FormListManager = cap4FormListManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }
}

