/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.mutibusinessmenu;

import com.seeyon.cap4.form.modules.mutibusinessmenu.MutiBusinessMenuDAO;
import com.seeyon.cap4.form.po.CapMutiBusinessMenu;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MutiBusinessMenuDAOImpl
implements MutiBusinessMenuDAO {
    @Override
    public List<CapMutiBusinessMenu> findMutiBusinessMenus() throws BusinessException {
        String hql = "FROM CapMutiBusinessMenu";
        return DBAgent.find((String)hql);
    }

    @Override
    public List<CapMutiBusinessMenu> findMutiBusinessMenusByOrgAccountId(Long orgAccountId) throws BusinessException {
        String hql = "FROM CapMutiBusinessMenu AS m WHERE m.orgAccountId=:orgAccountId";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("orgAccountId", orgAccountId);
        return DBAgent.find((String)hql, map);
    }

    @Override
    public CapMutiBusinessMenu findMutiBusinessMenuById(Long mutiBusinessMenuId) throws BusinessException {
        return (CapMutiBusinessMenu)((Object)DBAgent.get(CapMutiBusinessMenu.class, (Serializable)mutiBusinessMenuId));
    }

    @Override
    public List<CapMutiBusinessMenu> findMutiBusinessMenuByIds(List<Long> mutiBusinessMenuIds) throws BusinessException {
        String hql = "FROM CapMutiBusinessMenu mbm WHERE mbm.id IN (:ids)";
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("ids", mutiBusinessMenuIds);
        List list = DBAgent.find((String)hql, map);
        return list;
    }

    @Override
    public CapMutiBusinessMenu findMutiBusinessMenuByMenuId(Long menuId) throws BusinessException {
        String hql = "FROM CapMutiBusinessMenu AS m WHERE m.menuId=:menuId";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("menuId", menuId);
        List list = DBAgent.find((String)hql, map);
        if (list != null && !list.isEmpty()) {
            return (CapMutiBusinessMenu)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> findMutiBusinessMenuByCondition(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        HashMap<String, Long> parameterMap = new HashMap<String, Long>();
        boolean isAdmin = AppContext.isAdministrator();
        StringBuilder hql = new StringBuilder("select");
        hql.append(" new map(m.id as id, m.name as name, m.menuId as menuId, m.createUser as createUser, o.name as userName, m.createDate as createDate, m.updateDate as updateDate, m.delFlag as delFlag, m.sort as sort, m.modifyUser as modifyUser, m.orgAccountId as orgAccountId, m.icon as icon)");
        hql.append(" from CapMutiBusinessMenu m, OrgMember o where m.createUser = o.id ");
        if (isAdmin) {
            hql.append(" and m.orgAccountId=:orgAccountId and m.createUser=:createUser");
            parameterMap.put("orgAccountId", AppContext.currentAccountId());
            parameterMap.put("createUser", AppContext.currentUserId());
        }
        hql.append(" order by m.createDate desc, m.updateDate desc");
        return DBAgent.find((String)hql.toString(), parameterMap, (FlipInfo)fi);
    }

    @Override
    public void saveOrUpdateMutiBusinessMenu(CapMutiBusinessMenu mutiBusinessMenu) throws BusinessException {
        CapMutiBusinessMenu mbm = (CapMutiBusinessMenu)((Object)DBAgent.get(CapMutiBusinessMenu.class, (Serializable)mutiBusinessMenu.getId()));
        if (null == mbm) {
            DBAgent.save((Object)((Object)mutiBusinessMenu));
        } else {
            DBAgent.merge((Object)((Object)mutiBusinessMenu));
        }
    }

    @Override
    public void deleteMutiBusinessMenuById(Long mutiBusinessMenuId) throws BusinessException {
        CapMutiBusinessMenu mutiBusinessMenu = this.findMutiBusinessMenuById(mutiBusinessMenuId);
        if (mutiBusinessMenu != null) {
            DBAgent.delete((Object)((Object)mutiBusinessMenu));
        }
    }

    @Override
    public void deleteMutiBusinessMenus(List<Long> mutiBusinessMenuIds) throws BusinessException {
        String hql = "DELETE FROM CapMutiBusinessMenu mbm WHERE mbm.id IN (:ids)";
        HashMap<String, List<Long>> parameterMap = new HashMap<String, List<Long>>();
        parameterMap.put("ids", mutiBusinessMenuIds);
        DBAgent.bulkUpdate((String)hql, parameterMap);
    }

    @Override
    public void deleteMutiBusinessMenuByMenuId(Long menuId) throws BusinessException {
        CapMutiBusinessMenu mutiBusinessMenu = this.findMutiBusinessMenuByMenuId(menuId);
        if (mutiBusinessMenu != null) {
            DBAgent.delete((Object)((Object)mutiBusinessMenu));
        }
    }

    @Override
    public Integer getMutiBusinessMaxSort() throws BusinessException {
        Object result;
        String sql = "select max(sort) from CapMutiBusinessMenu";
        List lsit = DBAgent.find((String)sql);
        if (Strings.isNotEmpty((Collection)lsit) && (result = lsit.get(0)) != null) {
            return Integer.parseInt(result.toString()) + 1;
        }
        return 1100;
    }
}

