/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.mutibusinessmenu;

import com.seeyon.cap4.form.modules.mutibusinessmenu.MutiBusinessMenuBean;
import com.seeyon.cap4.form.modules.mutibusinessmenu.MutiBusinessMenuDAO;
import com.seeyon.cap4.form.modules.mutibusinessmenu.MutiBusinessMenuItem;
import com.seeyon.cap4.form.modules.mutibusinessmenu.MutiBusinessMenuManager;
import com.seeyon.cap4.form.modules.mutibusinessmenu.MutiBusinessUtil;
import com.seeyon.cap4.form.po.CapMutiBusinessMenu;
import com.seeyon.cap4.form.util.BusinessUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.appLog.AppLogAction;
import com.seeyon.ctp.common.appLog.manager.AppLogManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.V3xOrgRole;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.organization.manager.OrgManagerDirect;
import com.seeyon.ctp.organization.manager.RoleManager;
import com.seeyon.ctp.portal.api.PortalApi;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.privilege.enums.PrivMenuTypeEnums;
import com.seeyon.ctp.privilege.manager.PrivilegeManager;
import com.seeyon.ctp.privilege.manager.PrivilegeMenuManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class MutiBusinessMenuManagerImpl
implements MutiBusinessMenuManager {
    private final Log logger = CtpLogFactory.getLog(MutiBusinessMenuManagerImpl.class);
    private MutiBusinessMenuDAO mutiBusinessMenuDAO;
    private OrgManager orgManager;
    private PrivilegeManager privilegeManager;
    private PrivilegeMenuManager privilegeMenuManager;
    private AppLogManager appLogManager;
    private RoleManager roleManager;
    private OrgManagerDirect orgManagerDirect;
    private PortalApi portalApi;

    @Override
    public void saveOrUpdateMutiBusinessMenu(CapMutiBusinessMenu mutiBusinessMenu) throws Exception {
        V3xOrgRole orgRole;
        MutiBusinessMenuBean mutiBusinessMenuBean;
        String isNew = (String)mutiBusinessMenu.getExtraAttr("isNew");
        if ("true".equals(isNew)) {
            mutiBusinessMenuBean = new MutiBusinessMenuBean(mutiBusinessMenu);
            mutiBusinessMenuBean.setMenuId(UUIDLong.longUUID());
            mutiBusinessMenuBean.setCreateDate(DateUtil.currentDate());
            mutiBusinessMenuBean.setCreateUser(AppContext.currentUserId());
            mutiBusinessMenuBean.setUpdateDate(DateUtil.currentDate());
            mutiBusinessMenuBean.setDelFlag(0);
            mutiBusinessMenuBean.setSort(this.mutiBusinessMenuDAO.getMutiBusinessMaxSort());
            orgRole = new V3xOrgRole();
            orgRole.setId(mutiBusinessMenuBean.getMenuId());
            orgRole.setName(mutiBusinessMenuBean.getRoleName());
            orgRole.setCode(mutiBusinessMenuBean.getMenuId().toString());
            orgRole.setCreateTime((Date)DateUtil.currentTimestamp());
        } else {
            mutiBusinessMenuBean = new MutiBusinessMenuBean(this.mutiBusinessMenuDAO.findMutiBusinessMenuById(mutiBusinessMenu.getId()));
            mutiBusinessMenuBean.setModifyUser(AppContext.currentUserId());
            mutiBusinessMenuBean.setUpdateDate(DateUtil.currentDate());
            mutiBusinessMenuBean.setName(mutiBusinessMenu.getName());
            orgRole = this.orgManager.getRoleById(mutiBusinessMenuBean.getMenuId());
            orgRole.setName(mutiBusinessMenuBean.getRoleName());
            orgRole.setUpdateTime((Date)DateUtil.currentTimestamp());
        }
        mutiBusinessMenuBean.setOrgAccountId(AppContext.currentAccountId());
        orgRole.setBond(OrgConstants.ROLE_BOND.BUSINESS.ordinal());
        ArrayList<PrivMenuBO> list = new ArrayList<PrivMenuBO>();
        PrivMenuBO menuBO = new PrivMenuBO();
        menuBO.setId(mutiBusinessMenuBean.getMenuId());
        menuBO.setName(mutiBusinessMenuBean.getName());
        menuBO.setParentId(Long.valueOf(0L));
        menuBO.setCreatedate((Date)DateUtil.currentTimestamp());
        menuBO.setExt2("1");
        menuBO.setExt12(Integer.valueOf(-1));
        menuBO.setType(Integer.valueOf(PrivMenuTypeEnums.businessCap4Menu.getKey()));
        menuBO.setSortid(mutiBusinessMenuBean.getSort());
        if (Strings.isNotEmpty((String)mutiBusinessMenuBean.getIcon())) {
            menuBO.setIcon(mutiBusinessMenuBean.getIcon());
        } else {
            menuBO.setIcon("common.png");
        }
        list.add(menuBO);
        if (mutiBusinessMenuBean.getMenuList().size() > 0 && mutiBusinessMenu.getExtraAttr("MUTI_MENU_NAME_ARRAY") == null) {
            List<PrivMenuBO> listMenu = mutiBusinessMenuBean.getMenuList();
            for (PrivMenuBO privMenuBO : listMenu) {
                if (privMenuBO.getParentId() == 0L) continue;
                list.add(privMenuBO);
            }
        } else {
            MutiBusinessUtil.getPrivMenuList(mutiBusinessMenuBean, mutiBusinessMenu);
            List<PrivMenuBO> privMenuBOS = mutiBusinessMenuBean.getMenuList();
            list.addAll(privMenuBOS);
        }
        String authValue = "";
        if (Strings.isNotEmpty((String)((String)mutiBusinessMenu.getExtraAttr("MUTI_MENU_AUTHA_VALUE")))) {
            authValue = (String)mutiBusinessMenu.getExtraAttr("MUTI_MENU_AUTHA_VALUE");
        } else if (Strings.isNotEmpty((String)mutiBusinessMenuBean.getAuthValue())) {
            authValue = mutiBusinessMenuBean.getAuthValue();
        }
        this.insertMenus(list, orgRole, authValue, mutiBusinessMenuBean.getMenuId());
        this.mutiBusinessMenuDAO.saveOrUpdateMutiBusinessMenu(mutiBusinessMenuBean.getMutiBusinessMenu());
        this.privilegeMenuManager.updateBiz();
    }

    @Override
    public MutiBusinessMenuBean findMutiBusinessMenuBeanById(Long mutiBusinessMenuId) throws Exception {
        CapMutiBusinessMenu mutiBusinessMenu = this.mutiBusinessMenuDAO.findMutiBusinessMenuById(mutiBusinessMenuId);
        if (mutiBusinessMenu != null) {
            MutiBusinessMenuBean mutiBusinessMenuBean = new MutiBusinessMenuBean(mutiBusinessMenu);
            List list = this.privilegeMenuManager.getListByRole(new Long[]{mutiBusinessMenu.getMenuId()});
            mutiBusinessMenuBean.setMenuList(list);
            String[] auth = BusinessUtil.getAuthName(mutiBusinessMenu.getMenuId());
            mutiBusinessMenuBean.setAuthValue(auth[0]);
            mutiBusinessMenuBean.setAuthText(auth[1]);
            ArrayList<MutiBusinessMenuItem> mutiBusinessMenuItems = new ArrayList<MutiBusinessMenuItem>();
            for (PrivMenuBO privMenuBO : list) {
                if (privMenuBO.getParentId() == 0L) continue;
                mutiBusinessMenuItems.add(new MutiBusinessMenuItem(privMenuBO, mutiBusinessMenu));
            }
            mutiBusinessMenuBean.setItems(mutiBusinessMenuItems);
            return mutiBusinessMenuBean;
        }
        return null;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> deleteMutiBusinessMenuById(String mutiBusinessMenuId) throws Exception {
        Long mbmId;
        MutiBusinessMenuBean mutiBusinessMenuBean;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isNotBlank((String)mutiBusinessMenuId) && (mutiBusinessMenuBean = this.findMutiBusinessMenuBeanById(mbmId = Long.valueOf(mutiBusinessMenuId))) != null) {
            Long menuId = mutiBusinessMenuBean.getMenuId();
            this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.MenuSec_Delete, new String[]{AppContext.currentUserName(), mutiBusinessMenuBean.getName()});
            this.orgManagerDirect.deleteRole2Entity(menuId, null, null);
            if (Strings.isNotEmpty(mutiBusinessMenuBean.getMenuList())) {
                this.privilegeMenuManager.cleanPrivData(menuId);
            }
            this.mutiBusinessMenuDAO.deleteMutiBusinessMenuById(mbmId);
            this.roleManager.deleteRole(new Long[]{menuId});
            this.privilegeMenuManager.updateBiz();
        }
        result.put("success", true);
        return result;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> deleteMutiBusinessMenuByIds(List<String> mutiBusinessMenuIds) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isNotEmpty(mutiBusinessMenuIds)) {
            ArrayList<Long> delIds = new ArrayList<Long>(mutiBusinessMenuIds.size());
            for (String id : mutiBusinessMenuIds) {
                delIds.add(Long.valueOf(id));
            }
            List<CapMutiBusinessMenu> mutiBusinessMenus = this.mutiBusinessMenuDAO.findMutiBusinessMenuByIds(delIds);
            ArrayList<Long> menuIds = new ArrayList<Long>();
            if (Strings.isNotEmpty(mutiBusinessMenus)) {
                for (int i = 0; i < mutiBusinessMenus.size(); ++i) {
                    CapMutiBusinessMenu mutiBusinessMenu = mutiBusinessMenus.get(i);
                    Long menuId = mutiBusinessMenu.getMenuId();
                    menuIds.add(menuId);
                    this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.MenuSec_Delete, new String[]{AppContext.currentUserName(), mutiBusinessMenu.getName()});
                    this.orgManagerDirect.deleteRole2Entity(menuId, null, null);
                    this.privilegeMenuManager.cleanPrivData(menuId);
                }
                this.mutiBusinessMenuDAO.deleteMutiBusinessMenus(delIds);
                this.roleManager.deleteRole(menuIds.toArray(new Long[menuIds.size()]));
                this.privilegeMenuManager.updateBiz();
            }
        }
        result.put("success", true);
        return result;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
    public FlipInfo listMutiBusinessMenus(FlipInfo fi, Map<String, Object> params) throws Exception {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        List<Map<String, Object>> mapList = this.mutiBusinessMenuDAO.findMutiBusinessMenuByCondition(fi, params);
        ArrayList<Map<String, Object>> returnDataList = new ArrayList<Map<String, Object>>(fi.getSize());
        if (mapList != null) {
            for (int i = 0; i < mapList.size(); ++i) {
                Map<String, Object> map = mapList.get(i);
                String[] auth = BusinessUtil.getAuthName(ParamUtil.getLong(map, (String)"menuId"));
                map.put("authName", auth[1]);
                map.put("authId", auth[0]);
                if (Strings.isEmpty((String)ParamUtil.getString(map, (String)"icon"))) {
                    map.put("icon", "vp-application");
                }
                returnDataList.add(map);
            }
        }
        fi.setData(returnDataList);
        return fi;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void updataMutiBusinessAuth(Map<String, Object> auths) throws Exception {
        Object mbmId;
        if (auths != null && (mbmId = auths.get("id")) != null) {
            Long mutiBusinessMenuId = Long.valueOf(String.valueOf(mbmId));
            CapMutiBusinessMenu mutiBusinessMenu = this.mutiBusinessMenuDAO.findMutiBusinessMenuById(mutiBusinessMenuId);
            mutiBusinessMenu.putExtraAttr("MUTI_MENU_AUTHA_VALUE", String.valueOf(auths.get("authId")));
            this.saveOrUpdateMutiBusinessMenu(mutiBusinessMenu);
            this.portalApi.clearPortalMenusCache();
        }
    }

    private void insertMenus(List<PrivMenuBO> list, V3xOrgRole orgRole, String auth, Long menuId) throws BusinessException {
        this.privilegeManager.insertMenus(list, orgRole, auth);
        this.privilegeManager.insertCustomizeMenus(auth, menuId);
    }

    public void setMutiBusinessMenuDAO(MutiBusinessMenuDAO mutiBusinessMenuDAO) {
        this.mutiBusinessMenuDAO = mutiBusinessMenuDAO;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setPrivilegeManager(PrivilegeManager privilegeManager) {
        this.privilegeManager = privilegeManager;
    }

    public void setPrivilegeMenuManager(PrivilegeMenuManager privilegeMenuManager) {
        this.privilegeMenuManager = privilegeMenuManager;
    }

    public void setAppLogManager(AppLogManager appLogManager) {
        this.appLogManager = appLogManager;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public void setOrgManagerDirect(OrgManagerDirect orgManagerDirect) {
        this.orgManagerDirect = orgManagerDirect;
    }

    public void setPortalApi(PortalApi portalApi) {
        this.portalApi = portalApi;
    }
}

