/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.mutibusinessmenu;

import com.seeyon.cap4.form.modules.component.FormCollectionAscSortComparator;
import com.seeyon.cap4.form.modules.mutibusinessmenu.MutiBusinessSourceTypeManager;
import com.seeyon.cap4.form.modules.mutibusinessmenu.MutiFormAppBO;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class MutiBusinessSourceTypeUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(MutiBusinessSourceTypeManager.class);
    private static OrgManager orgManager;
    private static TemplateManager templateManager;
    private static Map<String, MutiBusinessSourceTypeManager> sourceTypeMap;
    private static Map<String, MutiBusinessSourceTypeManager> sourceTypeMap4code;
    private static Map<String, MutiBusinessSourceTypeManager> sourceTypeMap4CanUse;
    private static Map<String, List<MutiBusinessSourceTypeManager>> subSourceTypeMap;

    private static void init() {
        if (!sourceTypeMap.isEmpty()) {
            return;
        }
        Map sourceTypes = AppContext.getBeansOfType(MutiBusinessSourceTypeManager.class);
        for (Map.Entry et : sourceTypes.entrySet()) {
            String[] codes;
            String baseId;
            sourceTypeMap.put(((MutiBusinessSourceTypeManager)et.getValue()).getId(), (MutiBusinessSourceTypeManager)et.getValue());
            if (((MutiBusinessSourceTypeManager)et.getValue()).canUse()) {
                sourceTypeMap4CanUse.put(((MutiBusinessSourceTypeManager)et.getValue()).getId(), (MutiBusinessSourceTypeManager)et.getValue());
            }
            if (!((MutiBusinessSourceTypeManager)et.getValue()).isBaseSourceType() && Strings.isNotBlank((String)(baseId = ((MutiBusinessSourceTypeManager)et.getValue()).getBaseSourceTypeId()))) {
                List<MutiBusinessSourceTypeManager> tempList = subSourceTypeMap.get(baseId);
                if (tempList == null) {
                    tempList = new ArrayList<MutiBusinessSourceTypeManager>();
                }
                tempList.add((MutiBusinessSourceTypeManager)et.getValue());
                subSourceTypeMap.put(baseId, tempList);
            }
            if (!Strings.isNotBlank((String)((MutiBusinessSourceTypeManager)et.getValue()).getSupportedTypeCode())) continue;
            for (String code : codes = ((MutiBusinessSourceTypeManager)et.getValue()).getSupportedTypeCode().split(",")) {
                sourceTypeMap4code.put(code, (MutiBusinessSourceTypeManager)et.getValue());
            }
        }
    }

    public static List<MutiBusinessSourceTypeManager> getSubSourceTypeByBaseTypeId(String baseTypeId) {
        return subSourceTypeMap.get(baseTypeId);
    }

    public static void getCategoryBO(Map<String, CtpTemplateCategory> catgMap, List<MutiFormAppBO> list, Map<String, CtpTemplateCategory> catgMapAll) throws BusinessException {
        HashMap<String, CtpTemplateCategory> tempMap = new HashMap<String, CtpTemplateCategory>();
        for (Map.Entry<String, CtpTemplateCategory> et : catgMap.entrySet()) {
            CtpTemplateCategory category = et.getValue();
            MutiFormAppBO bo = new MutiFormAppBO();
            if (category.getParentId() != null && (long)ModuleType.form.getKey() != category.getParentId() && (long)ModuleType.collaboration.getKey() != category.getParentId()) {
                CtpTemplateCategory parentCategory = templateManager.getCtpTemplateCategory(category.getParentId());
                if (parentCategory != null) {
                    if (!catgMapAll.containsKey(parentCategory.getName())) {
                        tempMap.put(parentCategory.getName(), parentCategory);
                    }
                    bo.setCategoryId(parentCategory.getName());
                } else {
                    bo.setCategoryId(ModuleType.form.getKey() + "");
                }
            } else {
                bo.setCategoryId(ModuleType.form.getKey() + "");
            }
            bo.setId(category.getName());
            bo.setName(ResourceUtil.getString((String)category.getName()));
            bo.setSourceType(Enums.SourceType.SOURCE_TYPE_PARENT.getKey());
            bo.setSourceValue(category.getId());
            list.add(0, bo);
        }
        if (!tempMap.isEmpty()) {
            catgMapAll.putAll(tempMap);
            MutiBusinessSourceTypeUtil.getCategoryBO(tempMap, list, catgMapAll);
        }
    }

    public static List<MutiBusinessSourceTypeManager> getCanUseSourceTypeList() {
        return MutiBusinessSourceTypeUtil.getCanUseSourceTypeList(true);
    }

    private static List<MutiBusinessSourceTypeManager> getCanUseSourceTypeList(boolean onlyBaseType) {
        ArrayList<MutiBusinessSourceTypeManager> list = new ArrayList<MutiBusinessSourceTypeManager>();
        for (Map.Entry<String, MutiBusinessSourceTypeManager> et : sourceTypeMap4CanUse.entrySet()) {
            if (onlyBaseType && !et.getValue().isBaseSourceType() || "secondMenuCatg".equals(et.getKey()) || "doc".equals(et.getKey()) || "infomation".equals(et.getKey())) continue;
            list.add(et.getValue());
        }
        Collections.sort(list, FormCollectionAscSortComparator.getInstance());
        return list;
    }

    public static MutiBusinessSourceTypeManager getSourceTypeById(String id) {
        return sourceTypeMap.get(id);
    }

    static {
        sourceTypeMap = new LinkedHashMap<String, MutiBusinessSourceTypeManager>();
        sourceTypeMap4code = new LinkedHashMap<String, MutiBusinessSourceTypeManager>();
        sourceTypeMap4CanUse = new LinkedHashMap<String, MutiBusinessSourceTypeManager>();
        subSourceTypeMap = new LinkedHashMap<String, List<MutiBusinessSourceTypeManager>>();
        orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
        MutiBusinessSourceTypeUtil.init();
    }
}

