/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.portal.section;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.DynamicFieldUtil;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bean.FormDataListParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.result.FormDataResult;
import com.seeyon.cap4.template.service.CAPFormDataListService;
import com.seeyon.cap4.template.vo.ListVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.portal.section.BaseSectionImpl;
import com.seeyon.ctp.portal.section.templete.BaseSectionTemplete;
import com.seeyon.ctp.portal.section.templete.mobile.MInfoCardStyleTemplete;
import com.seeyon.ctp.portal.section.templete.mobile.MInfoTemplete;
import com.seeyon.ctp.portal.section.templete.mobile.MTableTemplete;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAP4FormDataSectionImpl
extends BaseSectionImpl {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormDataSectionImpl.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private AttachmentManager attachmentManager;
    private EnumManager enumManagerNew;
    private CAPFormDataListService capFormDataListService;

    public String getId() {
        return "cap4FormDataSection";
    }

    public String getName(Map<String, String> preference) {
        String name = preference.get("columnsName");
        if (Strings.isBlank((String)name)) {
            return this.getBaseName(preference);
        }
        return name;
    }

    public String getBaseName(Map<String, String> preference) {
        FormBean formBean = this.getForm(preference);
        if (formBean == null) {
            return ResourceUtil.getString((String)"form.base.processOrUnflowForm");
        }
        if (formBean.getFormType() == Enums.FormType.unFlowForm.getKey()) {
            return ResourceUtil.getString((String)"form.base.formtype.unflowform");
        }
        if (formBean.getFormType() == Enums.FormType.processesForm.getKey()) {
            return ResourceUtil.getString((String)"form.base.formtype.processesform");
        }
        return null;
    }

    public Integer getTotal(Map<String, String> preference) {
        return null;
    }

    public String getIcon() {
        return null;
    }

    public boolean isAllowUsed() {
        return !AppContext.getCurrentUser().isGroupAdmin();
    }

    public boolean isAllowUserUsed(Map<String, String> preference) {
        return this.isAllowUserUsed(preference.get("designated_value"));
    }

    public boolean isAllowUserUsed(String singleBoardId) {
        FormBean formBean = this.getForm(singleBoardId);
        if (formBean == null) {
            return false;
        }
        String formTemplateId = singleBoardId.split("[|]")[1];
        try {
            if (this.cap4FormCacheManager.isEnabled(formBean)) {
                FormBindAuthBean bindAuthBean = formBean.getBind().getFormBindAuthBean(formTemplateId);
                if (bindAuthBean == null) {
                    FormFlowBusinessBean businessBean = formBean.getBind().getFlowBusinessById(Long.valueOf(formTemplateId));
                    return businessBean != null && businessBean.checkRight(AppContext.currentUserId());
                }
                return bindAuthBean.checkRight(AppContext.currentUserId());
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public String getResolveFunction(Map<String, String> preference) {
        String requestFrom = preference.get("requestFrom");
        String resolveFunction = "iframeTemplete";
        if (Strings.isNotBlank((String)requestFrom) && "mobile".equals(requestFrom)) {
            String style;
            String string = style = Strings.isBlank((String)preference.get("_style")) ? "listData" : preference.get("_style");
            resolveFunction = "pictureAndListData".equals(style) ? new MInfoTemplete().getResolveFunction() : ("listData".equals(style) ? new MTableTemplete().getResolveFunction() : new MInfoCardStyleTemplete().getResolveFunction());
        }
        return resolveFunction;
    }

    public BaseSectionTemplete projection(Map<String, String> preference) {
        return null;
    }

    private FormBean getForm(Map<String, String> preference) {
        return this.getForm(preference == null ? null : preference.get("designated_value"));
    }

    private FormBean getForm(String designatedValue) {
        if (Strings.isBlank((String)designatedValue)) {
            return null;
        }
        String[] formInfo = designatedValue.split("\\|");
        if (formInfo.length > 0 && !Strings.isDigits((String)formInfo[0])) {
            return null;
        }
        return this.cap4FormCacheManager.getForm(Long.valueOf(formInfo[0]));
    }

    public BaseSectionTemplete mProjection(Map<String, String> preference) {
        String designatedValue = preference.get("designated_value");
        Long formTemplateId = Long.valueOf(designatedValue.split("\\|")[1]);
        FormBean formBean = this.getForm(preference);
        if (formBean == null) {
            return null;
        }
        try {
            if (formBean.getFormType() == Enums.FormType.unFlowForm.getKey()) {
                return this.unFlowmProjection(formBean, formTemplateId, preference);
            }
            if (formBean.getFormType() == Enums.FormType.processesForm.getKey()) {
                return this.flowmProjection(formBean, formTemplateId, preference);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("mProjection preference" + preference), (Throwable)e);
        }
        return null;
    }

    private BaseSectionTemplete flowmProjection(FormBean formBean, Long formTemplateId, Map<String, String> preference) throws BusinessException {
        MInfoTemplete baseSectionTemplete;
        FormFlowBusinessBean businessBean = formBean.getBind().getFlowBusinessById(formTemplateId);
        if (businessBean == null || !businessBean.checkRight(AppContext.currentUserId())) {
            return null;
        }
        CAPBusinessEnum.DataListTypeEnum typeEnum = CAPBusinessEnum.DataListTypeEnum.getEnumByKey(businessBean.getType(), "alias");
        typeEnum = typeEnum == null ? CAPBusinessEnum.DataListTypeEnum.FLOW_TO_DO : typeEnum;
        String style = Strings.isBlank((String)preference.get("_style")) ? "listData" : preference.get("_style");
        int count = preference.get("count") == null ? 3 : Integer.valueOf(preference.get("count"));
        HashMap<String, String> moreLinkParams = new HashMap<String, String>(3);
        moreLinkParams.put("formId", String.valueOf(formBean.getId()));
        moreLinkParams.put("appId", String.valueOf(formTemplateId));
        moreLinkParams.put("title", businessBean.getName());
        String moreLink = "/seeyon/m3/apps/v5/cap4" + typeEnum.getM3path() + "/htmls/" + typeEnum.getM3path() + "/0/dist/index.html";
        String moreLinkParam = JSONUtil.toJSONString(moreLinkParams);
        List<SimpleObjectBean> showFields = this.getShowFields(businessBean.getShowFieldList(), preference);
        FormDataListParamBean paramBean = new FormDataListParamBean();
        paramBean.setFormId(formBean.getId());
        paramBean.setFormTemplateId(formTemplateId);
        paramBean.setQueryType(typeEnum.getValue());
        paramBean.setClient(String.valueOf(CAPBusinessEnum.Platform.MOBILE.getType()));
        paramBean.setCustomShowFields(showFields);
        paramBean.setPage(1);
        paramBean.setPageSize(count);
        FormDataResult<? extends ListVO> formDataResult = this.capFormDataListService.getList(paramBean);
        if (!formDataResult.isSuccessResult()) {
            throw new BusinessException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff01" + formDataResult.getMessage());
        }
        List<Map<String, Object>> listData = ((ListVO)formDataResult.getData()).getDatas();
        String imgFieldName = this.getImageFieldName(formBean, showFields);
        if ("pictureAndListData".equals(style) || "listData2".equals(style)) {
            MInfoTemplete mInfoTemplete = this.invokeImgDataList(formBean, businessBean, showFields, listData, imgFieldName);
            mInfoTemplete.setMoreLink(moreLink);
            mInfoTemplete.setMoreLinkParam(moreLinkParam);
            baseSectionTemplete = mInfoTemplete;
        } else if ("listData".equals(style)) {
            MTableTemplete t = this.invokeTableDataList(formBean, businessBean, showFields, listData, imgFieldName);
            t.setMoreLink(moreLink);
            t.setMoreLinkParam(moreLinkParam);
            baseSectionTemplete = t;
        } else {
            MInfoCardStyleTemplete t = this.invokeCardDataList(formBean, businessBean, showFields, listData, imgFieldName);
            t.setMoreLink(moreLink);
            t.setMoreLinkParam(moreLinkParam);
            baseSectionTemplete = t;
        }
        return baseSectionTemplete;
    }

    private MInfoCardStyleTemplete invokeCardDataList(FormBean formBean, FormFlowBusinessBean businessBean, List<SimpleObjectBean> showFields, List<Map<String, Object>> listData, String imgFieldName) {
        MInfoCardStyleTemplete t = new MInfoCardStyleTemplete();
        ArrayList<String> resultListParam = new ArrayList<String>();
        Iterator<SimpleObjectBean> iterator = showFields.iterator();
        while (iterator.hasNext()) {
            SimpleObjectBean sob = iterator.next();
            FormFieldBean formFieldBean = this.findFormFieldBean(formBean, sob.getName());
            if (formFieldBean == null || !FormFieldComEnum.EXTEND_IMAGE.getKey().equals(formFieldBean.getInputType()) || imgFieldName.equals(formFieldBean.getName())) continue;
            iterator.remove();
        }
        ArrayList resultDataList = new ArrayList();
        for (Map<String, Object> lineValues : listData) {
            ArrayList<String> formDataList = new ArrayList<String>();
            formDataList.add(this.getFlowUrl());
            resultListParam.add(this.getFlowParams(businessBean, lineValues));
            String id = lineValues.get("id").toString();
            MInfoCardStyleTemplete.UnWorkflowList flowList = t.addUnWorkflowList(id);
            int i = 0;
            for (SimpleObjectBean one : showFields) {
                if (i > 3) break;
                String key = one.getName().contains(".") ? one.getName().split("[.]")[1] : one.getName();
                MInfoCardStyleTemplete.FieldList fieldList = flowList.addFieldList();
                if (lineValues.get(key) != null) {
                    fieldList.setDisplayName(one.getValue());
                    FormFieldBean formFieldBean = this.findFormFieldBean(formBean, one.getName());
                    if (formFieldBean != null && formFieldBean.isImageEnumField()) {
                        fieldList.setDisplayNameValue(this.getFieldValue(lineValues.get(key), "showValue"));
                    } else {
                        fieldList.setDisplayNameValue(this.getFieldValue(lineValues.get(key), "value"));
                    }
                } else {
                    fieldList.setDisplayNameValue("");
                }
                ++i;
            }
            flowList.setImgUrl("/common/form/common/css/img/none.png");
            Object obj = lineValues.get(imgFieldName);
            if (obj != null && obj instanceof Map) {
                List images;
                Map map = (Map)obj;
                List list = images = map.get("value") != null ? (List)map.get("value") : null;
                if (CollectionUtils.isNotEmpty((Collection)images)) {
                    String url = "/commonimage.do?method=showImage&id=" + String.valueOf(((Map)images.get(0)).get("fileUrl")) + "&size=custom&w=90&h=90";
                    flowList.setImgUrl(url);
                }
            }
            resultDataList.add(formDataList);
        }
        t.setDataNum(resultDataList.size());
        t.setDataList(resultDataList);
        t.setResultListParam(resultListParam);
        return t;
    }

    private MTableTemplete invokeTableDataList(FormBean formBean, FormFlowBusinessBean businessBean, List<SimpleObjectBean> showFields, List<Map<String, Object>> listData, String imgFieldName) {
        MTableTemplete mTableTemplete = new MTableTemplete();
        Iterator<SimpleObjectBean> iterator = showFields.iterator();
        while (iterator.hasNext()) {
            SimpleObjectBean sob = iterator.next();
            FormFieldBean formFieldBean = this.findFormFieldBean(formBean, sob.getName());
            if (formFieldBean == null || !FormFieldComEnum.EXTEND_IMAGE.getKey().equals(formFieldBean.getInputType())) continue;
            iterator.remove();
        }
        for (SimpleObjectBean one : showFields) {
            MTableTemplete.TableHead tableHead = mTableTemplete.addTableHead();
            tableHead.setTitle(one.getValue());
        }
        mTableTemplete.setResultSize(showFields.size());
        ArrayList<String> resultListParam = new ArrayList<String>();
        ArrayList<ArrayList<String>> resultDataList = new ArrayList<ArrayList<String>>();
        for (Map<String, Object> lineValues : listData) {
            ArrayList<String> formDataList = new ArrayList<String>();
            formDataList.add(this.getFlowUrl());
            resultListParam.add(this.getFlowParams(businessBean, lineValues));
            this.setFieldData(formBean, showFields, lineValues, formDataList);
            resultDataList.add(formDataList);
        }
        mTableTemplete.setDataNum(resultDataList.size());
        mTableTemplete.setResult(resultDataList);
        mTableTemplete.setResultListParam(resultListParam);
        return mTableTemplete;
    }

    private void setFieldData(FormBean formBean, List<SimpleObjectBean> showFields, Map<String, Object> lineValues, List<String> formDataList) {
        for (SimpleObjectBean one : showFields) {
            String key = one.getName().contains(".") ? one.getName().split("[.]")[1] : one.getName();
            FormFieldBean fieldBean = this.findFormFieldBean(formBean, key);
            if (fieldBean != null && fieldBean.isImageEnumField()) {
                formDataList.add(this.getFieldValue(lineValues.get(key), "showValue"));
                continue;
            }
            formDataList.add(this.getFieldValue(lineValues.get(key), "value"));
        }
    }

    private String getFieldValue(Object value, String mapValueKey) {
        String result = "";
        if (value != null) {
            Map valueMap;
            result = value instanceof Map ? ((valueMap = (Map)value).get(mapValueKey) == null ? "" : String.valueOf(valueMap.get(mapValueKey))) : value.toString();
        }
        return result;
    }

    private MInfoTemplete invokeImgDataList(FormBean formBean, FormFlowBusinessBean businessBean, List<SimpleObjectBean> showFields, List<Map<String, Object>> listData, String imgFiledName) {
        MInfoTemplete t = new MInfoTemplete();
        t.setSubject(formBean.getFormName());
        Iterator<SimpleObjectBean> iterator = showFields.iterator();
        while (iterator.hasNext()) {
            SimpleObjectBean sob = iterator.next();
            FormFieldBean formFieldBean = this.findFormFieldBean(formBean, sob.getName());
            if (formFieldBean == null || !FormFieldComEnum.EXTEND_IMAGE.getKey().equals(formFieldBean.getInputType())) continue;
            iterator.remove();
        }
        for (int i = 0; i < showFields.size() && i <= 4; ++i) {
            MInfoTemplete.Field field = t.addField();
            field.setName(showFields.get(i).getName());
            field.setValue(showFields.get(i).getValue());
        }
        ArrayList<String> resultListParam = new ArrayList<String>();
        ArrayList<ArrayList<String>> resultDataList = new ArrayList<ArrayList<String>>();
        for (Map<String, Object> lineValues : listData) {
            MInfoTemplete.Field imgField = t.addImgField();
            imgField.setValue("/common/form/common/css/img/none.png");
            Object obj = lineValues.get(imgFiledName);
            if (obj != null && obj instanceof Map) {
                List atts;
                Map map = (Map)obj;
                List list = atts = map.get("value") != null ? (List)map.get("value") : null;
                if (CollectionUtils.isNotEmpty((Collection)atts)) {
                    imgField.setValue("/commonimage.do?method=showImage&id=" + String.valueOf(((Map)atts.get(0)).get("fileUrl")) + "&size=custom&w=90&h=90");
                }
            }
            ArrayList<String> formDataList = new ArrayList<String>();
            formDataList.add(this.getFlowUrl());
            resultListParam.add(this.getFlowParams(businessBean, lineValues));
            this.setFieldData(formBean, showFields, lineValues, formDataList);
            resultDataList.add(formDataList);
        }
        t.setDataNum(resultDataList.size());
        t.setDataList(resultDataList);
        t.setResultListParam(resultListParam);
        return t;
    }

    private String getFlowUrl() {
        return SystemEnvironment.getContextPath() + "/m3/apps/v5/collaboration/html/details/summary.html";
    }

    private String getFlowParams(FormFlowBusinessBean businessBean, Map<String, Object> lineValues) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formType", "main");
        map.put("type", "browse");
        map.put("title", businessBean.getName());
        map.put("affairId", ((Map)lineValues.get("fixedField")).get("affairId").toString());
        map.put("summaryId", ((Map)lineValues.get("fixedField")).get("summaryId").toString());
        return JSONUtil.toJSONString(map);
    }

    private String getImageFieldName(FormBean formBean, List<SimpleObjectBean> showFields) {
        String imgFiledName = "";
        for (SimpleObjectBean one : showFields) {
            FormFieldBean formFieldBean;
            if (Strings.isBlank((String)one.getName()) || (formFieldBean = this.findFormFieldBean(formBean, one.getName())) == null) continue;
            boolean showImg = formFieldBean.isAttachment();
            boolean isMasterField = formFieldBean.isMasterField();
            if (!showImg || !isMasterField) continue;
            imgFiledName = one.getName().split("\\.")[1];
            break;
        }
        return imgFiledName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Deprecated
    private BaseSectionTemplete unFlowmProjection(FormBean formBean, Long formTemplateId, Map<String, String> preference) {
        String style = Strings.isBlank((String)preference.get("_style")) ? "listData" : preference.get("_style");
        int count = preference.get("count") == null ? 3 : Integer.valueOf(preference.get("count"));
        Long formId = formBean.getId();
        FormBindAuthBean bindAuthBean = formBean.getBind().getFormBindAuthBean(String.valueOf(formTemplateId));
        String moreLink = "/seeyon/m3/apps/v5/cap4unflow/htmls/unflow/0/dist/index.html";
        String moreLinkParam = "{\"formId\":\"" + formId + "\",\"appId\":\"" + formTemplateId + "\",\"title\":\"" + bindAuthBean.getName() + "\"}";
        SimpleObjectBean browseObj = bindAuthBean.getAuthObjByName("browse");
        String rightId = "";
        if (browseObj != null) {
            rightId = rightId + (browseObj.getPhoneValue().contains("|") ? browseObj.getPhoneValue().replaceAll("[|]", "_") : browseObj.getPhoneValue());
            if (Strings.isNotBlank((String)browseObj.getValue())) {
                if (Strings.isNotBlank((String)rightId)) {
                    rightId = rightId.endsWith("_") ? rightId : rightId + "_";
                }
                if ((rightId = rightId + (browseObj.getValue().contains("|") ? browseObj.getValue().replaceAll("[|]", "_") : browseObj.getValue())).endsWith("_")) {
                    rightId = rightId.substring(0, rightId.length() - 1);
                }
            }
        }
        try {
            if (bindAuthBean == null || !bindAuthBean.checkRight(AppContext.currentUserId())) {
                return null;
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"\u68c0\u67e5\u5bf9\u5e94\u7528\u6237\u662f\u5426\u6709\u6b64\u5e94\u7528\u7ed1\u5b9a\u7684\u4f7f\u7528\u6743\u9650\u5f02\u5e38", (Throwable)e);
        }
        List<SimpleObjectBean> showFields = this.getShowFields(bindAuthBean.getShowFieldList(), preference);
        String imgFiledName = this.getImageFieldName(formBean, showFields);
        AppContext.putThreadContext((String)"isMobile", (Object)"true");
        FlipInfo flipInfo = new FlipInfo(1, count);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formId", formId);
        params.put("formTemplateId", formTemplateId);
        params.put("sortStr", DynamicFieldUtil.getSortStr(bindAuthBean.getOrderByList()));
        if (Strings.isNotBlank((String)imgFiledName)) {
            HashSet<String> imgFieldNameSet = new HashSet<String>();
            imgFieldNameSet.add(imgFiledName);
            params.put("customShowFields", imgFieldNameSet);
        }
        try {
            flipInfo = this.cap4FormManager.getFormMasterDataListByFormId(flipInfo, params);
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u65e0\u6d41\u7a0b\u6570\u636e\u67e5\u8be2\u62a5\u9519\uff1a" + e.getMessage()), (Throwable)e);
        }
        finally {
            AppContext.removeThreadContext((String)"isMobile");
        }
        List formDataListAll = flipInfo.getData();
        ArrayList listDatas = new ArrayList();
        if ("pictureAndListData".equals(style) || "listData2".equals(style)) {
            MInfoTemplete t = new MInfoTemplete();
            Iterator<SimpleObjectBean> s = showFields.iterator();
            while (s.hasNext()) {
                boolean showImg;
                SimpleObjectBean simpleObjectBean = s.next();
                FormFieldBean formFieldBean = this.findFormFieldBean(formBean, simpleObjectBean.getName());
                if (formFieldBean == null || !(showImg = formFieldBean.isAttachment())) continue;
                s.remove();
            }
            t.setSubject(formBean.getFormName());
            ArrayList<String> resultListParam = new ArrayList<String>();
            boolean bl = false;
            for (SimpleObjectBean one : showFields) {
                void var20_29;
                if (var20_29 > 4) break;
                MInfoTemplete.Field field = t.addField();
                field.setName(one.getName());
                field.setValue(one.getValue());
                ++var20_29;
            }
            for (Map lineValues : formDataListAll) {
                List atts;
                Long id = Long.valueOf(lineValues.get("id").toString());
                String value = (String)lineValues.get(imgFiledName);
                MInfoTemplete.Field imgField = t.addImgField();
                imgField.setValue("/common/form/common/css/img/none.png");
                if (Strings.isNotBlank((String)value) && id != 0L && (atts = this.attachmentManager.getByReference(id, Long.valueOf(value))) != null && !atts.isEmpty()) {
                    Attachment att = (Attachment)atts.get(0);
                    imgField.setValue("/commonimage.do?method=showImage&id=" + String.valueOf(att.getFileUrl()) + "&size=custom&w=90&h=90");
                    lineValues.remove(imgFiledName);
                }
                ArrayList<String> formDataList = new ArrayList<String>();
                String rowLink = "/seeyon/m3/apps/v5/cap4/htmls/native/form/index.html";
                formDataList.add(rowLink);
                String rowsData = "{\"formType\":\"main\",\"type\":\"browse\",\"title\":\"" + bindAuthBean.getName() + "\",\"params\":{\"rightId\":\"" + rightId + "\",\"moduleId\":\"" + lineValues.get("id") + "\",\"moduleType\":\"42\",\"operateType\": \"2\",\"formTemplateId\":\"" + formTemplateId + "\"}}";
                resultListParam.add(rowsData);
                for (SimpleObjectBean one : showFields) {
                    FormFieldBean formFieldBean;
                    String key = one.getName();
                    String[] s2 = one.getName().split("\\.");
                    if (s2.length > 1) {
                        key = s2[1];
                    }
                    if ((formFieldBean = this.findFormFieldBean(formBean, one.getName())) == null) continue;
                    if (lineValues.get(key) != null) {
                        String formData = String.valueOf(lineValues.get(key));
                        if (Strings.isNotEmpty((String)formData)) {
                            if (formFieldBean.isEnumField() && Strings.isDigits((String)formData) && (formFieldBean.getInputType().equals(FormFieldComEnum.IMAGE_RADIO.getKey()) || formFieldBean.getInputType().equals(FormFieldComEnum.IMAGE_SELECT.getKey()))) {
                                String enumName = "";
                                try {
                                    enumName = this.enumManagerNew.getEItemNameById(Long.valueOf(Long.parseLong(formData)));
                                }
                                catch (Exception e) {
                                    LOGGER.error((Object)"", (Throwable)e);
                                }
                                formDataList.add(enumName);
                                continue;
                            }
                            formDataList.add(formData);
                            continue;
                        }
                        formDataList.add("");
                        continue;
                    }
                    formDataList.add("");
                }
                listDatas.add(formDataList);
            }
            t.setDataNum(listDatas.size());
            t.setDataList(listDatas);
            t.setMoreLink(moreLink);
            t.setMoreLinkParam(moreLinkParam);
            t.setResultListParam(resultListParam);
            return t;
        }
        if ("listData".equals(style)) {
            MTableTemplete t = new MTableTemplete();
            Iterator<SimpleObjectBean> s = showFields.iterator();
            while (s.hasNext()) {
                boolean showImg;
                SimpleObjectBean simpleObjectBean = s.next();
                FormFieldBean formFieldBean = this.findFormFieldBean(formBean, simpleObjectBean.getName());
                if (formFieldBean == null || !(showImg = formFieldBean.isAttachment())) continue;
                s.remove();
            }
            for (SimpleObjectBean simpleObjectBean : showFields) {
                MTableTemplete.TableHead tableHead = t.addTableHead();
                tableHead.setTitle(simpleObjectBean.getValue());
            }
            t.setResultSize(showFields.size());
            ArrayList<String> resultListParam = new ArrayList<String>();
            for (Map lineValues : formDataListAll) {
                ArrayList<String> formDataList = new ArrayList<String>();
                String rowLink = "/seeyon/m3/apps/v5/cap4/htmls/native/form/index.html";
                formDataList.add(rowLink);
                String rowsData = "{\"formType\":\"main\",\"type\":\"browse\",\"title\":\"" + bindAuthBean.getName() + "\",\"params\":{\"rightId\":\"" + rightId + "\",\"moduleId\":\"" + lineValues.get("id") + "\",\"moduleType\":\"42\",\"operateType\": \"2\",\"formTemplateId\":\"" + formTemplateId + "\"}}";
                resultListParam.add(rowsData);
                for (SimpleObjectBean one : showFields) {
                    FormFieldBean formFieldBean;
                    String key = one.getName();
                    String[] s3 = one.getName().split("\\.");
                    if (s3.length > 1) {
                        key = s3[1];
                    }
                    if ((formFieldBean = this.findFormFieldBean(formBean, one.getName())) == null) continue;
                    if (lineValues.get(key) != null) {
                        String formData = String.valueOf(lineValues.get(key));
                        if (Strings.isNotEmpty((String)formData)) {
                            if (formFieldBean.isEnumField() && Strings.isDigits((String)formData) && (formFieldBean.getInputType().equals(FormFieldComEnum.IMAGE_RADIO.getKey()) || formFieldBean.getInputType().equals(FormFieldComEnum.IMAGE_SELECT.getKey()))) {
                                String enumName = "";
                                try {
                                    enumName = this.enumManagerNew.getEItemNameById(Long.valueOf(Long.parseLong(formData)));
                                }
                                catch (Exception e) {
                                    LOGGER.error((Object)"", (Throwable)e);
                                }
                                formDataList.add(enumName);
                                continue;
                            }
                            formDataList.add(formData);
                            continue;
                        }
                        formDataList.add("");
                        continue;
                    }
                    formDataList.add("");
                }
                listDatas.add(formDataList);
            }
            t.setDataNum(listDatas.size());
            t.setResult(listDatas);
            t.setMoreLink(moreLink);
            t.setMoreLinkParam(moreLinkParam);
            t.setResultListParam(resultListParam);
            return t;
        }
        MInfoCardStyleTemplete t = new MInfoCardStyleTemplete();
        ArrayList<String> resultListParam = new ArrayList<String>();
        Iterator<SimpleObjectBean> iterator = showFields.iterator();
        while (iterator.hasNext()) {
            SimpleObjectBean sob = iterator.next();
            FormFieldBean formFieldBean = this.findFormFieldBean(formBean, sob.getName());
            if (formFieldBean == null) continue;
            boolean showImg = formFieldBean.isAttachment();
            String key = sob.getName();
            String[] str = sob.getName().split("\\.");
            if (str.length > 1) {
                key = str[1];
            }
            if (!showImg || imgFiledName.equals(key)) continue;
            iterator.remove();
        }
        for (Map lineValues : formDataListAll) {
            List atts;
            ArrayList<String> formDataList = new ArrayList<String>();
            String rowLink = "/seeyon/m3/apps/v5/cap4/htmls/native/form/index.html";
            formDataList.add(rowLink);
            String rowsData = "{\"formType\":\"main\",\"type\":\"browse\",\"title\":\"" + bindAuthBean.getName() + "\",\"params\":{\"rightId\":\"" + rightId + "\",\"moduleId\":\"" + lineValues.get("id") + "\",\"moduleType\":\"42\",\"operateType\": \"2\",\"formTemplateId\":\"" + formTemplateId + "\"}}";
            resultListParam.add(rowsData);
            String id = lineValues.get("id").toString();
            MInfoCardStyleTemplete.UnWorkflowList unflowList = t.addUnWorkflowList(id);
            int i = 0;
            for (SimpleObjectBean one : showFields) {
                FormFieldBean formFieldBean;
                if (i > 3) break;
                String key = one.getName();
                String[] s4 = one.getName().split("\\.");
                if (s4.length > 1) {
                    key = s4[1];
                }
                if ((formFieldBean = this.findFormFieldBean(formBean, one.getName())) == null) continue;
                MInfoCardStyleTemplete.FieldList fieldList = unflowList.addFieldList();
                if (lineValues.get(key) != null) {
                    String formfieldValue = lineValues.get(key).toString();
                    fieldList.setDisplayName(one.getValue());
                    if (Strings.isBlank((String)formfieldValue)) {
                        formfieldValue = "";
                        fieldList.setDisplayNameValue(formfieldValue);
                    } else if (formFieldBean.isEnumField() && Strings.isDigits((String)formfieldValue) && (formFieldBean.getInputType().equals(FormFieldComEnum.IMAGE_RADIO.getKey()) || formFieldBean.getInputType().equals(FormFieldComEnum.IMAGE_SELECT.getKey()))) {
                        String enumName = "";
                        try {
                            enumName = this.enumManagerNew.getEItemNameById(Long.valueOf(Long.parseLong(formfieldValue)));
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)"", (Throwable)e);
                        }
                        fieldList.setDisplayNameValue(enumName);
                    } else {
                        fieldList.setDisplayNameValue(formfieldValue);
                    }
                } else {
                    fieldList.setDisplayNameValue("");
                }
                ++i;
            }
            listDatas.add(formDataList);
            unflowList.setImgUrl("/common/form/common/css/img/none.png");
            String value = (String)lineValues.get(imgFiledName);
            if (!Strings.isNotBlank((String)value) || (atts = this.attachmentManager.getByReference(Long.valueOf(Long.parseLong(id)), Long.valueOf(value))) == null || atts.isEmpty()) continue;
            Attachment att = (Attachment)atts.get(0);
            String url = "/commonimage.do?method=showImage&id=" + String.valueOf(att.getFileUrl()) + "&size=custom&w=90&h=90";
            unflowList.setImgUrl(url);
        }
        t.setDataNum(listDatas.size());
        t.setDataList(listDatas);
        t.setMoreLink(moreLink);
        t.setMoreLinkParam(moreLinkParam);
        t.setResultListParam(resultListParam);
        return t;
    }

    private List<SimpleObjectBean> getShowFields(List<SimpleObjectBean> showFields, Map<String, String> preference) {
        ArrayList<SimpleObjectBean> finalShowList = new ArrayList<SimpleObjectBean>();
        for (SimpleObjectBean o : showFields) {
            if (o.getValue().contains("(") || o.getName().contains("_")) {
                try {
                    SimpleObjectBean newBean = (SimpleObjectBean)o.clone();
                    if (o.getValue().contains("(")) {
                        String display = o.getValue().substring(o.getValue().indexOf("(") + 1, o.getValue().indexOf(")"));
                        newBean.setValue(display);
                    }
                    finalShowList.add(newBean);
                }
                catch (CloneNotSupportedException e) {
                    LOGGER.info((Object)("\u514b\u9686\u51fa\u73b0\u5f02\u5e38." + e));
                }
                continue;
            }
            finalShowList.add(o);
        }
        Map fieldMap = null;
        if (preference.get("source_value") != null) {
            fieldMap = (Map)JSONUtil.parseJSONString((String)preference.get("source_value"), Map.class);
        }
        ArrayList<SimpleObjectBean> beans = null;
        if (fieldMap != null) {
            String[] fieldNameArray;
            beans = new ArrayList<SimpleObjectBean>();
            for (String fieldName : fieldNameArray = ((String)fieldMap.get("showFieldNameList")).split(",")) {
                for (SimpleObjectBean one : finalShowList) {
                    if (!one.getName().equals(fieldName)) continue;
                    beans.add(one);
                }
            }
        }
        return CollectionUtils.isEmpty(beans) ? finalShowList : beans;
    }

    private FormFieldBean findFormFieldBean(FormBean formBean, String fieldName) {
        if (fieldName.contains(".")) {
            fieldName = fieldName.substring(fieldName.indexOf(".") + 1);
        }
        return formBean.getFieldBeanByName(fieldName, true);
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public void setCapFormDataListService(CAPFormDataListService capFormDataListService) {
        this.capFormDataListService = capFormDataListService;
    }
}

