/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.serialNumber;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.serialNumber.CAP4SerialNumberManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.lock.manager.LockManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.lock.Lock;
import com.seeyon.ctp.form.bean.FormSerialNumberBean;
import com.seeyon.ctp.form.modules.engin.base.serialNumber.SerialNumberDAO;
import com.seeyon.ctp.form.modules.serialNumber.SerialCalRecordManager;
import com.seeyon.ctp.form.modules.serialNumber.SerialNumberManager;
import com.seeyon.ctp.form.po.FormOwner;
import com.seeyon.ctp.form.po.FormSerialCalculateRecord;
import com.seeyon.ctp.form.po.FormSerialNumber;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.StoredProcedureCaller;
import com.seeyon.ctp.util.StringUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;

public class CAP4SerialNumberManagerImpl
implements CAP4SerialNumberManager {
    private static final Log logger = CtpLogFactory.getLog(CAP4SerialNumberManagerImpl.class);
    public static final String PRESTIRNG = "0000000000";
    private SerialNumberDAO serialNumberDAO;
    private CAP4FormManager cap4FormManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormCacheManager formCacheManager;
    private LockManager lockManager;
    private CAPFormManager capFormManager;

    public void setCapFormManager(CAPFormManager capFormManager) {
        this.capFormManager = capFormManager;
    }

    @Override
    public String getSerialNumberIds4Formula(String formula) throws BusinessException {
        if (StringUtil.checkNull((String)formula)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Matcher m = FormFieldUtil.serialNumberPattern.matcher(formula);
        SerialNumberManager serialNumberManager = (SerialNumberManager)AppContext.getBean((String)"serialNumberManager");
        while (m.find()) {
            FormSerialNumberBean serialBean;
            String group = m.group();
            group = group.replace("\"", "'");
            String serialName = "";
            String[] arrayStr = group.split("'");
            if (arrayStr.length > 2) {
                serialName = arrayStr[1];
            }
            if ("".equals(serialName) || null == (serialBean = serialNumberManager.querySerialNumberByName(serialName)) || sb.toString().contains(String.valueOf(serialBean.getId()))) continue;
            sb.append(String.valueOf(serialBean.getId()));
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public Set<Long> getSerialNumber4FormBean(FormBean formBean) throws BusinessException {
        HashSet<Long> serialId = new HashSet<Long>();
        for (FormAuthViewBean view : formBean.getAllFormAuthViewBeans()) {
            for (FormAuthViewFieldBean field : view.getFormAuthorizationFieldList()) {
                Long sId = field.getSerialNumberId();
                if (sId == null) continue;
                serialId.add(sId);
            }
        }
        for (FormFieldBean ffb : formBean.getAllFieldBeans()) {
            if (null == ffb.getFormulaData() || "".equals(ffb.getFormulaData())) continue;
            String serialIds = this.getSerialNumberIds4Formula(ffb.getFormulaData());
            String[] arrayIds = serialIds.split(",");
            for (int i = 0; i < arrayIds.length; ++i) {
                if ("".equals(arrayIds[i])) continue;
                serialId.add(Long.parseLong(arrayIds[i]));
            }
        }
        return serialId;
    }

    @Override
    public String getSerialCalValue(String serialName, String fieldName, Long dataId, Long formId, Long subId) throws Exception {
        String needProduceValue;
        FormSerialNumberBean serialNumberBean = this.querySerialNumberByFormInSys(serialName, formId);
        long serialId = serialNumberBean == null ? 0L : serialNumberBean.getId();
        FormDataMasterBean dataBean = this.cap4FormManager.getSessioMasterDataBean(dataId);
        List serialRecordList = null;
        if (dataBean == null) {
            logger.info((Object)("\u751f\u6210\u6d41\u6c34\u53f7\u7684\u65f6\u5019\u8868\u5355\u6570\u636e\u5728session\u4e2d\u627e\u4e0d\u5230\uff0c\u8868\u5355id\uff1a" + formId + " \u6570\u636eid\uff1a" + dataId + ",\u5728\u6570\u636e\u5e93\u4e2d\u627e\u3002"));
            dataBean = this.cap4FormManager.getDataMasterBeanById(dataId, this.cap4FormManager.getForm(formId, false), null);
            SerialCalRecordManager serialCalRecordManager = (SerialCalRecordManager)AppContext.getBean((String)"serialCalRecordManager");
            serialRecordList = serialCalRecordManager.selectAllByFormData(formId, dataId);
        } else {
            serialRecordList = (List)dataBean.getExtraAttr("serialCalRecords");
        }
        if (dataBean == null) {
            logger.info((Object)("\u751f\u6210\u6d41\u6c34\u53f7\u7684\u65f6\u5019\u8868\u5355\u7f13\u5b58\u6570\u636e\u627e\u4e0d\u5230\uff0c\u8868\u5355id\uff1a" + formId + " \u6570\u636eid\uff1a" + dataId));
            return "";
        }
        FormSerialCalculateRecord serialCalRecord = null;
        if (serialRecordList != null) {
            serialCalRecord = this.getSerialRecordFromCache(fieldName, serialId, serialRecordList, subId);
        }
        if (serialCalRecord != null && serialCalRecord.getValue() != null && !"".equals(serialCalRecord.getValue())) {
            return serialCalRecord.getValue();
        }
        String currentValue = "";
        String string = needProduceValue = dataBean.getExtraAttr("needProduceValue") == null ? "" : dataBean.getExtraAttr("needProduceValue").toString();
        if ("true".equals(needProduceValue)) {
            currentValue = this.getSerialNumberValue(serialId);
            if (serialCalRecord != null) {
                serialCalRecord.setValue(currentValue);
            } else {
                List<FormSerialCalculateRecord> resultList = this.mergerFormSerialCache(fieldName, dataId, serialId, formId, currentValue, serialRecordList, subId);
                dataBean.putExtraAttr("serialCalRecords", resultList);
            }
        } else if (serialCalRecord == null) {
            List<FormSerialCalculateRecord> resultList = this.mergerFormSerialCache(fieldName, dataId, serialId, formId, currentValue, serialRecordList, subId);
            dataBean.putExtraAttr("serialCalRecords", resultList);
        }
        return currentValue;
    }

    @Override
    public FormSerialNumberBean querySerialNumberByFormInSys(String name, Long formId) throws BusinessException {
        if (name == null || "".equals(name)) {
            return null;
        }
        FormOwner formOwner = this.cap4FormCacheManager.getFormOwner(formId);
        if (formOwner == null) {
            return null;
        }
        FormSerialNumberBean returnValue = null;
        List serialList = this.formCacheManager.getSerialNumberList();
        name = name.trim();
        if (null != serialList) {
            for (FormSerialNumberBean fsnb : serialList) {
                if (!name.equals(fsnb.getVariableName()) || fsnb.getAccountId() != formOwner.getOrgAccountId().longValue()) continue;
                returnValue = fsnb;
                break;
            }
        }
        return returnValue;
    }

    private List<FormSerialCalculateRecord> mergerFormSerialCache(String fieldName, Long dataId, long serialId, Long formId, String serialValue, List<FormSerialCalculateRecord> list, Long subId) {
        if (list == null) {
            list = new ArrayList<FormSerialCalculateRecord>();
        }
        FormSerialCalculateRecord serialCalRecord = new FormSerialCalculateRecord();
        serialCalRecord.setIdIfNew();
        serialCalRecord.setFormId(formId);
        serialCalRecord.setFieldName(fieldName);
        serialCalRecord.setSerialId(Long.valueOf(serialId));
        serialCalRecord.setValue(serialValue);
        serialCalRecord.setCreateDate(new java.util.Date());
        serialCalRecord.setFormDataId(dataId);
        serialCalRecord.setFormSubId(Long.valueOf(subId == null ? 0L : subId));
        list.add(serialCalRecord);
        return list;
    }

    private FormSerialCalculateRecord getSerialRecordFromCache(String fieldName, long serialId, List<FormSerialCalculateRecord> serialRecordList, Long subId) {
        FormSerialCalculateRecord serialCalRecord = null;
        for (FormSerialCalculateRecord serialRecord : serialRecordList) {
            if (serialRecord == null || serialRecord.getSerialId() == null || !fieldName.equals(serialRecord.getFieldName()) || serialId != serialRecord.getSerialId() || subId != null && serialRecord.getFormSubId() != null && subId.longValue() != serialRecord.getFormSubId().longValue()) continue;
            serialCalRecord = serialRecord;
            break;
        }
        return serialCalRecord;
    }

    @Override
    public String getSerialNumberValue(long id) throws BusinessException {
        FormSerialNumberBean fsnb = this.formCacheManager.getSerialNumber(id);
        if (fsnb != null) {
            boolean isUseProc = this.capFormManager.isUseProc();
            String currentValue = isUseProc ? String.valueOf(this.getCurrenValue(id, false)) : String.valueOf(this.getCurrenValueByCache(id, false));
            return this.combSerialValue(currentValue, fsnb);
        }
        logger.info((Object)("\u6d41\u6c34\u53f7\u5728\u7f13\u5b58\u4e2d\u83b7\u53d6\u4e0d\u5230\uff0cid" + id));
        return "";
    }

    @Override
    public void resetSerialNumber(FormBean fb) throws BusinessException {
        if (fb != null) {
            Set<Long> serialIdList = this.getSerialNumber4FormBean(fb);
            for (Long serialId : serialIdList) {
                FormSerialNumberBean serialBean = this.formCacheManager.getSerialNumber(serialId.longValue());
                if (serialBean.getMinValue() != null) {
                    serialBean.setValue(serialBean.getMinValue().longValue());
                } else {
                    serialBean.setValue(1L);
                }
                this.serialNumberDAO.saveForceFlush(serialBean.toFormSerialNumber());
            }
        }
    }

    private Long getCurrenValue(long id, boolean readOnly) throws BusinessException {
        Long value = 1L;
        try {
            FormSerialNumberBean serialBean = this.formCacheManager.getSerialNumber(id);
            if (null == serialBean) {
                throw new BusinessException("\u6d41\u6c34\u53f7\u5728\u7f13\u5b58\u4e2d\u627e\u4e0d\u5230\uff0c\u6d41\u6c34\u53f7id\uff1a" + id);
            }
            value = (Long)StoredProcedureCaller.execute((String)"{call proc_nextserialnumber(?,?,?)}", (Long)id, (int)(readOnly ? 1 : 0));
            FormSerialNumber formSerialNumber = this.serialNumberDAO.selectById(Long.valueOf(id));
            if (formSerialNumber == null) {
                String eMsg = "can't find serial in db,serial id:'" + id;
                logger.error((Object)eMsg);
                throw new BusinessException(eMsg);
            }
            serialBean = new FormSerialNumberBean(formSerialNumber);
            this.formCacheManager.addFormSerialNumberBean(id, serialBean);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("\u6d41\u6c34\u53f7(" + id + ")\u751f\u6210\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getCurrenValueByCache(long id, boolean readOnly) throws BusinessException {
        Long value;
        block19: {
            Lock lock = this.lockManager.getLock(id, 1);
            while (lock != null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)"\u6d41\u6c34\u53f7\u751f\u6210\u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38\u2026\u2026", (Throwable)e);
                }
                lock = this.lockManager.getLock(id, 1);
            }
            this.lockManager.lock(AppContext.currentUserId(), id, 1);
            value = 0L;
            try {
                Long minValue;
                FormSerialNumberBean serialBean = null;
                if (NotificationManager.getInstance().isEnabled() || this.formCacheManager.getSerialNumber(id) == null) {
                    FormSerialNumber formSerialNumber = this.serialNumberDAO.selectById(Long.valueOf(id));
                    if (formSerialNumber == null) {
                        throw new BusinessException("\u6d41\u6c34\u53f7\u5df2\u4e0d\u5b58\u5728\uff01");
                    }
                    serialBean = new FormSerialNumberBean(formSerialNumber);
                } else {
                    serialBean = this.formCacheManager.getSerialNumber(id);
                }
                this.checkIsReset(serialBean);
                value = serialBean.getValue();
                if (readOnly) break block19;
                Long currentValue = null;
                int digit = serialBean.getDigit();
                currentValue = (double)value.longValue() >= Math.pow(10.0, digit) - 1.0 ? ((minValue = serialBean.getMinValue()) == null ? Long.valueOf(1L) : minValue) : Long.valueOf(value + 1L);
                serialBean.setValue(currentValue.longValue());
                try {
                    Connection conn = JDBCAgent.getRawConnection();
                    PreparedStatement st = null;
                    try {
                        st = conn.prepareStatement("update form_serial_number set VALUE=?,CURRENT_MARK_DATE=? where id=?");
                        st.setLong(1, currentValue);
                        st.setDate(2, new Date(serialBean.getCurrentMarkDate().getTime()));
                        st.setLong(3, id);
                        st.execute();
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u6d41\u6c34\u53f7\u4fdd\u5b58\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()), (Throwable)e);
                    }
                    finally {
                        if (st != null) {
                            st.close();
                        }
                        conn.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("\u6d41\u6c34\u53f7\u4fdd\u5b58\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()), (Throwable)e);
                }
                this.formCacheManager.addFormSerialNumberBean(id, serialBean);
            }
            catch (Exception e) {
                logger.error((Object)("\u6d41\u6c34\u53f7\u8ba1\u7b97\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()), (Throwable)e);
            }
            finally {
                this.lockManager.unlock(id, 1);
            }
        }
        return value;
    }

    private String combSerialValue(String serialValue, FormSerialNumberBean formSerialNumber) {
        StringBuilder str = new StringBuilder();
        int digit = formSerialNumber.getDigit();
        if (formSerialNumber.getPrefix() != null) {
            str.append(formSerialNumber.getPrefix());
        }
        if (formSerialNumber.getTimeDate() != null) {
            str.append(this.getTimeDateValue(formSerialNumber.getTimeDate()));
        }
        if (formSerialNumber.getTextTimeBehind() != null) {
            str.append(formSerialNumber.getTextTimeBehind());
        }
        if (null != formSerialNumber.getFixLenShow() && formSerialNumber.getFixLenShow() == 0) {
            str.append(serialValue);
        } else {
            str.append(PRESTIRNG.substring(0, digit - serialValue.length() < 0 ? 0 : digit - serialValue.length()) + serialValue);
        }
        if (formSerialNumber.getSuffix() != null) {
            str.append(formSerialNumber.getSuffix());
        }
        return str.toString();
    }

    private String getTimeDateValue(int flag) {
        String str = null;
        switch (flag) {
            case 1: {
                str = Datetimes.formatNoTimeZone((java.util.Date)new java.util.Date(), (String)"yyyy");
                break;
            }
            case 2: {
                str = Datetimes.formatNoTimeZone((java.util.Date)new java.util.Date(), (String)"yyyyMM");
                break;
            }
            case 3: {
                str = Datetimes.formatNoTimeZone((java.util.Date)new java.util.Date(), (String)"yyyyMMdd");
                break;
            }
            default: {
                str = "";
            }
        }
        return str;
    }

    private void checkIsReset(FormSerialNumberBean serialBean) throws BusinessException {
        if (serialBean != null) {
            Calendar current = Calendar.getInstance();
            int currentYear = current.get(1);
            int currentMonth = current.get(2) + 1;
            int currentDay = current.get(5);
            if (serialBean.getCurrentMarkDate() == null) {
                serialBean.setCurrentMarkDate(new java.util.Date());
            }
            java.util.Date markDate = serialBean.getCurrentMarkDate();
            Calendar mark = Calendar.getInstance();
            mark.setTime(markDate);
            int markYear = mark.get(1);
            int markMonth = mark.get(2) + 1;
            int markDay = mark.get(5);
            int rule = serialBean.getRuleReset();
            if (rule == Integer.parseInt(Enums.SerialNumberResetRule.Year.getKey()) && markYear != currentYear || rule == Integer.parseInt(Enums.SerialNumberResetRule.Month.getKey()) && (markYear != currentYear || markMonth != currentMonth) || rule == Integer.parseInt(Enums.SerialNumberResetRule.Day.getKey()) && (markYear != currentYear || markMonth != currentMonth || markDay != currentDay)) {
                if (serialBean.getMinValue() != null) {
                    serialBean.setValue(serialBean.getMinValue().longValue());
                } else {
                    serialBean.setValue(1L);
                }
                serialBean.setCurrentMarkDate(new java.util.Date());
            }
        }
    }

    @Override
    public String getSerialNumber(FormAuthViewFieldBean formAuthViewFieldBean) throws BusinessException {
        if (formAuthViewFieldBean.isSerialNumberDefaultValue()) {
            Long serialId = 0L;
            try {
                serialId = Long.parseLong(formAuthViewFieldBean.getDefaultValue());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return this.getSerialNumberValue(serialId);
        }
        return "";
    }

    public SerialNumberDAO getSerialNumberDAO() {
        return this.serialNumberDAO;
    }

    public void setSerialNumberDAO(SerialNumberDAO serialNumberDAO) {
        this.serialNumberDAO = serialNumberDAO;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }
}

