/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.service;

import com.seeyon.cap4.cache.CacheEngine;
import com.seeyon.cap4.cache.bean.BeanCacheObject;
import com.seeyon.cap4.cache.inf.IRedisDataVersionManager;
import com.seeyon.cap4.cache.map.BeanCacheMap;
import com.seeyon.cap4.cache.map.SubBeanCacheMap;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormConditionActionBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.beanloader.CtpFormulaLoader;
import com.seeyon.cap4.form.beanloader.FormBeanLoader;
import com.seeyon.cap4.form.beanloader.FormBusinessRelationLoader;
import com.seeyon.cap4.form.beanloader.FormBusinessTriggerLoader;
import com.seeyon.cap4.form.beanloader.FormConditionActionBeanListLoader;
import com.seeyon.cap4.form.beanloader.FormCustomFunctionListLoader;
import com.seeyon.cap4.form.beanloader.FormFieldConditionActionBeanCacheMap;
import com.seeyon.cap4.form.beanloader.FormOwnerLoader;
import com.seeyon.cap4.form.beanloader.FormRelationLoader;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataLoaderContext;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataPojo;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.cluster.notification.NotificationType;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.form.po.FormCustomFunction;
import com.seeyon.ctp.form.po.FormOwner;
import com.seeyon.ctp.form.po.FormRelation;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.dom4j.DocumentException;

public abstract class CAP4FormCache {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormCache.class);
    protected ConcurrentMap<Long, CtpFormula> formulas = new BeanCacheMap<Long, BeanCacheObject<CtpFormula>, CtpFormula, CAP4FormCache>(new CtpFormulaLoader(), this);
    protected ConcurrentMap<Long, List<FormConditionActionBean>> authConditions = new BeanCacheMap<Long, BeanCacheObject<List<FormConditionActionBean>>, List<FormConditionActionBean>, CAP4FormCache>(new FormConditionActionBeanListLoader("auth"), this);
    protected ConcurrentMap<Long, List<FormConditionActionBean>> formCheckRules = new BeanCacheMap<Long, BeanCacheObject<List<FormConditionActionBean>>, List<FormConditionActionBean>, CAP4FormCache>(new FormConditionActionBeanListLoader("check"), this);
    protected ConcurrentMap<Long, List<FormConditionActionBean>> fieldFormulaConditions = new FormFieldConditionActionBeanCacheMap(new FormConditionActionBeanListLoader("field"), this);
    protected ConcurrentMap<Long, List<FormCustomFunction>> formCustomFunctions = new BeanCacheMap<Long, BeanCacheObject<List<FormCustomFunction>>, List<FormCustomFunction>, CAP4FormCache>(new FormCustomFunctionListLoader(), this);
    protected ConcurrentMap<Long, FormRelation> relations = new BeanCacheMap<Long, BeanCacheObject<FormRelation>, FormRelation, CAP4FormCache>(new FormRelationLoader(), this);
    protected ConcurrentMap<Long, FormOwner> ownerMap = new BeanCacheMap<Long, BeanCacheObject<FormOwner>, FormOwner, CAP4FormCache>(new FormOwnerLoader(), this);
    protected ConcurrentMap<Long, FormBean> forms = new BeanCacheMap<Long, BeanCacheObject<FormBean>, FormBean, CAP4FormCache>(new FormBeanLoader(), this);
    protected ConcurrentMap<Long, FormRelationshipBean> formRelationshipMap = new BeanCacheMap<Long, BeanCacheObject<FormRelationshipBean>, FormRelationshipBean, CAP4FormCache>(new FormBusinessRelationLoader(), this);
    protected ConcurrentMap<Long, FormTriggerBean> formTriggerMap = new BeanCacheMap<Long, BeanCacheObject<FormTriggerBean>, FormTriggerBean, CAP4FormCache>(new FormBusinessTriggerLoader(), this);
    protected SubBeanCacheMap<String, FormTableBean> tables = new SubBeanCacheMap<String, FormTableBean>(){

        @Override
        public FormTableBean getBeanFromMasterMap(String key, Long formId) {
            FormBean formBean = (FormBean)CAP4FormCache.this.forms.get(formId);
            if (formBean != null) {
                return formBean.getTableByTableName(key);
            }
            return null;
        }
    };
    protected SubBeanCacheMap<Long, FormViewBean> views = new SubBeanCacheMap<Long, FormViewBean>(){

        @Override
        public FormViewBean getBeanFromMasterMap(Long key, Long formId) {
            FormBean formBean = (FormBean)CAP4FormCache.this.forms.get(formId);
            if (formBean != null) {
                return formBean.getFormView(key.longValue());
            }
            return null;
        }
    };
    protected SubBeanCacheMap<Long, FormFieldBean> fields = new SubBeanCacheMap<Long, FormFieldBean>(){

        @Override
        public FormFieldBean getBeanFromMasterMap(Long fieldId, Long formId) {
            FormBean formBean = (FormBean)CAP4FormCache.this.forms.get(formId);
            if (formBean != null) {
                List allFieldBeans = formBean.getAllFieldBeans();
                for (FormFieldBean ffb : allFieldBeans) {
                    if (!ffb.getId().equals(fieldId)) continue;
                    return ffb;
                }
            }
            return null;
        }
    };
    protected SubBeanCacheMap<Long, FormAuthViewBean> authors = new SubBeanCacheMap<Long, FormAuthViewBean>(){

        @Override
        public FormAuthViewBean getBeanFromMasterMap(Long key, Long formId) {
            FormBean formBean = (FormBean)CAP4FormCache.this.forms.get(formId);
            if (formBean != null) {
                return formBean.getAuthViewBeanById(key);
            }
            return null;
        }
    };
    protected ConcurrentMap<String, Long> formCodeMap = new ConcurrentHashMap<String, Long>();

    protected void init() throws BusinessException, DocumentException {
    }

    protected void destroy() {
        this.formCustomFunctions = null;
        this.authors = null;
        this.fields = null;
        this.views = null;
        this.tables = null;
        this.forms = null;
        this.formCodeMap = null;
    }

    public ConcurrentMap<Long, FormBean> getForms() {
        return this.forms;
    }

    public FormBean getForm(long id) {
        IRedisDataVersionManager iRedisDataVersionManager = (IRedisDataVersionManager)((Object)CacheEngine.getInstance().getCacheManager(CAPFormDataPojo.class, CAPFormDataLoaderContext.class));
        CAPFormManager capFormManager = (CAPFormManager)AppContext.getBean((String)"capFormManager");
        if (null != iRedisDataVersionManager) {
            iRedisDataVersionManager.checkDataVersion(capFormManager.getNoByEnum((Object)FormCacheType.Form_init), id);
        }
        return (FormBean)this.forms.get(id);
    }

    public List<FormBean> getFormsByType(int formType) {
        ArrayList<FormBean> list = new ArrayList<FormBean>();
        for (Map.Entry entry : this.forms.entrySet()) {
            FormBean fb = (FormBean)entry.getValue();
            if (fb.getFormType() != formType || fb.getEditFlag() != 0) continue;
            list.add(fb);
        }
        return list;
    }

    public List<FormBean> getFormsByTypes(int[] formTypes) {
        ArrayList<FormBean> list = new ArrayList<FormBean>();
        for (Map.Entry entry : this.forms.entrySet()) {
            FormBean fb = (FormBean)entry.getValue();
            for (int formType : formTypes) {
                if (fb.getFormType() != formType || fb.getEditFlag() != 0) continue;
                list.add(fb);
            }
        }
        return list;
    }

    public FormTableBean getTable(String tableName) {
        return this.tables.get(tableName);
    }

    public void addTable(String tableName, FormTableBean tableBean, Long formId) {
        this.tables.put(tableName, tableBean, formId);
    }

    public FormViewBean getView(long id) {
        return this.views.get(id);
    }

    public void addView(Long viewId, FormViewBean viewBean, Long formId) {
        this.views.put(viewId, viewBean, formId);
    }

    public FormAuthViewBean getAuth(long id) {
        return this.authors.get(id);
    }

    public void addAuthView(Long authId, FormAuthViewBean authViewBean, Long formId) {
        this.authors.put(authId, authViewBean, formId);
    }

    public FormFieldBean getField(long id) {
        return this.fields.get(id);
    }

    public void addField(Long fieldId, FormFieldBean fieldBean, Long formId) {
        this.fields.put(fieldId, fieldBean, formId);
    }

    public CtpFormula getFormula(long id) {
        return (CtpFormula)this.formulas.get(id);
    }

    public List<FormConditionActionBean> getFormCheckRule(long id) {
        return (List)this.formCheckRules.get(id);
    }

    public List<FormConditionActionBean> getFieldFormulaCondition(long id) {
        return (List)this.fieldFormulaConditions.get(id);
    }

    public List<FormCustomFunction> getFormCustomFunction(Long id) {
        return (List)this.formCustomFunctions.get(id);
    }

    public FormRelationshipBean getFormRelationshipBean(long id) {
        return (FormRelationshipBean)this.formRelationshipMap.get(id);
    }

    public List<FormRelationshipBean> getFormRelationshipBeanList() {
        return (List)this.formRelationshipMap.values();
    }

    public Set<FormRelationshipBean> getFormRelationshipBeanListByFormId(long formId) {
        HashSet<FormRelationshipBean> set = new HashSet<FormRelationshipBean>();
        FormBean formBean = this.getForm(formId);
        List relationshipIdList = formBean.getFormRelationshipIdList();
        for (Long relationId : relationshipIdList) {
            FormRelationshipBean relation = (FormRelationshipBean)this.formRelationshipMap.get(relationId);
            if (relation == null) continue;
            set.add(relation);
        }
        return set;
    }

    public FormTriggerBean getFormTriggerBean(long id) {
        return (FormTriggerBean)this.formTriggerMap.get(id);
    }

    public List<FormTriggerBean> getFormTriggerBeanList() {
        return (List)this.formTriggerMap.values();
    }

    public Set<FormTriggerBean> getFormTriggerBeanListByFormId(long formId) {
        HashSet<FormTriggerBean> set = new HashSet<FormTriggerBean>();
        FormBean formBean = this.getForm(formId);
        List triggerIdList = formBean.getFormTriggerIdList();
        for (Long triggerId : triggerIdList) {
            FormTriggerBean trigger = (FormTriggerBean)this.formTriggerMap.get(triggerId);
            if (trigger == null) continue;
            set.add(trigger);
        }
        return set;
    }

    public List<FormBean> getFormList() {
        ArrayList<FormBean> list = new ArrayList<FormBean>();
        for (Map.Entry entry : this.forms.entrySet()) {
            if (((FormBean)entry.getValue()).getEditFlag() != 0) continue;
            list.add((FormBean)entry.getValue());
        }
        return list;
    }

    public synchronized void addFormBean(long id, FormBean fb) {
        this.forms.put(id, fb);
        this.sendNotification((Object)id, FormCacheType.Form_init, id);
    }

    public synchronized void removeFormBean(long id) {
        this.removeFormBean(id, true);
    }

    public synchronized void removeFormBean(long id, boolean sendNotify) {
        FormBean bean = (FormBean)this.forms.get(id);
        if (bean != null) {
            if (bean.getEditFlag() == 1) {
                bean = (FormBean)this.forms.get(bean.getId());
            }
            if (bean != null) {
                this.removeFormTable(bean);
                this.removeFormView(bean);
                this.removeFormField(bean);
                this.removeFormAuth(bean);
                this.removeFormFormula(bean);
                this.removeFormConditionAction(bean);
                this.removeFormCustomFunction(bean);
                this.removeFormRelation(bean);
                this.removeFormRelationshipBean(bean);
                this.removeFormTriggerBean(bean);
            }
        }
        this.forms.remove(id);
        long currentUserId = AppContext.currentUserId();
        if (currentUserId != -1L) {
            this.showStackTrace(AppContext.currentUserName() + "\u5220\u9664\u8868\u5355 " + id);
        }
        if (sendNotify) {
            this.sendNotification((Object)id, FormCacheType.Form_remove, id);
        }
    }

    public synchronized void removeOnlyFormBean(long id) {
        this.forms.remove(id);
        this.showStackTrace(AppContext.currentUserName() + "\u5220\u9664\u8868\u5355 " + id);
        this.sendNotification((Object)id, FormCacheType.Form_remove, id);
    }

    public void removeFormTable(FormBean bean) {
        List tableList = bean.getTableList();
        for (FormTableBean table : tableList) {
            this.tables.remove(table.getTableName());
        }
    }

    public void removeFormView(FormBean bean) {
        List formViewList = bean.getFormViewList();
        for (FormViewBean view : formViewList) {
            this.views.remove(view.getId());
        }
    }

    public void removeFormField(FormBean bean) {
        List formFieldList = bean.getAllFieldBeans();
        for (FormFieldBean field : formFieldList) {
            this.fields.remove(field.getId());
        }
    }

    public void removeFormAuth(FormBean bean) {
        List formAuthViewBeanList = bean.getAllFormAuthViewBeans();
        for (FormAuthViewBean authView : formAuthViewBeanList) {
            this.authors.remove(authView.getId());
        }
    }

    public void removeFormFormula(FormBean bean) {
        this.removeFormula(this.getFormulaList(bean));
    }

    public List<CtpFormula> getFormulaList(FormBean formBean) {
        ArrayList<CtpFormula> list = new ArrayList<CtpFormula>();
        if (formBean.getCheckRuleBean() != null) {
            list.addAll(formBean.getCheckRuleBean().getCtpFormulaList());
        }
        for (FormFieldBean fieldBean : formBean.getAllFieldBeans()) {
            if (!Strings.isNotEmpty((Collection)fieldBean.getFormConditionList())) continue;
            for (FormConditionActionBean formCondition : fieldBean.getFormConditionList()) {
                list.addAll(formCondition.getAllFormulaList());
            }
        }
        Map authMap = formBean.getBind().getUnFlowTemplateMap();
        Set set = authMap.keySet();
        for (String s : set) {
            FormBindAuthBean formBindAuthBean = (FormBindAuthBean)authMap.get(s);
            FormFormulaBean formulaBean = formBindAuthBean.getFormFormulaBean();
            if (formulaBean == null) continue;
            list.add(formBean.newCTPFormula4Save(formulaBean, 2));
        }
        List authViewBeans = formBean.getAllFormAuthViewBeans(true);
        for (FormAuthViewBean favb : authViewBeans) {
            List formConditionActionBeans = favb.getFormConditionActionBeanList();
            for (FormConditionActionBean fcab : formConditionActionBeans) {
                if (fcab == null) continue;
                list.addAll(fcab.getAllFormulaList());
            }
        }
        return list;
    }

    public void removeFormula(List<CtpFormula> formulaList) {
        if (Strings.isEmpty(formulaList)) {
            return;
        }
        for (CtpFormula ctpFormula : formulaList) {
            if (ctpFormula == null) continue;
            this.formulas.remove(ctpFormula.getId());
        }
    }

    public void removeFormConditionAction(FormBean bean) {
        this.authConditions.remove(bean.getId());
        this.formCheckRules.remove(bean.getId());
        List formFieldBeanList = bean.getAllFieldBeans();
        for (FormFieldBean formFieldBean : formFieldBeanList) {
            this.fieldFormulaConditions.remove(formFieldBean.getId());
        }
    }

    public void removeFormCustomFunction(FormBean bean) {
        this.formCustomFunctions.remove(bean.getId());
    }

    public void removeFormRelation(FormBean bean) {
        List relationList = bean.getRelationList();
        for (FormRelation relation : relationList) {
            this.relations.remove(relation.getId());
        }
    }

    public void addFormRelationshipBean(long id, FormRelationshipBean relation) {
        this.formRelationshipMap.put(id, relation);
        this.sendNotification((Object)relation, FormCacheType.FormBusinessRelation_add, id);
    }

    public void removeFormRelationshipBean(FormBean formBean) {
        List relationIdList = formBean.getFormRelationshipIdList();
        for (Long relationId : relationIdList) {
            FormRelationshipBean formRelationshipBean = (FormRelationshipBean)this.formRelationshipMap.get(relationId);
            this.formRelationshipMap.remove(relationId);
            if (formRelationshipBean == null) continue;
            for (FormRelationshipMapBean relationshipMapBean : formRelationshipBean.getRelationMapList()) {
                Map collectFormulaBean;
                if (relationshipMapBean.getConditionFormulaId() != 0L) {
                    this.formulas.remove(relationshipMapBean.getConditionFormulaId());
                }
                if ((collectFormulaBean = relationshipMapBean.getCollectFormulaBean()) == null) continue;
                for (Map.Entry entry : collectFormulaBean.entrySet()) {
                    this.formulas.remove(entry.getKey());
                }
            }
        }
        relationIdList.clear();
    }

    public void addFormTriggerBean(long id, FormTriggerBean trigger) {
        this.formTriggerMap.put(id, trigger);
        this.sendNotification((Object)trigger, FormCacheType.FormBusinessRelation_add, id);
    }

    public void removeFormTriggerBean(FormBean formBean) {
        List triggerIdList = formBean.getFormTriggerIdList();
        for (Long triggerId : triggerIdList) {
            FormTriggerBean triggerBean = (FormTriggerBean)this.formTriggerMap.get(triggerId);
            boolean hasDis = false;
            if (triggerBean != null) {
                boolean needCheck;
                boolean isTargetForm = formBean.getId().equals(triggerBean.getTargetFormId());
                boolean bl = needCheck = FormTriggerBean.TriggerBusinessType.FormOuter.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.DataInterface.getKey().equals(triggerBean.getType());
                if (isTargetForm && needCheck) {
                    for (FormTriggerActionBean actionBean : triggerBean.getActionList()) {
                        boolean isDistribution = FormTriggerBean.TriggerType.Distribution.getKey().equals(actionBean.getType());
                        if (!isDistribution) {
                            boolean bl2 = isDistribution = actionBean.getParam("triggerType") != null && FormTriggerBean.TriggerType.Distribution.getKey().equals(actionBean.getParam("triggerType"));
                        }
                        if (!isDistribution) continue;
                        hasDis = true;
                        break;
                    }
                }
            }
            if (hasDis) continue;
            this.formTriggerMap.remove(triggerId);
            if (triggerBean == null) continue;
            for (FormFormulaBean formula : triggerBean.getFormulaList()) {
                if (formula == null) continue;
                this.formulas.remove(formula.getFormulaId());
            }
        }
        triggerIdList.clear();
    }

    public void removeFormTriggerBean(long id) {
        this.formTriggerMap.remove(id);
        this.sendNotification((Object)id, FormCacheType.FormBusinessRelation_remove, id);
    }

    public FormOwner getFormOwner(Long formId) {
        IRedisDataVersionManager iRedisDataVersionManager = (IRedisDataVersionManager)((Object)CacheEngine.getInstance().getCacheManager(CAPFormDataPojo.class, CAPFormDataLoaderContext.class));
        CAPFormManager capFormManager = (CAPFormManager)AppContext.getBean((String)"capFormManager");
        if (null != iRedisDataVersionManager) {
            iRedisDataVersionManager.checkDataVersion(capFormManager.getNoByEnum((Object)FormCacheType.Change_owner), formId);
        }
        return (FormOwner)this.ownerMap.get(formId);
    }

    public boolean addFormOwner(FormOwner formOwner) {
        this.ownerMap.put(formOwner.getFormId(), formOwner);
        return true;
    }

    private void showStackTrace(String info) {
        LOGGER.info((Object)info);
    }

    private void sendNotification(Object obj, FormCacheType type) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(0, (Object)type);
        args.add(1, obj);
        NotificationManager.getInstance().send(NotificationType.CapFormAppReload, args);
        LOGGER.info((Object)("CAP4\u53d1\u9001\u8868\u5355\u7f13\u5b58\u540c\u6b65\u901a\u77e5:type-" + type.name() + "  obj:" + JSONUtil.toJSONString((Object)obj)));
    }

    public void sendNotification(Object obj, FormCacheType type, Long id) {
        IRedisDataVersionManager iRedisDataVersionManager = (IRedisDataVersionManager)((Object)CacheEngine.getInstance().getCacheManager(CAPFormDataPojo.class, CAPFormDataLoaderContext.class));
        if (null != iRedisDataVersionManager && iRedisDataVersionManager.isUseRedisDataVersion()) {
            CAPFormManager capFormManager = (CAPFormManager)AppContext.getBean((String)"capFormManager");
            switch (type) {
                case SerialNum_add: 
                case SerialNum_remove: {
                    break;
                }
                case Form_init: 
                case Form_remove: {
                    iRedisDataVersionManager.sendNotification(capFormManager.getNoByEnum((Object)FormCacheType.Form_init), id);
                    break;
                }
                case Change_owner: {
                    iRedisDataVersionManager.sendNotification(capFormManager.getNoByEnum((Object)FormCacheType.Change_owner), id);
                    break;
                }
                case FromBizConfig_Reload: {
                    break;
                }
                case FromBizConfig_remove: {
                    break;
                }
                case FormBusinessRelation_add: 
                case FormBusinessRelation_remove: {
                    iRedisDataVersionManager.sendNotification(capFormManager.getNoByEnum((Object)FormCacheType.FormBusinessRelation_add), id);
                    break;
                }
                case CustomTemplate_Modify_Config: {
                    break;
                }
                case CustomTemplate_Delete_Template: {
                    break;
                }
                case CustomTemplate_Download_Template: {
                    break;
                }
                case CustomTemplate_Remove_Cache: {
                    break;
                }
                case CustomTemplate_Import_Business: {
                    break;
                }
                case CustomTemplate_Copy_Template: {
                    break;
                }
                case CustomTemplate_Save_Editable_Template: {
                    break;
                }
                case CustomControl_Reload: {
                    this.sendNotification(obj, type);
                }
            }
        } else {
            this.sendNotification(obj, type);
        }
    }

    public void sendNotification(Object obj, FormCacheType type, List<Long> ids) {
        IRedisDataVersionManager iRedisDataVersionManager = (IRedisDataVersionManager)((Object)CacheEngine.getInstance().getCacheManager(CAPFormDataPojo.class, CAPFormDataLoaderContext.class));
        if (null != iRedisDataVersionManager && iRedisDataVersionManager.isUseRedisDataVersion()) {
            CAPFormManager capFormManager = (CAPFormManager)AppContext.getBean((String)"capFormManager");
            long[] idArray = new long[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                idArray[i] = ids.get(i);
            }
            iRedisDataVersionManager.sendNotifications(capFormManager.getNoByEnum((Object)type), idArray);
        } else {
            this.sendNotification(obj, type);
        }
    }

    public ConcurrentMap<Long, List<FormConditionActionBean>> getAuthConditions() {
        return this.authConditions;
    }

    public ConcurrentMap<Long, List<FormConditionActionBean>> getFormCheckRules() {
        return this.formCheckRules;
    }

    public ConcurrentMap<Long, List<FormConditionActionBean>> getFieldFormulaConditions() {
        return this.fieldFormulaConditions;
    }

    public ConcurrentMap<Long, FormRelation> getRelations() {
        return this.relations;
    }

    public static enum FormCacheType {
        SerialNum_add,
        SerialNum_remove,
        Form_init,
        Form_remove,
        Change_owner,
        FromBizConfig_Reload,
        FromBizConfig_remove,
        FormBusinessRelation_add,
        FormBusinessRelation_remove,
        CustomTemplate_Modify_Config,
        CustomTemplate_Delete_Template,
        CustomTemplate_Download_Template,
        CustomTemplate_Download_Column,
        CustomTemplate_Remove_Cache,
        CustomTemplate_Import_Business,
        CustomTemplate_Copy_Template,
        CustomTemplate_Save_Editable_Template,
        CustomControl_Reload,
        CustomFunction_Reload,
        BizConfig_Valid_ModiFied;

    }
}

