/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.service;

import com.seeyon.cap4.cache.CacheEngine;
import com.seeyon.cap4.cache.inf.IRedisDataVersionManager;
import com.seeyon.cap4.cluster.listener.FormNotificationHandler;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormCheckRuleBean;
import com.seeyon.cap4.form.bean.FormConditionActionBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.control.ControlManager;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormDefinitionDAO;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormDefinitionInitManager;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormResourceDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataLoaderContext;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataPojo;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationDAO;
import com.seeyon.cap4.form.modules.engin.formula.FormulaUtil;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.formlist.CAP4FormListManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.po.CAPFormBusinessRelation;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.po.CAPFormResource;
import com.seeyon.cap4.form.service.CAP4FormCache;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.service.DefinitionInitRunner;
import com.seeyon.cap4.form.service.FormInitThreadFactory;
import com.seeyon.cap4.form.service.ResourceInitRunner;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.modules.engin.authorization.FormAuthModuleDAO;
import com.seeyon.ctp.form.modules.engin.base.formBase.FormOwnerDAO;
import com.seeyon.ctp.form.modules.engin.base.formBase.FormTableValueSignDAO;
import com.seeyon.ctp.form.modules.engin.base.serialNumber.SerialNumberDAO;
import com.seeyon.ctp.form.modules.engin.formula.FormCustomFunctionDAO;
import com.seeyon.ctp.form.modules.engin.formula.FormulaConditionDAO;
import com.seeyon.ctp.form.modules.engin.formula.FormulaDAO;
import com.seeyon.ctp.form.modules.engin.relation.FormRelationDAO;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.form.po.CtpFormulaCondition;
import com.seeyon.ctp.form.po.FormCustomFunction;
import com.seeyon.ctp.form.po.FormOwner;
import com.seeyon.ctp.form.po.FormRelation;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.XXEUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class CAP4FormCacheManager
extends CAP4FormCache {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormCacheManager.class);
    private CAP4FormResourceDAO cap4FormResourceDAO;
    private SerialNumberDAO serialNumberDAO;
    private CAP4FormDefinitionDAO cap4FormDefinitionDAO;
    private FormOwnerDAO formOwnerDAO;
    private CAP4FormDataDAO cap4FormDataDAO;
    private FormTableValueSignDAO formTableValueSignDAO;
    private FormulaDAO formulaDAO;
    private FormRelationDAO formRelationDAO;
    private FormAuthModuleDAO formAuthModuleDAO;
    private FormulaConditionDAO formulaConditionDAO;
    private FormCustomFunctionDAO formCustomFunctionDAO;
    private CAP4FormListManager cap4FormListManager;
    private AttachmentManager attachmentManager;
    private CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO;
    private CAP4FormManager cap4FormManager;
    private ControlManager controlManager;
    public volatile boolean initTag = false;
    public volatile boolean initing = false;
    private final int onceInitSize4FormDefinition = 200;
    private final int coreThreadSize = Runtime.getRuntime().availableProcessors() * 2;
    private final FormInitThreadFactory initThreadFactory = new FormInitThreadFactory();
    private final int onceInitSize4Formula = 500;
    private FormCacheManager formCacheManager;
    private List<CAP4FormDefinitionInitManager> enginInit;
    private List<CAP4FormDefinitionInitManager> appInit;
    public List<Object> initUndoMessages = Collections.synchronizedList(new LinkedList());

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void registerLoader() {
        CAPFormManager capFormManager = (CAPFormManager)AppContext.getBean((String)"capFormManager");
        IRedisDataVersionManager iRedisDataVersionManager = (IRedisDataVersionManager)((Object)CacheEngine.getInstance().getCacheManager(CAPFormDataPojo.class, CAPFormDataLoaderContext.class));
        if (null != iRedisDataVersionManager) {
            iRedisDataVersionManager.regAsyncDataVerEvent(new IRedisDataVersionManager.IOnAsyncDataVerEvent(){

                @Override
                public boolean doEvent(IRedisDataVersionManager.IAsyncDataVerItem aItem) {
                    Long formId = aItem.getDataId();
                    if (CAP4FormCacheManager.this.initing) {
                        return true;
                    }
                    try {
                        CAP4FormCacheManager.this.initForm(formId, false);
                        return true;
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            }, capFormManager.getNoByEnum((Object)CAP4FormCache.FormCacheType.Form_init));
            iRedisDataVersionManager.regAsyncDataVerEvent(new IRedisDataVersionManager.IOnAsyncDataVerEvent(){

                @Override
                public boolean doEvent(IRedisDataVersionManager.IAsyncDataVerItem aItem) {
                    if (CAP4FormCacheManager.this.initing) {
                        return true;
                    }
                    Long formId = aItem.getDataId();
                    try {
                        List owners = CAP4FormCacheManager.this.formOwnerDAO.selectByFormId(formId);
                        if (owners == null || owners.isEmpty()) {
                            LOGGER.error((Object)("\u8868\u5355id" + formId + "\u4ece\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u6240\u5c5e\u4eba\u6570\u636e\uff01"));
                            return false;
                        }
                        FormOwner formOwner = (FormOwner)owners.get(0);
                        CAP4FormCacheManager cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
                        cap4FormCacheManager.addFormOwner(formOwner);
                        FormBean form = cap4FormCacheManager.getForm(formId);
                        if (owners.size() > 1 && LOGGER.isWarnEnabled()) {
                            LOGGER.warn((Object)("\u8868\u5355" + form.getFormName() + "\u6240\u5c5e\u4eba\u6709" + owners.size() + "\u4e2a\uff0c\u5c5e\u4e8e\u975e\u6b63\u5e38\u6570\u636e"));
                        }
                        form.setOwnerId(formOwner.getOwnerId().longValue());
                        return true;
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            }, capFormManager.getNoByEnum((Object)CAP4FormCache.FormCacheType.Change_owner));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        this.registerLoader();
        if (!this.initTag) {
            this.initTag = true;
            try {
                LOGGER.info((Object)"\u521d\u59cb\u5316CAP4\u8868\u5355........");
                long startTime = System.currentTimeMillis();
                super.init();
                this.initAllFormFormula();
                this.initAllFormConditionAction();
                this.initAllFormCustomFunction();
                this.initAllFormRelation();
                this.initAllForm();
                this.initFormFormulaBean4Formula();
                this.initAllFormResource();
                this.initFormBusinessRelation();
                this.checkFieldInCondition();
                this.deployCustomCtrl();
                Map customCtrlMap = FormFieldUtil.getCustomCtrlMap();
                ArrayList<FormFieldCtrl> customCtrls = new ArrayList<FormFieldCtrl>();
                for (Map.Entry entry : customCtrlMap.entrySet()) {
                    customCtrls.add((FormFieldCtrl)entry.getValue());
                }
                this.controlManager.validateFormFieldCtrl(customCtrls);
                LOGGER.info((Object)("\u521d\u59cb\u5316CAP4\u8868\u5355\u7ed3\u675f,\u5171\u8017\u65f6" + (System.currentTimeMillis() - startTime)));
            }
            catch (BusinessException e1) {
                LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
            }
            catch (DocumentException e2) {
                LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.initTag = false;
                if (!this.initUndoMessages.isEmpty()) {
                    FormNotificationHandler handler = (FormNotificationHandler)AppContext.getBean((String)"formNotificationHandler4");
                    for (Object o : this.initUndoMessages) {
                        try {
                            handler.updateFormCache(o);
                        }
                        catch (BusinessException e) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    this.initUndoMessages.clear();
                }
            }
        }
    }

    private void deployCustomCtrl() throws BusinessException {
        File[] customPackages;
        File customCtrlFolder = SystemEnvironment.getClusterPublicFolder((String)"capCustomCtrls");
        File applicationFolder = new File(SystemEnvironment.getApplicationFolder());
        if (customCtrlFolder.exists() && customCtrlFolder.isDirectory() && (customPackages = customCtrlFolder.listFiles()) != null && customPackages.length > 0) {
            Long start = System.currentTimeMillis();
            LOGGER.info((Object)("\u81ea\u5b9a\u4e49\u63a7\u4ef6/\u6309\u94ae\u90e8\u7f72\u5f00\u59cb\uff0c\u603b\u5171" + customPackages.length + "\u4e2a"));
            for (File customPackageFile : customPackages) {
                FormUtil.deployCustomCtrl((File)customPackageFile, (File)applicationFolder, (boolean)true);
            }
            Long end = System.currentTimeMillis();
            LOGGER.info((Object)("\u81ea\u5b9a\u4e49\u63a7\u4ef6/\u6309\u94ae\u90e8\u7f72\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (end - start)));
        }
    }

    private void checkFieldInCondition(FormBean formBean) {
        List allFields = formBean.getAllFieldBeans();
        HashMap<String, String> tempFormulaStrs = new HashMap<String, String>(16);
        block0: for (FormFieldBean fieldBean : allFields) {
            FormFieldBean toField;
            FormRelation relation = fieldBean.getFormRelation();
            if (relation != null && (toField = formBean.getFieldBeanByName(relation.getToRelationAttr())) != null) {
                toField.setInInnerRelation(true);
            }
            for (FormFieldBean fieldBean1 : allFields) {
                List fieldConditions = fieldBean1.getFormConditionList();
                String formulaStr = (String)tempFormulaStrs.get(fieldBean1.getName());
                if (fieldConditions == null) continue;
                if (formulaStr == null) {
                    formulaStr = FormulaUtil.getConditionFormulaStr((List)fieldConditions);
                    tempFormulaStrs.put(fieldBean1.getName(), formulaStr);
                }
                if (!FormulaUtil.isFieldExistFormula((List)fieldConditions, (String)fieldBean.getName())) continue;
                fieldBean.setInCalculate(true);
                continue block0;
            }
        }
    }

    private void checkFieldInCondition() {
        Collection listForms = this.forms.values();
        for (FormBean formBean : listForms) {
            this.checkFieldInCondition(formBean);
        }
    }

    @Override
    public FormBean getForm(long id) {
        if (id == 0L || id == -1L) {
            return null;
        }
        return super.getForm(id);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public FormBean initForm(long formId) throws BusinessException {
        return this.initForm(formId, true);
    }

    public FormBean initForm(long formId, boolean sendNotify) throws BusinessException {
        LOGGER.info((Object)("\u521d\u59cb\u5316\u8868\u5355\uff1a" + formId));
        CAPFormManager capFormManager = (CAPFormManager)AppContext.getBean((String)"capFormManager");
        IRedisDataVersionManager iRedisDataVersionManager = (IRedisDataVersionManager)((Object)CacheEngine.getInstance().getCacheManager(CAPFormDataPojo.class, CAPFormDataLoaderContext.class));
        if (sendNotify) {
            this.sendNotification((Object)formId, CAP4FormCache.FormCacheType.Form_init, formId);
        }
        if (null != iRedisDataVersionManager) {
            iRedisDataVersionManager.syncLocalDataVersion(capFormManager.getNoByEnum((Object)CAP4FormCache.FormCacheType.Form_init), formId);
        }
        AppContext.putThreadContext((String)"currentInitForm", (Object)String.valueOf(formId));
        this.updateFormCodeMap(formId);
        FormCacheManager cacheManager = (FormCacheManager)AppContext.getBean((String)"formCacheManager");
        cacheManager.initFormSerialNumber(Long.valueOf(formId));
        this.initFormFormula(formId);
        this.initFormConditionAction(formId);
        this.initAllFormCustomFunction(formId);
        this.initFormRelation(formId);
        CAPFormDefinition formDefinition = this.cap4FormDefinitionDAO.selectById(formId);
        FormOwner formOwner = null;
        List formOwnerLists = this.formOwnerDAO.selectByFormId(Long.valueOf(formId));
        if (Strings.isNotEmpty((Collection)formOwnerLists)) {
            formOwner = (FormOwner)formOwnerLists.get(0);
            this.ownerMap.put(formOwner.getFormId(), formOwner);
        }
        FormBean fb = null;
        List<CAPFormResource> formAppResourceList = this.cap4FormResourceDAO.selectByFormId(formId);
        if (formDefinition != null && formOwner != null && formAppResourceList != null) {
            fb = this.initFormDefinition(formDefinition, formOwner);
            this.initFormDefinitionAPP(formDefinition);
            this.initFormFormulaBean4Formula(formId);
            this.initResources(formAppResourceList);
            this.initFormBusinessRelation(formId);
            this.checkFieldInCondition(fb);
        } else {
            if (null == formDefinition) {
                LOGGER.error((Object)"\u8868\u5355\u5b9a\u4e49formDefinition\u4e3a\u7a7a");
            }
            if (null == formOwner) {
                LOGGER.error((Object)"formOwner\u4e3a\u7a7a");
            }
            if (null == formAppResourceList) {
                LOGGER.error((Object)"formAppResourceList\u4e3a\u7a7a");
            }
        }
        return fb;
    }

    public void initResources(List<CAPFormResource> tempResources) throws BusinessException {
        block0: for (CAPFormResource tempResource : tempResources) {
            FormBean tempForm = (FormBean)this.forms.get(tempResource.getFormId());
            if (tempForm == null) continue;
            if (tempResource.getPropertyType() == 102) {
                for (FormViewBean view : tempForm.getFormViewList()) {
                    if (view.getFormViewContent() != null || !tempResource.getId().equals(view.getId()) || tempResource.getContent() == null) continue;
                    view.setFormViewContent(tempResource.getContent());
                }
                continue;
            }
            if (tempResource.getPropertyType() == 104) {
                FormAuthViewBean auth = (FormAuthViewBean)this.authors.get(tempResource.getId());
                if (auth == null) continue;
                Map authMap = (Map)JSONUtil.parseJSONString((String)tempResource.getContent());
                this.initFormAuthViewBean(auth, authMap, tempForm);
                List highAuth = (List)authMap.get("auths");
                for (int i = 0; i < highAuth.size(); ++i) {
                    Map highAuthMap = (Map)highAuth.get(i);
                    this.initHighFormAuthViewBean(auth, highAuthMap, tempForm);
                }
                List fieldConditionAuths = (List)authMap.get("fieldConditionAuths");
                for (int i = 0; i < fieldConditionAuths.size(); ++i) {
                    Map fieldConditionAuthMap = (Map)fieldConditionAuths.get(i);
                    this.getAuthFieldFromJsonObjMap(fieldConditionAuthMap, tempForm, null, auth);
                }
                List deleteAuth = (List)authMap.get("deleteHighAuths");
                for (int i = 0; i < deleteAuth.size(); ++i) {
                    Map deleteAuthMap = (Map)deleteAuth.get(i);
                    Long parentId = ParamUtil.getLong((Map)deleteAuthMap, (String)"parentId", (Long)0L);
                    if (0L == parentId) {
                        this.initFormAuthViewBean(auth, deleteAuthMap, tempForm);
                        continue;
                    }
                    this.initHighFormAuthViewBean(auth, deleteAuthMap, tempForm);
                }
                List fieldAuthConditions = auth.getFormConditionActionBeanList();
                for (FormFieldBean ffb : tempForm.getAllFieldBeans()) {
                    if (!FormulaUtil.isFieldExistFormula((List)fieldAuthConditions, (String)ffb.getName())) continue;
                    ffb.setInAuthCondition(true);
                }
                continue;
            }
            if (tempResource.getPropertyType() != 105) continue;
            boolean findTag = false;
            for (FormViewBean view : tempForm.getFormViewList()) {
                Map multiLanViewMap = view.getMultiLanFormViewMap();
                if (!multiLanViewMap.isEmpty()) {
                    for (Map.Entry entry : multiLanViewMap.entrySet()) {
                        FormViewBean lanView = (FormViewBean)entry.getValue();
                        if (!tempResource.getId().equals(lanView.getId())) continue;
                        findTag = true;
                        lanView.setFormViewContent(tempResource.getContent());
                        break;
                    }
                }
                if (!findTag) continue;
                continue block0;
            }
        }
    }

    private void initFormAuthViewBean(FormAuthViewBean auth, Map<String, Object> authMap, FormBean tempForm) throws BusinessException {
        List fcabList;
        FormAuthViewBean parentAuth = null;
        if (auth.getParentId() != null && !"0".equals(auth.getParentId().toString())) {
            parentAuth = (FormAuthViewBean)this.authors.get(auth.getParentId());
        }
        int advanceAuthType = ParamUtil.getInt(authMap, (String)"advanceAuthType");
        auth.setAdvanceAuthType(advanceAuthType);
        List fieldList = (List)authMap.get("fields");
        for (int i = 0; i < fieldList.size(); ++i) {
            Map fieldAuthMap = (Map)fieldList.get(i);
            this.getAuthFieldFromJsonObjMap(fieldAuthMap, tempForm, parentAuth, auth);
        }
        List tableList = (List)authMap.get("tables");
        for (int i = 0; i < tableList.size(); ++i) {
            Map tableMap = (Map)tableList.get(i);
            if (Strings.isNotEmpty((String)ParamUtil.getString((Map)tableMap, (String)"add"))) {
                auth.addFormAuthorizationTable(tableMap.get("tableName").toString(), Boolean.parseBoolean(ParamUtil.getString((Map)tableMap, (String)"add")), Boolean.parseBoolean(ParamUtil.getString((Map)tableMap, (String)"copy")), Boolean.parseBoolean(ParamUtil.getString((Map)tableMap, (String)"delete")), Boolean.parseBoolean(ParamUtil.getString((Map)tableMap, (String)"deleteAll")), Boolean.parseBoolean(ParamUtil.getString((Map)tableMap, (String)"importData")), Boolean.parseBoolean(ParamUtil.getString((Map)tableMap, (String)"exportData")));
                continue;
            }
            auth.addFormAuthorizationTable(tableMap.get("tableName").toString(), Boolean.parseBoolean(ParamUtil.getString((Map)tableMap, (String)"allowAdd")), Boolean.parseBoolean(ParamUtil.getString((Map)tableMap, (String)"allowDelete")));
        }
        if (auth.getParentId() != 0L && (fcabList = (List)this.authConditions.get(tempForm.getId())) != null) {
            for (FormConditionActionBean fcab : fcabList) {
                if (!(fcab.getActionId() + "").equals(auth.getId() + "")) continue;
                auth.setFormConditionActionBean(fcab);
                break;
            }
        }
    }

    private void initHighFormAuthViewBean(FormAuthViewBean auth, Map<String, Object> highAuthMap, FormBean tempForm) throws BusinessException {
        FormAuthViewBean sonAuth = new FormAuthViewBean();
        Long parentId = ParamUtil.getLong(highAuthMap, (String)"parentId");
        sonAuth.setParentId(parentId);
        Long id = ParamUtil.getLong(highAuthMap, (String)"id");
        sonAuth.setId(id);
        sonAuth.setFormViewId(auth.getFormViewId());
        sonAuth.setName(auth.getName());
        sonAuth.setType(auth.getType());
        sonAuth.setFileName(auth.getFileName());
        String delete = ParamUtil.getString(highAuthMap, (String)"delete");
        sonAuth.setDelete(Boolean.parseBoolean(delete));
        if (sonAuth.isDelete()) {
            sonAuth.putExtraAttr("FORM_AUTH_DELETE_FLAG", "true");
        }
        this.initFormAuthViewBean(sonAuth, highAuthMap, tempForm);
        auth.addConditonFormAuthViewBean(sonAuth.getId(), sonAuth);
        this.authors.put(sonAuth.getId(), sonAuth);
    }

    private void getAuthFieldFromJsonObjMap(Map<String, Object> fieldAuthMap, FormBean tempForm, FormAuthViewBean parentAuth, FormAuthViewBean auth) {
        FormFieldBean formFieldBean;
        FormAuthViewFieldBean parentFieldAuth;
        Long formulaId;
        FormAuthViewFieldBean authField = new FormAuthViewFieldBean();
        Long fieldAuthId = ParamUtil.getLong(fieldAuthMap, (String)"id", (Long)0L);
        authField.setId(fieldAuthId);
        String access = ParamUtil.getString(fieldAuthMap, (String)"access");
        authField.setAccess(access);
        String fieldName = ParamUtil.getString(fieldAuthMap, (String)"fieldName");
        if (fieldName != null) {
            authField.setFieldName(fieldName);
            authField.setFormFieldBean(tempForm.getFieldBeanByName(fieldName));
        }
        if ((formulaId = ParamUtil.getLong(fieldAuthMap, (String)"formulaId", (Long)0L)) != 0L) {
            authField.setFormConditionActionBean(this.getFormAuthFormulaCondtionBean(tempForm.getId(), formulaId));
        }
        int isNotNull = ParamUtil.getInt(fieldAuthMap, (String)"isNotNull", (int)0);
        authField.setIsNotNull(isNotNull);
        int isInitNull = ParamUtil.getInt(fieldAuthMap, (String)"isInitNull", (int)0);
        authField.setIsInitNull(isInitNull);
        if (parentAuth != null && (parentFieldAuth = parentAuth.getFormAuthorizationField(authField.getFieldName())) != null) {
            authField.setShowName(parentFieldAuth.getShowName());
            authField.setDefaultValue(parentFieldAuth.getDefaultValue());
            authField.setDefaultValueType(parentFieldAuth.getDefaultValueType());
        }
        if (authField.getIsInitNull() == 1) {
            auth.setContainInitNull(true);
        }
        if (auth.isApartSetAuth() && authField.getFormConditionActionBean() != null) {
            auth.addConditionAuthFieldBean(authField);
        } else {
            auth.addFormAuthorizationField(authField.getFieldName(), authField);
        }
        String defaultValue = ParamUtil.getString(fieldAuthMap, (String)"defaultValue");
        if (Strings.isNotBlank((String)defaultValue)) {
            authField.setDefaultValue(defaultValue);
            String defaultValueType = ParamUtil.getString(fieldAuthMap, (String)"defaultValueType");
            authField.setDefaultValueType(defaultValueType);
            String showName = ParamUtil.getString(fieldAuthMap, (String)"showName");
            authField.setShowName(showName);
        }
        if ((formFieldBean = authField.getFormFieldBean()) != null && !formFieldBean.isSn() && !auth.isDelete()) {
            formFieldBean.setSn(authField.isSerialNumberDefaultValue());
        }
    }

    public FormBean initFormDefinition(CAPFormDefinition formDefinition, FormOwner owner) throws BusinessException {
        FormBean formBean = new FormBean();
        formBean.setId(formDefinition.getId());
        formBean.setFormName(formDefinition.getName());
        formBean.setCategoryId(formDefinition.getCategoryId().longValue());
        formBean.setState(formDefinition.getState().intValue());
        formBean.setCreateDate(formDefinition.getCreateTime());
        formBean.setModifyDate(formDefinition.getModifyTime());
        formBean.setUseFlag(formDefinition.getUseFlag().intValue());
        formBean.setPublishFlag(formDefinition.getPublishFlag().intValue());
        formBean.setFormType(formDefinition.getFormType().intValue());
        formBean.setCreatorId(formDefinition.getCreateId().longValue());
        if (owner != null) {
            formBean.setOwnerId(owner.getOwnerId().longValue());
        }
        for (CAP4FormDefinitionInitManager initManager : this.enginInit) {
            if (initManager == null) continue;
            initManager.initDefinitionAttr(formBean, formDefinition);
        }
        List customList = (List)this.formCustomFunctions.get(formBean.getId());
        ArrayList<FormCustomFunction> newCustomList = new ArrayList<FormCustomFunction>();
        if (customList != null) {
            for (FormCustomFunction customBean : customList) {
                try {
                    FormCustomFunction cloneCustom = (FormCustomFunction)customBean.clone();
                    newCustomList.add(cloneCustom);
                }
                catch (CloneNotSupportedException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        formBean.setCustomFunctionList(newCustomList);
        this.forms.put(formBean.getId(), formBean);
        return formBean;
    }

    private void initFormDefinitionAPP(CAPFormDefinition formDefinition) throws BusinessException {
        List<FormConditionActionBean> checkRuleList;
        FormBean formBean = (FormBean)this.forms.get(formDefinition.getId());
        if (null == formBean) {
            LOGGER.error((Object)("\u8868\u5355\u542f\u52a8\u51fa\u9519\uff0c\u51fa\u9519\u8868\u5355id\uff1a" + formDefinition.getId()));
            return;
        }
        FormCheckRuleBean checkRuleBean = formBean.getCheckRuleBean();
        if (checkRuleBean == null) {
            checkRuleBean = new FormCheckRuleBean(formBean);
            formBean.setCheckRuleBean(checkRuleBean);
        }
        if (Strings.isNotEmpty(checkRuleList = this.getFormCheckRule(formDefinition.getId()))) {
            checkRuleBean.setCheckRuleList(checkRuleList);
        }
        if (Strings.isNotEmpty(this.appInit)) {
            for (CAP4FormDefinitionInitManager app : this.appInit) {
                if (app == null) continue;
                app.initDefinitionAttr(formBean, formDefinition);
            }
        }
        if (!StringUtil.checkNull((String)formDefinition.getExtensionsInfo())) {
            Object formAuthTo;
            Map extendInfo = (Map)JSONUtil.parseJSONString((String)formDefinition.getExtensionsInfo());
            if (extendInfo.get("checkRuleList") != null) {
                Map checkRuleObj = (Map)extendInfo.get("checkRuleList");
                Map checkRules = new HashMap();
                boolean newCheckRule = true;
                try {
                    checkRules = (Map)JSONUtil.parseJSONString((String)checkRuleObj.get("checkRules").toString());
                }
                catch (Exception e) {
                    newCheckRule = false;
                    LOGGER.error((Object)"\u6821\u9a8c\u89c4\u5219\u4e3a\u65e7\u7684");
                }
                if (newCheckRule) {
                    Object forceCheckObj = checkRules.get("forceCheck");
                    Object showDetailObj = checkRules.get("showDetail");
                    Object remarkObj = checkRules.get("remark");
                    checkRuleBean.setForceCheck(Integer.parseInt(forceCheckObj.toString()));
                    checkRuleBean.setShowDetail(Integer.parseInt(showDetailObj.toString()));
                    checkRuleBean.setRemark(remarkObj == null ? "" : remarkObj.toString());
                } else if (Strings.isNotEmpty((Collection)checkRuleBean.getCheckRuleList())) {
                    FormConditionActionBean checkRuleCon = (FormConditionActionBean)checkRuleBean.getCheckRuleList().get(0);
                    checkRuleBean.setForceCheck(checkRuleCon.getForceCheck().intValue());
                    checkRuleBean.setShowDetail(checkRuleCon.getShowDetail());
                    checkRuleBean.setRemark("");
                } else {
                    checkRuleBean.setForceCheck(1);
                    checkRuleBean.setShowDetail(1);
                    checkRuleBean.setRemark("");
                }
            }
            if (extendInfo.get("uniqueFieldLists") != null) {
                List unique = (List)extendInfo.get("uniqueFieldLists");
                formBean.setUniqueFieldList(unique);
            }
            if (extendInfo.get("advancedSettings") != null) {
                Map advancedSettings = (Map)extendInfo.get("advancedSettings");
                formBean.setAdvancedSet(advancedSettings);
            }
            if (extendInfo.get("formAttribute") != null) {
                String formAttribute = extendInfo.get("formAttribute").toString();
                formBean.setFormAttribute(BusinessEnums.FormAttribute.getEnumByKey((String)formAttribute));
            }
            if (!StringUtil.checkNull((String)String.valueOf(formAuthTo = extendInfo.get("formAuthTo")))) {
                formBean.setFormAuthTo(String.valueOf(formAuthTo));
            }
        }
    }

    void initAllForm() throws BusinessException {
        ExecutorService definitionExecutor = Executors.newFixedThreadPool(this.coreThreadSize, this.initThreadFactory);
        List<CAPFormDefinition> formDefinitionList = this.cap4FormDefinitionDAO.selectAll();
        List owners = this.formOwnerDAO.selectAllByVersion("4.0");
        for (Object owner : owners) {
            this.ownerMap.put(owner.getFormId(), owner);
        }
        CountDownLatch countDownLatch = new CountDownLatch(formDefinitionList.size());
        LOGGER.info((Object)"\u521d\u59cb\u5316cap_form_definition\u5f00\u59cb");
        for (CAPFormDefinition definition : formDefinitionList) {
            definitionExecutor.submit(new DefinitionInitRunner(this, definition, countDownLatch));
        }
        definitionExecutor.shutdown();
        try {
            countDownLatch.await();
            LOGGER.info((Object)"\u521d\u59cb\u5316cap_form_definition\u7ed3\u675f");
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        for (CAPFormDefinition formDefinition : formDefinitionList) {
            this.initFormDefinitionAPP(formDefinition);
        }
    }

    public <T> List<T>[] splitList(List<T> list, int pageSize) {
        int total = list.size();
        int pageCount = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        List[] result = new List[pageCount];
        for (int i = 0; i < pageCount; ++i) {
            List<T> subList;
            int start = i * pageSize;
            int end = start + pageSize > total ? total : start + pageSize;
            result[i] = subList = list.subList(start, end);
        }
        return result;
    }

    void initAllFormCustomFunction() throws BusinessException {
        long start = System.currentTimeMillis();
        List formCustomFunctionList = this.formCustomFunctionDAO.selectAllByVersion("4.0");
        long end1 = System.currentTimeMillis();
        LOGGER.info((Object)("\u67e5\u8be2\u81ea\u5b9a\u4e49\u51fd\u6570\u8017\u65f6" + (end1 - start)));
        if (formCustomFunctionList != null) {
            for (FormCustomFunction customFunction : formCustomFunctionList) {
                if (customFunction == null) continue;
                ArrayList<FormCustomFunction> cacheList = (ArrayList<FormCustomFunction>)this.formCustomFunctions.get(customFunction.getFormId());
                if (cacheList == null) {
                    cacheList = new ArrayList<FormCustomFunction>();
                }
                cacheList.add(customFunction);
                this.formCustomFunctions.put(customFunction.getFormId(), cacheList);
            }
        }
        long end2 = System.currentTimeMillis();
        LOGGER.info((Object)("\u52a0\u8f7d\u81ea\u5b9a\u4e49\u51fd\u6570\u8017\u65f6\uff1a" + (end2 - end1)));
    }

    void initAllFormCustomFunction(Long formId) throws BusinessException {
        List formCustomFunctionList = this.formCustomFunctionDAO.selectByFormId(formId);
        if (formCustomFunctionList != null) {
            this.formCustomFunctions.put(formId, formCustomFunctionList);
        }
    }

    void initAllFormResource() throws BusinessException {
        List<CAPFormResource> formAppResourceList = this.cap4FormResourceDAO.selectAll();
        ExecutorService resourceExecutor = Executors.newFixedThreadPool(this.coreThreadSize, this.initThreadFactory);
        List<CAPFormResource>[] resourceLists = this.splitList(formAppResourceList, 200);
        CountDownLatch countDownLatch = new CountDownLatch(resourceLists.length);
        LOGGER.info((Object)"\u521d\u59cb\u5316cap_form_resource\u5f00\u59cb");
        for (List<CAPFormResource> resources : resourceLists) {
            resourceExecutor.submit(new ResourceInitRunner(this, resources, countDownLatch));
        }
        resourceExecutor.shutdown();
        try {
            countDownLatch.await();
            LOGGER.info((Object)"\u521d\u59cb\u5316cap_form_resource\u7ed3\u675f");
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    void initFormFormulaBean4Formula() {
        ArrayList allConditionActionBean = new ArrayList();
        for (Map.Entry authFormula : this.authConditions.entrySet()) {
            allConditionActionBean.addAll((Collection)authFormula.getValue());
        }
        for (Map.Entry checkRule : this.formCheckRules.entrySet()) {
            allConditionActionBean.addAll((Collection)checkRule.getValue());
        }
        for (Map.Entry fieldFormula : this.fieldFormulaConditions.entrySet()) {
            allConditionActionBean.addAll((Collection)fieldFormula.getValue());
        }
        List<E>[] conditionActionBeanLists = this.splitList(allConditionActionBean, 500);
        final CountDownLatch countDownLatch = new CountDownLatch(conditionActionBeanLists.length);
        ExecutorService formulaExecutor = Executors.newFixedThreadPool(this.coreThreadSize, this.initThreadFactory);
        LOGGER.info((Object)("\u8ba1\u7b97\u516c\u5f0f\u4e2a\u6570\uff1a" + allConditionActionBean.size()));
        LOGGER.info((Object)"\u521d\u59cb\u5316CAP4\u8ba1\u7b97\u516c\u5f0f\u5f00\u59cb");
        for (final List conditionActionBeanList : conditionActionBeanLists) {
            formulaExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (FormConditionActionBean formConditionActionBean : conditionActionBeanList) {
                            CAP4FormCacheManager.this.loadFormFormulaBean(formConditionActionBean);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        formulaExecutor.shutdown();
        try {
            countDownLatch.await();
            LOGGER.info((Object)"\u521d\u59cb\u5316CAP4\u8ba1\u7b97\u516c\u5f0f\u7ed3\u675f");
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    void initFormFormulaBean4Formula(Long formId) {
        List checkRules;
        List authList = (List)this.authConditions.get(formId);
        if (Strings.isNotEmpty((Collection)authList)) {
            for (FormConditionActionBean fcab : authList) {
                this.loadFormFormulaBean(fcab);
            }
        }
        if (Strings.isNotEmpty((Collection)(checkRules = (List)this.formCheckRules.get(formId)))) {
            for (FormConditionActionBean formConditionActionBean : checkRules) {
                this.loadFormFormulaBean(formConditionActionBean);
            }
        }
        block2: for (Map.Entry entry : this.fieldFormulaConditions.entrySet()) {
            List fieldList = (List)entry.getValue();
            for (int i = 0; fieldList != null && i < fieldList.size(); ++i) {
                FormConditionActionBean fcab = (FormConditionActionBean)fieldList.get(i);
                if (formId != null && fcab.getOwnerId().longValue() != formId.longValue()) continue block2;
                this.loadFormFormulaBean(fcab);
            }
        }
    }

    private void loadFormFormulaBean(FormConditionActionBean fcab) {
        try {
            FormBean formBean = this.getForm(fcab.getOwnerId());
            if (formBean != null) {
                fcab.setConditionFormulaBean(this.loadFormFormulaBean(formBean, fcab.getConditionId()));
                if (Enums.FormulaConditionType.FORM_AUTHORITY.getKey() != fcab.getActionType().intValue()) {
                    fcab.setActionFormulaBean(this.loadFormFormulaBean(formBean, fcab.getActionId()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u521d\u59cb\u5316\u8ba1\u7b97\u5f0f formulaBean\u5bf9\u8c61\u5f02\u5e38\uff1a" + fcab.getId()), (Throwable)e);
        }
    }

    void initAllFormConditionAction() throws BusinessException {
        long start = System.currentTimeMillis();
        List ctpFormulaConditionList = this.formulaConditionDAO.selectAllByVersion("4.0");
        long end1 = System.currentTimeMillis();
        LOGGER.info((Object)("\u67e5\u8be2cap4\u6761\u4ef6\u5f0f\u8017\u65f6\uff1a" + (end1 - start)));
        this.initConditionActionCache(ctpFormulaConditionList);
        long end2 = System.currentTimeMillis();
        LOGGER.info((Object)("\u52a0\u8f7dcap4\u6761\u4ef6\u5f0f\u8017\u65f6\uff1a" + (end2 - end1)));
    }

    public void initFormConditionAction(Long formId) throws BusinessException {
        List ctpFormulaConditionList = this.formulaConditionDAO.selectByModuleId(formId);
        this.initConditionActionCache(ctpFormulaConditionList);
    }

    private void initConditionActionCache(List<CtpFormulaCondition> ctpFormulaConditionList) {
        Long ownerId;
        List valList;
        ConcurrentHashMap formulaTempMap = null;
        ConcurrentHashMap<Long, List<FormConditionActionBean>> authTempMap = null;
        ConcurrentHashMap<Long, List<FormConditionActionBean>> checkTempMap = null;
        for (CtpFormulaCondition ctpFormulaCondition : ctpFormulaConditionList) {
            Long tempId;
            List<FormConditionActionBean> tempList;
            ArrayList<CtpFormula> allCtpFormulaList = new ArrayList<CtpFormula>();
            FormConditionActionBean formConditionActionBean = new FormConditionActionBean();
            formConditionActionBean.setId(ctpFormulaCondition.getId());
            formConditionActionBean.setSerialNumber(ctpFormulaCondition.getSerialNumber());
            formConditionActionBean.setActionType(ctpFormulaCondition.getActionType());
            formConditionActionBean.setKeyword(ctpFormulaCondition.getKeyword());
            formConditionActionBean.setConditionId(ctpFormulaCondition.getCondtionId());
            formConditionActionBean.setActionId(ctpFormulaCondition.getActionId());
            formConditionActionBean.setFieldId(ctpFormulaCondition.getFieldId());
            formConditionActionBean.setOwnerId(ctpFormulaCondition.getOwnerId());
            formConditionActionBean.setSortNumber(ctpFormulaCondition.getSortNumber());
            formConditionActionBean.setForceCheck(ctpFormulaCondition.getForceCheck());
            formConditionActionBean.setShowDetail(ctpFormulaCondition.getShowDetail());
            int actionType = ctpFormulaCondition.getActionType();
            if (this.getFormula(formConditionActionBean.getConditionId()) != null) {
                allCtpFormulaList.add(this.getFormula(formConditionActionBean.getConditionId()));
            }
            if (this.getFormula(formConditionActionBean.getActionId()) != null) {
                allCtpFormulaList.add(this.getFormula(formConditionActionBean.getActionId()));
            }
            formConditionActionBean.setAllFormulaList(allCtpFormulaList);
            if (Enums.FormulaConditionType.FORM_CACULATE.getKey() == actionType) {
                if (null == formulaTempMap) {
                    formulaTempMap = new ConcurrentHashMap();
                }
                if (null == (tempList = (ArrayList<FormConditionActionBean>)formulaTempMap.get(tempId = formConditionActionBean.getFieldId()))) {
                    tempList = new ArrayList<FormConditionActionBean>();
                    formulaTempMap.put(tempId, tempList);
                }
                if (tempList.contains(formConditionActionBean)) continue;
                tempList.add(formConditionActionBean);
                continue;
            }
            if (Enums.FormulaConditionType.FORM_AUTHORITY.getKey() == actionType) {
                if (null == authTempMap) {
                    authTempMap = new ConcurrentHashMap<Long, List<FormConditionActionBean>>();
                }
                if (null == (tempList = (List)authTempMap.get(tempId = formConditionActionBean.getOwnerId()))) {
                    tempList = new ArrayList();
                    authTempMap.put(tempId, tempList);
                }
                if (tempList.contains(formConditionActionBean)) continue;
                tempList.add(formConditionActionBean);
                continue;
            }
            if (Enums.FormulaConditionType.FORM_CHECK.getKey() != actionType) continue;
            if (null == checkTempMap) {
                checkTempMap = new ConcurrentHashMap<Long, List<FormConditionActionBean>>();
            }
            if ((tempId = formConditionActionBean.getOwnerId()) == null) {
                LOGGER.info((Object)("\u516c\u5f0fownerId\u7a7a\u5f02\u5e38\u3002id = " + ctpFormulaCondition.getId() + " createUser = " + ctpFormulaCondition.getCreateUser() + " createDate = " + ctpFormulaCondition.getCreateDate()));
            }
            if (null == (tempList = (List)checkTempMap.get(tempId))) {
                tempList = new ArrayList();
                checkTempMap.put(tempId, tempList);
            }
            if (tempList.contains(formConditionActionBean)) continue;
            tempList.add(formConditionActionBean);
        }
        if (null != formulaTempMap) {
            for (Map.Entry entry : formulaTempMap.entrySet()) {
                Long fieldId = (Long)entry.getKey();
                valList = (List)entry.getValue();
                this.fieldFormulaConditions.remove(fieldId);
                this.fieldFormulaConditions.put(fieldId, valList);
            }
        }
        if (null != authTempMap) {
            for (Map.Entry entry : authTempMap.entrySet()) {
                ownerId = (Long)entry.getKey();
                valList = (List)entry.getValue();
                this.authConditions.remove(ownerId);
                this.authConditions.put(ownerId, valList);
            }
        }
        if (null != checkTempMap) {
            for (Map.Entry entry : checkTempMap.entrySet()) {
                ownerId = (Long)entry.getKey();
                valList = (List)entry.getValue();
                this.formCheckRules.remove(ownerId);
                this.formCheckRules.put(ownerId, valList);
            }
        }
    }

    void initAllFormFormula() throws BusinessException {
        long start = System.currentTimeMillis();
        List formFormulas = this.formulaDAO.selectAllByVersion("4.0");
        for (CtpFormula tempFormula : formFormulas) {
            this.formulas.put(tempFormula.getId(), tempFormula);
        }
        long end = System.currentTimeMillis();
        LOGGER.info((Object)("\u67e5\u8be2cap4\u516c\u5f0f\u8017\u65f6\uff1a" + (end - start)));
    }

    void initFormFormula(Long formId) throws BusinessException {
        List formFormulas = this.formulaDAO.selectByModuleId(formId);
        for (CtpFormula tempFormula : formFormulas) {
            this.formulas.put(tempFormula.getId(), tempFormula);
        }
    }

    void initAllFormRelation() throws BusinessException {
        long start = System.currentTimeMillis();
        List formRelations = this.formRelationDAO.selectAllByVersion("4.0");
        long end = System.currentTimeMillis();
        LOGGER.info((Object)("\u67e5\u8be2\u8868\u5185\u5173\u8054\u5173\u7cfb\u4fe1\u606f\u8017\u65f6\uff1a" + (end - start)));
        for (FormRelation tempRelation : formRelations) {
            this.relations.put(tempRelation.getId(), tempRelation);
        }
        long end1 = System.currentTimeMillis();
        LOGGER.info((Object)("\u52a0\u8f7d\u8868\u5185\u5173\u8054\u4fe1\u606f\u8017\u65f6\uff1a" + (end1 - end)));
    }

    void initFormRelation(Long formId) throws BusinessException {
        List formRelations = this.formRelationDAO.selectByModuleId(formId);
        for (FormRelation tempRelation : formRelations) {
            this.relations.put(tempRelation.getId(), tempRelation);
        }
    }

    void initFormBusinessRelation() throws BusinessException {
        List<CAPFormBusinessRelation> relationList = this.cap4FormBusinessRelationDAO.selectAll();
        this.initFormBusinessRelation(relationList);
    }

    void initFormBusinessRelation(Long formId) throws BusinessException {
        List<CAPFormBusinessRelation> relationList = this.cap4FormBusinessRelationDAO.selectAll(formId);
        FormBean formBean = this.getForm(formId);
        if (Strings.isNotEmpty(relationList)) {
            formBean.resetAllFieldBeanRelationInfo();
            this.initFormBusinessRelation(relationList);
        }
        if (Strings.isNotEmpty(relationList = this.cap4FormBusinessRelationDAO.selectByTargetFormId(formId))) {
            block0: for (CAPFormBusinessRelation relation : relationList) {
                boolean needCheck;
                FormTriggerBean triggerBean;
                if (!Enums.FormBusinessRelationType.TRIGGER.getKey().equals(relation.getType()) || (triggerBean = this.getFormTriggerBean(relation.getId())) == null) continue;
                boolean isTargetForm = formBean.getId().equals(triggerBean.getTargetFormId());
                boolean bl = needCheck = FormTriggerBean.TriggerBusinessType.FormOuter.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.DataInterface.getKey().equals(triggerBean.getType());
                if (!isTargetForm || !needCheck) continue;
                for (FormTriggerActionBean actionBean : triggerBean.getActionList()) {
                    boolean isDistribution = FormTriggerBean.TriggerType.Distribution.getKey().equals(actionBean.getType());
                    if (!isDistribution) {
                        boolean bl2 = isDistribution = actionBean.getParam("triggerType") != null && FormTriggerBean.TriggerType.Distribution.getKey().equals(actionBean.getParam("triggerType"));
                    }
                    if (!isDistribution || actionBean.getParam(FormTriggerBean.ActionParam.FeedBack.getKey()) == null || ((List)actionBean.getParam(FormTriggerBean.ActionParam.FeedBack.getKey())).size() <= 0) continue;
                    formBean.addFormTriggerSet(relation.getId());
                    continue block0;
                }
            }
        }
    }

    private void initFormBusinessRelation(List<CAPFormBusinessRelation> relationList) {
        for (CAPFormBusinessRelation relation : relationList) {
            FormBean formBean = this.getForm(relation.getSourceFormId());
            if (formBean == null) {
                LOGGER.info((Object)("\u521d\u59cb\u5316\u5173\u7cfb\u51fa\u73b0\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u8868\u5355\uff1aid=" + relation.getSourceFormId()));
                continue;
            }
            try {
                if (Enums.FormBusinessRelationType.RELATION.getKey().equals(relation.getType())) {
                    List relationMapList;
                    FormRelationshipBean relationshipBean = new FormRelationshipBean(relation);
                    this.formRelationshipMap.put(relationshipBean.getId(), relationshipBean);
                    formBean.getFormRelationshipIdList().add(relation.getId());
                    if (relationshipBean.getRelationType() != FormRelationEnums.ViewSelectType.system.getKey() || (relationMapList = relationshipBean.getRelationMapList()).size() <= 0) continue;
                    Map conditionMap = FormUtil.getRelationFormulaFieldMap((FormFormulaBean)((FormRelationshipMapBean)relationMapList.get(0)).getConditionFormula());
                    for (String fName : conditionMap.keySet()) {
                        FormFieldBean field = formBean.getFieldBeanByName(fName);
                        if (field == null) continue;
                        field.setInRelationCondition(true);
                    }
                    continue;
                }
                FormTriggerBean triggerBean = new FormTriggerBean(relation);
                this.formTriggerMap.put(triggerBean.getId(), triggerBean);
                formBean.addFormTriggerSet(relation.getId());
            }
            catch (Exception e) {
                LOGGER.info((Object)("\u52a0\u8f7d\u4e1a\u52a1\u5173\u7cfb\u5f02\u5e38\uff1aid=" + relation.getId() + ";msg:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public FormFormulaBean loadFormFormulaBean(FormBean formBean, Long formulaId) throws BusinessException {
        if (formulaId == 0L) {
            return null;
        }
        CtpFormula formulaPO = (CtpFormula)this.formulas.get(formulaId);
        if (formulaPO == null) {
            formulaPO = this.formulaDAO.selectById(formulaId);
        }
        return this.loadFormFormulaBean(formBean, formulaPO);
    }

    public FormFormulaBean loadFormFormulaBean(FormBean formBean, CtpFormula formulaPO) throws BusinessException {
        FormFormulaBean formulaBean = new FormFormulaBean(formBean);
        if (formulaPO != null) {
            try {
                if (!Strings.isNotBlank((String)formulaPO.getExpressionXml())) {
                    return null;
                }
                Document doc = XXEUtil.safeParseText((String)formulaPO.getExpressionXml());
                Element formulaElm = doc.getRootElement();
                formulaBean.loadFromXml(formBean, formulaElm);
                formulaBean.setFormulaDescription(formulaPO.getDescription());
            }
            catch (DocumentException e) {
                LOGGER.error((Object)formulaPO.getExpressionXml(), (Throwable)e);
            }
            catch (BusinessException ex) {
                LOGGER.error((Object)formulaPO.getExpressionXml(), (Throwable)ex);
            }
            return formulaBean;
        }
        return null;
    }

    public FormRelation loadFormRelationBean(Long relationId) throws BusinessException {
        FormRelation formRelation = (FormRelation)this.relations.get(relationId);
        if (formRelation != null) {
            return formRelation;
        }
        return null;
    }

    public FormConditionActionBean getFormAuthFormulaCondtionBean(Long formId, Long conditionId) {
        FormConditionActionBean returnBean = null;
        List conditionList = (List)this.authConditions.get(formId);
        if (conditionList != null && conditionList.size() > 0) {
            for (FormConditionActionBean fcabBean : conditionList) {
                if (conditionId == null || fcabBean == null || fcabBean.getId() == null || conditionId.longValue() != fcabBean.getId().longValue()) continue;
                returnBean = fcabBean;
                break;
            }
        } else {
            LOGGER.info((Object)("formId:" + formId + "\u8868\u5355\u8ba1\u7b97\u5f0f\u4e0d\u5b58\u5728\uff01"));
        }
        return returnBean;
    }

    public List<FormBean> getRelationFormList(Long formId) {
        ArrayList<FormBean> list = new ArrayList<FormBean>();
        FormBean formBean = this.getForm(formId);
        if (formBean != null) {
            for (FormFieldBean fieldBean : formBean.getAllFieldBeans()) {
                FormBean relFormBean;
                Long relFormId;
                FormRelation formRelation = fieldBean.getFormRelation();
                if (formRelation == null || (relFormId = formRelation.getToRelationObj()) == null || (relFormBean = this.getForm(relFormId)) == null) continue;
                String shortName = relFormBean.getShortName();
                relFormBean.putExtraAttr("shortName", shortName.replace("a", "b"));
                list.add(relFormBean);
            }
        }
        return list;
    }

    public boolean isEnabled(Long formId) {
        FormBean formBean = this.getForm(formId);
        if (formBean == null) {
            formBean = this.getForm(AppContext.currentUserId());
        }
        if (formBean == null) {
            return false;
        }
        return this.isEnabled(formBean);
    }

    public boolean isEnabled(FormBean formBean) {
        if (formBean == null) {
            return false;
        }
        if (!Enums.FormType.canUse((int)formBean.getFormType())) {
            return false;
        }
        return formBean.getState() == Enums.FormStateEnum.official.getKey() && formBean.getUseFlag() == Enums.FormUseFlagEnum.enabled.getKey();
    }

    public boolean isSystemDisabledForm(FormBean formBean) {
        return formBean == null || formBean.getUseFlag() == Enums.FormUseFlagEnum.systemDisabled.getKey();
    }

    public boolean isFormOwner(FormBean formBean) throws BusinessException {
        return this.isFormOwner(formBean, AppContext.currentUserId());
    }

    public boolean isFormOwner(FormBean formBean, Long userId) throws BusinessException {
        FormOwner formOwner = this.getFormOwner(formBean.getId());
        return FormUtil.isRightEditForm((long)userId, (FormOwner)formOwner);
    }

    private void updateFormCodeMap(Long formId) {
        if (this.formCodeMap.isEmpty()) {
            return;
        }
        for (Map.Entry et : this.formCodeMap.entrySet()) {
            if (!((Long)et.getValue()).equals(formId)) continue;
            this.formCodeMap.remove(et.getKey());
        }
    }

    public FormBean getFormByFormCode(String formCode) {
        Long beanId;
        if (Strings.isBlank((String)formCode)) {
            return null;
        }
        FormBean bean = null;
        if (this.formCodeMap != null && (beanId = (Long)this.formCodeMap.get(formCode)) != null) {
            bean = this.getForm(beanId);
        }
        if (!this.isEnabled(bean)) {
            bean = null;
        }
        if (bean == null) {
            TemplateManager templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
            CtpTemplate template = templateManager.getTempleteByTemplateNumber(formCode);
            if (template != null) {
                FormBean tempBean = this.getForm(template.getFormAppId());
                if (this.isEnabled(tempBean)) {
                    bean = tempBean;
                    this.formCodeMap.put(formCode, tempBean.getId());
                }
            } else {
                for (Map.Entry formEntry : this.forms.entrySet()) {
                    String tempFormCode;
                    FormBean tempBean = (FormBean)formEntry.getValue();
                    FormBindBean formBindBean = tempBean.getBind();
                    if (!this.isEnabled(tempBean) || formBindBean == null || tempBean.getFormType() != Enums.FormType.unFlowForm.getKey() || !Strings.isNotBlank((String)(tempFormCode = formBindBean.getFormCode()))) continue;
                    if (formCode.equals(formBindBean.getFormCode())) {
                        bean = tempBean;
                        this.formCodeMap.put(formCode, tempBean.getId());
                        break;
                    }
                    this.formCodeMap.put(tempFormCode, tempBean.getId());
                }
            }
        }
        return bean;
    }

    public FormBean getFormByTemplate(CtpTemplate ctpTemplate) throws BusinessException {
        CtpContentAll content;
        long formId;
        Long beanId;
        if (ctpTemplate == null) {
            return null;
        }
        FormBean bean = null;
        String formCode = ctpTemplate.getTempleteNumber();
        if (this.formCodeMap != null && (beanId = (Long)this.formCodeMap.get(formCode)) != null) {
            bean = this.getForm(beanId);
        }
        if (!this.isEnabled(bean)) {
            bean = null;
        }
        if (bean == null && (bean = (FormBean)this.forms.get(formId = (content = (CtpContentAll)DBAgent.get(CtpContentAll.class, (Serializable)ctpTemplate.getBody())).getContentTemplateId().longValue())) != null && !StringUtil.checkNull((String)formCode)) {
            this.formCodeMap.put(formCode, bean.getId());
        }
        return bean;
    }

    public void removeFormCodeCache(String formCode) {
        if (Strings.isNotBlank((String)formCode)) {
            this.formCodeMap.remove(formCode);
        }
    }

    public FormBean getFormByFormTableName(String tableName) {
        FormTableBean tableBean;
        FormBean formBean = null;
        if (Strings.isNotBlank((String)tableName) && (tableBean = (FormTableBean)this.tables.get(tableName)) != null) {
            formBean = this.getForm(tableBean.getFormId());
        }
        return formBean;
    }

    public CAP4FormResourceDAO getCap4FormResourceDAO() {
        return this.cap4FormResourceDAO;
    }

    public void setCap4FormResourceDAO(CAP4FormResourceDAO cap4FormResourceDAO) {
        this.cap4FormResourceDAO = cap4FormResourceDAO;
    }

    public SerialNumberDAO getSerialNumberDAO() {
        return this.serialNumberDAO;
    }

    public void setSerialNumberDAO(SerialNumberDAO serialNumberDAO) {
        this.serialNumberDAO = serialNumberDAO;
    }

    public CAP4FormDefinitionDAO getCap4FormDefinitionDAO() {
        return this.cap4FormDefinitionDAO;
    }

    public void setCap4FormDefinitionDAO(CAP4FormDefinitionDAO cap4FormDefinitionDAO) {
        this.cap4FormDefinitionDAO = cap4FormDefinitionDAO;
    }

    public FormOwnerDAO getFormOwnerDAO() {
        return this.formOwnerDAO;
    }

    public void setFormOwnerDAO(FormOwnerDAO formOwnerDAO) {
        this.formOwnerDAO = formOwnerDAO;
    }

    public CAP4FormDataDAO getCap4FormDataDAO() {
        return this.cap4FormDataDAO;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public FormTableValueSignDAO getFormTableValueSignDAO() {
        return this.formTableValueSignDAO;
    }

    public void setFormTableValueSignDAO(FormTableValueSignDAO formTableValueSignDAO) {
        this.formTableValueSignDAO = formTableValueSignDAO;
    }

    public FormulaDAO getFormulaDAO() {
        return this.formulaDAO;
    }

    public void setFormulaDAO(FormulaDAO formulaDAO) {
        this.formulaDAO = formulaDAO;
    }

    public FormRelationDAO getRelationDAO() {
        return this.formRelationDAO;
    }

    public void setRelationDAO(FormRelationDAO formRelationDAO) {
        this.formRelationDAO = formRelationDAO;
    }

    public FormAuthModuleDAO getFormAuthModuleDAO() {
        return this.formAuthModuleDAO;
    }

    public void setFormAuthModuleDAO(FormAuthModuleDAO formAuthModuleDAO) {
        this.formAuthModuleDAO = formAuthModuleDAO;
    }

    public FormulaConditionDAO getFormulaConditionDAO() {
        return this.formulaConditionDAO;
    }

    public void setFormulaConditionDAO(FormulaConditionDAO formulaConditionDAO) {
        this.formulaConditionDAO = formulaConditionDAO;
    }

    public FormCustomFunctionDAO getFormCustomFunctionDAO() {
        return this.formCustomFunctionDAO;
    }

    public void setFormCustomFunctionDAO(FormCustomFunctionDAO formCustomFunctionDAO) {
        this.formCustomFunctionDAO = formCustomFunctionDAO;
    }

    public CAP4FormListManager getCap4FormListManager() {
        return this.cap4FormListManager;
    }

    public void setCap4FormListManager(CAP4FormListManager cap4FormListManager) {
        this.cap4FormListManager = cap4FormListManager;
    }

    public void setAppInit(List<CAP4FormDefinitionInitManager> appInit) {
        this.appInit = appInit;
    }

    public void setEnginInit(List<CAP4FormDefinitionInitManager> enginInit) {
        this.enginInit = enginInit;
    }

    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public CAP4FormBusinessRelationDAO getCap4FormBusinessRelationDAO() {
        return this.cap4FormBusinessRelationDAO;
    }

    public void setCap4FormBusinessRelationDAO(CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO) {
        this.cap4FormBusinessRelationDAO = cap4FormBusinessRelationDAO;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public ControlManager getControlManager() {
        return this.controlManager;
    }

    public void setControlManager(ControlManager controlManager) {
        this.controlManager = controlManager;
    }
}

