/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.service;

import com.seeyon.apps.collaboration.enums.ColHandleType;
import com.seeyon.apps.collaboration.po.ColSummary;
import com.seeyon.apps.index.bo.AuthorizationInfo;
import com.seeyon.apps.seeyonreport.api.SeeyonreportApi;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormAuthorizationTableBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormCheckRuleBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTableIndexBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.ImpResultBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormDefinitionDAO;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormResourceDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManager;
import com.seeyon.cap4.form.modules.engin.bind.CAP4FormBindDesignManager;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.modules.engin.formula.CAP4FormCustomFunctionManager;
import com.seeyon.cap4.form.modules.engin.formula.FormulaUtil;
import com.seeyon.cap4.form.modules.engin.formula.validate.FormulaValidate;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.formlist.CAP4FormListManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.serialNumber.CAP4SerialNumberManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.vo.FormDataStateResultVO;
import com.seeyon.cap4.form.vo.FormTreeNode;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.magic.vo.MagicServiceDetail;
import com.seeyon.cap4.template.annotation.RemoveSessionData;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.appLog.AppLogAction;
import com.seeyon.ctp.common.appLog.manager.AppLogManager;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.content.comment.Comment;
import com.seeyon.ctp.common.content.mainbody.MainbodyManager;
import com.seeyon.ctp.common.content.mainbody.MainbodyService;
import com.seeyon.ctp.common.content.mainbody.MainbodyType;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumBindManager;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.lock.manager.LockManager;
import com.seeyon.ctp.common.lock.manager.LockState;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.BasePO;
import com.seeyon.ctp.common.po.DataContainer;
import com.seeyon.ctp.common.po.affair.CtpAffair;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumBean;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumBind;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.common.po.lock.Lock;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.publicqrcode.manager.PublicQrCodeManager;
import com.seeyon.ctp.common.template.manager.ComparatorTemplateBOPub;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.common.template.vo.TemplateCategory;
import com.seeyon.ctp.form.modules.engin.authorization.FormAuthModuleDAO;
import com.seeyon.ctp.form.modules.engin.base.formBase.FormOwnerDAO;
import com.seeyon.ctp.form.modules.engin.base.formBase.FormTableValueSignDAO;
import com.seeyon.ctp.form.modules.engin.formula.FormCustomFunctionDAO;
import com.seeyon.ctp.form.modules.engin.formula.FormulaConditionDAO;
import com.seeyon.ctp.form.modules.engin.formula.FormulaDAO;
import com.seeyon.ctp.form.modules.engin.relation.FormRelationDAO;
import com.seeyon.ctp.form.modules.serialNumber.SerialCalRecordManager;
import com.seeyon.ctp.form.modules.serialNumber.SerialNumberManager;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.form.po.FormModuleAuth;
import com.seeyon.ctp.form.po.FormOwner;
import com.seeyon.ctp.form.po.FormRelation;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.login.online.OnlineManager;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.dao.OrgHelper;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.portal.api.PortalApi;
import com.seeyon.ctp.privilege.manager.PrivilegeMenuManager;
import com.seeyon.ctp.report.utils.ReportDBUtils;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.UniqueList;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.ctp.util.json.mapper.JSONMapper;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.hibernate.dialect.Dialect;

public class CAP4FormManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormManager.class);
    private MainbodyManager ctpMainbodyManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormTableValueSignDAO formTableValueSignDAO;
    private CAP4FormDataDAO cap4FormDataDAO;
    private CAP4FormDataManager cap4FormDataManager;
    private CAP4FormBindDesignManager cap4FormBindDesignManager;
    private CAP4FormListManager cap4FormListManager;
    private LockManager lockManager;
    private OnlineManager onlineManager;
    private TemplateManager templateManager;
    private CAP4FormResourceDAO cap4FormResourceDAO;
    private FormulaDAO formulaDAO;
    private FormulaConditionDAO formulaConditionDAO;
    private FormOwnerDAO formOwnerDAO;
    private FormRelationDAO formRelationDAO;
    private FormCustomFunctionDAO formCustomFunctionDAO;
    private SerialNumberManager serialNumberManager;
    private CAP4SerialNumberManager cap4SerialNumberManager;
    private CAP4FormCustomFunctionManager cap4FormCustomFunctionManager;
    private EnumBindManager enumBindManager;
    private CAP4FormDefinitionDAO cap4FormDefinitionDAO;
    private FormAuthModuleDAO formAuthModuleDAO;
    private EnumManager enumManagerNew;
    private PrivilegeMenuManager privilegeMenuManager;
    private CAP4FormDesignManager cap4FormDesignManager;
    private AttachmentManager attachmentManager;
    private PortalApi portalApi;
    private SeeyonreportApi seeyonreportApi;
    private ICAP4MagicManager cap4MagicManager;
    private BusinessManager businessManager4;
    private PublicQrCodeManager publicQrCodeManager;
    public static final String FORM_ADVANCED_PLUGIN_ID = "formAdvanced";
    private static boolean isLog = true;

    public PublicQrCodeManager getPublicQrCodeManager() {
        return this.publicQrCodeManager;
    }

    public void setPublicQrCodeManager(PublicQrCodeManager publicQrCodeManager) {
        this.publicQrCodeManager = publicQrCodeManager;
    }

    public FormBean getEditingForm(Long formId) {
        return this.getEditingForm(isLog, formId);
    }

    public FormBean getEditingForm(boolean needLog, Long formId) {
        return this.cap4FormDesignManager.getEditingForm(needLog, formId);
    }

    public void saveEditingForm(FormBean bean) {
        this.cap4FormDesignManager.saveEditingForm(bean);
    }

    @AjaxAccess
    public void removeEditForm(Long formId) {
        this.cap4FormDesignManager.removeEditForm(isLog, formId);
    }

    @AjaxAccess
    @Deprecated
    public FormBean getForm(Long formId) {
        return this.getForm(formId, true);
    }

    public FormBean getForm(Long formId, boolean needEditing) {
        FormBean bean;
        if (needEditing && (bean = this.getEditingForm(formId)) != null) {
            return bean;
        }
        return this.cap4FormCacheManager.getForm(formId);
    }

    public FormBean getFormByFormCode(String formCode) throws BusinessException {
        return this.cap4FormCacheManager.getFormByFormCode(formCode);
    }

    public FormBean getFormByFormCode(CtpTemplate ctpTemplate) throws BusinessException {
        return this.cap4FormCacheManager.getFormByTemplate(ctpTemplate);
    }

    public void mergeFormData(FormDataMasterBean masterData, FormDataMasterBean cacheData, FormBean formBean) {
        this.cap4FormDataManager.mergeFormData(masterData, cacheData, formBean);
    }

    public FlipInfo getFormMasterDataListByFormId(FlipInfo flipInfo, Map<String, Object> params) throws BusinessException, SQLException {
        try {
            flipInfo = this.getFormMasterDataListByFormId(flipInfo, params, false);
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u65e0\u6d41\u7a0b\u6570\u636e\u67e5\u8be2\u62a5\u9519\uff1a" + e.getMessage()), (Throwable)e);
        }
        return flipInfo;
    }

    public FlipInfo getFormMasterDataListByFormId(FlipInfo flipInfo, Map<String, Object> params, boolean isExport) throws BusinessException, SQLException {
        return this.cap4FormDataManager.getFormMasterDataListByFormId(flipInfo, params, isExport);
    }

    public String getFormatDateValStr(Map<String, Object> params) throws Exception {
        DataContainer dc = new DataContainer();
        Long formId = ParamUtil.getLong(params, (String)"formId", (Long)0L);
        String fieldName = ParamUtil.getString(params, (String)"fieldName");
        String value = ParamUtil.getString(params, (String)"value");
        if (!StringUtil.checkNull((String)value)) {
            FormBean formBean = this.getForm(formId);
            FormFieldBean field = formBean.getFieldBeanByName(fieldName);
            Object[] objs = field.getDisplayValue((Object)value);
            dc.put("result", (Object)String.valueOf(objs[1]));
        } else {
            dc.put("result", (Object)"");
        }
        return dc.getJson();
    }

    public List<CtpContentAll> getViewList(ModuleType moduleType, Long formId) throws BusinessException {
        ArrayList<CtpContentAll> contentList = new ArrayList<CtpContentAll>();
        List formViewList = this.getForm(formId).getFormViewList();
        for (FormViewBean formViewBean : formViewList) {
            CtpContentAll contentAll = new CtpContentAll();
            contentAll.setTitle(formViewBean.getFormViewName());
            contentAll.setContentTemplateId(formId);
            contentAll.setModuleId(formViewBean.getId());
            contentAll.setModuleType(Integer.valueOf(ModuleType.formView.getKey()));
            contentAll.setContent("-1");
            contentAll.setContentType(Integer.valueOf(MainbodyType.FORM.getKey()));
            contentList.add(contentAll);
        }
        return contentList;
    }

    public List<CtpContentAll> getContentList(int moduleType, Long moduleId) throws BusinessException {
        List contentList = MainbodyService.getInstance().getContentList(ModuleType.getEnumByKey((int)moduleType), moduleId.longValue());
        return contentList;
    }

    public boolean delFormData(Long formId, String ids, Long templateId) throws BusinessException, SQLException {
        return this.cap4FormDataManager.delFormData(formId, ids, templateId);
    }

    @AjaxAccess
    public boolean checkLock(Long fromId, String ids) throws BusinessException, SQLException {
        return this.cap4FormDataDAO.findLock(ids, this.cap4FormCacheManager.getForm(fromId).getMasterTableBean().getTableName());
    }

    @AjaxAccess
    public List<Map> getLockState(Long fromId, String ids) throws BusinessException, SQLException {
        return this.cap4FormDataDAO.getLockState(ids, this.cap4FormCacheManager.getForm(fromId).getMasterTableBean().getTableName());
    }

    @AjaxAccess
    public boolean checkDelete(Long formId, String ids) throws BusinessException, SQLException {
        String[] idList = ids.split(",");
        int dbCount = this.cap4FormDataDAO.isExistReturnCount(ids, this.cap4FormCacheManager.getForm(formId).getMasterTableBean().getTableName());
        return dbCount == idList.length;
    }

    public FormDataMasterBean getDataMasterBeanById(Long masterId, FormBean formBean, String[] fields) throws BusinessException, SQLException {
        return this.cap4FormDataDAO.selectDataByMasterId(masterId, formBean, fields);
    }

    public boolean isHasFormDataMaster(FormBean formBean, long masterId) throws BusinessException {
        FormTableBean formTableBean = formBean.getMasterTableBean();
        int count = this.cap4FormDataDAO.selectRecordCount(formTableBean, masterId);
        return count > 0;
    }

    public FormDataStateResultVO updateDataState(ColSummary colSummary, CtpAffair affair, ColHandleType type, List<Comment> list) throws BusinessException, SQLException {
        return this.cap4FormDataManager.updateDataState(colSummary, affair, type, list);
    }

    public String getCollSubjuet(Long formId, String collSubject, Long formRecordid, boolean isForward) throws BusinessException {
        return this.cap4FormBindDesignManager.getCollSubjuet(formId, collSubject, formRecordid, isForward);
    }

    public Object getMasterFieldValue(Long formId, Long masterId, String fieldName, boolean isShowValue, boolean isOrgFormulaValue) throws BusinessException, SQLException {
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        FormDataMasterBean masterBean = this.getDataMasterBeanById(masterId, formBean, new String[]{fieldName});
        Object obj = masterBean.getFieldValue(fieldName);
        FormFieldBean fieldBean = formBean.getFieldBeanByName(fieldName);
        Object[] value = fieldBean.getDisplayValue(obj);
        if (isShowValue) {
            return value[1];
        }
        if (isOrgFormulaValue) {
            return value[2];
        }
        return value[0];
    }

    public void procDefaultValue(Long formId, Long dataId, Long authId, Long moduleId, Object formData) throws SQLException, BusinessException {
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (formBean.isEnabled()) {
            FormDataMasterBean masterBean = null;
            masterBean = this.getSessioMasterDataBean(dataId);
            if (null == masterBean) {
                masterBean = null != formData ? (FormDataMasterBean)formData : this.getDataMasterBeanById(dataId, formBean, null);
            }
            masterBean.putExtraAttr("moduleId", moduleId.longValue());
            FormAuthViewBean auth = formBean.getAuthViewBeanById(authId);
            if (masterBean != null && auth != null) {
                this.cap4FormDataManager.calcAll(formBean, masterBean, auth, false, true, true, true);
                this.cap4FormDataManager.insertOrUpdateMasterData(masterBean);
                LOGGER.info((Object)("procDefaultValue\u66f4\u65b0\u8868\u5355\u6570\u636e\uff1a" + dataId));
                this.procDefaultValueAttachment(masterBean, moduleId);
            }
        }
    }

    private void procDefaultValueAttachment(FormDataMasterBean masterBean, Long moduleId) {
        List attachments = masterBean.getSessionAttachments(null);
        if (Strings.isNotEmpty((Collection)attachments)) {
            List exitsAttachments;
            HashSet<Long> subReferences = new HashSet<Long>();
            for (Attachment attachment : attachments) {
                subReferences.add(attachment.getSubReference());
                attachment.setReference(moduleId);
            }
            if (subReferences.size() > 0 && Strings.isNotEmpty((Collection)(exitsAttachments = this.attachmentManager.getBySubReference(new ArrayList(subReferences))))) {
                ArrayList<Long> exitIds = new ArrayList<Long>();
                for (Attachment attachment : exitsAttachments) {
                    exitIds.add(attachment.getId());
                }
                this.attachmentManager.deleteByIds(exitIds);
                LOGGER.info((Object)("procDefaultValueAttachment moduleId " + moduleId + " , dataId " + masterBean.getId() + ", delete " + exitsAttachments));
            }
            this.attachmentManager.create((Collection)attachments, false);
        }
    }

    public FormDataMasterBean procDefaultValueAsValidate(FormBean formBean, FormDataMasterBean masterBean, FormAuthViewBean auth, Long moduleId) throws BusinessException {
        FormDataMasterBean formMasterData = masterBean;
        formMasterData.putExtraAttr("moduleId", (Object)moduleId);
        if (auth != null) {
            this.cap4FormDataManager.calcAll(formBean, formMasterData, auth, false, false, true, true);
        }
        return formMasterData;
    }

    public List<FormTreeNode> getUnFlowFormBindList(Map<String, Object> map) throws BusinessException {
        if (MapUtils.isNotEmpty(map) && map.containsKey("data")) {
            try {
                map.put("data", URLDecoder.decode((String)map.get("data"), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)"decode datay error", (Throwable)e);
            }
        }
        return this.cap4FormListManager.getUnFlowFormBindList(map);
    }

    public long getOneCtpTemplateCategoryId(long srcCategoryId, Long accountId) {
        List<Object> templateCategoryList = new ArrayList();
        long categoryId = 0L;
        try {
            templateCategoryList = this.getFormCategoryListByAccount(accountId);
        }
        catch (BusinessException e) {
            LOGGER.info((Object)("\u83b7\u53d6\u5355\u4f4d\u8868\u5355\u5206\u7c7b\u5f02\u5e38\u3002srcCategoryId=" + srcCategoryId + ";accountId=" + accountId));
            categoryId = srcCategoryId;
        }
        ArrayList<Long> categoryTypes = new ArrayList<Long>();
        categoryTypes.add(Long.valueOf(ModuleType.form.getKey()));
        categoryTypes.add(Long.valueOf(ModuleType.collaboration.getKey()));
        if (!templateCategoryList.isEmpty()) {
            for (CtpTemplateCategory ctpTemplateCategory : templateCategoryList) {
                Long parentId = ctpTemplateCategory.getParentId();
                if (!categoryTypes.contains(parentId)) continue;
                categoryId = ctpTemplateCategory.getId();
                break;
            }
        }
        return categoryId;
    }

    public List<CtpTemplateCategory> getFormCategoryListByAccount(Long accountId) throws BusinessException {
        return this.getCategoryListByMyAccount(ModuleType.collaboration, accountId);
    }

    public List<CtpTemplateCategory> getFormCategoryListByMyAccount() throws BusinessException {
        User user = AppContext.getCurrentUser();
        Long accountId = user.getLoginAccount();
        if (!user.isV5Member()) {
            accountId = OrgHelper.getVJoinAllowAccount();
        }
        return this.getCategoryListByMyAccount(ModuleType.collaboration, accountId);
    }

    public List<CtpTemplateCategory> getCategoryListByMyAccount(ModuleType moduleType, Long accountId) throws BusinessException {
        TemplateManager templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
        ArrayList<ModuleType> categoryList = new ArrayList<ModuleType>();
        categoryList.add(moduleType);
        ArrayList<CtpTemplateCategory> resultList = new ArrayList<CtpTemplateCategory>();
        ArrayList<TemplateCategory> returnTemplateCategorys = new ArrayList<TemplateCategory>();
        List formTemplateCategorys = templateManager.getCategorys(accountId, categoryList);
        for (CtpTemplateCategory category : formTemplateCategorys) {
            if (category.isDelete() != null && category.isDelete().booleanValue()) continue;
            returnTemplateCategorys.add(new TemplateCategory(category));
        }
        ComparatorTemplateBOPub comparator = new ComparatorTemplateBOPub();
        Collections.sort(returnTemplateCategorys, comparator);
        for (TemplateCategory category : returnTemplateCategorys) {
            resultList.add(category.toPO());
        }
        return resultList;
    }

    public List<CtpTemplateCategory> getFlowTemplateCategoryListByMyAccount() throws BusinessException {
        TemplateManager templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
        ArrayList<ModuleType> categoryList = new ArrayList<ModuleType>();
        categoryList.add(ModuleType.collaboration);
        categoryList.add(ModuleType.cap4UnflowForm);
        categoryList.add(ModuleType.cap4Form);
        List formTemplateCategorys = templateManager.getCategorys(Long.valueOf(AppContext.currentAccountId()), categoryList);
        return formTemplateCategorys;
    }

    @Deprecated
    public void putSessioMasterDataBean(FormBean formBean, FormDataMasterBean cacheMasterData) {
        this.putSessioMasterDataBean(formBean, cacheMasterData, true, true);
    }

    @Deprecated
    public void putSessioMasterDataBean(FormBean formBean, FormDataMasterBean cacheMasterData, boolean needAdd2Seeion) {
        this.putSessioMasterDataBean(formBean, cacheMasterData, needAdd2Seeion, true);
    }

    public void putSessioMasterDataBean(FormBean formBean, FormDataMasterBean cacheMasterData, boolean needAdd2Seeion, boolean needCloneMasterData) {
        if (needCloneMasterData) {
            try {
                FormDataMasterBean cloneBean = (FormDataMasterBean)cacheMasterData.clone();
                cacheMasterData.putExtraAttr("cloneDataBean", (BasePO)cloneBean);
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error((Object)"clone \u6570\u636e\u9519\u8bef", (Throwable)e);
            }
        }
        String key = this.createSessionMasterDataKey(cacheMasterData.getId());
        StringBuilder sb = new StringBuilder();
        sb.append("\u6dfb\u52a0\u8868\u5355\u6570\u636e: ");
        if (needAdd2Seeion) {
            HttpSession session = AppContext.getRawSession();
            if (session != null) {
                AppContext.putSessionContext((String)key, (Object)cacheMasterData);
                sb.append(" key:").append(key).append(" session: ").append(session.getId().substring(0, 10));
            } else {
                LOGGER.debug((Object)"session \u4e3a\u7a7a\uff0c\u6dfb\u52a0\u7f13\u5b58\u6570\u636e\u5931\u8d25");
            }
        }
        AppContext.putThreadContext((String)key, (Object)cacheMasterData);
        if (isLog) {
            LOGGER.info((Object)sb);
        }
    }

    public FormDataMasterBean getSessioMasterDataBean(Long formMasterId) {
        try {
            String key = this.createSessionMasterDataKey(formMasterId);
            FormDataMasterBean data = (FormDataMasterBean)AppContext.getThreadContext((String)key);
            StringBuilder sb = new StringBuilder();
            sb.append("1.\u83b7\u53d6\u8868\u5355\u6570\u636e:thread:" + key);
            if (data == null) {
                sb.append("\uff1b2.thread\u4e3a\u7a7a,session:" + key);
                HttpSession session = AppContext.getRawSession();
                if (session != null) {
                    data = (FormDataMasterBean)AppContext.getSessionContext((String)key);
                    sb.append(" session key :").append(session.getId().substring(10));
                }
                if (data == null) {
                    sb.append("\uff1b3.session\u4e3a\u7a7a: " + key);
                }
            }
            if (isLog && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)sb);
            }
            return data;
        }
        catch (Exception e) {
            LOGGER.error((Object)("get the session formdata error! the masterId is" + formMasterId), (Throwable)e);
            return null;
        }
    }

    public void saveSessioMasterDataBean(Long formMasterId, FormDataMasterBean formDataMasterBean) {
        if (SystemEnvironment.isDistributedMode()) {
            AppContext.putSessionContext((String)this.createSessionMasterDataKey(formMasterId), (Object)formDataMasterBean);
        }
    }

    @RemoveSessionData
    public void removeSessionMasterDataBean(Long formMasterId) {
        this.removeSessionMasterDataBean(formMasterId, AppContext.currentUserId());
    }

    @RemoveSessionData
    public void removeSessionMasterDataBean(Long formMasterId, Long userId) {
        String formDataSessionKey = this.createSessionMasterDataKey(formMasterId, userId);
        AppContext.removeThreadContext((String)formDataSessionKey);
        AppContext.removeSessionArrribute((String)formDataSessionKey);
        HttpSession session = AppContext.getRawSession();
        StringBuilder sb = new StringBuilder();
        if (session != null) {
            sb.append("session key : " + session.getId().substring(0, 10));
        }
        sb.append(" \u79fb\u9664\u8868\u5355\u6570\u636ethread/session \u7f13\u5b58: " + formDataSessionKey);
        LOGGER.info((Object)sb.toString());
        Lock lock = this.getLock(formMasterId);
        if (lock != null && lock.getOwner() == userId.longValue()) {
            if (Strings.isEmpty((String)lock.getFrom())) {
                this.unlockFormData(formMasterId);
            } else if (lock.getFrom().equals(Constants.login_sign.stringValueOf((int)AppContext.getCurrentUser().getLoginSign()))) {
                this.unlockFormData(formMasterId);
            } else if ("wechat".equals(lock.getFrom())) {
                this.unlockFormData(formMasterId);
            }
        }
    }

    private String createSessionMasterDataKey(Long formMasterId) {
        return this.createSessionMasterDataKey(formMasterId, AppContext.currentUserId());
    }

    private String createSessionMasterDataKey(Long formMasterId, Long userId) {
        return userId + "_" + formMasterId;
    }

    public boolean lockFormData(Long masterDataId) {
        return this.lockFormData(masterDataId, null, null);
    }

    public boolean lockFormData(Long masterDataId, Long userId, String from) {
        userId = null == userId ? AppContext.currentUserId() : userId;
        from = null == from ? Constants.login_sign.stringValueOf((int)AppContext.getCurrentUser().getLoginSign()) : from;
        return this.lockManager.lock(userId.longValue(), masterDataId.longValue(), from);
    }

    public boolean lockFormDataWithHeartbeat(Long masterDataId, Long userId, String from) {
        userId = null == userId ? AppContext.currentUserId() : userId;
        from = null == from ? Constants.login_sign.stringValueOf((int)AppContext.getCurrentUser().getLoginSign()) : from;
        return this.lockManager.lock(userId.longValue(), masterDataId.longValue(), -1, from, true);
    }

    public Lock getLock(Long masterDataId) {
        List locks = this.lockManager.getLocks(masterDataId.longValue());
        Lock l = null;
        if (locks != null && locks.size() > 0 && (l = (Lock)locks.get(0)) != null && !LockState.effective_lock.equals((Object)this.lockManager.isValid(l))) {
            this.unlockFormData(masterDataId);
            l = null;
        }
        return l;
    }

    @AjaxAccess
    public String checkDataLockForEdit(String dataId, String formIdStr, String rightId) throws BusinessException {
        boolean hasEditFlag;
        if (Strings.isNotBlank((String)dataId) && Strings.isNotBlank((String)formIdStr) && (hasEditFlag = this.checkUnFlowFormFieldCanEdit(Long.valueOf(formIdStr), rightId))) {
            return this.checkDataLockForEdit(dataId);
        }
        return "";
    }

    public String checkDataLockForEdit(String dataId) throws BusinessException {
        return this.checkDataLockFormEdit(dataId, false, true);
    }

    public String checkDataLockFormEdit(String dataId, boolean includeSelf, boolean needI18n) throws BusinessException {
        if (Strings.isNotBlank((String)dataId)) {
            OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
            Lock lock = this.getLock(Long.valueOf(dataId));
            if (lock != null) {
                V3xOrgMember member;
                User currentUser = AppContext.getCurrentUser();
                boolean isOne = lock.getOwner() == currentUser.getId().longValue();
                String from = Constants.login_sign.stringValueOf((int)currentUser.getLoginSign());
                String returnStr = "";
                if (includeSelf && isOne) {
                    returnStr = needI18n ? ResourceUtil.getString((String)"form.formlist.editdataerror", (Object)currentUser.getName()) : currentUser.getName();
                } else if (!(isOne && lock.getFrom() != null && lock.getFrom().equals(from) || (member = orgManager.getMemberById(Long.valueOf(lock.getOwner()))) == null)) {
                    returnStr = needI18n ? ResourceUtil.getString((String)"form.formlist.editdataerror", (Object)member.getName()) : member.getName();
                }
                return returnStr;
            }
        }
        return "";
    }

    public boolean checkUnFlowFormFieldCanEdit(Long formId, String rightId) {
        return true;
    }

    public String checkDataLock(String dataIds) throws BusinessException {
        if (Strings.isNotBlank((String)dataIds)) {
            String[] ids = dataIds.split(",");
            OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
            for (int i = 0; i < ids.length; ++i) {
                Lock lock = this.getLock(Long.valueOf(ids[i]));
                if (lock == null) continue;
                boolean isOne = lock.getOwner() == AppContext.currentUserId();
                String from = Constants.login_sign.stringValueOf((int)AppContext.getCurrentUser().getLoginSign());
                if (isOne && lock.getFrom() != null && lock.getFrom().equals(from)) continue;
                V3xOrgMember member = orgManager.getMemberById(Long.valueOf(lock.getOwner()));
                if (ids.length == 1) {
                    return ResourceUtil.getString((String)"form.formlist.deldataerror", (Object)member.getName());
                }
                return ResourceUtil.getString((String)"form.formlist.deldataerrormore", (Object)(i + 1), (Object)member.getName());
            }
        }
        return "";
    }

    public void unlockFormData(Long masterDataId) {
        this.lockManager.unlock(masterDataId.longValue());
    }

    public boolean canEdit(Long rightId, Long formId) {
        boolean retVal = false;
        FormBean form = this.cap4FormCacheManager.getForm(formId);
        FormAuthViewBean formAuth = form.getAuthViewBeanById(rightId);
        List fields = form.getAllFieldBeans();
        for (FormFieldBean field : fields) {
            FormAuthViewFieldBean fieldAuth = formAuth.getFormAuthorizationField(field.getName());
            String fieldAccess = fieldAuth.getAccess();
            if (!fieldAccess.equalsIgnoreCase(Enums.FieldAccessType.edit.getKey()) && !fieldAccess.equalsIgnoreCase(Enums.FieldAccessType.add.getKey())) continue;
            retVal = true;
            break;
        }
        if (!retVal) {
            List tableList = form.getTableList();
            for (FormTableBean tableBean : tableList) {
                if (tableBean.isMainTable() || !formAuth.allowAdd(tableBean.getTableName()) && !formAuth.allowDelete(tableBean.getTableName())) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public StringBuilder getCategory2HTML(Long accountId, Long parentCategoryId, boolean showRoot) throws BusinessException {
        StringBuilder categoryHTML = new StringBuilder();
        List<CtpTemplateCategory> templeteCategories = this.getFormCategoryListByMyAccount();
        if (parentCategoryId != null) {
            List<CtpTemplateCategory> notNeedCategorys = this.getSubCategorys(AppContext.currentAccountId(), parentCategoryId);
            notNeedCategorys.add(this.templateManager.getCtpTemplateCategory(parentCategoryId));
            templeteCategories.removeAll(notNeedCategorys);
        }
        StringBuilder sb = new StringBuilder();
        if (showRoot) {
            categoryHTML.append("<option value=\"2\">").append(ResourceUtil.getString((String)"form.bindseeyon.label")).append("</option>");
        }
        ArrayList<Long> categoryTypes = new ArrayList<Long>();
        categoryTypes.add(Long.valueOf(ModuleType.form.getKey()));
        categoryTypes.add(Long.valueOf(ModuleType.collaboration.getKey()));
        return sb.append((CharSequence)this.category2HTML(templeteCategories, categoryHTML, categoryTypes, 1));
    }

    private List<CtpTemplateCategory> getSubCategorys(Long accountId, Long id) throws BusinessException {
        UniqueList result = new UniqueList();
        ArrayList<ModuleType> intList = new ArrayList<ModuleType>();
        intList.add(ModuleType.form);
        List templeteCategories = this.templateManager.getCategorys(accountId, intList);
        if (templeteCategories != null) {
            for (CtpTemplateCategory ctpTemplateCategory : templeteCategories) {
                if (ctpTemplateCategory == null || ctpTemplateCategory.getParentId() == null || !ctpTemplateCategory.getParentId().equals(id)) continue;
                result.add(ctpTemplateCategory);
            }
        }
        return result;
    }

    private StringBuilder category2HTML(List<CtpTemplateCategory> categories, StringBuilder categoryHTML, List<Long> currentNode, int level) throws BusinessException {
        for (CtpTemplateCategory category : categories) {
            Long parentId = category.getParentId();
            if (!currentNode.contains(parentId)) continue;
            categoryHTML.append("<option value='" + category.getId() + "' title='" + Strings.toHTML((String)category.getName().trim()) + "'>");
            for (int i = 0; i < level; ++i) {
                categoryHTML.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            categoryHTML.append(Strings.toHTML((String)category.getName().trim()) + "</option>\n");
            ArrayList<Long> categoryTypes = new ArrayList<Long>();
            categoryTypes.add(category.getId());
            this.category2HTML(categories, categoryHTML, categoryTypes, level + 1);
        }
        return categoryHTML;
    }

    @AjaxAccess
    public boolean isEnabled(Long formId) {
        return this.cap4FormCacheManager.isEnabled(formId);
    }

    public boolean isEnabled(FormBean formBean) {
        return this.cap4FormCacheManager.isEnabled(formBean);
    }

    @AjaxAccess
    public String preExcFormulaMagic(Map<String, Object> params) throws BusinessException {
        String formulaStr = ParamUtil.getString(params, (String)"formulaStr");
        long formId = ParamUtil.getLong(params, (String)"formId", (Long)0L);
        String oFormId = ParamUtil.getString(params, (String)"oFormId", (String)"0");
        String formulaType = ParamUtil.getString(params, (String)"fType", (String)"0");
        Integer allowSubFieldAloneUse = ParamUtil.getInt(params, (String)"allowSubFieldAloneUse", (int)0);
        Integer checkSubFieldMethod = ParamUtil.getInt(params, (String)"checkSubFieldMethod", (int)0);
        FormBean form = this.getEditingForm(formId);
        if (form == null) {
            form = this.cap4FormCacheManager.getForm(formId);
        }
        MagicServiceDetail magicDetail = this.cap4MagicManager.getServiceDetailById(oFormId);
        return Strings.toHTML((String)FormulaUtil.preExcFormulaMagic((String)formulaStr, (String)formulaType, (FormBean)form, (MagicServiceDetail)magicDetail, (allowSubFieldAloneUse == 1 ? 1 : 0) != 0, (checkSubFieldMethod == 1 ? 1 : 0) != 0));
    }

    @AjaxAccess
    public String preExcFormula(String formulaStr, String formulaType, long formId, long oFormId, boolean allowSubFieldAloneUse, boolean checkSubFieldMethod) {
        FormBean form = this.getEditingForm(formId);
        if (form == null) {
            form = this.cap4FormCacheManager.getForm(formId);
        }
        FormBean oForm = null;
        if (oFormId != 0L) {
            oForm = this.cap4FormCacheManager.getForm(oFormId);
        }
        return Strings.toHTML((String)FormulaUtil.preExcFormula((String)formulaStr, (String)formulaType, (FormBean)form, (FormBean)oForm, (boolean)allowSubFieldAloneUse, (boolean)checkSubFieldMethod));
    }

    @AjaxAccess
    public String preExcConditionMagic(Map<String, Object> params) throws BusinessException {
        String formulaStr = ParamUtil.getString(params, (String)"formulaStr");
        String formulaType = ParamUtil.getString(params, (String)"fType");
        long formId = ParamUtil.getLong(params, (String)"formId", (Long)0L);
        String oFormId = ParamUtil.getString(params, (String)"oFormId");
        boolean allowSubFieldAloneUse = "1".equals(ParamUtil.getString(params, (String)"allowSubFieldAloneUse"));
        boolean checkSubFieldMethod = "1".equals(ParamUtil.getString(params, (String)"checkSubFieldMethod"));
        String queryOrReportId = ParamUtil.getString(params, (String)"queryOrReportId");
        FormBean form = this.getEditingForm(formId);
        if (form == null) {
            form = this.cap4FormCacheManager.getForm(formId);
        }
        MagicServiceDetail magicDetail = this.cap4MagicManager.getServiceDetailById(oFormId);
        return Strings.toHTML((String)FormulaUtil.preExcConditionMagic((String)formulaStr, (String)formulaType, (FormBean)form, (MagicServiceDetail)magicDetail, (boolean)allowSubFieldAloneUse, (boolean)checkSubFieldMethod, (String)queryOrReportId));
    }

    @AjaxAccess
    public String preExcCondition(String formulaStr, String formulaType, long formId, long oFormId, boolean allowSubFieldAloneUse, boolean checkSubFieldMethod, String queryOrReportId) {
        FormBean form = this.getEditingForm(formId);
        if (form == null) {
            form = this.cap4FormCacheManager.getForm(formId);
        }
        FormBean oForm = null;
        if (oFormId != 0L) {
            oForm = this.cap4FormCacheManager.getForm(oFormId);
        }
        return Strings.toHTML((String)FormulaUtil.preExcCondition((String)formulaStr, (String)formulaType, (FormBean)form, (FormBean)oForm, (boolean)allowSubFieldAloneUse, (boolean)checkSubFieldMethod, (String)queryOrReportId));
    }

    @AjaxAccess
    public String hasDifferSubTable(long formId, String condition) throws BusinessException {
        FormBean form = this.getEditingForm(formId);
        if (null == form) {
            form = this.cap4FormCacheManager.getForm(formId);
        }
        FormFormulaBean formulaBean = new FormFormulaBean(form);
        formulaBean.loadFromFormula(condition);
        boolean b = formulaBean.hasDifferSubTable();
        return String.valueOf(b);
    }

    public boolean hasFormInCategory(Long categoryId) throws BusinessException {
        return this.cap4FormListManager.checkCategorys(categoryId);
    }

    public boolean hasCheckRule(Long formId) {
        List checkRules;
        boolean result = false;
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        FormCheckRuleBean checkRuleBean = formBean.getCheckRuleBean();
        List list = checkRules = checkRuleBean == null ? null : checkRuleBean.getCheckRuleList();
        if (Strings.isNotEmpty((Collection)checkRules)) {
            result = true;
        }
        return result;
    }

    public boolean isFormCanBatchDeal(Long formId, Long rightId) {
        boolean result = true;
        FormBean bean = this.cap4FormCacheManager.getForm(formId);
        if (bean != null && bean.hasNotNullableField(rightId.longValue())) {
            result = false;
        }
        return result;
    }

    public String validate(Long formId, FormDataMasterBean cacheMasterData) throws BusinessException {
        List checkRules;
        DataContainer dc = new DataContainer();
        FormBean fb = this.cap4FormCacheManager.getForm(formId);
        FormCheckRuleBean checkRuleBean = fb.getCheckRuleBean();
        List list = checkRules = checkRuleBean == null ? null : checkRuleBean.getCheckRuleList();
        if (Strings.isNotEmpty((Collection)checkRules)) {
            FormDataMasterBean masterBean = cacheMasterData;
            Map conditionMap = masterBean.getFormulaMap("componentType_condition");
            Map formulaMap = fb.getCheckRuleFormula(conditionMap);
            HashMap<String, Object> dataMap = new HashMap<String, Object>(masterBean.getRowData());
            int forceCheck = Integer.valueOf(formulaMap.get("forceCheck").toString());
            int showDetail = Integer.valueOf(formulaMap.get("showDetail").toString());
            List formulaList = (List)formulaMap.get("checkRule");
            ArrayList<String> fieldNameList = new ArrayList<String>();
            ArrayList<String> errorFormulaDis = null;
            ArrayList<String> errorDescList = null;
            FormFormulaBean formula22 = null;
            try {
                boolean checkResult = true;
                for (FormFormulaBean formula22 : formulaList) {
                    String formulaStr = formula22.getExecuteFormulaForGroove();
                    if (StringUtil.checkNull((String)formulaStr)) continue;
                    String desc = formula22.getFormulaDescription();
                    boolean value = FormulaUtil.isMatch((String)formulaStr, (Map)conditionMap);
                    if (value) continue;
                    LOGGER.info((Object)("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u6821\u9a8c\u89c4\u5219\u4e3a\uff1a" + formulaStr));
                    Pattern pattern = Pattern.compile("field[0-9]{4}");
                    Matcher matcher = pattern.matcher(formulaStr);
                    HashSet<Object> fieldNameSet = new HashSet<Object>();
                    while (matcher.find()) {
                        String name = matcher.group();
                        fieldNameSet.add(name);
                    }
                    for (String string : fieldNameSet) {
                        Object obj = conditionMap.get(string);
                        String fieldValue = String.valueOf(null != obj ? obj : "null");
                        LOGGER.info((Object)(string + " = " + fieldValue));
                    }
                    if (checkResult) {
                        checkResult = false;
                    }
                    String formulaDis = formula22.getFormulaForDisplay();
                    if (null == errorFormulaDis) {
                        errorFormulaDis = new ArrayList<String>();
                    }
                    errorFormulaDis.add(formulaDis);
                    List list2 = FormulaValidate.parseToSimpleConditions((String)formulaDis);
                    for (String condition : list2) {
                        FormFormulaBean formulaBean = new FormFormulaBean(fb);
                        formulaBean.loadFromFormula(condition);
                        formulaStr = formulaBean.getExecuteFormulaForGroove();
                        if (FormulaUtil.isMatch((String)formulaStr, (Map)conditionMap)) continue;
                        if (null == errorDescList) {
                            errorDescList = new ArrayList<String>();
                        }
                        this.getCheckRuleMsg(desc, fb, dataMap, condition, formulaBean, showDetail, errorDescList, fieldNameList);
                    }
                }
                if (!checkResult) {
                    StringBuilder sb = new StringBuilder();
                    if (null != errorDescList && !errorDescList.isEmpty()) {
                        for (int i = 0; i < errorDescList.size(); ++i) {
                            sb.append(i + 1 + "\u3001" + (String)errorDescList.get(i) + "<br/>");
                        }
                    }
                    dc.add("ruleError", sb.toString());
                    dc.add("fields", fieldNameList);
                    throw new BusinessException(dc.getJson());
                }
            }
            catch (Exception e) {
                if (dc.isEmpty()) {
                    if (e instanceof BusinessException && "2012".equals(((BusinessException)((Object)e)).getCode())) {
                        dc.add("ruleError", ResourceUtil.getString((String)"form.data.exception.customfunc.error.tips") + "<br>(" + formula22.getFormulaForDisplay() + ")");
                    } else {
                        String exceptionMessage = ResourceUtil.getStringByParams((String)"form.baseinfo.checkRule.formula.error", (Object[])new Object[0]) != null ? ResourceUtil.getStringByParams((String)"form.baseinfo.checkRule.formula.error", (Object[])new Object[0]) : "form.baseinfo.checkRule.formula.error";
                        dc.add("ruleError", exceptionMessage + "<br>(" + formula22.getFormulaForDisplay() + ")");
                    }
                    dc.add("fields", new ArrayList());
                }
                dc.put("forceCheck", (Object)forceCheck);
                dc.add("formType", fb.getFormType() == 2 || fb.getFormType() == 3 ? "unflow" : "flow");
                LOGGER.error((Object)(e.getMessage() + " formId: " + fb.getFormName() + " dataId: " + cacheMasterData.getId()), (Throwable)e);
            }
        }
        return dc.isEmpty() ? "" : dc.getJson();
    }

    private void getCheckRuleMsg(String checkDesc, FormBean fb, Map<String, Object> dataMap, String condition, FormFormulaBean formulaBean, int showDetail, List<String> errorDescList, List<String> fieldNameList) throws BusinessException {
        checkDesc = Strings.isEmpty((String)checkDesc) ? ResourceUtil.getString((String)"cap.formDesign.checkrul.nojustify") : this.cap4FormDataManager.getReplaceMsg(checkDesc, fb, dataMap, false);
        Set fieldBeans = formulaBean.getInFormulaFormFieldBean();
        String detailMsg = ResourceUtil.getString((String)"form.forminputchoose.reaseme") + FormulaValidate.getValidateErrorMSG4CheckRule((String)condition, (FormBean)fb);
        String descMsg = Strings.toHTML((String)checkDesc.replaceAll("@formulaDes@", "\r\n").replaceAll("&quot;", "\""));
        errorDescList.add(descMsg + "<br>" + (showDetail == 1 ? detailMsg : ""));
        if (Strings.isNotEmpty((Collection)fieldBeans)) {
            for (FormFieldBean formFieldBean : fieldBeans) {
                fieldNameList.add(formFieldBean.getName());
            }
        }
    }

    public String removeDeeSessionData(Map<String, Object> param) {
        DataContainer dc = new DataContainer();
        Long formMasterId = ParamUtil.getLong(param, (String)"masterDataId", (Long)0L);
        try {
            this.removeDeeDataCache(formMasterId);
            dc.add("success", "true");
        }
        catch (Exception e) {
            dc.add("success", "false");
            dc.add("errorMsg", StringUtil.toString((Throwable)e));
        }
        return dc.getJson();
    }

    public void removeDeeDataCache(Long formMasterId) {
    }

    public List<FormDataBean> selectDataById(Long[] id, String tableName, String[] fields) {
        if (StringUtil.checkNull((String)tableName) || tableName.toLowerCase().indexOf("form") == -1) {
            return null;
        }
        FormTableBean tableBean = this.cap4FormCacheManager.getTable(tableName);
        ArrayList<FormDataBean> result = new ArrayList<FormDataBean>();
        try {
            List<Map<String, Object>> resMap = this.cap4FormDataDAO.selectDataById(id, tableBean, fields);
            if (Strings.isEmpty(resMap)) {
                return result;
            }
            for (Map<String, Object> m : resMap) {
                result.add(new FormDataBean(m, tableBean, new boolean[]{false}));
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public Long getFormIdByTemplate4FlowForm(CtpTemplate template) throws BusinessException {
        CtpContentAll contentAll;
        List list = MainbodyService.getInstance().getContentList(ModuleType.collaboration, template.getId().longValue());
        if (Strings.isNotEmpty((Collection)list) && null != (contentAll = (CtpContentAll)list.get(0))) {
            return contentAll.getContentTemplateId();
        }
        return 0L;
    }

    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void saveOrUpdateFormBean(FormBean formBean) throws BusinessException {
        this.saveOrUpdateFormBean(formBean, 0);
    }

    public void saveOrUpdateFormBean(FormBean formBean, int importOption) throws BusinessException {
        FormBean fb = this.cap4FormCacheManager.getForm(formBean.getId());
        try {
            CAPFormDefinition formDefinition = formBean.toFormDefinition();
            List resourceList = formBean.toResource4FormBean();
            FormOwner formOwner = new FormOwner();
            formOwner.setVersion("4.0");
            formOwner.setId(Long.valueOf(UUIDLong.longUUID()));
            formOwner.setFormId(formBean.getId());
            formOwner.setOwnerId(Long.valueOf(formBean.getOwnerId()));
            formOwner.setOrgAccountId(Long.valueOf(AppContext.currentAccountId()));
            User user = AppContext.getCurrentUser();
            List moduleAuthList = formBean.getAllModuleAuthList();
            AppLogManager appLogManager = (AppLogManager)AppContext.getBean((String)"appLogManager");
            boolean isNew = false;
            int state = formBean.getState();
            if (fb == null || importOption == 1 || importOption == 3) {
                isNew = true;
                formDefinition.setCreateTime(DateUtil.currentDate());
                formDefinition.setModifyTime(DateUtil.currentDate());
                this.cap4FormDefinitionDAO.insert(formDefinition);
                this.cap4FormResourceDAO.insert(resourceList);
                List<CtpFormula> formulaList = this.cap4FormCacheManager.getFormulaList(formBean);
                this.formulaDAO.insertList(formulaList);
                List formulaConditionList = formBean.getFormulaConditionList();
                this.formulaConditionDAO.insertList(formulaConditionList);
                this.formCustomFunctionDAO.insertList(formBean.getCustomFunctionList());
                List relationList = formBean.getRelationList();
                this.formRelationDAO.insertList(relationList);
                this.formOwnerDAO.insert(formOwner);
                if (importOption == 1 || importOption == 3) {
                    this.cap4FormCacheManager.addFormOwner(formOwner);
                }
                this.formAuthModuleDAO.saveOrUpdate(moduleAuthList);
                if (state == Enums.FormStateEnum.official.getKey()) {
                    this.cap4FormDataDAO.saveTable4Db(formBean);
                    this.cap4FormDataDAO.saveTableIndex4Db(formBean, null, false);
                }
                if (formBean.getState() == Enums.FormStateEnum.official.getKey() && user != null) {
                    appLogManager.insertLog(user, AppLogAction.Form_Publish, new String[]{AppContext.currentUserName(), formBean.getFormName()});
                }
                if (user != null) {
                    appLogManager.insertLog(user, AppLogAction.Form_New, new String[]{AppContext.currentUserName(), formBean.getFormName()});
                }
            } else {
                formDefinition.setModifyTime(DateUtil.currentDate());
                this.dealChangeFieldType(formBean, fb, this.cap4FormDesignManager.bizConfigPublish(formBean));
                this.cap4FormDefinitionDAO.update(formDefinition);
                int[] property_type = new int[]{Enums.FormResourcePropertyTypeEnum.DefaultInput.getKey(), Enums.FormResourcePropertyTypeEnum.View.getKey(), Enums.FormResourcePropertyTypeEnum.Operation.getKey(), Enums.FormResourcePropertyTypeEnum.MultiLanView.getKey()};
                this.cap4FormResourceDAO.delete(formBean.getId(), property_type);
                this.cap4FormResourceDAO.merge(resourceList);
                this.formOwnerDAO.delete(formBean.getId().longValue());
                this.formOwnerDAO.insert(formOwner);
                this.formAuthModuleDAO.deleteByFormId(formBean.getId().longValue());
                DBAgent.evict((Object)moduleAuthList);
                this.formAuthModuleDAO.saveOrUpdate(moduleAuthList);
                List<Long> businessFormulaId = this.getCtpFormulaIdFromRelationAndTrigger(fb, null);
                if (Strings.isEmpty(businessFormulaId)) {
                    this.formulaDAO.deleteByModuleId(formBean.getId());
                } else {
                    HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
                    params.put("formulaId", businessFormulaId);
                    this.formulaDAO.deleteByModuleId(formBean.getId(), params);
                }
                List<CtpFormula> formulaList = this.cap4FormCacheManager.getFormulaList(formBean);
                DBAgent.evict(formulaList);
                this.formulaDAO.insertList(formulaList);
                this.formulaConditionDAO.deleteByModuleId(formBean.getId());
                List formulaConditionList = formBean.getFormulaConditionList();
                this.formulaConditionDAO.insertList(formulaConditionList);
                this.formCustomFunctionDAO.deleteByFormId(formBean.getId());
                this.formCustomFunctionDAO.insertList(formBean.getCustomFunctionList());
                this.formRelationDAO.deleteByModuleId(formBean.getId());
                List relationList = formBean.getRelationList();
                this.formRelationDAO.insertList(relationList);
                if (user != null) {
                    appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Form_Edit, new String[]{AppContext.currentUserName(), fb.getFormName()});
                }
            }
            if (importOption == 0) {
                Set<Long> serialId = this.cap4SerialNumberManager.getSerialNumber4FormBean(formBean);
                this.serialNumberManager.bindingSerialNumber(new ArrayList<Long>(serialId), formBean.getId());
            }
            this.cap4FormBindDesignManager.saveTemplate2DB(formBean);
            if (importOption != 1) {
                boolean fromImport = importOption != 0;
                this.saveOrDeleteEnumRef(formBean, fb, fromImport);
            }
            this.removeEditForm(formBean.getId());
            this.cap4FormCacheManager.removeFormBean(formBean.getId());
            this.cap4FormCacheManager.initForm(formBean.getId());
            CAPFormDataCacheManager dataCacheManager = (CAPFormDataCacheManager)AppContext.getBean((String)"capFormDataCacheManager");
            dataCacheManager.removeByFormId(formBean.getId());
            if (!isNew) {
                this.privilegeMenuManager.updateBiz();
                this.portalApi.clearPortalMenusCache();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u8868\u5355\u5b9a\u4e49\u4fdd\u5b58\u62a5\u9519,\u8868\u5355id\uff1a" + formBean.getId()));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
    }

    public List<Long> getCtpFormulaIdFromRelationAndTrigger(FormBean formBean, AppUpgradeCacheBean appUpgradeCacheBean) {
        ArrayList<Long> formulaIdList = new ArrayList<Long>();
        for (Long relationId : formBean.getFormRelationshipIdList()) {
            FormRelationshipBean formRelationshipBean;
            if (appUpgradeCacheBean != null) {
                formRelationshipBean = appUpgradeCacheBean.getFormRelationshipBean(relationId);
                if (formRelationshipBean == null) {
                    formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                }
            } else {
                formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
            }
            if (formRelationshipBean == null) continue;
            for (FormRelationshipMapBean relationshipMapBean : formRelationshipBean.getRelationMapList()) {
                Map collectFormulaBean;
                if (relationshipMapBean.getConditionFormulaId() != 0L) {
                    formulaIdList.add(relationshipMapBean.getConditionFormulaId());
                }
                if ((collectFormulaBean = relationshipMapBean.getCollectFormulaBean()) == null) continue;
                for (Map.Entry entry : collectFormulaBean.entrySet()) {
                    formulaIdList.add((Long)entry.getKey());
                }
            }
        }
        for (Long triggerId : formBean.getFormTriggerIdList()) {
            FormTriggerBean triggerBean;
            if (appUpgradeCacheBean != null) {
                triggerBean = appUpgradeCacheBean.getFormTriggerBean(triggerId);
                if (triggerBean == null) {
                    triggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                }
            } else {
                triggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
            }
            if (triggerBean == null || !Strings.isNotEmpty((Collection)triggerBean.getFormulaList())) continue;
            for (FormFormulaBean formula : triggerBean.getFormulaList()) {
                if (formula == null) continue;
                formulaIdList.add(formula.getFormulaId());
            }
        }
        return formulaIdList;
    }

    public void clearFormBeanData(Long formId) throws BusinessException {
        this.cap4FormResourceDAO.delete(formId);
        this.formOwnerDAO.delete(formId.longValue());
        this.formAuthModuleDAO.deleteByFormId(formId.longValue());
        this.formulaDAO.deleteByModuleId(formId);
        this.formulaConditionDAO.deleteByModuleId(formId);
        this.formCustomFunctionDAO.deleteByFormId(formId);
        this.formRelationDAO.deleteByModuleId(formId);
    }

    public void dealChangeFieldType(FormBean editForm, FormBean cacheForm, boolean isPublish) throws BusinessException {
        block0: for (FormTableBean editTable : editForm.getTableList()) {
            for (FormTableBean cacheTable : cacheForm.getTableList()) {
                if (!editTable.getTableName().equals(cacheTable.getTableName())) continue;
                editTable.compareToColumnAttr(cacheTable, isPublish);
                continue block0;
            }
        }
        this.cap4FormDataDAO.saveAddFields4Db(editForm);
        this.cap4FormDataDAO.saveModifyFields4Db(this.getModifyFieldSql(editForm));
        this.cap4FormDataDAO.saveTableIndex4Db(editForm, cacheForm, true);
        this.cap4FormDataDAO.dropFields4Db(editForm);
    }

    private List<String> getModifyFieldSql(FormBean fb) throws BusinessException {
        LinkedList<String> listSQL = new LinkedList<String>();
        for (FormTableBean ftb : fb.getTableList()) {
            listSQL.addAll(this.modifyColumnSql(fb, ftb));
        }
        return listSQL;
    }

    public List<String> modifyColumnSql(FormBean editForm, FormTableBean formTableBean) throws BusinessException {
        FormFieldBean field;
        Dialect dialect = SystemEnvironment.getDialect();
        List modifyColumns = (List)formTableBean.getExtraAttr("modifyField");
        List clearColumns = (List)formTableBean.getExtraAttr("clearField");
        List modifyPartColumns = (List)formTableBean.getExtraAttr("modifyFieldPart");
        LinkedList<String> sqlList = new LinkedList<String>();
        if (null != clearColumns && clearColumns.size() > 0) {
            boolean needDropIndex = false;
            if (dialect.getClass().getName().toLowerCase().contains("sqlserver")) {
                needDropIndex = true;
            }
            for (String fieldName : clearColumns) {
                FormFieldBean field2 = formTableBean.getFieldBeanByName(fieldName);
                boolean isIndexField = false;
                if (needDropIndex) {
                    List uniqueList = editForm.getUniqueFieldList();
                    for (List one : uniqueList) {
                        if (one.size() != 1 || !one.contains(fieldName)) continue;
                        isIndexField = true;
                        break;
                    }
                }
                String dropIndex = "";
                String addIndex = "";
                if (isIndexField) {
                    FormTableIndexBean formTableIndexBean = new FormTableIndexBean();
                    dropIndex = formTableIndexBean.dropColumnIndexSql(null, formTableBean.getTableName(), fieldName);
                    addIndex = formTableIndexBean.createColumnIndexSql(formTableBean.getTableName(), fieldName);
                }
                try {
                    if (isIndexField && Strings.isNotBlank((String)dropIndex)) {
                        sqlList.add(dropIndex);
                    }
                    sqlList.add("alter table " + field2.getOwnerTableName() + " drop column " + field2.getName());
                    sqlList.add(formTableBean.getAddColumnSql(dialect, field2));
                    if (!isIndexField) continue;
                    sqlList.add(addIndex);
                }
                catch (Exception e) {
                    throw new BusinessException("\u6e05\u7406\u6570\u636e\u65f6\u51fa\u9519", (Throwable)e);
                }
            }
        }
        if (null != modifyPartColumns && modifyPartColumns.size() > 0) {
            for (String fieldName : modifyPartColumns) {
                field = formTableBean.getFieldBeanByName(fieldName);
                boolean hasData = false;
                try {
                    hasData = this.cap4FormDataDAO.checkFieldHasData(field.getOwnerTableName(), fieldName);
                }
                catch (SQLException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                if (hasData) {
                    sqlList.addAll(formTableBean.dealContentSplit(dialect, field));
                }
                this.dealChangeField4db(hasData, formTableBean, sqlList, editForm, field);
            }
        }
        if (null != modifyColumns && modifyColumns.size() > 0) {
            for (String fieldName : modifyColumns) {
                field = formTableBean.getFieldBeanByName(fieldName);
                boolean hasData = false;
                try {
                    hasData = this.cap4FormDataDAO.checkFieldHasData(field.getOwnerTableName(), field.getName());
                }
                catch (SQLException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                this.dealChangeField4db(hasData, formTableBean, sqlList, editForm, field);
            }
        }
        return sqlList;
    }

    private void dealChangeField4db(boolean hasData, FormTableBean formTableBean, List<String> sqlList, FormBean editForm, FormFieldBean ffb) throws BusinessException {
        Dialect dialect = SystemEnvironment.getDialect();
        String fieldName = ffb.getName();
        boolean needDropIndex = false;
        if (ffb.isStringField() && Integer.parseInt(ffb.getFieldLength()) > 255) {
            needDropIndex = true;
        }
        List uniqueList = editForm.getUniqueFieldList();
        boolean isIndexField = false;
        for (List one : uniqueList) {
            if (one.size() != 1 || !one.contains(fieldName)) continue;
            isIndexField = true;
            break;
        }
        if (ReportDBUtils.isOracleRuntime() || ReportDBUtils.isPostgreSQLRuntime()) {
            FormFieldBean cacheField = editForm.getFieldBeanByName(ffb.getName());
            try {
                FormFieldBean clonedField = (FormFieldBean)ffb.clone();
                clonedField.setName(clonedField.getName() + "_bak");
                sqlList.add(formTableBean.getAddColumnSql(dialect, clonedField));
                if (hasData) {
                    if (FormFieldComEnum.EXTEND_DATE.getKey().equals(cacheField.getInputType()) && (FormFieldComEnum.TEXT.getKey().equals(ffb.getInputType()) || FormFieldComEnum.TEXTAREA.getKey().equals(ffb.getInputType()))) {
                        sqlList.add("update " + clonedField.getOwnerTableName() + " set " + clonedField.getName() + " = to_char(" + ffb.getName() + ",'yyyy-mm-dd')");
                    } else if (FormFieldComEnum.EXTEND_DATETIME.getKey().equals(cacheField.getInputType()) && (FormFieldComEnum.TEXT.getKey().equals(ffb.getInputType()) || FormFieldComEnum.TEXTAREA.getKey().equals(ffb.getInputType()))) {
                        sqlList.add("update " + clonedField.getOwnerTableName() + " set " + clonedField.getName() + " = to_char(" + ffb.getName() + ",'yyyy-mm-dd hh24:mi')");
                    } else {
                        sqlList.add("update " + clonedField.getOwnerTableName() + " set " + clonedField.getName() + " = " + ffb.getName());
                    }
                }
                sqlList.add("alter table " + clonedField.getOwnerTableName() + " drop column " + ffb.getName());
                sqlList.add("alter table " + clonedField.getOwnerTableName() + " rename column " + clonedField.getName() + " to " + ffb.getName() + " ");
            }
            catch (Exception e) {
                throw new BusinessException("oracle\u4fee\u6539\u5b57\u6bb5\u65f6clone\u62a5\u9519", (Throwable)e);
            }
        } else if (ReportDBUtils.isSQLServerRuntime()) {
            String dropIndex = "";
            String addIndex = "";
            if (isIndexField) {
                FormTableIndexBean formTableIndexBean = new FormTableIndexBean();
                dropIndex = formTableIndexBean.dropColumnIndexSql(null, formTableBean.getTableName(), fieldName);
                addIndex = formTableIndexBean.createColumnIndexSql(formTableBean.getTableName(), fieldName);
            }
            if (hasData) {
                FormFieldBean cacheField = editForm.getFieldBeanByName(ffb.getName());
                try {
                    FormFieldBean fb = (FormFieldBean)ffb.clone();
                    fb.setName(fb.getName() + "_bak");
                    sqlList.add(formTableBean.getAddColumnSql(dialect, fb));
                    if (FormFieldComEnum.EXTEND_DATE.getKey().equals(cacheField.getInputType()) && (FormFieldComEnum.TEXT.getKey().equals(ffb.getInputType()) || FormFieldComEnum.TEXTAREA.getKey().equals(ffb.getInputType()))) {
                        sqlList.add("update " + fb.getOwnerTableName() + " set " + fb.getName() + " = convert(nvarchar(255), " + ffb.getName() + ",23)");
                    } else if (FormFieldComEnum.EXTEND_DATETIME.getKey().equals(cacheField.getInputType()) && (FormFieldComEnum.TEXT.getKey().equals(ffb.getInputType()) || FormFieldComEnum.TEXTAREA.getKey().equals(ffb.getInputType()))) {
                        sqlList.add("update " + fb.getOwnerTableName() + " set " + fb.getName() + " = left(convert(nvarchar(255), " + ffb.getName() + ",120),16)");
                    } else {
                        sqlList.add("update " + fb.getOwnerTableName() + " set " + fb.getName() + " = " + ffb.getName());
                    }
                    if (isIndexField && Strings.isNotBlank((String)dropIndex)) {
                        sqlList.add(dropIndex);
                    }
                    sqlList.add("alter table " + fb.getOwnerTableName() + " drop column " + ffb.getName());
                    sqlList.add(formTableBean.getAddColumnSql(dialect, ffb));
                    if (isIndexField) {
                        sqlList.add(addIndex);
                    }
                    sqlList.add("update " + fb.getOwnerTableName() + " set " + ffb.getName() + " = " + fb.getName());
                    sqlList.add("alter table " + fb.getOwnerTableName() + " drop column " + fb.getName());
                }
                catch (Exception e) {
                    throw new BusinessException("sqlserver\u4fee\u6539\u5b57\u6bb5\u65f6clone\u62a5\u9519", (Throwable)e);
                }
            } else {
                if (isIndexField && Strings.isNotBlank((String)dropIndex)) {
                    sqlList.add(dropIndex);
                }
                sqlList.add("alter table " + ffb.getOwnerTableName() + " drop column " + ffb.getName());
                sqlList.add(formTableBean.getAddColumnSql(dialect, ffb));
                if (isIndexField) {
                    sqlList.add(addIndex);
                }
            }
        } else if (ReportDBUtils.isDMSQLRuntime()) {
            formTableBean.getDealFieldTypeChangeSql(dialect, sqlList, ffb, hasData);
        } else if (hasData) {
            try {
                FormFieldBean fb = (FormFieldBean)ffb.clone();
                int length = StringUtil.checkNull((String)fb.getFieldLength()) ? 0 : Integer.parseInt(fb.getFieldLength());
                int digt = StringUtil.checkNull((String)fb.getDigitNum()) ? 0 : Integer.parseInt(fb.getDigitNum());
                String columnType = Enums.FieldType.columnSql((Dialect)dialect, (String)ffb.getFieldType(), (int)length, (int)length, (int)digt);
                fb.setName(fb.getName() + "_bak");
                FormFieldBean cacheField = editForm.getFieldBeanByName(ffb.getName());
                sqlList.add(formTableBean.getAddColumnSql(dialect, fb));
                if (FormFieldComEnum.EXTEND_DATETIME.getKey().equals(cacheField.getInputType()) && (FormFieldComEnum.TEXT.getKey().equals(ffb.getInputType()) || FormFieldComEnum.TEXTAREA.getKey().equals(ffb.getInputType()))) {
                    sqlList.add("update " + fb.getOwnerTableName() + " set " + fb.getName() + " = left(" + ffb.getName() + ",16)");
                } else {
                    sqlList.add("update " + fb.getOwnerTableName() + "  set  " + fb.getName() + " = " + ffb.getName());
                }
                sqlList.add("alter table " + fb.getOwnerTableName() + " drop column " + ffb.getName());
                sqlList.add("alter table " + fb.getOwnerTableName() + " change column " + fb.getName() + " " + ffb.getName() + " " + columnType);
            }
            catch (Exception e) {
                throw new BusinessException("mysql\u4fee\u6539\u5b57\u6bb5\u65f6clone\u62a5\u9519", (Throwable)e);
            }
        } else {
            FormTableIndexBean formTableIndexBean;
            String dropIndex;
            if (isIndexField && needDropIndex && Strings.isNotEmpty((String)(dropIndex = (formTableIndexBean = new FormTableIndexBean()).dropColumnIndexSql(null, formTableBean.getTableName(), fieldName)))) {
                sqlList.add(dropIndex);
            }
            sqlList.add(formTableBean.modifyAColumnSql(ffb, dialect));
        }
    }

    public void saveOrDeleteEnumRef(FormBean cacheForm, FormBean dbForm, boolean fromImport) throws BusinessException {
        CtpEnumBean ceb;
        long enumId;
        HashSet<Long> cacheBindEnum = new HashSet<Long>();
        HashSet<Long> oldBindEnum = new HashSet<Long>();
        long formId = 0L;
        if (cacheForm != null) {
            formId = cacheForm.getId();
            for (FormFieldBean ffb : cacheForm.getAllFieldBeans()) {
                enumId = 0L;
                enumId = ffb.getEnumId();
                if (enumId == 0L) continue;
                ceb = this.enumManagerNew.getEnum(Long.valueOf(enumId));
                if (ceb == null) {
                    LOGGER.error((Object)("formName:" + cacheForm.getFormName() + ",fieldName:" + ffb.getName() + ",enumId:[" + enumId + " ] is not find enum;"));
                    continue;
                }
                cacheBindEnum.add(enumId);
            }
        }
        if (dbForm != null && !fromImport) {
            formId = dbForm.getId();
            for (FormFieldBean ffb : dbForm.getAllFieldBeans()) {
                enumId = 0L;
                enumId = ffb.getEnumId();
                if (enumId == 0L) continue;
                ceb = this.enumManagerNew.getEnum(Long.valueOf(enumId));
                if (ceb == null) {
                    LOGGER.error((Object)("formName:" + dbForm.getFormName() + ",fieldName:" + ffb.getName() + ",enumId:[" + enumId + " ] is not find enum;"));
                    continue;
                }
                oldBindEnum.add(enumId);
            }
        }
        HashSet<Long> updateBindEnum = new HashSet<Long>();
        updateBindEnum.addAll(cacheBindEnum);
        updateBindEnum.removeAll(oldBindEnum);
        ArrayList<CtpEnumBind> ctpEnumBindList = new ArrayList<CtpEnumBind>();
        for (Long enumId2 : updateBindEnum) {
            this.enumManagerNew.updateEnumRef(enumId2);
            CtpEnumBind ctpEnumBind = new CtpEnumBind();
            ctpEnumBind.setNewId();
            ctpEnumBind.setEnumId(enumId2);
            ctpEnumBind.setIsEnumitem("N");
            ctpEnumBind.setModuleId(Long.valueOf(formId));
            ctpEnumBind.setModuleType(Integer.valueOf(ApplicationCategoryEnum.form.getKey()));
            ctpEnumBindList.add(ctpEnumBind);
        }
        this.enumBindManager.saveAllEnumBinds(ctpEnumBindList);
        updateBindEnum.clear();
        updateBindEnum.addAll(oldBindEnum);
        updateBindEnum.removeAll(cacheBindEnum);
        for (Long enumId2 : updateBindEnum) {
            boolean isUpdateEnum = true;
            ArrayList<CtpEnumBind> deleteBindList = new ArrayList<CtpEnumBind>();
            List itemList = this.enumManagerNew.getEmumItemByEmumId(enumId2);
            for (CtpEnumItem ctpEnumItem : itemList) {
                List itemBindList = this.enumBindManager.selectAllEnumBinds(ctpEnumItem.getId());
                if (itemBindList == null) continue;
                for (CtpEnumBind bind : itemBindList) {
                    if (bind.getModuleId() != formId) {
                        isUpdateEnum = false;
                        continue;
                    }
                    deleteBindList.add(bind);
                }
            }
            List bindList = this.enumBindManager.selectAllEnumBinds(enumId2);
            if (bindList != null) {
                for (CtpEnumBind bind : bindList) {
                    if (bind.getModuleId() != formId) {
                        isUpdateEnum = false;
                        continue;
                    }
                    deleteBindList.add(bind);
                }
            }
            if (isUpdateEnum) {
                for (CtpEnumItem ctpEnumItem : itemList) {
                    this.enumManagerNew.updateEnumItemRef(ctpEnumItem.getId(), "N");
                }
                this.enumManagerNew.updateEnumRef(enumId2, "N");
            }
            if (deleteBindList.isEmpty()) continue;
            this.enumBindManager.deleteEnumBinds(deleteBindList);
        }
    }

    public String getFormMasterData4Mobile(Map<String, Object> params) {
        ArrayList listResult = new ArrayList();
        HashMap result = null;
        JSONValue jsonValue = null;
        FormBean fb = null;
        String retValue = "";
        try {
            FlipInfo flipInfo = new FlipInfo();
            int page = params.get("page") != null ? Integer.parseInt(params.get("page").toString()) : 1;
            flipInfo.setPage(page);
            params.remove("page");
            flipInfo = this.getFormMasterDataListByFormId(flipInfo, params, false);
            fb = params.get("formId") != null ? this.cap4FormCacheManager.getForm(Long.parseLong(params.get("formId").toString())) : null;
            FormBindAuthBean formBindAuthBean = fb.getBind().getFormBindAuthBean(String.valueOf(params.get("formTemplateId")));
            List showFields = formBindAuthBean.getShowFieldList();
            List list = flipInfo.getData();
            if (Strings.isNotEmpty((Collection)list)) {
                int startAt = (page - 1) * flipInfo.getSize();
                int endAt = page * flipInfo.getSize();
                HashMap<String, Object> fieldValMap = null;
                ArrayList listItemData = null;
                for (int k = 0; k < list.size(); ++k) {
                    listItemData = new ArrayList();
                    if (k < startAt || k >= endAt) continue;
                    Map dataMap = (Map)list.get(k);
                    result = new HashMap();
                    result.put("listId", dataMap.get("id"));
                    if (fb != null) {
                        Iterator it = dataMap.keySet().iterator();
                        for (SimpleObjectBean sob : showFields) {
                            String fname = sob.getName();
                            if (StringUtil.checkNull((String)fname)) continue;
                            String fshowName = sob.getValue();
                            fieldValMap = new HashMap<String, Object>(2);
                            fieldValMap.put("listTitle", fshowName);
                            if (fname.indexOf(".") != -1) {
                                fieldValMap.put("listContent", dataMap.get(fname.split("[.]")[1]));
                            } else if (fname.equalsIgnoreCase(Enums.MasterTableField.start_member_id.getKey())) {
                                Enums.MasterTableField masterTableField = Enums.MasterTableField.getEnumByKey((String)fname);
                                fieldValMap.put("listContent", masterTableField.getFormFieldBean().getDisplayValue(dataMap.get(fname))[1]);
                            } else {
                                fieldValMap.put("listContent", dataMap.get(fname));
                            }
                            listItemData.add(fieldValMap);
                        }
                    }
                    result.put("listData", listItemData);
                    result.put("lockState", false);
                    listResult.add(result);
                }
                if (Strings.isNotEmpty(listResult)) {
                    jsonValue = JSONMapper.toJSON(listResult);
                    retValue = jsonValue.render(false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u65e0\u6d41\u7a0b\u6570\u636e\u79fb\u52a8\u7aef\u67e5\u8be2\u62a5\u9519\uff1a", (Throwable)e);
        }
        return Strings.isNotEmpty(listResult) ? retValue : "";
    }

    public String checkSessioMasterDataExists(String formMasterId) {
        FormDataMasterBean cacheMasterData = this.getSessioMasterDataBean(NumberUtils.toLong((String)formMasterId));
        if (cacheMasterData == null) {
            return ResourceUtil.getString((String)"form.cache.data.delete.label");
        }
        return "";
    }

    @AjaxAccess
    public String checkSessioMasterDataExists(String formMasterId, Long formId) throws BusinessException, SQLException {
        FormDataMasterBean cacheMasterData = this.getSessioMasterDataBean(NumberUtils.toLong((String)formMasterId));
        if (cacheMasterData == null) {
            return ResourceUtil.getString((String)"form.cache.data.delete.label");
        }
        if (!this.checkDelete(formId, formMasterId)) {
            this.removeSessionMasterDataBean(Long.valueOf(formMasterId));
            return ResourceUtil.getString((String)"form.exception.formdatadelete");
        }
        return "";
    }

    public boolean hasAttachment(FormBean formBean) throws BusinessException {
        boolean hasAttachment = false;
        if (formBean == null) {
            return hasAttachment;
        }
        List allField = formBean.getAllFieldBeans();
        for (FormFieldBean tempField : allField) {
            if (!tempField.isAttachment()) continue;
            hasAttachment = true;
            break;
        }
        return hasAttachment;
    }

    public AuthorizationInfo getAuthByFormBean(FormBean formBean) {
        AuthorizationInfo ai = new AuthorizationInfo();
        HashSet<Long> ownerSet = new HashSet<Long>();
        HashSet<Long> departmentSet = new HashSet<Long>();
        HashSet<Long> teamSet = new HashSet<Long>();
        HashSet<Long> levelSet = new HashSet<Long>();
        HashSet<Long> accountSet = new HashSet<Long>();
        HashSet<Long> postSet = new HashSet<Long>();
        Map unFlowMap = formBean.getBind().getUnFlowTemplateMap();
        for (Map.Entry tempBind : unFlowMap.entrySet()) {
            List moduleAuthList = ((FormBindAuthBean)tempBind.getValue()).getModuleAuthList();
            for (FormModuleAuth tempAuth : moduleAuthList) {
                if (tempAuth.getModuleType().intValue() != Enums.FormModuleAuthModuleType.BindAppForm.getKey()) continue;
                if (tempAuth.getOrgType().intValue() == Enums.FormModuleAuthOrgType.Account.getKey()) {
                    accountSet.add(tempAuth.getOrgId());
                }
                if (tempAuth.getOrgType().intValue() == Enums.FormModuleAuthOrgType.Team.getKey()) {
                    teamSet.add(tempAuth.getOrgId());
                }
                if (tempAuth.getOrgType().intValue() == Enums.FormModuleAuthOrgType.Level.getKey()) {
                    levelSet.add(tempAuth.getOrgId());
                }
                if (tempAuth.getOrgType().intValue() == Enums.FormModuleAuthOrgType.Department.getKey()) {
                    departmentSet.add(tempAuth.getOrgId());
                }
                if (tempAuth.getOrgType().intValue() == Enums.FormModuleAuthOrgType.Post.getKey()) {
                    postSet.add(tempAuth.getOrgId());
                }
                if (tempAuth.getOrgType().intValue() != Enums.FormModuleAuthOrgType.Member.getKey()) continue;
                ownerSet.add(tempAuth.getOrgId());
            }
        }
        ai.setOwner(new ArrayList(ownerSet));
        ai.setAccount(new ArrayList(accountSet));
        ai.setDepartment(new ArrayList(departmentSet));
        ai.setLevel(new ArrayList(levelSet));
        ai.setTeam(new ArrayList(teamSet));
        ai.setPost(new ArrayList(postSet));
        return ai;
    }

    @AjaxAccess
    public String updateFieldValByName(String formId, String rightId, String dataId, String fieldName, String val) {
        String s = "";
        if (null != dataId && null != formId && null != rightId && fieldName != null) {
            FormFieldBean field;
            FormBean form = this.getForm(Long.parseLong(formId));
            FormDataMasterBean masterBean = this.getSessioMasterDataBean(Long.parseLong(dataId));
            FormAuthViewBean auth = this.cap4FormCacheManager.getAuth(Long.parseLong(rightId));
            if (masterBean != null && form != null && (field = masterBean.getFormTable().getFieldBeanByName(fieldName)) != null) {
                masterBean.addFieldValue(fieldName, (Object)val);
                LOGGER.info((Object)("\u5ba2\u5f00\u4fee\u6539\u8868\u5355" + form.getFormName() + "\u7684\u6570\u636e" + dataId + "\u4fee\u6539\u503c" + fieldName + " " + String.valueOf(val)));
            }
        }
        return s;
    }

    public List<Attachment> saveOfficeContent(long ref, long subRef, long newRef, long newSubRef, String title, boolean needUpdateFileName) {
        this.attachmentManager.copy(Long.valueOf(ref), Long.valueOf(subRef), Long.valueOf(newRef), Long.valueOf(newSubRef), Integer.valueOf(ApplicationCategoryEnum.form.getKey()), Long.valueOf(AppContext.currentUserId()), Long.valueOf(AppContext.currentAccountId()));
        List atts = this.attachmentManager.getByReference(Long.valueOf(newRef), Long.valueOf(newSubRef));
        if (needUpdateFileName && atts != null && atts.size() > 0) {
            for (Attachment att : atts) {
                att.setFilename((title != null ? title : "") + "[" + ResourceUtil.getString((String)"cap4.customctrl.word.title") + "].doc");
                this.getAttachmentManager().update(att);
            }
        }
        return atts;
    }

    public void updateFormModifyTime(Long formId, Date modifyTime) throws BusinessException {
        this.cap4FormDefinitionDAO.updateFormModifyTime(formId, modifyTime);
    }

    public long getNewCategory(FormBean form, Long accountId) throws BusinessException {
        long categoryId = form.getCategoryId();
        if (form.getCategoryId() == 5L || form.getCategoryId() == 6L) {
            return categoryId;
        }
        long newCategoryId = -1L;
        CtpTemplateCategory ctpTemplateCategory = this.templateManager.getCtpTemplateCategory(Long.valueOf(categoryId));
        if (ctpTemplateCategory != null) {
            List newCtpTemplateCategoryList = this.templateManager.getCategoryByName(ctpTemplateCategory.getName(), accountId);
            if (newCtpTemplateCategoryList != null && !newCtpTemplateCategoryList.isEmpty()) {
                for (CtpTemplateCategory temp : newCtpTemplateCategoryList) {
                    if (temp.getId() != categoryId) continue;
                    newCategoryId = temp.getId();
                    break;
                }
                if (newCategoryId == -1L) {
                    newCategoryId = ((CtpTemplateCategory)newCtpTemplateCategoryList.get(0)).getId();
                }
            } else {
                newCategoryId = this.getOneCtpTemplateCategoryId(categoryId, accountId);
            }
        } else {
            newCategoryId = this.getOneCtpTemplateCategoryId(categoryId, accountId);
        }
        return newCategoryId;
    }

    @AjaxAccess
    public String validUnflowOperation(Long formId, String templateId, String rightId, String operation) throws BusinessException {
        String msg = ResourceUtil.getString((String)"bizconfig.use.authorize.forbidden");
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (!this.isEnabled(formBean)) {
            return msg;
        }
        FormBindAuthBean bindAuthBean = formBean.getBind().getFormBindAuthBean(templateId);
        if (bindAuthBean == null || !bindAuthBean.checkRight(AppContext.currentUserId())) {
            return msg;
        }
        if (Strings.isNotBlank((String)operation)) {
            if (FormBindAuthBean.AuthName.UPDATE.getKey().equals(operation)) {
                boolean valid = false;
                if (rightId == null) {
                    return msg;
                }
                for (SimpleObjectBean obj : bindAuthBean.getUpdateAuthList()) {
                    if (!rightId.equals(obj.getValue()) && !rightId.equals(obj.getPhoneValue())) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    return msg;
                }
            } else {
                SimpleObjectBean simpleObjectBean = bindAuthBean.getAuthObjByName(operation);
                if (simpleObjectBean == null || "false".equals(simpleObjectBean.getValue()) || Strings.isBlank((String)simpleObjectBean.getValue())) {
                    return msg;
                }
            }
        }
        return "";
    }

    public List<String> getModifiedFields(FormDataMasterBean data, Long formId) throws SQLException, BusinessException {
        FormDataMasterBean oldBean = this.findDataById((long)data.getId(), formId, null);
        return data.getModifiedFields((FormDataBean)oldBean);
    }

    public FormDataMasterBean findDataById(long masterId, long formId, String[] fields) throws BusinessException, SQLException {
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        return this.cap4FormDataDAO.selectDataByMasterId(masterId, formBean, fields);
    }

    public FormDataMasterBean findDataById(long masterId, FormBean formBean, String[] fields) throws BusinessException, SQLException {
        return this.cap4FormDataDAO.selectDataByMasterId(masterId, formBean, fields);
    }

    public void saveOrUpdateFormData(FormDataMasterBean data, Long formId, boolean saveDb) throws BusinessException, SQLException {
        this.saveOrUpdateFormData(data, formId, saveDb, null);
    }

    public void saveOrUpdateFormData(FormDataMasterBean data, Long formId, boolean saveDb, List<String> modifiedField) throws BusinessException, SQLException {
        LOGGER.info((Object)("\u6267\u884c\u6570\u636e\u4fdd\u5b58\uff1a\u8868\u5355id " + formId + "; \u6570\u636eid " + data.getId() + "; \u4eba\u5458id " + AppContext.currentUserId()));
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (saveDb) {
            if (modifiedField != null) {
                modifiedField.addAll(this.getModifiedFields(data, formId));
            }
            this.cap4FormDataManager.insertOrUpdateMasterData(data);
        }
        List allFields = formBean.getAllFieldBeans();
        for (FormFieldBean field : allFields) {
            List attValues;
            boolean updateEnumTag = false;
            if (field.isEnumField()) {
                updateEnumTag = true;
            }
            if (!updateEnumTag || (attValues = data.getDataList(field.getName())).size() <= 0) continue;
            try {
                for (Object objval : attValues) {
                    if (StringUtil.checkNull((String)String.valueOf(objval)) || "0".equals(String.valueOf(objval))) continue;
                    this.enumManagerNew.updateEnumItemRef(Long.valueOf(new BigDecimal(String.valueOf(objval)).longValue()));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u66f4\u65b0\u679a\u4e3e\u72b6\u6001\u5f02\u5e38\u2026\u2026", (Throwable)e);
            }
        }
        List serialRecordList = (List)data.getExtraAttr("serialCalRecords");
        if (Strings.isNotEmpty((Collection)serialRecordList)) {
            SerialCalRecordManager serialCalRecordManager = (SerialCalRecordManager)AppContext.getBean((String)"serialCalRecordManager");
            serialCalRecordManager.save(serialRecordList);
        }
    }

    public List<FormModuleAuth> getFormModuleAuthByOrgList(Enums.FormModuleAuthModuleType type, List<Long> orgList) throws BusinessException {
        return this.formAuthModuleDAO.selectModuleAuthByOrgList(type, orgList);
    }

    public List<FormBean> getForms() {
        return this.cap4FormCacheManager.getFormList();
    }

    public List<FormBean> getMyOwnForms(List<Enums.FormType> formType) {
        ArrayList<FormBean> fbList = new ArrayList<FormBean>();
        List<FormBean> allForms = this.getForms();
        HashSet<Enums.FormType> s = new HashSet<Enums.FormType>(formType);
        long userId = AppContext.currentUserId();
        for (FormBean fb : allForms) {
            Enums.FormType ft = Enums.FormType.getEnumByKey((int)fb.getFormType());
            if (fb.getOwnerId() != userId || !s.contains(ft)) continue;
            fbList.add(fb);
        }
        return fbList;
    }

    public List<CtpTemplate> getMyOwnFlowTemplate(Map<String, Object> params, Long notTempalteId) throws BusinessException {
        ArrayList<Enums.FormType> formType = new ArrayList<Enums.FormType>();
        formType.add(Enums.FormType.processesForm);
        List<FormBean> fbList = this.getMyOwnForms(formType);
        if (fbList.size() > 0) {
            return this.cap4FormDefinitionDAO.selectTemplate4Forms(params, fbList, notTempalteId);
        }
        return new ArrayList<CtpTemplate>();
    }

    public List<Attachment> getAllFormAttsByModuleId(Long moduleId, Long formId, Long masterId) {
        Object dataMasterBean = null;
        ArrayList<Long> valueList = new ArrayList<Long>();
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (null != formBean) {
            List allFieldBeans = formBean.getAllFieldBeans();
            if (null != allFieldBeans && allFieldBeans.size() > 0) {
                for (FormFieldBean formFieldBean : allFieldBeans) {
                    if (!"1872888230778916558".equals(formFieldBean.getFieldCtrl().getKey())) continue;
                    Object masterFieldValue = null;
                    try {
                        masterFieldValue = this.getMasterFieldValue(formId, masterId, formFieldBean.getName(), false, false);
                    }
                    catch (BusinessException e) {
                        LOGGER.error((Object)("\u83b7\u53d6\u8868\u5355\u8f6c\u6587\u6863\u63a7\u4ef6\u7684\u503c\u5931\u8d25\uff0cformId=" + formId + ",\u6570\u636eID=" + masterId), (Throwable)e);
                    }
                    catch (SQLException e) {
                        LOGGER.error((Object)("\u83b7\u53d6\u8868\u5355\u8f6c\u6587\u6863\u63a7\u4ef6\u7684\u503c\u5931\u8d25\uff0cformId=" + formId + ",\u6570\u636eID=" + masterId), (Throwable)e);
                    }
                    if (null == masterFieldValue) continue;
                    valueList.add(Long.valueOf(masterFieldValue.toString()));
                }
            }
        } else {
            LOGGER.error((Object)("\u7f13\u5b58\u4e2d\u627e\u4e0d\u5230\u8be5\u8868\u5355\uff0c\u8868\u5355ID:" + formId));
        }
        AttachmentManager attachmentManager = (AttachmentManager)AppContext.getBean((String)"attachmentManager");
        List allAtts = attachmentManager.getByReference(moduleId);
        ArrayList<Attachment> removeList = new ArrayList<Attachment>();
        for (Attachment att : allAtts) {
            if (att.getCategory().intValue() != ApplicationCategoryEnum.cap4Form.getKey()) {
                removeList.add(att);
                continue;
            }
            if (valueList.indexOf(att.getSubReference()) == -1) continue;
            removeList.add(att);
        }
        AppContext.putThreadContext((String)"removedAtt", removeList);
        allAtts.removeAll(removeList);
        return allAtts;
    }

    public boolean checkRight(Enums.FormModuleAuthModuleType moduleType, long moduleId, Long userId, Long formId) throws BusinessException {
        if (moduleType == Enums.FormModuleAuthModuleType.Relation) {
            return true;
        }
        if (!this.cap4FormCacheManager.isEnabled(formId)) {
            return false;
        }
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(formId);
        if (bizConfigBean != null && !bizConfigBean.isValid()) {
            return false;
        }
        return this.checkRight(moduleType, moduleId, userId);
    }

    public boolean checkRight(Enums.FormModuleAuthModuleType moduleType, long moduleId, Long userId) throws BusinessException {
        if (moduleType == Enums.FormModuleAuthModuleType.SeeyonReport && AppContext.hasPlugin((String)"seeyonreport")) {
            return this.seeyonreportApi.hasReportTemplateAuth(Long.valueOf(moduleId), userId);
        }
        List<Long> list = this.getUserDomainIDs(userId);
        int count = this.formAuthModuleDAO.selectAuthCountByOrgAndModuleId(list, moduleType.getKey(), moduleId);
        return count > 0;
    }

    public List<Long> getUserDomainIDs(Long userId) throws BusinessException {
        Long user = userId == null ? AppContext.currentUserId() : userId;
        OrgManager extendMemberOrgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        String[] orgType = new String[]{Enums.FormModuleAuthOrgType.Member.getText(), Enums.FormModuleAuthOrgType.Department.getText(), Enums.FormModuleAuthOrgType.Level.getText(), Enums.FormModuleAuthOrgType.Post.getText(), Enums.FormModuleAuthOrgType.Team.getText(), Enums.FormModuleAuthOrgType.Account.getText(), Enums.FormModuleAuthOrgType.BusinessAccount.getText(), Enums.FormModuleAuthOrgType.BusinessDepartment.getText()};
        return extendMemberOrgManager.getUserDomainIDs(user, orgType);
    }

    public List<CtpTemplate> getFormSystemTemplate(long formId) throws BusinessException {
        TemplateManager templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
        List templateList = templateManager.getCtpTemplates(formId, false);
        ArrayList<CtpTemplate> templates = new ArrayList<CtpTemplate>();
        for (CtpTemplate ctpTemplate : templateList) {
            if (!ctpTemplate.isSystem().booleanValue()) continue;
            templates.add(ctpTemplate);
        }
        return templates;
    }

    public void updateTemplates(List<CtpTemplate> templateList) throws BusinessException {
        TemplateManager templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
        if (templateList != null) {
            for (CtpTemplate c : templateList) {
                templateManager.updateCtpTemplate(c);
            }
        }
    }

    public void updateCategorys(long formId, long categoryId) throws BusinessException {
        List<CtpTemplate> templateList = this.getFormSystemTemplate(formId);
        for (CtpTemplate c : templateList) {
            c.setCategoryId(Long.valueOf(categoryId));
        }
        this.updateTemplates(templateList);
    }

    public boolean deleteFormData(long masterId, long formId) throws BusinessException, SQLException {
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        this.publicQrCodeManager.deletePublicQrCodeByObjectId(Long.valueOf(masterId));
        return this.cap4FormDataManager.deleteForm(masterId, formBean);
    }

    public FormDataMasterBean structureFormDataMasterBeanWithJson(Long formId, Long rightId, String dataJson, boolean validData) throws BusinessException {
        String validateStr;
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(rightId);
        Map dataMap = (Map)JSONUtil.parseJSONString((String)dataJson);
        FormTableBean masterTable = formBean.getMasterTableBean();
        Map masterData = (Map)dataMap.get(masterTable.getTableName());
        HashMap<String, Object> fieldMasterData = new HashMap<String, Object>(16);
        if (masterData != null) {
            this.convertDataByAuth(formBean, masterTable, formAuthViewBean, masterData, fieldMasterData);
        }
        if (validData) {
            this.validateNotNullable(masterTable, formAuthViewBean, fieldMasterData);
        }
        FormDataMasterBean formDataMasterBean = new FormDataMasterBean(fieldMasterData, masterTable, new boolean[0]);
        List subTableList = formBean.getSubTableBean();
        List subTableData = null;
        ArrayList<FormDataSubBean> formDataSubBeanList = null;
        for (FormTableBean formTableBean : subTableList) {
            subTableData = CAPParamUtil.getParamsListByKey((Map)dataMap, (String)formTableBean.getTableName());
            if (subTableData != null && subTableData.size() > 0) {
                formDataSubBeanList = new ArrayList<FormDataSubBean>();
                for (Map map : subTableData) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                    this.convertDataByAuth(formBean, formTableBean, formAuthViewBean, map, resultMap);
                    if (validData) {
                        this.validateNotNullable(formTableBean, formAuthViewBean, resultMap);
                    }
                    FormDataSubBean subBean = new FormDataSubBean(resultMap, formTableBean, formDataMasterBean, new boolean[0]);
                    formDataSubBeanList.add(subBean);
                }
                if (!Strings.isNotEmpty(formDataSubBeanList)) continue;
                formDataMasterBean.setSubData(formTableBean.getTableName(), formDataSubBeanList);
                continue;
            }
            if (!validData) continue;
            this.validateNotNullable(formTableBean, formAuthViewBean, new HashMap<String, Object>());
        }
        this.cap4FormDataManager.calcAll(formBean, formDataMasterBean, formAuthViewBean, false, false, false, true);
        formDataMasterBean.setState(Enums.FormDataStateEnum.FLOW_UNOFFICIAL.getKey());
        if (validData && !"".equals(validateStr = this.validate(formId, formDataMasterBean))) {
            throw new BusinessException(validateStr);
        }
        return formDataMasterBean;
    }

    private void convertDataByAuth(FormBean formBean, FormTableBean formTableBean, FormAuthViewBean formAuthViewBean, Map<String, Object> sourceMap, Map<String, Object> resultMap) throws BusinessException {
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            String display = entry.getKey();
            FormFieldBean formFieldBean = formTableBean.getFieldBeanByDisplay(display);
            if (formFieldBean == null) continue;
            FormAuthViewFieldBean authorizationField = formAuthViewBean.getFormAuthorizationField(formFieldBean.getName());
            if (Enums.FieldAccessType.browse.getKey().equals(authorizationField.getAccess()) || authorizationField.isSerialNumberDefaultValue() || Strings.isNotEmpty((Collection)formFieldBean.getFormConditionList()) || "handwrite".equals(formFieldBean.getInputType())) continue;
            resultMap.put(formFieldBean.getName(), entry.getValue());
        }
    }

    private void validateNotNullable(FormTableBean formTableBean, FormAuthViewBean formAuthViewBean, Map<String, Object> dataMap) throws BusinessException {
        for (FormFieldBean formFieldBean : formTableBean.getFields()) {
            Object value = dataMap.get(formFieldBean.getName());
            FormAuthViewFieldBean authorizationField = formAuthViewBean.getFormAuthorizationField(formFieldBean.getName());
            if (!authorizationField.isNotNullable() || authorizationField.getDefaultValue() != null || value != null && !Strings.isBlank((String)value.toString())) continue;
            throw new BusinessException("\u3010" + formFieldBean.getDisplay() + "\u3011\u5b57\u6bb5\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public boolean checkInputData(long formId, long viewId, long operationId, Map<String, String> masterNameValues, List<Map<String, String>> slaveNameValues, long id) throws BusinessException {
        FormBean fb = this.getForm(formId, false);
        if (fb == null) {
            return false;
        }
        StringBuilder errorMsg = new StringBuilder();
        FormAuthViewBean auth = fb.getAuthViewBeanById(Long.valueOf(operationId));
        String masterError = this.checkMapInputDate(fb, masterNameValues, auth, id, false);
        if (Strings.isNotBlank((String)masterError) && errorMsg.toString().indexOf(masterError) == -1) {
            errorMsg.append(masterError);
        }
        if (slaveNameValues != null) {
            for (Map<String, String> map : slaveNameValues) {
                String error = this.checkMapInputDate(fb, map, auth, id, true);
                if (!Strings.isNotBlank((String)error) || errorMsg.toString().indexOf(error) != -1) continue;
                errorMsg.append(error);
            }
        }
        if (errorMsg.length() > 0) {
            LOGGER.error((Object)("\u6821\u9a8c\u6570\u636e\u51fa\u9519:" + errorMsg.toString()));
            throw new BusinessException(errorMsg.toString());
        }
        return true;
    }

    private String checkMapInputDate(FormBean fb, Map<String, String> map, FormAuthViewBean auth, long id, boolean isSub) throws BusinessException {
        StringBuilder errorMsg = new StringBuilder();
        if (map != null) {
            HashMap uniqueMap = new HashMap();
            for (String display : map.keySet()) {
                int fieldLength;
                FormFieldBean ffb = fb.getFieldBeanByDisplay(display);
                String data = map.get(display);
                Object objValue = null;
                if (ffb == null) continue;
                String res = FormFieldUtil.checkFormat((String)ffb.getInputType(), (String)ffb.getFieldType(), (String)data, (boolean)false);
                if (res != null) {
                    errorMsg.append(display).append(ResourceUtil.getString((String)res)).append(";");
                    continue;
                }
                try {
                    ImpResultBean resultBean = ffb.getValue4Import((Object)data, true);
                    if (null != resultBean) {
                        objValue = resultBean.getResult();
                    }
                }
                catch (Exception e1) {
                    LOGGER.error((Object)"\u67e5\u8be2\u8868\u5355\u503c\u5bfc\u5e38", (Throwable)e1);
                }
                if (objValue == null && Strings.isNotBlank((String)data)) {
                    errorMsg.append(display).append("\u5bfc\u5165\u6570\u636e\u5f02\u5e38").append(";");
                    continue;
                }
                if (auth != null) {
                    FormAuthorizationTableBean formAuthorizationTableBean;
                    String tableName;
                    FormTableBean formTableBean;
                    FormAuthViewFieldBean fieldAuth = auth.getFormAuthorizationField(ffb.getName());
                    if (fieldAuth != null && (Enums.FieldAccessType.add.getKey().equalsIgnoreCase(fieldAuth.getAccess()) || Enums.FieldAccessType.edit.getKey().equalsIgnoreCase(fieldAuth.getAccess())) && !fieldAuth.isNull() && Strings.isBlank((String)data)) {
                        errorMsg.append(display).append("\u4e0d\u53ef\u4e3a\u7a7a").append(";");
                        continue;
                    }
                    if (isSub && (formTableBean = fb.getTableByTableName(tableName = ffb.getOwnerTableName())) != null && (formAuthorizationTableBean = auth.getSubTableAuth(formTableBean.getDisplay())) != null && !formAuthorizationTableBean.isAdd()) {
                        errorMsg.append(display).append("\u6240\u5728\u7684\u91cd\u590d\u8868\u4e0d\u5141\u8bb8\u6dfb\u52a0;");
                        break;
                    }
                }
                if (objValue == null) continue;
                String strVal = String.valueOf(objValue);
                int strLength = 0;
                try {
                    strLength = strVal.getBytes("UTF-8").length;
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(ffb.getFieldType()) && strLength > (fieldLength = Integer.parseInt(ffb.getFieldLength()))) {
                    errorMsg.append(display).append("-" + strVal + "-").append("\u6570\u636e\u957f\u5ea6(").append(strLength).append(")\u8d85\u8fc7\u4e86\u8868\u5355\u8bbe\u7f6e\u957f\u5ea6(").append(fieldLength).append(")");
                    continue;
                }
                if (!Enums.FieldType.DECIMAL.getKey().equalsIgnoreCase(ffb.getFieldType())) continue;
                int length = strVal.length();
                if (strVal.contains(".")) {
                    --length;
                }
                int fieldLength2 = Integer.parseInt(ffb.getFieldLength());
                if (length > Integer.parseInt(ffb.getFieldLength())) {
                    errorMsg.append(display).append("-" + strVal + "-").append("\u6570\u636e\u957f\u5ea6(").append(length).append(")\u8d85\u8fc7\u4e86\u8868\u5355\u8bbe\u7f6e\u957f\u5ea6(").append(fieldLength2).append(")");
                    continue;
                }
                FormRelation formRelation = ffb.getFormRelation();
                boolean isRelationEnum = false;
                if (formRelation != null && FormRelationEnums.ToRelationAttrType.data_relation_multiEnum.getKey() == formRelation.getToRelationAttrType().intValue()) {
                    isRelationEnum = true;
                }
                if (FormFieldComEnum.RADIO.getKey().equalsIgnoreCase(ffb.getInputType()) || FormFieldComEnum.SELECT.getKey().equalsIgnoreCase(ffb.getInputType()) || isRelationEnum || FormFieldUtil.checkNumberDigitLength((FormFieldBean)ffb, (Object)strVal)) continue;
                errorMsg.append(display).append("-" + strVal + "-").append("\u6570\u5b57\u5c0f\u6570\u4f4d\u4e0d\u6b63\u786e\u5e94\u4e3a" + ffb.getDigitNum() + ";");
            }
            if (!isSub && !uniqueMap.isEmpty()) {
                for (String display : uniqueMap.keySet()) {
                    String[] returnFields = new String[]{Enums.MasterTableField.id.getKey()};
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    valueMap.put(fb.getFieldBeanByDisplay(display).getName(), uniqueMap.get(display));
                    FormFieldBean ffb = fb.getFieldBeanByDisplay(display);
                    try {
                        List<Map> reList = this.cap4FormDataDAO.getValueByMap(returnFields, valueMap, ffb.getOwnerTableName(), "AND");
                        if (reList != null && reList.size() > 0) {
                            String reId = String.valueOf(reList.get(0).get(Enums.MasterTableField.id.getKey()));
                            if (id == Long.valueOf(reId)) continue;
                            errorMsg.append(display).append("\u672a\u8bbe\u7f6e\u5728\u552f\u4e00\u6027\u6570\u7ec4\u4e2d\u6216\u552f\u4e00\u6570\u7ec4\u4e2d\u6709\u672a\u8bbe\u7f6e\u6570\u636e\u552f\u4e00\u7684\u503c!");
                            continue;
                        }
                        if (id == -1L) continue;
                        errorMsg.append(display).append("\u672a\u8bbe\u7f6e\u5728\u552f\u4e00\u6027\u6570\u7ec4\u4e2d!");
                    }
                    catch (Exception e) {
                        errorMsg.append(display).append("\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38" + ffb.getDigitNum() + ";");
                        LOGGER.error((Object)"\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                        throw new BusinessException("\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
        }
        return errorMsg.toString();
    }

    public Map<String, String> getFormDataRightInfo(Long formId, String rightId, CtpContentAll ctpContentAll, String lang) throws BusinessException {
        Map<String, String> map;
        boolean pc = false;
        boolean phone = false;
        if (Strings.isBlank((String)rightId)) {
            if (ctpContentAll != null && ctpContentAll.getContentType().equals(MainbodyType.HTML.getKey())) {
                Map dataMap;
                map = (Map)JSONUtil.parseJSONString((String)ctpContentAll.getContent());
                if (map.get("formRightInfo") != null) {
                    return (Map)map.get("formRightInfo");
                }
                String phoneValue = String.valueOf(Constants.login_sign.phone.value());
                String pcValue = String.valueOf(Constants.login_sign.pc.value());
                if (map.get(phoneValue) != null) {
                    dataMap = (Map)((Object)map.get(phoneValue));
                    boolean bl = phone = !dataMap.isEmpty();
                }
                if (map.get(pcValue) != null) {
                    dataMap = (Map)((Object)map.get(pcValue));
                    pc = !dataMap.isEmpty();
                }
            } else {
                LOGGER.error((Object)"getFormRightInfo rightId is blank and content is null or is not html contentType");
            }
        } else {
            FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            if (rightId.contains("_") || rightId.contains(".")) {
                String[] viewStrs = rightId.split("_");
                for (int i = 0; !(i >= viewStrs.length || phone && pc); ++i) {
                    String rightIdStr = viewStrs[i].contains(".") ? viewStrs[i].split("\\.")[1] : viewStrs[i];
                    FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightIdStr)));
                    if (formAuthViewBean == null) {
                        LOGGER.error((Object)("getFormRightInfo rightId formAuthViewBean is null, rightIdStr:" + rightIdStr + ", formId: " + formId + ", rightId:" + rightId));
                        continue;
                    }
                    FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId(), lang);
                    if (formViewBean == null) {
                        LOGGER.error((Object)("getFormRightInfo rightId formViewBean is null, rightIdStr:" + rightIdStr + ", formId: " + formId + ", rightId:" + rightId));
                        continue;
                    }
                    boolean hasField = formViewBean.hasFields();
                    if (formViewBean.isPhone() && !phone && hasField) {
                        phone = true;
                    }
                    if (!formViewBean.isPc() || pc || !hasField) continue;
                    pc = true;
                }
            } else {
                FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightId)));
                if (formAuthViewBean == null) {
                    LOGGER.error((Object)("getFormRightInfo rightId formAuthViewBean is null, rightIdStr:" + rightId + ", formId: " + formId + ", rightId:" + rightId));
                } else {
                    FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId(), lang);
                    if (formViewBean != null) {
                        phone = formViewBean.isPhone();
                        pc = formViewBean.isPc();
                    }
                }
            }
        }
        map = new HashMap<String, String>();
        map.put("pc", pc ? "1" : "0");
        map.put("phone", phone ? "1" : "0");
        return map;
    }

    public String getConditionJson(String formula) {
        return FormUtil.getConditionJson((String)formula);
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public FormTableValueSignDAO getFormTableValueSignDAO() {
        return this.formTableValueSignDAO;
    }

    public void setFormTableValueSignDAO(FormTableValueSignDAO formTableValueSignDAO) {
        this.formTableValueSignDAO = formTableValueSignDAO;
    }

    public CAP4FormDataDAO getCap4FormDataDAO() {
        return this.cap4FormDataDAO;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public CAP4FormDataManager getCap4FormDataManager() {
        return this.cap4FormDataManager;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public CAP4FormBindDesignManager getCap4FormBindDesignManager() {
        return this.cap4FormBindDesignManager;
    }

    public void setCap4FormBindDesignManager(CAP4FormBindDesignManager cap4FormBindDesignManager) {
        this.cap4FormBindDesignManager = cap4FormBindDesignManager;
    }

    public CAP4FormListManager getCap4FormListManager() {
        return this.cap4FormListManager;
    }

    public void setCap4FormListManager(CAP4FormListManager cap4FormListManager) {
        this.cap4FormListManager = cap4FormListManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public void setCtpMainbodyManager(MainbodyManager ctpMainbodyManager) {
        this.ctpMainbodyManager = ctpMainbodyManager;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public OnlineManager getOnlineManager() {
        return this.onlineManager;
    }

    public void setOnlineManager(OnlineManager onlineManager) {
        this.onlineManager = onlineManager;
    }

    public void setCap4FormResourceDAO(CAP4FormResourceDAO cap4FormResourceDAO) {
        this.cap4FormResourceDAO = cap4FormResourceDAO;
    }

    public void setFormulaDAO(FormulaDAO formulaDAO) {
        this.formulaDAO = formulaDAO;
    }

    public void setFormulaConditionDAO(FormulaConditionDAO formulaConditionDAO) {
        this.formulaConditionDAO = formulaConditionDAO;
    }

    public void setFormOwnerDAO(FormOwnerDAO formOwnerDAO) {
        this.formOwnerDAO = formOwnerDAO;
    }

    public void setFormCustomFunctionDAO(FormCustomFunctionDAO formCustomFunctionDAO) {
        this.formCustomFunctionDAO = formCustomFunctionDAO;
    }

    public void setSerialNumberManager(SerialNumberManager serialNumberManager) {
        this.serialNumberManager = serialNumberManager;
    }

    public void setCap4SerialNumberManager(CAP4SerialNumberManager cap4SerialNumberManager) {
        this.cap4SerialNumberManager = cap4SerialNumberManager;
    }

    public CAP4FormCustomFunctionManager getCap4FormCustomFunctionManager() {
        return this.cap4FormCustomFunctionManager;
    }

    public void setCap4FormCustomFunctionManager(CAP4FormCustomFunctionManager cap4FormCustomFunctionManager) {
        this.cap4FormCustomFunctionManager = cap4FormCustomFunctionManager;
    }

    public void setEnumBindManager(EnumBindManager enumBindManager) {
        this.enumBindManager = enumBindManager;
    }

    public void setCap4FormDefinitionDAO(CAP4FormDefinitionDAO cap4FormDefinitionDAO) {
        this.cap4FormDefinitionDAO = cap4FormDefinitionDAO;
    }

    public void setFormAuthModuleDAO(FormAuthModuleDAO formAuthModuleDAO) {
        this.formAuthModuleDAO = formAuthModuleDAO;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public void setRelationDAO(FormRelationDAO formRelationDAO) {
        this.formRelationDAO = formRelationDAO;
    }

    public void setPrivilegeMenuManager(PrivilegeMenuManager privilegeMenuManager) {
        this.privilegeMenuManager = privilegeMenuManager;
    }

    public void setPortalApi(PortalApi portalApi) {
        this.portalApi = portalApi;
    }

    public void setCap4FormDesignManager(CAP4FormDesignManager cap4FormDesignManager) {
        this.cap4FormDesignManager = cap4FormDesignManager;
    }

    public void setSeeyonreportApi(SeeyonreportApi seeyonreportApi) {
        this.seeyonreportApi = seeyonreportApi;
    }

    public ICAP4MagicManager getCap4MagicManager() {
        return this.cap4MagicManager;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }
}

