/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.service;

import com.seeyon.cap4.form.modules.business.BusinessManagerImpl;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManager;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.modules.engin.formula.FormulaFunctionUitl;
import com.seeyon.cap4.form.modules.engin.plugin.CAPFormPluginManager;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.importandexport.BusinessImportAndExportManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.monitor.service.MonitorConfigServiceImpl;
import com.seeyon.cap4.monitor.service.SlowSqlServiceImpl;
import com.seeyon.cap4.task.ReportTaskExecuteManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.validity.service.ValidateManagerImpl;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.report.utils.ReportDBUtils;
import com.seeyon.ctp.util.JDBCAgent;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;

public class CAP4FormSystemInitializer
extends AbstractSystemInitializer {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormSystemInitializer.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormDesignManager cap4FormDesignManager;
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private ReportTaskExecuteManager reportTaskExecuteManager;
    private CAPFormDataCacheManager capFormDataCacheManager;
    private CAPFormManager capFormManager;
    private CAPFormPluginManager capFormPluginManager;
    private BusinessImportAndExportManager businessImportAndExportManager;

    public void setCapFormManager(CAPFormManager capFormManager) {
        this.capFormManager = capFormManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormDesignManager(CAP4FormDesignManager cap4FormDesignManager) {
        this.cap4FormDesignManager = cap4FormDesignManager;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setReportTaskExecuteManager(ReportTaskExecuteManager reportTaskExecuteManager) {
        this.reportTaskExecuteManager = reportTaskExecuteManager;
    }

    public void setCapFormDataCacheManager(CAPFormDataCacheManager capFormDataCacheManager) {
        this.capFormDataCacheManager = capFormDataCacheManager;
    }

    public void setCapFormPluginManager(CAPFormPluginManager capFormPluginManager) {
        this.capFormPluginManager = capFormPluginManager;
    }

    public void setBusinessImportAndExportManager(BusinessImportAndExportManager businessImportAndExportManager) {
        this.businessImportAndExportManager = businessImportAndExportManager;
    }

    public void initialize() {
        this.cap4FormCacheManager.initing = true;
        if (this.capFormManager.isUseProc()) {
            this.initSerialNumberProcedure();
        }
        this.initFormOnStart();
        this.cap4FormCacheManager.initing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSerialNumberProcedure() {
        LOGGER.info((Object)"\u6821\u9a8c\u6570\u636e\u5e93\u4e2d\u662f\u5426\u5b58\u5728\u6d41\u6c34\u53f7\u5b58\u50a8\u8fc7\u7a0b\u5f00\u59cb");
        JDBCAgent jdbc = new JDBCAgent();
        Connection rawConnection = null;
        try {
            String dbType = jdbc.getDBType();
            rawConnection = JDBCAgent.getRawConnection();
            String dbName = rawConnection.getCatalog();
            String sql = this.getQuerySql(dbType, dbName);
            int count = 0;
            jdbc.execute(sql);
            ResultSet result = jdbc.getQueryResult();
            if (null != result && result.next()) {
                count = result.getInt(1);
            }
            if (count <= 0) {
                LOGGER.info((Object)"\u6570\u636e\u5e93\u4e2d\u6ca1\u6709\u6d41\u6c34\u53f7\u5b58\u50a8\u8fc7\u7a0b\uff0c\u9700\u91cd\u65b0\u751f\u6210\u5b58\u50a8\u8fc7\u7a0b\u3002");
                String procedureSql = this.getProcedureSql(dbType);
                if (procedureSql.isEmpty()) {
                    LOGGER.warn((Object)"\u83b7\u53d6\u751f\u6210\u6d41\u6c34\u53f7\u7684\u5b58\u50a8\u8fc7\u7a0b\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u6587\u4ef6\u540d\u53ca\u6587\u4ef6\u5b58\u653e\u4f4d\u7f6e\u662f\u5426\u7b26\u5408\u8981\u6c42\uff01");
                    return;
                }
                jdbc.execute(procedureSql);
            } else {
                LOGGER.info((Object)"\u6570\u636e\u5e93\u4e2d\u5df2\u6709\u6d41\u6c34\u53f7\u5b58\u50a8\u8fc7\u7a0b");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            jdbc.close();
            if (null != rawConnection) {
                try {
                    rawConnection.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        LOGGER.info((Object)"\u6821\u9a8c\u6570\u636e\u5e93\u4e2d\u662f\u5426\u5b58\u5728\u6d41\u6c34\u53f7\u5b58\u50a8\u8fc7\u7a0b\u7ed3\u675f");
    }

    private String getQuerySql(String dbType, String dbName) {
        String sql = "";
        String sqlFormat = "SELECT count(1) from %s WHERE %s";
        if (ReportDBUtils.isSQLServerRuntime()) {
            sql = String.format(sqlFormat, "sys.procedures", "name='proc_nextserialnumber' AND type='P'");
        } else if (ReportDBUtils.isOracleRuntime() || ReportDBUtils.isDMSQLRuntime() || JDBCAgent.isKingBaseesRunTime()) {
            sql = String.format(sqlFormat, "user_objects", "object_type='PROCEDURE' AND object_name='proc_nextserialnumber' OR object_name='PROC_NEXTSERIALNUMBER'");
        } else if (ReportDBUtils.isMySQLRuntime()) {
            sql = String.format(sqlFormat, "mysql.proc", "db='" + dbName + "' AND type='PROCEDURE' AND name='proc_nextserialnumber'");
        } else if (ReportDBUtils.isPostgreSQLRuntime()) {
            sql = String.format(sqlFormat, "pg_proc", "proname='proc_nextserialnumber'");
        }
        return sql;
    }

    private String getProcedureSql(String dbType) {
        File sqlDir = new File(AppContext.getCfgHome(), "startup" + File.separator + "procedures");
        File[] files = sqlDir.listFiles();
        if (files.length < 1) {
            LOGGER.warn((Object)(AppContext.getCfgHome() + File.separator + "sql" + File.separator + "procedures\u4e0d\u5b58\u5728\u751f\u6210\u6d41\u6c34\u53f7\u7684\u5b58\u50a8\u8fc7\u7a0b\u6587\u4ef6\uff01"));
            return "";
        }
        for (File file : files) {
            String fileName = file.getName().toLowerCase();
            if (fileName.contains(dbType)) {
                return FileUtil.readFile((File)file);
            }
            if (!fileName.contains("server") || !ReportDBUtils.isSQLServerRuntime()) continue;
            return FileUtil.readFile((File)file);
        }
        return "";
    }

    private void initFormOnStart() {
        try {
            this.cap4FormDesignManager.init();
        }
        catch (BusinessException e) {
            LOGGER.info((Object)("Initialization form design failed:" + e.getMessage()), (Throwable)e);
        }
        FormulaFunctionUitl.init();
        Long start = System.currentTimeMillis();
        FormTriggerUtil.init();
        Long end = System.currentTimeMillis();
        LOGGER.info((Object)("FormTriggerUtil.init\u6267\u884c\u8017\u65f6\uff1a" + (end - start)));
        try {
            start = System.currentTimeMillis();
            this.capFormDataCacheManager.init();
            end = System.currentTimeMillis();
            LOGGER.info((Object)("capFormDataCacheManager.init\u6267\u884c\u8017\u65f6\uff1a" + (end - start)));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u521d\u59cb\u5316cap4FormDataCacheManager\u5931\u8d25", (Throwable)e);
        }
        start = System.currentTimeMillis();
        this.cap4FormCacheManager.initialize();
        end = System.currentTimeMillis();
        LOGGER.info((Object)("cap4FormCacheManager.initialize\u6267\u884c\u8017\u65f6\uff1a" + (end - start)));
        BusinessManagerImpl businessManager = (BusinessManagerImpl)AppContext.getBean((String)"businessManager4");
        ValidateManagerImpl validateManager = (ValidateManagerImpl)AppContext.getBean((String)"validateManager");
        try {
            start = System.currentTimeMillis();
            validateManager.init();
            end = System.currentTimeMillis();
            LOGGER.info((Object)("validateManager.init\u6267\u884c\u8017\u65f6\uff1a" + (end - start)));
            start = System.currentTimeMillis();
            businessManager.init();
            end = System.currentTimeMillis();
            LOGGER.info((Object)("businessManager.init\u6267\u884c\u8017\u65f6\uff1a" + (end - start)));
        }
        catch (BusinessException var14) {
            LOGGER.error((Object)"\u521d\u59cb\u5316businessManager\u5931\u8d25", (Throwable)var14);
        }
        MonitorConfigServiceImpl monitorConfigService = (MonitorConfigServiceImpl)AppContext.getBean((String)"monitorConfigService");
        SlowSqlServiceImpl slowSqlService = (SlowSqlServiceImpl)AppContext.getBean((String)"slowSqlService");
        try {
            start = System.currentTimeMillis();
            monitorConfigService.init();
            end = System.currentTimeMillis();
            LOGGER.info((Object)("monitorConfigService.init\u6267\u884c\u8017\u65f6\uff1a" + (end - start)));
            start = System.currentTimeMillis();
            slowSqlService.init();
            end = System.currentTimeMillis();
            LOGGER.info((Object)("slowSqlService.init\u6267\u884c\u8017\u65f6\uff1a" + (end - start)));
        }
        catch (BusinessException var14) {
            LOGGER.error((Object)"\u521d\u59cb\u5316monitorConfigService\u5931\u8d25", (Throwable)var14);
        }
        start = System.currentTimeMillis();
        this.capBusinessTemplateManager.systemStartInitialize();
        end = System.currentTimeMillis();
        LOGGER.info((Object)("capBusinessTemplateManager.systemStartInitialize\u6267\u884c\u8017\u65f6\uff1a" + (end - start)));
        start = System.currentTimeMillis();
        this.capFormPluginManager.initPlugins();
        end = System.currentTimeMillis();
        LOGGER.info((Object)("capFormPluginManager.initFormPlugins\u6267\u884c\u8017\u65f6\uff1a" + (end - start)));
        start = System.currentTimeMillis();
        this.reportTaskExecuteManager.init();
        end = System.currentTimeMillis();
        LOGGER.info((Object)("reportTaskExecuteManager.init\u6267\u884c\u8017\u65f6\uff1a" + (end - start)));
        start = System.currentTimeMillis();
        this.businessImportAndExportManager.init();
        end = System.currentTimeMillis();
        LOGGER.info((Object)("businessImportAndExportManager.init\u6267\u884c\u8017\u65f6\uff1a" + (end - start)));
    }

    public int getSortOrder() {
        return -2;
    }
}

