/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.util;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizMenuAuthCheckInterface;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.BusinessSourceTypeManager;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.modules.business.CtpBizConfigItem;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.modules.component.FormCollectionAscSortComparator;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormCharset;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.BeansOfTypeListener;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgRole;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class BizUtil {
    private static OrgManager orgManager;
    private static CAP4FormCacheManager cap4FormCacheManager;
    private static TemplateManager templateManager;
    private static BusinessManager businessManager4;
    private static CAP4FormManager cap4FormManager;
    private static CapBizConfigItemManager capBizConfigItemManager;
    private static final Log LOGGER;
    private static Map<String, BusinessSourceTypeManager> sourceTypeMap;
    private static Map<String, BusinessSourceTypeManager> sourceTypeMap4code;
    private static Map<String, BusinessSourceTypeManager> sourceTypeMap4CanUse;
    private static Map<String, List<BusinessSourceTypeManager>> subSourceTypeMap;
    private static Map<String, BizMenuAuthCheckInterface> menuAuthCheckMap;
    private static final String URL_NEW_AFFAIRS = "/collaboration.do?method=newColl";
    private static final String URL_TO_SEND_AFFAIRS = "/collaboration.do?method=collaborationFrame&from=WaitSend";
    private static final String URL_SENT_AFFAIRS = "/collaboration.do?method=collaborationFrame&from=Sent";
    private static final String URL_TO_DEAL_AFFAIRS = "/collaboration.do?method=collaborationFrame&from=Pending";
    private static final String URL_DEALT_AFFAIRS = "/collaboration.do?method=collaborationFrame&from=Done";
    private static final String URL_SUPERWISE_AFFAIRS = "/colSupervise.do?method=mainEntry&status=0";
    private static final String URL_FORM_QUERY = "/formquery.do?method=formQueryShow";
    private static final String URL_FORM_STATISTIC = "/formreport.do?method=formReportShow";
    private static final String URL_INFO_CENTER = "/formBizConfig.do?method=enterManagerCenter";

    private BizUtil() {
    }

    private static synchronized void init() {
        sourceTypeMap.clear();
        sourceTypeMap4CanUse.clear();
        subSourceTypeMap.clear();
        sourceTypeMap4code.clear();
        Map sourceTypes = AppContext.getBeansOfType(BusinessSourceTypeManager.class);
        for (Map.Entry et : sourceTypes.entrySet()) {
            String[] codes;
            String baseId;
            sourceTypeMap.put(((BusinessSourceTypeManager)et.getValue()).getId(), (BusinessSourceTypeManager)et.getValue());
            if (((BusinessSourceTypeManager)et.getValue()).canUse()) {
                sourceTypeMap4CanUse.put(((BusinessSourceTypeManager)et.getValue()).getId(), (BusinessSourceTypeManager)et.getValue());
            }
            if (!((BusinessSourceTypeManager)et.getValue()).isBaseSourceType() && Strings.isNotBlank((String)(baseId = ((BusinessSourceTypeManager)et.getValue()).getBaseSourceTypeId()))) {
                List<BusinessSourceTypeManager> tempList = subSourceTypeMap.get(baseId);
                if (tempList == null) {
                    tempList = new ArrayList<BusinessSourceTypeManager>();
                }
                tempList.add((BusinessSourceTypeManager)et.getValue());
                subSourceTypeMap.put(baseId, tempList);
            }
            if (!Strings.isNotBlank((String)((BusinessSourceTypeManager)et.getValue()).getSupportedTypeCode())) continue;
            for (String code : codes = ((BusinessSourceTypeManager)et.getValue()).getSupportedTypeCode().split(",")) {
                sourceTypeMap4code.put(code, (BusinessSourceTypeManager)et.getValue());
            }
        }
    }

    private static void initMenuAuthCheckMap() {
        Map map = AppContext.getBeansOfType(BizMenuAuthCheckInterface.class);
        for (Map.Entry entry : map.entrySet()) {
            menuAuthCheckMap.put(((BizMenuAuthCheckInterface)entry.getValue()).getId(), (BizMenuAuthCheckInterface)entry.getValue());
        }
    }

    public static BizMenuAuthCheckInterface getMenuAuthCheck(String authId) {
        return menuAuthCheckMap.get(authId);
    }

    public static String getMenuAuthCheckId(Long roleId, V3xOrgRole orgRole) throws BusinessException {
        String name = orgRole.getName();
        if (name.startsWith("bizMap_")) {
            return "bizMap";
        }
        boolean isBizConfig = businessManager4.checkBizConfigMenuId(roleId);
        if (isBizConfig) {
            return "formBiz";
        }
        if (!name.contains("_")) {
            LOGGER.warn((Object)("\u89d2\u8272\u7684\u540d\u79f0\u4e0d\u7b26\u5408\u6307\u5b9a\u89c4\u5219\uff01\u89d2\u8272\u540d\u79f0\uff1a" + name));
            return "";
        }
        return name.substring(0, name.indexOf("_"));
    }

    public static BusinessSourceTypeManager getSourceTypeById(String id) {
        return sourceTypeMap.get(id);
    }

    public static BusinessSourceTypeManager getSourceTypeByCode(String code) {
        return sourceTypeMap4code.get(code);
    }

    public static List<BusinessSourceTypeManager> getCanUseSourceTypeList() {
        return BizUtil.getCanUseSourceTypeList(true);
    }

    private static List<BusinessSourceTypeManager> getCanUseSourceTypeList(boolean onlyBaseType) {
        ArrayList<BusinessSourceTypeManager> list = new ArrayList<BusinessSourceTypeManager>();
        for (Map.Entry<String, BusinessSourceTypeManager> et : sourceTypeMap4CanUse.entrySet()) {
            if (onlyBaseType && !et.getValue().isBaseSourceType() || "secondMenuCatg".equals(et.getKey())) continue;
            list.add(et.getValue());
        }
        Collections.sort(list, FormCollectionAscSortComparator.getInstance());
        return list;
    }

    public static String getBaseSourceSupportedTypeCodeContainSubType(String baseTypeId) {
        StringBuilder sb = new StringBuilder(BizUtil.getSourceTypeById(baseTypeId).getSupportedTypeCode());
        List<BusinessSourceTypeManager> list = BizUtil.getSubSourceTypeByBaseTypeId(baseTypeId);
        if (Strings.isNotEmpty(list)) {
            sb.append(",");
            for (BusinessSourceTypeManager sourceType : list) {
                sb.append(sourceType.getSupportedTypeCode()).append(",");
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static List<BusinessSourceTypeManager> getSubSourceTypeByBaseTypeId(String baseTypeId) {
        return subSourceTypeMap.get(baseTypeId);
    }

    public static BusinessSourceTypeManager getSourceTypeFromConfigItem(CtpBizConfigItem item) {
        return BizUtil.getSourceTypeByCode(item.getSourceType() + "");
    }

    public static void getCategoryBO(Map<String, CtpTemplateCategory> catgMap, List<FormAppBO> list, Map<String, CtpTemplateCategory> catgMapAll) throws BusinessException {
        HashMap<String, CtpTemplateCategory> tempMap = new HashMap<String, CtpTemplateCategory>();
        for (Map.Entry<String, CtpTemplateCategory> et : catgMap.entrySet()) {
            CtpTemplateCategory category = et.getValue();
            FormAppBO bo = new FormAppBO();
            if (category.getParentId() != null && (long)ModuleType.form.getKey() != category.getParentId() && (long)ModuleType.collaboration.getKey() != category.getParentId()) {
                CtpTemplateCategory parentCategory = templateManager.getCtpTemplateCategory(category.getParentId());
                if (parentCategory != null) {
                    if (!catgMapAll.containsKey(parentCategory.getName())) {
                        tempMap.put(parentCategory.getName(), parentCategory);
                    }
                    bo.setCategoryId(parentCategory.getName());
                } else {
                    bo.setCategoryId(ModuleType.form.getKey() + "");
                }
            } else {
                bo.setCategoryId(ModuleType.form.getKey() + "");
            }
            bo.setId(category.getName());
            bo.setName(ResourceUtil.getString((String)category.getName()));
            bo.setSourceType(Enums.SourceType.SOURCE_TYPE_PARENT.getKey());
            bo.setSourceValue(category.getId());
            list.add(0, bo);
        }
        if (!tempMap.isEmpty()) {
            catgMapAll.putAll(tempMap);
            BizUtil.getCategoryBO(tempMap, list, catgMapAll);
        }
    }

    public static List<FormBean> getFormBeanList(User u, Long accountId, boolean isAll, boolean containCurrentForm) throws BusinessException {
        Long accId;
        User user = u;
        if (user == null) {
            user = AppContext.getCurrentUser();
        }
        if ((accId = accountId) == null) {
            accId = user.getLoginAccount();
        }
        ArrayList<FormBean> list = new ArrayList<FormBean>();
        List<FormBean> formList = cap4FormCacheManager.getFormList();
        for (FormBean formBean : formList) {
            if (!cap4FormCacheManager.isEnabled(formBean.getId())) continue;
            if (isAll) {
                V3xOrgMember member = orgManager.getMemberById(Long.valueOf(formBean.getOwnerId()));
                if (member == null || !member.getOrgAccountId().equals(accId)) continue;
                list.add(formBean);
                continue;
            }
            if (formBean.getOwnerId() != user.getId().longValue()) continue;
            list.add(formBean);
        }
        if (containCurrentForm) {
            // empty if block
        }
        return list;
    }

    public static List<FormBean> getFormBeanList(User u, boolean isAll) throws BusinessException {
        return BizUtil.getFormBeanList(u, null, isAll, false);
    }

    public static List<FormBean> getFormBeanListByBizId(User u, boolean isAll, Long bizId) throws BusinessException {
        User user = u;
        if (user == null) {
            user = AppContext.getCurrentUser();
        }
        Long accId = user.getLoginAccount();
        ArrayList<FormBean> list = new ArrayList<FormBean>();
        List<CapBizConfigItem> formList = capBizConfigItemManager.findByBizId(bizId);
        for (CapBizConfigItem capBizConfigItem : formList) {
            FormBean formBean = cap4FormCacheManager.getForm(capBizConfigItem.getFormId());
            if (formBean == null || !cap4FormCacheManager.isEnabled(formBean.getId())) continue;
            if (isAll) {
                V3xOrgMember member = orgManager.getMemberById(Long.valueOf(formBean.getOwnerId()));
                if (member == null || !member.getOrgAccountId().equals(accId)) continue;
                list.add(formBean);
                continue;
            }
            if (formBean.getOwnerId() != user.getId().longValue()) continue;
            list.add(formBean);
        }
        return list;
    }

    public static List<FormBean> getFormBeanList(Long categoryId, List<FormBean> formList) {
        ArrayList<FormBean> list = new ArrayList<FormBean>();
        for (FormBean formBean : formList) {
            if (formBean.getCategoryId() != categoryId.longValue()) continue;
            list.add(formBean);
        }
        return list;
    }

    public static boolean searchByCatg(String catgId, Long catg) throws BusinessException {
        Long catgS = Long.parseLong(catgId);
        return BizUtil.searchByCatg(catgS, catg);
    }

    private static boolean searchByCatg(Long catgId, Long catg) throws BusinessException {
        CtpTemplateCategory categoryS = templateManager.getCtpTemplateCategory(catgId);
        CtpTemplateCategory category = templateManager.getCtpTemplateCategory(catg);
        return categoryS.getName().equals(category.getName());
    }

    public static String getAction(Long menuId, Integer menuType, int sourceTypeInt, Long sourceId, Long formId, String name1, String name2, Long bizId) {
        Enums.SourceType sourceType = Enums.SourceType.getEnumByKey((int)sourceTypeInt);
        String menuName1 = name1;
        String menuName2 = name2;
        try {
            menuName1 = URLEncoder.encode(menuName1, FormCharset.getInstance().getSystemDefaultCharset());
            menuName2 = URLEncoder.encode(menuName2, FormCharset.getInstance().getSystemDefaultCharset());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        String action = "";
        switch (sourceType) {
            case SOURCE_TYPE_FLOWTEMPLATE: {
                if (menuType == 1) {
                    action = "/collaboration/collaboration.do?method=newColl&from=bizconfig&firstName=" + menuName1 + "&secondName=" + menuName2 + "&menuId=" + menuId + "&templateId=" + sourceId;
                    break;
                }
                if (menuType != 2) break;
                action = "/form/business.do?method=listBizColList&srcFrom=bizconfig&firstName=" + menuName1 + "&secondName=" + menuName2 + "&menuId=" + menuId + "&templeteId=" + sourceId;
                break;
            }
            case SOURCE_TYPE_INFOMANAGE: {
                action = "/cap4/businessTemplateController.do?method=capUnflowList&srcFrom=bizconfig&businessId=" + bizId + "&moduleId=" + sourceId + "&formId=" + formId + "&type=baseInfo&tag=" + new Date().getTime();
                break;
            }
            case SOURCE_TYPE_BASEDATA: {
                action = "/form/formData.do?method=getFormMasterDataList&srcFrom=bizconfig&firstName=" + menuName1 + "&secondName=" + menuName2 + "&formId=" + formId + "&formTemplateId=" + sourceId + "&type=baseInfo";
                break;
            }
            case SOURCE_TYPE_FLOWBUSINESS: {
                action = "/cap4/businessTemplateController.do?method=capFlowListNew&srcFrom=bizconfig&businessId=" + bizId + "&moduleId=" + sourceId + "&formId=" + formId;
                break;
            }
            case SOURCE_TYPE_QUERY: {
                action = "/report4Result.do?method=showResult&designType=QUERY&designId=" + sourceId + "&businessId=" + bizId;
                break;
            }
            case SOURCE_TYPE_REPORT: {
                action = "/report4Result.do?method=showResult&designType=STATISTICS&designId=" + sourceId + "&businessId=" + bizId;
                break;
            }
            case SOURCE_TYPE_DOCUMENT: {
                action = "/doc.do?method=docHomepageIndex&srcFrom=bizconfig&firstName=" + menuName1 + "&secondName=" + menuName2 + "&docResId=" + sourceId;
                break;
            }
            case SOURCE_TYPE_ADMIN_BUL: 
            case SOURCE_TYPE_GROUP_BUL: {
                action = "/bulData.do?method=bulIndex&typeId=" + sourceId;
                break;
            }
            case SOURCE_TYPE_ADMIN_NEWS: 
            case SOURCE_TYPE_GROUP_NEWS: {
                action = "/newsData.do?method=newsIndex&boardId=" + sourceId;
                break;
            }
            case SOURCE_TYPE_ADMIN_BBS: 
            case SOURCE_TYPE_GROUP_BBS: {
                action = "/bbs.do?method=bbsIndex&boardId=" + sourceId;
                break;
            }
            case SOURCE_TYPE_ADMIN_INQUIRY: 
            case SOURCE_TYPE_GROUP_INQUIRY: {
                action = "/inquiryData.do?method=inquiryBoardIndex&boardId=" + sourceId;
                break;
            }
            case SOURCE_TYPE_SEEYONREPORT: {
                action = "/seeyonReport/seeyonReportController.do?method=redirectSeeyonReport&templateId=" + sourceId + "&openFrom=biz";
                break;
            }
            case SOURCE_TYPE_BIZMAP: {
                action = "/form/bizMap.do?method=viewBizMap&srcFrom=bizconfig&mapId=" + sourceId;
                break;
            }
            case SOURCE_TYPE_BIZHOMEPAGE: {
                action = "/cap4/businessTemplateController.do?method=businessIndex&bussId=" + bizId;
                break;
            }
        }
        return action;
    }

    public static String getAction4Section(Long sectionId, Enums.FormMenuCategory category, String menuId, String templateIds) {
        String url = "";
        switch (category) {
            case FORM_MENU_FORMQUERY: {
                url = "/form/formSection.do?method=formSearch&srcFrom=formsection&sectionId=" + sectionId;
                break;
            }
            case FORM_MENU_FORMSTAT: {
                url = "/form/formSection.do?method=formStatistics&srcFrom=formsection&sectionId=" + sectionId;
                break;
            }
            case FORM_MENU_INFOCENTER: {
                url = "/form/formSection.do?method=messageCenter&sectionId=" + sectionId + "&type=flow&column=Pending";
                break;
            }
            case FORM_MENU_LISTDONE: {
                url = "/form/formSection.do?method=getColUrl&type=listDone&sectionId=" + sectionId;
                break;
            }
            case FORM_MENU_LISTPEND: {
                url = "/form/formSection.do?method=getColUrl&type=listPending&sectionId=" + sectionId;
                break;
            }
            case FORM_MENU_LISTSEND: {
                url = "/form/formSection.do?method=getColUrl&type=listSent&sectionId=" + sectionId;
                break;
            }
            case FORM_MENU_LISTSUPERVISE: {
                url = "/form/formSection.do?method=getColUrl&type=listSupervise&sectionId=" + sectionId;
                break;
            }
            case FORM_MENU_NEW: {
                url = "/collaboration/collaboration.do?method=newColl&templateId=" + menuId;
                break;
            }
            case FORM_MENU_WAITSEND: {
                url = "/form/formSection.do?method=getColUrl&type=listWaitSend&sectionId=" + sectionId;
                break;
            }
        }
        return url;
    }

    public static Enums.FormMenuCategory getCategoryNum(String actionUrl) {
        Enums.FormMenuCategory result = null;
        if (actionUrl.contains(URL_NEW_AFFAIRS)) {
            result = Enums.FormMenuCategory.FORM_MENU_NEW;
        } else if (actionUrl.contains(URL_TO_SEND_AFFAIRS)) {
            result = Enums.FormMenuCategory.FORM_MENU_WAITSEND;
        } else if (actionUrl.contains(URL_SENT_AFFAIRS)) {
            result = Enums.FormMenuCategory.FORM_MENU_LISTSEND;
        } else if (actionUrl.contains(URL_TO_DEAL_AFFAIRS)) {
            result = Enums.FormMenuCategory.FORM_MENU_LISTPEND;
        } else if (actionUrl.contains(URL_DEALT_AFFAIRS)) {
            result = Enums.FormMenuCategory.FORM_MENU_LISTDONE;
        } else if (actionUrl.contains(URL_SUPERWISE_AFFAIRS)) {
            result = Enums.FormMenuCategory.FORM_MENU_LISTSUPERVISE;
        } else if (actionUrl.contains(URL_FORM_QUERY)) {
            result = Enums.FormMenuCategory.FORM_MENU_FORMQUERY;
        } else if (actionUrl.contains(URL_FORM_STATISTIC)) {
            result = Enums.FormMenuCategory.FORM_MENU_FORMSTAT;
        } else if (actionUrl.contains(URL_INFO_CENTER)) {
            result = Enums.FormMenuCategory.FORM_MENU_INFOCENTER;
        }
        return result;
    }

    public static List<FormAppBO> getFormAppBo4Query(User user, String conditionType, String conditionValue, boolean isAll, boolean containCurrentForm, Long bizId) throws BusinessException {
        ArrayList<FormAppBO> list = new ArrayList<FormAppBO>();
        BizConfigBean bizConfigBean = null;
        if (bizId != null) {
            bizConfigBean = businessManager4.findBizConfigById(bizId);
            FormAppBO root = new FormAppBO();
            root.setId(String.valueOf(bizConfigBean.getId()));
            root.setName(ResourceUtil.getString((String)"cap4.form.business.common.menuType.query"));
            root.setTitle(bizConfigBean.getName());
            root.setSourceType(Enums.SourceType.SOURCE_TYPE_PARENT.getKey());
            list.add(root);
        }
        ReportApi reportApi = (ReportApi)AppContext.getBean((String)"reportApi");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("category", ApplicationCategoryEnum.cap4biz.name());
        params.put("categoryId", bizId == null ? "" : bizId.toString());
        params.put("designType", ReportConstants.DesignType.QUERY.name());
        if (Strings.isNotBlank((String)conditionType) && "subject".equals(conditionType)) {
            params.put("title_like", conditionValue);
        }
        List reportList = reportApi.findDesignWithoutAuth(params);
        for (Map map : reportList) {
            FormAppBO bo = new FormAppBO();
            bo.setId(String.valueOf(map.get("designId")));
            bo.setTitle(String.valueOf(map.get("title")));
            bo.setName(String.valueOf(map.get("title")));
            bo.setCategoryId(bizConfigBean != null ? String.valueOf(bizConfigBean.getId()) : String.valueOf(map.get("categoryId")));
            bo.setSourceType(Enums.SourceType.SOURCE_TYPE_QUERY.getKey());
            bo.setSourceValue((Long)map.get("designId"));
            list.add(bo);
        }
        return list;
    }

    public static List<FormAppBO> getFormAppBo4Report(User user, Long accountId, boolean isAll, String conditionType, String conditionValue, String layoutType, boolean containCurrentForm, Long bizId) throws BusinessException {
        ArrayList<FormAppBO> list = new ArrayList<FormAppBO>();
        BizConfigBean bizConfigBean = null;
        if (bizId != null) {
            bizConfigBean = businessManager4.findBizConfigById(bizId);
            FormAppBO root = new FormAppBO();
            root.setId(bizConfigBean.getId().toString());
            root.setName(ResourceUtil.getString((String)"cap4.form.business.common.menuType.statistical"));
            root.setTitle(bizConfigBean.getName());
            root.setSourceType(Enums.SourceType.SOURCE_TYPE_PARENT.getKey());
            list.add(root);
        }
        ReportApi reportApi = (ReportApi)AppContext.getBean((String)"reportApi");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("category", ApplicationCategoryEnum.cap4biz.name());
        params.put("categoryId", bizId == null ? "" : bizId.toString());
        params.put("designTypeList", new String[]{ReportConstants.DesignType.STATISTICS.name(), ReportConstants.DesignType.MULTSTATS.name(), ReportConstants.DesignType.SCHEDULEDSTATS.name()});
        if (Strings.isNotBlank((String)conditionType) && "subject".equals(conditionType)) {
            params.put("title_like", conditionValue);
        }
        List reportList = reportApi.findDesignWithoutAuth(params);
        for (Map map : reportList) {
            FormAppBO bo = new FormAppBO();
            bo.setId(String.valueOf(map.get("designId")));
            bo.setTitle(String.valueOf(map.get("title")));
            bo.setName(String.valueOf(map.get("title")));
            bo.setCategoryId(bizConfigBean != null ? String.valueOf(bizConfigBean.getId()) : String.valueOf(map.get("categoryId")));
            bo.setSourceType(Enums.SourceType.SOURCE_TYPE_REPORT.getKey());
            bo.setSourceValue((Long)map.get("designId"));
            list.add(bo);
        }
        return list;
    }

    static {
        LOGGER = CtpLogFactory.getLog(BizUtil.class);
        sourceTypeMap = new LinkedHashMap<String, BusinessSourceTypeManager>();
        sourceTypeMap4code = new LinkedHashMap<String, BusinessSourceTypeManager>();
        sourceTypeMap4CanUse = new LinkedHashMap<String, BusinessSourceTypeManager>();
        subSourceTypeMap = new LinkedHashMap<String, List<BusinessSourceTypeManager>>();
        menuAuthCheckMap = new LinkedHashMap<String, BizMenuAuthCheckInterface>();
        orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
        businessManager4 = (BusinessManager)AppContext.getBean((String)"businessManager4");
        cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");
        capBizConfigItemManager = (CapBizConfigItemManager)AppContext.getBean((String)"capBizConfigItemManager");
        BizUtil.init();
        AppContext.addBeansOfTypeListener(BusinessSourceTypeManager.class, (BeansOfTypeListener)new BeansOfTypeListener(){

            public void onChange(Class clazz) {
                BizUtil.init();
            }
        });
        BizUtil.initMenuAuthCheckMap();
    }
}

