/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.util;

import com.seeyon.apps.mplus.api.MplusApi;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessAuthorityManager;
import com.seeyon.cap4.form.modules.business.BusinessSourceTypeManager;
import com.seeyon.cap4.form.modules.business.CtpBizConfigItem;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.modules.component.FormCollectionAscSortComparator;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.BizUtil;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.StringUtils;
import com.seeyon.cap4.validity.service.CloudResourceManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.constants.ProductEditionEnum;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.content.mainbody.MainbodyService;
import com.seeyon.ctp.common.datai18n.manager.DataI18nManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.common.usermessage.MessageContent;
import com.seeyon.ctp.common.usermessage.MessageReceiver;
import com.seeyon.ctp.common.usermessage.UserMessageManager;
import com.seeyon.ctp.form.modules.bizmap.manager.BizMapManager;
import com.seeyon.ctp.form.po.CtpBizMap;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.V3xOrgEntity;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.dao.OrgHelper;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.portal.api.PortalApi;
import com.seeyon.ctp.portal.nav.bo.PortalNavBo;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.privilege.enums.PrivMenuTypeEnums;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.PageContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class BusinessUtil {
    private static OrgManager orgManager;
    private static UserMessageManager userMessageManager;
    private static TemplateManager templateManager;
    private static CAP4FormCacheManager cap4FormCacheManager;
    private static final Log LOGGER;
    private static BizMapManager bizMapManager;

    public static boolean isA6pOrNoCapAdvance() {
        Integer productId = SystemProperties.getInstance().getIntegerProperty("system.ProductId");
        if (ProductEditionEnum.a6p.ordinal() == productId.intValue() || ProductEditionEnum.a6.ordinal() == productId.intValue()) {
            return true;
        }
        if (SystemEnvironment.isTG()) {
            // empty if block
        }
        return !AppContext.hasPlugin((String)"cap_advance");
    }

    public static Set<Long> getAuthIds(String auth) throws BusinessException {
        String[] authId;
        HashSet<Long> set = new HashSet<Long>();
        if (Strings.isBlank((String)auth)) {
            return set;
        }
        for (String string : authId = auth.split(",")) {
            if (string.indexOf("|") == -1) continue;
            String[] sectionRight = string.split("\\|");
            List members = orgManager.getMembersByType(sectionRight[0], sectionRight[1]);
            set.addAll(OrgHelper.getEntityIds2((Collection)members));
        }
        return set;
    }

    public static String[] getAuthName(Long roleId) throws BusinessException {
        List authList = orgManager.getEntitysByRole(null, roleId);
        String value = "";
        String text = "";
        for (V3xOrgEntity auth : authList) {
            if (auth == null) continue;
            value = value + auth.getEntityType() + "|" + auth.getId() + ",";
        }
        if (Strings.isNotBlank((String)value)) {
            value = value.substring(0, value.length() - 1);
            PageContext p = null;
            text = Functions.showOrgEntities((String)value, p);
        }
        return new String[]{value, text};
    }

    public static boolean checkRight(Long userId, String authId) throws BusinessException {
        String[] orgTypes = new String[]{Enums.FormModuleAuthOrgType.Member.getText(), Enums.FormModuleAuthOrgType.Department.getText(), Enums.FormModuleAuthOrgType.Level.getText(), Enums.FormModuleAuthOrgType.Post.getText(), Enums.FormModuleAuthOrgType.Team.getText(), Enums.FormModuleAuthOrgType.Account.getText(), Enums.FormModuleAuthOrgType.BusinessAccount.getText(), Enums.FormModuleAuthOrgType.BusinessDepartment.getText()};
        List list = orgManager.getUserDomainIDs(userId, orgTypes);
        HashSet sLongs = new HashSet(list);
        if (Strings.isNotEmpty((String)authId)) {
            String[] authIdArray;
            for (String auth : authIdArray = authId.split(",")) {
                Long authIdL = Long.parseLong(auth.split("\\|")[1]);
                if (!sLongs.contains(authIdL)) continue;
                return true;
            }
        }
        return false;
    }

    public static void sendMsg(CapBizConfig biz, BizConfigBean oldBiz) throws BusinessException {
        String newAuth;
        String oldAuth;
        if (oldBiz == null || oldBiz.getUpdateDate() == null) {
            oldAuth = "";
            if (biz == null && null != oldBiz) {
                oldAuth = oldBiz.getAuthValue();
            }
        } else {
            oldAuth = oldBiz.getAuthValue();
        }
        if (biz == null) {
            newAuth = "";
            biz = oldBiz;
        } else {
            newAuth = (String)biz.getExtraAttr("BIZ_AUTHORITY_VALUE");
        }
        if (biz == null) {
            return;
        }
        Set<Long> oldShareIds = BusinessUtil.getAuthIds(oldAuth);
        Set<Long> newShareIds = BusinessUtil.getAuthIds(newAuth);
        List sharersAdded = Strings.getAddedCollection(oldShareIds, newShareIds);
        List sharersReduced = Strings.getReducedCollection(oldShareIds, newShareIds);
        if (Strings.isNotEmpty((Collection)sharersAdded)) {
            sharersAdded.remove(AppContext.currentUserId());
            userMessageManager.sendSystemMessage(MessageContent.get((String)"formbizconfig.share.biz", (Object[])new Object[]{AppContext.currentUserName(), biz.getName()}), ApplicationCategoryEnum.form, AppContext.currentUserId(), MessageReceiver.get((Long)biz.getId(), (Collection)sharersAdded), new Object[]{biz.getId()});
        }
        boolean clearBizFlag = false;
        if (biz.getExtraAttr("ClearBizAuth") != null) {
            clearBizFlag = (Boolean)biz.getExtraAttr("ClearBizAuth");
        }
        if (Strings.isNotEmpty((Collection)sharersReduced) && (Strings.isNotEmpty(newShareIds) || clearBizFlag)) {
            sharersReduced.remove(AppContext.currentUserId());
            userMessageManager.sendSystemMessage(MessageContent.get((String)"formbizconfig.sharecancel.biz", (Object[])new Object[]{AppContext.currentUserName(), biz.getName()}), ApplicationCategoryEnum.form, AppContext.currentUserId(), MessageReceiver.get((Long)biz.getId(), (Collection)sharersReduced), new Object[]{biz.getId()});
        }
    }

    public static boolean searchByCatg(String catgId, Long catg) throws BusinessException {
        Long catgS = Long.parseLong(catgId);
        return BusinessUtil.searchByCatg(catgS, catg);
    }

    public static boolean searchByCatg(Long catgId, Long catg) throws BusinessException {
        CtpTemplateCategory categoryS = templateManager.getCtpTemplateCategory(catgId);
        CtpTemplateCategory category = templateManager.getCtpTemplateCategory(catg);
        return categoryS.getName().equals(category.getName());
    }

    public static void getCategoryBO(Map<String, CtpTemplateCategory> catgMap, List<FormAppBO> list, Map<String, CtpTemplateCategory> catgMapAll) throws BusinessException {
        HashMap<String, CtpTemplateCategory> tempMap = new HashMap<String, CtpTemplateCategory>();
        for (Map.Entry<String, CtpTemplateCategory> et : catgMap.entrySet()) {
            CtpTemplateCategory category = et.getValue();
            FormAppBO bo = new FormAppBO();
            if (category.getParentId() != null && (long)ModuleType.form.getKey() != category.getParentId() && (long)ModuleType.collaboration.getKey() != category.getParentId()) {
                CtpTemplateCategory parentCategory = templateManager.getCtpTemplateCategory(category.getParentId());
                if (parentCategory != null) {
                    if (!catgMapAll.containsKey(parentCategory.getName())) {
                        tempMap.put(parentCategory.getName(), parentCategory);
                    }
                    bo.setCategoryId(parentCategory.getName());
                } else {
                    bo.setCategoryId(ModuleType.form.getKey() + "");
                }
            } else {
                bo.setCategoryId(ModuleType.form.getKey() + "");
            }
            bo.setId(category.getName());
            bo.setName(ResourceUtil.getString((String)category.getName()));
            bo.setSourceType(0);
            list.add(0, bo);
        }
        if (!tempMap.isEmpty()) {
            catgMapAll.putAll(tempMap);
            BusinessUtil.getCategoryBO(tempMap, list, catgMapAll);
        }
    }

    public static List<FormBean> getFormBenaList(User user, boolean isAll) throws BusinessException {
        if (user == null) {
            user = AppContext.getCurrentUser();
        }
        ArrayList<FormBean> list = new ArrayList<FormBean>();
        List<FormBean> formList = cap4FormCacheManager.getFormList();
        for (FormBean formBean : formList) {
            if (!cap4FormCacheManager.isEnabled(formBean.getId())) continue;
            if (isAll) {
                V3xOrgMember member = orgManager.getMemberById(Long.valueOf(formBean.getOwnerId()));
                if (member == null || !member.getOrgAccountId().equals(user.getLoginAccount())) continue;
                list.add(formBean);
                continue;
            }
            if (formBean.getOwnerId() != user.getId().longValue()) continue;
            list.add(formBean);
        }
        return list;
    }

    public static List<FormBean> getFormBeanList(Long categoryId, List<FormBean> formList) {
        ArrayList<FormBean> list = new ArrayList<FormBean>();
        for (FormBean formBean : formList) {
            if (formBean.getCategoryId() != categoryId.longValue()) continue;
            list.add(formBean);
        }
        return list;
    }

    public static Long getFormIdByTemplate(CtpTemplate template) throws BusinessException {
        CtpContentAll contentAll;
        List list = MainbodyService.getInstance().getContentList(ModuleType.collaboration, template.getId().longValue());
        if (Strings.isNotEmpty((Collection)list) && null != (contentAll = (CtpContentAll)MainbodyService.getInstance().getContentList(ModuleType.collaboration, template.getId().longValue()).get(0))) {
            return contentAll.getContentTemplateId();
        }
        return 0L;
    }

    public static boolean parentCatgIsRoot(CtpTemplateCategory category) {
        return category.getParentId() != null && (long)ModuleType.form.getKey() != category.getParentId() && (long)ModuleType.collaboration.getKey() != category.getParentId();
    }

    public static void getParentCategorys(Long catgId, Set<CtpTemplateCategory> categories) throws BusinessException {
        CtpTemplateCategory category = templateManager.getCtpTemplateCategory(catgId);
        if (BusinessUtil.parentCatgIsRoot(category)) {
            if (categories.add(category)) {
                BusinessUtil.getParentCategorys(category.getParentId(), categories);
            }
        } else {
            categories.add(category);
        }
    }

    public static void dealBeanFromBizMap(Long mapId, boolean needRelation, boolean needCheckIndex, Set<FormBean> set, List<Long> bizMapIdTem) throws BusinessException {
        if (bizMapIdTem.contains(mapId)) {
            return;
        }
        bizMapIdTem.add(mapId);
    }

    public static List<CtpBizConfigItem> getConfigItem(List<PrivMenuBO> menus, CapBizConfig biz) throws BusinessException {
        ArrayList<CtpBizConfigItem> list = new ArrayList<CtpBizConfigItem>();
        for (PrivMenuBO privMenuBO : menus) {
            if (biz.getBizMerge() == 1 && privMenuBO.getExt14() == 2 && privMenuBO.getExt17() == 0L || privMenuBO.getParentId() == 0L) continue;
            CtpBizConfigItem configItem = new CtpBizConfigItem(privMenuBO, biz);
            StringBuilder title = new StringBuilder(ResourceUtil.getString((String)"form.auth.save.as.authType") + "\uff1a");
            switch (Enums.SourceType.getEnumByKey((int)configItem.getSourceType())) {
                case SOURCE_TYPE_FLOWTEMPLATE: {
                    FormBean formBean;
                    if (cap4FormCacheManager.isEnabled(configItem.getFormAppmainId())) {
                        if (configItem.getFlowMenuType() == 1) {
                            title.append(Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATENEW.getText());
                        } else if (configItem.getFlowMenuType() == 2) {
                            title.append(Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATELIST.getText());
                        }
                        formBean = cap4FormCacheManager.getForm(configItem.getFormAppmainId());
                        CtpTemplate ctpTemplate = templateManager.getCtpTemplate(privMenuBO.getExt17());
                        DBAgent.evict((Object)ctpTemplate);
                        title.append("&lt;br&gt;" + ResourceUtil.getString((String)"cap4.form.business.menu.initialname") + "\uff1a").append(ctpTemplate != null ? ctpTemplate.getSubject() : "").append("&lt;br&gt;" + ResourceUtil.getString((String)"cap4.form.business.menu.formName") + "\uff1a").append(formBean.getFormName());
                        configItem.setTitle(title.toString());
                        break;
                    }
                    configItem.setTitle(configItem.getName());
                    break;
                }
                case SOURCE_TYPE_INFOMANAGE: {
                    FormBindAuthBean ctpTemplate;
                    FormBindBean bindBean;
                    FormBean formBean;
                    if (cap4FormCacheManager.isEnabled(configItem.getFormAppmainId())) {
                        title.append(Enums.SourceType.SOURCE_TYPE_INFOMANAGE.getText());
                        formBean = cap4FormCacheManager.getForm(configItem.getFormAppmainId());
                        bindBean = formBean.getBind();
                        ctpTemplate = bindBean.getUnFlowTemplateById(privMenuBO.getExt17());
                        title.append("&lt;br&gt;" + ResourceUtil.getString((String)"cap4.form.business.menu.initialname") + "\uff1a").append(ctpTemplate != null ? ctpTemplate.getName() : "").append("&lt;br&gt;" + ResourceUtil.getString((String)"cap4.form.business.menu.formName") + "\uff1a").append(formBean.getFormName());
                        configItem.setTitle(title.toString());
                        break;
                    }
                    configItem.setTitle(configItem.getName());
                    break;
                }
                case SOURCE_TYPE_FLOWBUSINESS: {
                    FormBindAuthBean ctpTemplate;
                    FormBindBean bindBean;
                    FormBean formBean;
                    if (cap4FormCacheManager.isEnabled(configItem.getFormAppmainId())) {
                        title.append(Enums.SourceType.SOURCE_TYPE_FLOWBUSINESS.getText());
                        formBean = cap4FormCacheManager.getForm(configItem.getFormAppmainId());
                        bindBean = formBean.getBind();
                        ctpTemplate = bindBean.getUnFlowTemplateById(privMenuBO.getExt17());
                        title.append("&lt;br&gt;" + ResourceUtil.getString((String)"cap4.form.business.menu.initialname") + "\uff1a").append(configItem.getName()).append("&lt;br&gt;" + ResourceUtil.getString((String)"cap4.form.business.menu.formName") + "\uff1a").append(formBean.getFormName());
                        configItem.setTitle(title.toString());
                        break;
                    }
                    configItem.setTitle(configItem.getName());
                    break;
                }
                case SOURCE_TYPE_QUERY: {
                    title.append(Enums.SourceType.SOURCE_TYPE_QUERY.getText());
                    Map<String, Object> queryMap = BusinessUtil.getReportInfoById(biz.getId(), configItem.getSourceId());
                    String queryName = queryMap != null ? (String)queryMap.get("title") : configItem.getName();
                    title.append("&lt;br&gt;" + ResourceUtil.getString((String)"cap4.form.business.menu.initialname") + "\uff1a").append(queryName);
                    configItem.setTitle(title.toString());
                    break;
                }
                case SOURCE_TYPE_REPORT: {
                    Map<String, Object> reportMap = BusinessUtil.getReportInfoById(biz.getId(), configItem.getSourceId());
                    String reportName = reportMap != null ? (String)reportMap.get("title") : configItem.getName();
                    title.append(Enums.SourceType.SOURCE_TYPE_REPORT.getText());
                    title.append("&lt;br&gt;" + ResourceUtil.getString((String)"cap4.form.business.menu.initialname") + "\uff1a").append(reportName);
                    configItem.setTitle(title.toString());
                    break;
                }
                default: {
                    configItem.setTitle(configItem.getName());
                }
            }
            if (Enums.SourceType.getEnumByKey((int)configItem.getSourceType()).equals((Object)Enums.SourceType.SOURCE_TYPE_BIZHOMEPAGE)) continue;
            configItem.setPrivMenuBO(privMenuBO);
            list.add(configItem);
        }
        return list;
    }

    public static void getConfigItem(BizConfigBean biz, CapBizConfig oldBiz) throws BusinessException {
        String[] sourceTypeAry = (String[])oldBiz.getExtraAttr("BIZ_CONFIG_SOURCE_TYPE_ARRAY");
        String[] sourceIdAry = (String[])oldBiz.getExtraAttr("BIZ_CONFIG_SOURCE_ID_ARRAY");
        String[] bizConfigItemNameAry = (String[])oldBiz.getExtraAttr("BIZ_CONFIG_MENU_NAME_ARRAY");
        String[] formAppmainIdAry = (String[])oldBiz.getExtraAttr("BIZ_CONFIG_FORM_ID_ARRAY");
        String[] flowMenuTypeNameAry = (String[])oldBiz.getExtraAttr("BIZ_CONFIG_MENU_TYPE_ARRAY");
        String[] menuIdAry = (String[])oldBiz.getExtraAttr("BIZ_CONFIG_MENU_ID_ARRAY");
        String[] menuIconAry = (String[])oldBiz.getExtraAttr("BIZ_CONFIG_MENU_ICON_ARRAY");
        ArrayList<CtpBizConfigItem> list = new ArrayList<CtpBizConfigItem>();
        ArrayList<PrivMenuBO> bos = new ArrayList<PrivMenuBO>();
        long parentId = biz.getMenuId();
        int bizPage = 0;
        if (oldBiz.getExtraAttr("BIZ_PAGE_VALUE") != null) {
            bizPage = (Integer)oldBiz.getExtraAttr("BIZ_PAGE_VALUE");
        }
        if (null != bizConfigItemNameAry && 0 != bizConfigItemNameAry.length) {
            PrivMenuBO menuBO;
            CtpBizConfigItem bizConfigItem;
            int sort = 990;
            boolean isMerge = true;
            if (bizPage == 1) {
                bizConfigItem = new CtpBizConfigItem();
                bizConfigItem.setNewId();
                bizConfigItem.setBizConfigId(biz.getId());
                bizConfigItem.setName(ResourceUtil.getString((String)"form.business.menu.bizHomePage.label"));
                bizConfigItem.setFlowMenuType(Integer.valueOf(0));
                bizConfigItem.setSourceType(Integer.valueOf(Enums.SourceType.SOURCE_TYPE_BIZHOMEPAGE.getKey()));
                bizConfigItem.setSourceId(Long.valueOf(1L));
                bizConfigItem.setFormAppmainId(Long.valueOf(-1L));
                bizConfigItem.setMenuId(Long.valueOf(UUIDLong.longUUID()));
                bizConfigItem.setSortId(Integer.valueOf(sort - 1));
                bizConfigItem.setMenuIcon("vp-Businessportal");
                list.add(bizConfigItem);
                menuBO = bizConfigItem.getPrivMenuBO();
                menuBO.setId(bizConfigItem.getMenuId());
                menuBO.setName("form.business.menu.bizHomePage.label");
                menuBO.setParentId(Long.valueOf(parentId));
                menuBO.setUrl("/cap4/businessTemplateController.do?method=businessIndex&bussId=" + biz.getId());
                menuBO.setSortid(Integer.valueOf(sort - 1));
                menuBO.setExt2("2");
                menuBO.setType(Integer.valueOf(PrivMenuTypeEnums.businessCap4Menu.getKey()));
                menuBO.setTarget("newWindow");
                bos.add(menuBO);
                menuBO.setIcon(bizConfigItem.getMenuIcon());
                if (bizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_CATG.getKey()) {
                    parentId = menuBO.getId();
                    menuBO.setParentId(biz.getMenuId());
                }
            }
            int j = bizConfigItemNameAry.length;
            for (int i = 0; i < j; ++i) {
                bizConfigItem = new CtpBizConfigItem();
                bizConfigItem.setNewId();
                bizConfigItem.setBizConfigId(biz.getId());
                bizConfigItem.setName(bizConfigItemNameAry[i]);
                bizConfigItem.setFlowMenuType(Integer.valueOf(Integer.parseInt(flowMenuTypeNameAry[i])));
                bizConfigItem.setSourceType(Integer.valueOf(Integer.parseInt(sourceTypeAry[i])));
                bizConfigItem.setSourceId(Long.valueOf(Long.parseLong(sourceIdAry[i])));
                bizConfigItem.setFormAppmainId(Long.valueOf(Long.parseLong(formAppmainIdAry[i])));
                bizConfigItem.setMenuId(Long.valueOf(Long.parseLong(menuIdAry[i])));
                bizConfigItem.setSortId(Integer.valueOf(sort));
                bizConfigItem.setMenuIcon(menuIconAry[i]);
                list.add(bizConfigItem);
                BusinessSourceTypeManager manager = BizUtil.getSourceTypeFromConfigItem(bizConfigItem);
                if (biz.getBizMerge() == 1 && isMerge && bizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATE.getKey() && bizConfigItem.getFlowMenuType() == 2) {
                    PrivMenuBO privMenuBO = new PrivMenuBO();
                    privMenuBO.setId(Long.valueOf(UUIDLong.longUUID()));
                    privMenuBO.setName(biz.getBizMergeName());
                    privMenuBO.setExt12(bizConfigItem.getSourceType());
                    privMenuBO.setExt14(bizConfigItem.getFlowMenuType());
                    privMenuBO.setExt17(Long.valueOf(0L));
                    privMenuBO.setExt18(Long.valueOf(0L));
                    privMenuBO.setExt13(bizConfigItem.getSortId());
                    privMenuBO.setParentId(Long.valueOf(parentId));
                    privMenuBO.setUrl(BizUtil.getAction(biz.getMenuId(), bizConfigItem.getFlowMenuType(), bizConfigItem.getSourceType(), 0L, 0L, biz.getName(), biz.getBizMergeName(), biz.getId()));
                    privMenuBO.setSortid(Integer.valueOf(sort));
                    privMenuBO.setExt2("2");
                    privMenuBO.setType(Integer.valueOf(PrivMenuTypeEnums.businessCap4Menu.getKey()));
                    privMenuBO.setIcon(manager.getIcon());
                    bos.add(privMenuBO);
                    ++sort;
                    isMerge = false;
                }
                menuBO = bizConfigItem.getPrivMenuBO();
                menuBO.setId(bizConfigItem.getMenuId());
                menuBO.setName(bizConfigItem.getName());
                menuBO.setParentId(Long.valueOf(parentId));
                menuBO.setUrl(manager.getMenuURL(bizConfigItem, (CapBizConfig)biz));
                menuBO.setSortid(Integer.valueOf(sort));
                menuBO.setExt2("2");
                menuBO.setType(Integer.valueOf(PrivMenuTypeEnums.businessCap4Menu.getKey()));
                bos.add(menuBO);
                menuBO.setIcon(bizConfigItem.getMenuIcon());
                if (bizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_CATG.getKey()) {
                    parentId = menuBO.getId();
                    menuBO.setParentId(biz.getMenuId());
                }
                ++sort;
            }
        }
        biz.setMenuList(bos);
        biz.setItems(list);
    }

    public static String formEditInfo(List<Map<String, Object>> checkFormEdit) {
        String formNames = "";
        for (Map<String, Object> map : checkFormEdit) {
            formNames = Strings.joinDelNull((String)",", (String[])new String[]{formNames, (String)map.get("name")});
        }
        if (Strings.isNotEmpty((String)formNames)) {
            formNames = formNames + " " + ResourceUtil.getString((String)"cap4.form.business.common.formEdit");
        }
        return formNames;
    }

    public static String getFormIdsByBizItems(List<CapBizConfigItem> capBizConfigItems) {
        String formIds = "";
        if (Strings.isNotEmpty(capBizConfigItems)) {
            for (CapBizConfigItem capBizConfigItem : capBizConfigItems) {
                formIds = Strings.joinDelNull((String)",", (String[])new String[]{formIds, capBizConfigItem.getFormId().toString()});
            }
        }
        return formIds;
    }

    public static String getFormIdsByBizItemsAndType(List<CapBizConfigItem> capBizConfigItems, int bizClearType) {
        String formIds = "";
        if (Strings.isNotEmpty(capBizConfigItems)) {
            if (bizClearType == BizEnums.BizClearType.clearAll.getKey()) {
                return BusinessUtil.getFormIdsByBizItems(capBizConfigItems);
            }
            for (CapBizConfigItem capBizConfigItem : capBizConfigItems) {
                Long formId = capBizConfigItem.getFormId();
                FormBean formBean = cap4FormCacheManager.getForm(formId);
                if (formBean == null || formBean.getFormType() != bizClearType) continue;
                formIds = Strings.joinDelNull((String)",", (String[])new String[]{formIds, capBizConfigItem.getFormId().toString()});
            }
        }
        return formIds;
    }

    public static List<BusinessAuthorityManager> getSortedManagerList() {
        ArrayList<BusinessAuthorityManager> businessAuthorityManagerList = new ArrayList<BusinessAuthorityManager>();
        Map managerMap = AppContext.getBeansOfType(BusinessAuthorityManager.class);
        if (!managerMap.isEmpty()) {
            for (Map.Entry entry : managerMap.entrySet()) {
                BusinessAuthorityManager manager = (BusinessAuthorityManager)entry.getValue();
                if (!manager.isEnableUsed()) continue;
                businessAuthorityManagerList.add(manager);
            }
        }
        Collections.sort(businessAuthorityManagerList, FormCollectionAscSortComparator.getInstance());
        return businessAuthorityManagerList;
    }

    public static BusinessAuthorityManager getBusinessAuthorityManager(int type) {
        ArrayList businessAuthorityManagerList = new ArrayList();
        Map managerMap = AppContext.getBeansOfType(BusinessAuthorityManager.class);
        if (!managerMap.isEmpty()) {
            for (Map.Entry entry : managerMap.entrySet()) {
                BusinessAuthorityManager manager = (BusinessAuthorityManager)entry.getValue();
                if (!manager.isEnableUsed() || manager.getId() != type) continue;
                return manager;
            }
        }
        return null;
    }

    public static List<Map<String, Object>> getReportAuth(FormAppBO fabo) {
        ArrayList<Map<String, Object>> authList = new ArrayList<Map<String, Object>>();
        if (Strings.isNotEmpty((String)fabo.getAuthId())) {
            String[] authObj = fabo.getAuthId().split(",");
            int sort = 1;
            for (String au : authObj) {
                HashMap<String, Number> reportAuth = new HashMap<String, Number>();
                reportAuth.put("reportId", fabo.getSourceValue());
                String[] org = au.split("\\|");
                reportAuth.put("orgentType", OrgConstants.ORGENT_TYPE.valueOf((String)org[0]).ordinal());
                reportAuth.put("orgentId", Long.parseLong(org[1]));
                reportAuth.put("sortNum", sort++);
                authList.add(reportAuth);
            }
            return authList;
        }
        return Collections.EMPTY_LIST;
    }

    public static void authSort(List<FormAppBO> formBoList) {
        if (CollectionUtils.isNotEmpty(formBoList)) {
            for (FormAppBO formAppBO : formBoList) {
                if (!Strings.isNotEmpty((String)formAppBO.getAuthName()) || !Strings.isNotEmpty((String)formAppBO.getAuthId())) continue;
                Object[] authIdArray = formAppBO.getAuthId().split(",");
                Arrays.sort(authIdArray);
                String authIds = StringUtils.arrayToString((String[])authIdArray, (String)",");
                formAppBO.setAuthName(Functions.showOrgEntities((String)authIds, (PageContext)null));
                formAppBO.setAuthId(authIds);
            }
        }
    }

    public static Map<String, Object> getReportInfoById(Long bizConfigId, Long desiginId) throws BusinessException {
        ReportApi reportApi = (ReportApi)AppContext.getBean((String)"reportApi");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("category", ApplicationCategoryEnum.cap4biz.name());
        params.put("categoryId", bizConfigId == null ? "" : bizConfigId.toString());
        if (desiginId != null) {
            params.put("designId", desiginId);
        }
        try {
            List reportList = reportApi.findDesign(params);
            if (Strings.isNotEmpty((Collection)reportList)) {
                return (Map)reportList.get(0);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static boolean isBizPage(BizConfigBean bizConfigBean) {
        List privMenuBOList;
        if (bizConfigBean != null && Strings.isNotEmpty((Collection)(privMenuBOList = bizConfigBean.getMenuList()))) {
            for (PrivMenuBO privMenuBO : privMenuBOList) {
                if (!privMenuBO.getExt12().equals(Enums.SourceType.SOURCE_TYPE_BIZHOMEPAGE.getKey()) || !privMenuBO.getParentId().equals(bizConfigBean.getMenuId())) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateBizPortalInfo(CapBizConfig biz, BizConfigBean oldBiz) throws BusinessException {
        if (biz.getExtraAttr("bizIconType") != null) {
            return;
        }
        String newAuth = (String)biz.getExtraAttr("BIZ_AUTHORITY_VALUE");
        int newBizPage = 0;
        if (biz.getExtraAttr("BIZ_PAGE_VALUE") != null) {
            newBizPage = (Integer)biz.getExtraAttr("BIZ_PAGE_VALUE");
        }
        Set<Long> oldShareIds = BusinessUtil.getAuthIds(oldBiz.getAuthValue());
        Set<Long> newShareIds = BusinessUtil.getAuthIds(newAuth);
        PortalApi portalApi = (PortalApi)AppContext.getBean((String)"portalApi");
        PortalNavBo portalNavBo = new PortalNavBo();
        portalNavBo.setId(biz.getId() + "");
        portalNavBo.setNavName(biz.getName());
        if (!BusinessUtil.isBizPage(oldBiz)) {
            if (newBizPage == 1 && Strings.isNotEmpty(oldShareIds)) {
                portalApi.appendThirdPartyToMasterPortalNav("5", portalNavBo, new ArrayList<Long>(oldShareIds));
            }
        } else if (newBizPage != 1) {
            List sharersAdded = Strings.getAddedCollection(oldShareIds, newShareIds);
            List sharersReduced = Strings.getReducedCollection(oldShareIds, newShareIds);
            if (Strings.isNotEmpty((Collection)sharersAdded)) {
                portalApi.appendThirdPartyToMasterPortalNav("5", portalNavBo, sharersAdded);
            }
            if (Strings.isNotEmpty((Collection)sharersReduced)) {
                portalApi.removeMasterPortalThirdPartyNav(biz.getId() + "", sharersReduced);
            }
        }
    }

    public static void removeBizPortalInfo(BizConfigBean bizConfig) throws BusinessException {
        Set<Long> memberList;
        if (BusinessUtil.isBizPage(bizConfig) && Strings.isNotEmpty(memberList = BusinessUtil.getAuthIds(bizConfig.getAuthValue()))) {
            PortalApi portalApi = (PortalApi)AppContext.getBean((String)"portalApi");
            try {
                portalApi.removeMasterPortalThirdPartyNav(bizConfig.getId() + "", new ArrayList<Long>(memberList));
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void deleteI18n(List<PrivMenuBO> privMenuBOList) throws BusinessException {
        if (Strings.isNotEmpty(privMenuBOList)) {
            ArrayList<Long> menuI18nIds = new ArrayList<Long>();
            for (PrivMenuBO privMenuBO : privMenuBOList) {
                if (!Strings.isLong((String)privMenuBO.getResourceNameKey())) continue;
                menuI18nIds.add(Long.parseLong(privMenuBO.getResourceNameKey()));
            }
            if (Strings.isNotEmpty(menuI18nIds)) {
                DataI18nManager dataI18nManager = (DataI18nManager)AppContext.getBean((String)"dataI18nManager");
                dataI18nManager.delete(menuI18nIds);
            }
        }
    }

    private static boolean checkSourceType(CtpBizConfigItem ctpBizConfigItem, Set<Long> formIds, Long bizId) throws BusinessException {
        boolean selfBizFlag = false;
        Enums.SourceType sourceType = Enums.SourceType.getEnumByKey((int)ctpBizConfigItem.getSourceType());
        switch (sourceType) {
            case SOURCE_TYPE_FLOWTEMPLATE: 
            case SOURCE_TYPE_INFOMANAGE: 
            case SOURCE_TYPE_FLOWBUSINESS: {
                if (!formIds.contains(ctpBizConfigItem.getFormAppmainId())) break;
                selfBizFlag = true;
                break;
            }
            case SOURCE_TYPE_QUERY: 
            case SOURCE_TYPE_REPORT: {
                Map<String, Object> queryMap = BusinessUtil.getReportInfoById(bizId, ctpBizConfigItem.getSourceId());
                if (queryMap == null) break;
                selfBizFlag = true;
                break;
            }
            case SOURCE_TYPE_DOCUMENT: 
            case SOURCE_TYPE_ADMIN_NEWS: 
            case SOURCE_TYPE_ADMIN_BUL: 
            case SOURCE_TYPE_ADMIN_BBS: 
            case SOURCE_TYPE_ADMIN_INQUIRY: 
            case SOURCE_TYPE_GROUP_NEWS: 
            case SOURCE_TYPE_GROUP_BUL: 
            case SOURCE_TYPE_GROUP_BBS: 
            case SOURCE_TYPE_GROUP_INQUIRY: {
                break;
            }
            case SOURCE_TYPE_BIZMAP: {
                CtpBizMap ctpBizMap = bizMapManager.getBizMap(ctpBizConfigItem.getSourceId());
                if (ctpBizMap == null || !bizId.equals(ctpBizMap.getBizId())) break;
                selfBizFlag = true;
                break;
            }
            default: {
                selfBizFlag = true;
            }
        }
        return selfBizFlag;
    }

    public static List<Map<String, Object>> validateBizMenu(List<FormBean> formBeanList, BizConfigBean bizConfigBean) throws BusinessException {
        if (Strings.isNotEmpty(formBeanList)) {
            HashSet<Long> formIds = new HashSet<Long>();
            for (FormBean formBean : formBeanList) {
                formIds.add(formBean.getId());
            }
            ArrayList<Map<String, Object>> menuMapList = new ArrayList<Map<String, Object>>();
            List ctpBizConfigItemList = bizConfigBean.getItems();
            if (Strings.isNotEmpty((Collection)ctpBizConfigItemList)) {
                for (CtpBizConfigItem ctpBizConfigItem : ctpBizConfigItemList) {
                    if (!BusinessUtil.checkSourceType(ctpBizConfigItem, formIds, bizConfigBean.getId())) continue;
                    HashMap<String, Object> menuMap = new HashMap<String, Object>();
                    menuMap.put("id", ctpBizConfigItem.getId());
                    menuMap.put("name", ctpBizConfigItem.getName());
                    menuMap.put("flowMenuType", ctpBizConfigItem.getFlowMenuType());
                    menuMap.put("sourceId", ctpBizConfigItem.getSourceId());
                    menuMap.put("sourceType", ctpBizConfigItem.getSourceType());
                    menuMap.put("formAppmainId", ctpBizConfigItem.getFormAppmainId());
                    menuMap.put("sortId", ctpBizConfigItem.getSortId());
                    menuMap.put("menuIcon", ctpBizConfigItem.getMenuIcon());
                    menuMap.put("title", ctpBizConfigItem.getTitle());
                    menuMapList.add(menuMap);
                }
            }
            return menuMapList;
        }
        return Collections.EMPTY_LIST;
    }

    public static String getUnzipFilePathSessionKey(Long userId, String path) {
        return "appUnZipFile" + userId;
    }

    public static boolean isBindMplusAccount() {
        if (SystemEnvironment.isDev() || AppContext.isRunningModeDevelop()) {
            return true;
        }
        MplusApi mplusApi = (MplusApi)AppContext.getBean((String)"mplusApi");
        if (mplusApi != null) {
            try {
                Map map = mplusApi.getCorpInfo();
                if (map != null) {
                    return true;
                }
            }
            catch (BusinessException e) {
                LOGGER.error((Object)"\u4e91\u8054\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static List<BizConfigBean> getCloudBizList() {
        CloudResourceManager cloudResourceManager;
        if (BusinessUtil.isBindMplusAccount() && (cloudResourceManager = (CloudResourceManager)AppContext.getBean((String)"cloudResourceManager")) != null) {
            try {
                return cloudResourceManager.getCloudApp();
            }
            catch (BusinessException e) {
                LOGGER.error((Object)"\u4e91\u8054\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    static {
        LOGGER = CtpLogFactory.getLog(BusinessUtil.class);
        orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        userMessageManager = (UserMessageManager)AppContext.getBean((String)"userMessageManager");
        templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
        cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        bizMapManager = (BizMapManager)AppContext.getBean((String)"bizMapManager");
    }
}

