/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.util;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public class DynamicFieldUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(DynamicFieldUtil.class);

    public static String getTheadStr(List<SimpleObjectBean> showFields, FormBean formBean) throws BusinessException {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        String isDisplayImage = "";
        FormFieldBean field = null;
        for (SimpleObjectBean showField : showFields) {
            FormFieldBean realField;
            String fieldName;
            if ("".equals(showField.getName())) continue;
            String[] strs = showField.getName().split("[.]");
            if (strs.length == 1) {
                fieldName = strs[0];
                fieldName = fieldName.replaceAll("_", "");
            } else {
                fieldName = strs[1];
            }
            String display = showField.getValue().contains("(") ? showField.getValue().substring(showField.getValue().indexOf("(") + 1, showField.getValue().indexOf(")")) : showField.getValue();
            field = formBean.getFieldBeanByName(fieldName);
            isDisplayImage = field != null && field.isDisplayImage() ? "true" : "false";
            sb.append("{");
            sb.append("\"").append("display\":\"").append(display).append("\",");
            sb.append("\"").append("name\":\"").append(fieldName).append("\",");
            sb.append("\"").append("isDisplayImage\":\"").append(isDisplayImage).append("\",");
            sb.append("\"").append("sortable\":\"").append("false").append("\",");
            sb.append("\"").append("align\":\"").append("center").append("\",");
            String sortType = "string";
            if (field != null && (realField = field) != null && StringUtil.checkNull((String)realField.getFormatType()) && FormFieldComEnum.TEXT.equals((Object)realField.getInputTypeEnum()) && realField.getFieldType().equals(Enums.FieldType.DECIMAL.getKey())) {
                sortType = "number";
            }
            sb.append("\"").append("sortType\":\"").append(sortType).append("\"");
            if (i == showFields.size() - 1) {
                sb.append("}");
            } else {
                sb.append("},");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static List<FormFieldBean> getSearchField(List<SimpleObjectBean> showFields, FormBean formBean) {
        ArrayList<FormFieldBean> list = new ArrayList<FormFieldBean>();
        FormFieldBean field = null;
        for (SimpleObjectBean showField : showFields) {
            int index2;
            String display = showField.getValue();
            int index1 = display.indexOf("(");
            if (index1 != -1) {
                display = display.substring(index1 + 1);
            }
            if ((index2 = display.indexOf(")")) != -1) {
                display = display.substring(0, index2);
            }
            if (showField.getName().indexOf(".") > -1) {
                String[] strs = showField.getName().split("[.]");
                field = formBean.getFieldBeanByName(strs[1]);
                if (field == null || field.getInputTypeEnum() == null) {
                    Enums.MasterTableField mtf = Enums.MasterTableField.getEnumByKey((String)strs[1]);
                    if (mtf == null) continue;
                    field = mtf.getFormFieldBean();
                }
                if (field.isMultiOrg() && field.getFieldType().equals(Enums.FieldType.LONGTEXT.getKey()) || field.getInputTypeEnum() == FormFieldComEnum.MAP_MARKED || field.getInputTypeEnum() == FormFieldComEnum.MAP_LOCATE || field.getInputTypeEnum() == FormFieldComEnum.MAP_PHOTO) {
                    continue;
                }
            } else {
                Enums.MasterTableField mtf = Enums.MasterTableField.getEnumByKey((String)showField.getName());
                if (mtf == null) continue;
                field = mtf.getFormFieldBean();
            }
            try {
                field = (FormFieldBean)field.clone();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error((Object)"\u514b\u9686\u5931\u8d25", (Throwable)e);
            }
            field.setDisplay(display);
            list.add(field);
        }
        return list;
    }

    public static String getSortStr(List<SimpleObjectBean> orderByFields) {
        String sortStr = "";
        if (orderByFields != null && orderByFields.size() > 0) {
            for (SimpleObjectBean orderField : orderByFields) {
                String[] strs = orderField.getName().split("[.]");
                if (strs.length < 2) {
                    strs = new String[]{strs[0], orderField.getName()};
                }
                if ("".equals(sortStr.trim())) {
                    sortStr = strs[1] + " " + orderField.getValue();
                    continue;
                }
                sortStr = sortStr + "," + strs[1] + " " + orderField.getValue();
            }
        }
        return sortStr;
    }
}

