/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.util;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import org.apache.commons.logging.Log;

public class FormLogUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(FormLogUtil.class);
    private static final String LOCK = ResourceUtil.getString((String)"form.log.running.util.lock");
    private static final String UNLOCK = ResourceUtil.getString((String)"form.log.running.util.unlock");
    private static final String DATA = ResourceUtil.getString((String)"form.log.running.util.data");
    private static final String QUOTES = "\"";
    private static final String AS = "\uff1a";
    private static final String COLON = "; ";
    private static final String COMMA = ", ";
    private static final String CONTENT = ResourceUtil.getString((String)"form.log.running.util.content");
    private static final String TAKE = ResourceUtil.getString((String)"form.log.running.util.take");
    private static final String FROM = ResourceUtil.getString((String)"form.log.running.util.from");
    private static final String BY = ResourceUtil.getString((String)"form.log.running.util.by");
    private static final String CHANGETO = ResourceUtil.getString((String)"form.log.running.util.changeTo");
    private static final String CHOOSED = ResourceUtil.getString((String)"form.log.running.util.choos");
    private static final String UNCHOOSED = ResourceUtil.getString((String)"form.log.running.util.unchoose");
    private static final String SALVEROW = ResourceUtil.getString((String)"form.log.running.util.salveRow");
    private static final String POSITION = ResourceUtil.getString((String)"form.log.running.util.position");
    private static final String ROW = ResourceUtil.getString((String)"form.log.running.util.row");

    public static String getLogForLockorUnlock(FormBean fb, FormFieldBean ffb, Object value, int state) {
        if (state == Enums.FormDataStateEnum.UNFLOW_LOCKED.getKey()) {
            return FormLogUtil.getLogForLock(fb, ffb, value);
        }
        return FormLogUtil.getLogForUnLock(fb, ffb, value);
    }

    private static String getLogForLock(FormBean fb, FormFieldBean ffb, Object value) {
        String log = LOCK + QUOTES + ffb.getDisplay() + QUOTES + AS + QUOTES + (value == null ? "" : value.toString()) + QUOTES + DATA + COLON;
        if (ffb.isAttachment() || ffb.getInputTypeEnum() == FormFieldComEnum.TEXTAREA) {
            log = LOCK + QUOTES + ffb.getDisplay() + QUOTES + CONTENT + COLON;
        }
        return log;
    }

    private static String getLogForUnLock(FormBean fb, FormFieldBean ffb, Object value) {
        String log = UNLOCK + QUOTES + ffb.getDisplay() + QUOTES + AS + QUOTES + (value == null ? "" : value.toString()) + QUOTES + DATA + COLON;
        if (ffb.isAttachment() || ffb.getInputTypeEnum() == FormFieldComEnum.TEXTAREA) {
            log = UNLOCK + QUOTES + ffb.getDisplay() + QUOTES + CONTENT + COLON;
        }
        return log;
    }

    public static String getSlaveLogPrefix(String subTable, int lineNum, Enums.CapLogType type) {
        String prefix = "";
        switch (type) {
            case INSERT: {
                prefix = Enums.CapLogType.INSERT.getText() + SALVEROW + "\u300a" + subTable + "\u300b" + POSITION + lineNum + ROW + COMMA;
                break;
            }
            case MODIFY: {
                prefix = Enums.CapLogType.MODIFY.getText() + SALVEROW + "\u300a" + subTable + "\u300b" + POSITION + lineNum + ROW + COMMA;
                break;
            }
            case DELETE: {
                prefix = Enums.CapLogType.DELETE.getText() + SALVEROW + "\u300a" + subTable + "\u300b" + POSITION + lineNum + ROW + COMMA;
                break;
            }
        }
        return prefix;
    }

    public static String getFieldLogDesc(FormFieldBean ffb, Object beforeValue, Object afterValue, Enums.CapLogType type) {
        if (ffb.isAttachment() || ffb.getInputTypeEnum() == FormFieldComEnum.TEXTAREA || ffb.isCustomerCtrl()) {
            return FormLogUtil.getSpecialFieldLog(ffb, type);
        }
        return FormLogUtil.getFieldDetailLog(ffb, beforeValue, afterValue, type);
    }

    private static String getSpecialFieldLog(FormFieldBean ffb, Enums.CapLogType type) {
        return type.getText() + QUOTES + ffb.getDisplay() + QUOTES + CONTENT + COLON;
    }

    private static String getFieldDetailLog(FormFieldBean ffb, Object beforeValue, Object afterValue, Enums.CapLogType type) {
        String detailLog = "";
        switch (type) {
            case INSERT: {
                if (ffb.getInputTypeEnum() == FormFieldComEnum.CHECKBOX) {
                    detailLog = QUOTES + ffb.getDisplay() + QUOTES + BY + ("1".equals(String.valueOf(afterValue)) ? CHOOSED : UNCHOOSED) + QUOTES + COLON;
                    break;
                }
                detailLog = QUOTES + ffb.getDisplay() + QUOTES + BY + QUOTES + (afterValue == null ? "" : FormLogUtil.getDisplayValue(ffb, afterValue)) + QUOTES + COLON;
                break;
            }
            case MODIFY: {
                if (String.valueOf(beforeValue).equals(String.valueOf(afterValue))) break;
                if (ffb.getInputTypeEnum() == FormFieldComEnum.CHECKBOX) {
                    detailLog = TAKE + QUOTES + ffb.getDisplay() + QUOTES + FROM + QUOTES + ("1".equals(String.valueOf(beforeValue)) ? CHOOSED : UNCHOOSED) + QUOTES + CHANGETO + QUOTES + ("1".equals(String.valueOf(afterValue)) ? CHOOSED : UNCHOOSED) + QUOTES + COLON;
                    break;
                }
                detailLog = TAKE + QUOTES + ffb.getDisplay() + QUOTES + FROM + QUOTES + (beforeValue == null ? "" : FormLogUtil.getDisplayValue(ffb, beforeValue)) + QUOTES + CHANGETO + QUOTES + (afterValue == null ? "" : FormLogUtil.getDisplayValue(ffb, afterValue)) + QUOTES + COLON;
                break;
            }
            case DELETE: {
                if (ffb.getInputTypeEnum() == FormFieldComEnum.CHECKBOX) {
                    detailLog = QUOTES + ffb.getDisplay() + QUOTES + BY + ("1".equals(String.valueOf(beforeValue)) ? CHOOSED : UNCHOOSED) + QUOTES + COLON;
                    break;
                }
                detailLog = QUOTES + ffb.getDisplay() + QUOTES + BY + QUOTES + (beforeValue == null ? "" : FormLogUtil.getDisplayValue(ffb, beforeValue)) + QUOTES + COLON;
                break;
            }
        }
        return detailLog;
    }

    private static Object getDisplayValue(FormFieldBean ffb, Object value) {
        try {
            return ffb.getDisplayValue(value, false)[1];
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static String getLogForBatchOperation(String masterTableName, String operationName, int successNum, int errorNum) {
        return ResourceUtil.getString((String)"cap.form.batchOperation.batchOperationTemplateMaster", (Object)AppContext.currentUserName(), (Object)masterTableName, (Object)operationName, (Object)successNum, (Object)errorNum);
    }
}

