/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.util;

import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormQueryWhereClause;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.formula.CustomSelectEnums;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.dao.OrgHelper;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.SQLWildcardUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class FormSearchUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(FormSearchUtil.class);
    private static final String DATE_CUSTOM = "date_custom";

    public static String showOrgEntities(String orgIds, String orgType) {
        String ret = "";
        if (Strings.isNotEmpty((String)orgIds)) {
            String[] idArr;
            StringBuilder sb = new StringBuilder();
            for (String idstr : idArr = orgIds.split("[,]")) {
                sb.append(",").append(orgType).append("|").append(idstr);
            }
            ret = sb.deleteCharAt(0).toString();
        }
        return ret;
    }

    public static FormQueryWhereClause getCustomConditionFormQueryWhereClause(com.seeyon.cap4.form.bean.FormBean formBean, Map<String, Object> params) {
        FormQueryWhereClause whereClause = new FormQueryWhereClause();
        StringBuilder sb = new StringBuilder("");
        ArrayList queryParams = new ArrayList();
        try {
            for (String key : params.keySet()) {
                FormFieldComEnum fieldComEnum;
                FormFieldBean fieldBean;
                FormQueryWhereClause myWhereClause;
                if (params.get(key) == null || "sortStr".equals(key) || "formId".equals(key) || "formTemplateId".equals(key) || "fromFormId".equals(key) || "fromDataId".equals(key) || "fromRecordId".equals(key) || "fromRelationAttr".equals(key) || "userOrderBy".equals(key) || null == (myWhereClause = FormSearchUtil.getQuerySql4ConditionWhereClause(fieldBean = formBean.getFieldBeanByName(key, true), fieldComEnum = FormFieldComEnum.getEnumByKey((String)fieldBean.getInputType()), key, params.get(key)))) continue;
                if (Strings.isNotBlank((String)myWhereClause.getAllSqlClause())) {
                    sb.append("and ").append(myWhereClause.getAllSqlClause());
                }
                if (null == myWhereClause.getQueryParams() || myWhereClause.getQueryParams().isEmpty()) continue;
                queryParams.addAll(myWhereClause.getQueryParams());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"getCustomConditionFormQueryWhereClause error", (Throwable)e);
        }
        whereClause.setQueryParams(queryParams);
        whereClause.setAllSqlClause(sb.delete(0, 3).toString());
        return whereClause;
    }

    public static String getNullSql(String operation, String fieldName) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(operation).append(" ( ").append(fieldName).append(" is null or ").append(fieldName).append(" = '' ) ");
        return sb.toString();
    }

    public static String getNullSql(String fieldName) {
        return FormSearchUtil.getNullSql("", fieldName);
    }

    private static FormQueryWhereClause getQuerySql4ConditionWhereClause(FormFieldBean fieldBean, FormFieldComEnum fieldComEnum, String fieldName, Object values) throws Exception {
        StringBuilder conditionSb = new StringBuilder("");
        ArrayList<String> queryParams = new ArrayList<String>();
        switch (fieldComEnum) {
            case SELECT: 
            case RADIO: {
                String[] selectArr = values.toString().split("[,]", -1);
                StringBuilder selectSb = new StringBuilder("");
                String isNullString = "";
                for (String select : selectArr) {
                    if (Strings.isBlank((String)select) && selectArr.length == 1) {
                        isNullString = FormSearchUtil.getNullSql(fieldName);
                        continue;
                    }
                    if (Strings.isBlank((String)select)) {
                        isNullString = FormSearchUtil.getNullSql("or", fieldName);
                        continue;
                    }
                    selectSb.append(",? ");
                    queryParams.add(select);
                }
                if (Strings.isNotEmpty((String)selectSb.toString())) {
                    selectSb.deleteCharAt(0);
                    conditionSb.append(" (").append(MessageFormat.format(" {0} in ({1}) ", fieldName, selectSb.toString())).append(isNullString).append(") ");
                    break;
                }
                conditionSb.append(" (").append(isNullString).append(") ");
                break;
            }
            case CHECKBOX: {
                String[] checkBoxs = values.toString().split("[,]");
                if (checkBoxs.length == 1) {
                    conditionSb.append(" (").append(fieldName).append(" = ").append(checkBoxs[0]).append(") ");
                }
                if (checkBoxs.length != 2) break;
                conditionSb.append(" (").append(fieldName).append(" = ").append(checkBoxs[0]).append(" or ").append(fieldName).append(" = ").append(checkBoxs[1]).append(") ");
                break;
            }
            case EXTEND_DATE: 
            case EXTEND_DATETIME: {
                Object[] timeOjb = FormSearchUtil.getTimeSql(values.toString(), fieldName);
                String isNullSql = "";
                for (Object object : timeOjb) {
                    if (!Strings.isBlank((String)String.valueOf(object))) continue;
                    isNullSql = FormSearchUtil.getNullSql(fieldName);
                }
                conditionSb.append(" (").append(timeOjb[0]).append(isNullSql).append(") ");
                queryParams.addAll((List)timeOjb[1]);
                break;
            }
            case TEXT: 
            case TEXTAREA: {
                if (Enums.FieldType.DECIMAL.getKey().equals(fieldBean.getFieldType())) {
                    if (",".equals(values)) {
                        conditionSb.append(FormSearchUtil.getNullSql(fieldName));
                        break;
                    }
                    Object[] numberOrg = FormSearchUtil.getDecimalSql(fieldName, values.toString());
                    conditionSb.append(" (").append(numberOrg[0]).append(") ");
                    queryParams.addAll((List)numberOrg[1]);
                    break;
                }
                String[] textArr = values.toString().split("[ ]");
                Object[] textObj = FormSearchUtil.appendLikeSql(fieldName, Arrays.asList(textArr), " and ");
                conditionSb.append(" (").append(textObj[0]).append(") ");
                queryParams.addAll((List)textObj[1]);
                break;
            }
            case EXTEND_ACCOUNT: {
                String[] orgAccArr = values.toString().replaceAll("Account[|]", "").split("[,]");
                Object[] orgAccObj = FormSearchUtil.getSingleOrgSQL(fieldName, orgAccArr);
                conditionSb.append(" (").append(orgAccObj[0]).append(") ");
                queryParams.addAll((List)orgAccObj[1]);
                break;
            }
            case EXTEND_DEPARTMENT: {
                String[] orgDepArr = values.toString().replaceAll("Department[|]", "").split("[,]");
                ArrayList<String> orgDepList = new ArrayList<String>();
                for (String orgDep : orgDepArr) {
                    if (orgDep.endsWith("|1")) {
                        orgDepList.add(orgDep.split("[|]")[0]);
                        continue;
                    }
                    orgDepList.add(orgDep);
                    List depList = OrgHelper.getOrgManager().getChildDepartments(Long.valueOf(orgDep), false);
                    for (V3xOrgDepartment v3xDep : depList) {
                        orgDepList.add(v3xDep.getId().toString());
                    }
                }
                Object[] orgDepObj = FormSearchUtil.getSingleOrgSQL(fieldName, orgDepList.toArray(new String[orgDepList.size()]));
                conditionSb.append(" (").append(orgDepObj[0]).append(") ");
                queryParams.addAll((List)orgDepObj[1]);
                break;
            }
            case EXTEND_MEMBER: {
                String[] orgMemArr = values.toString().replaceAll("Member[|]", "").split("[,]");
                Object[] orgMemObj = FormSearchUtil.getSingleOrgSQL(fieldName, orgMemArr);
                conditionSb.append(" (").append(orgMemObj[0]).append(") ");
                queryParams.addAll((List)orgMemObj[1]);
                break;
            }
            case EXTEND_POST: {
                String[] orgPostArr = values.toString().replaceAll("Post[|]", "").split("[,]");
                Object[] orgPostObj = FormSearchUtil.getSingleOrgSQL(fieldName, orgPostArr);
                conditionSb.append(" (").append(orgPostObj[0]).append(") ");
                queryParams.addAll((List)orgPostObj[1]);
                break;
            }
            case EXTEND_LEVEL: {
                String[] orgLevelArr = values.toString().replaceAll("Level[|]", "").split("[,]");
                Object[] orgLevelObj = FormSearchUtil.getSingleOrgSQL(fieldName, orgLevelArr);
                conditionSb.append(" (").append(orgLevelObj[0]).append(") ");
                queryParams.addAll((List)orgLevelObj[1]);
                break;
            }
            case EXTEND_MULTI_ACCOUNT: {
                String[] orgMultiAccArr = values.toString().replaceAll("Account[|]", "").split("[,]");
                Object[] multiAccObj = FormSearchUtil.appendLikeSql(fieldName, Arrays.asList(orgMultiAccArr), " or ");
                conditionSb.append(" (").append(multiAccObj[0]).append(") ");
                queryParams.addAll((List)multiAccObj[1]);
                break;
            }
            case EXTEND_MULTI_DEPARTMENT: {
                String[] orgMultiDepArr = values.toString().replaceAll("Department[|]", "").split("[,]");
                Object[] multiDepObj = FormSearchUtil.appendLikeSql(fieldName, Arrays.asList(orgMultiDepArr), " or ");
                conditionSb.append(" (").append(multiDepObj[0]).append(") ");
                queryParams.addAll((List)multiDepObj[1]);
                break;
            }
            case EXTEND_MULTI_MEMBER: {
                String value = values.toString().replaceAll("Member[|]", "");
                if (Strings.isBlank((String)value)) {
                    conditionSb.append(FormSearchUtil.getNullSql(fieldName));
                    break;
                }
                conditionSb.append(" (").append(fieldName).append(" = ? ").append(") ");
                queryParams.add(value);
                break;
            }
            case EXTEND_MULTI_POST: {
                String[] orgMultiPostArr = values.toString().replaceAll("Post[|]", "").split("[,]");
                Object[] multiPostObj = FormSearchUtil.appendLikeSql(fieldName, Arrays.asList(orgMultiPostArr), " or ");
                conditionSb.append(" (").append(multiPostObj[0]).append(") ");
                queryParams.addAll((List)multiPostObj[1]);
                break;
            }
            case EXTEND_MULTI_LEVEL: {
                String[] orgMultiLevelArr = values.toString().replaceAll("Level[|]", "").split("[,]");
                Object[] multiLevelObj = FormSearchUtil.appendLikeSql(fieldName, Arrays.asList(orgMultiLevelArr), " or ");
                conditionSb.append(" (").append(multiLevelObj[0]).append(") ");
                queryParams.addAll((List)multiLevelObj[1]);
                break;
            }
            default: {
                if (Strings.isBlank((String)values.toString())) {
                    conditionSb.append(FormSearchUtil.getNullSql(fieldName));
                    break;
                }
                conditionSb.append(" (").append(fieldName).append(" = ? ").append(") ");
                queryParams.add(values.toString());
            }
        }
        FormQueryWhereClause whereClause = new FormQueryWhereClause();
        whereClause.setAllSqlClause(conditionSb.toString());
        whereClause.setQueryParams(queryParams);
        return whereClause;
    }

    private static Object[] getDecimalSql(String fieldName, String values) {
        ArrayList<BigDecimal> params = new ArrayList<BigDecimal>();
        String[] dataArr = values.split("[,]");
        String dateStartSql = " 1=1 ";
        if (StringUtils.isNotEmpty((String)dataArr[0])) {
            dateStartSql = fieldName + " >= ? ";
            params.add(new BigDecimal(dataArr[0]));
        }
        if (dataArr.length > 1 && StringUtils.isNotEmpty((String)dataArr[1])) {
            dateStartSql = dateStartSql + " and " + fieldName + " <= ? ";
            params.add(new BigDecimal(dataArr[1]));
        }
        return new Object[]{dateStartSql, params};
    }

    private static Object[] getTimeSql(String values, String fieldName) {
        String[] dateArr;
        StringBuilder dateSb = new StringBuilder("");
        ArrayList<Date> params = new ArrayList<Date>();
        for (String dateStr : dateArr = values.split("[,]")) {
            CustomSelectEnums.DateTime4CustomSelect dateTimeEnum = CustomSelectEnums.DateTime4CustomSelect.getEnumByKey(dateStr);
            if (null == dateTimeEnum) {
                boolean isMasterDate = false;
                Enums.MasterTableField masterTableField = Enums.MasterTableField.getEnumByKey((String)fieldName);
                if (masterTableField != null && (masterTableField == Enums.MasterTableField.start_date || masterTableField == Enums.MasterTableField.modify_date)) {
                    isMasterDate = true;
                }
                String[] startEndStr = dateStr.split("[|]");
                String dateStartSql = " 1=1 ";
                if (StringUtils.isNotEmpty((String)startEndStr[0])) {
                    Date startTime = isMasterDate ? Datetimes.getTodayFirstTime((String)startEndStr[0]) : Datetimes.parse((String)startEndStr[0]);
                    dateStartSql = fieldName + " >= ? ";
                    params.add(startTime);
                }
                if (startEndStr.length > 1 && StringUtils.isNotEmpty((String)startEndStr[1])) {
                    Date endTime = isMasterDate ? Datetimes.getTodayLastTime((String)startEndStr[1]) : Datetimes.parse((String)startEndStr[1]);
                    dateStartSql = dateStartSql + " and " + fieldName + " <= ? ";
                    params.add(endTime);
                }
                dateSb.append("or (").append(dateStartSql).append(") ");
                continue;
            }
            Date[] dateVal = CustomSelectEnums.DateTime4CustomSelect.getEnumByKey(dateStr).getTimeValue();
            dateSb.append("or (").append(fieldName).append(" >= ? and ").append(fieldName).append(" <= ? ) ");
            params.add(dateVal[0]);
            params.add(dateVal[1]);
        }
        dateSb.delete(0, 2);
        return new Object[]{dateSb.toString(), params};
    }

    private static Object[] appendLikeSql(String fieldName, List<String> strList, String link) {
        StringBuilder sb = new StringBuilder("");
        ArrayList<String> params = new ArrayList<String>();
        if (strList.size() == 1 && Strings.isBlank((String)strList.get(0))) {
            sb.append(FormSearchUtil.getNullSql(fieldName));
        } else if (CollectionUtils.isNotEmpty(strList)) {
            for (String str : strList) {
                if (StringUtils.isNotEmpty((String)str)) {
                    sb.append(link).append(fieldName).append(" like ? ");
                    params.add('%' + SQLWildcardUtil.escape((String)str) + '%');
                    continue;
                }
                sb.append(link).append(FormSearchUtil.getNullSql(fieldName));
            }
            sb.delete(0, link.length());
        }
        return new Object[]{sb.toString(), params};
    }

    private static Object[] getSingleOrgSQL(String fieldName, String[] strArr) {
        StringBuilder sb = new StringBuilder("");
        ArrayList<String> params = new ArrayList<String>();
        if (strArr.length == 1 && Strings.isBlank((String)strArr[0])) {
            sb.append(FormSearchUtil.getNullSql(fieldName));
        } else {
            int max_in = 950;
            if (strArr.length > max_in) {
                Object[] o = FormSearchUtil.getSingleOrgSQL(fieldName, Arrays.copyOfRange(strArr, max_in, strArr.length));
                sb.append(o[0]).append(" or ");
                params.addAll((List)o[1]);
                strArr = Arrays.copyOf(strArr, max_in);
            }
            StringBuilder cutSb = new StringBuilder("");
            for (String str : strArr) {
                cutSb.append(",? ");
                params.add(str);
            }
            cutSb.deleteCharAt(0);
            sb.append(MessageFormat.format(" {0} in ({1}) ", fieldName, cutSb.toString()));
        }
        return new Object[]{sb.toString(), params};
    }

    public static List<Map<String, Object>> getReportUserConditions(List<Map<String, Object>> userConditions) {
        ArrayList<Map<String, Object>> userConditionList = new ArrayList<Map<String, Object>>();
        if (userConditions == null) {
            return userConditionList;
        }
        for (Map<String, Object> userCondition : userConditions) {
            if ("Include".equalsIgnoreCase(String.valueOf(userCondition.get("operation")))) {
                userCondition.put("operation", "Like");
            }
            userConditionList.add(userCondition);
        }
        return userConditionList;
    }

    public static void getMergeConditions(String reportId, Map<String, Map<String, Object>> defaultValueMap, List<Map<String, Object>> finalUserConditions, List<Map<String, Object>> paramUserConditions, boolean isRemoveSessionDefaultValue) throws BusinessException {
        List<Object> sessionContextUserConditions = new ArrayList();
        if (AppContext.getSessionContext((String)reportId) != null) {
            List defaultContions = (List)AppContext.getSessionContext((String)reportId);
            if (isRemoveSessionDefaultValue) {
                AppContext.removeSessionArrribute((String)reportId);
                AppContext.putSessionContext((String)reportId, null);
            }
            sessionContextUserConditions = FormSearchUtil.getReportDefaultConditions(defaultContions, defaultValueMap);
        }
        List<Map<String, Object>> userConditions = FormSearchUtil.getReportUserConditions(paramUserConditions);
        if (!sessionContextUserConditions.isEmpty() && !userConditions.isEmpty()) {
            HashMap<String, String> ucMap = new HashMap<String, String>(userConditions.size());
            StringBuilder sb = new StringBuilder();
            for (Map<String, Object> uc : userConditions) {
                sb.append(String.valueOf(uc.get("aliasTableName"))).append("_").append(String.valueOf(uc.get("fieldName")));
                ucMap.put(sb.toString(), CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
                sb.setLength(0);
            }
            Iterator<Object> sessionUserconditionIterator = sessionContextUserConditions.iterator();
            while (sessionUserconditionIterator.hasNext()) {
                Map suc = (Map)sessionUserconditionIterator.next();
                sb.append(String.valueOf(suc.get("aliasTableName"))).append("_").append(String.valueOf(suc.get("fieldName")));
                if (CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(ucMap.get(sb.toString()))) {
                    sessionUserconditionIterator.remove();
                }
                sb.setLength(0);
            }
        }
        finalUserConditions.addAll(sessionContextUserConditions);
        finalUserConditions.addAll(userConditions);
    }

    private static void setNullDefaultValue(ReportConstants.FieldComType fieldComType, Map<String, Map<String, Object>> defaultValueMap, String aliasTableName, String name) {
        HashMap<String, String> defaultValue = new HashMap<String, String>();
        defaultValue.put("value", "");
        defaultValue.put("showValue", "");
        defaultValue.put("showValue2", "");
        switch (fieldComType) {
            case MEMBER: 
            case MULTIMEMBER: 
            case DEPARTMENT: 
            case MULTIDEPARTMENT: 
            case ACCOUNT: 
            case MULTIACCOUNT: 
            case TEXT: 
            case TEXTAREA: {
                defaultValueMap.put(aliasTableName + "_" + name, defaultValue);
                break;
            }
            case DATE: 
            case DATETIME: {
                defaultValue.put("startTime", "");
                defaultValue.put("endTime", "");
                defaultValueMap.put(aliasTableName + "_" + name, defaultValue);
                break;
            }
            case CHECKBOX: {
                defaultValue.put("value", "0");
                defaultValue.put("showValue", "0");
                defaultValue.put("showValue2", "0");
                defaultValueMap.put(aliasTableName + "_" + name, defaultValue);
            }
        }
    }

    public static List<Map<String, Object>> getReportDefaultConditions(List<Map<Map<String, Object>, Object>> defaultContions, Map<String, Map<String, Object>> defaultValueMap) throws BusinessException {
        EnumManager enumManager = (EnumManager)AppContext.getBean((String)"enumManagerNew");
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        ArrayList<Map<String, Object>> defaultConditions = new ArrayList<Map<String, Object>>();
        for (Map<Map<String, Object>, Object> defaultContion : defaultContions) {
            block17: for (Map.Entry<Map<String, Object>, Object> entry : defaultContion.entrySet()) {
                Object value = entry.getValue();
                Map<String, Object> key = entry.getKey();
                String fieldComTypeName = String.valueOf(key.get("fieldComType"));
                String name = String.valueOf(key.get("name"));
                String aliasTableName = String.valueOf(key.get("aliasTableName"));
                ReportConstants.FieldComType fieldComType = ReportConstants.FieldComType.of((String)fieldComTypeName);
                if (value == null) {
                    defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", ""));
                    FormSearchUtil.setNullDefaultValue(fieldComType, defaultValueMap, aliasTableName, name);
                    continue;
                }
                switch (fieldComType) {
                    case SELECT: 
                    case RADIO: 
                    case IMAGEENUM: {
                        if ("0".equals(String.valueOf(value))) continue block17;
                        CtpEnumItem ctpEnumItem = enumManager.getCtpEnumItem(Long.valueOf(String.valueOf(value)));
                        ArrayList selectValues = new ArrayList();
                        HashMap<String, Object> selectValue = new HashMap<String, Object>();
                        selectValue.put("id", value);
                        selectValue.put("name", ctpEnumItem.getShowvalue());
                        selectValue.put("value", ctpEnumItem.getValue());
                        selectValues.add(selectValue);
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", selectValues));
                        continue block17;
                    }
                    case MEMBER: {
                        ArrayList<String> memberSelectValue = new ArrayList<String>(1);
                        String memberValue = "Member|" + String.valueOf(value);
                        memberSelectValue.add(memberValue);
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", memberSelectValue));
                        V3xOrgMember orgMember = orgManager.getMemberById(Long.valueOf(String.valueOf(value)));
                        HashMap<String, String> defaultMemberValue = new HashMap<String, String>();
                        defaultMemberValue.put("value", memberValue);
                        defaultMemberValue.put("showValue", orgMember.getName());
                        defaultMemberValue.put("showValue2", memberValue);
                        defaultValueMap.put(aliasTableName + "_" + name, defaultMemberValue);
                        continue block17;
                    }
                    case MULTIMEMBER: {
                        String multiMemberSelectValue;
                        V3xOrgMember currentOrgMember;
                        String multiMemberValue = String.valueOf(value);
                        StringBuilder stringBuilder = new StringBuilder();
                        StringBuilder multiMemberNameBulder = new StringBuilder();
                        if (multiMemberValue.contains(",")) {
                            String[] valueArray = multiMemberValue.split(",");
                            for (int i = 0; i < valueArray.length; ++i) {
                                currentOrgMember = orgManager.getMemberById(Long.valueOf(valueArray[i]));
                                if (i == valueArray.length - 1) {
                                    stringBuilder.append("Member|").append(valueArray[i]);
                                    multiMemberNameBulder.append(currentOrgMember.getName());
                                    continue;
                                }
                                stringBuilder.append("Member|").append(valueArray[i]).append(",");
                                multiMemberNameBulder.append(currentOrgMember.getName()).append(",");
                            }
                            multiMemberSelectValue = stringBuilder.toString();
                        } else {
                            currentOrgMember = orgManager.getMemberById(Long.valueOf(multiMemberValue));
                            multiMemberNameBulder.append(currentOrgMember.getName());
                            multiMemberSelectValue = "Member|" + String.valueOf(value);
                        }
                        HashMap<String, String> defaultMultiMemberValue = new HashMap<String, String>();
                        defaultMultiMemberValue.put("value", multiMemberSelectValue);
                        defaultMultiMemberValue.put("showValue", multiMemberNameBulder.toString());
                        defaultMultiMemberValue.put("showValue2", multiMemberSelectValue);
                        defaultValueMap.put(aliasTableName + "_" + name, defaultMultiMemberValue);
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Like", multiMemberSelectValue));
                        continue block17;
                    }
                    case DEPARTMENT: {
                        ArrayList<String> departmentSelectValue = new ArrayList<String>(1);
                        String departmentValue = "Department|" + String.valueOf(value);
                        departmentSelectValue.add(departmentValue);
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", departmentSelectValue));
                        V3xOrgDepartment orgDepartment = orgManager.getDepartmentById(Long.valueOf(String.valueOf(value)));
                        HashMap<String, String> defaultDepartMentValue = new HashMap<String, String>();
                        defaultDepartMentValue.put("value", departmentValue);
                        defaultDepartMentValue.put("showValue", orgDepartment.getName());
                        defaultDepartMentValue.put("showValue2", departmentValue);
                        defaultValueMap.put(aliasTableName + "_" + name, defaultDepartMentValue);
                        continue block17;
                    }
                    case MULTIDEPARTMENT: {
                        String multiDepartmentSelectValue;
                        V3xOrgDepartment currentOrgDepartment;
                        String multiDepartmentValue = String.valueOf(value);
                        StringBuilder stringMultiBuilder = new StringBuilder();
                        StringBuilder departmentNameBuilder = new StringBuilder();
                        if (multiDepartmentValue.contains(",")) {
                            String[] valueArray = multiDepartmentValue.split(",");
                            for (int i = 0; i < valueArray.length; ++i) {
                                currentOrgDepartment = orgManager.getDepartmentById(Long.valueOf(valueArray[i]));
                                if (i == valueArray.length - 1) {
                                    stringMultiBuilder.append("Department|").append(valueArray[i]);
                                    departmentNameBuilder.append(currentOrgDepartment.getName());
                                    continue;
                                }
                                stringMultiBuilder.append("Department|").append(valueArray[i]).append(",");
                                departmentNameBuilder.append(currentOrgDepartment.getName()).append(",");
                            }
                            multiDepartmentSelectValue = stringMultiBuilder.toString();
                        } else {
                            currentOrgDepartment = orgManager.getDepartmentById(Long.valueOf(multiDepartmentValue));
                            departmentNameBuilder.append(currentOrgDepartment.getName());
                            multiDepartmentSelectValue = "Department|" + String.valueOf(value);
                        }
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Like", multiDepartmentSelectValue));
                        HashMap<String, String> defaultMultiDepartmentValue = new HashMap<String, String>();
                        defaultMultiDepartmentValue.put("value", multiDepartmentSelectValue);
                        defaultMultiDepartmentValue.put("showValue", departmentNameBuilder.toString());
                        defaultMultiDepartmentValue.put("showValue2", multiDepartmentSelectValue);
                        defaultValueMap.put(aliasTableName + "_" + name, defaultMultiDepartmentValue);
                        continue block17;
                    }
                    case POST: {
                        ArrayList<String> postSelectValue = new ArrayList<String>(1);
                        postSelectValue.add("Post|" + String.valueOf(value));
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", postSelectValue));
                        continue block17;
                    }
                    case MULTIPOST: {
                        String mulitPostSelectValue;
                        String postValue = String.valueOf(value);
                        if (postValue.contains(",")) {
                            String[] valueArray = postValue.split(",");
                            StringBuilder stringPostBuilder = new StringBuilder();
                            for (int i = 0; i < valueArray.length; ++i) {
                                if (i == valueArray.length - 1) {
                                    stringPostBuilder.append("Post|").append(valueArray[i]);
                                    continue;
                                }
                                stringPostBuilder.append("Post|").append(valueArray[i]).append(",");
                            }
                            mulitPostSelectValue = stringPostBuilder.toString();
                        } else {
                            mulitPostSelectValue = "Post|" + String.valueOf(value);
                        }
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Like", mulitPostSelectValue));
                        continue block17;
                    }
                    case LEVEL: {
                        ArrayList<String> levelSelectValue = new ArrayList<String>(1);
                        levelSelectValue.add("Level|" + String.valueOf(value));
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", levelSelectValue));
                        continue block17;
                    }
                    case MULTILEVEL: {
                        String multiLevelSelectValue;
                        String levelValue = String.valueOf(value);
                        if (levelValue.contains(",")) {
                            String[] valueArray = levelValue.split(",");
                            StringBuilder stringLevelBuilder = new StringBuilder();
                            for (int i = 0; i < valueArray.length; ++i) {
                                if (i == valueArray.length - 1) {
                                    stringLevelBuilder.append("Level|").append(valueArray[i]);
                                    continue;
                                }
                                stringLevelBuilder.append("Level|").append(valueArray[i]).append(",");
                            }
                            multiLevelSelectValue = stringLevelBuilder.toString();
                        } else {
                            multiLevelSelectValue = "Level|" + String.valueOf(value);
                        }
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", multiLevelSelectValue));
                        continue block17;
                    }
                    case ACCOUNT: {
                        ArrayList<String> accountSelectValue = new ArrayList<String>(1);
                        accountSelectValue.add("Account|" + String.valueOf(value));
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", accountSelectValue));
                        V3xOrgAccount orgAccount = orgManager.getAccountById(Long.valueOf(String.valueOf(value)));
                        HashMap<String, String> defaultAccountValue = new HashMap<String, String>();
                        defaultAccountValue.put("value", "Account|" + String.valueOf(value));
                        defaultAccountValue.put("showValue", orgAccount.getName());
                        defaultAccountValue.put("showValue2", "Account|" + String.valueOf(value));
                        defaultValueMap.put(aliasTableName + "_" + name, defaultAccountValue);
                        continue block17;
                    }
                    case MULTIACCOUNT: {
                        String multiAccountSelectValue;
                        V3xOrgAccount currentOrgAccount;
                        String accountValue = String.valueOf(value);
                        StringBuilder stringAccountBuilder = new StringBuilder();
                        StringBuilder accountNameBuilder = new StringBuilder();
                        if (accountValue.contains(",")) {
                            String[] valueArray = accountValue.split(",");
                            for (int i = 0; i < valueArray.length; ++i) {
                                currentOrgAccount = orgManager.getAccountById(Long.valueOf(valueArray[i]));
                                if (i == valueArray.length - 1) {
                                    stringAccountBuilder.append("Account|").append(valueArray[i]);
                                    accountNameBuilder.append(currentOrgAccount.getName());
                                    continue;
                                }
                                stringAccountBuilder.append("Account|").append(valueArray[i]).append(",");
                                accountNameBuilder.append(currentOrgAccount.getName()).append(",");
                            }
                            multiAccountSelectValue = stringAccountBuilder.toString();
                        } else {
                            currentOrgAccount = orgManager.getAccountById(Long.valueOf(accountValue));
                            accountNameBuilder.append(currentOrgAccount.getName());
                            multiAccountSelectValue = "Account|" + String.valueOf(value);
                        }
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Like", multiAccountSelectValue));
                        HashMap<String, String> defaultMultiAccountValue = new HashMap<String, String>();
                        defaultMultiAccountValue.put("value", multiAccountSelectValue);
                        defaultMultiAccountValue.put("showValue", accountNameBuilder.toString());
                        defaultMultiAccountValue.put("showValue2", multiAccountSelectValue);
                        defaultValueMap.put(aliasTableName + "_" + name, defaultMultiAccountValue);
                        continue block17;
                    }
                    case TEXT: 
                    case TEXTAREA: {
                        if (Enums.FieldType.DECIMAL.getKey().equals(String.valueOf(key.get("dbType")))) {
                            defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", value));
                        } else if ("id".equals(name)) {
                            defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", value));
                        } else {
                            defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Like", value));
                        }
                        HashMap<String, Object> defaultTextValue = new HashMap<String, Object>();
                        defaultTextValue.put("value", value);
                        defaultTextValue.put("showValue", value);
                        defaultTextValue.put("showValue2", value);
                        defaultValueMap.put(aliasTableName + "_" + name, defaultTextValue);
                        continue block17;
                    }
                    case DATE: {
                        String dataValue = DateUtil.format((Date)((Date)value), (String)"yyyy-MM-dd");
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", dataValue));
                        HashMap<String, Object> defaultDateValue = new HashMap<String, Object>();
                        defaultDateValue.put("value", DATE_CUSTOM);
                        defaultDateValue.put("showValue", key.get("aliasDisplay"));
                        defaultDateValue.put("showValue2", DATE_CUSTOM);
                        defaultDateValue.put("startTime", dataValue);
                        defaultDateValue.put("endTime", dataValue);
                        defaultValueMap.put(aliasTableName + "_" + name, defaultDateValue);
                        continue block17;
                    }
                    case DATETIME: {
                        defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", value));
                        HashMap<String, Object> defaultDateTimeValue = new HashMap<String, Object>();
                        defaultDateTimeValue.put("value", DATE_CUSTOM);
                        defaultDateTimeValue.put("showValue", key.get("aliasDisplay"));
                        defaultDateTimeValue.put("showValue2", DATE_CUSTOM);
                        defaultDateTimeValue.put("startTime", value);
                        defaultDateTimeValue.put("endTime", value);
                        defaultValueMap.put(aliasTableName + "_" + name, defaultDateTimeValue);
                        continue block17;
                    }
                }
                HashMap<String, Object> defaultValue = new HashMap<String, Object>();
                defaultValue.put("value", value);
                defaultValue.put("showValue", value);
                defaultValue.put("showValue2", value);
                defaultValueMap.put(aliasTableName + "_" + name, defaultValue);
                defaultConditions.add(FormSearchUtil.getCondition(aliasTableName, name, "Equal", value));
            }
        }
        return defaultConditions;
    }

    @Deprecated
    public static List<Map<String, Object>> getUserConditions(com.seeyon.cap4.form.bean.FormBean formBean, List<Map<String, Object>> userConditions) {
        ArrayList<Map<String, Object>> userConditionList = new ArrayList<Map<String, Object>>();
        if (userConditions == null) {
            return userConditionList;
        }
        FormBean formBean3 = (FormBean)AppContext.getThreadContext((String)"magicCAP3FormBean");
        for (Map<String, Object> userCondition : userConditions) {
            HashMap<String, Object> nullCondition;
            Map lastEnum;
            StringBuilder sb;
            List enums;
            Date date;
            Object fieldValue;
            FormFieldBean formFieldBean;
            String key = null;
            String fieldName = (String)userCondition.get("fieldName");
            if (formBean != null) {
                formFieldBean = formBean.getFieldBeanByName(fieldName, true);
                if (formFieldBean != null) {
                    key = formFieldBean.getInputTypeEnum().getKey();
                    if (userCondition.get("aliasTableName") == null) {
                        userCondition.put("aliasTableName", formFieldBean.getOwnerTableName());
                    }
                    if (userCondition.get("fieldType") == null) {
                        userCondition.put("fieldType", formFieldBean.getFieldType());
                    }
                    if (userCondition.get("inputType") == null) {
                        userCondition.put("inputType", formFieldBean.getInputType());
                    }
                }
            } else if (formBean3 != null && (formFieldBean = formBean3.getFieldBeanByName(fieldName, true)) != null) {
                key = formFieldBean.getFinalInputType(true);
                if (userCondition.get("aliasTableName") == null) {
                    userCondition.put("aliasTableName", formFieldBean.getOwnerTableName());
                }
                if (userCondition.get("fieldType") == null) {
                    userCondition.put("fieldType", formFieldBean.getFieldType());
                }
                if (userCondition.get("inputType") == null) {
                    userCondition.put("inputType", formFieldBean.getInputType());
                }
            }
            if (key == null) {
                Enums.FlowBusinessFixField fixField = Enums.FlowBusinessFixField.getEnumByKey((String)fieldName);
                String string = key = fixField == null ? null : fixField.getInputType();
            }
            if (Enums.MasterTableField.state.getKey().equals(fieldName) || Enums.MasterTableField.ratifyflag.getKey().equals(fieldName) || Enums.MasterTableField.finishedflag.getKey().equals(fieldName) || Enums.FlowBusinessFixField.importantLevel.getKey().equals(fieldName) || Enums.FlowBusinessFixField.archiveId.getKey().equals(fieldName)) {
                key = ReportConstants.FieldComType.CUSTOMENUM.getComName();
            }
            if (key.equals(FormFieldComEnum.EXTEND_DATE.getKey())) {
                fieldValue = userCondition.get("fieldValue");
                if (fieldValue != null && fieldValue instanceof Date) {
                    date = (Date)fieldValue;
                    userCondition.put("fieldValue", DateUtil.format((Date)date, (String)"yyyy-MM-dd"));
                }
                userConditionList.add(FormSearchUtil.conversionOperation(userCondition));
                continue;
            }
            if (key.equals(FormFieldComEnum.EXTEND_DATETIME.getKey())) {
                fieldValue = userCondition.get("fieldValue");
                if (fieldValue != null && fieldValue instanceof Date) {
                    date = (Date)fieldValue;
                    userCondition.put("fieldValue", DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm"));
                }
                userConditionList.add(FormSearchUtil.conversionOperation(userCondition));
                continue;
            }
            if (key.equals(FormFieldComEnum.SELECT.getKey()) || key.equals(FormFieldComEnum.RADIO.getKey()) || key.equals(FormFieldComEnum.IMAGE_RADIO.getKey()) || key.equals(FormFieldComEnum.IMAGE_SELECT.getKey())) {
                fieldValue = userCondition.get("fieldValue");
                if (fieldValue instanceof List) {
                    enums = (List)fieldValue;
                    if (enums.size() == 1 && Strings.isBlank((String)((String)((Map)enums.get(0)).get("id")))) {
                        userConditionList.add(FormSearchUtil.conversionOperation(FormSearchUtil.getNullCondition(userCondition)));
                        continue;
                    }
                    sb = new StringBuilder();
                    lastEnum = (Map)enums.get(enums.size() - 1);
                    if (Strings.isBlank((String)((String)lastEnum.get("id")))) {
                        for (int i = 0; i < enums.size() - 1; ++i) {
                            if (i == enums.size() - 2) {
                                sb.append(((Map)enums.get(i)).get("id"));
                                continue;
                            }
                            sb.append(((Map)enums.get(i)).get("id")).append(",");
                        }
                        String rightChar = String.valueOf(userCondition.get("rightChar"));
                        userCondition.put("fieldValue", sb.toString());
                        userCondition.put("rightChar", "");
                        userCondition.put("rowOperation", "or");
                        userConditionList.add(FormSearchUtil.conversionOperation(userCondition));
                        nullCondition = new HashMap<String, Object>();
                        nullCondition.putAll(userCondition);
                        nullCondition.put("rowOperation", "and");
                        nullCondition.put("leftChar", "");
                        nullCondition.put("rightChar", rightChar);
                        userConditionList.add(FormSearchUtil.getNullCondition(nullCondition));
                        continue;
                    }
                    for (int i = 0; i < enums.size(); ++i) {
                        if (i == enums.size() - 1) {
                            sb.append(((Map)enums.get(i)).get("id"));
                            continue;
                        }
                        sb.append(((Map)enums.get(i)).get("id")).append(",");
                    }
                    userCondition.put("fieldValue", sb.toString());
                    userConditionList.add(FormSearchUtil.conversionOperation(userCondition));
                    continue;
                }
                userConditionList.add(FormSearchUtil.conversionOperation(userCondition));
                continue;
            }
            if (key.equals(ReportConstants.FieldComType.CUSTOMENUM.getComName())) {
                fieldValue = userCondition.get("fieldValue");
                if (fieldValue instanceof List) {
                    enums = (List)fieldValue;
                    if (enums.size() == 1 && Strings.isBlank((String)String.valueOf(((Map)enums.get(0)).get("value")))) {
                        userConditionList.add(FormSearchUtil.conversionOperation(FormSearchUtil.getNullCondition(userCondition)));
                        continue;
                    }
                    sb = new StringBuilder();
                    lastEnum = (Map)enums.get(enums.size() - 1);
                    if (Strings.isBlank((String)String.valueOf(lastEnum.get("value")))) {
                        for (int i = 0; i < enums.size() - 1; ++i) {
                            if (i == enums.size() - 2) {
                                sb.append(((Map)enums.get(i)).get("value"));
                                continue;
                            }
                            sb.append(((Map)enums.get(i)).get("value")).append(",");
                        }
                        String rightChar = String.valueOf(userCondition.get("rightChar"));
                        userCondition.put("fieldValue", sb.toString());
                        userCondition.put("rightChar", "");
                        userCondition.put("rowOperation", "or");
                        userConditionList.add(FormSearchUtil.conversionOperation(userCondition));
                        nullCondition = new HashMap();
                        nullCondition.putAll(userCondition);
                        nullCondition.put("rowOperation", "and");
                        nullCondition.put("leftChar", "");
                        nullCondition.put("rightChar", rightChar);
                        userConditionList.add(FormSearchUtil.getNullCondition(nullCondition));
                        continue;
                    }
                    for (int i = 0; i < enums.size(); ++i) {
                        if (i == enums.size() - 1) {
                            sb.append(((Map)enums.get(i)).get("value"));
                            continue;
                        }
                        sb.append(((Map)enums.get(i)).get("value")).append(",");
                    }
                    userCondition.put("fieldValue", sb.toString());
                    userConditionList.add(FormSearchUtil.conversionOperation(userCondition));
                    continue;
                }
                userConditionList.add(FormSearchUtil.conversionOperation(userCondition));
                continue;
            }
            if (key.equals(FormFieldComEnum.EXTEND_MEMBER.getKey()) || key.equals(FormFieldComEnum.EXTEND_MULTI_MEMBER.getKey()) || key.equals(FormFieldComEnum.EXTEND_DEPARTMENT.getKey()) || key.equals(FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getKey()) || key.equals(FormFieldComEnum.EXTEND_POST.getKey()) || key.equals(FormFieldComEnum.EXTEND_MULTI_POST.getKey()) || key.equals(FormFieldComEnum.EXTEND_LEVEL.getKey()) || key.equals(FormFieldComEnum.EXTEND_MULTI_LEVEL.getKey()) || key.equals(FormFieldComEnum.EXTEND_ACCOUNT.getKey()) || key.equals(FormFieldComEnum.EXTEND_MULTI_ACCOUNT.getKey())) {
                userCondition.put("fieldValue", FormSearchUtil.getExtendConditionFieldValue(userCondition.get("fieldValue")));
                userConditionList.add(FormSearchUtil.conversionOperation(userCondition));
                continue;
            }
            userConditionList.add(FormSearchUtil.conversionOperation(userCondition));
        }
        return userConditionList;
    }

    private static String getExtendConditionFieldValue(Object fieldValue) {
        if (fieldValue == null) {
            return "";
        }
        HashSet<String> lastValue = new HashSet<String>();
        if (fieldValue instanceof List) {
            List values = (List)fieldValue;
            for (String value : values) {
                lastValue.add(FormSearchUtil.getExtendConditionFieldLastValue(value));
            }
        } else if (Strings.isNotBlank((String)fieldValue.toString())) {
            lastValue.add(FormSearchUtil.getExtendConditionFieldLastValue(fieldValue.toString()));
        }
        return StringUtils.join(lastValue, (String)",");
    }

    private static String getExtendConditionFieldLastValue(String fieldValue) {
        if (fieldValue == null) {
            return fieldValue;
        }
        if (fieldValue.contains("|")) {
            String[] values = fieldValue.split(",");
            HashSet<String> set = new HashSet<String>();
            for (String value : values) {
                if (value.contains(Strings.capitalize((String)FormFieldComEnum.EXTEND_MEMBER.getKey()) + "|") || value.contains(Strings.capitalize((String)FormFieldComEnum.EXTEND_DEPARTMENT.getKey()) + "|") || value.contains(Strings.capitalize((String)FormFieldComEnum.EXTEND_ACCOUNT.getKey()) + "|") || value.contains(Strings.capitalize((String)FormFieldComEnum.EXTEND_POST.getKey()) + "|") || value.contains(Strings.capitalize((String)FormFieldComEnum.EXTEND_LEVEL.getKey()) + "|")) {
                    value = value.substring(value.indexOf("|") + 1, value.length());
                }
                set.add(value);
            }
            fieldValue = StringUtils.join(set, (String)",");
        }
        return fieldValue;
    }

    @Deprecated
    public static Map<String, Object> conversionOperation(Map<String, Object> userCondition) {
        if ("Like".equals(userCondition.get("operation"))) {
            userCondition.put("operation", "like");
        } else if ("Equal".equals(userCondition.get("operation"))) {
            userCondition.put("operation", "=");
        } else if ("NotEqual".equals(userCondition.get("operation"))) {
            userCondition.put("operation", "<>");
        } else if ("Less".equals(userCondition.get("operation"))) {
            userCondition.put("operation", "<");
        } else if ("LessEqual".equals(userCondition.get("operation"))) {
            userCondition.put("operation", "<=");
        } else if ("GreatEqual".equals(userCondition.get("operation"))) {
            userCondition.put("operation", ">=");
        } else if ("Greater".equals(userCondition.get("operation"))) {
            userCondition.put("operation", ">");
        } else if ("NotLike".equals(userCondition.get("operation"))) {
            userCondition.put("operation", "not_like");
        } else if ("Include".equalsIgnoreCase(String.valueOf(userCondition.get("operation")))) {
            userCondition.put("operation", "include");
        } else {
            userCondition.put("operation", "=");
        }
        return userCondition;
    }

    private static Map<String, Object> getNullCondition(Map<String, Object> userCondition) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("aliasTableName", userCondition.get("aliasTableName"));
        condition.put("rowOperation", userCondition.get("rowOperation"));
        condition.put("fieldName", userCondition.get("fieldName"));
        condition.put("rightChar", userCondition.get("rightChar"));
        condition.put("leftChar", userCondition.get("leftChar"));
        condition.put("operation", userCondition.get("operation"));
        condition.put("fieldValue", "");
        return condition;
    }

    private static Map<String, Object> getCondition(String aliasTableName, String fieldName, String operation, Object fieldValue) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("aliasTableName", aliasTableName);
        condition.put("rowOperation", "and");
        condition.put("fieldName", fieldName);
        condition.put("leftChar", "(");
        condition.put("rightChar", ")");
        condition.put("operation", operation);
        condition.put("fieldValue", fieldValue);
        return condition;
    }

    @Deprecated
    public static List<Map<String, Object>> getFilterFieldsDefaultCondition(com.seeyon.cap4.form.bean.FormBean formBean, List<SimpleObjectBean> searchFields) throws BusinessException {
        ArrayList<Map<String, Object>> conditions = new ArrayList<Map<String, Object>>();
        block11: for (SimpleObjectBean simpleObjectBean : searchFields) {
            FormFieldBean formFieldBean = FormSearchUtil.getFormFieldBean(formBean, simpleObjectBean);
            if (null == formFieldBean || FormFieldComEnum.LINE_NUMBER.getKey().equals(formFieldBean.getInputType())) continue;
            FormFieldComEnum formFieldComEnum = FormFieldComEnum.getEnumByKey((String)formFieldBean.getInputType());
            Map defaultValueJson = (Map)JSONUtil.parseJSONString((String)simpleObjectBean.getExtAttr("defaultValJOSN"), Map.class);
            switch (formFieldComEnum) {
                case EXTEND_DATE: {
                    Date endDate;
                    String date;
                    Map firstJson;
                    CustomSelectEnums.DateTime4CustomSelect dateTime4CustomSelect;
                    List rightArray;
                    if (defaultValueJson.get("defaultCheckFirst") == null || !"1".equals(defaultValueJson.get("defaultCheckFirst"))) break;
                    Map dateTimeYzxxValueJson = (Map)defaultValueJson.get("dateTimeYzxxValue");
                    if (dateTimeYzxxValueJson == null || (rightArray = (List)dateTimeYzxxValueJson.get("rightArray")).size() < 1 || (dateTime4CustomSelect = CustomSelectEnums.DateTime4CustomSelect.getEnumByKey((String)(firstJson = (Map)rightArray.get(0)).get("value"))) == null) continue block11;
                    Date[] datas = dateTime4CustomSelect.getTimeValue();
                    Date startDate = datas[0];
                    if (startDate != null) {
                        date = DateUtil.format((Date)startDate, (String)"yyyy-MM-dd");
                        conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), ">=", date));
                    }
                    if ((endDate = datas[1]) == null) continue block11;
                    date = DateUtil.format((Date)endDate, (String)"yyyy-MM-dd");
                    conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), "<=", date));
                    break;
                }
                case EXTEND_DATETIME: {
                    Date endDate;
                    String date;
                    Map firstJson;
                    CustomSelectEnums.DateTime4CustomSelect dateTime4CustomSelect;
                    List rightArray;
                    if (defaultValueJson.get("defaultCheckFirst") == null || !"1".equals(defaultValueJson.get("defaultCheckFirst"))) break;
                    Map dateTimeYzxxValueJson = (Map)defaultValueJson.get("dateTimeYzxxValue");
                    if (dateTimeYzxxValueJson == null || (rightArray = (List)dateTimeYzxxValueJson.get("rightArray")).size() < 1 || (dateTime4CustomSelect = CustomSelectEnums.DateTime4CustomSelect.getEnumByKey((String)(firstJson = (Map)rightArray.get(0)).get("value"))) == null) continue block11;
                    Date[] datas = dateTime4CustomSelect.getTimeValue();
                    Date startDate = datas[0];
                    if (startDate != null) {
                        date = DateUtil.format((Date)startDate, (String)"yyyy-MM-dd HH:mm:ss");
                        conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), ">=", date));
                    }
                    if ((endDate = datas[1]) == null) continue block11;
                    date = DateUtil.format((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss");
                    conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), "<=", date));
                    break;
                }
                case TEXT: 
                case TEXTAREA: {
                    CustomSelectEnums.SystemVar4CustomSelect systemVar4CustomSelect;
                    FormulaEnums.FormulaVar formulaVar;
                    if (defaultValueJson.get("isSettingDefaultVal") == null || !"true".equals(defaultValueJson.get("isSettingDefaultVal"))) break;
                    String showValue = "";
                    String defaultVal = (String)defaultValueJson.get("defaultVal");
                    if ("extend".equals(defaultValueJson.get("defaultType"))) {
                        formulaVar = FormulaEnums.FormulaVar.getEnumByKey((String)defaultVal);
                        systemVar4CustomSelect = CustomSelectEnums.SystemVar4CustomSelect.getEnumByKey(defaultVal);
                        if (formulaVar != null) {
                            showValue = formulaVar.getValue();
                        }
                        if (systemVar4CustomSelect != null) {
                            showValue = systemVar4CustomSelect.getIdValue();
                        }
                    } else {
                        showValue = defaultVal;
                    }
                    if (Enums.FieldType.DECIMAL.getKey().equals(formFieldBean.getFieldType())) {
                        conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), ">=", showValue));
                        conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), "<=", showValue));
                        break;
                    }
                    conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), "like", showValue));
                    break;
                }
                case CHECKBOX: {
                    if (defaultValueJson.get("isSettingDefaultVal") == null || !"true".equals(defaultValueJson.get("isSettingDefaultVal"))) break;
                    String defaultVal = (String)defaultValueJson.get("defaultVal");
                    if ("0".equalsIgnoreCase(defaultVal)) continue block11;
                    conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), "=", defaultVal));
                    break;
                }
                case EXTEND_DEPARTMENT: 
                case EXTEND_MULTI_DEPARTMENT: {
                    CustomSelectEnums.SystemVar4CustomSelect systemVar4CustomSelect;
                    FormulaEnums.FormulaVar formulaVar;
                    if (defaultValueJson.get("isSettingDefaultVal") == null || !"true".equals(defaultValueJson.get("isSettingDefaultVal"))) break;
                    String showValue = "";
                    String defaultVal = (String)defaultValueJson.get("defaultVal");
                    if ("extend".equals(defaultValueJson.get("defaultType"))) {
                        formulaVar = FormulaEnums.FormulaVar.getEnumByKey((String)defaultVal);
                        systemVar4CustomSelect = CustomSelectEnums.SystemVar4CustomSelect.getEnumByKey(defaultVal);
                        if (formulaVar != null) {
                            showValue = formulaVar.getValue();
                        }
                        if (systemVar4CustomSelect != null) {
                            showValue = systemVar4CustomSelect.getIdValue();
                            switch (systemVar4CustomSelect) {
                                case org_currentUserDepartmentId: 
                                case org_currentUserJZDeptId: 
                                case org_currentUserSuperiorDeptId: {
                                    showValue = showValue + "|1";
                                    break;
                                }
                            }
                        }
                        conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), "include", showValue));
                        break;
                    }
                    showValue = (String)defaultValueJson.get("handOrgIds");
                    conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), "include", showValue));
                    break;
                }
                case EXTEND_ACCOUNT: 
                case EXTEND_MEMBER: 
                case EXTEND_MULTI_ACCOUNT: 
                case EXTEND_MULTI_MEMBER: {
                    CustomSelectEnums.SystemVar4CustomSelect systemVar4CustomSelect;
                    FormulaEnums.FormulaVar formulaVar;
                    if (defaultValueJson.get("isSettingDefaultVal") == null || !"true".equals(defaultValueJson.get("isSettingDefaultVal"))) break;
                    String showValue = "";
                    String defaultVal = (String)defaultValueJson.get("defaultVal");
                    if ("extend".equals(defaultValueJson.get("defaultType"))) {
                        formulaVar = FormulaEnums.FormulaVar.getEnumByKey((String)defaultVal);
                        systemVar4CustomSelect = CustomSelectEnums.SystemVar4CustomSelect.getEnumByKey(defaultVal);
                        if (formulaVar != null) {
                            showValue = formulaVar.getValue();
                        }
                        if (systemVar4CustomSelect != null) {
                            showValue = systemVar4CustomSelect.getIdValue();
                        }
                        if (FormFieldComEnum.EXTEND_MEMBER.getKey().equals(formFieldComEnum.getKey()) || FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(formFieldComEnum.getKey())) {
                            conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), "=", showValue));
                            break;
                        }
                        conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), "include", showValue));
                        break;
                    }
                    showValue = (String)defaultValueJson.get("handOrgIds");
                    if (FormFieldComEnum.EXTEND_MEMBER.getKey().equals(formFieldComEnum.getKey()) || FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(formFieldComEnum.getKey())) {
                        conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), "=", showValue));
                        break;
                    }
                    conditions.add(FormSearchUtil.getCondition(formFieldBean.getOwnerTableName(), formFieldBean.getName(), "include", showValue));
                    break;
                }
            }
        }
        return conditions;
    }

    public static FormFieldBean getFormFieldBean(com.seeyon.cap4.form.bean.FormBean formBean, SimpleObjectBean sob) {
        String fieldName = sob.getName().contains(".") ? sob.getName().split("[.]")[1] : sob.getName();
        FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName, true);
        if (formFieldBean == null && sob.getName().contains("field")) {
            formFieldBean = formBean.getFieldBeanByName(sob.getName());
        }
        return formFieldBean;
    }

    public static Object dealValueByFieldInputType(FormFieldBean formFieldBean, Object value) {
        return FormSearchUtil.dealValueByFieldInputType(formFieldBean.getInputType(), value);
    }

    public static Object dealValueByFieldInputType(String inputType, Object value) {
        Object resultValue = value;
        if (FormFieldComEnum.EXTEND_DATE.getKey().equals(inputType) && resultValue instanceof Date) {
            resultValue = DateUtil.format((Date)((Date)resultValue), (String)"yyyy-MM-dd");
        } else if (FormFieldComEnum.EXTEND_DATETIME.getKey().equals(inputType) && resultValue instanceof Date) {
            resultValue = DateUtil.format((Date)((Date)resultValue), (String)"yyyy-MM-dd HH:mm:ss");
        } else if ((FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equals(inputType) || FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getKey().equals(inputType)) && Strings.isNotBlank((String)String.valueOf(resultValue))) {
            StringBuilder sb = new StringBuilder();
            String valueString = String.valueOf(resultValue);
            String[] values = valueString.split("[,]");
            int j = values.length;
            for (int i = 0; i < j; ++i) {
                if (i == j - 1) {
                    sb.append(values[i]).append("|1");
                    continue;
                }
                sb.append(values[i]).append("|1").append(",");
            }
            resultValue = sb.toString();
        }
        return resultValue;
    }
}

