/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.util;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTableIndexBean;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;

public class PerfUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(PerfUtil.class);
    private static CAP4FormManager cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getIndexColumInUniqueByFormId(long formId) {
        HashSet<String> fieldSet = new HashSet<String>();
        FormBean formBean = cap4FormManager.getForm(formId, false);
        if (formBean != null) {
            FormTableIndexBean formTableIndexBean = new FormTableIndexBean();
            JDBCAgent jdbc = new JDBCAgent();
            try {
                for (List fieldStrs : formBean.getUniqueFieldList()) {
                    for (String fieldStr : fieldStrs) {
                        FormTableBean formTableBean = formBean.getFormTableBeanByFieldName(fieldStr);
                        String tableName = formTableBean.getTableName();
                        if (!formTableIndexBean.checkIndex(jdbc, tableName, fieldStr)) continue;
                        fieldSet.add(fieldStr);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                jdbc.close();
            }
        }
        return new ArrayList<String>(fieldSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createIndexInUniqueByFormId(long formId) throws BusinessException {
        FormBean formBean = cap4FormManager.getForm(formId, false);
        if (formBean == null) return;
        JDBCAgent jdbcAgent = new JDBCAgent();
        try {
            FormTableIndexBean formTableIndexBean = new FormTableIndexBean();
            for (List fieldStrs : formBean.getUniqueFieldList()) {
                String resultFieldStr = "";
                int resultFieldValueCount = 0;
                String resultTableName = "";
                for (String fieldStr : fieldStrs) {
                    FormTableBean formTableBean = formBean.getFormTableBeanByFieldName(fieldStr);
                    String tableName = formTableBean.getTableName();
                    try {
                        jdbcAgent.execute("select count(1) from (select distinct( " + fieldStr + " ) from " + tableName + " ) a");
                        jdbcAgent.getQueryResult().next();
                        int fieldValueCount = jdbcAgent.getQueryResult().getInt(1);
                        if (fieldValueCount <= resultFieldValueCount) continue;
                        resultFieldValueCount = fieldValueCount;
                        resultFieldStr = fieldStr;
                        resultTableName = tableName;
                    }
                    catch (SQLException e) {
                        throw new BusinessException("\u68c0\u67e5\u5b57\u6bb5\u503c\u5206\u5e03\u6027\u5f02\u5e38", (Throwable)e);
                    }
                }
                if (!Strings.isNotEmpty((String)resultFieldStr)) continue;
                try {
                    jdbcAgent.execute(formTableIndexBean.createColumnIndexSql(resultTableName, resultFieldStr));
                }
                catch (SQLException e) {
                    throw new BusinessException("\u521b\u5efa\u5b57\u6bb5\u7d22\u5f15\u5f02\u5e38", (Throwable)e);
                    return;
                }
            }
        }
        finally {
            jdbcAgent.close();
        }
    }

    public static void main(String[] args) {
    }
}

