/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.util;

import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgEntity;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectPersonOperation {
    private static Log log = LogFactory.getLog(SelectPersonOperation.class);
    private static String[] str = new String[]{"Member", "Department", "Team", "Level", "Post", "Account", "Department0", "Department1", "Node", "FormField", "JoinAccountTag"};

    private static OrgManager getOrgManager() {
        return (OrgManager)AppContext.getBean((String)"orgManager");
    }

    private static EnumManager getEnumManagerNew() {
        return (EnumManager)AppContext.getBean((String)"enumManagerNew");
    }

    private static boolean isIn(String typename) {
        for (int i = 0; i < str.length; ++i) {
            if (!typename.equals(str[i])) continue;
            return true;
        }
        return false;
    }

    public static int changeType(String oldType) throws BusinessException {
        if (SelectPersonOperation.isIn(oldType)) {
            for (int i = 0; i < str.length; ++i) {
                if ("Member".equals(oldType)) {
                    return 0;
                }
                if ("Department".equals(oldType) || "Department0".equals(oldType)) {
                    return 1;
                }
                if ("Team".equals(oldType)) {
                    return 2;
                }
                if ("Level".equals(oldType)) {
                    return 3;
                }
                if ("Post".equals(oldType)) {
                    return 4;
                }
                if ("Account".equals(oldType)) {
                    return 5;
                }
                if ("Department1".equals(oldType)) {
                    return 6;
                }
                if ("Node".equals(oldType)) {
                    return 7;
                }
                if ("FormField".equals(oldType)) {
                    return 8;
                }
                if (!"JoinAccountTag".equals(oldType)) continue;
                return 9;
            }
        } else {
            throw new BusinessException("\u8be5\u7c7b\u578b\u6ca1\u6709\u5728\u9009\u4eba\u7ec4\u4ef6\u8303\u56f4\u5185\uff01");
        }
        return 0;
    }

    public static String getTypeByTypeId(int typeId) {
        if (typeId == 0) {
            return "Member";
        }
        if (typeId == 1) {
            return "Department";
        }
        if (typeId == 2) {
            return "Team";
        }
        if (typeId == 3) {
            return "Level";
        }
        if (typeId == 4) {
            return "Post";
        }
        if (typeId == 5) {
            return "Account";
        }
        if (typeId == 6) {
            return "Department";
        }
        if (typeId == 7) {
            return "Node";
        }
        if (typeId == 8) {
            return "FormField";
        }
        if (typeId == 9) {
            return "JoinAccountTag";
        }
        return "";
    }

    public static String getNameByTypeIdAndUserId(int typeId, Long userId) throws BusinessException {
        V3xOrgMember voe = null;
        if (userId != null) {
            CtpEnumItem item;
            if (typeId == 0) {
                try {
                    voe = SelectPersonOperation.getOrgManager().getMemberById(userId);
                }
                catch (BusinessException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            } else if (typeId == 1) {
                voe = SelectPersonOperation.getOrgManager().getDepartmentById(userId);
            } else if (typeId == 2) {
                voe = SelectPersonOperation.getOrgManager().getTeamById(userId);
            } else if (typeId == 3) {
                voe = SelectPersonOperation.getOrgManager().getLevelById(userId);
            } else if (typeId == 4) {
                voe = SelectPersonOperation.getOrgManager().getPostById(userId);
            } else if (typeId == 5) {
                voe = SelectPersonOperation.getOrgManager().getAccountById(userId);
            } else if (typeId == 6) {
                voe = SelectPersonOperation.getOrgManager().getDepartmentById(userId);
            } else if (typeId == 9 && (item = SelectPersonOperation.getEnumManagerNew().getCtpEnumItem(userId)) != null) {
                return item.getLabel();
            }
            if (voe != null) {
                return FormUtil.getOrgEntityName((V3xOrgEntity)voe, (OrgManager)SelectPersonOperation.getOrgManager());
            }
            return null;
        }
        return null;
    }

    public static Set<Long> getUserDomainIDs(int userType, Long userId) {
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"OrgManager");
        HashSet<Long> result = new HashSet<Long>();
        try {
            List l;
            if (userType == 0) {
                result.add(userId);
            } else if (userType == 1) {
                List l2 = SelectPersonOperation.getOrgManager().getUserDomainIDs(userId, V3xOrgEntity.VIRTUAL_ACCOUNT_ID, new String[]{"Department"});
                if (l2 != null) {
                    result.addAll(l2);
                }
            } else if (userType == 2) {
                List l3 = SelectPersonOperation.getOrgManager().getUserDomainIDs(userId, V3xOrgEntity.VIRTUAL_ACCOUNT_ID, new String[]{"Team"});
                if (l3 != null) {
                    result.addAll(l3);
                }
            } else if (userType == 3) {
                List l4 = SelectPersonOperation.getOrgManager().getUserDomainIDs(userId, V3xOrgEntity.VIRTUAL_ACCOUNT_ID, new String[]{"Level"});
                if (l4 != null) {
                    result.addAll(l4);
                }
            } else if (userType == 4) {
                List l5 = SelectPersonOperation.getOrgManager().getUserDomainIDs(userId, V3xOrgEntity.VIRTUAL_ACCOUNT_ID, new String[]{"Post"});
                if (l5 != null) {
                    result.addAll(l5);
                }
            } else if (userType == 5) {
                List l6 = SelectPersonOperation.getOrgManager().getUserDomainIDs(userId, V3xOrgEntity.VIRTUAL_ACCOUNT_ID, new String[]{"Account"});
                if (l6 != null) {
                    result.addAll(l6);
                }
            } else if (userType == 6) {
                List l7 = SelectPersonOperation.getOrgManager().getDepartmentsByUser(userId);
                if (l7 != null) {
                    for (V3xOrgDepartment dept : l7) {
                        result.add(dept.getId());
                    }
                }
            } else if (userType == 9 && (l = SelectPersonOperation.getOrgManager().getUserDomainIDs(userId, V3xOrgEntity.VIRTUAL_ACCOUNT_ID, new String[]{"JoinAccountTag"})) != null) {
                result.addAll(l);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

