/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.util;

import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.vo.FormTreeNode;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.util.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class TreeNodeUtil {
    private static TemplateManager templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");

    private TreeNodeUtil() {
    }

    public static void getTreeNode4Catg(Collection<CtpTemplateCategory> categories, FormTreeNode rootNode, Collection<FormTreeNode> nodes, String suffix) throws BusinessException {
        HashMap<String, CtpTemplateCategory> catgMap = new HashMap<String, CtpTemplateCategory>();
        for (CtpTemplateCategory category : categories) {
            catgMap.put(category.getName(), category);
        }
        TreeNodeUtil.getTreeNode4Catg(catgMap, rootNode, nodes, suffix, catgMap);
    }

    public static void getTreeNode4SortCatg(Map<String, CtpTemplateCategory> catgMap, FormTreeNode rootNode, Collection<FormTreeNode> nodes, String suffix, Map<String, CtpTemplateCategory> catgMapAll) throws BusinessException {
        ArrayList<FormTreeNode> catgNode = new ArrayList<FormTreeNode>();
        TreeNodeUtil.getTreeNode4Catg(catgMap, rootNode, catgNode, suffix, catgMapAll);
        Collections.sort(catgNode, TreeNodeComparator.getInstance());
        nodes.addAll(catgNode);
    }

    public static void getTreeNode4Catg(Map<String, CtpTemplateCategory> catgMap, FormTreeNode rootNode, Collection<FormTreeNode> nodes, String suffix, Map<String, CtpTemplateCategory> catgMapAll) throws BusinessException {
        HashMap<String, CtpTemplateCategory> tempMap = new HashMap<String, CtpTemplateCategory>();
        for (Map.Entry<String, CtpTemplateCategory> map : catgMap.entrySet()) {
            CtpTemplateCategory category = map.getValue();
            FormTreeNode node = new FormTreeNode();
            node.setId(category.getName() + suffix);
            if (!FormUtil.isBaseRootCatg((CtpTemplateCategory)category)) {
                CtpTemplateCategory parentCategory = templateManager.getCtpTemplateCategory(category.getParentId());
                if (parentCategory != null) {
                    if (!catgMapAll.containsKey(parentCategory.getName())) {
                        tempMap.put(parentCategory.getName(), parentCategory);
                    }
                    node.setParentId(parentCategory.getName() + suffix);
                } else {
                    node.setParentId(rootNode.getId());
                }
            } else {
                node.setParentId(rootNode.getId());
            }
            node.setSort(TreeNodeUtil.getSortStr(category.getSort(), category.getCreateDate() == null ? "1970-01-01 00:00" : DateUtil.formatDateTime((Date)category.getCreateDate()), 20));
            node.setName(category.getName());
            if (nodes.contains(node)) continue;
            nodes.add(node);
        }
        if (!tempMap.isEmpty()) {
            catgMapAll.putAll(tempMap);
            TreeNodeUtil.getTreeNode4Catg(tempMap, rootNode, nodes, suffix, catgMapAll);
        }
    }

    private static String getSortStr(int sort, String date, int maxLength) {
        String result = sort + date;
        if (result.length() < maxLength) {
            result = TreeNodeUtil.getStr(maxLength - result.length(), '0') + result;
        }
        return result;
    }

    private static String getStr(int length, char c) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = c;
        }
        return String.valueOf(chars);
    }

    public static class TreeNodeComparator
    implements Comparator<FormTreeNode> {
        private static TreeNodeComparator comparator = new TreeNodeComparator();

        private TreeNodeComparator() {
        }

        public static TreeNodeComparator getInstance() {
            return comparator;
        }

        @Override
        public int compare(FormTreeNode o1, FormTreeNode o2) {
            if (o1.getSort() == null || o2.getSort() == null) {
                return 0;
            }
            return o1.getSort().compareTo(o2.getSort());
        }
    }
}

