/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.interflow;

import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerBaseDesignInterface;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.interflow.utils.CapInterFlowRelationUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormBindAuthBean;
import com.seeyon.ctp.form.bean.FormBindBean;
import com.seeyon.ctp.form.bean.FormFieldBean;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.util.ReqUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.ModelAndView;

@CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
public class CapInterFlowController
extends BaseController {
    private static final Log LOGGER = CtpLogFactory.getLog(CapInterFlowController.class);
    private FormCacheManager formCacheManager;
    private TemplateManager templateManager;
    private CAP4FormCacheManager cap4FormCacheManager;

    public ModelAndView selectTemplate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result = new ModelAndView("cap4/form/interflow/triggerTemplate4CAP3");
        Long targetFormId = ReqUtil.getLong((HttpServletRequest)request, (String)"targetFormId");
        FormBean targetFormBean = this.formCacheManager.getForm(targetFormId.longValue());
        int formType = targetFormBean.getFormType();
        result.addObject("formType", (Object)formType);
        FormBindBean bindBean = targetFormBean.getBind();
        ArrayList<SimpleObjectBean> templateList = new ArrayList<SimpleObjectBean>();
        SimpleObjectBean soBean = null;
        if (formType == Enums.FormType.processesForm.getKey()) {
            List allTemplate = this.templateManager.getCtpTemplates(targetFormId.longValue(), false);
            for (CtpTemplate t : allTemplate) {
                soBean = new SimpleObjectBean();
                soBean.setId(t.getId());
                soBean.setName(t.getSubject());
                templateList.add(soBean);
            }
        } else {
            Map templates = bindBean.getUnFlowTemplateMap();
            for (Map.Entry entry : templates.entrySet()) {
                FormBindAuthBean authBean = (FormBindAuthBean)entry.getValue();
                soBean = new SimpleObjectBean();
                soBean.setId(authBean.getId());
                soBean.setName(authBean.getName());
                templateList.add(soBean);
            }
        }
        result.addObject("templateList", templateList);
        return result;
    }

    public ModelAndView batchSelectFields(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView model = new ModelAndView("cap4/form/interflow/selectFormField4CAP3");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L);
        String type = ReqUtil.getString((HttpServletRequest)request, (String)"type");
        FormBean fb = this.formCacheManager.getForm(formId.longValue());
        if (fb == null) {
            model.addObject("fieldList", Collections.emptyList());
        } else {
            model.addObject("fieldList", CapInterFlowRelationUtils.convertFields(fb, type, "relation".equals(type)));
        }
        return model;
    }

    public ModelAndView editTrigger2Cap3Form(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/form/businessTrigger/innerDesign2CAP3Form");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L);
        Long targetFormId = ReqUtil.getLong((HttpServletRequest)request, (String)"targetId", (long)0L);
        String type = ReqUtil.getString((HttpServletRequest)request, (String)"type", (String)"view");
        FormBean targetFormBean = this.formCacheManager.getForm(targetFormId.longValue());
        com.seeyon.cap4.form.bean.FormBean sourceFormBean = this.cap4FormCacheManager.getForm(formId);
        ArrayList<com.seeyon.cap4.form.bean.FormFieldBean> sourceFieldList = new ArrayList<com.seeyon.cap4.form.bean.FormFieldBean>();
        ArrayList<com.seeyon.cap4.form.bean.FormFieldBean> sourceConditionFieldList = new ArrayList<com.seeyon.cap4.form.bean.FormFieldBean>();
        FormTriggerUtil.filterMappingFields(sourceFormBean, sourceFieldList, sourceConditionFieldList);
        ArrayList<FormFieldBean> targetFormFieldList = new ArrayList<FormFieldBean>();
        ArrayList<FormFieldBean> targetConditionFieldList = new ArrayList<FormFieldBean>();
        CapInterFlowRelationUtils.filterCAP3MappingFields(targetFormBean, targetFormFieldList, targetConditionFieldList, "trigger");
        List<List<FormFieldBean>> uniqueFieldList = CapInterFlowRelationUtils.filterAndConvertUniqueFields(targetFormBean);
        mav.addObject("targetFormName", (Object)targetFormBean.getFormName());
        if (targetFormBean.getFormType() == Enums.FormType.processesForm.getKey()) {
            mav.addObject("targetFormType", (Object)1);
        } else {
            mav.addObject("targetFormType", (Object)6);
        }
        mav.addObject("hasUnique", (Object)Strings.isNotEmpty(uniqueFieldList));
        mav.addObject("uniqueFieldList", uniqueFieldList);
        mav.addObject("targetFieldList", targetFormFieldList);
        mav.addObject("targetConditionFieldList", targetConditionFieldList);
        mav.addObject("targetSourceType", (Object)MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType());
        Enums.FormType sourceType = Enums.FormType.getEnumByKey((int)sourceFormBean.getFormType());
        Enums.FormType targetType = null;
        Enums.FormType targetCap3Type = Enums.FormType.getEnumByKey((int)targetFormBean.getFormType());
        if (targetCap3Type != null) {
            switch (targetCap3Type) {
                case manageInfo: {
                    targetType = Enums.FormType.unFlowForm;
                    break;
                }
                case processesForm: {
                    targetType = Enums.FormType.processesForm;
                }
            }
        }
        ArrayList<FormTriggerBaseDesignInterface> actionList = new ArrayList<FormTriggerBaseDesignInterface>();
        List<FormTriggerBaseDesignInterface> actions = FormTriggerUtil.getDesignManagerList(sourceType, targetType, FormTriggerBean.TriggerBusinessType.Cap4To3InterFlow);
        for (FormTriggerBaseDesignInterface ftm : actions) {
            if (FormTriggerBean.TriggerType.Distribution.getKey().equals(ftm.getId())) continue;
            actionList.add(ftm);
        }
        mav.addObject("type", (Object)type);
        mav.addObject("sourceFormBean", (Object)sourceFormBean);
        mav.addObject("sourceFieldList", sourceFieldList);
        mav.addObject("sourceConditionFieldList", sourceConditionFieldList);
        mav.addObject("actionList", actionList);
        return mav;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    static enum InterFlowSourceType {
        FormBusiness("FormBusiness", "\u4e1a\u52a1\u751f\u6210\u5668", "capInterFlow.do?method=editTrigger2Business" + Functions.csrfSuffix()),
        CreateDataSrv("CreateDataSrv", "\u521b\u5efa\u6570\u636e\u670d\u52a1", "capInterFlow.do?method=editTrigger2OuterForm" + Functions.csrfSuffix()),
        CallDataInterface("CallDataInterface", "\u8c03\u7528\u6570\u636e\u63a5\u53e3", "capInterFlow.do?method=editTrigger2DataMagic" + Functions.csrfSuffix());

        private String key;
        private String i18n;
        private String url;

        private InterFlowSourceType(String key, String i18n, String url) {
            this.key = key;
            this.i18n = i18n;
            this.url = url;
        }

        public String getKey() {
            return this.key;
        }

        public String getI18n() {
            return this.i18n;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

