/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.interflow.utils;

import com.seeyon.cap4.form.modules.component.Left2RightVO;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormFieldBean;
import com.seeyon.ctp.form.bean.FormFieldComBean;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;

public class CapInterFlowRelationUtils {
    private static final Log LOGGER = CtpLogFactory.getLog(CapInterFlowRelationUtils.class);
    public static final FormFieldComBean.FormFieldComEnum[] filters = new FormFieldComBean.FormFieldComEnum[]{FormFieldComBean.FormFieldComEnum.HANDWRITE, FormFieldComBean.FormFieldComEnum.LINE_NUMBER, FormFieldComBean.FormFieldComEnum.BARCODE, FormFieldComBean.FormFieldComEnum.EXTEND_EXCHANGETASK, FormFieldComBean.FormFieldComEnum.EXTEND_QUERYTASK, FormFieldComBean.FormFieldComEnum.CUSTOM_CONTROL, FormFieldComBean.FormFieldComEnum.CUSTOM_PLAN, FormFieldComBean.FormFieldComEnum.PREPAREWRITE, FormFieldComBean.FormFieldComEnum.EXTEND_PROJECT, FormFieldComBean.FormFieldComEnum.LABLE};

    private CapInterFlowRelationUtils() {
    }

    public static List<Left2RightVO> convertFields(FormBean fb, String type, boolean valueNeedTableName) {
        LinkedList<FormFieldBean> fieldBeanList = new LinkedList<FormFieldBean>();
        CapInterFlowRelationUtils.filterCAP3MappingFields(fb, fieldBeanList, null, type);
        ArrayList<Left2RightVO> result = new ArrayList<Left2RightVO>(fieldBeanList.size());
        Left2RightVO item = null;
        for (FormFieldBean ffb : fieldBeanList) {
            item = new Left2RightVO();
            item.setFieldType(ffb.getFinalFieldType());
            item.setInputType(ffb.getFinalInputType());
            item.setName(ffb.getDisplay());
            if (!valueNeedTableName) {
                item.setValue(ffb.getName());
            } else {
                item.setValue(ffb.getOwnerTableName() + "." + ffb.getName());
            }
            item.setOwnerTable(ffb.getOwnerTableName());
            if (ffb.isMasterField()) {
                item.setOwnerTableDisplay(ffb.getOwnerTableName());
            } else {
                item.setOwnerTableDisplay(ResourceUtil.getString((String)"form.detail.table.label") + ffb.getOwnerTableIndex());
            }
            result.add(item);
        }
        return result;
    }

    public static List<List<FormFieldBean>> filterAndConvertUniqueFields(FormBean targetFormBean) {
        ArrayList<List<FormFieldBean>> uniqueFieldList = new ArrayList<List<FormFieldBean>>();
        List uniqueFields = targetFormBean.getUniqueFieldList();
        if (Strings.isNotEmpty((Collection)uniqueFields)) {
            try {
                HashSet<FormFieldComBean.FormFieldComEnum> filterStr = new HashSet<FormFieldComBean.FormFieldComEnum>(Arrays.asList(filters));
                filterStr.add(FormFieldComBean.FormFieldComEnum.FLOWDEALOPITION);
                filterStr.add(FormFieldComBean.FormFieldComEnum.MAP_LOCATE);
                filterStr.add(FormFieldComBean.FormFieldComEnum.MAP_PHOTO);
                for (List fields : uniqueFields) {
                    ArrayList<FormFieldBean> uniques = new ArrayList<FormFieldBean>();
                    for (String field : fields) {
                        FormFieldBean fieldBean = targetFormBean.getFieldBeanByName(field);
                        FormFieldBean fieldBeanClone = (FormFieldBean)fieldBean.clone();
                        String finalInputType = fieldBeanClone.getFinalInputType(true);
                        fieldBeanClone.setInputType(finalInputType);
                        FormFieldComBean.FormFieldComEnum finalInputEnum = FormFieldComBean.FormFieldComEnum.getEnumByKey((String)finalInputType);
                        if (filterStr.contains(finalInputEnum)) continue;
                        if (FormFieldComBean.FormFieldComEnum.SELECT.equals((Object)finalInputEnum) || FormFieldComBean.FormFieldComEnum.RADIO.equals((Object)finalInputEnum)) {
                            fieldBeanClone.setEnumId(fieldBeanClone.getFormatEnumId());
                            fieldBeanClone.setEnumLevel(fieldBeanClone.getFormatEnumLevel());
                            fieldBeanClone.setIsFinalChild(fieldBeanClone.isFormatEnumIsFinalChild());
                        }
                        uniques.add(fieldBeanClone);
                    }
                    uniqueFieldList.add(uniques);
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return uniqueFieldList;
    }

    public static void filterCAP3MappingFields(FormBean formBean, List<FormFieldBean> fieldList, List<FormFieldBean> conditionFieldList, String type) {
        HashSet<FormFieldComBean.FormFieldComEnum> outOrgField = new HashSet<FormFieldComBean.FormFieldComEnum>();
        outOrgField.add(FormFieldComBean.FormFieldComEnum.EXTEND_MEMBER);
        outOrgField.add(FormFieldComBean.FormFieldComEnum.EXTEND_MULTI_MEMBER);
        outOrgField.add(FormFieldComBean.FormFieldComEnum.EXTEND_DEPARTMENT);
        outOrgField.add(FormFieldComBean.FormFieldComEnum.EXTEND_MULTI_DEPARTMENT);
        outOrgField.add(FormFieldComBean.FormFieldComEnum.EXTEND_POST);
        outOrgField.add(FormFieldComBean.FormFieldComEnum.EXTEND_MULTI_POST);
        outOrgField.add(FormFieldComBean.FormFieldComEnum.EXTEND_LEVEL);
        outOrgField.add(FormFieldComBean.FormFieldComEnum.EXTEND_MULTI_LEVEL);
        outOrgField.add(FormFieldComBean.FormFieldComEnum.EXTEND_ACCOUNT);
        outOrgField.add(FormFieldComBean.FormFieldComEnum.EXTEND_MULTI_ACCOUNT);
        HashSet<FormFieldComBean.FormFieldComEnum> filterStr = new HashSet<FormFieldComBean.FormFieldComEnum>(Arrays.asList(filters));
        if ("trigger".equals(type) || Strings.isBlank((String)type)) {
            filterStr.add(FormFieldComBean.FormFieldComEnum.FLOWDEALOPITION);
            filterStr.add(FormFieldComBean.FormFieldComEnum.MAP_LOCATE);
            filterStr.add(FormFieldComBean.FormFieldComEnum.MAP_PHOTO);
        }
        List allFields = formBean.getAllFieldBeans();
        try {
            for (FormFieldBean field : allFields) {
                FormFieldComBean.FormFieldComEnum finalInputEnum;
                FormFieldComBean.FormFieldComEnum inputTypeEnum = field.getInputTypeEnum();
                try {
                    field = field.findRealFieldBean();
                }
                catch (BusinessException ex) {
                    LOGGER.warn((Object)(formBean.getId() + " " + field.getName() + "get realFieldBean failed  : " + ex.getLocalizedMessage()));
                    continue;
                }
                String finalInputType = field.getFinalInputType(true);
                if (finalInputType == null || FormFieldComBean.FormFieldComEnum.OUTWRITE.equals((Object)inputTypeEnum) && ("flowTitle".equals(field.getFormatType()) || field.getFieldType().equals(Enums.FieldType.LONGTEXT.getKey()) || !"trigger".equals(type) && Strings.isNotBlank((String)field.getFormatType()) && "multiattachment".equals(field.getFormatType())) || filterStr.contains(finalInputEnum = FormFieldComBean.FormFieldComEnum.getEnumByKey((String)finalInputType)) || outOrgField.contains(field.getInputTypeEnum()) && field.getExternalType() != 0) continue;
                FormFieldBean ffb = (FormFieldBean)field.clone();
                ffb.setInputType(finalInputType);
                if (FormFieldComBean.FormFieldComEnum.OUTWRITE.equals((Object)inputTypeEnum) && (FormFieldComBean.FormFieldComEnum.SELECT.equals((Object)finalInputEnum) || FormFieldComBean.FormFieldComEnum.RADIO.equals((Object)finalInputEnum))) {
                    ffb.setEnumId(ffb.getFormatEnumId());
                    ffb.setEnumLevel(ffb.getFormatEnumLevel());
                    ffb.setIsFinalChild(ffb.isFormatEnumIsFinalChild());
                }
                fieldList.add(ffb);
                if (conditionFieldList == null) continue;
                conditionFieldList.add(ffb);
            }
        }
        catch (CloneNotSupportedException e) {
            LOGGER.info((Object)e.getMessage(), (Throwable)e);
        }
    }
}

