/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.api;

import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.magic.api.MagicApi;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.ServiceInvokeInfo;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MagicApiImpl
implements MagicApi {
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private CAP4FormCacheManager cap4FormCacheManager;

    public ServiceInvokeInfo findInvokeServiceByBusinessId(String businessID) throws BusinessException {
        ServiceInvokeInfo r = new ServiceInvokeInfo();
        if (Strings.isNotBlank((String)businessID)) {
            ArrayList<String> ids = new ArrayList<String>(1);
            ids.add(businessID);
            List<MagicReflectionRelationPO> all = this.magicReflectionRelationDao.getReflectionByBids(ids);
            LinkedList<FormTriggerBean> triggerBeanList = new LinkedList<FormTriggerBean>();
            LinkedList<FormRelationshipBean> shipBeanList = new LinkedList<FormRelationshipBean>();
            for (MagicReflectionRelationPO a : all) {
                Long id = Long.parseLong(a.getCallingPoint().split("_")[0]);
                if (MagicEnums.BusinessMethodType.OUTERTRGGER.getType() == a.getCallingType()) {
                    FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(id);
                    if (triggerBean == null) continue;
                    triggerBeanList.add(triggerBean);
                    continue;
                }
                FormRelationshipBean ship = this.cap4FormCacheManager.getFormRelationshipBean(id);
                if (ship == null) continue;
                shipBeanList.add(ship);
            }
            r.setTriggerList(triggerBeanList);
            r.setRelationShipList(shipBeanList);
        }
        return r;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }
}

