/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business;

import com.seeyon.apps.cloudapp.api.MallApi;
import com.seeyon.apps.cloudapp.constant.MallEnum;
import com.seeyon.apps.cloudapp.po.CloudAppDatas;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.magic.business.IMagicAjaxHandleService;
import com.seeyon.cap4.magic.business.create.IMagicCreateService;
import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.business.importandexport.IMagicExportManager;
import com.seeyon.cap4.magic.business.importandexport.IMagicExternalExportManager;
import com.seeyon.cap4.magic.business.incision.IincisionSourceManager;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.execute.MagicProviderExecuteManager;
import com.seeyon.cap4.magic.initializer.CAP4MagicCacheInitializer;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.cap4.magic.vo.MagicFormFieldBean;
import com.seeyon.cap4.magic.vo.MagicFormTableBean;
import com.seeyon.cap4.magic.vo.MagicIncisionSource;
import com.seeyon.cap4.magic.vo.MagicServiceDetail;
import com.seeyon.cap4.magic.vo.ResponseMessage;
import com.seeyon.cap4.template.bo.CAPBusinessCustomCtrlBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.template.util.HttpClientUtil;
import com.seeyon.cap4.template.util.mall.MallUtil;
import com.seeyon.cap4.validity.ValidityUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.security.SecurityHelper;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDGenerator;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.base.MagicDisplay;
import com.seeyon.datamagic.engine.domain.mapping.MethodMappingConfig;
import com.seeyon.datamagic.engine.domain.metadata.MetadataConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import com.seeyon.datamagic.engine.out.service.OutService;
import com.seeyon.datamagic.engine.out.service.entry.OutServiceInfo;
import com.seeyon.datamagic.engine.out.service.entry.ServiceProvider;
import com.seeyon.datamagic.engine.out.service.entry.ServiceQueryCondition;
import com.seeyon.datamagic.engine.out.service.entry.ServiceSummary;
import com.seeyon.datamagic.engine.out.service.entry.ServicesCategoryTree;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.logging.Log;

public class MagicAjaxHandleServiceImpl
implements IMagicAjaxHandleService {
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private IMagicProviderDao magicProviderDao;
    private BusinessManager businessManager4;
    private ICAP4MagicManager cap4MagicManager;
    private OrgManager orgManager;
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private FormCacheManager formCacheManager;
    private FileManager fileManager;
    private IMagicExportManager magicExternalExportManager;
    private MagicProviderExecuteManager magicExternalExceuteManager;
    private MallApi mallApi;
    private static final String HANDLE_PERMISSION_LIST = "permissionList";
    private static final Log LOGGER = CtpLogFactory.getLog(MagicAjaxHandleServiceImpl.class);
    private static final String OTHER_CATEGORY = "123456";

    @Override
    @AjaxAccess
    public Map<String, Object> checkHandlePermission(Map<String, Object> params) throws BusinessException {
        String checkType = ParamUtil.getString(params, (String)"checkType", (String)"");
        Long interfaceId = ParamUtil.getLong(params, (String)"interfaceId", (Long)0L);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("ok", "1");
        if ("method".equals(checkType)) {
            List methodList = (List)params.get("methodList");
            HashMap usedList = new HashMap();
            MagicServiceSummary summary = this.magicServiceSummaryDao.loadServiceInfo(interfaceId);
            if (summary != null && !methodList.isEmpty()) {
                List<MagicInterfaceDefineEntity> allMethod = this.magicInterfaceDefineDao.loadAllEntitys(summary.getBusinessId(), summary.getBusinessVersion());
                HashMap<String, MagicInterfaceDefineEntity> methodMapper = new HashMap<String, MagicInterfaceDefineEntity>();
                for (MagicInterfaceDefineEntity e : allMethod) {
                    methodMapper.put(e.getMethodName(), e);
                }
                List<MagicReflectionRelationPO> reflectionRelationPOS = this.magicReflectionRelationDao.getReflectionByCallId(summary.getBusinessId(), summary.getBusinessVersion());
                HashMap<String, String> usedMethodNameMapper = new HashMap<String, String>();
                for (MagicReflectionRelationPO p : reflectionRelationPOS) {
                    ArrayList mmcList = new ArrayList();
                    JSONUtils.parseJSonListObj_Class(p.getMappingConfig(), mmcList, MethodMappingConfig.class);
                    for (MethodMappingConfig mmc : mmcList) {
                        usedMethodNameMapper.put(mmc.getMethodName(), mmc.getMethodName());
                    }
                }
                for (String m : methodList) {
                    if (!usedMethodNameMapper.containsKey(m) || !methodMapper.containsKey(m)) continue;
                    usedList.put(m, methodMapper.get(m));
                }
            }
            if (!usedList.isEmpty()) {
                result.put("ok", "0");
                ArrayList<String> error = new ArrayList<String>(usedList.size());
                for (MagicInterfaceDefineEntity e : usedList.values()) {
                    error.add(e.getName());
                }
                result.put("methodName", usedList.keySet());
                result.put("msg", ResourceUtil.getString((String)"cap.magic.tips.services.delete.error.invoke", (Object)Strings.join(error, (String)",")));
            }
        } else if ("services".equals(checkType)) {
            MagicServiceSummary summary = this.magicServiceSummaryDao.loadServiceInfo(interfaceId);
            List<String> permissionList = this.cap4MagicManager.checkHandlePermission(summary);
            if (permissionList.isEmpty()) {
                result.put("ok", "0");
                result.put("msg", ResourceUtil.getString((String)"cap.magic.tips.error2"));
            } else {
                result.put("ok", "1");
                result.put(HANDLE_PERMISSION_LIST, permissionList);
            }
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> createService(Map<String, Object> params) throws BusinessException, IOException, ZipException {
        String businessType = ParamUtil.getString(params, (String)"businessType", (String)"");
        IMagicCreateService createService = null;
        Map allCreateService = AppContext.getBeansOfType(IMagicCreateService.class);
        for (IMagicCreateService c : allCreateService.values()) {
            if (!businessType.equals(c.getBusinessType())) continue;
            createService = c;
            break;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (createService != null) {
            result.putAll(createService.createService(params));
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> createMagicMethod(Map<String, Object> baseInfo, Map<String, Object> methodInfo) throws BusinessException {
        String businessType = ParamUtil.getString(baseInfo, (String)"businessType", (String)"");
        IMagicCreateService createService = null;
        Map allCreateService = AppContext.getBeansOfType(IMagicCreateService.class);
        for (IMagicCreateService c : allCreateService.values()) {
            if (!businessType.equals(c.getBusinessType())) continue;
            createService = c;
            break;
        }
        if (createService != null) {
            return createService.createMethod(baseInfo, methodInfo);
        }
        return Collections.emptyMap();
    }

    @Override
    @AjaxAccess
    public Map<String, Object> createInternalImpl(Map<String, Object> serviceInfo, Map<String, Object> implSet) throws BusinessException {
        String businessType = ParamUtil.getString(serviceInfo, (String)"businessType", (String)"");
        IMagicCreateService createService = null;
        Map allCreateService = AppContext.getBeansOfType(IMagicCreateService.class);
        for (IMagicCreateService c : allCreateService.values()) {
            if (!businessType.equals(c.getBusinessType())) continue;
            createService = c;
            break;
        }
        if (createService != null) {
            return createService.createServiceImpl(serviceInfo, implSet);
        }
        return Collections.emptyMap();
    }

    @Override
    @AjaxAccess
    public List<Map<String, Object>> loadAllSupportBusinessMethod(Map<String, Object> params) throws BusinessException {
        String businessType = ParamUtil.getString(params, (String)"businessType", (String)"");
        MagicEnums.BusinessType bt = MagicEnums.BusinessType.valueOfType((String)businessType);
        if (bt == null) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        switch (bt) {
            case EXTERNAL_BUSINESS: {
                HashMap<String, String> s = new HashMap<String, String>();
                s.put("name", MagicEnums.BusinessMethodType.RELATION.getName());
                s.put("text", MagicEnums.BusinessMethodType.RELATION.getI18nText());
                result.add(s);
                s = new HashMap();
                s.put("name", MagicEnums.BusinessMethodType.OUTERTRGGER.getName());
                s.put("text", MagicEnums.BusinessMethodType.OUTERTRGGER.getI18nText());
                result.add(s);
                break;
            }
            case INTERNAL_BUSINESS: {
                Long formId = ParamUtil.getLong(params, (String)"formId", (Long)0L);
                String formType = ParamUtil.getString(params, (String)"formType", (String)MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType());
                MagicEnums.ServiceOwnerType sot = MagicEnums.ServiceOwnerType.getEnumByType((String)formType);
                MagicFormBean magicFormBean = new MagicFormBean(sot, formId);
                if (magicFormBean.isNull()) break;
                if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.equals((Object)magicFormBean.getType())) {
                    if (magicFormBean.isFlowForm()) {
                        HashMap<String, String> s = new HashMap<String, String>();
                        s.put("name", MagicEnums.BusinessMethodType.RELATION.getName());
                        s.put("text", MagicEnums.BusinessMethodType.RELATION.getI18nText());
                        result.add(s);
                        s = new HashMap();
                        s.put("name", MagicEnums.BusinessMethodType.TRIGGER_CREATE.getName());
                        s.put("text", ResourceUtil.getString((String)"form.businesstype.trigger.create.flow.label"));
                        result.add(s);
                        break;
                    }
                    HashMap<String, String> s = new HashMap<String, String>();
                    s.put("name", MagicEnums.BusinessMethodType.RELATION.getName());
                    s.put("text", MagicEnums.BusinessMethodType.RELATION.getI18nText());
                    result.add(s);
                    s = new HashMap();
                    s.put("name", MagicEnums.BusinessMethodType.TRIGGER_CREATE.getName());
                    s.put("text", MagicEnums.BusinessMethodType.TRIGGER_CREATE.getI18nText());
                    result.add(s);
                    s = new HashMap();
                    s.put("name", MagicEnums.BusinessMethodType.TRIGGER_UPDATE.getName());
                    s.put("text", MagicEnums.BusinessMethodType.TRIGGER_UPDATE.getI18nText());
                    result.add(s);
                    s = new HashMap();
                    s.put("name", MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE.getName());
                    s.put("text", MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE.getI18nText());
                    result.add(s);
                    break;
                }
                if (!MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.equals((Object)magicFormBean.getType())) break;
                if (magicFormBean.isFlowForm()) {
                    HashMap<String, String> s = new HashMap<String, String>();
                    s.put("name", MagicEnums.BusinessMethodType.TRIGGER_CREATE.getName());
                    s.put("text", ResourceUtil.getString((String)"form.businesstype.trigger.create.flow.label"));
                    result.add(s);
                    break;
                }
                HashMap<String, String> s = new HashMap<String, String>();
                s.put("name", MagicEnums.BusinessMethodType.TRIGGER_CREATE.getName());
                s.put("text", MagicEnums.BusinessMethodType.TRIGGER_CREATE.getI18nText());
                result.add(s);
                s = new HashMap();
                s.put("name", MagicEnums.BusinessMethodType.TRIGGER_UPDATE.getName());
                s.put("text", MagicEnums.BusinessMethodType.TRIGGER_UPDATE.getI18nText());
                result.add(s);
            }
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> showServiceInfo(Map<String, Object> params) throws BusinessException {
        Long id = ParamUtil.getLong(params, (String)"interfaceId", (Long)0L);
        MagicServiceSummary summary = this.magicServiceSummaryDao.loadServiceInfo(id);
        if (summary == null) {
            return Collections.emptyMap();
        }
        IMagicCreateService createService = null;
        Map allCreateService = AppContext.getBeansOfType(IMagicCreateService.class);
        for (IMagicCreateService c : allCreateService.values()) {
            if (Strings.isBlank((String)summary.getBusinessType()) && MagicEnums.BusinessType.EXTERNAL_BUSINESS.getKey().equalsIgnoreCase(c.getBusinessType())) {
                createService = c;
                break;
            }
            if (!c.getBusinessType().equals(summary.getBusinessType())) continue;
            createService = c;
            break;
        }
        if (createService != null) {
            return createService.showServiceInfo(summary);
        }
        return Collections.emptyMap();
    }

    @Override
    @AjaxAccess
    public Map<String, Object> switchMagicImpl(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", "0");
        long id = ParamUtil.getLong(params, (String)"serviceId", (Long)0L);
        long providerId = ParamUtil.getLong(params, (String)"providerId", (Long)0L);
        MagicServiceSummary entity = this.magicServiceSummaryDao.loadServiceInfo(id);
        if (entity != null) {
            this.magicProviderDao.switchProvider(entity.getBusinessId(), entity.getBusinessVersion(), providerId);
            result.put("success", "1");
            result.put("msg", ResourceUtil.getString((String)"cap.magic.tips.bind.success"));
        } else {
            result.put("msg", ResourceUtil.getString((String)"cap.magic.service.null"));
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> deleteServiceImpl(List<String> ids) throws BusinessException {
        if (ids != null && !ids.isEmpty()) {
            ArrayList<MagicServiceProviderPO> providers = new ArrayList<MagicServiceProviderPO>();
            for (String id : ids) {
                MagicServiceProviderPO p = this.getMagicProviderDao().getById(Long.parseLong(id));
                if (p == null) continue;
                providers.add(p);
            }
            this.getMagicProviderDao().deleteProvides(providers);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", "1");
        result.put("msg", ResourceUtil.getString((String)"cap.formDesign.ctrlArea.ds.delOk"));
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> deleteService(List<String> ids) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ids != null && !ids.isEmpty()) {
            ArrayList<MagicServiceSummary> allEntity = new ArrayList<MagicServiceSummary>();
            HashMap<Long, MagicInterfaceDefineEntity> needDeleteMethods = new HashMap<Long, MagicInterfaceDefineEntity>();
            ArrayList<String> businessIds = new ArrayList<String>();
            for (String id : ids) {
                try {
                    long i = Long.parseLong(id);
                    MagicServiceSummary entity = this.magicServiceSummaryDao.loadServiceInfo(i);
                    if (entity == null) continue;
                    businessIds.add(entity.getBusinessId());
                    allEntity.add(entity);
                }
                catch (Exception e) {
                    LOGGER.info((Object)e.getMessage());
                }
            }
            List<MagicReflectionRelationPO> reflactions = this.magicReflectionRelationDao.getReflectionByBids(businessIds);
            HashMap<String, Integer> invokeCount = new HashMap<String, Integer>();
            for (MagicReflectionRelationPO r : reflactions) {
                com.seeyon.cap4.form.bean.FormBean formBean;
                String cbid = r.getCalleeBusinessId();
                String cbversion = r.getCalleeVersionId();
                String tempKey = (String)cbid + "_" + cbversion;
                Integer count = (Integer)invokeCount.get(tempKey);
                if (count == null) {
                    count = 0;
                }
                if ((formBean = this.cap4FormCacheManager.getForm(r.getFormId())) != null) {
                    count = count + MagicCreateServiceUtils.invokeStatistics(r);
                }
                invokeCount.put(tempKey, count);
            }
            ArrayList<MagicServiceSummary> canDelelte = new ArrayList<MagicServiceSummary>();
            ArrayList<MagicServiceSummary> notDelelte = new ArrayList<MagicServiceSummary>();
            for (MagicServiceSummary e : allEntity) {
                Integer count = (Integer)invokeCount.get(e.getBusinessId() + "_" + e.getBusinessVersion());
                if (count == null || count == 0) {
                    canDelelte.add(e);
                    List<MagicInterfaceDefineEntity> thisBusinessMethods = this.magicInterfaceDefineDao.loadAllEntitys(e.getBusinessId(), e.getBusinessVersion());
                    if (thisBusinessMethods != null) {
                        for (MagicInterfaceDefineEntity entity : thisBusinessMethods) {
                            needDeleteMethods.put(entity.getId(), entity);
                        }
                    }
                    this.magicProviderDao.deleteProvides(e.getBusinessId(), e.getBusinessVersion());
                    continue;
                }
                notDelelte.add(e);
            }
            this.magicServiceSummaryDao.deleteAll(canDelelte);
            ArrayList<MagicInterfaceDefineEntity> deleteMethod = new ArrayList<MagicInterfaceDefineEntity>(needDeleteMethods.size());
            deleteMethod.addAll(needDeleteMethods.values());
            this.magicInterfaceDefineDao.delete(deleteMethod);
            if (!notDelelte.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>(notDelelte.size());
                for (MagicServiceSummary es : notDelelte) {
                    names.add(es.getNameDisplay());
                }
                result.put("msg", ResourceUtil.getString((String)"cap.magic.tips.services.delete.error.invoke", (Object)Strings.join(names, (String)",")));
            } else {
                result.put("msg", ResourceUtil.getString((String)"cap.template.unflow.deleteSuccessful"));
                result.put("success", "1");
            }
        }
        return result;
    }

    @Override
    @AjaxAccess
    public FlipInfo loadAllProviderServices(FlipInfo info, Map<String, Object> params) throws BusinessException {
        Long bizId;
        BizConfigBean bcb;
        HashMap<String, Object> condition = new HashMap<String, Object>();
        String name = ParamUtil.getString(params, (String)"name", (String)"");
        String type = ParamUtil.getString(params, (String)"searchType", (String)"name");
        if (Strings.isNotBlank((String)name) && "name".equals(type)) {
            condition.put("name", name);
        }
        if ((bcb = this.businessManager4.findBizConfigById(bizId = ParamUtil.getLong(params, (String)"bizConfig", (Long)0L))) == null) {
            info.setTotal(0);
            info.setData(Collections.emptyList());
            return info;
        }
        List<com.seeyon.cap4.form.bean.FormBean> allFormBean = this.businessManager4.getFormBeanListByBizId(bizId);
        ArrayList<String> ownerId = new ArrayList<String>(allFormBean.size());
        for (com.seeyon.cap4.form.bean.FormBean fb : allFormBean) {
            ownerId.add(String.valueOf(fb.getId()));
        }
        ownerId.add(String.valueOf(bizId));
        condition.put("ownerId", ownerId);
        List<MagicServiceSummary> serviceSummaries = this.magicServiceSummaryDao.findServices(condition, info);
        ArrayList resultData = new ArrayList(serviceSummaries.size());
        HashMap<String, Object> item = null;
        for (MagicServiceSummary s : serviceSummaries) {
            item = new HashMap<String, Object>();
            MagicServiceProviderPO onProviders = this.magicProviderDao.loadProviders(s.getBusinessId(), s.getBusinessVersion(), MagicEnums.ProviderStatus.ON);
            if (onProviders != null) {
                item.put("implInfo", onProviders.getDisplayName());
            }
            item.put("bizName", bcb.getName());
            int invokeCount = this.invokeStatistics(s.getBusinessId(), s.getBusinessVersion());
            item.put("invokeCount", invokeCount);
            item.put("id", String.valueOf(s.getId()));
            item.put("name", s.getNameDisplay());
            item.put("certificateType", MagicEnums.CertificateType.getEnumByKey((int)s.getCertificateType()).getI18nText());
            item.put("createDate", s.getCreateDate());
            item.put("modifyDate", s.getModifyDate());
            if (s.getCreateId() != null) {
                V3xOrgMember createMember = this.orgManager.getMemberById(s.getCreateId());
                if (createMember != null) {
                    item.put("createrName", createMember.getName());
                } else {
                    item.put("createrName", "");
                }
            } else {
                item.put("createrName", "");
            }
            item.put("status", bcb.isPublishedConfig() ? ResourceUtil.getString((String)"cap4.form.business.release") : ResourceUtil.getString((String)"form.mgr.state.unpublished.lable"));
            resultData.add(item);
        }
        info.setData(resultData);
        return info;
    }

    private int invokeStatistics(String bid, String verision) throws BusinessException {
        int invokeCount = 0;
        for (MagicReflectionRelationPO p : this.magicReflectionRelationDao.getReflectionByCallId(bid, verision)) {
            com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(p.getFormId());
            if (formBean == null) continue;
            invokeCount += MagicCreateServiceUtils.invokeStatistics(p);
        }
        return invokeCount;
    }

    @Override
    @AjaxAccess
    public FlipInfo loadInvokeInfoByServiceId(FlipInfo info, Map<String, Object> params) throws BusinessException {
        Long id = ParamUtil.getLong(params, (String)"id", (Long)0L);
        MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(id);
        if (serviceSummary != null) {
            HashMap<String, MagicInterfaceDefineEntity> interfaceMapper = new HashMap<String, MagicInterfaceDefineEntity>();
            for (MagicInterfaceDefineEntity e : this.magicInterfaceDefineDao.loadAllEntitys(serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion())) {
                interfaceMapper.put(e.getBusinessId() + "_" + e.getVersionId() + "_" + e.getMethodName(), e);
            }
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            List<MagicReflectionRelationPO> allReflection = this.magicReflectionRelationDao.getReflectionByCallId(serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion());
            for (MagicReflectionRelationPO p : allReflection) {
                Map<String, Object> item = this.showInvokeItem(p, serviceSummary, interfaceMapper);
                if (item.isEmpty()) continue;
                BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(p.getFormId());
                if (bizConfigBean != null) {
                    item.put("bizName", bizConfigBean.getName());
                    item.put("creater", bizConfigBean.getOwnerName());
                }
                data.add(item);
            }
            info.setData(data);
            info.setTotal(data.size());
        }
        return info;
    }

    private Map<String, Object> showInvokeItem(MagicReflectionRelationPO p, MagicServiceSummary serviceSummary, Map<String, MagicInterfaceDefineEntity> interfaceMapper) throws BusinessException {
        com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(p.getFormId());
        HashMap<String, Object> item = new HashMap<String, Object>();
        MagicEnums.BusinessMethodType methodType = MagicEnums.BusinessMethodType.valueOfType((int)p.getCallingType());
        if (methodType == null || methodType.equals((Object)MagicEnums.BusinessMethodType.QUERY) || methodType.equals((Object)MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK)) {
            return item;
        }
        ArrayList mappingConfigs = new ArrayList();
        JSONUtils.parseJSonListObj_Class(p.getMappingConfig(), mappingConfigs, MethodMappingConfig.class);
        for (MethodMappingConfig e : mappingConfigs) {
            MagicInterfaceDefineEntity invokeMethod = interfaceMapper.get(p.getCalleeBusinessId() + "_" + p.getCalleeVersionId() + "_" + e.getMethodName());
            if (invokeMethod == null || invokeMethod.getServiceType() == MagicEnums.BusinessMethodType.QUERY.getType() || invokeMethod.getServiceType() == MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK.getType()) continue;
            item.put("methodName", invokeMethod.getName());
            break;
        }
        switch (methodType) {
            case RELATION: 
            case RELATION_USER: 
            case RELATION_SYS: {
                FormRelationshipBean ship = this.cap4FormCacheManager.getFormRelationshipBean(Long.parseLong(p.getCallingPoint().split("_")[0]));
                if (ship == null) {
                    item.clear();
                    return item;
                }
                item.put("relationType", ResourceUtil.getString((String)"form.businesstype.type.relation"));
                item.put("relationName", ship.getName());
                break;
            }
            case TRIGGER_CREATE: 
            case TRIGGER_UPDATE: 
            case TRIGGER_DISTRIBUTE: 
            case OUTERTRGGER: {
                FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(Long.parseLong(p.getCallingPoint().split("_")[0]));
                if (triggerBean == null) {
                    item.clear();
                    return item;
                }
                item.put("relationType", ResourceUtil.getString((String)"form.businesstype.type.trigger"));
                item.put("relationName", triggerBean.getName());
            }
        }
        item.put("name", serviceSummary.getNameDisplay());
        if (formBean == null) {
            item.put("formName", "");
        } else {
            item.put("formName", formBean.getFormName());
        }
        item.put("createDate", serviceSummary.getCreateDate());
        item.put("id", String.valueOf(serviceSummary.getId()));
        V3xOrgMember create = this.orgManager.getMemberById(serviceSummary.getCreateId());
        if (create != null) {
            item.put("creater", create.getName());
        }
        return item;
    }

    @Override
    @AjaxAccess
    public FlipInfo loadAllInvokeServices(FlipInfo info, Map<String, Object> params) throws BusinessException {
        List<MagicServiceSummary> allService;
        Long bizId = ParamUtil.getLong(params, (String)"bizConfig", (Long)0L);
        Map node = new HashMap();
        if (params.containsKey("node")) {
            node = (Map)params.get("node");
        }
        String rootId = OTHER_CATEGORY;
        String id = ParamUtil.getString(node, (String)"id", (String)rootId);
        String pId = ParamUtil.getString(node, (String)"pId", (String)"");
        boolean isRoot = false;
        if (rootId.equals(id)) {
            isRoot = true;
        }
        String name = ParamUtil.getString(params, (String)"condition", (String)"");
        String conditionType = ParamUtil.getString(params, (String)"type", (String)"");
        String certificateType = ParamUtil.getString(params, (String)"certificateType", (String)"");
        if ("name".equals(conditionType)) {
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getLocalizedMessage());
            }
        }
        List<com.seeyon.cap4.form.bean.FormBean> allFormBeans = this.businessManager4.getFormBeanListByBizId(bizId);
        BizConfigBean currentBiz = this.businessManager4.findBizConfigById(bizId);
        LinkedList<String> collPoint = new LinkedList<String>();
        for (com.seeyon.cap4.form.bean.FormBean fb : allFormBeans) {
            Object shipIdList = fb.getFormRelationshipIdList();
            Iterator iterator = shipIdList.iterator();
            while (iterator.hasNext()) {
                Long ship = (Long)iterator.next();
                FormRelationshipBean relation = this.cap4FormCacheManager.getFormRelationshipBean(ship);
                if (relation == null || !FormRelationEnums.relationApplicationType.inner.getKey().equals(relation.getApplicationType()) || FormRelationEnums.RelationObjType.RELATION_CURRENT_FORM.getKey().equals(relation.getRelationObjType())) continue;
                for (Object shipMap : relation.getRelationMapList()) {
                    if (relation.getRelationType() == 1) {
                        collPoint.add(relation.getId() + "_" + shipMap.getSelectedField());
                        continue;
                    }
                    if (relation.getRelationType() == 2) {
                        collPoint.add(relation.getId() + "_" + shipMap.getConditionFormulaId());
                        continue;
                    }
                    if (relation.getRelationType() != FormRelationEnums.ViewSelectType.auto_increase_row.getKey()) continue;
                    collPoint.add(relation.getId() + "_" + FormRelationEnums.ViewSelectType.auto_increase_row.name());
                }
            }
            shipIdList = fb.getFormTriggerIdList();
            iterator = shipIdList.iterator();
            while (iterator.hasNext()) {
                Object shipMap;
                Long trigger = (Long)iterator.next();
                FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(trigger);
                BizConfigBean thisBiz = this.businessManager4.findBizConfigByFormId(triggerBean.getSourceFormId());
                if (thisBiz == null || currentBiz == null || !currentBiz.getId().equals(thisBiz.getId()) || (triggerBean == null || !FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(triggerBean.getType())) && !FormTriggerBean.TriggerBusinessType.DataInterface.getKey().equals(triggerBean.getType())) continue;
                shipMap = triggerBean.getActionList().iterator();
                while (shipMap.hasNext()) {
                    FormTriggerActionBean action = (FormTriggerActionBean)shipMap.next();
                    collPoint.add(triggerBean.getId() + "_" + action.getId());
                }
            }
        }
        List<MagicReflectionRelationPO> invokeList = this.magicReflectionRelationDao.getReflectionByCallPoints(collPoint);
        ArrayList<String> callBusinessIds = new ArrayList<String>();
        for (MagicReflectionRelationPO p : invokeList) {
            if (p.getCallingType() == MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK.getType()) continue;
            callBusinessIds.add(p.getCalleeBusinessId());
        }
        if (Strings.isBlank((String)name)) {
            allService = this.magicServiceSummaryDao.searchServicesByBusiness(callBusinessIds);
        } else if ("name".equals(conditionType)) {
            allService = this.magicServiceSummaryDao.searchServicesByName(callBusinessIds, name);
        } else if ("creater".equals(conditionType)) {
            List allMember = this.orgManager.getAllMembers(Long.valueOf(AppContext.currentAccountId()));
            LinkedList<Long> ids = new LinkedList<Long>();
            for (Object m : allMember) {
                if (!m.getName().contains(name)) continue;
                ids.add(m.getId());
            }
            allService = this.magicServiceSummaryDao.searchServicesByCreater(callBusinessIds, ids);
        } else {
            return info;
        }
        HashMap<String, MagicServiceSummary> allServicemapper = new HashMap<String, MagicServiceSummary>();
        ArrayList<MagicEnums.BusinessMethodType> serviceType = new ArrayList<MagicEnums.BusinessMethodType>();
        serviceType.add(MagicEnums.BusinessMethodType.RELATION_USER);
        serviceType.add(MagicEnums.BusinessMethodType.RELATION);
        serviceType.add(MagicEnums.BusinessMethodType.RELATION_SYS);
        serviceType.add(MagicEnums.BusinessMethodType.TRIGGER_CREATE);
        serviceType.add(MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE);
        serviceType.add(MagicEnums.BusinessMethodType.TRIGGER_UPDATE);
        serviceType.add(MagicEnums.BusinessMethodType.OUTERTRGGER);
        HashMap<String, MagicInterfaceDefineEntity> interfaceMapper = new HashMap<String, MagicInterfaceDefineEntity>();
        for (MagicInterfaceDefineEntity e : this.magicInterfaceDefineDao.loadDefines(serviceType, callBusinessIds, null)) {
            interfaceMapper.put(e.getBusinessId() + "_" + e.getVersionId() + "_" + e.getMethodName(), e);
        }
        for (MagicServiceSummary s : allService) {
            if (s.getCertificateType() == null) continue;
            if (MagicEnums.CertificateType.Public_certificate.getName().equals(certificateType) && s.getCertificateType().equals(MagicEnums.CertificateType.Public_certificate.getKey())) {
                allServicemapper.put(s.getBusinessId() + "_" + s.getBusinessVersion(), s);
                continue;
            }
            if (MagicEnums.CertificateType.Private_certificate.getName().equals(certificateType) && s.getCertificateType().equals(MagicEnums.CertificateType.Private_certificate.getKey())) {
                allServicemapper.put(s.getBusinessId() + "_" + s.getBusinessVersion(), s);
                continue;
            }
            allServicemapper.put(s.getBusinessId() + "_" + s.getBusinessVersion(), s);
        }
        ArrayList<Map<String, Object>> resultData = new ArrayList<Map<String, Object>>(invokeList.size());
        Map<String, Object> item = null;
        for (MagicReflectionRelationPO p : invokeList) {
            MagicEnums.BusinessMethodType methodType;
            BizConfigBean bizConfigBean;
            MagicEnums.ServiceOwnerType sot;
            MagicFormBean fb;
            BizConfigBean bbc;
            com.seeyon.cap4.form.bean.FormBean fb2;
            MagicServiceSummary ss;
            com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(p.getFormId());
            if (formBean == null || (ss = (MagicServiceSummary)allServicemapper.get(p.getCalleeBusinessId() + "_" + p.getCalleeVersionId())) == null || (!"other".equals(id) ? !isRoot && Strings.isNotBlank((String)id) && (!MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType().equals(ss.getOwnerType()) ? (!MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(ss.getOwnerType()) ? !id.equals(ss.getOwnerType()) : (fb2 = this.cap4FormCacheManager.getForm(Long.parseLong(MagicPrivateUtils.isNumeric(ss.getOwner()) ? ss.getOwner() : "0"))) == null || (bbc = this.businessManager4.findBizConfigByFormId(fb2.getId())) == null || !id.equals(String.valueOf(bbc.getId()))) : !MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType().equals(id) && !ss.getOwnerType().equals(id)) : !MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(ss.getOwnerType()) && !MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(ss.getOwnerType()) || MagicPrivateUtils.isNumeric(ss.getOwner()) && !(fb = new MagicFormBean(sot = MagicEnums.ServiceOwnerType.getEnumByType((String)ss.getOwnerType()), Long.parseLong(ss.getOwner()))).isNull())) continue;
            if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(id) && Strings.isNotBlank((String)id) && MagicPrivateUtils.isNumeric(ss.getOwner()) && (bizConfigBean = this.businessManager4.findBizConfigByFormId(Long.parseLong(ss.getOwner()))) != null && !id.equals(String.valueOf(bizConfigBean.getId())) || (methodType = MagicEnums.BusinessMethodType.valueOfType((int)p.getCallingType())) == null || methodType.equals((Object)MagicEnums.BusinessMethodType.QUERY) || methodType.equals((Object)MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK)) continue;
            ArrayList mappingConfigs = new ArrayList();
            JSONUtils.parseJSonListObj_Class(p.getMappingConfig(), mappingConfigs, MethodMappingConfig.class);
            item = this.showInvokeItem(p, ss, interfaceMapper);
            if (item.isEmpty()) continue;
            resultData.add(item);
        }
        info.setData(resultData);
        return this.setFlipInfo(resultData, info);
    }

    private <T> FlipInfo setFlipInfo(List<T> data, FlipInfo info) {
        if (info == null) {
            info = new FlipInfo(1, 20);
        }
        if (data == null || data.isEmpty()) {
            info.setTotal(0);
            info.setPage(1);
            info.setData(Collections.emptyList());
            return info;
        }
        int dataSize = data.size();
        int size = info.getSize();
        int page = info.getPage();
        int formIndex = 0;
        int endIndex = 0;
        List pageData = Collections.emptyList();
        if (page > 0) {
            formIndex = size * (page - 1);
            endIndex = size * page;
            if (formIndex > dataSize) {
                page = 1;
                formIndex = size * (page - 1);
                endIndex = size * page;
                info.setPage(1);
            }
            if (endIndex > dataSize) {
                endIndex = dataSize;
            }
            pageData = data.subList(formIndex, endIndex);
        }
        info.setTotal(data.size());
        info.setData(pageData);
        return info;
    }

    @Override
    @AjaxAccess
    public List<Map<String, Object>> loadInvokeServiceCategory(Map<String, Object> params) throws BusinessException {
        Long bizId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        List<com.seeyon.cap4.form.bean.FormBean> allFormBean = this.businessManager4.getFormBeanListByBizId(bizId);
        LinkedHashMap resultTree = new LinkedHashMap();
        HashMap<String, String> treeItem = new HashMap<String, String>();
        treeItem.put("id", OTHER_CATEGORY);
        treeItem.put("name", ResourceUtil.getString((String)"cap.magic.outer.interface.label"));
        treeItem.put("iconSkin", "treeCustomMenu");
        resultTree.put(OTHER_CATEGORY, treeItem);
        LinkedList<Map<String, Object>> datas = new LinkedList<Map<String, Object>>();
        if (allFormBean == null || allFormBean.isEmpty()) {
            datas.add(treeItem);
            return datas;
        }
        ArrayList<Long> formIdList = new ArrayList<Long>(allFormBean.size());
        for (com.seeyon.cap4.form.bean.FormBean fb : allFormBean) {
            formIdList.add(fb.getId());
        }
        List<MagicReflectionRelationPO> allRelations = this.magicReflectionRelationDao.getReflectionByFormIdList(formIdList);
        HashMap<String, MagicServiceSummary> result = new HashMap<String, MagicServiceSummary>();
        LinkedList<BizConfigBean> existsCap4Biz = new LinkedList<BizConfigBean>();
        boolean existsOther = false;
        HashMap<MagicEnums.ServiceOwnerType, Boolean> exists = new HashMap<MagicEnums.ServiceOwnerType, Boolean>();
        for (MagicReflectionRelationPO magicReflectionRelationPO : allRelations) {
            MagicServiceSummary serviceSummary;
            String k;
            int invokeSt = MagicCreateServiceUtils.invokeStatistics(magicReflectionRelationPO);
            if (invokeSt < 1 || result.get(k = magicReflectionRelationPO.getCalleeBusinessId() + "_" + magicReflectionRelationPO.getCalleeVersionId()) != null || (serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(magicReflectionRelationPO.getCalleeBusinessId(), magicReflectionRelationPO.getCalleeVersionId())) == null) continue;
            result.put(k, serviceSummary);
        }
        for (MagicServiceSummary magicServiceSummary : result.values()) {
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(magicServiceSummary.getOwnerType())) {
                BizConfigBean bizConfig = this.businessManager4.findBizConfigByFormId(Long.valueOf(Strings.isBlank((String)magicServiceSummary.getOwner()) ? "0" : magicServiceSummary.getOwner()));
                if (bizConfig != null) {
                    existsCap4Biz.add(bizConfig);
                    continue;
                }
                existsOther = true;
                continue;
            }
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(magicServiceSummary.getOwnerType())) {
                exists.put(MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3, true);
                continue;
            }
            if (MagicEnums.ProviderType.DEFAULT_DEE.getType().equals(magicServiceSummary.getOwnerType())) {
                exists.put(MagicEnums.ServiceOwnerType.DEFAULT_DEE, true);
                continue;
            }
            MagicEnums.ServiceOwnerType ss = MagicEnums.ServiceOwnerType.getEnumByType((String)magicServiceSummary.getOwnerType());
            if (ss == null) continue;
            exists.put(ss, true);
        }
        for (BizConfigBean bizConfigBean : existsCap4Biz) {
            treeItem = new HashMap();
            treeItem.put("pId", OTHER_CATEGORY);
            treeItem.put("name", bizConfigBean.getName());
            treeItem.put("id", String.valueOf(bizConfigBean.getId()));
            treeItem.put("canSelect", "1");
            treeItem.put("type", MagicEnums.ProviderType.DEFAULT_FORM.getType());
            resultTree.put(String.valueOf(bizConfigBean.getId()), treeItem);
        }
        for (Map.Entry entry : exists.entrySet()) {
            treeItem = new HashMap();
            treeItem.put("pId", OTHER_CATEGORY);
            if (((MagicEnums.ServiceOwnerType)entry.getKey()).equals((Object)MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3)) {
                treeItem.put("name", ResourceUtil.getString((String)"cap4.form.business.businessset") + "/" + ResourceUtil.getString((String)"form.bizconfig.link.label.form"));
            } else if (((MagicEnums.ServiceOwnerType)entry.getKey()).equals((Object)MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL)) {
                treeItem.put("name", MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getI18nText());
            } else {
                treeItem.put("name", ((MagicEnums.ServiceOwnerType)entry.getKey()).getI18nText());
            }
            treeItem.put("id", ((MagicEnums.ServiceOwnerType)entry.getKey()).getType());
            treeItem.put("canSelect", "1");
            treeItem.put("type", ((MagicEnums.ServiceOwnerType)entry.getKey()).getType());
            resultTree.put(((MagicEnums.ServiceOwnerType)entry.getKey()).getType(), treeItem);
        }
        if (existsOther) {
            treeItem = new HashMap();
            treeItem.put("pId", OTHER_CATEGORY);
            treeItem.put("name", ResourceUtil.getString((String)"com.cap.businessrelation.condition.other.label"));
            treeItem.put("id", "other");
            treeItem.put("canSelect", "1");
            treeItem.put("type", "other");
            resultTree.put("other", treeItem);
        }
        datas.addAll(resultTree.values());
        return datas;
    }

    @Override
    @AjaxAccess
    public List<Map<String, Object>> showProvidersSummarys(MagicServiceSummary entity) throws BusinessException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<MagicServiceProviderPO> providers = this.magicProviderDao.loadProviders(entity.getBusinessId(), entity.getBusinessVersion());
        if (providers != null && !providers.isEmpty()) {
            MagicEnums.ServiceOwnerType serviceOwnerType = MagicEnums.ServiceOwnerType.getEnumByType((String)entity.getOwnerType());
            for (MagicServiceProviderPO p : providers) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("id", String.valueOf(p.getId()));
                data.put("name", entity.getNameDisplay());
                data.put("implName", p.getDisplayName());
                if (serviceOwnerType != null) {
                    switch (serviceOwnerType) {
                        case DEFAULT_FORM: {
                            data.put("type", ResourceUtil.getString((String)"cap4.form.business.form"));
                            com.seeyon.cap4.form.bean.FormBean fb = this.cap4FormCacheManager.getForm(Long.parseLong(p.getSource()));
                            if (fb != null) {
                                data.put("provider", "CAP." + fb.getFormName());
                                break;
                            }
                            data.put("provider", "-");
                            break;
                        }
                        case DEFAULT_FORM_CAP3: {
                            FormBean fbs = this.formCacheManager.getForm(Long.parseLong(p.getSource()));
                            if (fbs != null) {
                                data.put("provider", "CAP." + fbs.getFormName());
                            } else {
                                data.put("provider", "-");
                            }
                            data.put("type", ResourceUtil.getString((String)"cap4.form.business.form"));
                            break;
                        }
                        case DEFAULT_EXTERNAL: 
                        case DEFAULT_CAP4_BIZ: {
                            data.put("type", serviceOwnerType.getI18nText());
                            data.put("provider", p.getSource());
                            break;
                        }
                        case DEFAULT_REPORT: 
                        case DEFAULT_DEE: {
                            data.put("type", serviceOwnerType.getI18nText());
                            data.put("provider", "-");
                        }
                    }
                }
                if (MagicEnums.ProviderStatus.ON.getType() == p.getStatus()) {
                    data.put("status", ResourceUtil.getString((String)"cap4.form.business.enable"));
                } else {
                    data.put("status", ResourceUtil.getString((String)"cap4.form.business.disable"));
                }
                V3xOrgMember member = this.orgManager.getMemberById(p.getCreater());
                if (member != null) {
                    data.put("creater", member.getName());
                } else {
                    data.put("creater", "-");
                }
                data.put("createDate", DateUtil.format((Date)p.getCreateDate(), (String)"yyyy-MM-dd HH:mm"));
                data.put("remark", p.getComment() == null ? "" : p.getComment());
                result.add(data);
            }
        }
        return result;
    }

    @Override
    @AjaxAccess
    public FlipInfo showServiceProviderInfo(FlipInfo infp, Map<String, Object> params) throws BusinessException {
        Long id = ParamUtil.getLong(params, (String)"id", (Long)0L);
        MagicServiceSummary entity = this.magicServiceSummaryDao.loadServiceInfo(id);
        if (entity != null) {
            List<Map<String, Object>> result = this.showProvidersSummarys(entity);
            infp.setData(result);
            infp.setTotal(result.size());
        }
        return infp;
    }

    @Override
    @AjaxAccess
    public FlipInfo loadServicesByOwnerType(FlipInfo infp, Map<String, Object> params) throws BusinessException {
        List<Object> allSummary;
        String certificateType = ParamUtil.getString(params, (String)"certificateType", (String)MagicEnums.CertificateType.Private_certificate.getName());
        String queryValue = ParamUtil.getString(params, (String)"queryValue", (String)"");
        String queryType = ParamUtil.getString(params, (String)"queryType", (String)"");
        Map node = new HashMap();
        if (params.containsKey("node")) {
            node = (Map)params.get("node");
        }
        String otherId = OTHER_CATEGORY;
        String id = ParamUtil.getString(node, (String)"id", (String)"0");
        String pId = ParamUtil.getString(node, (String)"parentId", (String)"");
        HashMap<String, Object> condition = new HashMap<String, Object>();
        ArrayList<String> ownerType = new ArrayList<String>();
        if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(id) || MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(pId)) {
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(id)) {
                ownerType.add(MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType());
                ownerType.add(MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType());
                condition.put("ownerType", ownerType);
            } else if (!otherId.equals(id)) {
                List<com.seeyon.cap4.form.bean.FormBean> allFormBean = this.businessManager4.getFormBeanListByBizId(Long.parseLong(id));
                ArrayList<String> formIds = new ArrayList<String>();
                for (com.seeyon.cap4.form.bean.FormBean formBean : allFormBean) {
                    formIds.add(String.valueOf(formBean.getId()));
                }
                formIds.add(id);
                condition.put("ownerId", formIds);
            }
        } else if (!"0".equals(id)) {
            ownerType.add(id);
            condition.put("ownerType", ownerType);
        }
        if (Strings.isNotBlank((String)queryValue) && !"creater".equals(queryType)) {
            try {
                condition.put("name", URLDecoder.decode(queryValue, "UTF-8"));
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getLocalizedMessage());
            }
        } else if (Strings.isNotBlank((String)queryValue)) {
            List allMember = this.orgManager.getAllMembers(Long.valueOf(AppContext.currentAccountId()));
            LinkedList<Long> ids = new LinkedList<Long>();
            for (V3xOrgMember v3xOrgMember : allMember) {
                if (!v3xOrgMember.getName().contains(queryValue)) continue;
                ids.add(v3xOrgMember.getId());
            }
            V3xOrgMember group = this.orgManager.getGroupAdmin();
            if (group != null && group.getName().contains(queryValue)) {
                ids.add(group.getId());
            }
            condition.put("creater", ids);
            if (ids.isEmpty()) {
                return infp;
            }
            queryValue = "";
        }
        if (MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType().equals(id)) {
            if (MagicEnums.CertificateType.Public_certificate.getName().equals(certificateType)) {
                condition.put("certificateType", MagicEnums.CertificateType.Public_certificate.getKey());
            } else {
                condition.put("certificateType", MagicEnums.CertificateType.Private_certificate.getKey());
            }
            condition.put("ownerType", MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType());
            allSummary = this.magicServiceSummaryDao.findServices(condition, infp);
        } else {
            if (MagicEnums.CertificateType.Public_certificate.getName().equals(certificateType)) {
                condition.put("certificateType", MagicEnums.CertificateType.Public_certificate.getKey());
            } else {
                condition.put("certificateType", MagicEnums.CertificateType.Private_certificate.getKey());
            }
            allSummary = this.magicServiceSummaryDao.findServices(condition, infp);
        }
        if (allSummary == null) {
            allSummary = Collections.emptyList();
        }
        ArrayList resultData = new ArrayList();
        for (MagicServiceSummary magicServiceSummary : allSummary) {
            Long ownerLong;
            HashMap<String, Object> item = new HashMap<String, Object>();
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(pId) && otherId.equals(id)) {
                if (Strings.isNotBlank((String)magicServiceSummary.getOwner()) && MagicPrivateUtils.isNumeric(magicServiceSummary.getOwner())) {
                    ownerLong = Long.parseLong(magicServiceSummary.getOwner());
                    if (MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType().equals(magicServiceSummary.getOwnerType()) ? this.businessManager4.findBizConfigById(ownerLong) != null : !MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(magicServiceSummary.getOwnerType()) || this.cap4FormCacheManager.getForm(ownerLong) != null && this.businessManager4.findBizConfigByFormId(ownerLong) != null) {
                        continue;
                    }
                } else if (!MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(magicServiceSummary.getOwnerType()) && !MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType().equals(magicServiceSummary.getOwnerType())) continue;
            }
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(magicServiceSummary.getOwnerType())) {
                ownerLong = Long.parseLong(MagicPrivateUtils.isNumeric(magicServiceSummary.getOwner()) ? magicServiceSummary.getOwner() : "0");
                BizConfigBean biz = this.businessManager4.findBizConfigByFormId(ownerLong);
                if (biz != null) {
                    item.put("status", biz.isPublishedConfig() ? ResourceUtil.getString((String)"cap4.form.business.release") : ResourceUtil.getString((String)"form.mgr.state.unpublished.lable"));
                }
            } else {
                item.put("status", ResourceUtil.getString((String)"form.mgr.state.unpublished.lable"));
            }
            MagicServiceProviderPO onProviders = this.magicProviderDao.loadProviders(magicServiceSummary.getBusinessId(), magicServiceSummary.getBusinessVersion(), MagicEnums.ProviderStatus.ON);
            if (onProviders != null) {
                item.put("implInfo", onProviders.getDisplayName());
            }
            int invokeCount = this.invokeStatistics(magicServiceSummary.getBusinessId(), magicServiceSummary.getBusinessVersion());
            item.put("invokeCount", invokeCount);
            item.put("id", String.valueOf(magicServiceSummary.getId()));
            item.put("name", magicServiceSummary.getNameDisplay());
            item.put("certificateType", MagicEnums.CertificateType.getEnumByKey((int)magicServiceSummary.getCertificateType()).getI18nText());
            item.put("createDate", magicServiceSummary.getCreateDate());
            item.put("modifyDate", magicServiceSummary.getModifyDate());
            if (magicServiceSummary.getCreateId() != null) {
                V3xOrgMember createMember = this.orgManager.getMemberById(magicServiceSummary.getCreateId());
                if (createMember != null) {
                    item.put("createrName", createMember.getName());
                } else {
                    item.put("createrName", "");
                }
            } else {
                item.put("createrName", "");
            }
            resultData.add(item);
        }
        if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(pId) && otherId.equals(id)) {
            return this.setFlipInfo(resultData, infp);
        }
        infp.setData(resultData);
        return infp;
    }

    @Override
    @AjaxAccess
    public List<Map<String, Object>> loadAllServicesOwnerType(Map<String, Object> params) throws BusinessException {
        String certificateType = ParamUtil.getString(params, (String)"certificateType", (String)MagicEnums.CertificateType.Private_certificate.getName());
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        List<Object> allSummary = null;
        if (MagicEnums.CertificateType.Public_certificate.getName().equals(certificateType)) {
            condition.put("certificateType", MagicEnums.CertificateType.Public_certificate.getKey());
            allSummary = this.magicServiceSummaryDao.findServices(condition, null);
        } else {
            condition.put("certificateType", MagicEnums.CertificateType.Private_certificate.getKey());
            allSummary = this.magicServiceSummaryDao.findServices(condition, null);
        }
        if (allSummary == null) {
            allSummary = Collections.emptyList();
        }
        HashMap<Long, BizConfigBean> allBiz = new HashMap<Long, BizConfigBean>();
        boolean existDeleteBiz = false;
        HashMap<String, ArrayList<Object>> category = new HashMap<String, ArrayList<Object>>();
        for (Object s : allSummary) {
            BizConfigBean bizConfig;
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(s.getOwnerType())) {
                bizConfig = this.businessManager4.findBizConfigByFormId(Long.parseLong(Strings.isNotBlank((String)s.getOwner()) ? s.getOwner() : "0"));
                if (bizConfig != null) {
                    allBiz.put(bizConfig.getId(), bizConfig);
                    continue;
                }
                existDeleteBiz = true;
                continue;
            }
            if (MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType().equals(s.getOwnerType())) {
                if (MagicPrivateUtils.isNumeric(s.getOwner())) {
                    bizConfig = this.businessManager4.findBizConfigById(Long.parseLong(Strings.isNotBlank((String)s.getOwner()) ? s.getOwner() : "0"));
                    if (bizConfig != null) {
                        allBiz.put(bizConfig.getId(), bizConfig);
                        continue;
                    }
                    existDeleteBiz = true;
                    continue;
                }
                existDeleteBiz = true;
                continue;
            }
            String ownerType = s.getOwnerType() == null ? MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType() : s.getOwnerType();
            ArrayList<Object> cacheS = (ArrayList<Object>)category.get(ownerType);
            if (cacheS == null) {
                cacheS = new ArrayList<Object>();
                category.put(ownerType, cacheS);
            }
            cacheS.add(s);
        }
        HashMap<String, String> item2 = null;
        if (!allBiz.isEmpty() || existDeleteBiz) {
            item2 = new HashMap<String, String>();
            item2.put("id", MagicEnums.ProviderType.DEFAULT_FORM.getType());
            item2.put("parentId", "-1");
            item2.put("name", ResourceUtil.getString((String)"system.menuname.BusinessOrderPlatform"));
            result.add(item2);
        }
        for (BizConfigBean b : allBiz.values()) {
            item2 = new HashMap();
            item2.put("id", String.valueOf(b.getId()));
            item2.put("parentId", MagicEnums.ProviderType.DEFAULT_FORM.getType());
            item2.put("name", b.getName());
            result.add(item2);
        }
        if (existDeleteBiz) {
            item2 = new HashMap();
            item2.put("id", OTHER_CATEGORY);
            item2.put("parentId", MagicEnums.ProviderType.DEFAULT_FORM.getType());
            item2.put("name", ResourceUtil.getString((String)"com.cap.businessrelation.condition.other.label"));
            result.add(item2);
        }
        List<OutService> allOutService = CAP4MagicCacheInitializer.getAllMagicOutService();
        ArrayList<OutServiceInfo> allServiceInfo = new ArrayList<OutServiceInfo>();
        for (OutService os : allOutService) {
            OutServiceInfo si = os.getServiceInfo();
            if (si == null) continue;
            allServiceInfo.add(si);
        }
        Collections.sort(allServiceInfo, new Comparator<OutServiceInfo>(){

            @Override
            public int compare(OutServiceInfo o1, OutServiceInfo o2) {
                return o1.getSort() - o2.getSort();
            }
        });
        for (OutServiceInfo osi : allServiceInfo) {
            List existsSummary = (List)category.get(osi.getIdentity());
            if (existsSummary == null) continue;
            item2 = new HashMap();
            item2.put("id", osi.getIdentity());
            item2.put("parentId", "-1");
            item2.put("name", osi.getName());
            result.add(item2);
        }
        if (category.containsKey(MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType())) {
            item2 = new HashMap();
            item2.put("id", MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType());
            item2.put("parentId", "-1");
            item2.put("name", MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getI18nText());
            result.add(item2);
        }
        return result;
    }

    private List<ServiceSummary> loadExternalServices(Map<String, Object> condition) throws BusinessException {
        ServiceSummary mss;
        ServiceSummary root;
        String services = ParamUtil.getString(condition, (String)"subType");
        String name = "";
        String currentBizId = ParamUtil.getString(condition, (String)"currentBizId", (String)"");
        if (condition.get("name") != null && !"".equals(condition.get("name"))) {
            name = ParamUtil.getString(condition, (String)"name");
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getLocalizedMessage());
            }
        }
        List<MagicServiceSummary> serviceSummaries = this.magicServiceSummaryDao.findExternalServices(null, null, null, null, false);
        ArrayList<String> bidList = new ArrayList<String>(serviceSummaries.size());
        for (MagicServiceSummary s : serviceSummaries) {
            if (s.getAuthorizationType() == null) continue;
            if (MagicEnums.ServiceAuthType.PUBLIC.getKey() == s.getAuthorizationType().intValue()) {
                bidList.add(s.getBusinessId());
                continue;
            }
            if (MagicEnums.ServiceAuthType.PRIVATE.getKey() == s.getAuthorizationType().intValue()) {
                BizConfigBean bizConfigBean;
                if (!MagicPrivateUtils.isNumeric(s.getOwner()) || (bizConfigBean = this.businessManager4.findBizConfigById(Long.parseLong(s.getOwner()))) == null || AppContext.currentUserId() != bizConfigBean.getOwnerId()) continue;
                bidList.add(s.getBusinessId());
                continue;
            }
            if (!Strings.isNotBlank((String)s.getAuthorizationInfo())) continue;
            ArrayList authList = new ArrayList();
            JSONUtils.parseJSonListObj_Class(s.getAuthorizationInfo(), authList, Map.class);
            for (Map a : authList) {
                Long bizId = ParamUtil.getLong((Map)a, (String)"value", (Long)0L);
                if (!String.valueOf(bizId).equals(currentBizId)) continue;
                bidList.add(s.getBusinessId());
            }
        }
        ArrayList<MagicEnums.BusinessMethodType> type = new ArrayList<MagicEnums.BusinessMethodType>();
        if (services != null) {
            if (MagicEnums.BusinessMethodType.RELATION_SYS.getName().equals(services)) {
                type.add(MagicEnums.BusinessMethodType.RELATION_SYS);
                type.add(MagicEnums.BusinessMethodType.RELATION);
            } else if (MagicEnums.BusinessMethodType.RELATION_USER.getName().equals(services)) {
                type.add(MagicEnums.BusinessMethodType.RELATION_USER);
                type.add(MagicEnums.BusinessMethodType.RELATION);
            } else if (MagicEnums.BusinessMethodType.RELATION.getName().equals(services)) {
                type.add(MagicEnums.BusinessMethodType.RELATION_USER);
                type.add(MagicEnums.BusinessMethodType.RELATION);
                type.add(MagicEnums.BusinessMethodType.RELATION_SYS);
            } else {
                type.add(MagicEnums.BusinessMethodType.OUTERTRGGER);
            }
        }
        List<MagicInterfaceDefineEntity> entityList = this.magicInterfaceDefineDao.loadDefines(type, bidList, name);
        ArrayList<ServiceSummary> result = new ArrayList<ServiceSummary>();
        LinkedList<MagicInterfaceDefineEntity> systemMethod = new LinkedList<MagicInterfaceDefineEntity>();
        LinkedList<MagicInterfaceDefineEntity> bizMethod = new LinkedList<MagicInterfaceDefineEntity>();
        for (MagicInterfaceDefineEntity entity : entityList) {
            if (MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType().equals(entity.getSubType())) {
                bizMethod.add(entity);
                continue;
            }
            systemMethod.add(entity);
        }
        if (!systemMethod.isEmpty()) {
            root = new ServiceSummary();
            root.setParentId(OTHER_CATEGORY);
            root.setId(MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType());
            root.setCategory(true);
            root.setName(MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getI18nText());
            result.add(root);
            for (MagicInterfaceDefineEntity d : systemMethod) {
                mss = new ServiceSummary();
                mss.setParentId(root.getId());
                mss.setName(d.getName());
                mss.setId(String.valueOf(d.getId()));
                mss.setBusinessId(d.getBusinessId());
                mss.setVersion(d.getVersionId());
                mss.setServiceName(d.getMethodName());
                result.add(mss);
            }
        }
        if (!bizMethod.isEmpty()) {
            root = new ServiceSummary();
            root.setParentId(OTHER_CATEGORY);
            root.setId(MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType());
            root.setCategory(true);
            root.setName(MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getI18nText());
            result.add(root);
            for (MagicInterfaceDefineEntity d : bizMethod) {
                mss = new ServiceSummary();
                mss.setParentId(root.getId());
                mss.setName(d.getName());
                mss.setId(String.valueOf(d.getId()));
                mss.setBusinessId(d.getBusinessId());
                mss.setVersion(d.getVersionId());
                mss.setServiceName(d.getMethodName());
                result.add(mss);
            }
        }
        return result;
    }

    @Override
    @AjaxAccess
    public List<ServiceSummary> loadAllAvailableService(Map<String, Object> condition) throws BusinessException {
        String serviceTypes = ParamUtil.getString(condition, (String)"serviceType");
        String name = "";
        if (condition.get("name") != null && !"".equals(condition.get("name"))) {
            name = ParamUtil.getString(condition, (String)"name");
            try {
                name = URLDecoder.decode(name, "UTF-8");
                condition.put("name", name);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getLocalizedMessage());
            }
        }
        if (MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType().equals(serviceTypes)) {
            return this.loadExternalServices(condition);
        }
        OutService outService = CAP4MagicCacheInitializer.getOutServiceByType(serviceTypes);
        String services = ParamUtil.getString(condition, (String)"subType");
        int type = 0;
        if (outService != null) {
            if (services != null) {
                type = MagicEnums.BusinessMethodType.RELATION_SYS.getName().equals(services) ? MagicEnums.BusinessMethodType.RELATION_SYS.getType() : (MagicEnums.BusinessMethodType.RELATION_USER.getName().equals(services) ? MagicEnums.BusinessMethodType.RELATION_USER.getType() : (MagicEnums.BusinessMethodType.RELATION.getName().equals(services) ? MagicEnums.BusinessMethodType.RELATION.getType() : MagicEnums.BusinessMethodType.OUTERTRGGER.getType()));
            }
            ServicesCategoryTree category = new ServicesCategoryTree();
            String id = ParamUtil.getString(condition, (String)"id", null);
            if (Strings.isNotBlank((String)id)) {
                category.setId(id);
            }
            ServiceQueryCondition condtion = new ServiceQueryCondition();
            if (condition.get("name") != null && !"".equals(condition.get("name"))) {
                condtion.setCondition(ParamUtil.getString(condition, (String)"name"));
                condtion.setQueryType(ServiceQueryCondition.QueryType.NAME);
            }
            condtion.setOtherAttr(condition);
            return outService.loadAllServices(type, category, condtion);
        }
        return this.loadAvialbableFormServices(condition);
    }

    private List<ServiceSummary> loadAvialbableFormServices(Map<String, Object> condition) throws BusinessException {
        String name = ParamUtil.getString(condition, (String)"name");
        String otherParentId = OTHER_CATEGORY;
        Long currentBizId = ParamUtil.getLong(condition, (String)"currentBizId", (Long)0L);
        String services = ParamUtil.getString(condition, (String)"subType");
        ArrayList<MagicEnums.BusinessMethodType> serviceType = new ArrayList<MagicEnums.BusinessMethodType>();
        if (Strings.isNotBlank((String)services)) {
            if (services.contains(MagicEnums.BusinessMethodType.RELATION_SYS.getName() + "")) {
                serviceType.add(MagicEnums.BusinessMethodType.RELATION_SYS);
                serviceType.add(MagicEnums.BusinessMethodType.RELATION);
            }
            if (services.contains(MagicEnums.BusinessMethodType.RELATION_USER.getName() + "") || "userRelationIncreaseRow".equals(services)) {
                serviceType.add(MagicEnums.BusinessMethodType.RELATION_USER);
                serviceType.add(MagicEnums.BusinessMethodType.RELATION);
            }
            if (services.contains(MagicEnums.BusinessMethodType.TRIGGER_CREATE.getName() + "")) {
                serviceType.add(MagicEnums.BusinessMethodType.TRIGGER_CREATE);
            }
            if (services.contains(MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE.getName() + "")) {
                serviceType.add(MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE);
            }
            if (services.contains(MagicEnums.BusinessMethodType.TRIGGER_UPDATE.getName() + "")) {
                serviceType.add(MagicEnums.BusinessMethodType.TRIGGER_UPDATE);
            }
        } else {
            serviceType.add(MagicEnums.BusinessMethodType.TRIGGER_CREATE);
            serviceType.add(MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE);
            serviceType.add(MagicEnums.BusinessMethodType.TRIGGER_UPDATE);
        }
        HashMap<String, Object> summaryCondition = new HashMap<String, Object>();
        summaryCondition.put("ownerType", MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType());
        List<MagicServiceSummary> allSummary = this.magicServiceSummaryDao.findServices(summaryCondition, null);
        ArrayList<String> authService = new ArrayList<String>();
        ArrayList<String> formIds = new ArrayList<String>();
        List<com.seeyon.cap4.form.bean.FormBean> allBizFormBean = this.businessManager4.getFormBeanListByBizId(currentBizId);
        for (com.seeyon.cap4.form.bean.FormBean formBean : allBizFormBean) {
            formIds.add(String.valueOf(formBean.getId()));
        }
        HashMap<String, MagicServiceSummary> allMapper = new HashMap<String, MagicServiceSummary>();
        for (MagicServiceSummary s : allSummary) {
            if (s.getAuthorizationType() == null || formIds.contains(s.getOwner())) continue;
            if (MagicEnums.ServiceAuthType.PUBLIC.getKey() == s.getAuthorizationType().intValue()) {
                authService.add(s.getBusinessId());
                allMapper.put(s.getBusinessId(), s);
                continue;
            }
            if (MagicEnums.ServiceAuthType.USERDEFINED.getKey() == s.getAuthorizationType().intValue() && Strings.isNotBlank((String)s.getAuthorizationInfo())) {
                ArrayList authList = new ArrayList();
                JSONUtils.parseJSonListObj_Class(s.getAuthorizationInfo(), authList, Map.class);
                for (Map a : authList) {
                    Long bizId = ParamUtil.getLong((Map)a, (String)"value", (Long)0L);
                    if (!bizId.equals(currentBizId)) continue;
                    authService.add(s.getBusinessId());
                    allMapper.put(s.getBusinessId(), s);
                }
                continue;
            }
            if (MagicEnums.ServiceAuthType.PRIVATE.getKey() != s.getAuthorizationType().intValue()) continue;
            BizConfigBean bizConfigBean = null;
            if (MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType().equals(s.getOwnerType()) && MagicPrivateUtils.isNumeric(s.getOwner())) {
                bizConfigBean = this.businessManager4.findBizConfigById(Long.parseLong(s.getOwner()));
            } else if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(s.getOwnerType()) && MagicPrivateUtils.isNumeric(s.getOwner())) {
                bizConfigBean = this.businessManager4.findBizConfigByFormId(Long.parseLong(s.getOwner()));
            }
            if (bizConfigBean == null || AppContext.currentUserId() != bizConfigBean.getOwnerId()) continue;
            authService.add(s.getBusinessId());
            allMapper.put(s.getBusinessId(), s);
        }
        List<MagicInterfaceDefineEntity> list = this.magicInterfaceDefineDao.loadDefines(serviceType, authService, name);
        ArrayList<ServiceSummary> tempList = new ArrayList<ServiceSummary>();
        LinkedHashMap<String, ServiceSummary> categoryMapper = new LinkedHashMap<String, ServiceSummary>();
        ArrayList<ServiceSummary> other = new ArrayList<ServiceSummary>();
        ServiceSummary root = new ServiceSummary();
        root.setId("root");
        root.setName(ResourceUtil.getString((String)"cap.magic.info.port.form"));
        root.setIconSkin("treeCustomMenu");
        if (list != null) {
            for (MagicInterfaceDefineEntity d : list) {
                ServiceSummary mss;
                MagicServiceSummary thisServiceSummary = (MagicServiceSummary)allMapper.get(d.getBusinessId());
                if (thisServiceSummary == null) continue;
                long ownerId = MagicPrivateUtils.isNumeric(thisServiceSummary.getOwner()) ? Long.parseLong(thisServiceSummary.getOwner()) : 0L;
                BizConfigBean item = this.businessManager4.findBizConfigByFormId(ownerId);
                if (item != null && !Integer.valueOf(0).equals(item.getUseFlag())) {
                    if (categoryMapper.get(String.valueOf(item.getId())) == null) {
                        ServiceSummary categorySummary = new ServiceSummary();
                        categorySummary.setId(String.valueOf(item.getId()));
                        categorySummary.setName(item.getName());
                        categorySummary.setParentId(root.getId());
                        categorySummary.setCategory(true);
                        categoryMapper.put(categorySummary.getId(), categorySummary);
                    }
                    mss = new ServiceSummary();
                    mss.setParentId(String.valueOf(item.getId()));
                    mss.setName(d.getName(AppContext.getLocale()));
                    mss.setId(String.valueOf(d.getId()));
                    mss.setBusinessId(d.getBusinessId());
                    mss.setVersion(d.getVersionId());
                    mss.setServiceName(d.getMethodName());
                    categoryMapper.put(mss.getId(), mss);
                    continue;
                }
                if (item != null) continue;
                mss = new ServiceSummary();
                mss.setParentId(otherParentId);
                mss.setName(d.getName(AppContext.getLocale()));
                mss.setId(String.valueOf(d.getId()));
                mss.setBusinessId(d.getBusinessId());
                mss.setVersion(d.getVersionId());
                mss.setServiceName(d.getMethodName());
                other.add(mss);
            }
        }
        tempList.add(root);
        tempList.addAll(categoryMapper.values());
        if (!other.isEmpty()) {
            ServiceSummary otherTree = new ServiceSummary();
            otherTree.setId(otherParentId);
            otherTree.setParentId(root.getId());
            otherTree.setName(ResourceUtil.getString((String)"com.cap.businessrelation.condition.other.label"));
            otherTree.setCategory(true);
            tempList.add(otherTree);
            tempList.addAll(other);
        }
        if (tempList.size() < 2) {
            tempList.clear();
        }
        return tempList;
    }

    @Override
    @AjaxAccess
    public List<ServiceSummary> loadAllAvailableBusiness(Map<String, Object> condtion) throws BusinessException {
        String sourceType = ParamUtil.getString(condtion, (String)"serviceType", (String)"");
        int publishFlag = ParamUtil.getInt(condtion, (String)"publishFlag", (int)-1);
        IincisionSourceManager currentSourceManager = null;
        Map sourceManager = AppContext.getBeansOfType(IincisionSourceManager.class);
        for (IincisionSourceManager entry : sourceManager.values()) {
            MagicIncisionSource sourceInfo = entry.getSourceInfo();
            if (sourceInfo == null || !sourceInfo.getSourceType().equals(sourceType)) continue;
            currentSourceManager = entry;
            break;
        }
        if (currentSourceManager != null) {
            int type = 0;
            String currentBizId = ParamUtil.getString(condtion, (String)"currentBizId", (String)"");
            ServiceQueryCondition condtions = new ServiceQueryCondition();
            String name = ParamUtil.getString(condtion, (String)"name", (String)"");
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getLocalizedMessage());
            }
            condtions.setCondition(name);
            condtions.getOtherAttr().put("currentBizId", currentBizId);
            condtions.getOtherAttr().put("publishFlag", publishFlag);
            condtions.getOtherAttr().putAll(condtion);
            return currentSourceManager.loadSources(type, condtions);
        }
        return Collections.emptyList();
    }

    @Override
    @AjaxAccess
    public List<MagicIncisionSource> loadAllIncisionSources(Map<String, Object> params) throws BusinessException {
        String filter = ParamUtil.getString(params, (String)"filter", (String)"");
        Map sourceManager = AppContext.getBeansOfType(IincisionSourceManager.class);
        ArrayList<MagicIncisionSource> result = new ArrayList<MagicIncisionSource>();
        for (IincisionSourceManager entry : sourceManager.values()) {
            MagicIncisionSource sourceInfo = entry.getSourceInfo();
            if (sourceInfo == null || !sourceInfo.isEnabled() || !Strings.isBlank((String)filter) && !filter.contains(sourceInfo.getSourceType())) continue;
            result.add(sourceInfo);
        }
        Collections.sort(result, new Comparator<MagicIncisionSource>(){

            @Override
            public int compare(MagicIncisionSource o1, MagicIncisionSource o2) {
                return o1.getSort() - o2.getSort();
            }
        });
        return result;
    }

    @Override
    @AjaxAccess
    public List<Map<String, Object>> loadFormByBizId(Map<String, Object> params) throws BusinessException {
        Long bizId = ParamUtil.getLong(params, (String)"currentBizId", (Long)0L);
        int flowForm = ParamUtil.getInt(params, (String)"flowForm", (int)-1);
        String name = ParamUtil.getString(params, (String)"name", (String)"");
        if (Strings.isNotBlank((String)name)) {
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getLocalizedMessage());
            }
        }
        BizConfigBean biz = this.businessManager4.findBizConfigById(bizId);
        List<com.seeyon.cap4.form.bean.FormBean> allForm = this.businessManager4.getFormBeanListByBizId(bizId);
        if (biz != null && allForm != null) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(allForm.size());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", String.valueOf(biz.getId()));
            data.put("name", biz.getName());
            data.put("canSelect", "0");
            result.add(data);
            for (com.seeyon.cap4.form.bean.FormBean fb : allForm) {
                if (Strings.isNotBlank((String)name) && !fb.getFormName().contains(name) || flowForm == 1 && !fb.isFlowForm() || flowForm == 0 && fb.isFlowForm()) continue;
                data = new HashMap();
                data.put("id", String.valueOf(fb.getId()));
                data.put("name", fb.getFormName());
                data.put("pId", String.valueOf(bizId));
                data.put("canSelect", "1");
                data.put("flowForm", fb.isFlowForm() ? "1" : "0");
                result.add(data);
            }
            if (result.size() == 1) {
                result.clear();
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    @AjaxAccess
    public List<Map<String, Object>> loadBizConfigs(Map<String, Object> params) throws BusinessException {
        List currentAccountBizs;
        List<CapBizConfig> data = this.businessManager4.findAllBizConfig();
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        String pId = "1";
        String name = ParamUtil.getString(params, (String)"name", (String)"");
        try {
            name = URLDecoder.decode(name, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
        HashMap mapperByAccount = new HashMap();
        for (V3xOrgAccount account : this.orgManager.getAllAccounts()) {
            mapperByAccount.put(account.getId(), new LinkedList());
        }
        for (CapBizConfig i : data) {
            Long ownerAccountId;
            List mappers;
            Integer useFlag = i.getUseFlag();
            Long id = i.getId();
            if (useFlag == null || useFlag == 0) continue;
            String bizName = i.getName();
            if (Strings.isNotBlank((String)name) && !bizName.contains(name) || (mappers = (List)mapperByAccount.get(ownerAccountId = i.getOrgAccountId())) == null) continue;
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("id", String.valueOf(id));
            item.put("name", bizName);
            item.put("pId", String.valueOf(ownerAccountId));
            item.put("canSelect", "1");
            mappers.add(item);
        }
        if (!mapperByAccount.isEmpty()) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("id", pId);
            item.put("name", ResourceUtil.getString((String)"system.menuname.BusinessOrderPlatform"));
            result.add(item);
        }
        if ((currentAccountBizs = (List)mapperByAccount.get(AppContext.currentAccountId())) != null && !currentAccountBizs.isEmpty()) {
            V3xOrgAccount currentAccount = this.orgManager.getAccountById(Long.valueOf(AppContext.currentAccountId()));
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("pId", pId);
            item.put("id", String.valueOf(currentAccount.getId()));
            item.put("name", currentAccount.getName());
            item.put("open", true);
            result.add(item);
            result.addAll(currentAccountBizs);
        }
        mapperByAccount.remove(AppContext.currentAccountId());
        for (Map.Entry entry : mapperByAccount.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            V3xOrgAccount currentAccount = this.orgManager.getAccountById((Long)entry.getKey());
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("pId", pId);
            item.put("id", String.valueOf(currentAccount.getId()));
            item.put("name", currentAccount.getName());
            result.add(item);
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    @Override
    @AjaxAccess
    public List<OutServiceInfo> loadOutServices(Map<String, Object> params) throws BusinessException {
        List<OutService> allOutService = CAP4MagicCacheInitializer.getAllMagicOutService();
        String handleType = ParamUtil.getString(params, (String)"handleType", (String)"");
        ArrayList<OutServiceInfo> rs = new ArrayList<OutServiceInfo>();
        OutServiceInfo form = new OutServiceInfo();
        form.setIdentity(MagicEnums.ProviderType.DEFAULT_FORM.getType());
        form.setName(ResourceUtil.getString((String)"system.menuname.BusinessOrderPlatform"));
        form.setSort(1);
        String filter = ParamUtil.getString(params, (String)"filter", (String)"");
        if (Strings.isBlank((String)filter) || filter.contains(form.getIdentity())) {
            rs.add(form);
        }
        if (allOutService == null || allOutService.isEmpty()) {
            return rs;
        }
        List<String> handleTypeArray = Arrays.asList(handleType.split(","));
        block0: for (OutService os : allOutService) {
            OutServiceInfo outServiceInfo;
            if (!Strings.isBlank((String)filter) && !filter.contains(os.getServiceInfo().getIdentity()) || !(outServiceInfo = os.getServiceInfo()).isEnabled()) continue;
            List supportType = outServiceInfo.getSupportType();
            for (String s : supportType) {
                if (!handleTypeArray.contains(s)) continue;
                rs.add(os.getServiceInfo());
                continue block0;
            }
        }
        if (Strings.isBlank((String)filter) || filter.contains(MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType())) {
            this.addPublicServiceInfo(rs);
        }
        Collections.sort(rs, new Comparator<OutServiceInfo>(){

            @Override
            public int compare(OutServiceInfo o1, OutServiceInfo o2) {
                return o1.getSort() - o2.getSort();
            }
        });
        return rs;
    }

    private void addPublicServiceInfo(List<OutServiceInfo> allServiceInfo) {
        List<MagicServiceSummary> allSummary = this.magicServiceSummaryDao.findExternalServices(null, null, null, null, false);
        if (allSummary != null && !allSummary.isEmpty()) {
            OutServiceInfo form = new OutServiceInfo();
            form.setIdentity(MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType());
            form.setName(ResourceUtil.getString((String)"cap.magic.public.interface.label"));
            form.setSort(100);
            allServiceInfo.add(form);
        }
    }

    @Override
    @AjaxAccess
    public ResponseMessage updateDefineInfo(List<Map<String, Object>> params) throws BusinessException {
        ResponseMessage result = new ResponseMessage();
        result.setSuccess(true);
        if (params == null || params.isEmpty()) {
            result.setSuccess(false);
            result.setMsg("\u53c2\u6570\u4e3a\u7a7a ");
            return result;
        }
        HashMap<Long, Map<String, Object>> attr = new HashMap<Long, Map<String, Object>>();
        for (Map<String, Object> p : params) {
            Long id = ParamUtil.getLong(p, (String)"id", (Long)0L);
            attr.put(id, p);
        }
        List<MagicInterfaceDefineEntity> entitys = this.magicInterfaceDefineDao.findByIds(attr.keySet());
        ArrayList<MagicInterfaceDefineEntity> needUpdateEntity = new ArrayList<MagicInterfaceDefineEntity>();
        boolean repetition = false;
        for (MagicInterfaceDefineEntity e : entitys) {
            Map map = (Map)attr.get(e.getId());
            if (map == null || map.isEmpty()) continue;
            String name = ParamUtil.getString((Map)map, (String)"name");
            repetition = this.magicInterfaceDefineDao.checkNameRepetition(name, e.getId());
            if (repetition) {
                result.setSuccess(false);
                result.setMsg(name + "\u5df2\u7ecf\u5b58\u5728\uff01 \u8bf7\u4fee\u6539");
                return result;
            }
            e.setName(name);
            needUpdateEntity.add(e);
        }
        this.magicInterfaceDefineDao.updateList(needUpdateEntity);
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, String> checkMagicServiceExists(List<String> ids) throws BusinessException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (ids != null && !ids.isEmpty()) {
            for (String s : ids) {
                try {
                    Long id = Long.parseLong(s);
                    MagicInterfaceDefineEntity entry = this.magicInterfaceDefineDao.loadDefineById(id);
                    if (entry == null) {
                        result.put(s, "0");
                        continue;
                    }
                    result.put(s, "1");
                }
                catch (Exception e) {
                    result.put(s, "0");
                }
            }
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> installExternalImpl(Map<String, Object> params) throws BusinessException {
        try {
            Long fileId = ParamUtil.getLong(params, (String)"fileUrl", (Long)0L);
            File importFile = this.fileManager.getFile(fileId, DateUtil.currentDate());
            if (importFile == null || !importFile.exists() || importFile.length() == 0L) {
                throw new BusinessException("\u627e\u4e0d\u5230\u6307\u5b9a\u6587\u4ef6\uff01");
            }
            Long serviceId = ParamUtil.getLong(params, (String)"serviceId", (Long)0L);
            MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(serviceId);
            if (serviceSummary == null) {
                throw new BusinessException("\u627e\u4e0d\u5230\u63a5\u53e3\u5b9a\u4e49\u6587\u4ef6\uff01");
            }
            File publicFolders = SystemEnvironment.getClusterPublicFolder((String)"interface");
            File businessFolder = new File(publicFolders, serviceSummary.getBusinessId() + ".zip");
            FileUtil.copyFile((File)importFile, (File)businessFolder);
            ((IMagicExternalExportManager)((Object)this.magicExternalExportManager)).installServiceImpl(businessFolder, serviceSummary, params);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return null;
    }

    @Override
    @AjaxAccess
    public FlipInfo loadMagicZipForMall(FlipInfo infp, Map<String, Object> params) throws BusinessException {
        CloudAppDatas ctpCloudAppData;
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("version", "4.3");
        requestParams.put("platform", CAPBusinessEnum.Platform.PC.getType());
        requestParams.put("catAlias", "dataMagicInterface");
        requestParams.put("pageSize", infp.getSize());
        String keyword = ParamUtil.getString(params, (String)"keyword", (String)"");
        if (Strings.isNotBlank((String)keyword)) {
            requestParams.put("keyword", keyword);
        }
        if ((ctpCloudAppData = this.mallApi.getBindMallUserData(Long.valueOf(AppContext.currentUserId()))) != null) {
            requestParams.put("access_token", ctpCloudAppData.getAccessToken());
        }
        Map parameterJson = MallUtil.getMallCommonParams(MallEnum.MallAction.LIST, requestParams);
        Map<String, Object> httpResult = HttpClientUtil.doPost(MallUtil.getRestApiUrl(MallEnum.RestApi.MALL_INDEX), parameterJson);
        if (!MallUtil.isRequestSuccess(httpResult)) {
            String message = MallUtil.getMallErrorMessage(httpResult);
            throw new BusinessException(message);
        }
        parameterJson = (Map)JSONUtil.parseJSONString((String)CAPParamUtil.getString(httpResult, (String)"data"));
        List list = (List)parameterJson.get("list");
        if (list != null && !list.isEmpty()) {
            Map<String, List<MagicServiceSummary>> allServicesFormMall = this.loadAllServicesFormMall();
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(list.size());
            CAPBusinessCustomCtrlBO abstractMallBO = new CAPBusinessCustomCtrlBO();
            for (Map map : list) {
                abstractMallBO.clear();
                abstractMallBO.importFromMallMap(map);
                Map<String, Object> mapp = abstractMallBO.exportToMallMap(0);
                if (allServicesFormMall.containsKey(abstractMallBO.getGoodId())) {
                    mapp.put("installed", "true");
                }
                mapList.add(mapp);
            }
            infp.setTotal(mapList.size());
            infp.setData(mapList);
        } else {
            infp.setTotal(0);
            infp.setData(Collections.emptyList());
        }
        return infp;
    }

    private Map<String, List<MagicServiceSummary>> loadAllServicesFormMall() {
        ArrayList<MagicEnums.CertificateType> certificateTypes = new ArrayList<MagicEnums.CertificateType>();
        certificateTypes.add(MagicEnums.CertificateType.Public_certificate);
        certificateTypes.add(MagicEnums.CertificateType.Private_certificate);
        List<MagicServiceSummary> allExternalServices = this.magicServiceSummaryDao.findExternalServices(certificateTypes, null, null, null, true);
        HashMap<String, List<MagicServiceSummary>> result = new HashMap<String, List<MagicServiceSummary>>(allExternalServices.size());
        for (MagicServiceSummary s : allExternalServices) {
            List<MagicServiceProviderPO> providers;
            Map extendOwner;
            String goodId;
            if (Strings.isBlank((String)s.getExtendOwner()) || !Strings.isNotBlank((String)(goodId = ParamUtil.getString((Map)(extendOwner = JSONUtils.parseJSonStr_Class(s.getExtendOwner(), Map.class)), (String)"goodId", (String)""))) || (providers = this.getMagicProviderDao().loadProviders(s.getBusinessId(), s.getBusinessVersion())) == null || providers.isEmpty()) continue;
            ArrayList<MagicServiceSummary> mapper = (ArrayList<MagicServiceSummary>)result.get(goodId);
            if (mapper == null) {
                mapper = new ArrayList<MagicServiceSummary>();
                result.put(goodId, mapper);
            }
            mapper.add(s);
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> exportServices(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String corpId = ValidityUtil.getMplusCorpId();
        if (Strings.isBlank((String)corpId)) {
            throw new BusinessException(ResourceUtil.getString((String)"cap.magic.service.create.error1"));
        }
        try {
            List idArray = (List)params.get("serviceIds");
            LinkedList<ServiceConfig> serviceConfigList = new LinkedList<ServiceConfig>();
            for (String id : idArray) {
                MagicServiceSummary serviceSummary;
                if (!MagicPrivateUtils.isNumeric(id) || (serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(Long.parseLong(id))) == null) continue;
                if (!MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType().equals(serviceSummary.getOwnerType())) {
                    throw new BusinessException(ResourceUtil.getString((String)"cap.magic.export.error1", (Object)serviceSummary.getNameDisplay()));
                }
                if (Strings.isNotBlank((String)serviceSummary.getExtendOwner())) {
                    throw new BusinessException(ResourceUtil.getString((String)"cap.magic.export.error2", (Object)serviceSummary.getNameDisplay()));
                }
                List<MagicInterfaceDefineEntity> methodList = this.magicInterfaceDefineDao.loadAllEntitys(serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion());
                ServiceConfig sc = MagicPrivateUtils.mergeInterface2Configs(serviceSummary, methodList, null);
                serviceConfigList.add(sc);
            }
            File tempFolder = new File(SystemEnvironment.getSystemTempFolder(), UUIDGenerator.getUUID());
            tempFolder.deleteOnExit();
            tempFolder.mkdirs();
            BusinessDataBean businessDataBean = new BusinessDataBean();
            businessDataBean.setZipFolder(tempFolder.getPath());
            HashMap<String, Object> extParams = new HashMap<String, Object>();
            extParams.put("zipNeedPassword", "0");
            this.magicExternalExportManager.exportMagic(businessDataBean, serviceConfigList, extParams);
            Long fileName = UUIDLong.longUUID();
            String baseFolder = this.fileManager.getNowFolder(true);
            File zipFile = new File(baseFolder, String.valueOf(fileName));
            ZipUtil.zip((File)tempFolder, (File)zipFile, (boolean)false);
            Date date = new Date();
            StringBuilder url = new StringBuilder();
            url.append("fileUpload.do?method=download&fileId=").append(fileName);
            url.append("&createDate=").append(DateUtil.format((Date)date));
            url.append("&v=").append(SecurityHelper.digest((Object[])new Object[]{fileName})).append("&filename=");
            resultMap.put("fileUrl", url.toString());
            resultMap.put("filename", zipFile.getName() + ".zip");
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return resultMap;
    }

    @Override
    @AjaxAccess
    public ServiceSummary convertOutService(String handelType, String serviceType, ServiceSummary summary) throws BusinessException {
        OutService outService = CAP4MagicCacheInitializer.getOutServiceByType(serviceType);
        if (outService != null) {
            int type = MagicEnums.BusinessMethodType.OUTERTRGGER.getType();
            if (MagicEnums.BusinessMethodType.RELATION_USER.getName().equals(handelType)) {
                type = MagicEnums.BusinessMethodType.RELATION_USER.getType();
            } else if (MagicEnums.BusinessMethodType.RELATION_SYS.getName().equals(handelType)) {
                type = MagicEnums.BusinessMethodType.RELATION_SYS.getType();
            }
            Long startTime = System.currentTimeMillis();
            ServiceConfig sc = outService.convert(type, summary);
            Long endTime = System.currentTimeMillis();
            LOGGER.info((Object)(outService.getServiceInfo().getName() + "\u8f6c\u6362\u63a5\u53e3[" + summary.getName() + "]\u8017\u65f6" + (endTime - startTime) + "ms"));
            if (sc != null && sc.getMethodConfig() != null && !sc.getMethodConfig().isEmpty()) {
                List<MagicServiceProviderPO> allServiceProviders;
                ServiceMethodConfig mc = (ServiceMethodConfig)sc.getMethodConfig().get(0);
                MagicServiceSummary mss = this.magicServiceSummaryDao.loadServiceInfo(sc.getBusinessId(), sc.getVersion());
                if (mss == null) {
                    mss = new MagicServiceSummary();
                    mss.setIdIfNew();
                    mss.setAuthorizationType(Integer.valueOf(1));
                    mss.setOwnerType(outService.getServiceInfo().getIdentity());
                    mss.setOwner(sc.getOwner());
                    mss.setBusinessType(MagicEnums.BusinessType.EXTERNAL_BUSINESS.getKey());
                    if (sc.getDisplayName() != null && !sc.getDisplayName().isEmpty()) {
                        mss.setNameDisplay(((MagicDisplay)sc.getDisplayName().get(0)).getText());
                    }
                    if (sc.getDes() != null && !sc.getDes().isEmpty()) {
                        mss.setDescription(((MagicDisplay)sc.getDes().get(0)).getText());
                    }
                    if (MagicEnums.CertificateType.Public_certificate.getName().equals(sc.getCertificateType())) {
                        mss.setCertificateType(Integer.valueOf(MagicEnums.CertificateType.Public_certificate.getKey()));
                    } else {
                        mss.setCertificateType(Integer.valueOf(MagicEnums.CertificateType.Private_certificate.getKey()));
                    }
                    mss.setBusinessVersion(sc.getVersion());
                    mss.setBusinessId(sc.getBusinessId());
                    if (sc.getMetadata() != null && sc.getMetadata().getMetadatas() != null && !sc.getMetadata().getMetadatas().isEmpty()) {
                        mss.setMetadata(JSONUtil.toJSONString((Object)sc.getMetadata().getMetadatas()));
                    }
                    mss.setCreateDate(DateUtil.currentDate());
                    mss.setCreateId(Long.valueOf(AppContext.currentUserId()));
                    this.magicServiceSummaryDao.save(mss);
                } else {
                    if (sc.getMetadata() != null && sc.getMetadata().getMetadatas() != null && !sc.getMetadata().getMetadatas().isEmpty()) {
                        HashMap<String, MetadataConfig> allMetadata = new HashMap<String, MetadataConfig>();
                        for (MetadataConfig mcconfig : sc.getMetadata().getMetadatas()) {
                            allMetadata.put(mcconfig.getObjName(), mcconfig);
                        }
                        ArrayList existsMetadata = new ArrayList();
                        if (Strings.isNotBlank((String)mss.getMetadata())) {
                            JSONUtils.parseJSonListObj_Class(mss.getMetadata(), existsMetadata, MetadataConfig.class);
                        }
                        for (MetadataConfig emc : existsMetadata) {
                            allMetadata.put(emc.getObjName(), emc);
                        }
                        mss.setMetadata(JSONUtil.toJSONString(allMetadata.values()));
                    }
                    mss.setCreateDate(DateUtil.currentDate());
                    mss.setCreateId(Long.valueOf(AppContext.currentUserId()));
                    this.magicServiceSummaryDao.delete(mss);
                    this.magicServiceSummaryDao.save(mss);
                }
                MagicInterfaceDefineEntity exists = this.magicInterfaceDefineDao.loadDefineById(sc.getBusinessId(), sc.getVersion(), mc.getMethodName());
                long id = UUIDLong.longUUID();
                if (exists != null) {
                    id = exists.getId();
                }
                MagicInterfaceDefineEntity e = MagicCreateServiceUtils.convertMethodToPoForOutService(sc.getBusinessId(), sc.getVersion(), serviceType, id, mc);
                if (exists != null) {
                    ArrayList<MagicInterfaceDefineEntity> entitys = new ArrayList<MagicInterfaceDefineEntity>();
                    entitys.add(exists);
                    e.setId(exists.getId());
                    this.magicInterfaceDefineDao.delete(entitys);
                }
                this.magicInterfaceDefineDao.saveDefine(e);
                ServiceProvider provider = outService.provider(e.getBusinessId(), e.getVersionId(), e.getMethodName(), summary);
                HashMap<String, String> currentMethodMapping = new HashMap<String, String>();
                currentMethodMapping.put("methodName", e.getMethodName());
                if (provider.getOtherSet() != null) {
                    currentMethodMapping.putAll(provider.getOtherSet());
                }
                if ((allServiceProviders = this.getMagicProviderDao().loadProviders(e.getBusinessId(), e.getVersionId())) != null && !allServiceProviders.isEmpty()) {
                    for (MagicServiceProviderPO p : allServiceProviders) {
                        ArrayList<HashMap<String, String>> extMapper = JSONUtils.parseJSonStr_Class(p.getExt1(), List.class);
                        if (extMapper == null) {
                            extMapper = new ArrayList<HashMap<String, String>>();
                        }
                        if (extMapper.isEmpty()) {
                            extMapper.add(currentMethodMapping);
                        } else {
                            boolean isExists = false;
                            for (Object e2 : extMapper) {
                                String methodName = ParamUtil.getString((Map)((Map)e2), (String)"methodName", (String)"");
                                if (null == provider || !methodName.equals(provider.getMethodName())) continue;
                                isExists = true;
                                break;
                            }
                            if (!isExists) {
                                extMapper.add(currentMethodMapping);
                            }
                        }
                        p.setExt1(JSONUtils.getJSonString(extMapper));
                    }
                    this.magicProviderDao.updateProviders(allServiceProviders);
                } else {
                    ArrayList<HashMap<String, String>> extMapper = new ArrayList<HashMap<String, String>>();
                    extMapper.add(currentMethodMapping);
                    MagicServiceProviderPO po = new MagicServiceProviderPO();
                    po.setIdIfNew();
                    po.setDisplayName(e.getName());
                    po.setBusinessId(e.getBusinessId());
                    po.setSourceType(outService.getServiceInfo().getIdentity());
                    po.setStatus(MagicEnums.ProviderStatus.ON.getType());
                    po.setExt1(JSONUtils.getJSonString(extMapper));
                    po.setVersionId(e.getVersionId());
                    po.setCreater(Long.valueOf(AppContext.currentUserId()));
                    po.setCreateDate(DateUtil.currentDate());
                    this.magicProviderDao.saveProvider(po);
                }
                ServiceSummary result = new ServiceSummary();
                result.setId(String.valueOf(e.getId()));
                result.setName(((MagicDisplay)mc.getDisplayName().get(0)).getText());
                return result;
            }
            throw new BusinessException("\u65e0\u6cd5\u5c06[" + summary.getName() + "]\u8f6c\u6362\u6210\u6570\u636e\u670d\u52a1,\u539f\u56e0 :\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a!");
        }
        throw new BusinessException("\u65e0\u6cd5\u5c06[" + summary.getName() + "]\u8f6c\u6362\u6210\u6570\u636e\u670d\u52a1,\u539f\u56e0 :\u672a\u77e5\u7684serviceType [" + serviceType + "]");
    }

    @Override
    @AjaxAccess
    public List<Map<String, Object>> selectFormBind(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Long currentBizId = ParamUtil.getLong(params, (String)"currentBizId", (Long)0L);
        parameterMap.put("businessType", "0");
        String name = ParamUtil.getString(params, (String)"name");
        if (Strings.isNotBlank((String)name)) {
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FlipInfo fi = new FlipInfo(1, -1);
        FlipInfo business = (FlipInfo)this.businessManager4.listBusiness(fi, parameterMap).get("validBusiness");
        List data = business.getData();
        LinkedList<Map<String, Object>> resultTree = new LinkedList<Map<String, Object>>();
        HashMap<String, String> summary = null;
        for (Map i : data) {
            Integer useFlag = ParamUtil.getInt((Map)i, (String)"useFlag", (int)1);
            Long id = ParamUtil.getLong((Map)i, (String)"id");
            if (useFlag == 0 || currentBizId.equals(id)) continue;
            List<com.seeyon.cap4.form.bean.FormBean> allFormBean = this.businessManager4.getFormBeanListByBizId(id);
            LinkedList bizFormBinds = new LinkedList();
            for (com.seeyon.cap4.form.bean.FormBean f : allFormBean) {
                FormBindBean bind = f.getBind();
                if (f.isFlowForm()) {
                    List<CtpTemplate> template = bind.getFlowTemplateList();
                    if (template.isEmpty()) {
                        template = this.cap4FormManager.getFormSystemTemplate(f.getId());
                    }
                    if (template.isEmpty()) continue;
                    for (CtpTemplate t : template) {
                        if (Strings.isNotBlank((String)name) && !t.getSubject().contains(name)) continue;
                        summary = new HashMap();
                        summary.put("name", f.getFormName());
                        summary.put("id", String.valueOf(f.getId()));
                        summary.put("pId", String.valueOf(id));
                        summary.put("canSelect", "0");
                        bizFormBinds.add(summary);
                        break;
                    }
                    for (CtpTemplate t : template) {
                        if (Strings.isNotBlank((String)name) && !t.getSubject().contains(name)) continue;
                        summary = new HashMap();
                        summary.put("name", t.getSubject());
                        summary.put("id", String.valueOf(t.getId()));
                        summary.put("pId", String.valueOf(f.getId()));
                        summary.put("canSelect", "1");
                        bizFormBinds.add(summary);
                    }
                    continue;
                }
                Map bindAuthBeanMap = bind.getUnFlowTemplateMap();
                if (bindAuthBeanMap == null || bindAuthBeanMap.isEmpty()) continue;
                for (FormBindAuthBean auth : bindAuthBeanMap.values()) {
                    if (Strings.isNotBlank((String)name) && !auth.getName().contains(name)) continue;
                    summary = new HashMap();
                    summary.put("name", f.getFormName());
                    summary.put("id", String.valueOf(f.getId()));
                    summary.put("pId", String.valueOf(id));
                    summary.put("canSelect", "0");
                    bizFormBinds.add(summary);
                    break;
                }
                for (FormBindAuthBean auth : bindAuthBeanMap.values()) {
                    if (Strings.isNotBlank((String)name) && !auth.getName().contains(name)) continue;
                    summary = new HashMap();
                    summary.put("name", auth.getName());
                    summary.put("id", String.valueOf(auth.getId()));
                    summary.put("pId", String.valueOf(f.getId()));
                    summary.put("canSelect", "1");
                    bizFormBinds.add(summary);
                }
            }
            if (!bizFormBinds.isEmpty()) {
                summary = new HashMap<String, String>();
                summary.put("name", ParamUtil.getString((Map)i, (String)"name"));
                summary.put("id", String.valueOf(id));
                summary.put("canSelect", "0");
                resultTree.add(summary);
                resultTree.addAll(bizFormBinds);
            }
            bizFormBinds.clear();
        }
        return resultTree;
    }

    @Override
    @AjaxAccess
    public List<Map<String, Object>> selectFormTemplate(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        int publishFlag = ParamUtil.getInt(params, (String)"publishFlag", (int)-1);
        String name = ParamUtil.getString(params, (String)"name", (String)"");
        if (publishFlag == BizEnums.BizPublishState.published.getKey()) {
            parameterMap.put("publishFlag", BizEnums.BizPublishState.published.getKey());
        } else if (publishFlag == BizEnums.BizPublishState.initState.getKey()) {
            parameterMap.put("publishFlag", BizEnums.BizPublishState.initState.getKey());
        }
        try {
            name = URLDecoder.decode(name, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
        int templateFlag = ParamUtil.getInt(params, (String)"templateFlag", (int)-1);
        parameterMap.put("businessType", "0");
        FlipInfo fi = new FlipInfo(1, -1);
        FlipInfo business = (FlipInfo)this.businessManager4.listBusiness(fi, parameterMap).get("validBusiness");
        List data = business.getData();
        LinkedList<Map<String, Object>> resultTree = new LinkedList<Map<String, Object>>();
        HashMap<String, String> summary = null;
        for (Map i : data) {
            Integer useFlag = ParamUtil.getInt((Map)i, (String)"useFlag", (int)1);
            Long id = ParamUtil.getLong((Map)i, (String)"id");
            if (useFlag == 0) continue;
            List<com.seeyon.cap4.form.bean.FormBean> allFormBean = this.businessManager4.getFormBeanListByBizId(id);
            LinkedList bizFormBinds = new LinkedList();
            for (com.seeyon.cap4.form.bean.FormBean f : allFormBean) {
                FormBindBean bind = f.getBind();
                if (!f.isFlowForm()) continue;
                List<CtpTemplate> template = bind.getFlowTemplateList();
                if (template.isEmpty()) {
                    template = this.cap4FormManager.getFormSystemTemplate(f.getId());
                }
                ArrayList<CtpTemplate> filterByName = new ArrayList<CtpTemplate>();
                for (CtpTemplate t : template) {
                    if (!Strings.isBlank((String)name) && !t.getSubject().contains(name)) continue;
                    filterByName.add(t);
                }
                if (filterByName.isEmpty()) continue;
                summary = new HashMap();
                summary.put("name", f.getFormName());
                summary.put("id", String.valueOf(f.getId()));
                summary.put("pId", String.valueOf(id));
                summary.put("canSelect", "0");
                bizFormBinds.add(summary);
                for (CtpTemplate t : filterByName) {
                    summary = new HashMap();
                    summary.put("name", t.getSubject());
                    summary.put("id", String.valueOf(t.getId()));
                    summary.put("pId", String.valueOf(f.getId()));
                    summary.put("canSelect", "1");
                    bizFormBinds.add(summary);
                }
            }
            if (!bizFormBinds.isEmpty()) {
                summary = new HashMap<String, String>();
                summary.put("name", ParamUtil.getString((Map)i, (String)"name"));
                summary.put("id", String.valueOf(id));
                summary.put("canSelect", "0");
                resultTree.add(summary);
                resultTree.addAll(bizFormBinds);
            }
            bizFormBinds.clear();
        }
        if (templateFlag == 1) {
            HashMap<String, Object> tempParams = new HashMap<String, Object>();
            tempParams.put("ownerId", AppContext.currentUserId());
            tempParams.put("orgAccountId", AppContext.currentAccountId());
            if (Strings.isNotBlank((String)name)) {
                tempParams.put("name", name);
            }
            List<Map<String, Object>> listMap = this.cap4FormCacheManager.getCap4FormDefinitionDAO().showFormList(null, tempParams);
            LinkedList bizFormBinds = new LinkedList();
            for (Map<String, Object> map : listMap) {
                Long formId = ParamUtil.getLong(map, (String)"id", (Long)0L);
                com.seeyon.cap4.form.bean.FormBean f = this.cap4FormCacheManager.getForm(formId);
                if (f == null) {
                    this.cap4FormCacheManager.initForm(formId);
                    f = this.cap4FormCacheManager.getForm(formId);
                    if (f == null) continue;
                }
                if (f.getOwnerId() != AppContext.currentUserId() || Enums.FormPublishFlagEnum.published.getKey() != f.getPublishFlag()) continue;
                FormBindBean bind = f.getBind();
                if (!f.isFlowForm()) continue;
                List<CtpTemplate> template = bind.getFlowTemplateList();
                if (template.isEmpty()) {
                    template = this.cap4FormManager.getFormSystemTemplate(f.getId());
                }
                if (template.isEmpty()) continue;
                summary = new HashMap();
                summary.put("name", f.getFormName());
                summary.put("id", String.valueOf(f.getId()));
                summary.put("pId", "123456789");
                summary.put("canSelect", "0");
                bizFormBinds.add(summary);
                for (CtpTemplate t : template) {
                    summary = new HashMap();
                    summary.put("name", t.getSubject());
                    summary.put("id", String.valueOf(t.getId()));
                    summary.put("pId", String.valueOf(f.getId()));
                    summary.put("canSelect", "1");
                    bizFormBinds.add(summary);
                }
            }
            if (!bizFormBinds.isEmpty()) {
                summary = new HashMap();
                summary.put("name", ResourceUtil.getString((String)"cap4.form.business.formmanagement"));
                summary.put("id", "123456789");
                summary.put("canSelect", "0");
                resultTree.add(summary);
                resultTree.addAll(bizFormBinds);
            }
            bizFormBinds.clear();
        }
        return resultTree;
    }

    @Override
    @AjaxAccess
    public List<Map<String, Object>> getAllFormFieldList(Map<String, Object> params) throws BusinessException {
        Long formId = ParamUtil.getLong(params, (String)"formId", (Long)0L);
        String style = ParamUtil.getString(params, (String)"style", (String)"tree");
        String formVersion = ParamUtil.getString(params, (String)"formVersion", (String)MagicEnums.ProviderType.DEFAULT_FORM.getType());
        String filterInfo = ParamUtil.getString(params, (String)"filter", (String)"formData");
        String methodType = ParamUtil.getString(params, (String)"methodType", (String)"");
        MagicEnums.ServiceOwnerType providerType = MagicEnums.ServiceOwnerType.getEnumByType((String)formVersion);
        MagicFormBean magicFormBean = new MagicFormBean(providerType, formId);
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        Map<Object, Object> item = null;
        MagicEnums.BusinessMethodType businessMethodType = MagicEnums.BusinessMethodType.valueOfName((String)methodType);
        if (!magicFormBean.isNull()) {
            item = new HashMap<String, String>();
            item.put("id", String.valueOf(magicFormBean.getId()));
            item.put("displayName", magicFormBean.getFormName());
            item.put("canSelect", "0");
            result.add(item);
            if ("tree".equals(style)) {
                for (MagicFormTableBean t : magicFormBean.getTableList()) {
                    item = new HashMap();
                    item.put("id", t.getTableName());
                    item.put("displayName", t.getDisplay());
                    item.put("canSelect", "0");
                    item.put("pId", String.valueOf(magicFormBean.getId()));
                    result.add(item);
                    for (MagicFormFieldBean formFieldBean : t.getFieldsByName(methodType, filterInfo)) {
                        item = magicFormBean.getFormFieldInfo(formFieldBean, businessMethodType);
                        item.put("id", formFieldBean.getName());
                        item.put("name", formFieldBean.getName());
                        item.put("canSelect", "1");
                        item.put("pId", t.getTableName());
                        result.add(item);
                    }
                }
            } else {
                result.clear();
                result.addAll(magicFormBean.getAllFieldBeans4JSON());
            }
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getFormInfoForMagicImpl(Map<String, Object> params) throws BusinessException {
        Long formId = ParamUtil.getLong(params, (String)"formId", (Long)0L);
        String formType = ParamUtil.getString(params, (String)"formType", (String)"");
        MagicEnums.ServiceOwnerType serviceOwnerType = MagicEnums.ServiceOwnerType.getEnumByType((String)formType);
        MagicFormBean formBean = new MagicFormBean(serviceOwnerType, formId);
        if (formBean.isNull()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("template", formBean.getTemplates());
        HashMap<String, List<Map<String, Object>>> dataRight = new HashMap<String, List<Map<String, Object>>>();
        ArrayList<String> viewOpertaionType = new ArrayList<String>();
        viewOpertaionType.add(Enums.FormAuthorizationType.add.getKey());
        dataRight.put(Enums.FormAuthorizationType.add.getKey(), formBean.getDataRight(viewOpertaionType));
        viewOpertaionType.clear();
        viewOpertaionType.add(Enums.FormAuthorizationType.update.getKey());
        dataRight.put(Enums.FormAuthorizationType.update.getKey(), formBean.getDataRight(viewOpertaionType));
        viewOpertaionType.clear();
        viewOpertaionType.add(Enums.FormAuthorizationType.show.getKey());
        dataRight.put(Enums.FormAuthorizationType.show.getKey(), formBean.getDataRight(viewOpertaionType));
        result.put("dataRight", dataRight);
        result.put("formFieldList", formBean.getAllFieldBeans4JSON());
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> getFormFieldBeans(Map<String, Object> params) throws BusinessException {
        Long formId = ParamUtil.getLong(params, (String)"formId", (Long)0L);
        Long bindId = ParamUtil.getLong(params, (String)"bindId", (Long)0L);
        com.seeyon.cap4.form.bean.FormBean fb = this.cap4FormCacheManager.getForm(formId);
        if (fb == null) {
            return Collections.EMPTY_MAP;
        }
        List allTableList = fb.getTableList();
        ArrayList formFields = new ArrayList(allTableList.size());
        for (FormTableBean ftb : allTableList) {
            HashMap<String, Object> formTableInfo = new HashMap<String, Object>();
            formTableInfo.put("tableName", ftb.getTableName());
            List allFieldBeans = ftb.getFields();
            ArrayList<Map> fieldInfo = new ArrayList<Map>(allFieldBeans.size());
            for (FormFieldBean ffb : allFieldBeans) {
                fieldInfo.add(ffb.getJsonObj4Design(false, true));
            }
            formTableInfo.put("fieldInfo", fieldInfo);
            formFields.add(formTableInfo);
        }
        HashMap<String, Number> targetForm = new HashMap<String, Number>();
        targetForm.put("formType", fb.getFormType());
        targetForm.put("formId", formId);
        targetForm.put("bindId", bindId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("targetForm", targetForm);
        result.put("formFields", formFields);
        return result;
    }

    @Override
    @AjaxAccess
    public MagicServiceDetail getServiceDetailById(String id, String type) throws BusinessException {
        MagicInterfaceDefineEntity data = this.magicInterfaceDefineDao.loadDefineById(Long.valueOf(id));
        if (data != null) {
            if (Strings.isNotBlank((String)data.getSubType()) && !MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(data.getSubType()) && !MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(data.getSubType())) {
                return MagicPrivateUtils.convertForNotForm(data, type);
            }
            return MagicPrivateUtils.convert(this.magicServiceSummaryDao.loadServiceInfo(data.getBusinessId(), data.getVersionId()), data);
        }
        throw new BusinessException("\u6ca1\u6709\u627e\u5230 ID=[" + id + "]\u7684\u4e1a\u52a1\u65b9\u6cd5!");
    }

    @Override
    @AjaxAccess
    public MagicServiceDetail getServiceDetailById(String id) throws BusinessException {
        return this.cap4MagicManager.getServiceDetailById(id);
    }

    @Override
    @AjaxAccess
    public Map<String, Object> installExternal(Map<String, Object> params) throws BusinessException {
        try {
            Long fileId = ParamUtil.getLong(params, (String)"fileUrl", (Long)0L);
            V3XFile importFile = this.fileManager.getV3XFile(fileId);
            File file = this.fileManager.getFile(fileId);
            if (importFile == null || file == null || !file.exists()) {
                throw new BusinessException("\u627e\u4e0d\u5230\u6307\u5b9a\u6587\u4ef6\uff01");
            }
            ((IMagicExternalExportManager)((Object)this.magicExternalExportManager)).installExternalService(file, params, true);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return null;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public ICAP4MagicManager getCap4MagicManager() {
        return this.cap4MagicManager;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public IMagicExportManager getMagicExternalExportManager() {
        return this.magicExternalExportManager;
    }

    public void setMagicExternalExportManager(IMagicExportManager magicExternalExportManager) {
        this.magicExternalExportManager = magicExternalExportManager;
    }

    public MagicProviderExecuteManager getMagicExternalExceuteManager() {
        return this.magicExternalExceuteManager;
    }

    public void setMagicExternalExceuteManager(MagicProviderExecuteManager magicExternalExceuteManager) {
        this.magicExternalExceuteManager = magicExternalExceuteManager;
    }

    public void setMallApi(MallApi mallApi) {
        this.mallApi = mallApi;
    }
}

