/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.bind;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.magic.business.bind.IMagicBusinessBindService;
import com.seeyon.cap4.magic.compiler.IMagicCompilerManager;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.mapping.ArgumentMappingConfig;
import com.seeyon.datamagic.engine.domain.mapping.MethodMappingConfig;
import com.seeyon.datamagic.engine.domain.mapping.ReturnAttrMappingConfig;
import com.seeyon.datamagic.engine.domain.metadata.MetadataConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceArgumentConfig;
import com.seeyon.datamagic.engine.utils.PrivateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.jgroups.util.UUID;

public class MagicBindInternalServiceManager
implements IMagicBusinessBindService {
    private CAP4FormCacheManager cap4FormCacheManager;
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private static final Log LOGGER = CtpLogFactory.getLog(MagicBindInternalServiceManager.class);
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private IMagicCompilerManager magicCompilerManager;

    @Override
    public String getBindType() {
        return MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey();
    }

    @Override
    public MagicReflectionRelationPO bindRelation(MagicServiceSummary serviceSummary, FormRelationshipBean shipBean, FormRelationshipMapBean shipMapBean, MagicInterfaceDefineEntity entity, boolean generate) throws BusinessException {
        LinkedHashSet<String> deWeight = new LinkedHashSet<String>();
        int relationType = shipBean.getRelationType();
        Long sourceId = shipBean.getSourceFormId();
        Long shipBeanId = shipBean.getId();
        List showFieldList = shipMapBean.getShowFieldList();
        if (showFieldList != null && !showFieldList.isEmpty()) {
            for (SimpleObjectBean temp : showFieldList) {
                Object name = temp.getName();
                if (((String)name).contains(".")) {
                    name = ((String)name).split("[.]")[1];
                }
                deWeight.add((String)name);
            }
        }
        String selectedField = "";
        Map relationFieldMap = shipMapBean.getFormRelationFieldMap();
        for (Map.Entry temp : relationFieldMap.entrySet()) {
            String v = (String)temp.getValue();
            deWeight.add(v);
        }
        MethodMappingConfig mc = null;
        if (relationType == FormRelationEnums.ViewSelectType.user.getKey()) {
            selectedField = shipMapBean.getSelectedField();
            mc = this.incisionUserRelation4Mapping(entity.getMethodName(), "getRelationDatas", deWeight);
        } else if (relationType == FormRelationEnums.ViewSelectType.auto_increase_row.getKey()) {
            selectedField = FormRelationEnums.ViewSelectType.auto_increase_row.name();
            mc = this.incisionUserRelation4Mapping(entity.getMethodName(), "getRelationDatas", deWeight);
        } else {
            selectedField = String.valueOf(shipMapBean.getConditionFormulaId());
            Map condtionMap = FormUtil.getRelationFormulaFieldMap((FormFormulaBean)shipMapBean.getConditionFormula());
            mc = this.incisionSysRelation4Mapping(entity.getMethodName(), "getRelationDatas", deWeight, condtionMap);
        }
        MagicReflectionRelationPO reflectionRelation = new MagicReflectionRelationPO();
        reflectionRelation.setVersionId(MagicPrivateUtils.getSeeyonRelationVid());
        reflectionRelation.setBusinessId(MagicPrivateUtils.getSeeyonRelationBid());
        reflectionRelation.setCalleeBusinessId(entity.getBusinessId());
        reflectionRelation.setCalleeVersionId(entity.getVersionId());
        reflectionRelation.setCreateDate(new Date());
        reflectionRelation.setDynamicInvokeToken("");
        reflectionRelation.setFormId(sourceId.longValue());
        reflectionRelation.setInvokeSort(0);
        reflectionRelation.setCallingType(entity.getServiceType());
        reflectionRelation.setIdIfNew();
        ArrayList<MethodMappingConfig> mmcs = new ArrayList<MethodMappingConfig>();
        mmcs.add(mc);
        reflectionRelation.setMappingConfig(JSONUtils.getJSonString(mmcs));
        reflectionRelation.setCallingPoint(shipBeanId + "_" + selectedField);
        reflectionRelation.setIdentifier(PrivateUtils.generateMD5((String)UUID.randomUUID().toString()));
        if (generate) {
            this.magicCompilerManager.generateByRelation(reflectionRelation);
        }
        return reflectionRelation;
    }

    @Override
    public MagicReflectionRelationPO bindTrigger(MagicServiceSummary serviceSummary, FormTriggerBean triggerBean, FormTriggerActionBean actionBean, MagicInterfaceDefineEntity entity, boolean generate) throws BusinessException {
        if (entity == null) {
            return null;
        }
        int serviceType = entity.getServiceType();
        MagicEnums.BusinessMethodType st = MagicEnums.BusinessMethodType.valueOfType((int)serviceType);
        if (st == null) {
            return null;
        }
        MethodMappingConfig methodMappingConfig = null;
        ArrayList<MethodMappingConfig> mmcs = new ArrayList<MethodMappingConfig>();
        FormBean sourceBean = this.cap4FormCacheManager.getForm(actionBean.getFormTriggerBean().getSourceFormId());
        switch (st) {
            case TRIGGER_CREATE: {
                methodMappingConfig = this.setCreateMapping4Interface(serviceSummary, entity, sourceBean, actionBean);
                break;
            }
            case TRIGGER_UPDATE: {
                methodMappingConfig = this.setUpdateMapping4Interface(entity, sourceBean, actionBean);
                String queryMethodName = "m" + PrivateUtils.generateMD5((String)entity.getBusinessId());
                MagicInterfaceDefineEntity queryEntity = this.magicInterfaceDefineDao.loadDefineById(entity.getBusinessId(), entity.getVersionId(), queryMethodName);
                if (queryEntity == null) {
                    queryEntity = MagicPrivateUtils.setQueryInterfaceDefine(entity.getBusinessId(), entity.getVersionId());
                    this.magicInterfaceDefineDao.saveDefine(queryEntity);
                }
                MethodMappingConfig queryMC = MagicPrivateUtils.setQueryMapping4Interface(entity, queryEntity, actionBean, sourceBean, this.getCap4FormCacheManager());
                mmcs.add(queryMC);
                break;
            }
            case TRIGGER_DISTRIBUTE: {
                methodMappingConfig = this.setCreateMapping4Interface(serviceSummary, entity, sourceBean, actionBean);
                methodMappingConfig.setStandardMethodName("triggerDistribute");
                Map ext = (Map)JSONUtil.parseJSONString((String)entity.getExt1(), Map.class);
                String feedBackName = ParamUtil.getString((Map)ext, (String)"feedback_id", (String)"");
                MagicInterfaceDefineEntity queryEntity1 = this.magicInterfaceDefineDao.loadDefineById(entity.getBusinessId(), entity.getVersionId(), feedBackName);
                this.setFeedBackM4Interface(queryEntity1, sourceBean, actionBean);
            }
        }
        if (methodMappingConfig != null) {
            mmcs.add(methodMappingConfig);
        }
        actionBean.addParam("businessId", (Object)entity.getBusinessId());
        actionBean.addParam("versionId", (Object)entity.getVersionId());
        actionBean.addParam("methodName", (Object)entity.getMethodName());
        MagicReflectionRelationPO reflectionRelation = new MagicReflectionRelationPO();
        reflectionRelation.setVersionId(MagicPrivateUtils.getSeeyonRelationVid());
        reflectionRelation.setBusinessId(MagicPrivateUtils.getSeeyonRelationBid());
        reflectionRelation.setCalleeBusinessId(entity.getBusinessId());
        reflectionRelation.setCalleeVersionId(entity.getVersionId());
        reflectionRelation.setCallingPoint(actionBean.getFormTriggerBean().getId() + "_" + actionBean.getId());
        reflectionRelation.setCreateDate(new Date());
        reflectionRelation.setDynamicInvokeToken("");
        reflectionRelation.setFormId(actionBean.getFormTriggerBean().getSourceFormId());
        reflectionRelation.setInvokeSort(0);
        reflectionRelation.setIdIfNew();
        reflectionRelation.setMappingConfig(JSONUtils.getJSonString(mmcs));
        reflectionRelation.setCallingType(entity.getServiceType());
        reflectionRelation.setIdentifier(PrivateUtils.generateMD5((String)UUID.randomUUID().toString()));
        this.magicReflectionRelationDao.save(reflectionRelation);
        if (generate) {
            this.magicCompilerManager.generateByRelation(reflectionRelation);
        }
        return reflectionRelation;
    }

    private MethodMappingConfig incisionSysRelation4Mapping(String methodName, String seeyonMethodName, Collection<String> deWeight, Map<String, String> condtionMap) {
        deWeight.addAll(condtionMap.values());
        MethodMappingConfig config = this.incisionUserRelation4Mapping(methodName, seeyonMethodName, deWeight);
        return config;
    }

    private MethodMappingConfig incisionSysRelation4Mapping(FormBean fb, String methodName, String seeyonMethodName, Collection<String> deWeight, Map<String, String> condtionMap) {
        MethodMappingConfig config = this.incisionUserRelation4Mapping(methodName, seeyonMethodName, deWeight);
        return config;
    }

    private MagicReflectionRelationPO setFeedBackM4Interface(MagicInterfaceDefineEntity entity, FormBean sourceFormBean, FormTriggerActionBean triggerBean) throws BusinessException {
        MethodMappingConfig result = new MethodMappingConfig();
        result.setMethodName(entity.getMethodName());
        result.setStandardMethodName("triggerFeedBack");
        ReturnAttrMappingConfig aReturnMapping = new ReturnAttrMappingConfig();
        result.setReturnMapping(aReturnMapping);
        List feedBackList = (List)triggerBean.getParam(FormTriggerBean.ActionParam.FeedBack.getKey());
        if (feedBackList != null) {
            for (SimpleObjectBean temp : feedBackList) {
                ArgumentMappingConfig subsM;
                boolean isMasterField;
                String value = temp.getValue();
                String[] valueArray = value.split("[.]");
                ArgumentMappingConfig subMapping = new ArgumentMappingConfig();
                boolean bl = isMasterField = value.startsWith(Enums.TableType.MASTER.getTableSufName());
                if (isMasterField) {
                    subMapping.setArgumentName("masterData");
                    subMapping.setStandardArgsName("masterData");
                    subsM = new ArgumentMappingConfig();
                    subsM.setArgumentName(valueArray[1]);
                    subsM.setStandardArgsName(valueArray[1]);
                    subsM.setSubAttrMapping(MagicPrivateUtils.getFeedBackSubMapping());
                    subMapping.addMapping(subsM);
                } else {
                    subMapping.setArgumentName("subTableDataList");
                    subMapping.setStandardArgsName("subTableDataList");
                    subsM = new ArgumentMappingConfig();
                    subsM.setArgumentName(valueArray[0]);
                    subsM.setStandardArgsName(valueArray[0]);
                    ArgumentMappingConfig fieldMapp = new ArgumentMappingConfig();
                    fieldMapp.setArgumentName(valueArray[1]);
                    fieldMapp.setStandardArgsName(valueArray[1]);
                    fieldMapp.setSubAttrMapping(MagicPrivateUtils.getFeedBackSubMapping());
                    subsM.addMapping(fieldMapp);
                    subMapping.addMapping(subsM);
                }
                aReturnMapping.addMapping(subMapping);
            }
        }
        ArgumentMappingConfig recordId = new ArgumentMappingConfig();
        recordId.setArgumentName("dataId");
        recordId.setStandardArgsName("dataId");
        result.addArgsMapping(recordId);
        ArgumentMappingConfig rightId = new ArgumentMappingConfig();
        rightId.setStandardArgsName("dataRight");
        rightId.setArgumentName("dataRight");
        result.addArgsMapping(rightId);
        MagicReflectionRelationPO po = new MagicReflectionRelationPO();
        po.setIdIfNew();
        po.setBusinessId(MagicPrivateUtils.getSeeyonRelationBid());
        po.setVersionId(MagicPrivateUtils.getSeeyonRelationVid());
        po.setCalleeBusinessId(entity.getBusinessId());
        po.setCalleeVersionId(entity.getVersionId());
        ArrayList<MethodMappingConfig> methodMappingList = new ArrayList<MethodMappingConfig>();
        methodMappingList.add(result);
        po.setMappingConfig(JSONUtils.getJSonString(methodMappingList));
        po.setIdentifier(PrivateUtils.generateMD5((String)UUID.randomUUID().toString()));
        po.setCallingPoint(triggerBean.getFormTriggerBean().getId() + "_" + triggerBean.getId());
        po.setCreateDate(new Date());
        po.setDynamicInvokeToken("");
        po.setFormId(triggerBean.getFormTriggerBean().getSourceFormId());
        po.setCallingType(entity.getServiceType());
        this.magicReflectionRelationDao.save(po);
        this.magicCompilerManager.generateByRelation(po);
        return po;
    }

    private MethodMappingConfig incisionUserRelation4Mapping(String methodName, String seeyonMethodName, Collection<String> deWeight) {
        MethodMappingConfig mc = new MethodMappingConfig();
        ArgumentMappingConfig condtion = new ArgumentMappingConfig();
        condtion.setArgumentName("condition");
        condtion.setStandardArgsName("condition");
        ArgumentMappingConfig subTalbeName = new ArgumentMappingConfig();
        subTalbeName.setArgumentName("aliasTableName");
        subTalbeName.setStandardArgsName("aliasTableName");
        condtion.addMapping(subTalbeName);
        ArgumentMappingConfig rowOp = new ArgumentMappingConfig();
        rowOp.setArgumentName("rowOperation");
        rowOp.setStandardArgsName("rowOperation");
        condtion.addMapping(rowOp);
        ArgumentMappingConfig fieldName = new ArgumentMappingConfig();
        fieldName.setArgumentName("fieldName");
        fieldName.setStandardArgsName("fieldName");
        condtion.addMapping(fieldName);
        ArgumentMappingConfig rightChar = new ArgumentMappingConfig();
        rightChar.setArgumentName("rightChar");
        rightChar.setStandardArgsName("rightChar");
        condtion.addMapping(rightChar);
        ArgumentMappingConfig leftChar = new ArgumentMappingConfig();
        leftChar.setArgumentName("leftChar");
        leftChar.setStandardArgsName("leftChar");
        condtion.addMapping(leftChar);
        ArgumentMappingConfig operation = new ArgumentMappingConfig();
        operation.setArgumentName("operation");
        operation.setStandardArgsName("operation");
        condtion.addMapping(operation);
        ArgumentMappingConfig fieldValue = new ArgumentMappingConfig();
        fieldValue.setArgumentName("fieldValue");
        fieldValue.setStandardArgsName("fieldValue");
        condtion.addMapping(fieldValue);
        mc.addArgsMapping(condtion);
        ArgumentMappingConfig dataIdSubMapping = new ArgumentMappingConfig();
        dataIdSubMapping.setArgumentName("selectedToMasterDataId");
        dataIdSubMapping.setStandardArgsName("selectedToMasterDataId");
        mc.addArgsMapping(dataIdSubMapping);
        ArgumentMappingConfig amcPage = new ArgumentMappingConfig();
        amcPage.setArgumentName("page");
        amcPage.setStandardArgsName("page");
        mc.addArgsMapping(amcPage);
        ArgumentMappingConfig amcPageSize = new ArgumentMappingConfig();
        amcPageSize.setArgumentName("pageSize");
        amcPageSize.setStandardArgsName("pageSize");
        mc.addArgsMapping(amcPageSize);
        ReturnAttrMappingConfig aReturnMapping = new ReturnAttrMappingConfig();
        ArgumentMappingConfig total = new ArgumentMappingConfig();
        total.setArgumentName("total");
        total.setStandardArgsName("total");
        aReturnMapping.addMapping(total);
        ArgumentMappingConfig targetId = new ArgumentMappingConfig();
        targetId.setArgumentName("targetFormId");
        targetId.setStandardArgsName("targetFormId");
        aReturnMapping.addMapping(targetId);
        ArgumentMappingConfig targetType = new ArgumentMappingConfig();
        targetType.setArgumentName("targetFormType");
        targetType.setStandardArgsName("targetFormType");
        aReturnMapping.addMapping(targetType);
        ArgumentMappingConfig datam = new ArgumentMappingConfig();
        datam.setArgumentName("data");
        datam.setStandardArgsName("data");
        for (String key : deWeight) {
            ArgumentMappingConfig subDatam = new ArgumentMappingConfig();
            subDatam.setArgumentName(key);
            subDatam.setStandardArgsName(key);
            ArgumentMappingConfig subvalue = new ArgumentMappingConfig();
            subvalue.setArgumentName("value");
            subvalue.setStandardArgsName("value");
            subDatam.addMapping(subvalue);
            ArgumentMappingConfig subshowvalue = new ArgumentMappingConfig();
            subshowvalue.setArgumentName("showValue");
            subshowvalue.setStandardArgsName("showValue");
            subDatam.addMapping(subshowvalue);
            ArgumentMappingConfig subshowvalue2 = new ArgumentMappingConfig();
            subshowvalue2.setArgumentName("showValue2");
            subshowvalue2.setStandardArgsName("showValue2");
            subDatam.addMapping(subshowvalue2);
            ArgumentMappingConfig subdisplay = new ArgumentMappingConfig();
            subdisplay.setArgumentName("display");
            subdisplay.setStandardArgsName("display");
            subDatam.addMapping(subdisplay);
            ArgumentMappingConfig subisAttach = new ArgumentMappingConfig();
            subisAttach.setArgumentName("isAttach");
            subisAttach.setStandardArgsName("isAttach");
            subDatam.addMapping(subisAttach);
            ArgumentMappingConfig subenums = new ArgumentMappingConfig();
            subenums.setArgumentName("enums");
            subenums.setStandardArgsName("enums");
            subDatam.addMapping(subenums);
            ArgumentMappingConfig subattachments = new ArgumentMappingConfig();
            subattachments.setArgumentName("attachments");
            subattachments.setStandardArgsName("attachments");
            subDatam.addMapping(subattachments);
            ArgumentMappingConfig ids = new ArgumentMappingConfig();
            subattachments.setArgumentName("id");
            subattachments.setStandardArgsName("id");
            subDatam.addMapping(ids);
            ArgumentMappingConfig subIds = new ArgumentMappingConfig();
            subIds.setArgumentName("subDataId");
            subIds.setStandardArgsName("subDataId");
            subDatam.addMapping(subIds);
            datam.addMapping(subDatam);
        }
        aReturnMapping.addMapping(datam);
        mc.setReturnMapping(aReturnMapping);
        mc.setStandardMethodName(seeyonMethodName);
        mc.setMethodName(methodName);
        return mc;
    }

    private MethodMappingConfig setUpdateMapping4Interface(MagicInterfaceDefineEntity entity, FormBean sourceFormBean, FormTriggerActionBean triggerBean) {
        MethodMappingConfig mmc = new MethodMappingConfig();
        String aMethodName = entity.getMethodName();
        ArgumentMappingConfig argsMapping = new ArgumentMappingConfig();
        mmc.addArgsMapping(argsMapping);
        argsMapping.setArgumentName("formData");
        argsMapping.setStandardArgsName("formData");
        List fillBackList = (List)triggerBean.getParam(FormTriggerBean.ActionParam.FillBack.getKey());
        List withHoldingFields = triggerBean.getWithHoldingFields();
        LinkedList<SimpleObjectBean> allFillBackList = new LinkedList<SimpleObjectBean>();
        allFillBackList.addAll(fillBackList);
        block0: for (SimpleObjectBean hold : withHoldingFields) {
            for (SimpleObjectBean fill : fillBackList) {
                if (!fill.getName().equals(hold.getValue())) continue;
                SimpleObjectBean s = new SimpleObjectBean();
                s.setDisplay(fill.getDisplay());
                s.setIdIfNew();
                s.setName(hold.getName());
                s.setPhoneValue(fill.getPhoneValue());
                s.setType(fill.getType());
                s.setValue(fill.getValue());
                allFillBackList.add(s);
                continue block0;
            }
        }
        for (SimpleObjectBean fill : allFillBackList) {
            ArgumentMappingConfig subsM;
            String name = fill.getName();
            String[] nameArray = name.split("[.]");
            boolean isMasterField = name.startsWith(Enums.TableType.MASTER.getTableSufName());
            ArgumentMappingConfig subMapping = new ArgumentMappingConfig();
            if (isMasterField) {
                subMapping.setArgumentName(nameArray[1]);
                subMapping.setStandardArgsName("masterData");
                subsM = new ArgumentMappingConfig();
                subsM.setArgumentName(nameArray[1]);
                subsM.setStandardArgsName((String)nameArray[1]);
                subMapping.addMapping(subsM);
            } else {
                subMapping.setArgumentName(nameArray[0]);
                subMapping.setStandardArgsName("subTableDataList");
                subsM = new ArgumentMappingConfig();
                subsM.setArgumentName(nameArray[0]);
                subsM.setStandardArgsName((String)nameArray[0]);
                ArgumentMappingConfig fieldMapp = new ArgumentMappingConfig();
                fieldMapp.setArgumentName((String)nameArray[1]);
                fieldMapp.setStandardArgsName((String)nameArray[1]);
                ArgumentMappingConfig sourceDataIdM = new ArgumentMappingConfig();
                sourceDataIdM.setArgumentName("sourceDataId");
                sourceDataIdM.setStandardArgsName("sourceDataId");
                subsM.addMapping(sourceDataIdM);
                subsM.addMapping(fieldMapp);
                subMapping.addMapping(subsM);
            }
            argsMapping.addMapping(subMapping);
        }
        ArgumentMappingConfig createMapping = new ArgumentMappingConfig();
        createMapping.setArgumentName("createUserId");
        createMapping.setStandardArgsName("createUserId");
        argsMapping.addMapping(createMapping);
        ArgumentMappingConfig sourceDataIdM = new ArgumentMappingConfig();
        sourceDataIdM.setArgumentName("sourceDataId");
        sourceDataIdM.setStandardArgsName("sourceDataId");
        argsMapping.addMapping(sourceDataIdM);
        ArrayList argsList = new ArrayList();
        JSONUtils.parseJSonListObj_Class(entity.getArgsConfig(), argsList, ServiceArgumentConfig.class);
        for (ServiceArgumentConfig sac : argsList) {
            ArgumentMappingConfig subMaping;
            if ("formData".equals(sac.getArgsName())) continue;
            if ("newline".equals(sac.getArgsName())) {
                ArgumentMappingConfig newlineMapping = new ArgumentMappingConfig();
                newlineMapping.setArgumentName("newline");
                newlineMapping.setStandardArgsName("configItem");
                ArgumentMappingConfig subNewlineMaping = new ArgumentMappingConfig();
                subNewlineMaping.setArgumentName("newline");
                subNewlineMaping.setStandardArgsName("newline");
                newlineMapping.addMapping(subNewlineMaping);
                mmc.addArgsMapping(newlineMapping);
                continue;
            }
            if ("remindUser".equals(sac.getArgsName())) {
                ArgumentMappingConfig remindUserMapping = new ArgumentMappingConfig();
                remindUserMapping.setArgumentName("remindUser");
                remindUserMapping.setStandardArgsName("configItem");
                ArgumentMappingConfig remindUserSubMaping = new ArgumentMappingConfig();
                remindUserSubMaping.setArgumentName("remindUser");
                remindUserSubMaping.setStandardArgsName("remindUser");
                remindUserMapping.addMapping(remindUserSubMaping);
                mmc.addArgsMapping(remindUserMapping);
                continue;
            }
            if ("dataRight".equals(sac.getArgsName())) {
                ArgumentMappingConfig dataRightMapping = new ArgumentMappingConfig();
                dataRightMapping.setArgumentName("dataRight");
                dataRightMapping.setStandardArgsName("configItem");
                subMaping = new ArgumentMappingConfig();
                subMaping.setArgumentName("dataRight");
                subMaping.setStandardArgsName("dataRight");
                dataRightMapping.addMapping(subMaping);
                mmc.addArgsMapping(dataRightMapping);
                continue;
            }
            if ("template".equals(sac.getArgsName())) {
                ArgumentMappingConfig tempalteMapping = new ArgumentMappingConfig();
                tempalteMapping.setArgumentName("template");
                tempalteMapping.setStandardArgsName("configItem");
                subMaping = new ArgumentMappingConfig();
                subMaping.setArgumentName("template");
                subMaping.setStandardArgsName("template");
                tempalteMapping.addMapping(subMaping);
                mmc.addArgsMapping(tempalteMapping);
                continue;
            }
            if (!"fromDataId".equals(sac.getArgsName())) continue;
            ArgumentMappingConfig fromDataIdMapping = new ArgumentMappingConfig();
            fromDataIdMapping.setArgumentName("fromDataId");
            fromDataIdMapping.setStandardArgsName("configItem");
            ArgumentMappingConfig fromSubMapping = new ArgumentMappingConfig();
            fromSubMapping.setArgumentName("fromDataId");
            fromSubMapping.setStandardArgsName("fromDataId");
            fromDataIdMapping.addMapping(fromSubMapping);
            mmc.addArgsMapping(fromDataIdMapping);
        }
        mmc.setMethodName(aMethodName);
        mmc.setStandardMethodName("triggerUpdate");
        ReturnAttrMappingConfig aReturnMapping = new ReturnAttrMappingConfig();
        ArgumentMappingConfig returnConfigData = new ArgumentMappingConfig();
        returnConfigData.setArgumentName("dataId");
        returnConfigData.setStandardArgsName("dataId");
        aReturnMapping.addMapping(returnConfigData);
        ArgumentMappingConfig returnConfigSuccess = new ArgumentMappingConfig();
        returnConfigSuccess.setArgumentName("success");
        returnConfigSuccess.setStandardArgsName("success");
        aReturnMapping.addMapping(returnConfigSuccess);
        ArgumentMappingConfig returnConfigMsg = new ArgumentMappingConfig();
        returnConfigMsg.setArgumentName("msg");
        returnConfigMsg.setStandardArgsName("msg");
        aReturnMapping.addMapping(returnConfigMsg);
        mmc.setReturnMapping(aReturnMapping);
        return mmc;
    }

    private MethodMappingConfig setCreateMapping4Interface(MagicServiceSummary serviceSummary, MagicInterfaceDefineEntity entity, FormBean sourceBean, FormTriggerActionBean triggerActionBean) {
        MethodMappingConfig mmc = new MethodMappingConfig();
        String aMethodName = entity.getMethodName();
        ArrayList argsList = new ArrayList();
        ArrayList objList = new ArrayList();
        String objListStr = serviceSummary.getMetadata();
        JSONUtils.parseJSonListObj_Class(objListStr, objList, MetadataConfig.class);
        JSONUtils.parseJSonListObj_Class(entity.getArgsConfig(), argsList, ServiceArgumentConfig.class);
        ArgumentMappingConfig argsMapping = new ArgumentMappingConfig();
        mmc.addArgsMapping(argsMapping);
        argsMapping.setArgumentName("formData");
        argsMapping.setStandardArgsName("formData");
        for (Object sac : argsList) {
            ArgumentMappingConfig subMaping;
            if ("template".equals(sac.getArgsName())) {
                ArgumentMappingConfig templateMapping = new ArgumentMappingConfig();
                templateMapping.setArgumentName("template");
                templateMapping.setStandardArgsName("configItem");
                subMaping = new ArgumentMappingConfig();
                subMaping.setArgumentName("template");
                subMaping.setStandardArgsName("template");
                templateMapping.addMapping(subMaping);
                mmc.addArgsMapping(templateMapping);
                continue;
            }
            if (!"dataRight".equals(sac.getArgsName())) continue;
            ArgumentMappingConfig dataRightMapping = new ArgumentMappingConfig();
            dataRightMapping.setArgumentName("dataRight");
            dataRightMapping.setStandardArgsName("configItem");
            subMaping = new ArgumentMappingConfig();
            subMaping.setArgumentName("dataRight");
            subMaping.setStandardArgsName("dataRight");
            dataRightMapping.addMapping(subMaping);
            mmc.addArgsMapping(dataRightMapping);
        }
        List fillBackList = (List)triggerActionBean.getParam(FormTriggerBean.ActionParam.FillBack.getKey());
        for (SimpleObjectBean fill : fillBackList) {
            ArgumentMappingConfig dataIdM;
            ArgumentMappingConfig fieldMapp;
            ArgumentMappingConfig subsM;
            boolean isMasterField;
            String name = fill.getName();
            String[] nameArray = name.split("[.]");
            String value = fill.getValue();
            FormFieldBean sourceField = sourceBean.getFieldBeanByName(value.split("[.]")[1]);
            if (sourceField == null) continue;
            ArgumentMappingConfig subMapping = new ArgumentMappingConfig();
            boolean bl = isMasterField = name.startsWith(Enums.TableType.MASTER.getTableSufName());
            if (isMasterField && sourceField.isMasterField()) {
                subMapping.setArgumentName(nameArray[1]);
                subMapping.setStandardArgsName("masterData");
                subsM = new ArgumentMappingConfig();
                subsM.setArgumentName(nameArray[1]);
                subsM.setStandardArgsName(sourceField.getName());
                subMapping.addMapping(subsM);
            } else if (isMasterField && !sourceField.isMasterField()) {
                subMapping.setArgumentName(nameArray[1]);
                subMapping.setStandardArgsName("subTableDataList");
                subsM = new ArgumentMappingConfig();
                subsM.setArgumentName(nameArray[1]);
                subsM.setStandardArgsName(sourceField.getOwnerTableName());
                fieldMapp = new ArgumentMappingConfig();
                fieldMapp.setArgumentName(nameArray[1]);
                fieldMapp.setStandardArgsName(sourceField.getName());
                dataIdM = new ArgumentMappingConfig();
                dataIdM.setArgumentName("sourceDataId");
                dataIdM.setStandardArgsName("sourceDataId");
                subsM.addMapping(dataIdM);
                subsM.addMapping(fieldMapp);
                subMapping.addMapping(subsM);
            } else if (!isMasterField && !sourceField.isMasterField()) {
                subMapping.setArgumentName(nameArray[0]);
                subMapping.setStandardArgsName("subTableDataList");
                subsM = new ArgumentMappingConfig();
                subsM.setArgumentName(nameArray[0]);
                subsM.setStandardArgsName(sourceField.getOwnerTableName());
                fieldMapp = new ArgumentMappingConfig();
                fieldMapp.setArgumentName(nameArray[1]);
                fieldMapp.setStandardArgsName(sourceField.getName());
                dataIdM = new ArgumentMappingConfig();
                dataIdM.setArgumentName("sourceDataId");
                dataIdM.setStandardArgsName("sourceDataId");
                subsM.addMapping(dataIdM);
                subsM.addMapping(fieldMapp);
                subMapping.addMapping(subsM);
            } else {
                subMapping.setArgumentName(nameArray[0]);
                subMapping.setStandardArgsName("masterData");
                subsM = new ArgumentMappingConfig();
                subsM.setArgumentName(nameArray[1]);
                subsM.setStandardArgsName(sourceField.getName());
                ArgumentMappingConfig dataIdM2 = new ArgumentMappingConfig();
                dataIdM2.setArgumentName("sourceDataId");
                dataIdM2.setStandardArgsName("sourceDataId");
                subMapping.addMapping(dataIdM2);
                subMapping.addMapping(subsM);
            }
            argsMapping.addMapping(subMapping);
        }
        ArgumentMappingConfig createMapping = new ArgumentMappingConfig();
        createMapping.setArgumentName("createUserId");
        createMapping.setStandardArgsName("createUserId");
        argsMapping.addMapping(createMapping);
        ArgumentMappingConfig sourceDataIdM = new ArgumentMappingConfig();
        sourceDataIdM.setArgumentName("sourceDataId");
        sourceDataIdM.setStandardArgsName("sourceDataId");
        argsMapping.addMapping(sourceDataIdM);
        mmc.setMethodName(aMethodName);
        mmc.setStandardMethodName("triggerCreate");
        ReturnAttrMappingConfig aReturnMapping = new ReturnAttrMappingConfig();
        ArgumentMappingConfig returnConfigData = new ArgumentMappingConfig();
        returnConfigData.setArgumentName("dataId");
        returnConfigData.setStandardArgsName("dataId");
        aReturnMapping.addMapping(returnConfigData);
        ArgumentMappingConfig returnConfigSuccess = new ArgumentMappingConfig();
        returnConfigSuccess.setArgumentName("success");
        returnConfigSuccess.setStandardArgsName("success");
        aReturnMapping.addMapping(returnConfigSuccess);
        ArgumentMappingConfig returnConfigMsg = new ArgumentMappingConfig();
        returnConfigMsg.setArgumentName("msg");
        returnConfigMsg.setStandardArgsName("msg");
        aReturnMapping.addMapping(returnConfigMsg);
        mmc.setReturnMapping(aReturnMapping);
        return mmc;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicCompilerManager getMagicCompilerManager() {
        return this.magicCompilerManager;
    }

    public void setMagicCompilerManager(IMagicCompilerManager magicCompilerManager) {
        this.magicCompilerManager = magicCompilerManager;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }
}

