/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.bind;

import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.magic.business.bind.IMagicBindServicesHandle;
import com.seeyon.cap4.magic.business.bind.IMagicBusinessBindService;
import com.seeyon.cap4.magic.compiler.IMagicCompilerManager;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.initializer.CAP4MagicCacheInitializer;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.ParamUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MagicBindServicesHandleImpl
implements IMagicBindServicesHandle {
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private IMagicCompilerManager magicCompilerManager;
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private IMagicServiceSummaryDao magicServiceSummaryDao;

    @Override
    public List<MagicReflectionRelationPO> handleRealtionShip(FormRelationshipBean ships, boolean generate) throws BusinessException {
        List relationShipMapBeans = ships.getRelationMapList();
        ArrayList<MagicReflectionRelationPO> allRelations = new ArrayList<MagicReflectionRelationPO>();
        for (FormRelationshipMapBean s : relationShipMapBeans) {
            IMagicBusinessBindService bindServices;
            Map params = s.getParams();
            String businessId = ParamUtil.getString((Map)params, (String)"businessId", (String)"");
            String version = ParamUtil.getString((Map)params, (String)"versionId", (String)"");
            String methodName = ParamUtil.getString((Map)params, (String)"methodName", (String)"");
            MagicInterfaceDefineEntity entry = this.magicInterfaceDefineDao.loadDefineById(businessId, version, methodName);
            MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(entry.getBusinessId(), entry.getVersionId());
            MagicEnums.BusinessType type = MagicEnums.BusinessType.INTERNAL_BUSINESS;
            if (serviceSummary != null) {
                type = MagicEnums.BusinessType.valueOfType((String)serviceSummary.getBusinessType());
            }
            if ((bindServices = CAP4MagicCacheInitializer.getBindService(type == null ? MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey() : type.getKey())) != null) {
                MagicReflectionRelationPO mmc = bindServices.bindRelation(serviceSummary, ships, s, entry, false);
                allRelations.add(mmc);
            }
            if (serviceSummary == null || ships.getRelationType() != FormRelationEnums.ViewSelectType.system.getKey()) continue;
            if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(serviceSummary.getOwnerType())) {
                ships.setTargetFormVersion(MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType());
                continue;
            }
            if (!MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(serviceSummary.getOwnerType())) continue;
            ships.setTargetFormVersion(MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType());
        }
        this.magicReflectionRelationDao.deleteByActionOrShipId(String.valueOf(ships.getId()));
        this.magicReflectionRelationDao.saveAll(allRelations);
        if (generate) {
            this.magicCompilerManager.generateByRelations(allRelations);
        }
        return allRelations;
    }

    @Override
    public MagicReflectionRelationPO handelTriggerBean(FormTriggerBean triggers, FormTriggerActionBean action, boolean generate) throws BusinessException {
        IMagicBusinessBindService bindServices;
        MagicReflectionRelationPO mmc = null;
        Map params = action.getParam();
        String businessId = ParamUtil.getString((Map)params, (String)"businessId", (String)"");
        String version = ParamUtil.getString((Map)params, (String)"versionId", (String)"");
        String methodName = ParamUtil.getString((Map)params, (String)"methodName", (String)"");
        MagicInterfaceDefineEntity entry = this.magicInterfaceDefineDao.loadDefineById(businessId, version, methodName);
        MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(entry.getBusinessId(), entry.getVersionId());
        MagicEnums.BusinessType type = MagicEnums.BusinessType.INTERNAL_BUSINESS;
        if (serviceSummary != null) {
            type = MagicEnums.BusinessType.valueOfType((String)serviceSummary.getBusinessType());
        }
        if ((bindServices = CAP4MagicCacheInitializer.getBindService(type == null ? MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey() : type.getKey())) != null) {
            mmc = bindServices.bindTrigger(serviceSummary, triggers, action, entry, false);
        }
        if (generate) {
            this.magicCompilerManager.generateByRelation(mmc);
        }
        return mmc;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicCompilerManager getMagicCompilerManager() {
        return this.magicCompilerManager;
    }

    public void setMagicCompilerManager(IMagicCompilerManager magicCompilerManager) {
        this.magicCompilerManager = magicCompilerManager;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }
}

