/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.create.impl;

import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.magic.business.IMagicAjaxHandleService;
import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.datamagic.engine.domain.base.MagicDisplay;
import com.seeyon.datamagic.engine.domain.config.ArgsConfigGuide;
import com.seeyon.datamagic.engine.domain.config.EntryAnnotation;
import com.seeyon.datamagic.engine.domain.config.EntryConfigItem;
import com.seeyon.datamagic.engine.domain.config.ResultConfigGuide;
import com.seeyon.datamagic.engine.domain.mapping.MethodMappingConfig;
import com.seeyon.datamagic.engine.domain.metadata.MetadataConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceArgumentConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractMagicHandleService {
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private IMagicProviderDao magicProviderDao;
    private BusinessManager businessManager4;
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private IMagicAjaxHandleService magicAjaxHandleService;
    private ICAP4MagicManager cap4MagicManager;
    private static Map<Long, MagicServiceSummary> cacheServiceSummary = new HashMap<Long, MagicServiceSummary>();
    private static Map<Long, List<MagicInterfaceDefineEntity>> cacheMethodList = new HashMap<Long, List<MagicInterfaceDefineEntity>>();

    protected Map<String, Object> absShowServiceInfo(MagicServiceSummary summary) throws BusinessException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("baseInfo", this.convertServiceSummary(summary));
        List<MagicInterfaceDefineEntity> methodList = this.magicInterfaceDefineDao.loadAllEntitys(summary.getBusinessId(), summary.getBusinessVersion());
        ArrayList<Map<String, Object>> showMethodList = new ArrayList<Map<String, Object>>(methodList.size());
        for (MagicInterfaceDefineEntity e : methodList) {
            Map<String, Object> methodInfo;
            if (e.getServiceType() == MagicEnums.BusinessMethodType.QUERY.getType() || e.getServiceType() == MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK.getType() || (methodInfo = this.convertMethodInfo(summary.getBusinessType(), e)).isEmpty()) continue;
            showMethodList.add(methodInfo);
        }
        List<MagicServiceProviderPO> allProviders = this.magicProviderDao.loadProviders(summary.getBusinessId(), summary.getBusinessVersion());
        ArrayList<Map<String, Object>> implList = new ArrayList<Map<String, Object>>(allProviders.size());
        for (MagicServiceProviderPO p : allProviders) {
            implList.add(MagicCreateServiceUtils.showServiceImplInfo(summary.getNameDisplay(), p));
        }
        data.put("methodInfo", showMethodList);
        data.put("implList", implList);
        return data;
    }

    protected Map<String, Object> onlyUpdateAuthInfo(MagicServiceSummary summary, Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int auth_type = ParamUtil.getInt(params, (String)"authType", (int)0);
        if (MagicEnums.ServiceAuthType.USERDEFINED.getKey() == auth_type) {
            List authInfo = (List)params.get("authInfo");
            if (authInfo != null && !authInfo.isEmpty()) {
                summary.setAuthorizationInfo(JSONUtils.getJSonString(authInfo));
            }
            summary.setAuthorizationType(Integer.valueOf(MagicEnums.ServiceAuthType.USERDEFINED.getKey()));
        } else {
            summary.setAuthorizationType(Integer.valueOf(auth_type));
        }
        this.magicServiceSummaryDao.update(summary);
        result.put("msg", ResourceUtil.getString((String)"cap.template.common.text.saveok"));
        result.put("success", "1");
        return result;
    }

    private Map<String, MagicInterfaceDefineEntity> getAllMethodMapper(String bid, String version) throws BusinessException {
        List<MagicInterfaceDefineEntity> allMethod = this.magicInterfaceDefineDao.loadAllEntitys(bid, version);
        HashMap<String, MagicInterfaceDefineEntity> methodMapper = new HashMap<String, MagicInterfaceDefineEntity>();
        for (MagicInterfaceDefineEntity e : allMethod) {
            methodMapper.put(e.getMethodName(), e);
        }
        return methodMapper;
    }

    protected void delete(MagicServiceSummary summary, Map<String, Object> params) throws BusinessException {
        if (summary != null) {
            Map<String, MagicInterfaceDefineEntity> methodMapper = this.getAllMethodMapper(summary.getBusinessId(), summary.getBusinessVersion());
            HashMap<String, MagicInterfaceDefineEntity> usedList = new HashMap<String, MagicInterfaceDefineEntity>();
            ArrayList existMethod = (ArrayList)params.get("existMethodList");
            if (existMethod == null) {
                existMethod = new ArrayList();
            }
            if (!existMethod.isEmpty()) {
                List methodList = (List)params.get("methodInfo");
                if (methodList != null && !methodList.isEmpty()) {
                    for (Map m : methodList) {
                        String methodName = ParamUtil.getString((Map)m, (String)"methodName", (String)"");
                        existMethod.remove(methodName);
                    }
                }
                List<MagicReflectionRelationPO> reflectionRelationPOS = this.magicReflectionRelationDao.getReflectionByCallId(summary.getBusinessId(), summary.getBusinessVersion());
                HashMap<String, String> usedMethodNameMapper = new HashMap<String, String>();
                Iterator iterator = reflectionRelationPOS.iterator();
                while (iterator.hasNext()) {
                    MagicReflectionRelationPO p = (MagicReflectionRelationPO)iterator.next();
                    int statistics = MagicCreateServiceUtils.invokeStatistics(p);
                    if (statistics < 1) continue;
                    ArrayList mmcList = new ArrayList();
                    JSONUtils.parseJSonListObj_Class(p.getMappingConfig(), mmcList, MethodMappingConfig.class);
                    for (MethodMappingConfig mmc : mmcList) {
                        usedMethodNameMapper.put(mmc.getMethodName(), mmc.getMethodName());
                    }
                }
                for (String m : existMethod) {
                    if (!usedMethodNameMapper.containsKey(m) || !methodMapper.containsKey(m)) continue;
                    usedList.put(m, methodMapper.get(m));
                }
            }
            if (!usedList.isEmpty()) {
                ArrayList<String> error = new ArrayList<String>(usedList.size());
                for (MagicInterfaceDefineEntity e : usedList.values()) {
                    error.add(e.getName());
                }
                String errors = ResourceUtil.getString((String)"cap.magic.tips.services.delete.error.invoke", (Object)Strings.join(error, (String)","));
                throw new BusinessException(errors);
            }
        }
    }

    protected MagicServiceSummary createServiceSummary(Long creater, Map<String, Object> params, String businessId, String version, Date createDate) {
        MagicServiceSummary result = new MagicServiceSummary();
        result.setIdIfNew();
        String displayName = ParamUtil.getString(params, (String)"displayName");
        result.setNameDisplay(displayName);
        String des = ParamUtil.getString(params, (String)"des");
        if (Strings.isNotBlank((String)des)) {
            result.setDescription(des);
        }
        result.setBusinessVersion(version);
        result.setBusinessId(businessId);
        result.setCreateId(creater);
        int auth_type = ParamUtil.getInt(params, (String)"authType", (int)0);
        if (MagicEnums.ServiceAuthType.USERDEFINED.getKey() == auth_type) {
            List authInfo = (List)params.get("authInfo");
            if (authInfo != null && !authInfo.isEmpty()) {
                result.setAuthorizationInfo(JSONUtils.getJSonString(authInfo));
            }
            result.setAuthorizationType(Integer.valueOf(MagicEnums.ServiceAuthType.USERDEFINED.getKey()));
        } else {
            result.setAuthorizationType(Integer.valueOf(auth_type));
        }
        String certificateType = ParamUtil.getString(params, (String)"certificateType", (String)MagicEnums.CertificateType.Private_certificate.getName());
        if (certificateType.equals(MagicEnums.CertificateType.Public_certificate.getName())) {
            result.setCertificateType(Integer.valueOf(MagicEnums.CertificateType.Public_certificate.getKey()));
        } else {
            result.setCertificateType(Integer.valueOf(MagicEnums.CertificateType.Private_certificate.getKey()));
        }
        String businessType = ParamUtil.getString(params, (String)"businessType", (String)MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey());
        result.setBusinessType(businessType);
        result.setCreateDate(createDate);
        result.setModifyDate(DateUtil.currentDate());
        return result;
    }

    protected List<Map<String, Object>> getArgsSet(List<Map<String, Object>> args, String argsName) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> argsItem : args) {
            String argsItemName = ParamUtil.getString(argsItem, (String)"name");
            int needSet = ParamUtil.getInt(argsItem, (String)"needSet", (int)1);
            if (!argsName.equals(argsItemName) || 1 != needSet) continue;
            List setInfo = (List)argsItem.get("setInfo");
            if (setInfo == null) break;
            result.addAll(setInfo);
            break;
        }
        return result;
    }

    protected boolean saveService(MagicServiceSummary summary, List<ServiceMethodConfig> methodConfigs, Map<String, MetadataConfig> metadataConfigs, boolean saveToDb) throws BusinessException {
        MagicServiceSummary checkServiceExists = this.magicServiceSummaryDao.loadServiceInfo(summary.getBusinessId(), summary.getBusinessVersion());
        if (checkServiceExists == null) {
            if (saveToDb) {
                summary.setMetadata(JSONUtils.getJSonString(metadataConfigs.values()));
                this.magicServiceSummaryDao.save(summary);
            }
        } else {
            ArrayList<MetadataConfig> existsMetadata = new ArrayList<MetadataConfig>();
            if (Strings.isNotBlank((String)checkServiceExists.getMetadata())) {
                JSONUtils.parseJSonListObj_Class(checkServiceExists.getMetadata(), existsMetadata, MetadataConfig.class);
            }
            existsMetadata.addAll(metadataConfigs.values());
            summary.setMetadata(JSONUtils.getJSonString(existsMetadata));
            if (saveToDb) {
                this.magicServiceSummaryDao.update(summary);
            }
        }
        ArrayList<MagicInterfaceDefineEntity> saveMethodLists = new ArrayList<MagicInterfaceDefineEntity>(methodConfigs.size());
        ArrayList<MagicInterfaceDefineEntity> needUpdate = new ArrayList<MagicInterfaceDefineEntity>(methodConfigs.size());
        Map<String, MagicInterfaceDefineEntity> existsMapper = this.getAllMethodMapper(summary.getBusinessId(), summary.getBusinessVersion());
        for (ServiceMethodConfig smc : methodConfigs) {
            MagicInterfaceDefineEntity mide = MagicCreateServiceUtils.convertMethodToPo(summary.getOwnerType(), summary.getOwner(), summary.getBusinessId(), summary.getBusinessVersion(), smc);
            mide.setCategory(summary.getCertificateType().intValue());
            MagicInterfaceDefineEntity existsTempMethod = existsMapper.get(smc.getMethodName());
            if (existsTempMethod != null) {
                mide.setId(existsTempMethod.getId());
                needUpdate.add(mide);
                continue;
            }
            saveMethodLists.add(mide);
        }
        if (saveToDb) {
            this.magicInterfaceDefineDao.updateList(needUpdate);
            this.magicInterfaceDefineDao.saveDefine(saveMethodLists);
        } else {
            cacheServiceSummary.put(summary.getId(), summary);
            ArrayList<MagicInterfaceDefineEntity> cacheMethodListT = new ArrayList<MagicInterfaceDefineEntity>(saveMethodLists.size() + needUpdate.size());
            cacheMethodListT.addAll(saveMethodLists);
            cacheMethodListT.addAll(needUpdate);
            cacheMethodList.put(summary.getId(), cacheMethodListT);
        }
        return true;
    }

    protected void sendMessageToInvokeUser(List<MagicInterfaceDefineEntity> updateEntitys) {
    }

    public static List<MagicInterfaceDefineEntity> getCacheMethodList(Long serviceId) {
        return cacheMethodList.get(serviceId);
    }

    public static MagicServiceSummary getCacheServiceSummary(Long serviceId) {
        return cacheServiceSummary.get(serviceId);
    }

    public static void removeCacheByServiceID(Long serviceId) {
        cacheServiceSummary.remove(serviceId);
        cacheMethodList.remove(serviceId);
    }

    protected Map<String, Object> convertMethodInfo(String businessType, MagicInterfaceDefineEntity e) {
        HashMap<String, Object> methodInfo = new HashMap<String, Object>();
        methodInfo.put("methodName", e.getMethodName());
        methodInfo.put("displayName", e.getName());
        methodInfo.put("id", e.getMethodName());
        methodInfo.put("methodType", MagicEnums.BusinessMethodType.valueOfType((int)e.getServiceType()).getName());
        methodInfo.put("des", e.getDescription());
        if (Strings.isNotBlank((String)e.getResultConfigGuide())) {
            ResultConfigGuide resultConfigGuide = JSONUtils.parseJSonStr_Class(e.getResultConfigGuide(), ResultConfigGuide.class);
            methodInfo.put("resultFields", this.convertMethodResult(resultConfigGuide));
        }
        MagicEnums.BusinessMethodType methodType = MagicEnums.BusinessMethodType.valueOfType((int)e.getServiceType());
        if (Strings.isNotBlank((String)e.getArgsConfigGuide())) {
            ArrayList<ArgsConfigGuide> argsConfigGuides = new ArrayList<ArgsConfigGuide>();
            JSONUtils.parseJSonListObj_Class(e.getArgsConfigGuide(), argsConfigGuides, ArgsConfigGuide.class);
            List<Map<String, Object>> argss = this.convertMethodArgs(businessType, methodType, argsConfigGuides, e);
            methodInfo.put("argsConfig", argss);
        } else {
            List<Map<String, Object>> argss = this.convertMethodArgs(businessType, methodType, Collections.<ArgsConfigGuide>emptyList(), e);
            methodInfo.put("argsConfig", argss);
        }
        return methodInfo;
    }

    private List<Map<String, Object>> convertMethodArgs(String businessType, MagicEnums.BusinessMethodType methodType, List<ArgsConfigGuide> argsConfigGuides, MagicInterfaceDefineEntity e) {
        ArrayList<Map<String, Object>> r = new ArrayList<Map<String, Object>>();
        HashMap<String, ArgsConfigGuide> mapper = new HashMap<String, ArgsConfigGuide>();
        for (ArgsConfigGuide a : argsConfigGuides) {
            mapper.put(a.getArgsName(), a);
        }
        HashMap<String, Object> dataRight = new HashMap<String, Object>();
        dataRight.put("name", "dataRight");
        dataRight.put("displayName", ResourceUtil.getString((String)"cap.magic.label.relation.dataright"));
        dataRight.put("argType", ResourceUtil.getString((String)"form.input.inputtype.basic.text.label"));
        dataRight.put("needSet", "0");
        dataRight.put("setType", "dataRight");
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("name", "condition");
        condition.put("displayName", ResourceUtil.getString((String)"form.business.relation.relation.condition"));
        condition.put("argType", ResourceUtil.getString((String)"cap.magic.label.args.type.array"));
        condition.put("needSet", "1");
        condition.put("setType", "formField");
        HashMap<String, Object> formData = new HashMap<String, Object>();
        formData.put("name", "formData");
        formData.put("displayName", "\u6570\u636e\u5199\u5165\u53c2\u6570");
        formData.put("argType", ResourceUtil.getString((String)"cap.magic.label.args.type.array"));
        formData.put("needSet", "1");
        formData.put("setType", "formField");
        if (MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey().equals(businessType)) {
            switch (methodType) {
                case RELATION_USER: 
                case RELATION_SYS: 
                case RELATION: {
                    EntryAnnotation ea;
                    ArgsConfigGuide formDataGuide = (ArgsConfigGuide)mapper.get("dataRight");
                    if (formDataGuide != null) {
                        EntryAnnotation ea2 = JSONUtils.parseJSonStr_Class(formDataGuide.getGuideStr(), EntryAnnotation.class);
                        if (ea2.getConfigList() != null) {
                            ArrayList<Map> item = new ArrayList<Map>();
                            for (Object eci : ea2.getConfigList()) {
                                item.add(eci.getOtherConfig());
                            }
                            dataRight.put("setInfo", item);
                        }
                        dataRight.put("displayName", ResourceUtil.getString((String)"cap.magic.label.relation.dataright"));
                    }
                    r.add(dataRight);
                    ArgsConfigGuide c = (ArgsConfigGuide)mapper.get("condition");
                    if (c != null && (ea = JSONUtils.parseJSonStr_Class(c.getGuideStr(), EntryAnnotation.class)).getConfigList() != null) {
                        ArrayList<Map> item = new ArrayList<Map>();
                        for (EntryConfigItem eci : ea.getConfigList()) {
                            item.add(eci.getOtherConfig());
                        }
                        condition.put("setInfo", item);
                    }
                    r.add(condition);
                    break;
                }
                case TRIGGER_UPDATE: {
                    ArrayList<Map> item;
                    EntryAnnotation ea;
                    ArgsConfigGuide cc = (ArgsConfigGuide)mapper.get("condition");
                    if (cc != null && (ea = JSONUtils.parseJSonStr_Class(cc.getGuideStr(), EntryAnnotation.class)).getConfigList() != null) {
                        item = new ArrayList<Map>();
                        for (EntryConfigItem eci : ea.getConfigList()) {
                            item.add(eci.getOtherConfig());
                        }
                        condition.put("setInfo", item);
                    }
                    r.add(condition);
                    ArgsConfigGuide formDataGuide = (ArgsConfigGuide)mapper.get("dataRight");
                    if (formDataGuide != null) {
                        ea = JSONUtils.parseJSonStr_Class(formDataGuide.getGuideStr(), EntryAnnotation.class);
                        if (ea.getConfigList() != null) {
                            item = new ArrayList();
                            for (EntryConfigItem eci : ea.getConfigList()) {
                                item.add(eci.getOtherConfig());
                            }
                            dataRight.put("setInfo", item);
                        }
                        dataRight.put("displayName", ResourceUtil.getString((String)"cap.magic.label.trigger.data2"));
                    }
                    r.add(dataRight);
                    formDataGuide = (ArgsConfigGuide)mapper.get("formData");
                    if (formDataGuide != null && (ea = JSONUtils.parseJSonStr_Class(formDataGuide.getGuideStr(), EntryAnnotation.class)).getConfigList() != null) {
                        item = new ArrayList();
                        for (EntryConfigItem eci : ea.getConfigList()) {
                            item.add(eci.getOtherConfig());
                        }
                        formData.put("setInfo", item);
                    }
                    r.add(formData);
                    break;
                }
                case TRIGGER_CREATE: {
                    ArrayList<Map> item;
                    EntryAnnotation ea;
                    ArgsConfigGuide formDataGuide = (ArgsConfigGuide)mapper.get("formData");
                    if (formDataGuide != null && (ea = JSONUtils.parseJSonStr_Class(formDataGuide.getGuideStr(), EntryAnnotation.class)).getConfigList() != null) {
                        item = new ArrayList<Map>();
                        for (Object eci : ea.getConfigList()) {
                            item.add(eci.getOtherConfig());
                        }
                        formData.put("setInfo", item);
                    }
                    r.add(formData);
                    if (mapper.containsKey("template")) {
                        EntryAnnotation ea3;
                        HashMap<String, Object> template = new HashMap<String, Object>();
                        template.put("name", "template");
                        template.put("displayName", ResourceUtil.getString((String)"cap.magic.label.trigger.template"));
                        template.put("argType", ResourceUtil.getString((String)"form.input.inputtype.basic.text.label"));
                        template.put("needSet", "0");
                        condition.put("setType", "template");
                        formDataGuide = (ArgsConfigGuide)mapper.get("template");
                        if (formDataGuide != null && (ea3 = JSONUtils.parseJSonStr_Class(formDataGuide.getGuideStr(), EntryAnnotation.class)).getConfigList() != null) {
                            ArrayList item2 = new ArrayList();
                            for (EntryConfigItem eci : ea3.getConfigList()) {
                                item2.add(eci.getOtherConfig());
                            }
                            template.put("setInfo", item2);
                        }
                        r.add(template);
                        break;
                    }
                    formDataGuide = (ArgsConfigGuide)mapper.get("dataRight");
                    if (formDataGuide != null) {
                        ea = JSONUtils.parseJSonStr_Class(formDataGuide.getGuideStr(), EntryAnnotation.class);
                        if (ea.getConfigList() != null) {
                            item = new ArrayList();
                            for (Object eci : ea.getConfigList()) {
                                item.add(eci.getOtherConfig());
                            }
                            dataRight.put("setInfo", item);
                        }
                        dataRight.put("displayName", ResourceUtil.getString((String)"cap.magic.label.trigger.data3"));
                    }
                    r.add(dataRight);
                    break;
                }
                case TRIGGER_DISTRIBUTE: {
                    ArrayList<Map> item;
                    EntryAnnotation ea;
                    ArgsConfigGuide formDataGuide = (ArgsConfigGuide)mapper.get("formData");
                    if (formDataGuide != null && (ea = JSONUtils.parseJSonStr_Class(formDataGuide.getGuideStr(), EntryAnnotation.class)).getConfigList() != null) {
                        item = new ArrayList<Map>();
                        for (EntryConfigItem eci : ea.getConfigList()) {
                            item.add(eci.getOtherConfig());
                        }
                        formData.put("setInfo", item);
                    }
                    r.add(formData);
                    formDataGuide = (ArgsConfigGuide)mapper.get("dataRight");
                    if (formDataGuide != null) {
                        ea = JSONUtils.parseJSonStr_Class(formDataGuide.getGuideStr(), EntryAnnotation.class);
                        if (ea.getConfigList() != null) {
                            item = new ArrayList();
                            for (EntryConfigItem eci : ea.getConfigList()) {
                                item.add(eci.getOtherConfig());
                            }
                            dataRight.put("setInfo", item);
                        }
                        dataRight.put("displayName", ResourceUtil.getString((String)"cap.magic.label.trigger.data1"));
                    }
                    r.add(dataRight);
                }
            }
        } else if (!MagicEnums.ServiceOwnerType.DEFAULT_DEE.getType().equals(e.getSubType())) {
            switch (methodType) {
                case OUTERTRGGER: {
                    ArgsConfigGuide formDataGuide = (ArgsConfigGuide)mapper.get("formData");
                    if (formDataGuide != null) {
                        EntryAnnotation ea = JSONUtils.parseJSonStr_Class(formDataGuide.getGuideStr(), EntryAnnotation.class);
                        ArrayList<Map> item = new ArrayList<Map>();
                        for (EntryConfigItem eci : ea.getConfigList()) {
                            item.add(eci.getOtherConfig());
                        }
                        formData.put("setInfo", item);
                    }
                    r.add(formData);
                    break;
                }
                case RELATION_USER: 
                case RELATION_SYS: 
                case RELATION: {
                    EntryAnnotation ea;
                    ArgsConfigGuide c = (ArgsConfigGuide)mapper.get("condition");
                    if (c != null && (ea = JSONUtils.parseJSonStr_Class(c.getGuideStr(), EntryAnnotation.class)).getConfigList() != null) {
                        ArrayList<Map> item = new ArrayList<Map>();
                        for (EntryConfigItem eci : ea.getConfigList()) {
                            item.add(eci.getOtherConfig());
                        }
                        condition.put("setInfo", item);
                    }
                    r.add(condition);
                }
            }
        } else if (Strings.isNotBlank((String)e.getArgsConfig())) {
            ArrayList serviceArgumentConfigs = new ArrayList();
            JSONUtils.parseJSonListObj_Class(e.getArgsConfig(), serviceArgumentConfigs, ServiceArgumentConfig.class);
            HashMap<String, ServiceArgumentConfig> argumentConfigMap = new HashMap<String, ServiceArgumentConfig>();
            for (ServiceArgumentConfig s : serviceArgumentConfigs) {
                argumentConfigMap.put(s.getArgsName(), s);
            }
            HashMap<String, Object> setInfo = new HashMap<String, Object>();
            setInfo.put("name", "dee");
            setInfo.put("displayName", "dee\u53c2\u6570\u8bbe\u7f6e");
            setInfo.put("argType", ResourceUtil.getString((String)"cap.magic.label.args.type.array"));
            setInfo.put("needSet", "1");
            ArrayList item = new ArrayList();
            for (Map.Entry items : mapper.entrySet()) {
                ArgsConfigGuide itemArgsGuide;
                EntryAnnotation ea;
                ServiceArgumentConfig itemArgsConfig = (ServiceArgumentConfig)argumentConfigMap.get(items.getKey());
                if (itemArgsConfig == null || (ea = JSONUtils.parseJSonStr_Class((itemArgsGuide = (ArgsConfigGuide)items.getValue()).getGuideStr(), EntryAnnotation.class)).getConfigList() == null) continue;
                for (EntryConfigItem eci : ea.getConfigList()) {
                    HashMap<String, String> otherConfig = eci.getOtherConfig();
                    if (otherConfig != null) continue;
                    otherConfig = new HashMap<String, String>();
                    if (eci.getDisplayName() != null && eci.getDisplayName().size() > 0) {
                        otherConfig.put("displayName", ((MagicDisplay)eci.getDisplayName().get(0)).getText());
                    }
                    otherConfig.put("name", itemArgsConfig.getArgsName() + "." + eci.getName());
                    item.add(otherConfig);
                }
            }
            setInfo.put("setInfo", item);
            r.add(setInfo);
        }
        return r;
    }

    private List<Map<String, Object>> convertMethodResult(ResultConfigGuide resultConfigGuide) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(resultConfigGuide.getConfigList().size());
        for (EntryConfigItem i : resultConfigGuide.getConfigList()) {
            HashMap<String, String> otherConfig = i.getOtherConfig();
            if (otherConfig == null) {
                otherConfig = new HashMap<String, String>();
                if (i.getDisplayName() != null && i.getDisplayName().size() > 0) {
                    otherConfig.put("displayName", ((MagicDisplay)i.getDisplayName().get(0)).getText());
                }
                otherConfig.put("name", i.getName());
            }
            result.add((Map<String, Object>)otherConfig);
        }
        return result;
    }

    private Map<String, Object> convertServiceSummary(MagicServiceSummary summary) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", String.valueOf(summary.getId()));
        result.put("businessId", summary.getBusinessId());
        result.put("businessVersion", summary.getBusinessVersion());
        result.put("certificateType", MagicEnums.CertificateType.getEnumByKey((int)summary.getCertificateType()).getName());
        result.put("businessType", summary.getBusinessType());
        result.put("displayName", summary.getNameDisplay());
        result.put("des", summary.getDescription());
        if (MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey().equals(summary.getBusinessType())) {
            HashMap<String, String> bizConfig = new HashMap<String, String>();
            if (MagicPrivateUtils.isNumeric(summary.getOwner())) {
                Long formId = Long.parseLong(summary.getOwner());
                MagicEnums.ServiceOwnerType pt = MagicEnums.ServiceOwnerType.getEnumByType((String)summary.getOwnerType());
                if (pt == null) {
                    pt = MagicEnums.ServiceOwnerType.DEFAULT_FORM;
                }
                MagicFormBean mfb = new MagicFormBean(pt, formId);
                result.put("formType", pt.getType());
                if (!mfb.isNull()) {
                    result.put("formId", summary.getOwner());
                    result.put("formName", mfb.getFormName());
                    result.put("flowForm", mfb.isFlowForm() ? "1" : "0");
                    result.put("exists", "1");
                } else {
                    result.put("exists", "0");
                }
                if (pt.equals((Object)MagicEnums.ServiceOwnerType.DEFAULT_FORM)) {
                    BizConfigBean biz = this.businessManager4.findBizConfigByFormId(formId);
                    if (biz != null) {
                        bizConfig.put("name", biz.getName());
                        bizConfig.put("id", String.valueOf(biz.getId()));
                    }
                    result.put("formType", MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType());
                }
            }
            result.put("bizConfig", bizConfig);
        }
        result.put("authType", summary.getAuthorizationType() == null ? 1 : summary.getAuthorizationType());
        if (summary.getAuthorizationType() != null && MagicEnums.ServiceAuthType.USERDEFINED.getKey() == summary.getAuthorizationType().intValue() && Strings.isNotBlank((String)summary.getAuthorizationInfo())) {
            result.put("authInfo", JSONUtils.parseJSonStr_Class(summary.getAuthorizationInfo(), List.class));
        }
        return result;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public IMagicAjaxHandleService getMagicAjaxHandleService() {
        return this.magicAjaxHandleService;
    }

    public void setMagicAjaxHandleService(IMagicAjaxHandleService magicAjaxHandleService) {
        this.magicAjaxHandleService = magicAjaxHandleService;
    }

    public ICAP4MagicManager getCap4MagicManager() {
        return this.cap4MagicManager;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }
}

