/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.create.impl;

import com.seeyon.cap4.magic.business.create.IMagicCreateService;
import com.seeyon.cap4.magic.business.create.impl.AbstractMagicHandleService;
import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.datamagic.engine.domain.base.MagicDisplay;
import com.seeyon.datamagic.engine.domain.metadata.MetadataConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class MagicExternalHandleServiceImpl
extends AbstractMagicHandleService
implements IMagicCreateService {
    @Override
    public String getBusinessType() {
        return MagicEnums.BusinessType.EXTERNAL_BUSINESS.getKey();
    }

    @Override
    public Map<String, Object> showServiceInfo(MagicServiceSummary serviceSummary) throws BusinessException {
        return super.absShowServiceInfo(serviceSummary);
    }

    @Override
    public Map<String, Object> createMethod(Map<String, Object> baseInfo, Map<String, Object> methodInfo) throws BusinessException {
        methodInfo.put("id", String.valueOf(UUIDLong.absLongUUID()));
        return methodInfo;
    }

    @Override
    public Map<String, Object> createServiceImpl(Map<String, Object> serviceInfo, Map<String, Object> setInfo) throws BusinessException {
        return Collections.emptyMap();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={BusinessException.class})
    public Map<String, Object> createService(Map<String, Object> params) throws BusinessException {
        Date createDate;
        String businessId;
        Map baseInfo = (Map)params.get("baseInfo");
        String certificateType = ParamUtil.getString((Map)baseInfo, (String)"certificateType", (String)"");
        String version = "1";
        Long id = ParamUtil.getLong((Map)baseInfo, (String)"id", (Long)0L);
        String saveToDBStr = ParamUtil.getString(params, (String)"saveToDB", (String)"1");
        boolean saveToDB = "1".equalsIgnoreCase(saveToDBStr);
        MagicServiceSummary summary = this.getMagicServiceSummaryDao().loadServiceInfo(id);
        Long creater = AppContext.currentUserId();
        if (summary != null) {
            List<String> permissionList = this.getCap4MagicManager().checkHandlePermission(summary);
            if (permissionList.isEmpty()) {
                throw new BusinessException(ResourceUtil.getString((String)"cap.magic.tips.error2"));
            }
            if (permissionList.size() == 1 && permissionList.get(0).equals("modifyAuth")) {
                return super.onlyUpdateAuthInfo(summary, baseInfo);
            }
            businessId = summary.getBusinessId();
            version = summary.getBusinessVersion();
            createDate = summary.getCreateDate();
            creater = summary.getCreateId();
            if (saveToDB) {
                this.delete(summary, params);
            }
        } else {
            createDate = DateUtil.currentDate();
            id = UUIDLong.absLongUUID();
            businessId = certificateType.equals(MagicEnums.CertificateType.Public_certificate.getName()) ? MagicCreateServiceUtils.generateBusinessId(MagicEnums.CertificateType.Public_certificate) : MagicCreateServiceUtils.generateBusinessId(MagicEnums.CertificateType.Private_certificate);
        }
        List methodList = (List)params.get("methodInfo");
        ArrayList<ServiceMethodConfig> methodConfigs = new ArrayList<ServiceMethodConfig>();
        HashMap<String, MetadataConfig> metadataConfigs = new HashMap<String, MetadataConfig>();
        for (Map method : methodList) {
            methodConfigs.addAll(this.createMethod(method, metadataConfigs, businessId, version));
        }
        summary = super.createServiceSummary(creater, baseInfo, businessId, version, createDate);
        summary.setId(id);
        String currentBizId = ParamUtil.getString((Map)baseInfo, (String)"currentBizId", (String)"");
        if (Strings.isNotBlank((String)currentBizId)) {
            summary.setOwner(currentBizId);
            summary.setOwnerType(MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType());
        } else {
            summary.setOwner(String.valueOf(AppContext.currentUserId()));
            summary.setOwnerType(MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType());
        }
        List implInfo = (List)params.get("implList");
        List deleteImplList = (List)params.get("deleteImplIdList");
        if (deleteImplList != null && !deleteImplList.isEmpty()) {
            ArrayList<MagicServiceProviderPO> needDelete = new ArrayList<MagicServiceProviderPO>(deleteImplList.size());
            for (Object ids : deleteImplList) {
                MagicServiceProviderPO p = this.getMagicProviderDao().getById(Long.parseLong((String)ids));
                if (p == null) continue;
                needDelete.add(p);
            }
            if (!needDelete.isEmpty()) {
                this.getMagicProviderDao().deleteProvides(needDelete);
            }
        }
        if (implInfo != null) {
            Object ids;
            ArrayList<MagicServiceProviderPO> providerPOList = new ArrayList<MagicServiceProviderPO>(implInfo.size());
            List<MagicServiceProviderPO> exists = this.getMagicProviderDao().loadProviders(businessId, version);
            ids = new ArrayList(implInfo.size());
            for (Map i : implInfo) {
                Long implId = ParamUtil.getLong((Map)i, (String)"id", (Long)0L);
                ids.add(implId);
                int status = ParamUtil.getInt((Map)i, (String)"status", (int)MagicEnums.ProviderStatus.OFF.getType());
                MagicServiceProviderPO po = this.getMagicProviderDao().getById(implId);
                if (po != null) {
                    po.setStatus(status);
                }
                providerPOList.add(po);
            }
            ArrayList<MagicServiceProviderPO> needDelete = new ArrayList<MagicServiceProviderPO>();
            for (MagicServiceProviderPO p : exists) {
                if (ids.contains(p.getId())) continue;
                needDelete.add(p);
            }
            if (!needDelete.isEmpty()) {
                this.getMagicProviderDao().deleteProvides(needDelete);
            }
            if (!providerPOList.isEmpty()) {
                this.getMagicProviderDao().updateProviders(providerPOList);
            }
        } else {
            this.getMagicProviderDao().deleteProvides(businessId, version);
        }
        super.saveService(summary, methodConfigs, metadataConfigs, saveToDB);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("msg", ResourceUtil.getString((String)"cap.template.common.text.saveok"));
        result.put("success", "1");
        result.put("id", String.valueOf(summary.getId()));
        return result;
    }

    protected List<ServiceMethodConfig> createMethod(Map<String, Object> params, Map<String, MetadataConfig> metadatas, String businessId, String version) throws BusinessException {
        ServiceMethodConfig serviceMethodConfig = null;
        String methodType = ParamUtil.getString(params, (String)"methodType", (String)"");
        MagicEnums.BusinessMethodType st = MagicEnums.BusinessMethodType.valueOfName((String)methodType);
        String displayName = ParamUtil.getString(params, (String)"displayName", (String)"");
        String methodName = ParamUtil.getString(params, (String)"methodName", (String)"");
        String des = ParamUtil.getString(params, (String)"des", (String)"");
        List args = Collections.EMPTY_LIST;
        if (params.containsKey("argsConfig")) {
            args = (List)params.get("argsConfig");
        }
        if (st == null) {
            return Collections.emptyList();
        }
        switch (st) {
            case RELATION_USER: 
            case RELATION_SYS: 
            case RELATION: {
                List<Map<String, Object>> condition = this.getArgsSet(args, "condition");
                LinkedHashSet<Object> conditionFields = new LinkedHashSet<Object>();
                HashMap<Object, String> limit = new HashMap<Object, String>();
                if (condition != null && !condition.isEmpty()) {
                    for (Map<String, Object> item : condition) {
                        String name = ParamUtil.getString(item, (String)"name", (String)"");
                        if (Strings.isNotBlank((String)name)) {
                            conditionFields.add(name);
                        }
                        limit.put(name, JSONUtils.getJSonString(item));
                    }
                }
                LinkedHashSet<String> resultFields = new LinkedHashSet<String>();
                List result = (List)params.get("resultFields");
                if (result != null && !result.isEmpty()) {
                    for (Map item : result) {
                        String name = ParamUtil.getString((Map)item, (String)"name", (String)"");
                        if (Strings.isNotBlank((String)name)) {
                            resultFields.add(name);
                        }
                        limit.put(name, JSONUtils.getJSonString(item));
                    }
                }
                serviceMethodConfig = MagicCreateServiceUtils.createRelation(displayName, methodName, businessId, version, metadatas, condition, result);
                serviceMethodConfig.addOtherAttr("resultKey", resultFields);
                if (condition != null && !condition.isEmpty()) {
                    serviceMethodConfig.addOtherAttr("condition", conditionFields);
                }
                serviceMethodConfig.addOtherAttr("fieldLimit", limit);
                break;
            }
            case OUTERTRGGER: {
                List<Map<String, Object>> triggerFormDatas = this.getArgsSet(args, "formData");
                List triggerResultFormDatas = (List)params.get("resultFields");
                List<Map<String, Object>> triggerConditionDatas = this.getArgsSet(args, "condition");
                serviceMethodConfig = MagicCreateServiceUtils.createOutTrigger(triggerFormDatas, triggerResultFormDatas, triggerConditionDatas, displayName, methodName, businessId, metadatas, version);
            }
        }
        ArrayList<ServiceMethodConfig> resultMethod = new ArrayList<ServiceMethodConfig>();
        if (null != serviceMethodConfig) {
            serviceMethodConfig.addDes(new MagicDisplay(des));
        }
        resultMethod.add(serviceMethodConfig);
        return resultMethod;
    }
}

