/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.create.impl;

import com.seeyon.cap4.magic.business.create.IMagicCreateService;
import com.seeyon.cap4.magic.business.create.impl.AbstractMagicHandleService;
import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.cap4.magic.vo.MagicFormFieldBean;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.form.modules.engin.formula.FormulaDAO;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.base.MagicDisplay;
import com.seeyon.datamagic.engine.domain.metadata.MetadataConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import com.seeyon.datamagic.engine.utils.GenerateUtils;
import com.seeyon.datamagic.engine.utils.JSONUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class MagicInternalHandleServicesImpl
extends AbstractMagicHandleService
implements IMagicCreateService {
    private FormulaDAO formulaDAO;

    private MagicServiceProviderPO setProvider(Map<String, Object> params) throws BusinessException {
        String businessId = ParamUtil.getString(params, (String)"businessId", (String)"");
        String version = ParamUtil.getString(params, (String)"version", (String)"");
        Long implId = ParamUtil.getLong(params, (String)"id", (Long)0L);
        String displayName = ParamUtil.getString(params, (String)"name", (String)"");
        MagicServiceProviderPO exists = this.getMagicProviderDao().getById(implId);
        Integer status = ParamUtil.getInt(params, (String)"status", (int)MagicEnums.ProviderStatus.OFF.getType());
        if (exists != null) {
            ArrayList<MagicServiceProviderPO> deleteList = new ArrayList<MagicServiceProviderPO>();
            deleteList.add(exists);
            this.getMagicProviderDao().deleteProvides(deleteList);
        } else {
            implId = UUIDLong.longUUID();
        }
        Map targetInfo = (Map)params.get("targetInfo");
        String formType = ParamUtil.getString((Map)targetInfo, (String)"type", (String)"");
        Long formId = ParamUtil.getLong((Map)targetInfo, (String)"id", (Long)0L);
        MagicEnums.ServiceOwnerType pt = MagicEnums.ServiceOwnerType.getEnumByType((String)formType);
        MagicFormBean formBean = new MagicFormBean(pt, formId);
        List methodMapping = (List)params.get("methodMapping");
        MagicServiceProviderPO providerPO = new MagicServiceProviderPO();
        providerPO.setSource(String.valueOf(formId));
        providerPO.setSourceType(pt.getType());
        providerPO.setBusinessId(businessId);
        providerPO.setVersionId(version);
        providerPO.setId(implId);
        providerPO.setDisplayName(displayName);
        providerPO.setCreateDate(DateUtil.currentDate());
        providerPO.setCreater(Long.valueOf(AppContext.currentUserId()));
        providerPO.setSource(String.valueOf(formBean.getId()));
        providerPO.setSourceType(formBean.getType().getType());
        providerPO.setExt1(JSONUtil.toJSONString((Object)methodMapping));
        providerPO.setDisplayName(displayName);
        providerPO.setStatus(status.intValue());
        providerPO.setExt4(GenerateUtils.generateThirdBusinessId((long)UUIDLong.longUUID()));
        if (!formBean.isNull() && params.containsKey("scopeSet")) {
            Map scopeSet = (Map)params.get("scopeSet");
            HashMap<String, Map> ext2 = new HashMap<String, Map>();
            ext2.put("scopeSet", scopeSet);
            providerPO.setExt2(JSONUtils.getJSonString(ext2));
        }
        return providerPO;
    }

    @Override
    public String getBusinessType() {
        return MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey();
    }

    @Override
    public Map<String, Object> showServiceInfo(MagicServiceSummary serviceSummary) throws BusinessException {
        return super.absShowServiceInfo(serviceSummary);
    }

    @Override
    public Map<String, Object> createServiceImpl(Map<String, Object> serviceInfo, Map<String, Object> implSet) throws BusinessException {
        MagicServiceProviderPO providerPO;
        ArrayList<ServiceMethodConfig> methodConfigs = new ArrayList<ServiceMethodConfig>();
        HashMap<String, MetadataConfig> metadataConfigs = new HashMap<String, MetadataConfig>();
        Map baseInfo = (Map)serviceInfo.get("baseInfo");
        Long formId = ParamUtil.getLong((Map)baseInfo, (String)"formId", (Long)0L);
        String formType = ParamUtil.getString((Map)baseInfo, (String)"formType");
        String businessId = "";
        String version = "";
        MagicEnums.ServiceOwnerType pt = MagicEnums.ServiceOwnerType.getEnumByType((String)formType);
        if (pt == null) {
            return Collections.emptyMap();
        }
        MagicFormBean magicFormBean = new MagicFormBean(pt, formId);
        List methodInfo = (List)serviceInfo.get("methodInfo");
        if (methodInfo != null) {
            for (Map m : methodInfo) {
                methodConfigs.addAll(this.createMethod(m, metadataConfigs, magicFormBean, businessId, version));
            }
        }
        if (implSet == null || implSet.isEmpty()) {
            providerPO = this.saveDefaultImpl(businessId, version, methodConfigs, magicFormBean);
        } else {
            Long implId = ParamUtil.getLong(implSet, (String)"id", (Long)0L);
            if (implId == 0L) {
                implId = UUIDLong.longUUID();
            }
            Integer status = ParamUtil.getInt(implSet, (String)"status", (int)MagicEnums.ProviderStatus.OFF.getType());
            String displayName = ParamUtil.getString(implSet, (String)"name", (String)"");
            Map targetInfo = (Map)implSet.get("targetInfo");
            if (targetInfo == null || targetInfo.isEmpty()) {
                return Collections.emptyMap();
            }
            String targetFormType = ParamUtil.getString((Map)targetInfo, (String)"type", (String)"");
            Long targetFormId = ParamUtil.getLong((Map)targetInfo, (String)"id", (Long)0L);
            MagicEnums.ServiceOwnerType targetOwnerType = MagicEnums.ServiceOwnerType.getEnumByType((String)targetFormType);
            MagicFormBean formBean = new MagicFormBean(targetOwnerType, targetFormId);
            List methodMapping = (List)implSet.get("methodMapping");
            LinkedList<Map> saveMethodMapping = new LinkedList<Map>();
            if (methodMapping != null) {
                for (Map item : methodMapping) {
                    if (item == null || item.isEmpty()) continue;
                    saveMethodMapping.add(item);
                }
            }
            providerPO = new MagicServiceProviderPO();
            providerPO.setSource(String.valueOf(formId));
            providerPO.setSourceType(pt.getType());
            providerPO.setId(implId);
            providerPO.setDisplayName(displayName);
            providerPO.setCreateDate(DateUtil.currentDate());
            providerPO.setCreater(Long.valueOf(AppContext.currentUserId()));
            providerPO.setSource(String.valueOf(formBean.getId()));
            providerPO.setSourceType(formBean.getType().getType());
            providerPO.setExt1(JSONUtil.toJSONString(saveMethodMapping));
            providerPO.setDisplayName(displayName);
            providerPO.setStatus(status.intValue());
        }
        return MagicCreateServiceUtils.showServiceImplInfo("", providerPO);
    }

    @Override
    public Map<String, Object> createMethod(Map<String, Object> serviceInfo, Map<String, Object> methodInfo) throws BusinessException {
        String businessId = "";
        String version = "";
        HashMap<String, MetadataConfig> metadataConfigs = new HashMap<String, MetadataConfig>();
        Long formId = ParamUtil.getLong(serviceInfo, (String)"formId", (Long)0L);
        String formType = ParamUtil.getString(serviceInfo, (String)"formType");
        MagicEnums.ServiceOwnerType pt = MagicEnums.ServiceOwnerType.getEnumByType((String)formType);
        if (pt == null) {
            return Collections.emptyMap();
        }
        MagicFormBean magicFormBean = new MagicFormBean(pt, formId);
        List<ServiceMethodConfig> methodConfigs = this.createMethod(methodInfo, metadataConfigs, magicFormBean, businessId, version);
        for (ServiceMethodConfig e : methodConfigs) {
            if (MagicEnums.BusinessMethodType.QUERY.getName().equals(e.getServiceType()) || MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK.getName().equals(e.getServiceType())) continue;
            Map<String, Object> methodShowInfo = this.convertMethodInfo(MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey(), MagicCreateServiceUtils.convertMethodToPo(formType, String.valueOf(formId), businessId, version, e));
            if (methodInfo.isEmpty()) continue;
            return methodShowInfo;
        }
        return Collections.emptyMap();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={BusinessException.class})
    public Map<String, Object> createService(Map<String, Object> params) throws BusinessException {
        Date createDate;
        String businessId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", "0");
        Map baseInfo = (Map)params.get("baseInfo");
        Long id = ParamUtil.getLong((Map)baseInfo, (String)"id", (Long)0L);
        Long formId = ParamUtil.getLong((Map)baseInfo, (String)"formId", (Long)0L);
        String formType = ParamUtil.getString((Map)baseInfo, (String)"formType");
        String version = "1";
        String certificateType = ParamUtil.getString((Map)baseInfo, (String)"certificateType", (String)"");
        MagicEnums.ServiceOwnerType pt = MagicEnums.ServiceOwnerType.getEnumByType((String)formType);
        if (pt == null) {
            return Collections.emptyMap();
        }
        MagicFormBean magicFormBean = new MagicFormBean(pt, formId);
        Long createId = AppContext.currentUserId();
        if (magicFormBean.isNull()) {
            return Collections.emptyMap();
        }
        MagicServiceSummary summary = this.getMagicServiceSummaryDao().loadServiceInfo(id);
        if (summary != null) {
            List<String> permissionList = this.getCap4MagicManager().checkHandlePermission(summary);
            if (permissionList.isEmpty()) {
                throw new BusinessException(ResourceUtil.getString((String)"cap.magic.tips.error2"));
            }
            if (permissionList.size() == 1 && permissionList.get(0).equals("modifyAuth")) {
                return super.onlyUpdateAuthInfo(summary, baseInfo);
            }
            businessId = summary.getBusinessId();
            version = summary.getBusinessVersion();
            createId = summary.getCreateId();
            createDate = summary.getCreateDate();
            this.delete(summary, params);
        } else {
            id = UUIDLong.absLongUUID();
            createDate = DateUtil.currentDate();
            businessId = certificateType.equals(MagicEnums.CertificateType.Public_certificate.getName()) ? MagicCreateServiceUtils.generateBusinessId(MagicEnums.CertificateType.Public_certificate) : MagicCreateServiceUtils.generateBusinessId(MagicEnums.CertificateType.Private_certificate);
        }
        List methodList = (List)params.get("methodInfo");
        ArrayList<ServiceMethodConfig> methodConfigs = new ArrayList<ServiceMethodConfig>();
        HashMap<String, MetadataConfig> metadataConfigs = new HashMap<String, MetadataConfig>();
        for (Map method : methodList) {
            methodConfigs.addAll(this.createMethod(method, metadataConfigs, magicFormBean, businessId, version));
        }
        summary = this.createServiceInternalSummary(createId, magicFormBean, baseInfo, businessId, version, createDate);
        summary.setId(id);
        this.saveService(summary, methodConfigs, metadataConfigs, true);
        List implInfo = (List)params.get("implList");
        List deleteImplList = (List)params.get("deleteImplIdList");
        if (deleteImplList != null && !deleteImplList.isEmpty()) {
            ArrayList<MagicServiceProviderPO> needDelete = new ArrayList<MagicServiceProviderPO>(deleteImplList.size());
            for (String ids : deleteImplList) {
                MagicServiceProviderPO p = this.getMagicProviderDao().getById(Long.parseLong(ids));
                if (p == null) continue;
                needDelete.add(p);
            }
            if (!needDelete.isEmpty()) {
                this.getMagicProviderDao().deleteProvides(needDelete);
            }
        }
        if (implInfo != null) {
            ArrayList<MagicServiceProviderPO> providerPOList = new ArrayList<MagicServiceProviderPO>(implInfo.size());
            for (Map i : implInfo) {
                MagicServiceProviderPO providerPO = this.setProvider(i);
                providerPO.setBusinessId(businessId);
                providerPO.setVersionId(version);
                providerPOList.add(providerPO);
            }
            if (!providerPOList.isEmpty()) {
                this.getMagicProviderDao().saveProviders(providerPOList);
            }
        }
        result.put("msg", ResourceUtil.getString((String)"cap.template.common.text.saveok"));
        result.put("success", "1");
        return result;
    }

    private MagicServiceProviderPO saveDefaultImpl(String bid, String version, List<ServiceMethodConfig> methodConfigs, MagicFormBean mfb) {
        this.getMagicProviderDao().deleteProvides(bid, version);
        MagicServiceProviderPO p = new MagicServiceProviderPO();
        p.setIdIfNew();
        p.setDisplayName(mfb.getFormName());
        p.setSourceType(mfb.getType().getType());
        p.setSource(String.valueOf(mfb.getId()));
        p.setVersionId(version);
        p.setBusinessId(bid);
        p.setCreater(Long.valueOf(AppContext.currentUserId()));
        p.setCreateDate(DateUtil.currentDate());
        List<Map<String, Object>> mappingList = MagicCreateServiceUtils.saveDefaultImpl(bid, version, methodConfigs, mfb);
        p.setStatus(MagicEnums.ProviderStatus.ON.getType());
        p.setExt1(JSONUtils.getJSonString(mappingList));
        p.setExt4(GenerateUtils.generateThirdBusinessId((long)UUIDLong.longUUID()));
        return p;
    }

    private MagicServiceSummary createServiceInternalSummary(Long creater, MagicFormBean ffb, Map<String, Object> params, String businessId, String version, Date createDate) {
        MagicServiceSummary result = super.createServiceSummary(creater, params, businessId, version, createDate);
        result.setOwner(String.valueOf(ffb.getId()));
        result.setOwnerType(ffb.getType().getType());
        return result;
    }

    private List<ServiceMethodConfig> createMethod(Map<String, Object> params, Map<String, MetadataConfig> metadatas, MagicFormBean magicFormBean, String businessId, String version) throws BusinessException {
        ArrayList<ServiceMethodConfig> resultMethod = new ArrayList<ServiceMethodConfig>();
        ServiceMethodConfig serviceMethodConfig = null;
        String methodType = ParamUtil.getString(params, (String)"methodType", (String)"");
        MagicEnums.BusinessMethodType st = MagicEnums.BusinessMethodType.valueOfName((String)methodType);
        String displayName = ParamUtil.getString(params, (String)"displayName", (String)"");
        String des = ParamUtil.getString(params, (String)"des", (String)"");
        String methodName = ParamUtil.getString(params, (String)"methodName", (String)"");
        List args = params.containsKey("argsConfig") ? (List)params.get("argsConfig") : Collections.EMPTY_LIST;
        if (st == null) {
            return Collections.emptyList();
        }
        switch (st) {
            case RELATION_USER: 
            case RELATION_SYS: 
            case RELATION: {
                List<Map<String, Object>> condition = this.getArgsSet(args, "condition");
                LinkedHashSet<String> conditionFields = new LinkedHashSet<String>();
                if (condition != null && !condition.isEmpty()) {
                    for (Map<String, Object> item : condition) {
                        String name = ParamUtil.getString(item, (String)"name", (String)"");
                        MagicFormFieldBean mffb = magicFormBean.getFieldBeanByName(name);
                        if (mffb.isNull()) continue;
                        conditionFields.add(name);
                    }
                }
                LinkedHashSet<String> resultFields = new LinkedHashSet<String>();
                List result = (List)params.get("resultFields");
                if (result != null && !result.isEmpty()) {
                    for (Map item : result) {
                        String name = ParamUtil.getString((Map)item, (String)"name", (String)"");
                        MagicFormFieldBean mffb = magicFormBean.getFieldBeanByName(name);
                        if (mffb.isNull()) continue;
                        resultFields.add(name);
                    }
                }
                serviceMethodConfig = MagicCreateServiceUtils.createInternalRelation(magicFormBean, resultFields, conditionFields, displayName, methodName, businessId, version, metadatas);
                break;
            }
            case TRIGGER_CREATE: {
                List<Map<String, Object>> formData = this.getArgsSet(args, "formData");
                LinkedHashSet<String> triggerCreateFields = new LinkedHashSet<String>();
                if (formData != null && !formData.isEmpty()) {
                    for (Map<String, Object> item : formData) {
                        String name = ParamUtil.getString(item, (String)"name", (String)"");
                        MagicFormFieldBean mffb = magicFormBean.getFieldBeanByName(name);
                        if (mffb.isNull()) continue;
                        triggerCreateFields.add(name);
                    }
                }
                serviceMethodConfig = MagicCreateServiceUtils.createTriggerCreate(magicFormBean, triggerCreateFields, displayName, methodName, businessId, version, metadatas);
                break;
            }
            case TRIGGER_UPDATE: {
                List<Map<String, Object>> formData = this.getArgsSet(args, "formData");
                LinkedHashSet<String> triggerUpdateFields = new LinkedHashSet<String>();
                if (formData != null && !formData.isEmpty()) {
                    for (Map<String, Object> item : formData) {
                        String name = ParamUtil.getString(item, (String)"name", (String)"");
                        MagicFormFieldBean magicFormFieldBean = magicFormBean.getFieldBeanByName(name);
                        if (magicFormFieldBean.isNull()) continue;
                        triggerUpdateFields.add(name);
                    }
                }
                List<Map<String, Object>> triggerUpdateCondition = this.getArgsSet(args, "condition");
                LinkedHashSet<String> triggerUpdateConditionFields = new LinkedHashSet<String>();
                if (triggerUpdateCondition != null && !triggerUpdateCondition.isEmpty()) {
                    for (Map map : triggerUpdateCondition) {
                        String name = ParamUtil.getString((Map)map, (String)"name", (String)"");
                        MagicFormFieldBean mffb = magicFormBean.getFieldBeanByName(name);
                        if (mffb.isNull()) continue;
                        triggerUpdateConditionFields.add(name);
                    }
                }
                serviceMethodConfig = MagicCreateServiceUtils.createTriggerUpdate(magicFormBean, triggerUpdateFields, triggerUpdateConditionFields, displayName, methodName, businessId, version, null, metadatas);
                ServiceMethodConfig queryMethod = MagicCreateServiceUtils.createTriggerQuery(businessId, version, metadatas);
                resultMethod.add(queryMethod);
                break;
            }
            case TRIGGER_DISTRIBUTE: {
                List<Map<String, Object>> formData = this.getArgsSet(args, "formData");
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                if (formData != null && !formData.isEmpty()) {
                    for (Map<String, Object> item : formData) {
                        String name = ParamUtil.getString(item, (String)"name", (String)"");
                        MagicFormFieldBean mffb = magicFormBean.getFieldBeanByName(name);
                        if (mffb.isNull()) continue;
                        linkedHashSet.add(name);
                    }
                }
                List result = (List)params.get("resultFields");
                LinkedHashSet<String> feedBackFields = new LinkedHashSet<String>();
                if (result != null && !result.isEmpty()) {
                    for (Map item : result) {
                        String name = ParamUtil.getString((Map)item, (String)"name", (String)"");
                        MagicFormFieldBean mffb = magicFormBean.getFieldBeanByName(name);
                        if (mffb.isNull()) continue;
                        feedBackFields.add(name);
                    }
                }
                String feedbackMethodName = GenerateUtils.generateRandomMD5((String)"m");
                String feedbackMethodDisplay = "\u53cd\u9988" + magicFormBean.getFormName() + System.currentTimeMillis();
                serviceMethodConfig = MagicCreateServiceUtils.createTriggerDistribution(magicFormBean, linkedHashSet, feedBackFields, displayName, methodName, businessId, version, metadatas, feedbackMethodName);
                ServiceMethodConfig feedBackMethod = MagicCreateServiceUtils.createTriggerFeedBack(magicFormBean, feedBackFields, feedbackMethodDisplay, feedbackMethodName, businessId, version, metadatas);
                resultMethod.add(feedBackMethod);
            }
        }
        if (serviceMethodConfig != null) {
            serviceMethodConfig.addDes(new MagicDisplay(des));
            resultMethod.add(serviceMethodConfig);
        }
        return resultMethod;
    }

    public FormulaDAO getFormulaDAO() {
        return this.formulaDAO;
    }

    public void setFormulaDAO(FormulaDAO formulaDAO) {
        this.formulaDAO = formulaDAO;
    }
}

