/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.create.utils;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.magic.initializer.CAP4MagicCacheInitializer;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.DefinitionSeeyonServiceUtils;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.cap4.magic.vo.MagicFormFieldBean;
import com.seeyon.cap4.validity.ValidityUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.AttributeType;
import com.seeyon.datamagic.engine.domain.base.MagicDisplay;
import com.seeyon.datamagic.engine.domain.base.attr.ListAttrConfig;
import com.seeyon.datamagic.engine.domain.base.attr.MapAttrConfig;
import com.seeyon.datamagic.engine.domain.base.attr.ObjectAttrConfig;
import com.seeyon.datamagic.engine.domain.config.ArgsConfigGuide;
import com.seeyon.datamagic.engine.domain.config.ConfigAnnotation;
import com.seeyon.datamagic.engine.domain.config.ConfigEnum;
import com.seeyon.datamagic.engine.domain.config.EntryAnnotation;
import com.seeyon.datamagic.engine.domain.config.EntryConfigItem;
import com.seeyon.datamagic.engine.domain.config.EnumAnnotation;
import com.seeyon.datamagic.engine.domain.config.ResultConfigGuide;
import com.seeyon.datamagic.engine.domain.metadata.MetadataConfig;
import com.seeyon.datamagic.engine.domain.metadata.ObjAttributeDef;
import com.seeyon.datamagic.engine.domain.service.ReturnConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceArgumentConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import com.seeyon.datamagic.engine.utils.PrivateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;

public class MagicCreateServiceUtils {
    private static final Log LOGGER = CtpLogFactory.getLog(MagicCreateServiceUtils.class);
    private static final String NAME = "ABCDEGHIJKLMNOPQRSTUVWXYZabcdeghijklmnopqrstuvwxyz123456789";

    private MagicCreateServiceUtils() {
    }

    public static List<Map<String, Object>> saveDefaultImpl(String bid, String version, List<ServiceMethodConfig> methodConfigs, MagicFormBean mfb) {
        ArrayList<Map<String, Object>> mappingList = new ArrayList<Map<String, Object>>();
        for (ServiceMethodConfig smc : methodConfigs) {
            mappingList.add(MagicCreateServiceUtils.setDefaultImplMapping(smc, mfb));
        }
        return mappingList;
    }

    public static int invokeStatistics(MagicReflectionRelationPO p) throws BusinessException {
        int invokeCount = 0;
        CAP4FormCacheManager cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        FormBean formBean = cap4FormCacheManager.getForm(p.getFormId());
        if (Strings.isBlank((String)p.getCallingPoint())) {
            return invokeCount;
        }
        MagicEnums.BusinessMethodType b = MagicEnums.BusinessMethodType.valueOfType((int)p.getCallingType());
        if (b != null && formBean != null) {
            String id = p.getCallingPoint().substring(0, p.getCallingPoint().indexOf("_"));
            if (!MagicPrivateUtils.isNumeric(id)) {
                return invokeCount;
            }
            switch (b) {
                case RELATION: 
                case RELATION_USER: 
                case RELATION_SYS: {
                    FormRelationshipBean formRelationshipBean = cap4FormCacheManager.getFormRelationshipBean(Long.parseLong(id));
                    if (formRelationshipBean == null) break;
                    ++invokeCount;
                    break;
                }
                case TRIGGER_CREATE: 
                case TRIGGER_DISTRIBUTE: 
                case TRIGGER_UPDATE: 
                case TRIGGER_FEEDBACK: 
                case QUERY: 
                case OUTERTRGGER: {
                    if (p.getCallingType() == MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK.getType() || p.getCallingType() == MagicEnums.BusinessMethodType.QUERY.getType()) {
                        return invokeCount;
                    }
                    FormTriggerBean triggerBean = cap4FormCacheManager.getFormTriggerBean(Long.parseLong(id));
                    if (triggerBean == null) break;
                    ++invokeCount;
                }
            }
        }
        return invokeCount;
    }

    private static String getThirdHeader(int length) {
        StringBuilder sb = new StringBuilder();
        Random r = new Random();
        int nameSize = NAME.length();
        char[] chars = NAME.toCharArray();
        for (int x = 0; x < length; ++x) {
            int size = r.nextInt(nameSize);
            sb.append(chars[size]);
        }
        if (!sb.toString().equalsIgnoreCase("FFFF")) {
            return sb.toString();
        }
        return MagicCreateServiceUtils.getThirdHeader(length);
    }

    public static String generateBusinessId(MagicEnums.CertificateType certificateType) throws BusinessException {
        if (certificateType == null) {
            throw new BusinessException("certificateType is null");
        }
        String corpId = ValidityUtil.getMplusCorpId();
        if (Strings.isBlank((String)corpId) && MagicEnums.CertificateType.Public_certificate.equals((Object)certificateType)) {
            throw new BusinessException(ResourceUtil.getString((String)"cap.magic.service.create.error1"));
        }
        if (Strings.isBlank((String)corpId)) {
            corpId = String.valueOf(UUIDLong.longUUID());
        }
        String id = MagicCreateServiceUtils.getThirdHeader(4) + corpId + Long.toString(UUIDLong.longUUID(), 16);
        id = id.replaceAll("-", "X");
        return id;
    }

    public static List<Map<String, String>> getDefaultAuth(Long formId, String formType) throws BusinessException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            MagicEnums.ServiceOwnerType st = MagicEnums.ServiceOwnerType.getEnumByType((String)formType);
            if (st != null) {
                List<CapBizConfig> all;
                MagicFormBean mfb = new MagicFormBean(st, formId);
                Long ownerId = mfb.getOwnerId();
                BusinessManager businessManager4 = (BusinessManager)AppContext.getBean((String)"businessManager4");
                if (businessManager4 != null && (all = businessManager4.findAllBizConfig()) != null) {
                    for (CapBizConfig i : all) {
                        if (i.getOwnerId() == null || !i.getOwnerId().equals(ownerId)) continue;
                        HashMap<String, String> auth = new HashMap<String, String>();
                        auth.put("value", String.valueOf(i.getId()));
                        auth.put("name", i.getName());
                        result.add(auth);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return result;
    }

    private static ArgsConfigGuide setTemplate(MagicFormBean formBean) throws BusinessException {
        ArgsConfigGuide result = new ArgsConfigGuide();
        result.setArgsName("template");
        EntryAnnotation e = new EntryAnnotation();
        for (Map<String, Object> t : formBean.getTemplates()) {
            EntryConfigItem item = new EntryConfigItem();
            HashMap<String, String> otherConfig = new HashMap<String, String>();
            otherConfig.put("name", ParamUtil.getString(t, (String)"id"));
            otherConfig.put("displayName", ParamUtil.getString(t, (String)"displayName"));
            item.setName(ParamUtil.getString(t, (String)"id"));
            item.setOtherConfig(otherConfig);
            e.addItem(item);
        }
        result.setGuide((ConfigAnnotation)e);
        return result;
    }

    public static ArgsConfigGuide setDataRight(MagicFormBean formBean, MagicEnums.BusinessMethodType st) {
        ArgsConfigGuide result = new ArgsConfigGuide();
        result.setArgsName("dataRight");
        ArrayList<String> viewOpertaionType = new ArrayList<String>();
        List<Map<String, Object>> data = null;
        switch (st) {
            case RELATION: 
            case RELATION_USER: 
            case RELATION_SYS: {
                viewOpertaionType.add(Enums.FormAuthorizationType.show.getKey());
                data = formBean.getDataRight(viewOpertaionType);
                break;
            }
            case TRIGGER_CREATE: {
                viewOpertaionType.add(Enums.FormAuthorizationType.add.getKey());
                data = formBean.getDataRight(viewOpertaionType);
                break;
            }
            case TRIGGER_UPDATE: {
                viewOpertaionType.add(Enums.FormAuthorizationType.update.getKey());
                data = formBean.getDataRight(viewOpertaionType);
                break;
            }
            case TRIGGER_DISTRIBUTE: {
                viewOpertaionType.add(Enums.FormAuthorizationType.add.getKey());
                viewOpertaionType.add(Enums.FormAuthorizationType.update.getKey());
                data = formBean.getDataRight(viewOpertaionType);
            }
        }
        if (data != null && !data.isEmpty()) {
            EntryAnnotation e = new EntryAnnotation();
            for (Map<String, Object> t : data) {
                EntryConfigItem item = new EntryConfigItem();
                item.setName(ParamUtil.getString(t, (String)"id"));
                item.setOtherConfig(t);
                e.addItem(item);
            }
            result.setGuide((ConfigAnnotation)e);
        }
        return result;
    }

    private static List<ArgsConfigGuide> createTriggerArgsConfigGuide(MagicFormBean mfb, Collection<String> formDatas, Collection<String> condition, MagicEnums.BusinessMethodType st) throws BusinessException {
        ArrayList<ArgsConfigGuide> result = new ArrayList<ArgsConfigGuide>();
        ArgsConfigGuide formData = new ArgsConfigGuide();
        formData.setArgsName("formData");
        formData.setGuide(MagicCreateServiceUtils.createConfigItem(mfb, formDatas, st));
        result.add(formData);
        if (MagicEnums.BusinessMethodType.TRIGGER_CREATE.equals((Object)st)) {
            if (mfb.triggerNeedTemplate()) {
                result.add(MagicCreateServiceUtils.setTemplate(mfb));
            } else {
                result.add(MagicCreateServiceUtils.setDataRight(mfb, MagicEnums.BusinessMethodType.TRIGGER_CREATE));
            }
        } else if (MagicEnums.BusinessMethodType.TRIGGER_UPDATE.equals((Object)st)) {
            ArgsConfigGuide conditionGuide = new ArgsConfigGuide();
            conditionGuide.setArgsName("condition");
            conditionGuide.setGuide(MagicCreateServiceUtils.createConfigItem(mfb, condition, st));
            result.add(conditionGuide);
            if (mfb.triggerNeedTemplate()) {
                result.add(MagicCreateServiceUtils.setTemplate(mfb));
            } else {
                result.add(MagicCreateServiceUtils.setDataRight(mfb, MagicEnums.BusinessMethodType.TRIGGER_UPDATE));
            }
        } else {
            result.add(MagicCreateServiceUtils.setDataRight(mfb, MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE));
        }
        return result;
    }

    private static ConfigAnnotation createConfigItem(MagicFormBean mfb, Collection<String> formFields, MagicEnums.BusinessMethodType st) {
        EntryAnnotation ca = new EntryAnnotation();
        for (String k : formFields) {
            MagicFormFieldBean mffb = mfb.getFieldBeanByName(k);
            if (mffb.isNull()) continue;
            EntryConfigItem eci = new EntryConfigItem();
            eci.setName(k);
            eci.addName(new MagicDisplay(mffb.getDisplay()));
            eci.setInputType(new String[]{ConfigEnum.InputType.FORM_FIELD.getKey()});
            eci.setOtherConfig(mfb.getFormFieldInfo(mffb, st));
            ca.addItem(eci);
        }
        return ca;
    }

    private static ConfigAnnotation createTriggerRight(MagicFormBean mfb) {
        EnumAnnotation ea = new EnumAnnotation();
        ea.setEnumIds(new String[0]);
        ea.setRequired(1);
        ea.setStyle("radio");
        ea.setEnumLevel(new HashMap());
        return ea;
    }

    private static ConfigAnnotation createTriggerTemplate(MagicFormBean mfb) {
        EnumAnnotation ea = new EnumAnnotation();
        ea.setEnumIds(new String[0]);
        ea.setRequired(1);
        ea.setStyle("radio");
        ea.setEnumLevel(new HashMap());
        return ea;
    }

    public static ServiceMethodConfig createRelation(String displayName, String name, String businessId, String version, Map<String, MetadataConfig> metadatas, List<Map<String, Object>> argsSet, List<Map<String, Object>> resultSet) {
        EntryConfigItem cItem;
        String rName;
        ArrayList<ServiceArgumentConfig> argsConfig = new ArrayList<ServiceArgumentConfig>();
        String aObjName = MagicPrivateUtils.getRelationConditionName(businessId, version);
        ServiceArgumentConfig condition = new ServiceArgumentConfig();
        condition.setType(AttributeType.Type.ListArray.getName());
        MagicDisplay conditionDis = new MagicDisplay("\u6761\u4ef6");
        condition.addName(conditionDis);
        condition.setArgsName("condition");
        ListAttrConfig mac = new ListAttrConfig();
        mac.setEntityType(aObjName);
        condition.setLimitConfig(JSONUtil.toJSONString((Object)mac));
        argsConfig.add(condition);
        ServiceArgumentConfig selectedMasterDataId = new ServiceArgumentConfig();
        selectedMasterDataId.setArgsName("selectedToMasterDataId");
        selectedMasterDataId.setType(AttributeType.Type.String.getName());
        MagicDisplay displayNameMasterDataId = new MagicDisplay("\u5df2\u7ecf\u9009\u62e9\u7684\u6570\u636eID");
        selectedMasterDataId.addName(displayNameMasterDataId);
        argsConfig.add(selectedMasterDataId);
        String type = new AttributeType(AttributeType.Type.Integer).getName();
        ServiceArgumentConfig pagee = new ServiceArgumentConfig();
        pagee.setArgsName("page");
        MagicDisplay displayNamePage = new MagicDisplay("\u5206\u9875\u5c5e\u6027-\u9875");
        pagee.addName(displayNamePage);
        pagee.setType(type);
        argsConfig.add(pagee);
        ServiceArgumentConfig pageSizee = new ServiceArgumentConfig();
        pageSizee.setArgsName("pageSize");
        MagicDisplay displayNameSize = new MagicDisplay("\u5206\u9875\u5c5e\u6027-\u6bcf\u9875\u663e\u793a\u591a\u5c11\u6570\u636e");
        pageSizee.addName(displayNameSize);
        pageSizee.setType(type);
        argsConfig.add(pageSizee);
        ReturnConfig rc = new ReturnConfig();
        rc.setType(AttributeType.Type.Customization.getName());
        ObjectAttrConfig subDef = new ObjectAttrConfig();
        HashSet<String> resultKey = new HashSet<String>();
        for (Map<String, Object> resultSetEntry : resultSet) {
            String resultItemName = ParamUtil.getString(resultSetEntry, (String)"name", (String)"");
            if (!Strings.isNotBlank((String)resultItemName)) continue;
            resultKey.add(resultItemName);
        }
        subDef.setName(MagicPrivateUtils.getRelationResultDataName(businessId, version, resultKey));
        subDef.setType(subDef.getName());
        subDef.setCustom(true);
        rc.setLimitConfig(JSONUtil.toJSONString((Object)subDef));
        ServiceMethodConfig interfaceDefineEntity = new ServiceMethodConfig();
        interfaceDefineEntity.setMethodName(name);
        interfaceDefineEntity.setArgsConfig(argsConfig);
        interfaceDefineEntity.setReturnConfig(rc);
        interfaceDefineEntity.addName(new MagicDisplay(displayName));
        if (argsSet == null || argsSet.isEmpty()) {
            interfaceDefineEntity.setServiceType(MagicEnums.BusinessMethodType.RELATION_USER.getName());
        } else {
            interfaceDefineEntity.setServiceType(MagicEnums.BusinessMethodType.RELATION.getName());
        }
        if (argsSet != null && !argsSet.isEmpty()) {
            ArrayList<ArgsConfigGuide> acg = new ArrayList<ArgsConfigGuide>(1);
            ArgsConfigGuide conditionGuide = new ArgsConfigGuide();
            conditionGuide.setArgsName("condition");
            EntryAnnotation eaa = new EntryAnnotation();
            for (Map<String, Object> r : argsSet) {
                rName = ParamUtil.getString(r, (String)"name", (String)"");
                if (Strings.isBlank((String)rName)) continue;
                cItem = new EntryConfigItem();
                cItem.setName(rName);
                cItem.setOtherConfig(r);
                eaa.addItem(cItem);
            }
            conditionGuide.setGuide((ConfigAnnotation)eaa);
            acg.add(conditionGuide);
            interfaceDefineEntity.setArgsConfigGuide(acg);
        }
        Map<String, MetadataConfig> config = MagicPrivateUtils.setRelationResultMetadatas(businessId, version, resultSet, resultKey);
        MetadataConfig condtionc = DefinitionSeeyonServiceUtils.getStandardRCondtion();
        condtionc.setObjName(aObjName);
        if (metadatas != null) {
            metadatas.putAll(config);
            metadatas.put(condtionc.getObjName(), condtionc);
        }
        ResultConfigGuide rcg = new ResultConfigGuide();
        for (Map<String, Object> r : resultSet) {
            rName = ParamUtil.getString(r, (String)"name", (String)"");
            if (Strings.isBlank((String)rName)) continue;
            cItem = new EntryConfigItem();
            cItem.setName(rName);
            cItem.setOtherConfig(r);
            rcg.addItem(cItem);
        }
        interfaceDefineEntity.setResultConfigGuide(rcg);
        return interfaceDefineEntity;
    }

    public static Map<String, Object> setDefaultImplMapping(ServiceMethodConfig smc, MagicFormBean mfb) {
        HashMap<String, Map<String, String>> otherSet = new HashMap<String, Map<String, String>>();
        otherSet.put("tableName", mfb.getFormTableMapping());
        String methodName = smc.getMethodName();
        HashMap<String, Object> methodMapping = new HashMap<String, Object>();
        if (smc.getResultConfigGuide() != null && smc.getResultConfigGuide().getConfigList() != null) {
            HashMap<String, String> resultMapping = new HashMap<String, String>();
            for (EntryConfigItem e : smc.getResultConfigGuide().getConfigList()) {
                resultMapping.put(e.getName(), e.getName());
            }
            if (!resultMapping.isEmpty()) {
                methodMapping.put("resultMapping", resultMapping);
            }
        }
        HashMap<String, Map<Object, Object>> argsMapping = new HashMap<String, Map<Object, Object>>();
        if (smc.getArgsConfigGuide() != null && !smc.getArgsConfigGuide().isEmpty()) {
            for (ArgsConfigGuide s : smc.getArgsConfigGuide()) {
                if ("condition".equals(s.getArgsName())) {
                    HashMap<String, String> conditionMapping = new HashMap<String, String>();
                    for (EntryConfigItem eci : ((EntryAnnotation)s.loadGuide()).getConfigList()) {
                        conditionMapping.put(eci.getName(), eci.getName());
                    }
                    argsMapping.put("condition", conditionMapping);
                    continue;
                }
                if ("formData".equals(s.getArgsName())) {
                    HashMap<String, String> formDataMapping = new HashMap<String, String>();
                    for (EntryConfigItem eci : ((EntryAnnotation)s.loadGuide()).getConfigList()) {
                        formDataMapping.put(eci.getName(), eci.getName());
                    }
                    argsMapping.put("formData", formDataMapping);
                    continue;
                }
                if ("dataRight".equals(s.getArgsName())) {
                    argsMapping.put("dataRight", mfb.getRightMapping());
                    continue;
                }
                if (!"template".equals(s.getArgsName())) continue;
                argsMapping.put("template", mfb.getTemplateMapping());
            }
        }
        if (MagicEnums.BusinessMethodType.RELATION_USER.getName().equals(smc.getServiceType()) || MagicEnums.BusinessMethodType.RELATION.getName().equals(smc.getServiceType())) {
            argsMapping.put("dataRight", mfb.getRightMapping());
        }
        if (!argsMapping.isEmpty()) {
            methodMapping.put("argsMapping", argsMapping);
        }
        if (!methodMapping.isEmpty()) {
            methodMapping.put("methodName", methodName);
            methodMapping.put("otherSet", otherSet);
        }
        return methodMapping;
    }

    public static ServiceMethodConfig createInternalRelation(MagicFormBean targetFormBean, Collection<String> resultFields, Collection<String> argsFields, String displayName, String name, String businessId, String version, Map<String, MetadataConfig> metadatas) throws BusinessException {
        ArrayList<Map<String, Object>> argsSet = new ArrayList<Map<String, Object>>();
        if (argsFields != null) {
            for (String string : argsFields) {
                MagicFormFieldBean ffb = targetFormBean.getFieldBeanByName(string);
                if (ffb.isNull()) continue;
                argsSet.add(targetFormBean.getFormFieldInfo(ffb, MagicEnums.BusinessMethodType.RELATION_USER));
            }
        }
        ArrayList<Map<String, Object>> resultSet = new ArrayList<Map<String, Object>>();
        for (String k : resultFields) {
            MagicFormFieldBean ffb = targetFormBean.getFieldBeanByName(k);
            if (ffb.isNull()) continue;
            resultSet.add(targetFormBean.getFormFieldInfo(ffb, MagicEnums.BusinessMethodType.RELATION_USER));
        }
        ServiceMethodConfig serviceMethodConfig = MagicCreateServiceUtils.createRelation(displayName, name, businessId, version, metadatas, argsSet, resultSet);
        serviceMethodConfig.addArgumentConfigGuide(MagicCreateServiceUtils.setDataRight(targetFormBean, MagicEnums.BusinessMethodType.RELATION));
        serviceMethodConfig.addOtherAttr("resultKey", resultFields);
        serviceMethodConfig.addOtherAttr("dataRight", (Object)targetFormBean.getDataRight());
        Map<String, String> limit = MagicPrivateUtils.getFieldLists(targetFormBean, resultFields, MagicEnums.BusinessMethodType.RELATION);
        if (argsFields != null && !argsFields.isEmpty()) {
            serviceMethodConfig.addOtherAttr("condition", argsFields);
            limit.putAll(MagicPrivateUtils.getFieldLists(targetFormBean, argsFields, MagicEnums.BusinessMethodType.RELATION));
        }
        serviceMethodConfig.addOtherAttr("fieldLimit", limit);
        serviceMethodConfig.addOtherAttr("tableName", targetFormBean.getFormTableMapping());
        return serviceMethodConfig;
    }

    public static ServiceMethodConfig createTriggerCreate(MagicFormBean targetFormBean, Collection<String> fillBackNames, String displayName, String name, String bid, String version, Map<String, MetadataConfig> metadatas) throws BusinessException {
        MagicDisplay templateName;
        ArrayList<ServiceArgumentConfig> argsConfig = new ArrayList<ServiceArgumentConfig>();
        HashMap<String, List<MagicFormFieldBean>> formFieldSort = new HashMap<String, List<MagicFormFieldBean>>();
        for (String string : fillBackNames) {
            MagicFormFieldBean field = targetFormBean.getFieldBeanByName(string);
            ArrayList<MagicFormFieldBean> tempFieldSet = (ArrayList<MagicFormFieldBean>)formFieldSort.get(field.getOwnerTableName());
            if (tempFieldSet == null) {
                tempFieldSet = new ArrayList<MagicFormFieldBean>();
                formFieldSort.put(field.getOwnerTableName(), tempFieldSet);
            }
            tempFieldSet.add(field);
        }
        Map<String, MetadataConfig> metaDataMap = MagicPrivateUtils.setTriggerCreateArgs(bid, version, targetFormBean, formFieldSort);
        for (String names : fillBackNames) {
            metaDataMap.remove(names);
        }
        MetadataConfig metadataConfig = MagicPrivateUtils.getCreateReturnObj(bid, version, targetFormBean.getId());
        metaDataMap.put(metadataConfig.getObjName(), metadataConfig);
        if (metadatas != null) {
            metadatas.putAll(metaDataMap);
        }
        String argsName = MagicPrivateUtils.getArgsObjName(bid, version, fillBackNames);
        ServiceArgumentConfig formData = new ServiceArgumentConfig();
        formData.setArgsName("formData");
        ListAttrConfig lac = new ListAttrConfig();
        lac.setEntityType(argsName);
        formData.setType(AttributeType.Type.ListArray.getName());
        formData.setLimitConfig(JSONUtil.toJSONString((Object)lac));
        MagicDisplay formDataDisp = new MagicDisplay("\u8868\u5355\u6570\u636e");
        formData.addName(formDataDisp);
        argsConfig.add(formData);
        if (targetFormBean.triggerNeedTemplate()) {
            ServiceArgumentConfig templateArgs = new ServiceArgumentConfig();
            templateArgs.setArgsName("template");
            templateArgs.setType(AttributeType.Type.Long.getName());
            templateName = new MagicDisplay("\u6a21\u7248Id");
            templateArgs.addName(templateName);
            argsConfig.add(templateArgs);
        } else {
            ServiceArgumentConfig rightArgs = new ServiceArgumentConfig();
            rightArgs.setArgsName("dataRight");
            rightArgs.setType(AttributeType.Type.String.getName());
            templateName = new MagicDisplay("\u6743\u9650Id");
            rightArgs.addName(templateName);
            argsConfig.add(rightArgs);
        }
        ReturnConfig rc = new ReturnConfig();
        rc.setType(AttributeType.Type.ListArray.getName());
        ListAttrConfig oac = new ListAttrConfig();
        oac.setEntityType(metadataConfig.getObjName());
        String aLimitConfig = JSONUtil.toJSONString((Object)oac);
        rc.setLimitConfig(aLimitConfig);
        ServiceMethodConfig interfaceDefineEntity = new ServiceMethodConfig();
        interfaceDefineEntity.setMethodName(name);
        interfaceDefineEntity.setArgsConfig(argsConfig);
        interfaceDefineEntity.setReturnConfig(rc);
        interfaceDefineEntity.addName(new MagicDisplay(displayName));
        interfaceDefineEntity.setServiceType(MagicEnums.BusinessMethodType.TRIGGER_CREATE.getName());
        interfaceDefineEntity.addOtherAttr("fillback", fillBackNames);
        interfaceDefineEntity.addOtherAttr("dataRight", (Object)targetFormBean.getDataRight());
        interfaceDefineEntity.addOtherAttr("fieldLimit", MagicPrivateUtils.getFieldLists(targetFormBean, fillBackNames, MagicEnums.BusinessMethodType.TRIGGER_CREATE));
        interfaceDefineEntity.addOtherAttr("tableName", targetFormBean.getFormTableMapping());
        List<Map<String, Object>> templates = targetFormBean.getTemplates();
        interfaceDefineEntity.addOtherAttr("templates", templates);
        interfaceDefineEntity.setArgsConfigGuide(MagicCreateServiceUtils.createTriggerArgsConfigGuide(targetFormBean, fillBackNames, null, MagicEnums.BusinessMethodType.TRIGGER_CREATE));
        return interfaceDefineEntity;
    }

    public static ServiceMethodConfig createTriggerDistribution(MagicFormBean targetFormBean, Collection<String> fillBackNames, Collection<String> feedBackFieldNames, String displayName, String name, String bid, String version, Map<String, MetadataConfig> metadatas, String feedbackMethodName) throws BusinessException {
        ServiceMethodConfig method = MagicCreateServiceUtils.createTriggerCreate(targetFormBean, fillBackNames, displayName, name, bid, version, metadatas);
        method.getArgsConfigGuide().clear();
        method.setArgsConfigGuide(MagicCreateServiceUtils.createTriggerArgsConfigGuide(targetFormBean, fillBackNames, null, MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE));
        method.setServiceType(MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE.getName());
        method.addOtherAttr("fillback", fillBackNames);
        method.addOtherAttr("dataRight", (Object)targetFormBean.getDataRight());
        method.addOtherAttr("resultKey", feedBackFieldNames);
        method.addOtherAttr("feedback_id", (Object)feedbackMethodName);
        ArrayList<String> copyFillBack = new ArrayList<String>();
        copyFillBack.addAll(feedBackFieldNames);
        copyFillBack.addAll(fillBackNames);
        Map<String, String> limit = MagicPrivateUtils.getFieldLists(targetFormBean, copyFillBack, MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE);
        method.addOtherAttr("fieldLimit", limit);
        method.addOtherAttr("tableName", targetFormBean.getFormTableMapping());
        ResultConfigGuide rcg = new ResultConfigGuide();
        for (String k : feedBackFieldNames) {
            MagicFormFieldBean ffb = targetFormBean.getFieldBeanByName(k);
            EntryConfigItem cItem = new EntryConfigItem();
            cItem.setName(k);
            cItem.setOtherConfig(targetFormBean.getFormFieldInfo(ffb, MagicEnums.BusinessMethodType.TRIGGER_CREATE));
            rcg.addItem(cItem);
        }
        method.setResultConfigGuide(rcg);
        return method;
    }

    public static ServiceMethodConfig createTriggerFeedBack(MagicFormBean targetFormBean, Collection<String> feedBackFieldNames, String displayName, String name, String bid, String version, Map<String, MetadataConfig> metadatas) {
        ServiceMethodConfig interfaceDefineEntity = new ServiceMethodConfig();
        HashMap<String, List<MagicFormFieldBean>> feedBackFieldBean = new HashMap<String, List<MagicFormFieldBean>>();
        for (String field : feedBackFieldNames) {
            MagicFormFieldBean currentFieldBean = targetFormBean.getFieldBeanByName(field);
            if (currentFieldBean == null) continue;
            String ownerTableName = currentFieldBean.getOwnerTableName();
            ArrayList<MagicFormFieldBean> tempFieldSet = (ArrayList<MagicFormFieldBean>)feedBackFieldBean.get(ownerTableName);
            if (tempFieldSet == null) {
                tempFieldSet = new ArrayList<MagicFormFieldBean>();
                feedBackFieldBean.put(ownerTableName, tempFieldSet);
            }
            tempFieldSet.add(currentFieldBean);
            feedBackFieldNames.add(currentFieldBean.getName());
        }
        ArrayList<ServiceArgumentConfig> argsConfig = new ArrayList<ServiceArgumentConfig>();
        ServiceArgumentConfig dataIdArgs = new ServiceArgumentConfig();
        dataIdArgs.setArgsName("dataId");
        ListAttrConfig lac = new ListAttrConfig();
        lac.setEntityType(AttributeType.Type.String.getName());
        String aLimitConfig = JSONUtils.getJSonString(lac);
        dataIdArgs.setType(AttributeType.Type.ListArray.getName());
        dataIdArgs.setLimitConfig(aLimitConfig);
        MagicDisplay dataIdDis = new MagicDisplay("\u6570\u636eID");
        dataIdArgs.addName(dataIdDis);
        argsConfig.add(dataIdArgs);
        ServiceArgumentConfig rightArgs = new ServiceArgumentConfig();
        rightArgs.setArgsName("dataRight");
        rightArgs.setType(AttributeType.Type.String.getName());
        MagicDisplay templateName = new MagicDisplay("\u65b0\u5efa\u6743\u9650Id  \u5982\u679c\u6ca1\u6709\u65b0\u5efa\u6743\u9650 \u5219\u53ef\u80fd\u4e0d\u4f1a\u8fd4\u56de\u6570\u636e");
        rightArgs.addName(templateName);
        argsConfig.add(rightArgs);
        interfaceDefineEntity.setServiceType(MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK.getName());
        interfaceDefineEntity.setMethodName(name);
        Map<String, MetadataConfig> config = MagicPrivateUtils.setFeedBackResult(bid, version, targetFormBean, feedBackFieldNames, feedBackFieldBean);
        metadatas.putAll(config);
        MetadataConfig mc = MagicPrivateUtils.setQueryReturnObj(bid, version);
        metadatas.put(mc.getObjName(), mc);
        interfaceDefineEntity.addOtherAttr("resultKey", feedBackFieldNames);
        interfaceDefineEntity.addOtherAttr("dataRight", (Object)targetFormBean.getDataRight());
        Map<String, String> limit = MagicPrivateUtils.getFieldLists(targetFormBean, feedBackFieldNames, MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK);
        interfaceDefineEntity.addOtherAttr("fieldLimit", limit);
        interfaceDefineEntity.addOtherAttr("tableName", targetFormBean.getFormTableMapping());
        interfaceDefineEntity.addName(new MagicDisplay(displayName));
        interfaceDefineEntity.setArgsConfig(argsConfig);
        ReturnConfig rc = new ReturnConfig();
        rc.setType(AttributeType.Type.ListArray.getName());
        lac = new ListAttrConfig();
        lac.setEntityType(mc.getObjName());
        aLimitConfig = JSONUtils.getJSonString(lac);
        rc.setLimitConfig(aLimitConfig);
        interfaceDefineEntity.setReturnConfig(rc);
        return interfaceDefineEntity;
    }

    public static Map<String, Object> showServiceImplInfo(String serviceName, MagicServiceProviderPO p) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(p.getSourceType()) || MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(p.getSourceType())) {
            Map ext2Mapper;
            MagicFormBean mfb = new MagicFormBean(MagicEnums.ServiceOwnerType.getEnumByType((String)p.getSourceType()), Long.parseLong(p.getSource()));
            HashMap<String, String> targetFormInfo = new HashMap<String, String>();
            if (!mfb.isNull()) {
                targetFormInfo.put("id", String.valueOf(mfb.getId()));
                BusinessManager businessManager4 = (BusinessManager)AppContext.getBean((String)"businessManager4");
                if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(p.getSourceType())) {
                    BizConfigBean biz = businessManager4.findBizConfigByFormId(mfb.getId());
                    if (biz != null) {
                        targetFormInfo.put("name", "(" + biz.getName() + ")" + mfb.getFormName());
                    } else {
                        targetFormInfo.put("name", mfb.getFormName());
                    }
                } else {
                    targetFormInfo.put("name", mfb.getFormName());
                }
                targetFormInfo.put("type", mfb.getType().getType());
                result.put("targetTableName", "CAP." + mfb.getFormName());
            } else {
                result.put("targetTableName", "-");
            }
            result.put("targetInfo", targetFormInfo);
            result.put("type", ResourceUtil.getString((String)"cap.bizSetup.detail.form"));
            if (Strings.isNotBlank((String)p.getExt2()) && (ext2Mapper = JSONUtils.parseJSonStr_Class(p.getExt2(), Map.class)).containsKey("scopeSet")) {
                ext2Mapper.remove("id");
                result.put("scopeSet", ext2Mapper.get("scopeSet"));
            }
        } else if (MagicEnums.ProviderType.DEFAULT_DEE.getType().equals(p.getSourceType())) {
            result.put("type", ResourceUtil.getString((String)"form.businesstype.deetask.label"));
            result.put("provider", "-");
        } else {
            result.put("type", "\u5916\u90e8\u7cfb\u7edf");
            result.put("targetTableName", p.getSource());
        }
        if (Strings.isNotBlank((String)p.getExt1())) {
            result.put("methodMapping", JSONUtils.parseJSonStr_Class(p.getExt1(), List.class));
        } else {
            result.put("methodMapping", Collections.emptyList());
        }
        result.put("businessId", p.getBusinessId());
        result.put("version", p.getVersionId());
        result.put("id", String.valueOf(p.getId()));
        result.put("name", p.getDisplayName());
        result.put("serviceName", serviceName);
        result.put("status", p.getStatus());
        result.put("statusText", MagicEnums.ProviderStatus.valueOfType((int)p.getStatus()).getI18nText());
        return result;
    }

    public static MagicServiceSummary convertServiceToPo(ServiceConfig sc) {
        MagicServiceSummary mss = new MagicServiceSummary();
        mss.setIdIfNew();
        if (sc.getOtherAttrs() != null) {
            Map authInfo = (Map)sc.getOtherAttrs().get("authInfo");
            if (authInfo != null && !authInfo.isEmpty()) {
                String authType = ParamUtil.getString((Map)authInfo, (String)"authType", (String)"");
                if (MagicEnums.ServiceAuthType.USERDEFINED.getName().equals(authType)) {
                    mss.setAuthorizationType(Integer.valueOf(MagicEnums.ServiceAuthType.USERDEFINED.getKey()));
                    List oldBizInfos = (List)authInfo.get("authInfo");
                    if (oldBizInfos != null) {
                        mss.setAuthorizationInfo(JSONUtils.getJSonString(oldBizInfos));
                    }
                } else {
                    mss.setAuthorizationType(Integer.valueOf(MagicEnums.ServiceAuthType.PUBLIC.getKey()));
                }
            } else {
                mss.setAuthorizationType(Integer.valueOf(MagicEnums.ServiceAuthType.PUBLIC.getKey()));
            }
        }
        mss.setOwnerType(sc.getOwnerType());
        mss.setOwner(sc.getOwner());
        if (sc.getDisplayName() != null && !sc.getDisplayName().isEmpty()) {
            mss.setNameDisplay(((MagicDisplay)sc.getDisplayName().get(0)).getText());
        }
        if (sc.getDes() != null && !sc.getDes().isEmpty()) {
            mss.setDescription(((MagicDisplay)sc.getDes().get(0)).getText());
        }
        mss.setBusinessType(sc.getBusinessType());
        if (MagicEnums.CertificateType.Public_certificate.getName().equals(sc.getCertificateType())) {
            mss.setCertificateType(Integer.valueOf(MagicEnums.CertificateType.Public_certificate.getKey()));
        } else {
            mss.setCertificateType(Integer.valueOf(MagicEnums.CertificateType.Private_certificate.getKey()));
        }
        mss.setBusinessVersion(sc.getVersion());
        mss.setBusinessId(sc.getBusinessId());
        if (sc.getMetadata() != null && sc.getMetadata().getMetadatas() != null && !sc.getMetadata().getMetadatas().isEmpty()) {
            mss.setMetadata(JSONUtil.toJSONString((Object)sc.getMetadata().getMetadatas()));
        }
        mss.setCreateDate(DateUtil.currentDate());
        mss.setCreateId(Long.valueOf(AppContext.currentUserId()));
        mss.setModifyDate(mss.getCreateDate());
        return mss;
    }

    public static MagicInterfaceDefineEntity convertMethodToPoForOutService(String businessId, String version, String serviceType, Long id, ServiceMethodConfig mc) {
        MagicInterfaceDefineEntity e = new MagicInterfaceDefineEntity();
        e.setId(id);
        e.setBusinessId(businessId);
        e.setVersionId(version);
        e.setCreateDate(new Date());
        String serviceTypes = mc.getServiceType();
        if (MagicPrivateUtils.isNumeric(serviceTypes)) {
            e.setServiceType(Integer.valueOf(serviceTypes).intValue());
        }
        e.setMethodName(mc.getMethodName());
        if (mc.getDisplayName() != null && !mc.getDisplayName().isEmpty()) {
            e.setName(((MagicDisplay)mc.getDisplayName().get(0)).getText());
        }
        HashMap<String, Cloneable> ext1 = new HashMap<String, Cloneable>();
        HashMap fieldLimit = new HashMap();
        ArrayList<String> resultKey = new ArrayList<String>();
        ResultConfigGuide resultConfiGuide = mc.getResultConfigGuide();
        if (resultConfiGuide != null) {
            List guides = resultConfiGuide.getConfigList();
            if (guides != null && !guides.isEmpty()) {
                for (EntryConfigItem ci : guides) {
                    Map other = ci.getOtherConfig();
                    HashMap<String, String> fieldLimitItem = new HashMap<String, String>();
                    if (other != null) {
                        fieldLimitItem.putAll(other);
                    }
                    if (ci.getDisplayName() != null && ci.getDisplayName().size() > 0) {
                        fieldLimitItem.put("displayName", ((MagicDisplay)ci.getDisplayName().get(0)).getText());
                    }
                    fieldLimit.put(ci.getName(), fieldLimitItem);
                    resultKey.add(ci.getName());
                }
            }
            ext1.put("fieldLimit", fieldLimit);
            ext1.put("resultKey", resultKey);
        }
        e.setExt1(JSONUtil.toJSONString(ext1));
        e.setExt2(MagicPrivateUtils.setExt2Info());
        e.setSubType(serviceType);
        e.setExt3(String.valueOf(CAP4MagicCacheInitializer.getLatestUpdateVersion()));
        e.setArgsConfig(JSONUtils.getJSonString(mc.getArgsConfig()));
        e.setResultConfig(JSONUtils.getJSonString(mc.getReturnConfig()));
        Map other = mc.getOtherAttr();
        if (other != null) {
            e.setOtherAttr(JSONUtils.getJSonString(other));
        }
        e.setArgsConfigGuide(JSONUtils.getJSonString(mc.getArgsConfigGuide()));
        e.setResultConfigGuide(JSONUtils.getJSonString(mc.getResultConfigGuide()));
        return e;
    }

    public static MagicInterfaceDefineEntity convertMethodToPo(String ownerType, String owner, String bid, String version, ServiceMethodConfig method) {
        MagicInterfaceDefineEntity result = new MagicInterfaceDefineEntity();
        result.setIdIfNew();
        if (method.getResultConfigGuide() != null) {
            result.setResultConfigGuide(JSONUtils.getJSonString(method.getResultConfigGuide()));
        }
        result.setResultConfig(JSONUtils.getJSonString(method.getReturnConfig()));
        result.setName(MagicCreateServiceUtils.getDefaultDisplay(method.getDisplayName()));
        result.setDescription(MagicCreateServiceUtils.getDefaultDisplay(method.getDes()));
        if (method.getArgsConfig() != null) {
            result.setArgsConfig(JSONUtils.getJSonString(method.getArgsConfig()));
        }
        result.setMethodName(method.getMethodName());
        result.setBusinessId(bid);
        result.setVersionId(version);
        result.setCategory(MagicEnums.CertificateType.Private_certificate.getKey());
        result.setCreateDate(DateUtil.currentDate());
        result.setModifyDate(result.getCreateDate());
        result.setServiceType(MagicEnums.BusinessMethodType.valueOfName((String)method.getServiceType()).getType());
        result.setSubType(ownerType);
        if ((MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(ownerType) || MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(ownerType)) && MagicPrivateUtils.isNumeric(owner)) {
            result.setFormId(Long.parseLong(owner));
        }
        result.setExt1(JSONUtils.getJSonString(method.getOtherAttr()));
        result.setExt3(String.valueOf(CAP4MagicCacheInitializer.getLatestUpdateVersion()));
        if (method.getArgsConfigGuide() != null) {
            result.setArgsConfigGuide(JSONUtil.toJSONString((Object)method.getArgsConfigGuide()));
        }
        if (method.getResultConfigGuide() != null) {
            result.setResultConfigGuide(JSONUtil.toJSONString((Object)method.getResultConfigGuide()));
        }
        if (method.getDes() != null && !method.getDes().isEmpty()) {
            result.setDescription(((MagicDisplay)method.getDes().get(0)).getText());
        }
        return result;
    }

    private static String getDefaultDisplay(List<MagicDisplay> allDisplay) {
        if (allDisplay == null || allDisplay.isEmpty()) {
            return "";
        }
        Locale locale = AppContext.getLocale();
        for (MagicDisplay m : allDisplay) {
            if (m == null || !locale.getLanguage().equals(m.getLanguage()) || !locale.getCountry().equals(m.getCountry())) continue;
            return m.getText();
        }
        MagicDisplay m = allDisplay.get(0);
        if (m == null) {
            return "";
        }
        return m.getText();
    }

    public static MagicServiceSummary createServiceSummary(String business, String version, MagicFormBean formBean, Map<String, MetadataConfig> allMetadatas, MagicEnums.CertificateType certificateType) throws BusinessException {
        MagicServiceSummary mss = new MagicServiceSummary();
        mss.setIdIfNew();
        mss.setBusinessId(business);
        mss.setBusinessVersion(version);
        mss.setBusinessType(MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey());
        mss.setCertificateType(Integer.valueOf(certificateType.getKey()));
        mss.setOwnerType(formBean.getType().getType());
        mss.setOwner(String.valueOf(formBean.getId()));
        mss.setNameDisplay(formBean.getFormName());
        mss.setMetadata(JSONUtils.getJSonString(allMetadatas.values()));
        mss.setCreateId(Long.valueOf(AppContext.currentUserId()));
        mss.setCreateDate(DateUtil.currentDate());
        mss.setModifyDate(mss.getCreateDate());
        mss.setAuthorizationType(Integer.valueOf(MagicEnums.ServiceAuthType.PRIVATE.getKey()));
        return mss;
    }

    public static ServiceMethodConfig createTriggerQuery(String bId, String vId, Map<String, MetadataConfig> metadataConfigMap) {
        ServiceMethodConfig result = new ServiceMethodConfig();
        MetadataConfig mc = MagicPrivateUtils.setQueryReturnObj(bId, vId);
        metadataConfigMap.put(mc.getObjName(), mc);
        MetadataConfig feedbackItem = MagicPrivateUtils.getFeedBackValueObj(bId, vId);
        metadataConfigMap.put(feedbackItem.getObjName(), feedbackItem);
        ArrayList<ServiceArgumentConfig> args = new ArrayList<ServiceArgumentConfig>();
        ServiceArgumentConfig resultListArgs = new ServiceArgumentConfig();
        resultListArgs.setArgsName("resultFields");
        ListAttrConfig lac = new ListAttrConfig();
        lac.setEntityType(AttributeType.Type.String.getName());
        String aLimitConfig = JSONUtils.getJSonString(lac);
        resultListArgs.setType(AttributeType.Type.ListArray.getName());
        resultListArgs.setLimitConfig(aLimitConfig);
        MagicDisplay dataIdDis = new MagicDisplay("\u9700\u8981\u8fd4\u56de\u7ed3\u679c\u5b57\u6bb5\u5217\u8868");
        resultListArgs.addName(dataIdDis);
        args.add(resultListArgs);
        ServiceArgumentConfig condition = new ServiceArgumentConfig();
        condition.setType(AttributeType.Type.Map.getName());
        MagicDisplay conditionDis = new MagicDisplay("\u6761\u4ef6");
        condition.addName(conditionDis);
        condition.setArgsName("condition");
        MapAttrConfig mac = new MapAttrConfig();
        mac.setKeyType(AttributeType.Type.String.getName());
        mac.setVelueType(AttributeType.Type.Object.getName());
        condition.setLimitConfig(JSONUtils.getJSonString(mac));
        args.add(condition);
        ReturnConfig aReturnConfig = new ReturnConfig();
        aReturnConfig.setType(AttributeType.Type.ListArray.getName());
        lac = new ListAttrConfig();
        lac.setEntityType(mc.getObjName());
        aLimitConfig = JSONUtils.getJSonString(lac);
        aReturnConfig.setLimitConfig(aLimitConfig);
        String aMethodName = "m" + PrivateUtils.generateMD5((String)bId);
        result.setArgsConfig(args);
        result.setMethodName(aMethodName);
        result.setReturnConfig(aReturnConfig);
        result.setServiceType(MagicEnums.BusinessMethodType.QUERY.getName());
        result.addName(new MagicDisplay("\u67e5\u8be2\u63a5\u53e3"));
        return result;
    }

    public static ServiceMethodConfig createTriggerUpdate(MagicFormBean targetFormBean, Set<String> fillBackNames, Set<String> conditionFieldSet, String displayName, String name, String bid, String version, Set<String> allQuerySet, Map<String, MetadataConfig> metadatas) throws BusinessException {
        ArrayList<ServiceArgumentConfig> argsConfig = new ArrayList<ServiceArgumentConfig>();
        if (allQuerySet == null) {
            allQuerySet = Collections.EMPTY_SET;
        }
        HashMap<String, List<MagicFormFieldBean>> formFieldSort = new HashMap<String, List<MagicFormFieldBean>>();
        for (String string : fillBackNames) {
            MagicFormFieldBean magicFormFieldBean = targetFormBean.getFieldBeanByName(string);
            ArrayList<MagicFormFieldBean> tempFieldSet = (ArrayList<MagicFormFieldBean>)formFieldSort.get(magicFormFieldBean.getOwnerTableName());
            if (tempFieldSet == null) {
                tempFieldSet = new ArrayList<MagicFormFieldBean>();
                formFieldSort.put(magicFormFieldBean.getOwnerTableName(), tempFieldSet);
            }
            tempFieldSet.add(magicFormFieldBean);
        }
        Map<String, MetadataConfig> metadata = MagicPrivateUtils.setTriggerCreateArgs(bid, version, targetFormBean, formFieldSort);
        for (String string : fillBackNames) {
            metadata.remove(string);
        }
        if (metadatas != null) {
            metadatas.putAll(metadata);
        }
        HashMap<String, List<MagicFormFieldBean>> hashMap = new HashMap<String, List<MagicFormFieldBean>>();
        for (String s : conditionFieldSet) {
            MagicFormFieldBean field = targetFormBean.getFieldBeanByName(s);
            ArrayList tempFieldSet = (ArrayList)hashMap.get(field.getOwnerTableName());
            if (tempFieldSet != null) continue;
            tempFieldSet = new ArrayList();
            hashMap.put(field.getOwnerTableName(), tempFieldSet);
        }
        Map<String, MetadataConfig> map = MagicPrivateUtils.setTriggerConditionArgs(bid, version, targetFormBean, hashMap);
        MetadataConfig returnObj = MagicPrivateUtils.getCreateReturnObj(bid, version, targetFormBean.getId());
        if (null != metadatas) {
            metadatas.putAll(map);
            metadatas.put(returnObj.getObjName(), returnObj);
        }
        String argsName = MagicPrivateUtils.getArgsObjName(bid, version, fillBackNames);
        ServiceArgumentConfig formData = new ServiceArgumentConfig();
        formData.setArgsName("formData");
        ListAttrConfig lac = new ListAttrConfig();
        lac.setEntityType(argsName);
        formData.setType(AttributeType.Type.ListArray.getName());
        formData.setLimitConfig(JSONUtil.toJSONString((Object)lac));
        MagicDisplay formDataDisp = new MagicDisplay("\u8868\u5355\u6570\u636e");
        formData.addName(formDataDisp);
        argsConfig.add(formData);
        ServiceArgumentConfig newlineArgs = new ServiceArgumentConfig();
        newlineArgs.setArgsName("newline");
        newlineArgs.setType(AttributeType.Type.Integer.getName());
        MagicDisplay newlineName = new MagicDisplay("\u65b0\u589e\u660e\u7ec6\u884c");
        newlineArgs.addName(newlineName);
        argsConfig.add(newlineArgs);
        ServiceArgumentConfig remindUserArgs = new ServiceArgumentConfig();
        remindUserArgs.setArgsName("remindUser");
        remindUserArgs.setType(AttributeType.Type.Integer.getName());
        MagicDisplay remindUserArgsName = new MagicDisplay("\u672a\u5339\u914d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e\u65f6\uff0c\u63d0\u9192\u7528\u6237");
        remindUserArgs.addName(remindUserArgsName);
        argsConfig.add(remindUserArgs);
        if (targetFormBean.triggerNeedTemplate()) {
            ServiceArgumentConfig templateArgs = new ServiceArgumentConfig();
            templateArgs.setArgsName("template");
            templateArgs.setType(AttributeType.Type.Long.getName());
            MagicDisplay templateArgsName = new MagicDisplay("\u6a21\u7248Id");
            templateArgs.addName(templateArgsName);
            argsConfig.add(templateArgs);
        } else {
            ServiceArgumentConfig rightArgs = new ServiceArgumentConfig();
            rightArgs.setArgsName("dataRight");
            rightArgs.setType(AttributeType.Type.String.getName());
            MagicDisplay rightArgsName = new MagicDisplay("\u6743\u9650Id");
            rightArgs.addName(rightArgsName);
            argsConfig.add(rightArgs);
        }
        ServiceArgumentConfig targetDataId = new ServiceArgumentConfig();
        targetDataId.setArgsName("fromDataId");
        targetDataId.setType(AttributeType.Type.String.getName());
        MagicDisplay targetDataIdName = new MagicDisplay("\u6570\u636e\u6765\u6e90ID");
        targetDataId.addName(targetDataIdName);
        argsConfig.add(targetDataId);
        ServiceMethodConfig interfaceDefineEntity = new ServiceMethodConfig();
        interfaceDefineEntity.setMethodName(name);
        interfaceDefineEntity.setServiceType(MagicEnums.BusinessMethodType.TRIGGER_UPDATE.getName());
        interfaceDefineEntity.addName(new MagicDisplay(displayName));
        interfaceDefineEntity.setArgsConfig(argsConfig);
        ReturnConfig rc = new ReturnConfig();
        rc.setType(AttributeType.Type.ListArray.getName());
        ListAttrConfig oac = new ListAttrConfig();
        oac.setEntityType(returnObj.getObjName());
        String aLimitConfig = JSONUtil.toJSONString((Object)oac);
        rc.setLimitConfig(aLimitConfig);
        interfaceDefineEntity.setReturnConfig(rc);
        interfaceDefineEntity.addOtherAttr("fillback", fillBackNames);
        interfaceDefineEntity.addOtherAttr("condition", conditionFieldSet);
        interfaceDefineEntity.addOtherAttr("dataRight", (Object)targetFormBean.getDataRight());
        fillBackNames.addAll(allQuerySet);
        Map<String, String> limit = MagicPrivateUtils.getFieldLists(targetFormBean, fillBackNames, MagicEnums.BusinessMethodType.TRIGGER_UPDATE);
        limit.putAll(MagicPrivateUtils.getFieldLists(targetFormBean, conditionFieldSet, MagicEnums.BusinessMethodType.TRIGGER_UPDATE));
        interfaceDefineEntity.addOtherAttr("allFormulaFields", (Object)allQuerySet);
        interfaceDefineEntity.addOtherAttr("fieldLimit", limit);
        interfaceDefineEntity.addOtherAttr("tableName", targetFormBean.getFormTableMapping());
        if (targetFormBean.triggerNeedTemplate()) {
            List<Map<String, Object>> templates = targetFormBean.getTemplates();
            interfaceDefineEntity.addOtherAttr("templates", templates);
        }
        interfaceDefineEntity.setArgsConfigGuide(MagicCreateServiceUtils.createTriggerArgsConfigGuide(targetFormBean, fillBackNames, conditionFieldSet, MagicEnums.BusinessMethodType.TRIGGER_UPDATE));
        return interfaceDefineEntity;
    }

    public static ServiceMethodConfig createOutTrigger(List<Map<String, Object>> triggerFormDatas, List<Map<String, Object>> triggerResultFormDatas, List<Map<String, Object>> triggerConditionDatas, String displayName, String name, String businessId, Map<String, MetadataConfig> metadatas, String version) throws BusinessException {
        List<String> resultNames;
        String name_temp;
        Object aLimitConfig;
        ListAttrConfig oac;
        ServiceArgumentConfig formData;
        MetadataConfig formDataMetadata;
        ServiceMethodConfig interfaceDefineEntity = new ServiceMethodConfig();
        interfaceDefineEntity.setMethodName(name);
        interfaceDefineEntity.setServiceType(MagicEnums.BusinessMethodType.OUTERTRGGER.getName());
        interfaceDefineEntity.addName(new MagicDisplay(displayName));
        ArrayList<ArgsConfigGuide> argsConfigGuides = new ArrayList<ArgsConfigGuide>();
        HashMap<String, String> limit = new HashMap<String, String>();
        if (triggerFormDatas != null && !triggerFormDatas.isEmpty()) {
            formDataMetadata = MagicCreateServiceUtils.createOuterTriggerOrgsMetadata(businessId, version, triggerFormDatas, "formData");
            formData = new ServiceArgumentConfig();
            formData.addDes(new MagicDisplay("\u8868\u5355\u6570\u636e"));
            formData.setArgsName("formData");
            formData.setType(AttributeType.Type.ListArray.getName());
            oac = new ListAttrConfig();
            oac.setEntityType(formDataMetadata.getObjName());
            aLimitConfig = JSONUtils.getJSonString(oac);
            formData.setLimitConfig((String)aLimitConfig);
            metadatas.put(formDataMetadata.getObjName(), formDataMetadata);
            interfaceDefineEntity.addArgumentConfig(formData);
            argsConfigGuides.add(MagicCreateServiceUtils.putArgsGuideForOutTrigger(triggerFormDatas, businessId, version, "formData"));
            ArrayList<String> formDataNames = new ArrayList<String>(triggerFormDatas.size());
            for (Map<String, Object> map : triggerFormDatas) {
                name_temp = ParamUtil.getString(map, (String)"name", (String)"");
                if (!Strings.isNotBlank((String)name_temp)) continue;
                limit.put(name_temp, JSONUtils.getJSonString(map));
                formDataNames.add(name_temp);
            }
            interfaceDefineEntity.addOtherAttr("formData", formDataNames);
        }
        if (triggerConditionDatas != null && !triggerConditionDatas.isEmpty()) {
            formDataMetadata = MagicCreateServiceUtils.createOuterTriggerOrgsMetadata(businessId, version, triggerFormDatas, "condition");
            formData = new ServiceArgumentConfig();
            formData.addDes(new MagicDisplay("\u8868\u5355\u6570\u636e"));
            formData.setArgsName("condition");
            formData.setType(AttributeType.Type.Object.getName());
            oac = new ObjectAttrConfig();
            oac.setType(formDataMetadata.getObjName());
            oac.setCustom(true);
            oac.setName(formDataMetadata.getObjName());
            aLimitConfig = JSONUtils.getJSonString(oac);
            formData.setLimitConfig((String)aLimitConfig);
            metadatas.put(formDataMetadata.getObjName(), formDataMetadata);
            interfaceDefineEntity.addArgumentConfig(formData);
            argsConfigGuides.add(MagicCreateServiceUtils.putArgsGuideForOutTrigger(triggerConditionDatas, businessId, version, "condition"));
            ArrayList<String> conditionNames = new ArrayList<String>(triggerConditionDatas.size());
            for (Map<String, Object> map : triggerConditionDatas) {
                name_temp = ParamUtil.getString(map, (String)"name", (String)"");
                if (!Strings.isNotBlank((String)name_temp)) continue;
                limit.put(name_temp, JSONUtils.getJSonString(map));
                conditionNames.add(name_temp);
            }
            interfaceDefineEntity.addOtherAttr("condition", conditionNames);
        }
        MetadataConfig resultDataConfigMetada = new MetadataConfig();
        interfaceDefineEntity.setArgsConfigGuide(argsConfigGuides);
        if (triggerResultFormDatas != null && !triggerResultFormDatas.isEmpty()) {
            ResultConfigGuide resultConfigGuide = new ResultConfigGuide();
            resultNames = new ArrayList<String>(triggerResultFormDatas.size());
            for (Map<String, Object> r : triggerResultFormDatas) {
                String rName = ParamUtil.getString(r, (String)"name", (String)"");
                if (Strings.isBlank((String)rName)) continue;
                limit.put(rName, JSONUtils.getJSonString(r));
                resultNames.add(rName);
                EntryConfigItem entryConfigItem = new EntryConfigItem();
                entryConfigItem.setName(rName);
                entryConfigItem.setOtherConfig(r);
                resultConfigGuide.addItem(entryConfigItem);
                ObjAttributeDef oad = new ObjAttributeDef();
                String chName = ParamUtil.getString(r, (String)"displayName", (String)"");
                MagicDisplay rdisplayName = new MagicDisplay(chName);
                oad.addName(rdisplayName);
                oad.setName(rName);
                oad.setType(AttributeType.Type.Object.getName());
                resultDataConfigMetada.addAttr(oad);
            }
            interfaceDefineEntity.setResultConfigGuide(resultConfigGuide);
            interfaceDefineEntity.addOtherAttr("resultKey", resultNames);
        } else {
            resultNames = Collections.emptyList();
        }
        resultDataConfigMetada.setObjName(MagicPrivateUtils.getObjName("outTriggerResultDataObj", businessId, version, resultNames));
        metadatas.put(resultDataConfigMetada.getObjName(), resultDataConfigMetada);
        interfaceDefineEntity.addOtherAttr("fieldLimit", limit);
        ReturnConfig rc = new ReturnConfig();
        rc.addDes(new MagicDisplay("\u8fd9\u662f\u8fd4\u56de\u503c\u63cf\u8ff0"));
        rc.setType(AttributeType.Type.ListArray.getName());
        ListAttrConfig subDef = new ListAttrConfig();
        MetadataConfig reultMetadata = MagicCreateServiceUtils.createOutTriggerReturnMagicObj(businessId, version, resultDataConfigMetada.getObjName(), resultNames);
        metadatas.put(reultMetadata.getObjName(), reultMetadata);
        subDef.setEntityType(reultMetadata.getObjName());
        rc.setLimitConfig(JSONUtil.toJSONString((Object)subDef));
        interfaceDefineEntity.setReturnConfig(rc);
        return interfaceDefineEntity;
    }

    public static MetadataConfig createOutTriggerReturnMagicObj(String businessId, String versionId, String dataObjName, List<String> fieldsNames) {
        String objName = MagicPrivateUtils.getObjName("outTriggerResultObj", businessId, versionId, fieldsNames);
        MetadataConfig r = new MetadataConfig();
        r.setObjName(objName);
        ObjAttributeDef dataId = new ObjAttributeDef();
        dataId.addName(new MagicDisplay("\u6570\u636eid"));
        dataId.setName("dataId");
        dataId.setType(AttributeType.Type.Long.getName());
        r.addAttr(dataId);
        ObjAttributeDef success = new ObjAttributeDef();
        success.addName(new MagicDisplay("\u6210\u529f\u5931\u8d25\u72b6\u6001"));
        success.setName("success");
        success.setType(AttributeType.Type.Integer.getName());
        r.addAttr(success);
        ObjAttributeDef msg = new ObjAttributeDef();
        msg.addName(new MagicDisplay("\u4fe1\u606f"));
        msg.setName("msg");
        msg.setType(AttributeType.Type.String.getName());
        r.addAttr(msg);
        ObjAttributeDef data = new ObjAttributeDef();
        data.addName(new MagicDisplay("\u884c\u6570\u636e"));
        data.setName("data");
        data.setType(AttributeType.Type.Customization.getName());
        ObjectAttrConfig subDef = new ObjectAttrConfig();
        subDef.setName(dataObjName);
        subDef.setType(subDef.getName());
        subDef.setCustom(true);
        data.setLimitConfig(JSONUtil.toJSONString((Object)subDef));
        r.addAttr(data);
        return r;
    }

    private static MetadataConfig createOuterTriggerOrgsMetadata(String businessId, String version, List<Map<String, Object>> data, String type) {
        HashSet<String> names = new HashSet<String>(data.size() + 2);
        MetadataConfig result = new MetadataConfig();
        for (Map<String, Object> item : data) {
            String forDataItemName = ParamUtil.getString(item, (String)"name", (String)"");
            if (!Strings.isNotBlank((String)forDataItemName)) continue;
            names.add(forDataItemName);
            ObjAttributeDef oad = new ObjAttributeDef();
            oad.setType(AttributeType.Type.Object.getName());
            String aLimitConfig = JSONUtils.getJSonString(item);
            oad.setLimitConfig(aLimitConfig);
            String displayName = ParamUtil.getString(item, (String)"displayName", (String)"");
            if (Strings.isNotBlank((String)displayName)) {
                oad.addName(new MagicDisplay(displayName));
            }
            oad.setName(forDataItemName);
            result.addAttr(oad);
        }
        ObjAttributeDef masterDataId = new ObjAttributeDef();
        masterDataId.setType(AttributeType.Type.Object.getName());
        String displayName = "\u4e3b\u8868\u6570\u636eID";
        masterDataId.addName(new MagicDisplay(displayName));
        masterDataId.setName("sourceDataId");
        names.add(masterDataId.getName());
        result.addAttr(masterDataId);
        ObjAttributeDef subDataId = new ObjAttributeDef();
        subDataId.setType(AttributeType.Type.Object.getName());
        displayName = "\u660e\u7ec6\u8868\u6570\u636eID";
        subDataId.addName(new MagicDisplay(displayName));
        subDataId.setName("subDataId");
        names.add(subDataId.getName());
        result.addAttr(subDataId);
        String objName = MagicPrivateUtils.getArgsObjName(businessId, version, names);
        result.setObjName(objName);
        return result;
    }

    private static ArgsConfigGuide putArgsGuideForOutTrigger(List<Map<String, Object>> triggerDatas, String businessId, String version, String argsName) {
        ArgsConfigGuide formDataConfigGuide = new ArgsConfigGuide();
        formDataConfigGuide.setArgsName(argsName);
        EntryAnnotation ca = new EntryAnnotation();
        ArrayList<EntryConfigItem> argsConfigItems = new ArrayList<EntryConfigItem>();
        HashSet names2 = new HashSet();
        for (Map<String, Object> data : triggerDatas) {
            EntryConfigItem entryConfigItem = new EntryConfigItem();
            entryConfigItem.setName(ParamUtil.getString(data, (String)"name", (String)""));
            entryConfigItem.setOtherConfig(data);
            entryConfigItem.setInputType(new String[]{ParamUtil.getString(data, (String)"inputType", (String)"")});
            argsConfigItems.add(entryConfigItem);
            ca.setConfigList(argsConfigItems);
        }
        formDataConfigGuide.setGuide((ConfigAnnotation)ca);
        return formDataConfigGuide;
    }

    public static String updateFieldLimit(String oldLimit, FormBean fb) {
        if (oldLimit == null || fb == null) {
            return oldLimit;
        }
        Map limitMap = (Map)JSONUtil.parseJSONString((String)oldLimit, Map.class);
        Map fieldLimit = (Map)limitMap.get("fieldLimit");
        if (fieldLimit == null || fieldLimit.isEmpty()) {
            return oldLimit;
        }
        ArrayList<String> enumInputTypes = new ArrayList<String>();
        enumInputTypes.add(FormFieldComEnum.SELECT.getKey());
        enumInputTypes.add(FormFieldComEnum.IMAGE_SELECT.getKey());
        enumInputTypes.add(FormFieldComEnum.RADIO.getKey());
        enumInputTypes.add(FormFieldComEnum.IMAGE_RADIO.getKey());
        HashMap<String, Map> newFieldLimit = new HashMap<String, Map>();
        for (Map.Entry entry : fieldLimit.entrySet()) {
            String key = (String)entry.getKey();
            Map value = (Map)JSONUtil.parseJSONString((String)entry.getValue().toString(), Map.class);
            FormFieldBean ffb = fb.getFieldBeanByName(key);
            if (value != null && ffb != null && enumInputTypes.contains(value.get("inputType")) && enumInputTypes.contains(ffb.getInputType())) {
                value.put("value", ffb.getEnumId());
            }
            newFieldLimit.put(key, value);
        }
        limitMap.put("fieldLimit", newFieldLimit);
        return JSONUtil.toJSONString((Object)limitMap);
    }
}

