/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.importandexport;

import com.seeyon.apps.mplus.api.MplusApi;
import com.seeyon.apps.mplus.api.MplusExtApi;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.magic.business.importandexport.IMagicExportManager;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicExportFileVo;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicExportProvider;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicExportProviderBase;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.validity.ValidityUtil;
import com.seeyon.cap4.validity.util.CertificateUtils;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.IOUtility;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.datamagic.engine.domain.service.ReturnConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceArgumentConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.songjian.utils.StreamUtils;

public abstract class MagicExportBaseManager
implements IMagicExportManager {
    public static final String magicRootFolderName = "interface";
    public static final String magicExternalCodeFolderName = "code";
    public static final String magicExternalLibFolderName = "lib";
    public static final String magicExternalCorpSignFolderName = "corpSign";
    public static final String magicExternalCorpSignCerName = "cer";
    public static final String magicExternalCorpSignSignChechsumName = "sign.checksum";
    public static final String magicInterfaceZipName = "interface.zip";
    private static final String string_append_separator = "_";
    public static final String magicExportProviderInfoName = "provider.json";
    public static final String magicExportServiceConfigName = "serviceConfig.json";
    private ICAP4MagicManager cap4MagicManager;
    private IMagicProviderDao magicProviderDao;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private MplusExtApi mplusExtApi;
    private MplusApi mplusApi;
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private BusinessManager businessManager4;
    private OrgManager orgManager;
    private static final Log LOGGER = CtpLogFactory.getLog(MagicExportBaseManager.class);

    public File createExportFolder() {
        String tempFolder = SystemEnvironment.getSystemTempFolder();
        File tempMagicFolderItem = new File(tempFolder, magicRootFolderName);
        if (!tempMagicFolderItem.exists()) {
            tempMagicFolderItem.mkdirs();
        }
        return tempMagicFolderItem;
    }

    public boolean verifyZip(File unzipFolder) throws BusinessException {
        try {
            File corpPublicKeyPath = new File(unzipFolder, magicExternalCorpSignFolderName + File.separator + magicExternalCorpSignCerName);
            File signChecksum = new File(unzipFolder, magicExternalCorpSignFolderName + File.separator + magicExternalCorpSignSignChechsumName);
            X509Certificate readKey = CertificateUtils.readCertKeyFromFile(corpPublicKeyPath.getPath());
            byte[] decrptArray = StreamUtils.readBinaryData((String)signChecksum.getPath());
            File interfaceZip = new File(unzipFolder, magicInterfaceZipName);
            byte[] interfaceArray = IOUtility.toByteArray((InputStream)new FileInputStream(interfaceZip));
            return CertificateUtils.verifySign(interfaceArray, decrptArray, readKey);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public void signServiceConfig(ServiceConfig sc) {
        String identifier = this.generateConfigIdentifier(sc);
        sc.setPublicSign(identifier);
    }

    protected void saveInternalProvider(MagicExportProvider provider, File folder) throws BusinessException {
        try {
            File providerInfoFile = new File(folder, magicExportProviderInfoName);
            StreamUtils.writeStringToFile((String)providerInfoFile.getPath(), (String)JSONUtils.getJSonString(provider), (String)"UTF-8");
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public String signProviderConfig(MagicExportProvider provider) throws BusinessException {
        try {
            String key;
            MagicExportProviderBase providerInfo;
            if (MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey().equals(provider.getProviderType())) {
                providerInfo = provider.getExternalProviderInfo();
                key = providerInfo == null ? "" : DigestUtils.md5Hex((String)JSONUtils.getJSonString(providerInfo));
            } else {
                providerInfo = provider.getInternalProviderInfo();
                key = provider == null ? "" : DigestUtils.md5Hex((String)JSONUtils.getJSonString(providerInfo));
            }
            Object[] resultSign = this.getMplusExtApi().signMessage(key.getBytes("UTF-8"));
            return DigestUtils.md5Hex((byte[])((byte[])resultSign[0]));
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public boolean checkProvider(MagicExportProvider provider) throws BusinessException {
        if (provider != null) {
            String identifier = this.signProviderConfig(provider);
            return identifier.equals(provider.getSign());
        }
        return true;
    }

    X509Certificate corpPublicPath(File unzipFolder) throws BusinessException {
        try {
            File publicKey = new File(unzipFolder, magicExternalCorpSignFolderName + File.separator + magicExternalCorpSignCerName);
            return CertificateUtils.readCertKeyFromFile(publicKey.getPath());
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public boolean checkServiceConfig(ServiceConfig sc) throws BusinessException {
        String identifier = this.generateConfigIdentifier(sc);
        return identifier.equals(sc.getPublicSign());
    }

    private String generateConfigIdentifier(ServiceConfig sc) {
        if (sc == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(string_append_separator);
        result.append(sc.getBusinessId());
        result.append(sc.getVersion());
        result.append(this.generateMethodConfigIdentifier(sc.getMethodConfig()));
        return DigestUtils.md5Hex((String)result.toString());
    }

    private String generateMethodConfigIdentifier(List<ServiceMethodConfig> smcList) {
        if (smcList == null || smcList.isEmpty()) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>(smcList.size());
        for (ServiceMethodConfig smc : smcList) {
            result.add(smc.getMethodName());
            result.add(this.generateServiceArgsIdentifier(smc.getArgsConfig()));
            result.add(this.generateServiceReturnIdentifier(smc.getReturnConfig()));
        }
        return StringUtils.join(result, (String)string_append_separator);
    }

    private String generateServiceReturnIdentifier(ReturnConfig rc) {
        if (rc == null) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(rc.getType());
        result.add(rc.getEntityType());
        return StringUtils.join(result, (String)string_append_separator);
    }

    private String generateServiceArgsIdentifier(List<ServiceArgumentConfig> sacList) {
        if (sacList == null || sacList.isEmpty()) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>(sacList.size());
        for (ServiceArgumentConfig sac : sacList) {
            result.add(sac.getArgsName());
            result.add(sac.getType());
        }
        return StringUtils.join(result, (String)string_append_separator);
    }

    protected MagicExportFileVo createBusinessExportFolder(File parentFile, String businessId) {
        File tempMagicFolderItem = new File(parentFile, businessId);
        FileUtil.deleteFile((File)tempMagicFolderItem);
        tempMagicFolderItem.mkdirs();
        File interfaceFolder = new File(tempMagicFolderItem, magicRootFolderName);
        interfaceFolder.mkdirs();
        File corpSign = new File(tempMagicFolderItem, magicExternalCorpSignFolderName);
        corpSign.mkdirs();
        MagicExportFileVo result = new MagicExportFileVo();
        result.setRootFile(tempMagicFolderItem);
        result.setInterfaceFolder(interfaceFolder);
        result.setCorpSignFolder(corpSign);
        return result;
    }

    protected void saveServiceConfig(ServiceConfig sc, File parentFile) throws BusinessException {
        try {
            File serviceConfigFile = new File(parentFile, magicExportServiceConfigName);
            StreamUtils.writeStringToFile((String)serviceConfigFile.getPath(), (String)JSONUtils.getJSonString(sc), (String)"UTF-8");
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    protected void zipAndCopyToExportRoot(File exportRoot, MagicExportFileVo serviceFile, boolean clear, String businessId, boolean zipNeedPassword) throws BusinessException {
        InputStream interfaceStream = null;
        File rootFile = serviceFile.getRootFile();
        try {
            File intefaceFolder = serviceFile.getInterfaceFolder();
            File interfaceZip = new File(rootFile, magicInterfaceZipName);
            String password = "";
            if (zipNeedPassword && ValidityUtil.isValidMplusAccount()) {
                password = ValidityUtil.getPwd();
                ZipUtil.zip((File)intefaceFolder, (File)interfaceZip, (String)password, (boolean)false);
            } else {
                ZipUtil.zip((File)intefaceFolder, (File)interfaceZip, (boolean)false);
            }
            FileUtil.deleteFile((File)intefaceFolder);
            if (ValidityUtil.isValidMplusAccount()) {
                interfaceStream = new FileInputStream(interfaceZip);
                byte[] interfaceArray = IOUtility.toByteArray((InputStream)interfaceStream);
                Object[] signResult = this.getMplusExtApi().signMessage(interfaceArray);
                File corpSingFile = new File(serviceFile.getCorpSignFolder(), magicExternalCorpSignSignChechsumName);
                StreamUtils.writeByteArrayToFile((byte[])((byte[])signResult[0]), (String)corpSingFile.getPath());
                X509Certificate certificate = (X509Certificate)signResult[1];
                File corpPublicKeyPath = new File(serviceFile.getCorpSignFolder(), magicExternalCorpSignCerName);
                CertificateUtils.writeCertKeyToFile(certificate, corpPublicKeyPath.getPath());
                if (zipNeedPassword) {
                    File signPackage = this.mplusApi.signPackage(interfaceZip, password, magicRootFolderName, 3153600000L, "1.0");
                    ZipUtil.unzip((File)signPackage, (File)rootFile);
                    FileUtil.deleteFile((File)signPackage);
                }
            }
            File f = new File(rootFile.getParent(), businessId + ".zip");
            ZipUtil.zip((File)rootFile, (File)f, (boolean)false);
            File out = new File(exportRoot, File.separator + businessId + ".zip");
            IOUtility.copy((File)f, (File)out);
            if (clear) {
                f.delete();
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            if (interfaceStream != null) {
                try {
                    interfaceStream.close();
                }
                catch (Exception e) {
                    throw new BusinessException((Throwable)e);
                }
            }
            if (clear) {
                FileUtil.deleteFile((File)rootFile);
            }
        }
    }

    protected MagicExportProvider readProviderByImportFile(File unzipRoot) throws BusinessException {
        try {
            String setStr;
            File providerFile = new File(unzipRoot, magicRootFolderName + File.separator + magicExportProviderInfoName);
            if (providerFile.exists() && Strings.isNotBlank((String)(setStr = FileUtils.readFileToString((File)providerFile, (String)"UTF-8")))) {
                return JSONUtils.parseJSonStr_Class(setStr, MagicExportProvider.class);
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return null;
    }

    public ICAP4MagicManager getCap4MagicManager() {
        return this.cap4MagicManager;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public MplusExtApi getMplusExtApi() {
        return this.mplusExtApi;
    }

    public void setMplusExtApi(MplusExtApi mplusExtApi) {
        this.mplusExtApi = mplusExtApi;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public MplusApi getMplusApi() {
        return this.mplusApi;
    }

    public void setMplusApi(MplusApi mplusApi) {
        this.mplusApi = mplusApi;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }
}

