/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.importandexport;

import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.util.CapUtil;
import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.business.importandexport.IMagicExternalExportManager;
import com.seeyon.cap4.magic.business.importandexport.MagicExportBaseManager;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicExportFileVo;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicExportProvider;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicExternalProviderInfo;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicInternalProviderInfo;
import com.seeyon.cap4.magic.execute.MagicProviderExecuteManager;
import com.seeyon.cap4.magic.manager.MagicProviderInfo;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.utils.PrivateFileUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicImportResult;
import com.seeyon.cap4.validity.ValidityUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.report.bizportal.api.ReportFacadeManagerApi;
import com.seeyon.ctp.report.engine.api.bo.ReportConfig;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.report.engine.po.ReportDesign;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDGenerator;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.service.ServiceConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.songjian.utils.StreamUtils;
import org.springframework.util.ClassUtils;

public class MagicExternalExportManagerImpl
extends MagicExportBaseManager
implements IMagicExternalExportManager {
    private static final Log LOGGER = CtpLogFactory.getLog(MagicExternalExportManagerImpl.class);
    private MagicProviderExecuteManager magicExternalExceuteManager;
    private ReportFacadeManagerApi reportFacadeManagerApi;
    private ReportApi reportApi;

    @Override
    public void exportMagic(BusinessDataBean businessDataBean, List<ServiceConfig> serviceConfigs, Map<String, Object> extParams) throws BusinessException {
        String zipFolder = businessDataBean.getZipFolder();
        File exportMagicFolder = new File(zipFolder, "interface");
        File tempMagicFolderItem = this.createExportFolder();
        for (ServiceConfig sc : serviceConfigs) {
            super.signServiceConfig(sc);
            this.exportServiceConfig(exportMagicFolder, sc, tempMagicFolderItem, extParams);
        }
    }

    private void exportServiceConfig(File exportMagicFolder, ServiceConfig serviceConfig, File tempFolder, Map<String, Object> extParams) throws BusinessException {
        try {
            MagicExportFileVo thisServiceFolder = this.createBusinessExportFolder(tempFolder, serviceConfig.getBusinessId());
            serviceConfig.setImplsConfigs(Collections.emptyList());
            if (MagicEnums.ServiceOwnerType.DEFAULT_REPORT.getType().equals(serviceConfig.getOwnerType())) {
                List<MagicServiceProviderPO> providers = this.getMagicProviderDao().loadProviders(serviceConfig.getBusinessId(), serviceConfig.getVersion());
                MagicExportProvider exportReportProvider = this.exportReportProviders(serviceConfig.getBusinessId(), serviceConfig.getVersion(), providers);
                this.saveInternalProvider(exportReportProvider, thisServiceFolder.getInterfaceFolder());
            } else {
                this.saveExternalProvider(serviceConfig.getBusinessId(), thisServiceFolder.getRootFile());
            }
            this.saveServiceConfig(serviceConfig, thisServiceFolder.getInterfaceFolder());
            this.writeExtension(thisServiceFolder.getRootFile());
            String zipNeedPassword = ParamUtil.getString(extParams, (String)"zipNeedPassword", (String)"0");
            this.zipAndCopyToExportRoot(exportMagicFolder, thisServiceFolder, true, serviceConfig.getBusinessId(), zipNeedPassword.equals("1"));
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private void writeExtension(File exportMagicFolder) throws BusinessException {
        Map extensionMap = CapUtil.generateExtensionInfoMap();
        V3xOrgAccount orgAccount = super.getOrgManager().getAccountById(AppContext.getCurrentUser().getLoginAccount());
        extensionMap.put("creatorAccount", orgAccount.getName());
        extensionMap.put("createOrgName", ValidityUtil.getMplusCorpName());
        extensionMap.put("createOrgId", ValidityUtil.getMplusCorpId());
        CapUtil.writeFile((String)exportMagicFolder.getPath(), (String)"extension.json", (String)JSONUtil.toJSONString((Object)extensionMap));
    }

    private MagicExportProvider exportReportProviders(String businessId, String version, List<MagicServiceProviderPO> providerPOS) {
        MagicExportProvider result = new MagicExportProvider();
        result.setBusinessId(businessId);
        result.setVersion(version);
        result.setProviderType(MagicEnums.BusinessType.EXTERNAL_BUSINESS.getKey());
        MagicInternalProviderInfo internalProviderInfo = new MagicInternalProviderInfo();
        for (MagicServiceProviderPO p : providerPOS) {
            Map export = p.getExportJSONFormPublish();
            internalProviderInfo.addProvider(export);
        }
        result.setInternalProviderInfo(internalProviderInfo);
        return result;
    }

    private boolean checkExternalFiles(MagicExportProvider provider, File unzipFolder) throws BusinessException {
        boolean check = this.checkProvider(provider);
        if (check) {
            // empty if block
        }
        return check;
    }

    private void saveExternalProvider(String businessId, File thisServiceFolder) throws BusinessException {
        try {
            File publicFolders = SystemEnvironment.getClusterPublicFolder((String)"interface");
            File businessFolder = new File(publicFolders, businessId + ".zip");
            if (!businessFolder.exists()) {
                return;
            }
            ZipUtil.unzip((File)businessFolder, (File)thisServiceFolder);
            File interfaceZip = new File(thisServiceFolder, "interface.zip");
            File interfaceUnzip = new File(thisServiceFolder, "interface");
            File manifest = new File(thisServiceFolder, "META-INF" + File.separator + "MANIFEST.MF");
            if (manifest.exists() && manifest.isFile()) {
                Map verifyResult = this.getMplusApi().verifyPackage(businessFolder);
                String password = (String)verifyResult.get("pwd");
                ZipUtil.unzip((File)interfaceZip, (File)interfaceUnzip, (String)password);
            } else {
                ZipUtil.unzip((File)interfaceZip, (File)interfaceUnzip);
            }
            FileUtil.deleteFile((File)interfaceZip);
            MagicExportProvider provider = this.readProviderByImportFile(thisServiceFolder);
            this.setProviderInfo(provider, interfaceUnzip);
            File providerInfoFile = new File(interfaceUnzip, "provider.json");
            StreamUtils.writeStringToFile((String)providerInfoFile.getPath(), (String)JSONUtils.getJSonString(provider), (String)"UTF-8");
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public MagicExportProvider setProviderInfo(MagicExportProvider provider, File thisServiceFolder) throws BusinessException {
        MagicExternalProviderInfo providerInfo;
        if (provider == null) {
            provider = new MagicExportProvider();
        }
        if ((providerInfo = provider.getExternalProviderInfo()) == null) {
            providerInfo = new MagicExternalProviderInfo();
        }
        InputStream classStream = null;
        LinkedList<Map<String, String>> classHashCode = new LinkedList<Map<String, String>>();
        File code = new File(thisServiceFolder, "code");
        LinkedList<File> allFiles = new LinkedList<File>();
        this.listAllFile(code, allFiles);
        ArrayList<String> classList = new ArrayList<String>(allFiles.size());
        for (File f : allFiles) {
            try {
                String fName = f.getPath();
                fName = fName.replace(code.getPath() + File.separator, "").replaceAll("\\\\", ".");
                if (fName.contains(File.separator)) {
                    fName = ClassUtils.convertResourcePathToClassName((String)fName);
                }
                classList.add(fName);
                HashMap<String, String> hashCode = new HashMap<String, String>();
                classStream = new FileInputStream(f);
                hashCode.put(fName, DigestUtils.md5Hex((InputStream)classStream));
                classHashCode.add(hashCode);
            }
            catch (Exception e) {
                throw new BusinessException((Throwable)e);
            }
            finally {
                if (classStream == null) continue;
                try {
                    classStream.close();
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        providerInfo.setClassHashCode(classHashCode);
        providerInfo.setClassList(classList);
        return provider;
    }

    public void listAllFile(File parent, List<File> files) {
        File[] childFiles;
        if (parent.exists() && (childFiles = parent.listFiles()) != null) {
            for (File f : parent.listFiles()) {
                if (f.isFile()) {
                    files.add(f);
                    continue;
                }
                this.listAllFile(f, files);
            }
        }
    }

    @Override
    public void importMagic(File zipFolder, File unzipFolder, ServiceConfig sc, BusinessDataBean businessDataBean, MagicImportResult importResult) throws BusinessException {
        boolean checkResult = super.checkServiceConfig(sc);
        MagicExportProvider provider = this.readProviderByImportFile(unzipFolder);
        String bid = sc.getBusinessId();
        String vId = sc.getVersion();
        this.getCap4MagicManager().importServiceSummary(bid, vId, sc, importResult, businessDataBean);
        MagicServiceSummary serviceSummary = importResult.getServiceSummary(sc.getBusinessId(), sc.getVersion());
        for (ServiceMethodConfig mc : sc.getMethodConfig()) {
            MagicInterfaceDefineEntity checkExist = this.getMagicInterfaceDefineDao().loadDefineById(bid, vId, mc.getMethodName());
            if (checkExist != null) {
                importResult.addProviderExists(checkExist);
                boolean isUpdate = false;
                if (MagicEnums.ServiceOwnerType.DEFAULT_EXTERNAL.getType().equals(serviceSummary.getOwnerType())) {
                    isUpdate = true;
                } else if (MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType().equals(serviceSummary.getOwnerType()) && businessDataBean.getBizConfigBean().getId().toString().equals(serviceSummary.getOwner())) {
                    isUpdate = true;
                }
                if (!isUpdate) continue;
                MagicInterfaceDefineEntity update = MagicCreateServiceUtils.convertMethodToPo(sc.getOwnerType(), sc.getOwner(), bid, vId, mc);
                update.setId(checkExist.getId());
                this.getMagicInterfaceDefineDao().saveEntityInCache(update);
                importResult.addProviderUpdate(update);
                continue;
            }
            checkExist = MagicCreateServiceUtils.convertMethodToPo(sc.getOwnerType(), sc.getOwner(), bid, vId, mc);
            if (MagicEnums.CertificateType.Private_certificate.getName().equals(sc.getCertificateType())) {
                checkExist.setCategory(MagicEnums.CertificateType.Private_certificate.getKey());
            } else if (MagicEnums.CertificateType.Public_certificate.getName().equals(sc.getCertificateType())) {
                checkExist.setCategory(MagicEnums.CertificateType.Public_certificate.getKey());
            }
            importResult.addProviderNew(checkExist);
            this.getMagicInterfaceDefineDao().saveEntityInCache(checkExist);
        }
        File publicFolders = SystemEnvironment.getClusterPublicFolder((String)"interface");
        File businessFolder = new File(publicFolders, sc.getBusinessId() + ".zip");
        FileUtil.copyFile((File)zipFolder, (File)businessFolder);
        if (MagicEnums.ServiceOwnerType.DEFAULT_REPORT.getType().equals(sc.getOwnerType())) {
            this.importReportServices(provider, sc, businessDataBean, importResult);
        } else if (provider != null && provider.getExternalProviderInfo() != null) {
            File executePath;
            File interfaceCode = new File(unzipFolder, "interface" + File.separator + "code");
            File compilerPath = new File(SystemEnvironment.getClassCacheFolder(), "magic/compiler" + File.separator + serviceSummary.getId());
            if (!compilerPath.exists()) {
                compilerPath.mkdirs();
            }
            if (!(executePath = new File(SystemEnvironment.getClassCacheFolder(), "magic/execute" + File.separator + serviceSummary.getId())).exists()) {
                executePath.mkdirs();
            }
            PrivateFileUtils.copyCode(interfaceCode, compilerPath, executePath);
            this.initExternal(sc, executePath, provider.getExternalProviderInfo().getInitClass(), importResult);
        }
    }

    private void importReportServices(MagicExportProvider provider, ServiceConfig sc, BusinessDataBean businessDataBean, MagicImportResult importResult) throws BusinessException {
        if (MagicPrivateUtils.isNumeric(sc.getOwner()) && provider != null && provider.getInternalProviderInfo() != null) {
            ReportConfig reportDesignBean;
            Long newReportId = businessDataBean.getNewIdByOldId(Long.valueOf(Long.parseLong(sc.getOwner())));
            if (newReportId == null) {
                return;
            }
            MagicServiceSummary serviceSummary = importResult.getServiceSummary(sc.getBusinessId(), sc.getVersion());
            if (serviceSummary == null) {
                return;
            }
            try {
                reportDesignBean = this.reportApi.getReport(Long.valueOf(sc.getOwner()));
            }
            catch (BusinessException e) {
                reportDesignBean = null;
                LOGGER.warn((Object)(sc.getOwner() + "\u4e0d\u5b58\u5728"));
            }
            boolean needUpdateProvider = false;
            if (reportDesignBean == null) {
                if (businessDataBean.isUpgrade()) {
                    Object disignObj = businessDataBean.getAppUpgradeCacheBean().getExtraAttr(String.valueOf(newReportId));
                    if (disignObj != null && disignObj instanceof ReportDesign) {
                        needUpdateProvider = true;
                        LOGGER.info((Object)("report set owner from " + sc.getOwner() + " to " + newReportId));
                        serviceSummary.setOwner(String.valueOf(newReportId));
                    }
                } else {
                    needUpdateProvider = true;
                    LOGGER.info((Object)("report set owner from " + sc.getOwner() + " to " + newReportId));
                    serviceSummary.setOwner(String.valueOf(newReportId));
                }
            }
            if (!needUpdateProvider) {
                return;
            }
            MagicInternalProviderInfo providerInfo = provider.getInternalProviderInfo();
            List<MagicServiceProviderPO> allProviders = this.getMagicProviderDao().loadProviders(sc.getBusinessId(), sc.getVersion());
            if (allProviders != null && !allProviders.isEmpty()) {
                return;
            }
            if (providerInfo.getProviders() == null || providerInfo.getProviders().isEmpty()) {
                return;
            }
            Map<String, Object> firstProvider = providerInfo.getProviders().get(0);
            List methodMapping = (List)firstProvider.get("methodMapping");
            if (methodMapping != null && !methodMapping.isEmpty()) {
                Map resultMapping;
                String[] oldTableNameArray;
                String oldTableName;
                String newTableName;
                String value;
                Map methodMappingTemp = (Map)methodMapping.get(0);
                String methodName = ParamUtil.getString((Map)methodMappingTemp, (String)"methodName", (String)"");
                if (Strings.isBlank((String)methodName)) {
                    return;
                }
                Map argsMapping = (Map)methodMappingTemp.get("argsMapping");
                if (argsMapping != null) {
                    Map condition = (Map)argsMapping.get("condition");
                    for (String key : condition.keySet()) {
                        value = ParamUtil.getString((Map)condition, (String)key, (String)"");
                        if (!Strings.isNotBlank((String)value) || !Strings.isNotBlank((String)(newTableName = businessDataBean.getOldAndNewStringMap(oldTableName = (oldTableNameArray = value.split("_"))[0] + "_" + oldTableNameArray[1])))) continue;
                        value = value.replace(oldTableName, newTableName);
                        condition.put(key, value);
                    }
                }
                if ((resultMapping = (Map)methodMappingTemp.get("resultMapping")) != null) {
                    for (String key : resultMapping.keySet()) {
                        value = ParamUtil.getString((Map)resultMapping, (String)key, (String)"");
                        if (!Strings.isNotBlank((String)value) || !Strings.isNotBlank((String)(newTableName = businessDataBean.getOldAndNewStringMap(oldTableName = (oldTableNameArray = value.split("_"))[0] + "_" + oldTableNameArray[1])))) continue;
                        value = value.replace(oldTableName, newTableName);
                        resultMapping.put(key, value);
                    }
                }
                ArrayList<Map> extMapper = new ArrayList<Map>(1);
                extMapper.add(methodMappingTemp);
                MagicServiceProviderPO p = new MagicServiceProviderPO();
                p.setIdIfNew();
                p.setBusinessId(sc.getBusinessId());
                p.setVersionId(sc.getVersion());
                p.setSourceType(serviceSummary.getOwnerType());
                p.setStatus(MagicEnums.ProviderStatus.ON.getType());
                p.setSource(String.valueOf(newReportId));
                p.setExt1(JSONUtils.getJSonString(extMapper));
                importResult.addNewProvierCache(p);
            }
        }
    }

    private void initExternal(ServiceConfig sc, File executePath, String initClassName, MagicImportResult importResult) throws BusinessException {
        try {
            List<MagicProviderInfo> providerInfos;
            List<MagicServiceProviderPO> exists = this.getMagicProviderDao().loadProviders(sc.getBusinessId(), sc.getVersion());
            if (exists != null) {
                for (MagicServiceProviderPO p : exists) {
                    importResult.addExistsProvierCache(p);
                }
            }
            if ((providerInfos = PrivateFileUtils.invokeInitForExternal(executePath, initClassName)) != null) {
                for (MagicProviderInfo m : providerInfos) {
                    MagicServiceProviderPO p = this.convertProvider(m, sc.getBusinessId(), sc.getVersion());
                    importResult.addNewProvierCache(p);
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private MagicServiceProviderPO convertProvider(MagicProviderInfo m, String bid, String version) {
        MagicServiceProviderPO p = new MagicServiceProviderPO();
        p.setSource(m.getSource());
        p.setSourceType(m.getSourceType());
        p.setDisplayName(m.getName());
        p.setCreateDate(DateUtil.currentDate());
        p.setVersionId(version);
        p.setSourceType(MagicEnums.ArticulatedType.EXTEND_CLASS.getType());
        p.setBusinessId(bid);
        p.setIdIfNew();
        p.setExt4(m.getProviderId());
        p.setCreateDate(DateUtil.currentDate());
        p.setCreater(Long.valueOf(AppContext.currentUserId()));
        String status = m.getStatus();
        if (MagicEnums.ProviderStatus.ON.getName().equals(status)) {
            p.setStatus(MagicEnums.ProviderStatus.ON.getType());
        } else {
            p.setStatus(MagicEnums.ProviderStatus.OFF.getType());
        }
        return p;
    }

    private void copyCode(File unzipFolder, Long serviceId) {
        File executePath;
        File interfaceCode = new File(unzipFolder, "interface" + File.separator + "code");
        File compilerPath = new File(SystemEnvironment.getClassCacheFolder(), "magic/compiler" + File.separator + serviceId);
        if (!compilerPath.exists()) {
            compilerPath.mkdirs();
        }
        if (!(executePath = new File(SystemEnvironment.getClassCacheFolder(), "magic/execute" + File.separator + serviceId)).exists()) {
            executePath.mkdirs();
        }
        PrivateFileUtils.copyCode(interfaceCode, compilerPath, executePath);
    }

    private void invokeInit(File tempFolder, MagicServiceSummary serviceSummary) throws BusinessException {
        try {
            String providerSetStr;
            File providerFile = new File(tempFolder, "interface" + File.separator + "provider.json");
            MagicExportProvider provider = null;
            if (providerFile.exists() && Strings.isNotBlank((String)(providerSetStr = FileUtils.readFileToString((File)providerFile, (String)"UTF-8")))) {
                provider = JSONUtils.parseJSonStr_Class(providerSetStr, MagicExportProvider.class);
            }
            if (provider != null && provider.getExternalProviderInfo() != null) {
                File executePath;
                File interfaceCode = new File(tempFolder, "interface" + File.separator + "code");
                File compilerPath = new File(SystemEnvironment.getClassCacheFolder(), "magic/compiler" + File.separator + serviceSummary.getId());
                if (!compilerPath.exists()) {
                    compilerPath.mkdirs();
                }
                if (!(executePath = new File(SystemEnvironment.getClassCacheFolder(), "magic/execute" + File.separator + serviceSummary.getId())).exists()) {
                    executePath.mkdirs();
                }
                PrivateFileUtils.copyCode(interfaceCode, compilerPath, executePath);
                List<MagicProviderInfo> providerInfos = PrivateFileUtils.invokeInitForExternal(executePath, provider.getExternalProviderInfo().getInitClass());
                this.getMagicProviderDao().deleteProvides(serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion());
                if (providerInfos != null) {
                    ArrayList<MagicServiceProviderPO> pList = new ArrayList<MagicServiceProviderPO>(providerInfos.size());
                    for (MagicProviderInfo m : providerInfos) {
                        MagicServiceProviderPO p = this.convertProvider(m, serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion());
                        pList.add(p);
                    }
                    this.getMagicProviderDao().saveProviders(pList);
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private Map<String, Object> readExtension(File tempFolder) throws BusinessException {
        try {
            File extensionFile = new File(tempFolder, "extension.json");
            if (extensionFile == null || !extensionFile.exists() || extensionFile.isDirectory()) {
                return new HashMap<String, Object>();
            }
            String setStr = FileUtils.readFileToString((File)extensionFile, (String)"UTF-8");
            if (Strings.isNotBlank((String)setStr)) {
                return JSONUtils.parseJSonStr_Class(setStr, Map.class);
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return new HashMap<String, Object>();
    }

    @Override
    public boolean reinstall(File zipFile, Map<String, Object> params, boolean invokeInit) throws BusinessException {
        File tempFolder = new File(SystemEnvironment.getSystemTempFolder(), UUIDGenerator.getUUID());
        LOGGER.info((Object)("debugger file path[" + zipFile.getPath() + "]"));
        try {
            if (zipFile.exists()) {
                Map<Object, Object> extendOwner;
                String goodId = ParamUtil.getString(params, (String)"goodId", (String)"");
                String bizConfigId = ParamUtil.getString(params, (String)"bizConfig", (String)"");
                if (tempFolder.exists()) {
                    tempFolder.delete();
                }
                ZipUtil.unzip((File)zipFile, (File)tempFolder);
                File unzipInterfaceFolder = new File(tempFolder, "interface");
                File zipInterfaceFile = new File(tempFolder, "interface.zip");
                File manifest = new File(tempFolder, "META-INF" + File.separator + "MANIFEST.MF");
                if (manifest.exists() && manifest.isFile()) {
                    Map verifyResult = this.getMplusApi().verifyPackage(zipFile);
                    String password = (String)verifyResult.get("pwd");
                    ZipUtil.unzip((File)zipInterfaceFile, (File)unzipInterfaceFolder, (String)password);
                } else {
                    ZipUtil.unzip((File)zipInterfaceFile, (File)unzipInterfaceFolder);
                }
                String setStr = FileUtils.readFileToString((File)new File(unzipInterfaceFolder, "serviceConfig.json"), (String)"UTF-8");
                ServiceConfig sc = JSONUtils.parseJSonStr_Class(setStr, ServiceConfig.class);
                MagicServiceSummary existsServices = super.getMagicServiceSummaryDao().loadServiceInfo(sc.getBusinessId(), sc.getVersion());
                MagicServiceSummary serviceSummary = MagicCreateServiceUtils.convertServiceToPo(sc);
                if (existsServices != null && invokeInit && MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType().equals(existsServices.getOwnerType()) && !bizConfigId.equals(existsServices.getOwner())) {
                    throw new BusinessException("\u63a5\u53e3 [" + existsServices.getNameDisplay() + "]\u5df2\u7ecf\u88ab\u5176\u4ed6\u5e94\u7528\u5b89\u88c5!\u65e0\u6cd5\u518d\u6b21\u5b89\u88c5!");
                }
                if (existsServices != null) {
                    serviceSummary.setId(existsServices.getId());
                    serviceSummary.setAuthorizationType(existsServices.getAuthorizationType());
                    serviceSummary.setAuthorizationInfo(existsServices.getAuthorizationInfo());
                    extendOwner = this.readExtension(tempFolder);
                    if (Strings.isNotBlank((String)goodId)) {
                        extendOwner.put("goodId", goodId);
                    }
                    if (!extendOwner.isEmpty()) {
                        serviceSummary.setExtendOwner(JSONUtils.getJSonString(extendOwner));
                    }
                    this.getMagicServiceSummaryDao().update(serviceSummary);
                } else {
                    BizConfigBean bizConfigBean;
                    if (MagicPrivateUtils.isNumeric(bizConfigId) && (bizConfigBean = this.getBusinessManager4().findBizConfigById(Long.parseLong(bizConfigId))) != null) {
                        serviceSummary.setOwner(bizConfigId);
                        serviceSummary.setOwnerType(MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType());
                    }
                    extendOwner = new HashMap<String, String>();
                    if (Strings.isNotBlank((String)serviceSummary.getExtendOwner())) {
                        extendOwner.putAll(JSONUtils.parseJSonStr_Class(serviceSummary.getExtendOwner(), Map.class));
                    }
                    if (Strings.isNotBlank((String)goodId)) {
                        extendOwner.put("goodId", goodId);
                    }
                    if (!extendOwner.isEmpty()) {
                        serviceSummary.setExtendOwner(JSONUtils.getJSonString(extendOwner));
                    }
                    this.getMagicServiceSummaryDao().save(serviceSummary);
                }
                ArrayList<MagicInterfaceDefineEntity> saveList = new ArrayList<MagicInterfaceDefineEntity>();
                ArrayList<MagicInterfaceDefineEntity> updateList = new ArrayList<MagicInterfaceDefineEntity>();
                for (ServiceMethodConfig mc : sc.getMethodConfig()) {
                    MagicInterfaceDefineEntity checkExist = this.getMagicInterfaceDefineDao().loadDefineById(sc.getBusinessId(), sc.getVersion(), mc.getMethodName());
                    MagicInterfaceDefineEntity newMethod = MagicCreateServiceUtils.convertMethodToPo(sc.getOwnerType(), sc.getOwner(), sc.getBusinessId(), sc.getVersion(), mc);
                    if (MagicEnums.CertificateType.Private_certificate.getName().equals(sc.getCertificateType())) {
                        newMethod.setCategory(MagicEnums.CertificateType.Private_certificate.getKey());
                    } else if (MagicEnums.CertificateType.Public_certificate.getName().equals(sc.getCertificateType())) {
                        newMethod.setCategory(MagicEnums.CertificateType.Public_certificate.getKey());
                    }
                    if (checkExist != null) {
                        newMethod.setId(checkExist.getId());
                        updateList.add(newMethod);
                        continue;
                    }
                    saveList.add(newMethod);
                }
                this.getMagicInterfaceDefineDao().saveDefine(saveList);
                this.getMagicInterfaceDefineDao().updateList(updateList);
                this.copyCode(tempFolder, serviceSummary.getId());
                if (invokeInit) {
                    this.invokeInit(tempFolder, serviceSummary);
                    File publicFolders = SystemEnvironment.getClusterPublicFolder((String)"interface");
                    File businessFolder = new File(publicFolders, sc.getBusinessId() + ".zip");
                    FileUtil.copyFile((File)zipFile, (File)businessFolder);
                }
                this.magicExternalExceuteManager.removeCacheExecute(serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion());
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            FileUtil.deleteFile((File)tempFolder);
        }
        return true;
    }

    @Override
    public boolean installExternalService(File zipFile, Map<String, Object> params, boolean invokeInit) throws BusinessException {
        String tempFolderName = UUIDGenerator.getUUID();
        File tempFolder = new File(SystemEnvironment.getSystemTempFolder(), tempFolderName);
        Map verifyResult = Collections.emptyMap();
        try {
            verifyResult = super.getMplusApi().verifyPackage(zipFile);
        }
        catch (BusinessException e) {
            LOGGER.info((Object)(zipFile.getName() + "\u6821\u9a8c\u5931\u8d25,\u6309\u7167\u514d\u8d39\u5305\u5b89\u88c5\u4e00\u6b21"));
        }
        try {
            File[] allZip;
            String password = (String)verifyResult.get("pwd");
            ZipUtil.unzip((File)zipFile, (File)tempFolder);
            for (File tempFile : tempFolder.listFiles()) {
                if (!tempFile.isFile() || !tempFile.getName().endsWith(".zip")) continue;
                if (verifyResult != null && verifyResult.containsKey("pwd")) {
                    ZipUtil.unzip((File)tempFile, (File)tempFolder, (String)password);
                    break;
                }
                ZipUtil.unzip((File)tempFile, (File)tempFolder);
                break;
            }
            File interfaceFolder = new File(tempFolder, "interface");
            for (File f : allZip = interfaceFolder.listFiles()) {
                this.reinstall(f, params, invokeInit);
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            FileUtil.deleteFile((File)tempFolder);
        }
        return true;
    }

    @Override
    public boolean installServiceImpl(File zipFile, MagicServiceSummary serviceSummary, Map<String, Object> params) throws BusinessException {
        File tempFolder = new File(SystemEnvironment.getSystemTempFolder(), zipFile.getName());
        try {
            ZipUtil.unzip((File)zipFile, (File)tempFolder);
            File unzipInterfaceFolder = new File(tempFolder, "interface");
            File zipInterfaceFile = new File(tempFolder, "interface.zip");
            ZipUtil.unzip((File)zipInterfaceFile, (File)unzipInterfaceFolder);
            String setStr = FileUtils.readFileToString((File)new File(unzipInterfaceFolder, "serviceConfig.json"), (String)"UTF-8");
            ServiceConfig sc = JSONUtils.parseJSonStr_Class(setStr, ServiceConfig.class);
            if (!sc.getBusinessId().equals(serviceSummary.getBusinessId())) {
                throw new BusinessException("\u4e1a\u52a1ID\u4e0d\u4e00\u81f4 \u65e0\u6cd5\u5b89\u88c5!");
            }
            this.copyCode(tempFolder, serviceSummary.getId());
            this.invokeInit(tempFolder, serviceSummary);
            File publicFolders = SystemEnvironment.getClusterPublicFolder((String)"interface");
            File businessFolder = new File(publicFolders, sc.getBusinessId() + ".zip");
            FileUtil.copyFile((File)zipFile, (File)businessFolder);
            FileUtil.deleteFile((File)tempFolder);
            this.magicExternalExceuteManager.removeCacheExecute(serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion());
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        return true;
    }

    public MagicProviderExecuteManager getMagicExternalExceuteManager() {
        return this.magicExternalExceuteManager;
    }

    public void setMagicExternalExceuteManager(MagicProviderExecuteManager magicExternalExceuteManager) {
        this.magicExternalExceuteManager = magicExternalExceuteManager;
    }

    public ReportFacadeManagerApi getReportFacadeManagerApi() {
        return this.reportFacadeManagerApi;
    }

    public void setReportFacadeManagerApi(ReportFacadeManagerApi reportFacadeManagerApi) {
        this.reportFacadeManagerApi = reportFacadeManagerApi;
    }

    public ReportApi getReportApi() {
        return this.reportApi;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }
}

