/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.importandexport;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.business.importandexport.MagicExportBaseManager;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicExportFileVo;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicExportProvider;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicInternalProviderInfo;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.cap4.magic.vo.MagicImportResult;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.form.modules.engin.formula.FormulaDAO;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.datamagic.engine.domain.service.ServiceConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import com.seeyon.datamagic.engine.utils.GenerateUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MagicInternalExportManagerImpl
extends MagicExportBaseManager {
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormulaDAO formulaDAO;

    @Override
    public void importMagic(File zipFolder, File unzipFolder, ServiceConfig sc, BusinessDataBean businessDataBean, MagicImportResult importResult) throws BusinessException {
        MagicExportProvider provider = this.readProviderByImportFile(unzipFolder);
        this.importProviderServices(zipFolder, sc, provider, businessDataBean, importResult);
    }

    private MagicServiceProviderPO initProviderForImport(String bid, String vId, String ownerType, Map<String, Object> importInfo, Map<String, Map> redirectMap, BusinessDataBean businessDataBean, MagicImportResult importResult) throws BusinessException {
        Long newFormId;
        String uniqueToken = ParamUtil.getString(importInfo, (String)"uniqueToken", (String)"");
        String sourceType = ParamUtil.getString(importInfo, (String)"sourceType", (String)"");
        String source = ParamUtil.getString(importInfo, (String)"source", (String)"");
        String comment = ParamUtil.getString(importInfo, (String)"comment", (String)"");
        String status = ParamUtil.getString(importInfo, (String)"status", (String)"");
        String displayName = ParamUtil.getString(importInfo, (String)"displayName", (String)"");
        MagicServiceProviderPO existPo = new MagicServiceProviderPO();
        existPo.setIdIfNew();
        existPo.setBusinessId(bid);
        existPo.setSourceType(sourceType);
        existPo.setSource(source);
        if (MagicPrivateUtils.isNumeric(source) && (newFormId = businessDataBean.getNewIdByOldId(Long.valueOf(Long.parseLong(source)))) != null) {
            existPo.setSource(String.valueOf(newFormId));
        }
        existPo.setExt1(JSONUtils.getJSonString(redirectMap.values()));
        existPo.setVersionId(vId);
        existPo.setComment(comment);
        existPo.setDisplayName(displayName);
        existPo.setExt4(uniqueToken);
        MagicEnums.ProviderStatus pt = MagicEnums.ProviderStatus.valueOf((String)status);
        if (pt != null) {
            existPo.setStatus(pt.getType());
        } else {
            existPo.setStatus(MagicEnums.ProviderStatus.OFF.getType());
        }
        if (importInfo.containsKey("scopeSet") && MagicPrivateUtils.isNumeric(existPo.getSource()) && MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(ownerType)) {
            Map scopeSet = (Map)importInfo.get("scopeSet");
            FormBean formBean = this.cap4FormCacheManager.getForm(Long.parseLong(existPo.getSource()));
            if (formBean != null) {
                Map formulaImportResult = FormDesignUtil.getFormulaFromMap4Import((BusinessDataBean)businessDataBean, (Map)scopeSet, (FormBean)formBean, (int)2, (boolean)false);
                FormFormulaBean formulaBean = (FormFormulaBean)formulaImportResult.get("bo");
                scopeSet.clear();
                importResult.addNewFormulaBean(formulaBean, formBean.getId(), existPo.getId());
                scopeSet.put("id", String.valueOf(formulaBean.getFormulaId()));
                scopeSet.put("formulaStr", formulaBean.getFormulaForDisplay());
                HashMap<String, Map> ext2 = new HashMap<String, Map>();
                ext2.put("scopeSet", scopeSet);
                existPo.setExt2(JSONUtils.getJSonString(ext2));
            }
        }
        return existPo;
    }

    private MagicInterfaceDefineEntity initMethodForImport(ServiceConfig sc, String bid, String vId, ServiceMethodConfig mc, BusinessDataBean businessDataBean) {
        MagicInterfaceDefineEntity checkExist = MagicCreateServiceUtils.convertMethodToPo(sc.getOwnerType(), sc.getOwner(), bid, vId, mc);
        MagicEnums.ServiceOwnerType sot = MagicEnums.ServiceOwnerType.getEnumByType((String)sc.getOwnerType());
        if (sot != null) {
            switch (sot) {
                case DEFAULT_FORM: 
                case DEFAULT_CAP4_BIZ: {
                    Long newId = businessDataBean.genNewIdByOldId(Long.valueOf(Long.parseLong(sc.getOwner())));
                    if (newId != null) {
                        checkExist.setFormId(newId.longValue());
                    } else {
                        newId = 0L;
                    }
                    if (!Strings.isNotBlank((String)checkExist.getExt1())) break;
                    FormBean fb = this.cap4FormCacheManager.getForm(newId);
                    checkExist.setExt1(MagicCreateServiceUtils.updateFieldLimit(checkExist.getExt1(), fb));
                }
            }
        }
        if (MagicEnums.CertificateType.Private_certificate.getName().equals(sc.getCertificateType())) {
            checkExist.setCategory(MagicEnums.CertificateType.Private_certificate.getKey());
        } else if (MagicEnums.CertificateType.Public_certificate.getName().equals(sc.getCertificateType())) {
            checkExist.setCategory(MagicEnums.CertificateType.Public_certificate.getKey());
        }
        return checkExist;
    }

    private void importProviderServices(File zipFolder, ServiceConfig sc, MagicExportProvider provider, BusinessDataBean businessDataBean, MagicImportResult importResult) throws BusinessException {
        String bid = sc.getBusinessId();
        String vId = sc.getVersion();
        this.getCap4MagicManager().importServiceSummary(bid, vId, sc, importResult, businessDataBean);
        MagicServiceSummary serviceSummary = importResult.getServiceSummary(bid, vId);
        List methodConfigs = sc.getMethodConfig();
        for (ServiceMethodConfig mc : methodConfigs) {
            MagicInterfaceDefineEntity checkExist = this.getMagicInterfaceDefineDao().loadDefineById(bid, vId, mc.getMethodName());
            if (checkExist != null) {
                BizConfigBean biz;
                importResult.addProviderExists(checkExist);
                if (serviceSummary.getOwner() == null || (biz = this.getBusinessManager4().findBizConfigByFormId(Long.parseLong(serviceSummary.getOwner()))) == null || !biz.getId().equals(businessDataBean.getBizConfigBean().getId())) continue;
                MagicInterfaceDefineEntity update = this.initMethodForImport(sc, bid, vId, mc, businessDataBean);
                update.setId(checkExist.getId());
                this.getMagicInterfaceDefineDao().saveEntityInCache(update);
                importResult.addProviderUpdate(update);
                continue;
            }
            checkExist = this.initMethodForImport(sc, bid, vId, mc, businessDataBean);
            importResult.addProviderNew(checkExist);
            this.getMagicInterfaceDefineDao().saveEntityInCache(checkExist);
        }
        File publicFolders = SystemEnvironment.getClusterPublicFolder((String)"interface");
        File businessFolder = new File(publicFolders, sc.getBusinessId() + ".zip");
        FileUtil.copyFile((File)zipFolder, (File)businessFolder);
        List<MagicServiceProviderPO> allProviders = this.getMagicProviderDao().loadProviders(bid, vId);
        if (provider != null && provider.getInternalProviderInfo() != null && provider.getInternalProviderInfo().getProviders() != null && !provider.getInternalProviderInfo().getProviders().isEmpty()) {
            for (Map<String, Object> i : provider.getInternalProviderInfo().getProviders()) {
                String uniqueToken = ParamUtil.getString(i, (String)"uniqueToken", (String)"");
                String sourceType = ParamUtil.getString(i, (String)"sourceType", (String)"");
                String source = ParamUtil.getString(i, (String)"source", (String)"");
                List methodMapping = (List)i.get("methodMapping");
                HashMap<String, Map> redirectMap = new HashMap<String, Map>();
                if (methodMapping != null) {
                    for (Object x : methodMapping) {
                        Map<String, Object> redirectMethod;
                        String tempName;
                        if (x == null || x.isEmpty() || !Strings.isNotBlank((String)(tempName = ParamUtil.getString((Map)x, (String)"methodName"))) || (redirectMethod = this.redirectMethodMapping(sourceType, source, (Map)x, businessDataBean)) == null || redirectMethod.isEmpty()) continue;
                        redirectMap.put(tempName, redirectMethod);
                    }
                }
                MagicServiceProviderPO existPo = null;
                if (allProviders != null && !allProviders.isEmpty()) {
                    Object x;
                    x = allProviders.iterator();
                    while (x.hasNext()) {
                        MagicServiceProviderPO p = (MagicServiceProviderPO)x.next();
                        if (!Strings.isNotBlank((String)p.getExt4()) || !p.getExt4().equals(uniqueToken)) continue;
                        existPo = p;
                        break;
                    }
                }
                MagicServiceProviderPO importProvider = this.initProviderForImport(bid, vId, sc.getOwnerType(), i, redirectMap, businessDataBean, importResult);
                if (existPo == null) {
                    importResult.addNewProvierCache(importProvider);
                    continue;
                }
                if (Strings.isBlank((String)existPo.getExt4())) {
                    importProvider.setExt4(GenerateUtils.generateThirdBusinessId((long)UUIDLong.longUUID()));
                } else {
                    importProvider.setExt4(existPo.getExt4());
                }
                importProvider.setId(existPo.getId());
                String existMethodMapping = existPo.getExt1();
                if (Strings.isBlank((String)existMethodMapping)) {
                    importProvider.setExt1(JSONUtils.getJSonString(redirectMap));
                } else {
                    ArrayList existList = new ArrayList();
                    JSONUtils.parseJSonListObj_Class(existPo.getExt1(), existList, Map.class);
                    LinkedList<Object> mergeMethodMapping = new LinkedList<Object>();
                    mergeMethodMapping.addAll(existList);
                    for (Map map : existList) {
                        String methodName;
                        if (map == null || redirectMap.containsKey(methodName = ParamUtil.getString((Map)map, (String)"methodName", (String)""))) continue;
                        mergeMethodMapping.add(redirectMap.get(methodName));
                    }
                    importProvider.setExt1(JSONUtils.getJSonString(mergeMethodMapping));
                }
                importResult.addUpdateProvierCache(importProvider);
                importResult.addExistsProvierCache(existPo);
            }
        }
    }

    private Map<String, Object> redirectMethodMapping(String sourceType, String source, Map oldMethodMapping, BusinessDataBean businessDataBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(oldMethodMapping);
        if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(sourceType)) {
            Long newFormId = businessDataBean.getNewIdByOldId(Long.valueOf(Long.parseLong(source)));
            if (newFormId == null) {
                return result;
            }
            MagicFormBean formBean = new MagicFormBean(MagicEnums.ServiceOwnerType.DEFAULT_FORM, newFormId);
            if (!formBean.isNull()) {
                Map otherSet;
                Map argsMappingObj = (Map)oldMethodMapping.get("argsMapping");
                if (argsMappingObj != null) {
                    if (argsMappingObj.containsKey("dataRight")) {
                        argsMappingObj.put("dataRight", this.redirectDataRight((Map)argsMappingObj.get("dataRight"), businessDataBean));
                    } else if (argsMappingObj.containsKey("template")) {
                        argsMappingObj.put("template", this.redirectTemplate((Map)argsMappingObj.get("template"), businessDataBean));
                    }
                    result.put("argsMapping", argsMappingObj);
                }
                if ((otherSet = (Map)oldMethodMapping.get("otherSet")) != null) {
                    result.put("otherSet", this.redirectFormTableName(otherSet, businessDataBean));
                }
            }
        }
        return result;
    }

    private Map<String, Object> redirectFormTableName(Map oldFormTable, BusinessDataBean businessDataBean) {
        HashMap<String, String> newTableMapping = new HashMap<String, String>();
        Map tableMapping = (Map)oldFormTable.get("tableName");
        if (tableMapping != null) {
            for (Object t : tableMapping.keySet()) {
                String newTableName;
                String oldValue = ParamUtil.getString((Map)tableMapping, (String)t.toString());
                if (Strings.isBlank((String)oldValue) || (newTableName = businessDataBean.getOldAndNewStringMap(oldValue)) == null) continue;
                newTableMapping.put(t.toString(), newTableName);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tableName", newTableMapping);
        return result;
    }

    private Map<String, Object> redirectTemplate(Map oldTemplateMapping, BusinessDataBean businessDataBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object t : oldTemplateMapping.keySet()) {
            Long newTemplateId;
            String oldValue = ParamUtil.getString((Map)oldTemplateMapping, (String)t.toString());
            if (Strings.isBlank((String)oldValue)) continue;
            Long oldTemplete = Long.parseLong(oldValue);
            if (oldTemplete != null && businessDataBean.isUpgrade()) {
                oldTemplete = businessDataBean.getRealId4Upgrade(oldTemplete);
            }
            if ((newTemplateId = businessDataBean.getNewIdByOldId(oldTemplete)) == null) continue;
            result.put(t.toString(), newTemplateId);
        }
        return result;
    }

    private Map<String, Object> redirectDataRight(Map oldDataRightMapping, BusinessDataBean businessDataBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object t : oldDataRightMapping.keySet()) {
            String oldValue = ParamUtil.getString((Map)oldDataRightMapping, (String)t.toString());
            if (Strings.isBlank((String)oldValue)) continue;
            String[] oldValueArray = oldValue.split("[.]");
            Long viewId = Long.parseLong(oldValueArray[0]);
            Long rightId = Long.parseLong(oldValueArray[1]);
            if (businessDataBean.isUpgrade()) {
                if (viewId != null) {
                    viewId = businessDataBean.getRealId4Upgrade(viewId);
                }
                if (rightId != null) {
                    rightId = businessDataBean.getRealId4Upgrade(rightId);
                }
            }
            Long newViewId = businessDataBean.getNewIdByOldId(viewId);
            Long newRightId = businessDataBean.getNewIdByOldId(rightId);
            if (newViewId == null || newRightId == null) continue;
            result.put(t.toString(), newViewId + "." + newRightId);
        }
        return result;
    }

    @Override
    public void exportMagic(BusinessDataBean businessDataBean, List<ServiceConfig> serviceConfigs, Map<String, Object> extParams) throws BusinessException {
        String zipFolder = businessDataBean.getZipFolder();
        File exportMagicFolder = new File(zipFolder, "interface");
        File tempMagicFolderItem = this.createExportFolder();
        for (ServiceConfig sc : serviceConfigs) {
            super.signServiceConfig(sc);
            if (MagicPrivateUtils.isNumeric(sc.getOwner())) {
                Long realFormId = businessDataBean.getRealId4Export(Long.valueOf(Long.parseLong(sc.getOwner())));
                sc.setOwner(String.valueOf(realFormId));
            }
            this.exportServiceConfig(businessDataBean, exportMagicFolder, sc, tempMagicFolderItem);
        }
    }

    private void exportServiceConfig(BusinessDataBean businessDataBean, File exportMagicFolder, ServiceConfig serviceConfig, File tempFolder) throws BusinessException {
        try {
            MagicExportFileVo thisServiceFolder = this.createBusinessExportFolder(tempFolder, serviceConfig.getBusinessId());
            List<MagicServiceProviderPO> providers = this.getMagicProviderDao().loadProviders(serviceConfig.getBusinessId(), serviceConfig.getVersion());
            serviceConfig.setImplsConfigs(Collections.emptyList());
            super.signServiceConfig(serviceConfig);
            this.saveServiceConfig(serviceConfig, thisServiceFolder.getInterfaceFolder());
            MagicExportProvider exportProvider = this.convertProvider(businessDataBean, serviceConfig.getOwnerType(), serviceConfig.getOwner(), providers, serviceConfig);
            this.saveInternalProvider(exportProvider, thisServiceFolder.getInterfaceFolder());
            this.zipAndCopyToExportRoot(exportMagicFolder, thisServiceFolder, true, serviceConfig.getBusinessId(), false);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private MagicExportProvider convertProvider(BusinessDataBean businessDataBean, String ownerType, String owner, List<MagicServiceProviderPO> alls, ServiceConfig sc) throws BusinessException {
        MagicExportProvider result = new MagicExportProvider();
        result.setBusinessId(sc.getBusinessId());
        result.setVersion(sc.getVersion());
        result.setProviderType(MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey());
        MagicInternalProviderInfo internalProviderInfo = new MagicInternalProviderInfo();
        for (MagicServiceProviderPO p : alls) {
            FormBean formBean;
            Map scopeSet;
            Map export = p.getExportJSONFormPublish();
            this.updateRealId(export, businessDataBean);
            if (export.containsKey("scopeSet") && (scopeSet = (Map)export.get("scopeSet")) != null && MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(ownerType) && MagicPrivateUtils.isNumeric(owner) && (formBean = this.cap4FormCacheManager.getForm(Long.parseLong(owner))) != null) {
                String formulaStr = ParamUtil.getString((Map)scopeSet, (String)"formulaStr", (String)"");
                FormFormulaBean filterFormula = new FormFormulaBean(formBean);
                filterFormula.setId(Long.valueOf(UUIDLong.longUUID()));
                filterFormula.loadFromFormula(formulaStr);
                CtpFormula formula = formBean.newCTPFormula4Save(filterFormula, 2);
                Map conditionFormula = FormDesignUtil.getFormulaJsonMap4Export((FormBean)formBean, (CtpFormula)formula, (FormFormulaBean)filterFormula, null);
                export.put("scopeSet", conditionFormula);
            }
            internalProviderInfo.addProvider(export);
        }
        result.setInternalProviderInfo(internalProviderInfo);
        return result;
    }

    private void updateRealId(Map<String, Object> export, BusinessDataBean businessDataBean) {
        List methodMapping = (List)export.get("methodMapping");
        for (Map t : methodMapping) {
            Map argsMapping = (Map)t.get("argsMapping");
            if (argsMapping == null) continue;
            for (Map.Entry args : argsMapping.entrySet()) {
                String oldValue;
                Map dataRight;
                if ("dataRight".equals(args.getKey())) {
                    dataRight = (Map)args.getValue();
                    for (Map.Entry dataRightItem : dataRight.entrySet()) {
                        oldValue = dataRightItem.getValue().toString();
                        String[] oldValueArray = oldValue.split("[.]");
                        Long viewId = Long.parseLong(oldValueArray[0]);
                        Long rightId = Long.parseLong(oldValueArray[1]);
                        Long newViewId = businessDataBean.getRealId4Export(viewId);
                        Long newRightId = businessDataBean.getRealId4Export(rightId);
                        dataRight.put(dataRightItem.getKey(), newViewId + "." + newRightId);
                    }
                }
                if (!"template".equals(args.getKey())) continue;
                dataRight = (Map)args.getValue();
                for (Map.Entry dataRightItem : dataRight.entrySet()) {
                    oldValue = dataRightItem.getValue().toString();
                    Long templateId = Long.parseLong(oldValue);
                    Long newTemplateId = businessDataBean.getRealId4Export(templateId);
                    dataRight.put(dataRightItem.getKey(), newTemplateId);
                }
            }
        }
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public FormulaDAO getFormulaDAO() {
        return this.formulaDAO;
    }

    public void setFormulaDAO(FormulaDAO formulaDAO) {
        this.formulaDAO = formulaDAO;
    }
}

