/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.incision;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.magic.business.bind.MagicBindInternalServiceManager;
import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.business.incision.ICAP4MagicIncisionManager;
import com.seeyon.cap4.magic.compiler.IMagicCompilerManager;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.vo.IncisionResult;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.cap4.magic.vo.MagicFormFieldBean;
import com.seeyon.cap4.magic.vo.MagicFormTableBean;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.config.ArgsConfigGuide;
import com.seeyon.datamagic.engine.domain.config.EntryAnnotation;
import com.seeyon.datamagic.engine.domain.config.EntryConfigItem;
import com.seeyon.datamagic.engine.domain.metadata.MetadataConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import com.seeyon.datamagic.engine.utils.GenerateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;

public abstract class AbstractMagicIncision
implements ICAP4MagicIncisionManager {
    private static final Log LOGGER = CtpLogFactory.getLog(AbstractMagicIncision.class);
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private IMagicProviderDao magicProviderDao;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private MagicBindInternalServiceManager magicBindInternalServiceManager;
    private IMagicCompilerManager magicCompilerManager;
    private IMagicServiceSummaryDao magicServiceSummaryDao;

    private String setServiceDefaultName(MagicFormBean targetFormBean, MagicEnums.BusinessMethodType type) {
        String temp = "";
        if (type != null) {
            switch (type) {
                case TRIGGER_CREATE: {
                    if (targetFormBean.isFlowForm()) {
                        temp = ResourceUtil.getString((String)"processLog.action.name.72");
                        break;
                    }
                    temp = ResourceUtil.getString((String)"processLog.action.name.73");
                    break;
                }
                case TRIGGER_UPDATE: {
                    temp = ResourceUtil.getString((String)"processLog.action.name.74");
                    break;
                }
                case RELATION_USER: 
                case RELATION_SYS: {
                    temp = ResourceUtil.getString((String)"form.businesstype.type.relation");
                    break;
                }
                case TRIGGER_DISTRIBUTE: {
                    temp = ResourceUtil.getString((String)"form.businesstype.trigger.distribute.label");
                    break;
                }
                case QUERY: {
                    temp = ResourceUtil.getString((String)"cap.template.common.query");
                    break;
                }
                case TRIGGER_FEEDBACK: {
                    temp = ResourceUtil.getString((String)"form.businesstype.trigger.feedback.label");
                    break;
                }
            }
        }
        temp = temp + targetFormBean.getFormName() + DateUtil.get19DateAndTime();
        return temp;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IncisionResult triggerIncision(FormTriggerActionBean actionBean, boolean generate) throws BusinessException {
        String type = ParamUtil.getString((Map)actionBean.getParam(), (String)"triggerType");
        long targetFormId = ParamUtil.getLong((Map)actionBean.getParam(), (String)"targetFormId");
        long sourceFormId = actionBean.getFormTriggerBean().getSourceFormId();
        MagicFormBean targetFormBean = new MagicFormBean(this.getType(), targetFormId);
        FormBean sourceFormBean = this.cap4FormCacheManager.getForm(sourceFormId);
        LinkedList<MagicFormFieldBean> targetDecimalFields = new LinkedList<MagicFormFieldBean>();
        for (MagicFormFieldBean ffb : targetFormBean.getAllFieldBeans()) {
            if (!Enums.FieldType.DECIMAL.getKey().equals(ffb.getFieldType())) continue;
            targetDecimalFields.add(ffb);
        }
        HashMap fillBackFieldBean = new HashMap();
        HashSet<String> targetFieldsInMapping = new HashSet<String>();
        HashSet<String> allQuerySet = new HashSet<String>();
        List fillBackList = (List)actionBean.getParam(FormTriggerBean.ActionParam.FillBack.getKey());
        for (SimpleObjectBean fill : fillBackList) {
            String fillType = fill.getType();
            String value = fill.getValue();
            String name = fill.getName();
            MagicFormFieldBean targetField = targetFormBean.getFieldBeanByName(name.split("[.]")[1]);
            if (targetField == null) continue;
            String ownerTableName = targetField.getOwnerTableName();
            Map<String, MagicFormFieldBean> tempFieldSet = (HashMap<String, MagicFormFieldBean>)fillBackFieldBean.get(ownerTableName);
            if (tempFieldSet == null) {
                tempFieldSet = new HashMap<String, MagicFormFieldBean>();
                fillBackFieldBean.put(ownerTableName, tempFieldSet);
            }
            tempFieldSet.put(targetField.getName(), targetField);
            targetFieldsInMapping.add(targetField.getName());
            allQuerySet.add(targetField.getName());
            if (!FormTriggerBean.FillBackType.formula.getKey().equals(fillType)) continue;
            FormFormulaBean formula = (FormFormulaBean)fill.getExtraAttr(value);
            if (formula == null) {
                formula = this.cap4FormCacheManager.loadFormFormulaBean(sourceFormBean, Long.valueOf(value));
            }
            if (formula == null) continue;
            String formulaSql = formula.getExecuteFormulaForSQL();
            for (MagicFormFieldBean field : targetDecimalFields) {
                String tableName = field.getOwnerTableName();
                tableName = field.isMasterField() ? tableName.replace(Enums.TableType.MASTER.getTableSufName() + "_", "b") : tableName.replace(Enums.TableType.SLAVE.getTableSufName() + "_", "b");
                if (!formulaSql.contains(tableName = tableName + "." + field.getName())) continue;
                allQuerySet.add(field.getName());
                tempFieldSet = (Map)fillBackFieldBean.get(field.getOwnerTableName());
                if (tempFieldSet == null) {
                    tempFieldSet = new HashMap();
                    fillBackFieldBean.put(field.getOwnerTableName(), tempFieldSet);
                }
                targetFieldsInMapping.add(field.getName());
                tempFieldSet.put(field.getName(), field);
            }
        }
        IncisionResult result = new IncisionResult();
        ArrayList<Collection<String>> args = new ArrayList<Collection<String>>();
        MagicInterfaceDefineEntity interfaceDefineEntity = null;
        FormTriggerBean.TriggerType triggerTypeEnum = FormTriggerBean.TriggerType.getEnumByKey((String)type);
        String methodName = GenerateUtils.generateRandomMD5((String)"m");
        String methodDisplayName = null;
        String bid = this.generateBusinessId(targetFormBean.getId());
        String version = "1";
        HashMap<String, MetadataConfig> metadataConfigMap = new HashMap<String, MetadataConfig>();
        ArrayList<MagicInterfaceDefineEntity> saveMethodConfig = new ArrayList<MagicInterfaceDefineEntity>();
        if (triggerTypeEnum != null) {
            switch (triggerTypeEnum) {
                case CreateFlow: 
                case CreateUnflow: 
                case Cap4CreateCap3Flow: 
                case Cap4CreateCap3UnFlow: {
                    methodDisplayName = this.setServiceDefaultName(targetFormBean, MagicEnums.BusinessMethodType.TRIGGER_CREATE);
                    args.add(targetFieldsInMapping);
                    interfaceDefineEntity = this.checkEntityExistsByFormId(MagicEnums.BusinessMethodType.TRIGGER_CREATE, targetFormId, null, args);
                    for (Map.Entry entry : fillBackFieldBean.entrySet()) {
                        ArrayList lists = new ArrayList();
                        lists.addAll(((Map)entry.getValue()).values());
                    }
                    ServiceMethodConfig createMethod = MagicCreateServiceUtils.createTriggerCreate(targetFormBean, targetFieldsInMapping, methodDisplayName, methodName, bid, version, metadataConfigMap);
                    if (interfaceDefineEntity == null) {
                        interfaceDefineEntity = MagicCreateServiceUtils.convertMethodToPo(targetFormBean.getType().getType(), String.valueOf(targetFormId), bid, version, createMethod);
                        saveMethodConfig.add(interfaceDefineEntity);
                        result.addInterface(interfaceDefineEntity);
                        actionBean.addParam("dataMagicId", (Object)interfaceDefineEntity.getId());
                        actionBean.addParam("needRename", (Object)"1");
                    } else {
                        bid = interfaceDefineEntity.getBusinessId();
                        version = interfaceDefineEntity.getVersionId();
                        actionBean.addParam("dataMagicId", (Object)interfaceDefineEntity.getId());
                        actionBean.addParam("needRename", (Object)"0");
                    }
                    this.setDefaultImplMapping(bid, version, createMethod, targetFormBean);
                    break;
                }
                case Update: 
                case Cap4UpdateCap3: {
                    List holdingFields;
                    methodDisplayName = this.setServiceDefaultName(targetFormBean, MagicEnums.BusinessMethodType.TRIGGER_UPDATE);
                    HashSet<String> conditionFieldBeans = new HashSet<String>();
                    Map relationCondition = actionBean.getRelationConditionMap();
                    if (relationCondition != null) {
                        for (Map.Entry entry : relationCondition.entrySet()) {
                            String fieldNames = (String)entry.getKey();
                            MagicFormFieldBean currentFieldBean = targetFormBean.getFieldBeanByName(fieldNames);
                            if (currentFieldBean == null) continue;
                            conditionFieldBeans.add(fieldNames);
                        }
                        args.add(relationCondition.keySet());
                    }
                    if ((holdingFields = actionBean.getWithHoldingFields()) != null && !holdingFields.isEmpty()) {
                        for (SimpleObjectBean sob : holdingFields) {
                            String name = sob.getName();
                            String[] nameArray = name.split("[.]");
                            MagicFormFieldBean fb = targetFormBean.getFieldBeanByName(nameArray[1]);
                            HashMap<String, MagicFormFieldBean> fields = (HashMap<String, MagicFormFieldBean>)fillBackFieldBean.get(nameArray[0]);
                            if (fields == null && fb != null) {
                                fields = new HashMap<String, MagicFormFieldBean>();
                                fillBackFieldBean.put(nameArray[0], fields);
                            }
                            if (fb == null) continue;
                            fields.put(fb.getName(), fb);
                            targetFieldsInMapping.add(fb.getName());
                        }
                    }
                    interfaceDefineEntity = this.checkEntityExistsByFormId(MagicEnums.BusinessMethodType.TRIGGER_UPDATE, targetFormId, targetFieldsInMapping, args);
                    for (Map.Entry entry : fillBackFieldBean.entrySet()) {
                        ArrayList lists = new ArrayList();
                        lists.addAll(((Map)entry.getValue()).values());
                    }
                    ServiceMethodConfig serviceMethodConfig = MagicCreateServiceUtils.createTriggerUpdate(targetFormBean, targetFieldsInMapping, conditionFieldBeans, methodDisplayName, methodName, bid, version, allQuerySet, metadataConfigMap);
                    if (interfaceDefineEntity == null) {
                        interfaceDefineEntity = MagicCreateServiceUtils.convertMethodToPo(targetFormBean.getType().getType(), String.valueOf(targetFormId), bid, version, serviceMethodConfig);
                        saveMethodConfig.add(interfaceDefineEntity);
                        result.addInterface(interfaceDefineEntity);
                        actionBean.addParam("dataMagicId", (Object)interfaceDefineEntity.getId());
                        actionBean.addParam("needRename", (Object)"1");
                    } else {
                        bid = interfaceDefineEntity.getBusinessId();
                        version = interfaceDefineEntity.getVersionId();
                        actionBean.addParam("dataMagicId", (Object)interfaceDefineEntity.getId());
                        actionBean.addParam("needRename", (Object)"0");
                    }
                    this.setDefaultImplMapping(bid, version, serviceMethodConfig, targetFormBean);
                    ServiceMethodConfig queryMethod = MagicCreateServiceUtils.createTriggerQuery(bid, version, metadataConfigMap);
                    if (this.magicInterfaceDefineDao.loadDefineById(bid, version, queryMethod.getMethodName()) != null) {
                        LOGGER.info((Object)(targetFormBean.getFormName() + " \u5b58\u5728\u67e5\u8be2\u63a5\u53e3  \u4e0d\u518d\u751f\u6210\u67e5\u8be2\u63a5\u53e3"));
                        break;
                    }
                    MagicInterfaceDefineEntity queryEntry = MagicCreateServiceUtils.convertMethodToPo(targetFormBean.getType().getType(), String.valueOf(targetFormId), bid, version, queryMethod);
                    saveMethodConfig.add(queryEntry);
                    this.setDefaultImplMapping(bid, version, queryMethod, targetFormBean);
                    break;
                }
                case Distribution: {
                    methodDisplayName = this.setServiceDefaultName(targetFormBean, MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE);
                    List feedBackList = (List)actionBean.getParam(FormTriggerBean.ActionParam.FeedBack.getKey());
                    HashMap feedBackFieldBean = new HashMap();
                    HashSet<String> feedBackFieldNames = new HashSet<String>();
                    args.add(targetFieldsInMapping);
                    if (feedBackList != null) {
                        for (SimpleObjectBean temp : feedBackList) {
                            void var39_45;
                            String value = temp.getValue();
                            MagicFormFieldBean currentFieldBean = targetFormBean.getFieldBeanByName(value.split("[.]")[1]);
                            if (currentFieldBean == null) continue;
                            String ownerTableName = currentFieldBean.getOwnerTableName();
                            List list = (List)feedBackFieldBean.get(ownerTableName);
                            if (list == null) {
                                ArrayList arrayList = new ArrayList();
                                feedBackFieldBean.put(ownerTableName, arrayList);
                            }
                            var39_45.add(currentFieldBean);
                            feedBackFieldNames.add(currentFieldBean.getName());
                        }
                    }
                    interfaceDefineEntity = this.checkEntityExistsByFormId(MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE, targetFormId, null, args);
                    MagicInterfaceDefineEntity feedbackExist = this.checkEntityExistsByFormId(MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK, targetFormBean.getId(), feedBackFieldNames, null);
                    String feedbackMethodName = GenerateUtils.generateRandomMD5((String)"m");
                    String feedbackMethodDisplay = this.setServiceDefaultName(targetFormBean, MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK);
                    ServiceMethodConfig feedBackMethod = MagicCreateServiceUtils.createTriggerFeedBack(targetFormBean, feedBackFieldNames, feedbackMethodDisplay, feedbackMethodName, bid, version, metadataConfigMap);
                    if (feedbackExist == null || !bid.equals(feedbackExist.getBusinessId()) || !version.equals(feedbackExist.getVersionId())) {
                        feedbackExist = MagicCreateServiceUtils.convertMethodToPo(targetFormBean.getType().getType(), String.valueOf(targetFormId), bid, version, feedBackMethod);
                        saveMethodConfig.add(feedbackExist);
                    }
                    this.setDefaultImplMapping(bid, version, feedBackMethod, targetFormBean);
                    for (Map.Entry entry : fillBackFieldBean.entrySet()) {
                        ArrayList lists = new ArrayList();
                        lists.addAll(((Map)entry.getValue()).values());
                    }
                    ServiceMethodConfig triggerDistribution = MagicCreateServiceUtils.createTriggerDistribution(targetFormBean, targetFieldsInMapping, feedBackFieldNames, methodDisplayName, methodName, bid, version, metadataConfigMap, feedbackExist.getMethodName());
                    if (interfaceDefineEntity == null) {
                        interfaceDefineEntity = MagicCreateServiceUtils.convertMethodToPo(targetFormBean.getType().getType(), String.valueOf(targetFormId), bid, version, triggerDistribution);
                        saveMethodConfig.add(interfaceDefineEntity);
                        actionBean.addParam("dataMagicId", (Object)interfaceDefineEntity.getId());
                        actionBean.addParam("needRename", (Object)"1");
                    } else {
                        bid = interfaceDefineEntity.getBusinessId();
                        version = interfaceDefineEntity.getVersionId();
                        actionBean.addParam("dataMagicId", (Object)interfaceDefineEntity.getId());
                        actionBean.addParam("needRename", (Object)"0");
                    }
                    this.setDefaultImplMapping(bid, version, triggerDistribution, targetFormBean);
                    break;
                }
            }
        }
        if (interfaceDefineEntity == null) {
            return null;
        }
        actionBean.addParam("businessId", (Object)interfaceDefineEntity.getBusinessId());
        actionBean.addParam("versionId", (Object)interfaceDefineEntity.getVersionId());
        actionBean.addParam("methodName", (Object)interfaceDefineEntity.getMethodName());
        MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(bid, version);
        if (serviceSummary == null) {
            serviceSummary = bid.startsWith("FFFF") ? MagicCreateServiceUtils.createServiceSummary(bid, version, targetFormBean, metadataConfigMap, MagicEnums.CertificateType.Private_certificate) : MagicCreateServiceUtils.createServiceSummary(bid, version, targetFormBean, metadataConfigMap, MagicEnums.CertificateType.Public_certificate);
            this.magicServiceSummaryDao.save(serviceSummary);
        } else if (serviceSummary.getMetadata() != null) {
            ArrayList existsMetadata = new ArrayList();
            JSONUtils.parseJSonListObj_Class(serviceSummary.getMetadata(), existsMetadata, MetadataConfig.class);
            existsMetadata.addAll(metadataConfigMap.values());
            serviceSummary.setMetadata(JSONUtils.getJSonString(existsMetadata));
            this.magicServiceSummaryDao.update(serviceSummary);
        }
        this.magicInterfaceDefineDao.saveDefine(saveMethodConfig);
        MagicReflectionRelationPO reflectionRelation = this.magicBindInternalServiceManager.bindTrigger(serviceSummary, actionBean.getFormTriggerBean(), actionBean, interfaceDefineEntity, generate);
        if (generate) {
            this.magicCompilerManager.generateByRelation(reflectionRelation);
        }
        result.addReflection(reflectionRelation);
        return result;
    }

    protected abstract MagicInterfaceDefineEntity checkEntityExistsByFormId(MagicEnums.BusinessMethodType var1, long var2, Collection<String> var4, List<Collection<String>> var5) throws BusinessException;

    abstract String getServiceSubType();

    protected boolean checkEntityExits(long formId, MagicInterfaceDefineEntity e, MagicEnums.BusinessMethodType st, Collection<String> returnSort, List<Collection<String>> args) {
        String ext1 = e.getExt1();
        if (Strings.isBlank((String)ext1) || !ext1.trim().startsWith("{")) {
            return false;
        }
        boolean isfields = this.checkFieldNames(e, st, returnSort, args);
        if (isfields) {
            Map extMapper = (Map)JSONUtil.parseJSONString((String)e.getExt1(), Map.class);
            Map fieldLimit = (Map)extMapper.get("fieldLimit");
            MagicFormBean fb = new MagicFormBean(this.getType(), formId);
            if (fieldLimit != null && !fb.isNull()) {
                for (Object t : fieldLimit.keySet()) {
                    Map itemLists;
                    MagicFormFieldBean ffb = fb.getFieldBeanByName(t.toString());
                    String limitStr = ParamUtil.getString((Map)fieldLimit, (String)t.toString(), null);
                    if (Strings.isBlank((String)limitStr) || ffb.isNull() || (itemLists = (Map)JSONUtil.parseJSONString((String)limitStr, Map.class)) == null) continue;
                    String inputType = ParamUtil.getString((Map)itemLists, (String)"inputType", (String)"");
                    String fieldType = ParamUtil.getString((Map)itemLists, (String)"fieldType", (String)"");
                    String ownerTableName = ParamUtil.getString((Map)itemLists, (String)"ownerTableName", (String)"");
                    String enumLevel = ParamUtil.getString((Map)itemLists, (String)"enumLevel", (String)"");
                    String isFinalChild = ParamUtil.getString((Map)itemLists, (String)"isFinalChild", (String)"");
                    String fieldLength = ParamUtil.getString((Map)itemLists, (String)"fieldLength", (String)"");
                    String digitNum = ParamUtil.getString((Map)itemLists, (String)"digitNum", (String)"");
                    String enumId = ParamUtil.getString((Map)itemLists, (String)"value", (String)"");
                    if (!(inputType.equalsIgnoreCase(ffb.getInputType()) && fieldType.equalsIgnoreCase(ffb.getFieldType()) && fieldLength.equalsIgnoreCase(ffb.getFieldLength()) && ownerTableName.equals(ffb.getOwnerTableName()))) {
                        return false;
                    }
                    if (!("select".equalsIgnoreCase(inputType) || "imageselect".equalsIgnoreCase(inputType) || "radio".equalsIgnoreCase(inputType) || "imageradio".equalsIgnoreCase(inputType) ? !enumId.equals(ffb.getEnumId() + "") || !enumLevel.equals(ffb.getEnumLevel() + "") || !isFinalChild.equals(ffb.getIsFinalChild() ? "1" : "0") : "DECIMAL".equalsIgnoreCase(fieldType) && !digitNum.equals(ffb.getDigitNum()))) continue;
                    return false;
                }
                if (Strings.isNotBlank((String)e.getArgsConfigGuide())) {
                    ArrayList guideList = new ArrayList();
                    JSONUtils.parseJSonListObj_Class(e.getArgsConfigGuide(), guideList, ArgsConfigGuide.class);
                    HashMap<String, String> templateMapping = new HashMap<String, String>(fb.getTemplateMapping());
                    for (ArgsConfigGuide t : guideList) {
                        EntryAnnotation ea;
                        if ("template".equals(t.getArgsName())) {
                            ea = JSONUtils.parseJSonStr_Class(t.getGuideStr(), EntryAnnotation.class);
                            if (ea.getConfigList() != null) {
                                for (EntryConfigItem eci : ea.getConfigList()) {
                                    if (!templateMapping.containsKey(eci.getName())) {
                                        return false;
                                    }
                                    templateMapping.remove(eci.getName());
                                }
                            }
                            if (templateMapping.isEmpty()) continue;
                            return false;
                        }
                        if (!"dataRight".equals(t.getArgsName())) continue;
                        ea = JSONUtils.parseJSonStr_Class(t.getGuideStr(), EntryAnnotation.class);
                        ArgsConfigGuide newDataRightGuide = MagicCreateServiceUtils.setDataRight(fb, st);
                        EntryAnnotation entryAnnotation = (EntryAnnotation)newDataRightGuide.loadGuide();
                        HashMap<String, String> rightMapping = new HashMap<String, String>();
                        for (EntryConfigItem s : entryAnnotation.getConfigList()) {
                            rightMapping.put(s.getName(), s.getName());
                        }
                        if (ea.getConfigList() != null) {
                            for (EntryConfigItem eci : ea.getConfigList()) {
                                if (!rightMapping.containsKey(eci.getName())) {
                                    return false;
                                }
                                rightMapping.remove(eci.getName());
                            }
                        }
                        if (rightMapping.isEmpty()) continue;
                        return false;
                    }
                }
            }
        }
        return isfields;
    }

    private boolean checkFieldNames(MagicInterfaceDefineEntity e, MagicEnums.BusinessMethodType st, Collection<String> returnSort, List<Collection<String>> args) {
        try {
            String ext1 = e.getExt1();
            Map ext = (Map)JSONUtil.parseJSONString((String)ext1, Map.class);
            if (ext == null || ext.isEmpty()) {
                return false;
            }
            TreeSet<String> condition = new TreeSet<String>();
            List resultKey = null;
            List conditions = null;
            List argsFieldList = null;
            switch (st) {
                case RELATION_SYS: {
                    resultKey = (List)ext.get("resultKey");
                    conditions = (List)ext.get("condition");
                    if (args != null && !args.isEmpty()) {
                        condition.addAll(args.get(0));
                    }
                    if ((resultKey == null || resultKey.isEmpty()) && returnSort.isEmpty()) {
                        return true;
                    }
                    if (resultKey == null) {
                        return false;
                    }
                    if (resultKey.size() < returnSort.size()) {
                        return false;
                    }
                    for (Object temp : returnSort.toArray()) {
                        if (resultKey.contains(temp)) continue;
                        return false;
                    }
                    if ((conditions == null || conditions.isEmpty()) && condition.isEmpty()) {
                        return true;
                    }
                    if (conditions == null) {
                        return false;
                    }
                    for (Object temp : conditions.toArray()) {
                        if (condition.contains(temp)) continue;
                        return false;
                    }
                    break;
                }
                case RELATION_USER: {
                    resultKey = (List)ext.get("resultKey");
                    if ((resultKey == null || resultKey.isEmpty()) && returnSort.isEmpty()) {
                        return true;
                    }
                    if (resultKey == null) {
                        return false;
                    }
                    for (Object temp : returnSort.toArray()) {
                        if (resultKey.contains(temp)) continue;
                        return false;
                    }
                    break;
                }
                case TRIGGER_CREATE: 
                case TRIGGER_DISTRIBUTE: {
                    condition.clear();
                    argsFieldList = (List)ext.get("fillback");
                    if (args != null && !args.isEmpty()) {
                        condition.addAll(args.get(0));
                    }
                    for (Object temp : condition.toArray()) {
                        if (argsFieldList.contains(temp)) continue;
                        return false;
                    }
                    break;
                }
                case TRIGGER_FEEDBACK: {
                    argsFieldList = (List)ext.get("resultKey");
                    for (Object temp : returnSort.toArray()) {
                        if (argsFieldList.contains(temp)) continue;
                        return false;
                    }
                    break;
                }
                case TRIGGER_UPDATE: {
                    condition.clear();
                    argsFieldList = (List)ext.get("fillback");
                    if (args != null && !args.isEmpty()) {
                        condition.addAll(args.get(0));
                    }
                    if (((conditions = (List)ext.get("condition")) == null || conditions.isEmpty()) && condition.isEmpty()) {
                        return true;
                    }
                    if (conditions == null) {
                        return false;
                    }
                    for (Object temp : conditions.toArray()) {
                        if (condition.contains(temp)) continue;
                        return false;
                    }
                    for (Object temp : returnSort.toArray()) {
                        if (argsFieldList.contains(temp)) continue;
                        return false;
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IncisionResult relationIncision(FormRelationshipBean shipBean, FormRelationshipMapBean ship, boolean generate) throws BusinessException {
        List sortFieldList;
        List queryFieldList;
        List showFieldList;
        String value;
        long targetFormId = shipBean.getTargetFormId();
        MagicFormBean targetFormBean = new MagicFormBean(this.getType(), targetFormId);
        FormBean sourceForm = this.cap4FormCacheManager.getForm(shipBean.getSourceFormId());
        IncisionResult result = new IncisionResult();
        ArrayList<MagicInterfaceDefineEntity> saveEntry = new ArrayList<MagicInterfaceDefineEntity>();
        ArrayList<MagicReflectionRelationPO> allRelation = new ArrayList<MagicReflectionRelationPO>();
        Map relationFieldMap = ship.getFormRelationFieldMap();
        LinkedHashSet<String> deWeight = new LinkedHashSet<String>();
        if (shipBean.getRelationType() == FormRelationEnums.ViewSelectType.user.getKey() && Strings.isNotBlank((String)(value = (String)relationFieldMap.remove(ship.getSelectedField()))) && targetFormBean.getFieldBeanByName(value) != null) {
            deWeight.add(value);
        }
        if ((showFieldList = ship.getShowFieldList()) != null && !showFieldList.isEmpty()) {
            for (SimpleObjectBean temp : showFieldList) {
                String name = temp.getName();
                if (name.contains(".")) {
                    name = name.split("[.]")[1];
                }
                if (targetFormBean.getFieldBeanByName(name) == null) continue;
                deWeight.add(name);
            }
        }
        if ((queryFieldList = ship.getQueryFieldList()) != null && !queryFieldList.isEmpty()) {
            for (SimpleObjectBean temp : queryFieldList) {
                void var17_16;
                String string = temp.getName();
                if (string.contains(".")) {
                    String string2 = string.split("[.]")[1];
                }
                if (FormulaEnums.SystemDataField.getEnumByKey((String)var17_16) != null || targetFormBean.getFieldBeanByName((String)var17_16) == null) continue;
                deWeight.add((String)var17_16);
            }
        }
        if ((sortFieldList = ship.getSortFieldList()) != null && !sortFieldList.isEmpty()) {
            for (SimpleObjectBean simpleObjectBean : sortFieldList) {
                String name = simpleObjectBean.getName();
                if (name.contains(".")) {
                    name = name.split("[.]")[1];
                }
                if (FormulaEnums.SystemDataField.getEnumByKey((String)name) != null || targetFormBean.getFieldBeanByName(name) == null) continue;
                deWeight.add(name);
            }
        }
        for (Map.Entry entry : relationFieldMap.entrySet()) {
            String v = (String)entry.getValue();
            if (targetFormBean.getFieldBeanByName(v) == null) continue;
            deWeight.add(v);
        }
        MagicInterfaceDefineEntity interfaceDefineEntity = null;
        String string = GenerateUtils.generateRandomMD5((String)"m");
        String methodDisplayName = this.setServiceDefaultName(targetFormBean, MagicEnums.BusinessMethodType.RELATION_USER);
        String bid = this.generateBusinessId(targetFormBean.getId());
        String version = "1";
        HashMap<String, MetadataConfig> allMetadatas = new HashMap<String, MetadataConfig>();
        if (shipBean.getRelationType() == FormRelationEnums.ViewSelectType.user.getKey() || shipBean.getRelationType() == FormRelationEnums.ViewSelectType.auto_increase_row.getKey()) {
            List interflowConditions;
            if (ship.getConditionFormulaId() != 0L) {
                FormFormulaBean formulab = this.cap4FormCacheManager.loadFormFormulaBean(sourceForm, ship.getConditionFormulaId());
                String formDisplay = formulab.getFormulaForDisplay();
                for (MagicFormTableBean table : targetFormBean.getTableList()) {
                    String tableName = table.getTableName();
                    String tableNum = tableName.split("_")[1];
                    if (formDisplay.indexOf("{b" + tableNum + '.') <= -1) continue;
                    for (MagicFormFieldBean ffb : table.getFieldsByName()) {
                        if (formDisplay.indexOf("{b" + tableNum + '.' + ffb.getDisplay() + '}') <= -1) continue;
                        deWeight.add(ffb.getName());
                    }
                }
            }
            if (MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(shipBean.getTargetFormVersion()) && (interflowConditions = ship.getInterflowConditionMapList()) != null && !interflowConditions.isEmpty()) {
                for (Map condition : interflowConditions) {
                    String targetFieldName = ParamUtil.getString((Map)condition, (String)"sourceField");
                    if (!Strings.isNotBlank((String)targetFieldName)) continue;
                    if (targetFieldName.contains(".")) {
                        targetFieldName = targetFieldName.split("[.]")[1];
                    }
                    if (targetFormBean.getFieldBeanByName(targetFieldName).isNull()) continue;
                    deWeight.add(targetFieldName);
                }
            }
            interfaceDefineEntity = this.checkEntityExistsByFormId(MagicEnums.BusinessMethodType.RELATION_USER, targetFormBean.getId(), deWeight, null);
            ServiceMethodConfig smc = MagicCreateServiceUtils.createInternalRelation(targetFormBean, deWeight, null, methodDisplayName, string, bid, version, allMetadatas);
            if (interfaceDefineEntity == null) {
                interfaceDefineEntity = MagicCreateServiceUtils.convertMethodToPo(targetFormBean.getType().getType(), String.valueOf(targetFormId), bid, version, smc);
                saveEntry.add(interfaceDefineEntity);
            } else {
                bid = interfaceDefineEntity.getBusinessId();
                version = interfaceDefineEntity.getVersionId();
                result.addExistsInterface(interfaceDefineEntity.getId());
            }
            this.setDefaultImplMapping(bid, version, smc, targetFormBean);
            result.addInterface(interfaceDefineEntity);
        } else {
            Map condtionMap = FormUtil.getRelationFormulaFieldMap((FormFormulaBean)ship.getConditionFormula());
            HashSet<String> deWeightArgs = new HashSet<String>();
            for (Map.Entry entry : condtionMap.entrySet()) {
                String fieldName = (String)entry.getValue();
                MagicFormFieldBean field = targetFormBean.getFieldBeanByName(fieldName);
                if (field == null) continue;
                deWeightArgs.add(field.getName());
            }
            ArrayList<Collection<String>> args = new ArrayList<Collection<String>>();
            args.add(deWeightArgs);
            deWeight.addAll(deWeightArgs);
            interfaceDefineEntity = this.checkEntityExistsByFormId(MagicEnums.BusinessMethodType.RELATION_SYS, targetFormBean.getId(), deWeight, args);
            ServiceMethodConfig smc = MagicCreateServiceUtils.createInternalRelation(targetFormBean, deWeight, deWeightArgs, methodDisplayName, string, bid, version, allMetadatas);
            if (interfaceDefineEntity == null) {
                interfaceDefineEntity = MagicCreateServiceUtils.convertMethodToPo(targetFormBean.getType().getType(), String.valueOf(targetFormId), bid, version, smc);
                saveEntry.add(interfaceDefineEntity);
            } else {
                bid = interfaceDefineEntity.getBusinessId();
                version = interfaceDefineEntity.getVersionId();
                result.addExistsInterface(interfaceDefineEntity.getId());
            }
            this.setDefaultImplMapping(bid, version, smc, targetFormBean);
            result.addInterface(interfaceDefineEntity);
        }
        MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(bid, version);
        if (serviceSummary == null) {
            serviceSummary = bid.startsWith("FFFF") ? MagicCreateServiceUtils.createServiceSummary(bid, version, targetFormBean, allMetadatas, MagicEnums.CertificateType.Private_certificate) : MagicCreateServiceUtils.createServiceSummary(bid, version, targetFormBean, allMetadatas, MagicEnums.CertificateType.Public_certificate);
            this.magicServiceSummaryDao.save(serviceSummary);
        } else if (serviceSummary.getMetadata() != null) {
            ArrayList existsMetadata = new ArrayList();
            JSONUtils.parseJSonListObj_Class(serviceSummary.getMetadata(), existsMetadata, MetadataConfig.class);
            existsMetadata.addAll(allMetadatas.values());
            serviceSummary.setMetadata(JSONUtils.getJSonString(existsMetadata));
            this.magicServiceSummaryDao.update(serviceSummary);
        }
        this.magicInterfaceDefineDao.saveDefine(saveEntry);
        MagicReflectionRelationPO reflectionRelation = this.magicBindInternalServiceManager.bindRelation(serviceSummary, shipBean, ship, interfaceDefineEntity, generate);
        allRelation.add(reflectionRelation);
        result.addReflection(reflectionRelation);
        if (generate) {
            this.magicCompilerManager.generateByRelations(allRelation);
        }
        return result;
    }

    private String generateBusinessId(Long formId) {
        try {
            String id = MagicCreateServiceUtils.generateBusinessId(MagicEnums.CertificateType.Public_certificate);
            if (Strings.isNotBlank((String)id)) {
                return id;
            }
            return GenerateUtils.generateThirdBusinessId((long)formId);
        }
        catch (BusinessException e) {
            LOGGER.warn((Object)e.getLocalizedMessage());
            return GenerateUtils.generateThirdBusinessId((long)formId);
        }
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setDefaultImplMapping(String bId, String version, ServiceMethodConfig entity, MagicFormBean targetFormBean) {
        List<MagicServiceProviderPO> allServiceProviders = this.magicProviderDao.loadProviders(bId, version, String.valueOf(targetFormBean.getId()), targetFormBean.getType().getType());
        Map<String, Object> currentMethodMapping = MagicCreateServiceUtils.setDefaultImplMapping(entity, targetFormBean);
        if (allServiceProviders != null && !allServiceProviders.isEmpty()) {
            for (MagicServiceProviderPO p : allServiceProviders) {
                ArrayList<Map<String, Object>> extMapper = JSONUtils.parseJSonStr_Class(p.getExt1(), List.class);
                if (extMapper == null) {
                    extMapper = new ArrayList<Map<String, Object>>();
                }
                if (extMapper.isEmpty()) {
                    extMapper.add(currentMethodMapping);
                } else {
                    HashMap<String, Object> existsMapping = new HashMap<String, Object>();
                    for (Object e : extMapper) {
                        String methodName = ParamUtil.getString((Map)((Map)e), (String)"methodName", (String)"");
                        existsMapping.put(methodName, e);
                    }
                    existsMapping.put(entity.getMethodName(), currentMethodMapping);
                    extMapper.clear();
                    extMapper.addAll(existsMapping.values());
                }
                p.setExt1(JSONUtils.getJSonString(extMapper));
                p.setExt4(GenerateUtils.generateThirdBusinessId((long)UUIDLong.longUUID()));
            }
            this.magicProviderDao.updateProviders(allServiceProviders);
        } else {
            ArrayList<Map<String, Object>> extMapper = new ArrayList<Map<String, Object>>();
            extMapper.add(currentMethodMapping);
            MagicServiceProviderPO po = new MagicServiceProviderPO();
            po.setIdIfNew();
            po.setDisplayName(targetFormBean.getFormName());
            po.setBusinessId(bId);
            po.setSourceType(targetFormBean.getType().getType());
            po.setSource(String.valueOf(targetFormBean.getId()));
            po.setStatus(MagicEnums.ProviderStatus.ON.getType());
            po.setExt1(JSONUtils.getJSonString(extMapper));
            po.setVersionId(version);
            po.setCreater(Long.valueOf(AppContext.currentUserId()));
            po.setCreateDate(DateUtil.currentDate());
            po.setExt4(GenerateUtils.generateThirdBusinessId((long)UUIDLong.longUUID()));
            this.magicProviderDao.saveProvider(po);
        }
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public MagicBindInternalServiceManager getMagicBindInternalServiceManager() {
        return this.magicBindInternalServiceManager;
    }

    public void setMagicBindInternalServiceManager(MagicBindInternalServiceManager magicBindInternalServiceManager) {
        this.magicBindInternalServiceManager = magicBindInternalServiceManager;
    }

    public IMagicCompilerManager getMagicCompilerManager() {
        return this.magicCompilerManager;
    }

    public void setMagicCompilerManager(IMagicCompilerManager magicCompilerManager) {
        this.magicCompilerManager = magicCompilerManager;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }
}

