/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.incision;

import com.seeyon.cap4.magic.business.incision.IincisionSourceManager;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicIncisionSource;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.form.util.TreeNodeUtil;
import com.seeyon.ctp.form.vo.FormTreeNode;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.datamagic.engine.out.service.entry.ServiceQueryCondition;
import com.seeyon.datamagic.engine.out.service.entry.ServiceSummary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LoadCap3FormManagerImpl
implements IincisionSourceManager {
    private FormCacheManager formCacheManager;
    private TemplateManager templateManager;
    private OrgManager orgManager;

    @Override
    public MagicIncisionSource getSourceInfo() {
        MagicIncisionSource source = new MagicIncisionSource();
        source.setDisplayName(ResourceUtil.getString((String)"cap4.form.business.businessset") + "/" + ResourceUtil.getString((String)"form.bizconfig.link.label.form"));
        source.setSourceType(MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType());
        source.setSort(2);
        boolean formBiz = AppContext.hasPlugin((String)"formBiz");
        boolean form = AppContext.hasPlugin((String)"form");
        source.setEnabled(formBiz || form);
        return source;
    }

    @Override
    public List<ServiceSummary> loadSources(int type, ServiceQueryCondition condtion) throws BusinessException {
        List formList = this.formCacheManager.getFormList();
        LinkedList<FormBean> managerInfos = new LinkedList<FormBean>();
        Map otherAttr = condtion.getOtherAttr();
        String allBiz = ParamUtil.getString((Map)otherAttr, (String)"allBiz", (String)"");
        boolean formBiz = AppContext.hasPlugin((String)"formBiz");
        boolean form = AppContext.hasPlugin((String)"form");
        if (!formBiz && !form) {
            return Collections.emptyList();
        }
        String name = condtion.getCondition();
        for (FormBean fbean : formList) {
            if (!this.formCacheManager.isEnabled(fbean) || !"1".equals(allBiz) && fbean.getOwnerId() != AppContext.currentUserId() || Strings.isNotBlank((String)name) && !fbean.getFormName().contains(name)) continue;
            int formType = fbean.getFormType();
            if ((formType == Enums.FormType.processesForm.getKey() || "1".equals(allBiz)) && form) {
                managerInfos.add(fbean);
                continue;
            }
            if ((formType == Enums.FormType.manageInfo.getKey() || "1".equals(allBiz)) && formBiz) {
                managerInfos.add(fbean);
                continue;
            }
            if (formType != Enums.FormType.baseInfo.getKey() && !"1".equals(allBiz) || !formBiz) continue;
            managerInfos.add(fbean);
        }
        ArrayList<FormTreeNode> nodes = new ArrayList<FormTreeNode>();
        FormTreeNode rootNode = new FormTreeNode();
        rootNode.setId(Enums.FormType.manageInfo.getKey() + "");
        rootNode.setName(ResourceUtil.getString((String)"form.bindseeyon.label"));
        nodes.add(rootNode);
        HashMap<String, CtpTemplateCategory> catgMap = new HashMap<String, CtpTemplateCategory>();
        for (FormBean formBean : managerInfos) {
            CtpTemplateCategory currentTemplate = this.templateManager.getCtpTemplateCategory(Long.valueOf(formBean.getCategoryId()));
            if (currentTemplate == null) continue;
            catgMap.put(currentTemplate.getName(), currentTemplate);
            FormTreeNode node = new FormTreeNode();
            node.setName(formBean.getFormName());
            node.setId(currentTemplate.getId().toString());
            node.setParentId(currentTemplate.getName());
            node.setFormId(String.valueOf(formBean.getId()));
            nodes.add(node);
        }
        TreeNodeUtil.getTreeNode4Catg(catgMap, (FormTreeNode)rootNode, nodes, (String)"", catgMap);
        HashMap<String, List<FormTreeNode>> nodeMapper = new HashMap<String, List<FormTreeNode>>();
        for (FormTreeNode node : nodes) {
            if (node.getId().equals(rootNode.getId())) continue;
            LinkedList<FormTreeNode> childen = (LinkedList<FormTreeNode>)nodeMapper.get(node.getParentId());
            if (childen == null) {
                childen = new LinkedList<FormTreeNode>();
                nodeMapper.put(node.getParentId(), childen);
            }
            childen.add(node);
        }
        nodes.clear();
        this.sortFormNodes(nodes, rootNode, nodeMapper);
        LinkedList<ServiceSummary> linkedList = new LinkedList<ServiceSummary>();
        ServiceSummary summary = new ServiceSummary();
        if (!nodes.isEmpty()) {
            summary.setName(rootNode.getName());
            summary.setParentId(rootNode.getParentId());
            summary.setId(rootNode.getId());
            summary.setIconSkin("treeCustomMenu");
            summary.setCategory(rootNode.getFormId() == null);
            linkedList.add(summary);
            for (FormTreeNode ftn : nodes) {
                summary = new ServiceSummary();
                summary.setName(ftn.getName());
                summary.setParentId(ftn.getParentId());
                summary.setCategory(ftn.getFormId() == null);
                if (summary.isCategory()) {
                    summary.setId(ftn.getId());
                } else {
                    summary.setId(ftn.getFormId());
                    summary.getOtherAttr().put("formType", this.formCacheManager.getForm(Long.valueOf(ftn.getFormId()).longValue()).getFormType());
                }
                linkedList.add(summary);
            }
        }
        return linkedList;
    }

    public void sortFormNodes(List<FormTreeNode> sortedNodes, FormTreeNode root, Map<String, List<FormTreeNode>> nodes) {
        List<FormTreeNode> childen = nodes.remove(root.getId());
        if (childen != null && !childen.isEmpty()) {
            for (FormTreeNode child : childen) {
                sortedNodes.add(child);
                this.sortFormNodes(sortedNodes, child, nodes);
            }
        }
    }

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }
}

