/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.incision;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.magic.business.incision.IincisionSourceManager;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicIncisionSource;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.datamagic.engine.out.service.entry.ServiceQueryCondition;
import com.seeyon.datamagic.engine.out.service.entry.ServiceSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LoadCap4FormManagerImpl
implements IincisionSourceManager {
    private BusinessManager businessManager4;
    private CAP4FormCacheManager cap4FormCacheManager;

    @Override
    public MagicIncisionSource getSourceInfo() {
        MagicIncisionSource source = new MagicIncisionSource();
        source.setDisplayName(ResourceUtil.getString((String)"system.menuname.BusinessOrderPlatform"));
        source.setSourceType(MagicEnums.ProviderType.DEFAULT_FORM.getType());
        source.setSort(1);
        source.setEnabled(true);
        return source;
    }

    private void addCurrentBiz(List<ServiceSummary> result, String rootId, Map<String, Object> otherAttr, String conditionName) throws BusinessException {
        String currentBizId = ParamUtil.getString(otherAttr, (String)"currentBizId", (String)"");
        int publishFlag = ParamUtil.getInt(otherAttr, (String)"publishFlag", (int)-1);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("businessType", "0");
        if (publishFlag == BizEnums.BizPublishState.published.getKey()) {
            parameterMap.put("publishFlag", BizEnums.BizPublishState.published.getKey());
        } else if (publishFlag == BizEnums.BizPublishState.initState.getKey()) {
            parameterMap.put("publishFlag", BizEnums.BizPublishState.initState.getKey());
        }
        FlipInfo fi = new FlipInfo();
        fi.setSize(Integer.MAX_VALUE);
        FlipInfo business = (FlipInfo)this.businessManager4.listBusiness(fi, parameterMap).get("validBusiness");
        List data = business.getData();
        for (Map temp : data) {
            ServiceSummary resultItem = new ServiceSummary();
            String id = String.valueOf(temp.get("id"));
            Integer useFlag = ParamUtil.getInt((Map)temp, (String)"useFlag", (int)1);
            if (StringUtils.isBlank((CharSequence)id) || id.equals(currentBizId) || useFlag == 0) continue;
            String name = String.valueOf(temp.get("name"));
            resultItem.setId(id);
            resultItem.setName(name);
            resultItem.setParentId(rootId);
            resultItem.setCategory(true);
            long idl = Long.parseLong(id);
            ArrayList<ServiceSummary> sub = new ArrayList<ServiceSummary>();
            List<CAPFormDefinition> formList = this.businessManager4.getCAP4FormByBizId(idl);
            for (CAPFormDefinition cfd : formList) {
                if (cfd.getState() == null || Enums.FormStateEnum.official.getKey() != cfd.getState().intValue() || Strings.isNotBlank((String)conditionName) && cfd.getName().indexOf(conditionName) == -1) continue;
                ServiceSummary capFormSummart = new ServiceSummary();
                capFormSummart.setId(String.valueOf(cfd.getId()));
                capFormSummart.setName(cfd.getName());
                capFormSummart.setParentId(id);
                sub.add(capFormSummart);
            }
            if (sub.isEmpty()) continue;
            result.add(resultItem);
            result.addAll(sub);
        }
    }

    private void addAllBiz(List<ServiceSummary> result, String rootId, String conditionName) throws BusinessException {
        for (BizConfigBean temp : this.businessManager4.getAllBizConfigInCache()) {
            ServiceSummary resultItem = new ServiceSummary();
            if (temp.getUseFlag() == null || temp.getUseFlag() == 0) continue;
            resultItem.setId(String.valueOf(temp.getId()));
            resultItem.setName(temp.getName());
            resultItem.setParentId(rootId);
            resultItem.setCategory(true);
            ArrayList<ServiceSummary> sub = new ArrayList<ServiceSummary>();
            List<CAPFormDefinition> formList = this.businessManager4.getCAP4FormByBizId(temp.getId());
            for (CAPFormDefinition cfd : formList) {
                if (cfd.getState() == null || Enums.FormStateEnum.official.getKey() != cfd.getState().intValue() || Strings.isNotBlank((String)conditionName) && cfd.getName().indexOf(conditionName) == -1) continue;
                ServiceSummary capFormSummart = new ServiceSummary();
                capFormSummart.setId(String.valueOf(cfd.getId()));
                capFormSummart.setName(cfd.getName());
                capFormSummart.setParentId(resultItem.getId());
                sub.add(capFormSummart);
            }
            if (sub.isEmpty()) continue;
            result.add(resultItem);
            result.addAll(sub);
        }
    }

    @Override
    public List<ServiceSummary> loadSources(int type, ServiceQueryCondition condtion) throws BusinessException {
        Map otherAttr = condtion.getOtherAttr();
        String currentBizId = ParamUtil.getString((Map)otherAttr, (String)"currentBizId", (String)"");
        int publishFlag = ParamUtil.getInt((Map)otherAttr, (String)"publishFlag", (int)-1);
        String filterInfo = ParamUtil.getString((Map)otherAttr, (String)"filterInfo", (String)"");
        String allBiz = ParamUtil.getString((Map)otherAttr, (String)"allBiz", (String)"");
        LinkedList<ServiceSummary> result = new LinkedList<ServiceSummary>();
        String conditionName = condtion.getCondition();
        if (Strings.isBlank((String)filterInfo) || filterInfo.contains("cap4Biz")) {
            ServiceSummary root = new ServiceSummary();
            root.setId("root");
            root.setName(ResourceUtil.getString((String)"system.menuname.BusinessApplication"));
            root.setIconSkin("treeCustomMenu");
            result.add(root);
            if ("1".equals(allBiz)) {
                this.addAllBiz(result, root.getId(), conditionName);
            } else {
                this.addCurrentBiz(result, root.getId(), otherAttr, conditionName);
            }
        }
        if (Strings.isNotBlank((String)filterInfo) && filterInfo.contains("cap4_formManager")) {
            HashMap<String, Object> tempParams = new HashMap<String, Object>();
            if (!"1".equals(allBiz)) {
                tempParams.put("ownerId", AppContext.currentUserId());
                tempParams.put("orgAccountId", AppContext.currentAccountId());
            }
            if (Strings.isNotBlank((String)conditionName)) {
                tempParams.put("name", conditionName);
            }
            List<Map<String, Object>> listMap = this.cap4FormCacheManager.getCap4FormDefinitionDAO().showFormList(null, tempParams);
            ArrayList<FormBean> formBeanList = new ArrayList<FormBean>();
            if (!listMap.isEmpty()) {
                for (Map<String, Object> map : listMap) {
                    Long formId = ParamUtil.getLong(map, (String)"id", (Long)0L);
                    FormBean f = this.cap4FormCacheManager.getForm(formId);
                    if (f == null) {
                        this.cap4FormCacheManager.initForm(formId);
                        f = this.cap4FormCacheManager.getForm(formId);
                        if (f == null) continue;
                    }
                    if (!f.isEnabled() || publishFlag != -1 && publishFlag != f.getPublishFlag()) continue;
                    formBeanList.add(f);
                }
            }
            if (!formBeanList.isEmpty()) {
                ServiceSummary capFormSummart = new ServiceSummary();
                capFormSummart.setId("123456789");
                capFormSummart.setName(ResourceUtil.getString((String)"cap4.form.business.formmanagement"));
                capFormSummart.setIconSkin("treeCustomMenu");
                capFormSummart.setCategory(true);
                result.add(capFormSummart);
                for (FormBean f : formBeanList) {
                    capFormSummart = new ServiceSummary();
                    capFormSummart.setId(String.valueOf(f.getId()));
                    capFormSummart.setName(f.getFormName());
                    capFormSummart.setParentId("123456789");
                    result.add(capFormSummart);
                }
            }
        }
        return result;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }
}

