/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.update;

import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.DataRightEntity;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.cap4.magic.vo.RightAnnotationEntity;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.base.MagicDisplay;
import com.seeyon.datamagic.engine.domain.config.ArgsConfigGuide;
import com.seeyon.datamagic.engine.domain.config.ConfigAnnotation;
import com.seeyon.datamagic.engine.domain.config.EntryAnnotation;
import com.seeyon.datamagic.engine.domain.config.EntryConfigItem;
import com.seeyon.datamagic.engine.domain.config.ResultConfigGuide;
import com.seeyon.datamagic.engine.domain.metadata.MetadataConfig;
import com.seeyon.datamagic.engine.domain.metadata.ObjAttributeDef;
import com.seeyon.datamagic.engine.domain.service.ReturnConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceArgumentConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MagicUpdateServiceUtils {
    private MagicUpdateServiceUtils() {
    }

    public static void updateEntity(MagicInterfaceDefineEntity entity, int updateSort, Map<String, MetadataConfig> newMetadataConfigs) {
        String metataConfigStr = entity.getMetadataConfig();
        if (Strings.isNotBlank((String)metataConfigStr)) {
            newMetadataConfigs.putAll(MagicUpdateServiceUtils.updateMetadata(metataConfigStr));
        }
        entity.setExt3(String.valueOf(updateSort));
        if (Strings.isNotBlank((String)entity.getResultConfig())) {
            entity.setResultConfig(JSONUtils.getJSonString(MagicUpdateServiceUtils.updateResultConfig(entity.getResultConfig())));
        }
        if (Strings.isNotBlank((String)entity.getArgsConfig())) {
            entity.setArgsConfig(JSONUtils.getJSonString(MagicUpdateServiceUtils.updateArguments(entity.getArgsConfig())));
        }
        MagicUpdateServiceUtils.updateGuide(entity);
    }

    public static ReturnConfig updateResultConfig(String resultConfig) {
        ReturnConfig rc = new ReturnConfig();
        Map oldR = JSONUtils.parseJSonStr_Class(resultConfig, Map.class);
        String limitConfig = ParamUtil.getString((Map)oldR, (String)"limitconfig");
        if (oldR.containsKey("limitConfig")) {
            limitConfig = ParamUtil.getString((Map)oldR, (String)"limitConfig");
        }
        String type = ParamUtil.getString((Map)oldR, (String)"type");
        rc.setLimitConfig(limitConfig);
        rc.setType(type);
        return rc;
    }

    public static Map<String, MetadataConfig> updateMetadata(String oldMetadata) {
        ArrayList old = new ArrayList();
        JSONUtils.parseJSonListObj_Class(oldMetadata, old, Map.class);
        HashMap<String, MetadataConfig> result = new HashMap<String, MetadataConfig>();
        for (Map m : old) {
            String name;
            String objName = ParamUtil.getString((Map)m, (String)"objname");
            if (m.containsKey("objName")) {
                objName = ParamUtil.getString((Map)m, (String)"objName");
            }
            MetadataConfig mc = new MetadataConfig();
            mc.setObjName(objName);
            Object attributes = m.get("attributes");
            if (attributes != null) {
                mc.setAttributes(MagicUpdateServiceUtils.updateMetadataAttrs((List)attributes));
            }
            Object displayName = m.get("displayname");
            if (m.containsKey("displayName")) {
                displayName = m.get("displayName");
            }
            if (displayName != null && Strings.isNotBlank((String)(name = MagicUpdateServiceUtils.getOldText(displayName)))) {
                mc.addName(new MagicDisplay(name));
            }
            result.put(objName, mc);
        }
        return result;
    }

    public static void updateGuide(MagicInterfaceDefineEntity entity) {
        ArgsConfigGuide a;
        DataRightEntity rightEntity;
        List fillback;
        Map extMapper;
        if (MagicEnums.BusinessMethodType.QUERY.getType() == entity.getServiceType() || MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK.getType() == entity.getServiceType()) {
            return;
        }
        ArrayList argsList = new ArrayList();
        JSONUtils.parseJSonListObj_Class(entity.getArgsConfig(), argsList, ServiceArgumentConfig.class);
        HashMap ext1Mapper = new HashMap();
        if (Strings.isNotBlank((String)entity.getExt1()) && (extMapper = (Map)JSONUtil.parseJSONString((String)entity.getExt1(), Map.class)) != null) {
            ext1Mapper.putAll(extMapper);
        }
        Map fieldLimit = (Map)ext1Mapper.get("fieldLimit");
        ArrayList<ArgsConfigGuide> guideList = new ArrayList<ArgsConfigGuide>();
        for (ServiceArgumentConfig e : argsList) {
            Enums.FieldType ft;
            Map limit;
            String limitStr;
            Iterator iterator;
            EntryAnnotation entry;
            ArgsConfigGuide formData;
            Object fillback2;
            ArgsConfigGuide a2;
            DataRightEntity rightEntity2;
            EntryConfigItem item;
            Map t2;
            String name = e.getArgsName();
            if ("template".equals(name)) {
                List templet = (List)ext1Mapper.get("templates");
                ArgsConfigGuide tempalteGuide = new ArgsConfigGuide();
                EntryAnnotation tempalteGuideItem = new EntryAnnotation();
                for (Map t2 : templet) {
                    item = new EntryConfigItem();
                    item.setName(ParamUtil.getString((Map)t2, (String)"id"));
                    HashMap<String, String> otherConfig = new HashMap<String, String>();
                    otherConfig.putAll(t2);
                    otherConfig.put("name", ParamUtil.getString((Map)t2, (String)"id"));
                    otherConfig.put("displayName ", ParamUtil.getString(t2, (String)"name"));
                    item.setOtherConfig(otherConfig);
                    tempalteGuideItem.addItem(item);
                }
                tempalteGuide.setArgsName(name);
                tempalteGuide.setGuide((ConfigAnnotation)tempalteGuideItem);
                guideList.add(tempalteGuide);
            }
            if ("dataRight".equals(name) && (rightEntity2 = JSONUtils.parseJSonStr_Class(ParamUtil.getString(ext1Mapper, (String)"dataRight"), DataRightEntity.class)) != null && (a2 = MagicUpdateServiceUtils.updateDataRight(rightEntity2, entity)) != null) {
                guideList.add(a2);
            }
            if ("formData".equals(name)) {
                fillback2 = (List)ext1Mapper.get("fillback");
                formData = new ArgsConfigGuide();
                formData.setArgsName("formData");
                entry = new EntryAnnotation();
                iterator = fillback2.iterator();
                while (iterator.hasNext()) {
                    t2 = iterator.next();
                    item = new EntryConfigItem();
                    if (!fieldLimit.containsKey(t2)) continue;
                    limitStr = fieldLimit.get(t2.toString()).toString();
                    limit = JSONUtils.parseJSonStr_Class(limitStr, Map.class);
                    limit.put("id", t2);
                    limit.put("name", t2);
                    ft = Enums.FieldType.getEnumByKey((String)ParamUtil.getString((Map)limit, (String)"fieldType", (String)""));
                    if (ft != null) {
                        limit.put("fieldTypeText", ft.getText());
                    }
                    item.setName(t2.toString());
                    item.setOtherConfig(limit);
                    entry.addItem(item);
                }
                formData.setGuide((ConfigAnnotation)entry);
                guideList.add(formData);
            }
            if (!"condition".equals(name) || (fillback2 = (List)ext1Mapper.get("condition")) == null || fillback2.isEmpty()) continue;
            formData = new ArgsConfigGuide();
            formData.setArgsName("condition");
            entry = new EntryAnnotation();
            iterator = fillback2.iterator();
            while (iterator.hasNext()) {
                t2 = iterator.next();
                item = new EntryConfigItem();
                if (!fieldLimit.containsKey(t2)) continue;
                limitStr = fieldLimit.get(t2.toString()).toString();
                limit = JSONUtils.parseJSonStr_Class(limitStr, Map.class);
                limit.put("id", t2);
                limit.put("name", t2);
                ft = Enums.FieldType.getEnumByKey((String)ParamUtil.getString((Map)limit, (String)"fieldType", (String)""));
                if (ft != null) {
                    limit.put("fieldTypeText", ft.getText());
                }
                item.setName(t2.toString());
                item.setOtherConfig(limit);
                entry.addItem(item);
            }
            formData.setGuide((ConfigAnnotation)entry);
            guideList.add(formData);
        }
        if (MagicEnums.BusinessMethodType.TRIGGER_UPDATE.getType() == entity.getServiceType() && (fillback = (List)ext1Mapper.get("condition")) != null && !fillback.isEmpty()) {
            ArgsConfigGuide formData = new ArgsConfigGuide();
            formData.setArgsName("condition");
            EntryAnnotation entry = new EntryAnnotation();
            for (Object t : fillback) {
                EntryConfigItem item = new EntryConfigItem();
                if (!fieldLimit.containsKey(t)) continue;
                String limitStr = fieldLimit.get(t.toString()).toString();
                Map limit = JSONUtils.parseJSonStr_Class(limitStr, Map.class);
                limit.put("id", t);
                limit.put("name", t);
                Enums.FieldType ft = Enums.FieldType.getEnumByKey((String)ParamUtil.getString((Map)limit, (String)"fieldType", (String)""));
                if (ft != null) {
                    limit.put("fieldTypeText", ft.getText());
                }
                item.setName(t.toString());
                item.setOtherConfig(limit);
                entry.addItem(item);
            }
            formData.setGuide((ConfigAnnotation)entry);
            guideList.add(formData);
        }
        if (MagicEnums.BusinessMethodType.RELATION_USER.getType() == entity.getServiceType() && (rightEntity = JSONUtils.parseJSonStr_Class(ParamUtil.getString(ext1Mapper, (String)"dataRight"), DataRightEntity.class)) != null && (a = MagicUpdateServiceUtils.updateDataRight(rightEntity, entity)) != null) {
            guideList.add(a);
        }
        if (!guideList.isEmpty()) {
            entity.setArgsConfigGuide(JSONUtils.getJSonString(guideList));
        }
        if (ext1Mapper.containsKey("resultKey")) {
            fillback = (List)ext1Mapper.get("resultKey");
            ResultConfigGuide resultConfigGuide = new ResultConfigGuide();
            for (Object t : fillback) {
                EntryConfigItem item = new EntryConfigItem();
                if (!fieldLimit.containsKey(t)) continue;
                String limitStr = fieldLimit.get(t.toString()).toString();
                Map limit = JSONUtils.parseJSonStr_Class(limitStr, Map.class);
                limit.put("id", t);
                limit.put("name", t);
                Enums.FieldType ft = Enums.FieldType.getEnumByKey((String)ParamUtil.getString((Map)limit, (String)"fieldType", (String)""));
                if (ft != null) {
                    limit.put("fieldTypeText", ft.getText());
                }
                item.setName(t.toString());
                item.setOtherConfig(limit);
                resultConfigGuide.addItem(item);
            }
            entity.setResultConfigGuide(JSONUtils.getJSonString(resultConfigGuide));
        }
    }

    public static List<Map<String, Object>> filterDataRight(DataRightEntity e, List<String> filterType) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<RightAnnotationEntity> rights = e.getPcRights();
        rights.addAll(e.getPhoneRights());
        for (RightAnnotationEntity s : rights) {
            if (!filterType.contains(s.getType())) continue;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", s.getViewId() + "." + s.getRightId());
            data.put("name", s.getViewId() + "." + s.getRightId());
            data.put("displayName", s.getRightName() + s.getViewName());
            result.add(data);
        }
        return result;
    }

    public static ArgsConfigGuide updateDataRight(DataRightEntity entity, MagicInterfaceDefineEntity service) {
        MagicEnums.BusinessMethodType bt = MagicEnums.BusinessMethodType.valueOfType((int)service.getServiceType());
        ArrayList<String> viewOpertaionType = new ArrayList<String>();
        List<Map<String, Object>> data = null;
        if (bt != null) {
            switch (bt) {
                case RELATION_USER: 
                case RELATION: 
                case RELATION_SYS: {
                    viewOpertaionType.add(Enums.FormAuthorizationType.show.getKey());
                    data = MagicUpdateServiceUtils.filterDataRight(entity, viewOpertaionType);
                    break;
                }
                case TRIGGER_CREATE: {
                    viewOpertaionType.add(Enums.FormAuthorizationType.add.getKey());
                    data = MagicUpdateServiceUtils.filterDataRight(entity, viewOpertaionType);
                    break;
                }
                case TRIGGER_UPDATE: {
                    viewOpertaionType.add(Enums.FormAuthorizationType.update.getKey());
                    data = MagicUpdateServiceUtils.filterDataRight(entity, viewOpertaionType);
                    break;
                }
                case TRIGGER_DISTRIBUTE: {
                    viewOpertaionType.add(Enums.FormAuthorizationType.add.getKey());
                    viewOpertaionType.add(Enums.FormAuthorizationType.update.getKey());
                    data = MagicUpdateServiceUtils.filterDataRight(entity, viewOpertaionType);
                }
            }
            if (data != null && !data.isEmpty()) {
                ArgsConfigGuide result = new ArgsConfigGuide();
                EntryAnnotation e = new EntryAnnotation();
                for (Map<String, Object> t : data) {
                    EntryConfigItem item = new EntryConfigItem();
                    item.setName(ParamUtil.getString(t, (String)"id"));
                    item.setOtherConfig(t);
                    e.addItem(item);
                }
                result.setArgsName("dataRight");
                result.setGuide((ConfigAnnotation)e);
                return result;
            }
            return null;
        }
        return null;
    }

    public static List<ServiceArgumentConfig> updateArguments(String args) {
        ArrayList<ServiceArgumentConfig> result = new ArrayList<ServiceArgumentConfig>();
        ArrayList oldArgs = new ArrayList();
        JSONUtils.parseJSonListObj_Class(args, oldArgs, Map.class);
        for (Map m : oldArgs) {
            String name;
            String argsName = ParamUtil.getString((Map)m, (String)"argsname");
            if (m.containsKey("argsName")) {
                argsName = ParamUtil.getString((Map)m, (String)"argsName");
            }
            String limitConfig = ParamUtil.getString((Map)m, (String)"limitconfig");
            if (m.containsKey("limitConfig")) {
                limitConfig = ParamUtil.getString((Map)m, (String)"limitConfig");
            }
            String type = ParamUtil.getString((Map)m, (String)"type");
            ServiceArgumentConfig serviceArgumentConfig = new ServiceArgumentConfig();
            serviceArgumentConfig.setType(type);
            serviceArgumentConfig.setLimitConfig(limitConfig);
            serviceArgumentConfig.setArgsName(argsName);
            Object displayName = m.get("displayname");
            if (m.containsKey("displayName")) {
                displayName = m.get("displayName");
            }
            if (Strings.isNotBlank((String)(name = MagicUpdateServiceUtils.getOldText(displayName)))) {
                serviceArgumentConfig.addName(new MagicDisplay(name));
            }
            result.add(serviceArgumentConfig);
        }
        return result;
    }

    public static String getOldText(Object old) {
        if (old == null) {
            return "";
        }
        try {
            Map oldJSON = JSONUtils.parseJSonStr_Class(old.toString(), Map.class);
            if (oldJSON == null) {
                return "";
            }
            if (oldJSON.containsKey("i18n")) {
                return ParamUtil.getString((Map)((Map)oldJSON.get("i18n")), (String)"ch");
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static Map<String, Object> updateProviderMappingSet(MagicInterfaceDefineEntity e, MagicFormBean mfb, Map oldSet) {
        Map argsMapping;
        ServiceMethodConfig msc = MagicPrivateUtils.convertToMethod(e);
        if (mfb.isNull()) {
            return Collections.emptyMap();
        }
        Map<String, Object> result = MagicCreateServiceUtils.setDefaultImplMapping(msc, mfb);
        Map otherMapping = (Map)result.get("otherSet");
        if (otherMapping != null) {
            otherMapping.put("tableName", oldSet.get("tableName"));
        }
        if ((argsMapping = (Map)result.get("argsMapping")) != null) {
            if (oldSet.containsKey("dataRight")) {
                argsMapping.put("dataRight", oldSet.get("dataRight"));
            }
            if (oldSet.containsKey("template")) {
                argsMapping.put("template", oldSet.get("template"));
            }
            result.put("argsMapping", argsMapping);
        }
        return result;
    }

    public static List<ObjAttributeDef> updateMetadataAttrs(List<Map> attrs) {
        ArrayList<ObjAttributeDef> result = new ArrayList<ObjAttributeDef>(attrs.size());
        for (Map m : attrs) {
            String text;
            String name = ParamUtil.getString((Map)m, (String)"name");
            String type = ParamUtil.getString((Map)m, (String)"type");
            String limitConfig = ParamUtil.getString((Map)m, (String)"limitconfig");
            if (m.containsKey("limitConfig")) {
                limitConfig = ParamUtil.getString((Map)m, (String)"limitConfig");
            }
            ObjAttributeDef oad = new ObjAttributeDef();
            oad.setName(name);
            oad.setType(type);
            if (Strings.isNotBlank((String)limitConfig)) {
                oad.setLimitConfig(limitConfig);
            }
            Object subAtts = m.get("subAtts");
            if (m.containsKey("subAtts")) {
                subAtts = m.get("subAtts");
            }
            if (subAtts != null) {
                oad.setSubAtts(MagicUpdateServiceUtils.updateMetadataAttrs((List)subAtts));
            }
            Object displayName = m.get("displayname");
            if (m.containsKey("displayName")) {
                displayName = m.get("displayName");
            }
            if (displayName != null && Strings.isNotBlank((String)(text = MagicUpdateServiceUtils.getOldText(displayName)))) {
                oad.addName(new MagicDisplay(text));
            }
            result.add(oad);
        }
        return result;
    }
}

