/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.update;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.magic.business.update.IMagicServiceUpdate;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MagicUpdateV70SP3Service
implements IMagicServiceUpdate {
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private IMagicProviderDao magicProviderDao;
    private CAP4FormCacheManager cap4FormCacheManager;

    @Override
    public int updateSort() {
        return 70300;
    }

    @Override
    public List<MagicInterfaceDefineEntity> update(List<MagicInterfaceDefineEntity> allEntitys, int previousVersion) throws BusinessException {
        LinkedList<MagicInterfaceDefineEntity> needUpdateServices = new LinkedList<MagicInterfaceDefineEntity>();
        List<MagicServiceProviderPO> allOnProviders = this.magicProviderDao.loadAllProviders(MagicEnums.ProviderStatus.ON);
        HashMap<String, MagicServiceProviderPO> providerMaps = new HashMap<String, MagicServiceProviderPO>();
        for (MagicServiceProviderPO p : allOnProviders) {
            providerMaps.put(p.getBusinessId() + "_" + p.getVersionId() + "_" + p.getMethodName(), p);
        }
        ArrayList<MagicServiceProviderPO> saveList = new ArrayList<MagicServiceProviderPO>();
        for (MagicInterfaceDefineEntity entity : allEntitys) {
            FormBean fb;
            MagicServiceProviderPO exists = (MagicServiceProviderPO)providerMaps.get(entity.getBusinessId() + "_" + entity.getVersionId() + "_" + entity.getMethodName());
            if (entity.getSubType() == null) {
                needUpdateServices.add(entity);
            }
            if (exists != null || (fb = this.cap4FormCacheManager.getForm(entity.getFormId())) == null) continue;
            MagicServiceProviderPO provider = new MagicServiceProviderPO();
            CAP4FormManager cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");
            HashMap<String, Map<Object, Object>> ext1 = new HashMap<String, Map<Object, Object>>();
            if (fb.isFlowForm()) {
                List<CtpTemplate> templateList = cap4FormManager.getFormSystemTemplate(fb.getId());
                HashMap<String, String> temp = new HashMap<String, String>();
                for (CtpTemplate template : templateList) {
                    String key = String.valueOf(template.getId());
                    temp.put(key, key);
                }
                ext1.put("templates", temp);
            }
            List pcViewList = fb.getFormViewList();
            HashMap<String, String> right = new HashMap<String, String>();
            for (FormViewBean fvb : pcViewList) {
                String viewId = String.valueOf(fvb.getId());
                for (FormAuthViewBean t : fvb.getAllOperations()) {
                    String rightId = String.valueOf(t.getId());
                    right.put(viewId + "." + rightId, viewId + "." + rightId);
                }
            }
            ext1.put("dataRight", right);
            ext1.put("tableName", MagicPrivateUtils.getFormTableDefaultMapping(fb));
            provider.setBusinessId(entity.getBusinessId());
            provider.setVersionId(entity.getVersionId());
            provider.setCreateDate(new Date());
            provider.setCreater(Long.valueOf(AppContext.currentUserId()));
            provider.setIdIfNew();
            provider.setMethodName(entity.getMethodName());
            provider.setStatus(MagicEnums.ProviderStatus.ON.getType());
            provider.setSource(String.valueOf(entity.getFormId()));
            provider.setSourceType(MagicEnums.ProviderType.DEFAULT_FORM.getType());
            provider.setExt1(JSONUtil.toJSONString(ext1));
            saveList.add(provider);
        }
        if (!saveList.isEmpty()) {
            this.magicProviderDao.saveProviders(saveList);
        }
        return needUpdateServices;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }
}

