/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.business.update;

import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.business.update.IMagicServiceUpdate;
import com.seeyon.cap4.magic.business.update.MagicUpdateServiceUtils;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.datamagic.engine.domain.metadata.MetadataConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class MagicUpdateV71Service
implements IMagicServiceUpdate {
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private IMagicProviderDao magicProviderDao;
    private static final Log LOGGER = CtpLogFactory.getLog(MagicUpdateV71Service.class);

    @Override
    public int updateSort() {
        return 71000;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={BusinessException.class})
    public List<MagicInterfaceDefineEntity> update(List<MagicInterfaceDefineEntity> allEntitys, int previousVersion) throws BusinessException {
        String key;
        LinkedList<MagicInterfaceDefineEntity> needUpdate = new LinkedList<MagicInterfaceDefineEntity>();
        List<MagicServiceSummary> allMagicService = this.magicServiceSummaryDao.loadAllServices();
        HashMap<String, MagicServiceSummary> servicSummary = new HashMap<String, MagicServiceSummary>();
        for (MagicServiceSummary mbf : allMagicService) {
            servicSummary.put(mbf.getBusinessId() + "_" + mbf.getBusinessVersion(), mbf);
        }
        HashMap<String, MagicServiceSummary> needSaveBaseInfo = new HashMap<String, MagicServiceSummary>();
        HashMap<String, LinkedList<MagicInterfaceDefineEntity>> groupByBusinessAndVersion = new HashMap<String, LinkedList<MagicInterfaceDefineEntity>>();
        for (MagicInterfaceDefineEntity magicInterfaceDefineEntity : allEntitys) {
            key = magicInterfaceDefineEntity.getBusinessId() + "_" + magicInterfaceDefineEntity.getVersionId();
            LinkedList<MagicInterfaceDefineEntity> group = (LinkedList<MagicInterfaceDefineEntity>)groupByBusinessAndVersion.get(key);
            if (group == null) {
                group = new LinkedList<MagicInterfaceDefineEntity>();
                groupByBusinessAndVersion.put(key, group);
            }
            group.add(magicInterfaceDefineEntity);
        }
        for (Map.Entry entry : groupByBusinessAndVersion.entrySet()) {
            key = (String)entry.getKey();
            String name = null;
            String[] keyArray = key.split("_");
            HashMap<String, MetadataConfig> newMetadataConfigs = new HashMap<String, MetadataConfig>();
            String owner = "";
            String ownerType = "";
            String businessType = "";
            Long creater = 0L;
            for (MagicInterfaceDefineEntity entity : (List)entry.getValue()) {
                if (Strings.isBlank((String)entity.getExt3()) || this.updateSort() > Integer.valueOf(entity.getExt3())) {
                    MagicUpdateServiceUtils.updateEntity(entity, this.updateSort(), newMetadataConfigs);
                    needUpdate.add(entity);
                }
                if (Strings.isBlank(name)) {
                    String suffix = entity.getBusinessId().substring(4, 9);
                    if (MagicEnums.ProviderType.DEFAULT_DEE.getType().equals(entity.getSubType())) {
                        name = "DEE\u4efb\u52a1\u63a5\u53e3" + suffix;
                        businessType = MagicEnums.BusinessType.EXTERNAL_BUSINESS.getKey();
                        ownerType = MagicEnums.ProviderType.DEFAULT_DEE.getType();
                    } else if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(entity.getSubType()) || MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(entity.getSubType())) {
                        MagicFormBean mfb = null;
                        ownerType = entity.getSubType();
                        businessType = MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey();
                        mfb = MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(entity.getSubType()) ? new MagicFormBean(MagicEnums.ServiceOwnerType.DEFAULT_FORM, entity.getFormId()) : new MagicFormBean(MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3, entity.getFormId());
                        if (mfb == null || mfb.isNull()) {
                            name = "\u5176\u4ed6" + suffix;
                        } else {
                            owner = String.valueOf(mfb.getId());
                            name = mfb.getFormName() + suffix;
                        }
                    } else {
                        name = "\u5176\u4ed6" + suffix;
                    }
                }
                if (creater != null && creater != 0L || !Strings.isNotBlank((String)entity.getExt2())) continue;
                try {
                    Map ext2 = JSONUtils.parseJSonStr_Class(entity.getExt2(), Map.class);
                    creater = ParamUtil.getLong((Map)ext2, (String)"creater", (Long)0L);
                }
                catch (Exception ex) {
                    LOGGER.warn((Object)ex.getLocalizedMessage());
                }
            }
            if (servicSummary.get(key) != null || needSaveBaseInfo.get(key) != null) continue;
            MagicServiceSummary newInfo = new MagicServiceSummary();
            newInfo.setIdIfNew();
            newInfo.setBusinessId(keyArray[0]);
            newInfo.setBusinessVersion(keyArray[1]);
            newInfo.setNameDisplay(name);
            newInfo.setOwner(owner);
            newInfo.setCreateDate(DateUtil.currentDate());
            newInfo.setModifyDate(DateUtil.currentDate());
            newInfo.setOwnerType(ownerType);
            newInfo.setBusinessType(businessType);
            newInfo.setAuthorizationType(Integer.valueOf(MagicEnums.ServiceAuthType.USERDEFINED.getKey()));
            if (MagicPrivateUtils.isNumeric(owner)) {
                newInfo.setAuthorizationInfo(JSONUtils.getJSonString(MagicCreateServiceUtils.getDefaultAuth(Long.parseLong(owner), ownerType)));
            }
            newInfo.setCertificateType(Integer.valueOf(MagicEnums.CertificateType.Private_certificate.getKey()));
            newInfo.setMetadata(JSONUtils.getJSonString(newMetadataConfigs.values()));
            newInfo.setCreateId(creater);
            needSaveBaseInfo.put(key, newInfo);
        }
        this.magicServiceSummaryDao.saveAll(needSaveBaseInfo.values());
        if (!needUpdate.isEmpty()) {
            this.updateProviders(needUpdate);
        }
        return needUpdate;
    }

    private void updateProviders(List<MagicInterfaceDefineEntity> allEntitys) {
        String splitChar = ",";
        HashMap<String, MagicInterfaceDefineEntity> entityMapper = new HashMap<String, MagicInterfaceDefineEntity>();
        for (MagicInterfaceDefineEntity e : allEntitys) {
            entityMapper.put(e.getBusinessId() + splitChar + e.getVersionId() + splitChar + e.getMethodName(), e);
        }
        List<MagicServiceProviderPO> allProviders = this.magicProviderDao.loadAllProviders();
        HashMap mapper = new HashMap();
        HashMap<String, LinkedList<MagicServiceProviderPO>> deeProvider = new HashMap<String, LinkedList<MagicServiceProviderPO>>();
        for (MagicServiceProviderPO p : allProviders) {
            String subKey = p.getBusinessId() + splitChar + p.getVersionId();
            if (entityMapper.get(subKey + splitChar + p.getMethodName()) == null) continue;
            if (MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(p.getSourceType()) || MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(p.getSourceType())) {
                LinkedList<MagicServiceProviderPO> providers;
                String key = p.getSource() + splitChar + p.getSourceType();
                HashMap<String, LinkedList<MagicServiceProviderPO>> cacheMapper = (HashMap<String, LinkedList<MagicServiceProviderPO>>)mapper.get(key);
                if (cacheMapper == null) {
                    cacheMapper = new HashMap<String, LinkedList<MagicServiceProviderPO>>();
                    mapper.put(key, cacheMapper);
                }
                if ((providers = (LinkedList<MagicServiceProviderPO>)cacheMapper.get(subKey)) == null) {
                    providers = new LinkedList<MagicServiceProviderPO>();
                    cacheMapper.put(subKey, providers);
                }
                providers.add(p);
                continue;
            }
            LinkedList<MagicServiceProviderPO> providers = (LinkedList<MagicServiceProviderPO>)deeProvider.get(subKey);
            if (providers == null) {
                providers = new LinkedList<MagicServiceProviderPO>();
                deeProvider.put(subKey, providers);
            }
            providers.add(p);
        }
        LinkedList<MagicServiceProviderPO> needSaveList = new LinkedList<MagicServiceProviderPO>();
        LinkedList<MagicServiceProviderPO> needDeleteList = new LinkedList<MagicServiceProviderPO>();
        for (Map.Entry e : mapper.entrySet()) {
            String key = (String)e.getKey();
            String[] keyArray = key.split(splitChar);
            for (Map.Entry entry : ((Map)e.getValue()).entrySet()) {
                String subKey = (String)entry.getKey();
                String[] subKeyArray = subKey.split(splitChar);
                MagicServiceProviderPO tempP = new MagicServiceProviderPO();
                tempP.setIdIfNew();
                tempP.setSource(keyArray[0]);
                tempP.setSourceType(keyArray[1]);
                tempP.setBusinessId(subKeyArray[0]);
                tempP.setVersionId(subKeyArray[1]);
                tempP.setCreateDate(DateUtil.currentDate());
                ArrayList<Map<String, Object>> methodMapping = new ArrayList<Map<String, Object>>();
                Integer status = MagicEnums.ProviderStatus.OFF.getType();
                for (MagicServiceProviderPO p : (List)entry.getValue()) {
                    MagicInterfaceDefineEntity serviceEntity = (MagicInterfaceDefineEntity)entityMapper.get(subKey + splitChar + p.getMethodName());
                    if (p.getStatus() == MagicEnums.ProviderStatus.ON.getType()) {
                        status = MagicEnums.ProviderStatus.ON.getType();
                    }
                    if (serviceEntity != null) {
                        MagicEnums.ServiceOwnerType serviceOwnerType = MagicEnums.ServiceOwnerType.getEnumByType((String)p.getSourceType());
                        if (Strings.isNotBlank((String)p.getExt1()) && serviceOwnerType != null && MagicPrivateUtils.isNumeric(p.getSource())) {
                            MagicFormBean mfb = new MagicFormBean(serviceOwnerType, Long.parseLong(p.getSource()));
                            Map<String, Object> newProviders = MagicUpdateServiceUtils.updateProviderMappingSet(serviceEntity, mfb, JSONUtils.parseJSonStr_Class(p.getExt1(), Map.class));
                            if (newProviders != null && !newProviders.isEmpty()) {
                                methodMapping.add(newProviders);
                            }
                            if (!mfb.isNull()) {
                                tempP.setDisplayName(mfb.getFormName());
                            }
                        }
                        if ((tempP.getCreater() == null || tempP.getCreater() == 0L) && Strings.isNotBlank((String)serviceEntity.getExt2())) {
                            try {
                                Map ext2 = JSONUtils.parseJSonStr_Class(serviceEntity.getExt2(), Map.class);
                                tempP.setCreater(ParamUtil.getLong((Map)ext2, (String)"creater", (Long)0L));
                            }
                            catch (Exception ex) {
                                LOGGER.warn((Object)ex.getLocalizedMessage());
                            }
                        }
                        needDeleteList.add(p);
                        continue;
                    }
                    needDeleteList.add(p);
                }
                tempP.setStatus(status.intValue());
                if (methodMapping.isEmpty()) continue;
                tempP.setExt1(JSONUtils.getJSonString(methodMapping));
                needSaveList.add(tempP);
            }
        }
        for (Map.Entry entry : deeProvider.entrySet()) {
            String subKey = (String)entry.getKey();
            List values = (List)entry.getValue();
            Integer status = MagicEnums.ProviderStatus.OFF.getType();
            String[] subKeyArray = subKey.split(splitChar);
            MagicServiceProviderPO tempP = new MagicServiceProviderPO();
            tempP.setIdIfNew();
            tempP.setBusinessId(subKeyArray[0]);
            tempP.setVersionId(subKeyArray[1]);
            tempP.setSourceType(MagicEnums.ProviderType.DEFAULT_DEE.getType());
            ArrayList extMapper = new ArrayList();
            for (MagicServiceProviderPO p : values) {
                if (p.getStatus() == MagicEnums.ProviderStatus.ON.getType()) {
                    status = MagicEnums.ProviderStatus.ON.getType();
                }
                HashMap<String, String> currentMethodMapping = new HashMap<String, String>();
                currentMethodMapping.put("methodName", p.getMethodName());
                extMapper.add(currentMethodMapping);
            }
            needDeleteList.addAll(values);
            tempP.setExt1(JSONUtils.getJSonString(extMapper));
            tempP.setStatus(status.intValue());
            needSaveList.add(tempP);
        }
        this.magicProviderDao.saveProviders(needSaveList);
        this.magicProviderDao.deleteProvides(needDeleteList);
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }
}

