/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.compiler;

import com.seeyon.cap4.magic.business.importandexport.IMagicExportManager;
import com.seeyon.cap4.magic.business.importandexport.IMagicExternalExportManager;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicExportProvider;
import com.seeyon.cap4.magic.business.importandexport.vo.MagicExternalProviderInfo;
import com.seeyon.cap4.magic.compiler.IMagicCompilerManager;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.generator.cap4.ICAP4ImplGenerateManager;
import com.seeyon.cap4.magic.manager.impl.LoadConfigDataService4CapImpl;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.IOUtility;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.datamagic.engine.domain.DataMagicSourceCode;
import com.seeyon.datamagic.engine.domain.mapping.MethodMappingConfig;
import com.seeyon.datamagic.engine.domain.mapping.ServiceMapping;
import com.seeyon.datamagic.engine.domain.metadata.Metadata;
import com.seeyon.datamagic.engine.domain.service.ServiceConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import com.seeyon.datamagic.engine.enums.MetadaEnums;
import com.seeyon.datamagic.engine.loader.PrivateClassLoader;
import com.seeyon.datamagic.engine.service.CompilerService;
import com.seeyon.datamagic.engine.service.GenerateService;
import com.seeyon.datamagic.engine.service.LoadConfigDataService;
import com.seeyon.datamagic.engine.service.impl.CompilerServiceImpl;
import com.seeyon.datamagic.engine.service.impl.GenerateServiceImplByTemplate;
import com.seeyon.datamagic.engine.template.DataMagicMatchValue;
import com.seeyon.datamagic.engine.template.TemplateFormatUtls;
import com.seeyon.datamagic.engine.template.vo.TemplateVo;
import com.seeyon.datamagic.engine.utils.GenerateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.logging.Log;
import org.songjian.utils.ScriptReplace;
import org.songjian.utils.StreamUtils;

public class MagicCompilerManagerImpl
implements IMagicCompilerManager {
    private GenerateService gs = new GenerateServiceImplByTemplate();
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private ICAP4ImplGenerateManager cap4ImplGenerateManager;
    private IMagicProviderDao magicProviderDao;
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private IMagicExportManager magicExternalExportManager;
    private static final Log LOGGER = CtpLogFactory.getLog(MagicCompilerManagerImpl.class);
    private static LoadConfigDataService loadConfigDataService = new LoadConfigDataService4CapImpl();

    @Override
    public boolean generateByRelations(List<MagicReflectionRelationPO> relations) throws BusinessException {
        if (relations != null && !relations.isEmpty()) {
            HashMap<String, DataMagicSourceCode> code = new HashMap<String, DataMagicSourceCode>();
            for (MagicReflectionRelationPO relation : relations) {
                CompilerService cs;
                MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(relation.getCalleeBusinessId(), relation.getCalleeVersionId());
                MagicServiceProviderPO currentProvider = this.magicProviderDao.loadProviders(relation.getCalleeBusinessId(), relation.getCalleeVersionId(), MagicEnums.ProviderStatus.ON);
                if (currentProvider != null && (MagicEnums.ArticulatedType.EXTEND_JAVA_SOURCE.getType().equals(currentProvider.getSourceType()) || MagicEnums.ArticulatedType.EXTEND_CLASS.getType().equals(currentProvider.getSourceType()))) {
                    PrivateClassLoader classLoader = new PrivateClassLoader(this.getClass().getClassLoader());
                    File compilerPath = new File(SystemEnvironment.getClassCacheFolder(), "magic/compiler" + File.separator + serviceSummary.getId());
                    classLoader.addClassPath(compilerPath.getPath());
                    this.loadExternalClass(compilerPath.getPath(), compilerPath, classLoader);
                    this.checkAndCopyCode(serviceSummary, currentProvider);
                    cs = this.getCompilerService(classLoader, serviceSummary.getId());
                } else {
                    cs = this.getCompilerService(serviceSummary.getId());
                }
                code.clear();
                code.putAll(this.getSourceCode(serviceSummary, relation, currentProvider));
                cs.compiler(code.values());
            }
        }
        return true;
    }

    private void checkAndCopyCode(MagicServiceSummary serviceSummary, MagicServiceProviderPO currentProvider) throws BusinessException {
        File compilerPath = new File(SystemEnvironment.getClassCacheFolder(), "magic/compiler" + File.separator + serviceSummary.getId());
        File execute = new File(SystemEnvironment.getClassCacheFolder(), "magic/execute" + File.separator + serviceSummary.getId());
        boolean needCopy = false;
        if (!compilerPath.exists() || !execute.exists()) {
            needCopy = true;
        } else {
            String className = currentProvider.getSource();
            String calssPath = className.replace(".", File.separator) + ".class";
            File classFile = new File(compilerPath, calssPath);
            File classFile1 = new File(execute, calssPath);
            if (!classFile.exists() || !classFile1.exists()) {
                needCopy = true;
            }
        }
        if (needCopy) {
            File zipFile = new File(SystemEnvironment.getClusterPublicFolder((String)"interface"), serviceSummary.getBusinessId() + ".zip");
            HashMap<String, Object> params = new HashMap<String, Object>();
            ((IMagicExternalExportManager)((Object)this.magicExternalExportManager)).reinstall(zipFile, params, false);
        }
    }

    private void loadExternalClass(String rootPath, File source, PrivateClassLoader classLoader) throws BusinessException {
        try {
            File[] listFiles = source.listFiles();
            if (listFiles != null && listFiles.length > 0) {
                for (File f : listFiles) {
                    if (f.isFile()) {
                        String className = f.getPath().replace(rootPath, "");
                        className = className.replace(File.separator, ".");
                        className = className.substring(1, className.lastIndexOf(".class"));
                        classLoader.loadClass(className);
                        continue;
                    }
                    this.loadExternalClass(rootPath, f, classLoader);
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private CompilerService getCompilerService(Long targetId) {
        LOGGER.info((Object)("\u52a0\u8f7d\u5668\u540d\u79f0\u4e3a" + this.getClass().getClassLoader().getClass().getName()));
        PrivateClassLoader loader = new PrivateClassLoader(this.getClass().getClassLoader());
        File compilerPath = new File(SystemEnvironment.getClassCacheFolder(), "magic/compiler" + File.separator + targetId);
        return new CompilerServiceImpl(loader, compilerPath);
    }

    private CompilerService getCompilerService(PrivateClassLoader classLoader, Long targetId) {
        LOGGER.info((Object)("\u52a0\u8f7d\u5668\u540d\u79f0\u4e3a" + this.getClass().getClassLoader().getClass().getName()));
        File compilerPath = new File(SystemEnvironment.getClassCacheFolder(), "magic/compiler" + File.separator + targetId);
        return new CompilerServiceImpl(classLoader, compilerPath);
    }

    @Override
    public boolean generateByRelation(MagicReflectionRelationPO relation) throws BusinessException {
        if (relation != null) {
            ArrayList<MagicReflectionRelationPO> r = new ArrayList<MagicReflectionRelationPO>();
            r.add(relation);
            this.generateByRelations(r);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DataMagicSourceCode> getSourceCode(MagicServiceSummary serviceSummary, MagicReflectionRelationPO relation, MagicServiceProviderPO currentProvider) throws BusinessException {
        String cvid;
        HashMap<String, DataMagicSourceCode> code = new HashMap<String, DataMagicSourceCode>();
        String bId = relation.getBusinessId();
        String vId = relation.getVersionId();
        String cbid = relation.getCalleeBusinessId();
        List<MagicInterfaceDefineEntity> eitityList = this.magicInterfaceDefineDao.loadAllEntitys(cbid, cvid = relation.getCalleeVersionId());
        if (eitityList == null || eitityList.isEmpty()) {
            return code;
        }
        try {
            ServiceConfig thirdConfig = MagicPrivateUtils.mergeInterface2Configs(serviceSummary, eitityList, currentProvider);
            ServiceMapping sm = this.convert2Mapping(relation);
            ServiceConfig seeyonConfig = loadConfigDataService.loadServiceConfig(bId, vId);
            TemplateVo seeyonTemplate = TemplateFormatUtls.generateServiceTemplate((ServiceConfig)seeyonConfig, (List)seeyonConfig.getMetadata().getMetadatas());
            this.saveTemplate(seeyonTemplate);
            Map scode = this.gs.generateMetadataCode(seeyonConfig.getMetadata());
            if (currentProvider == null || !MagicEnums.ArticulatedType.EXTEND_JAVA_SOURCE.getType().equals(currentProvider.getSourceType()) && !MagicEnums.ArticulatedType.EXTEND_CLASS.getType().equals(currentProvider.getSourceType())) {
                Map tcode = this.gs.generateMetadataCode(thirdConfig.getMetadata());
                Map<String, DataMagicSourceCode> code1 = this.generateImpl4Interface(thirdConfig, eitityList);
                code.putAll(tcode);
                code.putAll(code1);
            }
            code.putAll(scode);
            this.testSaveConfig(thirdConfig, seeyonConfig, sm);
            List mds = this.gs.generateStandardServiceImpl(sm, thirdConfig, seeyonConfig.getMetadata(), thirdConfig.getMetadata(), seeyonConfig);
            for (DataMagicSourceCode dsc : mds) {
                code.put(dsc.getName(), dsc);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.saveCode(serviceSummary.getId(), code.values());
        }
        return code;
    }

    private ServiceMapping convert2Mapping(MagicReflectionRelationPO relation) {
        String mappingstr = relation.getMappingConfig();
        ArrayList mmcList = new ArrayList();
        JSONUtils.parseJSonListObj_Class(mappingstr, mmcList, MethodMappingConfig.class);
        ServiceMapping sm = new ServiceMapping();
        sm.setMappingId(String.valueOf(relation.getId()));
        sm.setServicebusinessId(relation.getCalleeBusinessId());
        sm.setServiceVersion(relation.getCalleeVersionId());
        sm.setStandardVersion(relation.getBusinessId());
        sm.setStantardBusinessId(relation.getVersionId());
        sm.setHookList(mmcList);
        return sm;
    }

    private void saveTemplate(TemplateVo vo) {
        String bid = vo.getBusinessId();
        String version = vo.getVersion();
        String path = SystemEnvironment.getClassCacheFolder();
        File file = new File(path, "magic/template");
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            file = new File(file, bid + "_" + version + "." + "txt");
            StreamUtils.writeStringToFile((String)file.getPath(), (String)vo.getContent(), (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void testSaveConfig(ServiceConfig third, ServiceConfig seeyon, ServiceMapping sm) {
        String path = SystemEnvironment.getClassCacheFolder();
        String thirdName = third.getBusinessId() + "_" + third.getVersion() + "." + "json";
        String seeyonName = seeyon.getBusinessId() + "_" + seeyon.getVersion() + "." + "json";
        String smName = sm.getStantardBusinessId() + "_" + sm.getServicebusinessId() + "." + "json";
        File parent = new File(path, "magic/config");
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File thirdFile = new File(parent, thirdName);
        File seeyonFile = new File(parent, seeyonName);
        File smFile = new File(parent, smName);
        try {
            StreamUtils.writeStringToFile((String)thirdFile.getPath(), (String)JSONUtils.getJSonString(third), (String)"UTF-8");
            StreamUtils.writeStringToFile((String)seeyonFile.getPath(), (String)JSONUtils.getJSonString(seeyon), (String)"UTF-8");
            StreamUtils.writeStringToFile((String)smFile.getPath(), (String)JSONUtils.getJSonString(sm), (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void saveCode(Long serviceId, Collection<DataMagicSourceCode> dsss) {
        String path = SystemEnvironment.getClassCacheFolder();
        File parentPath = new File(path, "magic/source" + File.separator + serviceId);
        if (!parentPath.exists()) {
            parentPath.mkdirs();
        }
        for (DataMagicSourceCode ss : dsss) {
            String pacakgeN = ss.getName();
            String souceCode = ss.getSource();
            File f = new File(parentPath, pacakgeN.replaceAll("[.]", "/") + ".java");
            try {
                if (f.exists()) {
                    f.delete();
                }
                f.getParentFile().mkdirs();
                StreamUtils.writeStringToFile((String)f.getPath(), (String)souceCode, (String)"UTF-8");
            }
            catch (IOException e1) {
                LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    public Map<String, DataMagicSourceCode> generateImpl4Interface(ServiceConfig thirdConfig, List<MagicInterfaceDefineEntity> eitityList) throws BusinessException {
        TemplateVo vo;
        HashMap<String, DataMagicSourceCode> result = new HashMap<String, DataMagicSourceCode>();
        String businessId = thirdConfig.getBusinessId();
        String version = thirdConfig.getVersion();
        HashMap<String, MagicInterfaceDefineEntity> defineEntityMapper = new HashMap<String, MagicInterfaceDefineEntity>();
        ArrayList<MagicServiceProviderPO> javaProviders = new ArrayList<MagicServiceProviderPO>();
        for (MagicInterfaceDefineEntity e : eitityList) {
            MagicServiceProviderPO currentProvider = this.magicProviderDao.loadProviders(businessId, version, MagicEnums.ProviderStatus.ON);
            if (currentProvider != null && MagicEnums.ArticulatedType.EXTEND_JAVA_SOURCE.getType().equals(currentProvider.getSourceType())) {
                javaProviders.add(currentProvider);
            }
            defineEntityMapper.put(e.getMethodName(), e);
        }
        Metadata metadata = thirdConfig.getMetadata();
        List mcList = null;
        if (metadata != null) {
            mcList = metadata.getMetadatas();
        }
        if (mcList == null) {
            mcList = new ArrayList();
        }
        if ((vo = TemplateFormatUtls.generateServiceTemplate((ServiceConfig)thirdConfig, (List)mcList)) != null) {
            this.saveTemplate(vo);
        }
        DataMagicMatchValue match = new DataMagicMatchValue();
        String interfaceP = GenerateUtils.generateServicePackage((String)businessId, (String)version);
        String interfaceN = GenerateUtils.generateServiceName((String)businessId);
        String className = GenerateUtils.generateServiceImplName((String)businessId, (String)version, (String)"0");
        String packages = GenerateUtils.generateServiceImplPath((String)businessId);
        String entityPath = GenerateUtils.generateEntityPackage((String)businessId, (String)version);
        match.put("interfaceName", interfaceP + "." + interfaceN);
        match.put("packageName", packages);
        match.put("className", className);
        HashSet<String> imports = new HashSet<String>();
        for (ServiceMethodConfig mc : thirdConfig.getMethodConfig()) {
            String methodName = mc.getMethodName();
            MagicInterfaceDefineEntity entity = (MagicInterfaceDefineEntity)defineEntityMapper.get(methodName);
            TemplateVo contents = null;
            MagicServiceProviderPO currentProviders = this.magicProviderDao.loadProviders(businessId, version, MagicEnums.ProviderStatus.ON);
            Set dependences = null;
            contents = this.cap4ImplGenerateManager.generateMethodContent(entity, thirdConfig, currentProviders);
            dependences = contents.getDependences();
            match.put(methodName, contents.getContent());
            if (dependences == null || dependences.isEmpty()) continue;
            imports.addAll(dependences);
        }
        for (String defaultImport : GenerateUtils.getDefaultImportList()) {
            if (!Strings.isNotBlank((String)defaultImport)) continue;
            match.put("imports", "import " + defaultImport + ";");
        }
        imports.add(entityPath + ".*");
        for (String i : imports) {
            if (!Strings.isNotBlank((String)i)) continue;
            match.put("imports", "import " + i + ";");
        }
        DataMagicSourceCode imple = new DataMagicSourceCode();
        String sourceId = "";
        imple.setSourceId(sourceId);
        imple.setCodeType(MetadaEnums.ObjectType.IMPLEMENT);
        imple.setName(packages + "." + className);
        imple.setSource(TemplateFormatUtls.convert((String)thirdConfig.getBusinessId(), (String)thirdConfig.getVersion(), (ScriptReplace.IMatchValue)match));
        result.put(imple.getName(), imple);
        if (thirdConfig.getMetadata() != null && thirdConfig.getMetadata().getMetadatas() != null) {
            mcList = thirdConfig.getMetadata().getMetadatas();
        }
        DataMagicSourceCode scode = this.gs.generateThirdService(thirdConfig, mcList);
        result.put(scode.getName(), scode);
        for (MagicServiceProviderPO p : javaProviders) {
            String javaFullName = p.getSource();
            String javaContent = this.loadJavaSourceByFullName(p.getBusinessId(), javaFullName);
            if (!Strings.isNotBlank((String)javaContent)) continue;
            DataMagicSourceCode t = new DataMagicSourceCode();
            t.setName(javaFullName);
            t.setSource(javaContent);
            t.setCodeType(MetadaEnums.ObjectType.IMPLEMENT);
            result.put(javaFullName, t);
        }
        return result;
    }

    private String loadJavaSourceByFullName(String bid, String name) {
        try {
            if (Strings.isNotBlank((String)name)) {
                String fileName = name.replaceAll("[.]", "\\" + File.separator) + ".java";
                File f = new File(SystemEnvironment.getClassCacheFolder() + File.separator + "magic/source" + File.separator + bid, fileName);
                FileInputStream input = new FileInputStream(f);
                return IOUtility.toString((InputStream)input);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u83b7\u53d6java \u7c7b" + name + ",\u7684\u6b63\u6587\u5931\u8d25" + e.getLocalizedMessage()));
        }
        return null;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public ICAP4ImplGenerateManager getCap4ImplGenerateManager() {
        return this.cap4ImplGenerateManager;
    }

    public void setCap4ImplGenerateManager(ICAP4ImplGenerateManager cap4ImplGenerateManager) {
        this.cap4ImplGenerateManager = cap4ImplGenerateManager;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    @Override
    public String createCodeZip(MagicServiceSummary summary, List<MagicInterfaceDefineEntity> eitityList) throws BusinessException, IOException, ZipException {
        ServiceConfig serviceConfig = MagicPrivateUtils.mergeInterface2Configs(summary, eitityList, null);
        Map<String, DataMagicSourceCode> serviceCodes = this.generateImpl4Interface(serviceConfig, eitityList);
        try {
            if (serviceConfig.getMetadata() != null && serviceConfig.getMetadata().getMetadatas() != null) {
                Map allMetadataCode = this.gs.generateMetadataCode(serviceConfig.getMetadata());
                serviceCodes.putAll(allMetadataCode);
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        ExportSourceFileVo vo = this.createMavenFolder(summary.getId());
        this.saveExternalCode(serviceCodes.values(), serviceConfig, vo.getJavaSourceFolder());
        this.createRegisterImplText(serviceConfig, vo.getJavaSourceFolder());
        File serviceConfigFile = new File(vo.getServiceRootPath(), "serviceConfig.json");
        StreamUtils.writeStringToFile((String)serviceConfigFile.getPath(), (String)JSONUtils.getJSonString(serviceConfig), (String)"UTF-8");
        this.setProviderJSON(serviceConfig, vo.getServiceRootPath());
        DataMagicMatchValue match = new DataMagicMatchValue();
        match.put("businessId", serviceConfig.getBusinessId());
        match.put("cap.version", "${cap.version}");
        match.put("name", "${name}");
        InputStream pomStream = this.getClass().getResourceAsStream("pom.txt");
        String template = IOUtility.toString((InputStream)pomStream);
        String pomContent = TemplateFormatUtls.convert((String)template, (ScriptReplace.IMatchValue)match);
        File pomFile = new File(vo.getServiceRootPath(), "pom.xml");
        StreamUtils.writeStringToFile((String)pomFile.getPath(), (String)pomContent, (String)"UTF-8");
        pomStream.close();
        String interface_assembly = "interface-assembly.xml";
        pomStream = this.getClass().getResourceAsStream(interface_assembly);
        pomFile = new File(vo.getServiceRootPath(), interface_assembly);
        IOUtility.copy((byte[])IOUtility.toByteArray((InputStream)pomStream), (String)pomFile.getPath());
        pomStream.close();
        String rootZip_assembly = "rootZip-assembly.xml";
        pomStream = this.getClass().getResourceAsStream(rootZip_assembly);
        pomFile = new File(vo.getServiceRootPath(), rootZip_assembly);
        IOUtility.copy((byte[])IOUtility.toByteArray((InputStream)pomStream), (String)pomFile.getPath());
        pomStream.close();
        File zip = new File(vo.getRootPath(), "zip");
        if (!zip.exists()) {
            zip.mkdirs();
        }
        File f = new File(zip.getPath() + "/" + summary.getId() + ".zip");
        ZipUtil.zip((File)new File(vo.getServiceRootPath()), (File)f, (boolean)true);
        return f.getPath();
    }

    private ExportSourceFileVo createMavenFolder(Long summaryId) {
        String root = SystemEnvironment.getSystemTempFolder();
        File javaMain = new File(root, "magic" + File.separator + "external" + File.separator + summaryId + File.separator + "src" + File.separator + "main" + File.separator + "java");
        if (javaMain.exists()) {
            javaMain.delete();
        }
        javaMain.mkdirs();
        ExportSourceFileVo result = new ExportSourceFileVo();
        result.setJavaSourceFolder(javaMain.getPath());
        File rootPath = new File(root, "magic" + File.separator + "external");
        File summaryRootFile = new File(rootPath, summaryId + "");
        result.setRootPath(rootPath.getPath());
        result.setServiceRootPath(summaryRootFile.getPath());
        return result;
    }

    private void saveExternalCode(Collection<DataMagicSourceCode> dsss, ServiceConfig serviceConfig, String path) {
        File parentPath = new File(path);
        if (!parentPath.exists()) {
            parentPath.mkdirs();
        }
        try {
            for (DataMagicSourceCode ss : dsss) {
                String pacakgeN = ss.getName();
                String souceCode = ss.getSource();
                File f = new File(parentPath, pacakgeN.replaceAll("[.]", "/") + ".java");
                if (f.exists()) {
                    f.delete();
                }
                f.getParentFile().mkdirs();
                StreamUtils.writeStringToFile((String)f.getPath(), (String)souceCode, (String)"UTF-8");
            }
        }
        catch (IOException e1) {
            LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private String setProviderJSON(ServiceConfig serviceConfig, String savePath) {
        try {
            MagicExportProvider p = new MagicExportProvider();
            p.setProviderType(MagicEnums.BusinessType.EXTERNAL_BUSINESS.getKey());
            p.setVersion(serviceConfig.getVersion());
            p.setBusinessId(serviceConfig.getBusinessId());
            MagicExternalProviderInfo eInfo = new MagicExternalProviderInfo();
            eInfo.setInitClass("com.seeyon.magic.external.register.MagicProviderRegisterImpl");
            p.setExternalProviderInfo(eInfo);
            File f = new File(savePath, "provider.json");
            StreamUtils.writeStringToFile((String)f.getPath(), (String)JSONUtils.getJSonString(p), (String)"UTF-8");
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRegisterImplText(ServiceConfig serviceConfig, String savePath) throws IOException {
        String className = GenerateUtils.generateServiceImplName((String)serviceConfig.getBusinessId(), (String)serviceConfig.getVersion(), (String)"0");
        String packages = GenerateUtils.generateServiceImplPath((String)serviceConfig.getBusinessId());
        String code = "package com.seeyon.magic.external.register;\nimport  com.seeyon.cap4.magic.manager.MagicProviderRegisterServices;\nimport com.seeyon.cap4.magic.manager.MagicProviderInfo;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.UUID;\nimport " + packages + "." + className + ";\npublic class MagicProviderRegisterImpl implements MagicProviderRegisterServices {\n    @Override\n    public List<MagicProviderInfo> registerProviders( String oaVersion, String magicVersion ) {\n        List<MagicProviderInfo> result = new ArrayList<MagicProviderInfo>();\n        MagicProviderInfo info = new MagicProviderInfo();\n        info.setBusinessId(\"" + serviceConfig.getBusinessId() + "\");\n        info.setVersion(\"" + serviceConfig.getVersion() + "\");\n        info.setName(\"\u8fd9\u662f\u5b9e\u73b0\u7c7b\u540d\u79f0\");\n        info.setSource(" + className + ".class.getName());\n        info.setProviderId(UUID.randomUUID().toString());\n        info.setDes(\"\u8fd9\u662f\u63cf\u8ff0\");\n        info.setStatus(\"on\");\n        result.add(info);\n        return result;\n    }\n}\n";
        File registerFile = new File(savePath + File.separator + "com" + File.separator + "seeyon" + File.separator + "magic" + File.separator + "external" + File.separator + "register", "MagicProviderRegisterImpl.java");
        if (!registerFile.getParentFile().exists()) {
            registerFile.getParentFile().mkdirs();
        }
        if (!registerFile.exists()) {
            registerFile.createNewFile();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(registerFile);
            out.write(code.getBytes("UTF-8"));
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    public IMagicExportManager getMagicExternalExportManager() {
        return this.magicExternalExportManager;
    }

    public void setMagicExternalExportManager(IMagicExportManager magicExternalExportManager) {
        this.magicExternalExportManager = magicExternalExportManager;
    }

    class ExportSourceFileVo {
        private String serviceRootPath;
        private String rootPath;
        private String javaSourceFolder;

        ExportSourceFileVo() {
        }

        public String getRootPath() {
            return this.rootPath;
        }

        public void setRootPath(String rootPath) {
            this.rootPath = rootPath;
        }

        public String getJavaSourceFolder() {
            return this.javaSourceFolder;
        }

        public void setJavaSourceFolder(String javaSourceFolder) {
            this.javaSourceFolder = javaSourceFolder;
        }

        public String getServiceRootPath() {
            return this.serviceRootPath;
        }

        public void setServiceRootPath(String serviceRootPath) {
            this.serviceRootPath = serviceRootPath;
        }
    }
}

