/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.controller;

import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.component.Left2RightVO;
import com.seeyon.cap4.form.modules.engin.formula.CAP4FormCustomFunctionManager;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.interflow.utils.CapInterFlowRelationUtils;
import com.seeyon.cap4.magic.business.IMagicAjaxHandleService;
import com.seeyon.cap4.magic.business.create.impl.AbstractMagicHandleService;
import com.seeyon.cap4.magic.business.importandexport.IMagicExportManager;
import com.seeyon.cap4.magic.compiler.IMagicCompilerManager;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicFormBean;
import com.seeyon.cap4.magic.vo.MagicFormFieldBean;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumBean;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.util.IOUtility;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.ReqUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.utils.GenerateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.ModelAndView;

public class MagicController
extends BaseController {
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private CAP4FormCustomFunctionManager cap4FormCustomFunctionManager;
    private FormCacheManager formCacheManager;
    private BusinessManager businessManager4;
    private static final Log LOGGER = CtpLogFactory.getLog(MagicController.class);
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private ICAP4MagicManager cap4MagicManager;
    private IMagicProviderDao magicProviderDao;
    private EnumManager enumManagerNew;
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private IMagicAjaxHandleService magicAjaxHandleService;
    private IMagicExportManager magicExternalExportManager;

    public ModelAndView magicServiceManager(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(MagicPrivateUtils.checkPrivilege());
        ModelAndView mav = new ModelAndView("cap4/magic/interface/interfaceManager", params);
        return mav;
    }

    public ModelAndView selectOuterFormBind(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceType", "formBind");
        ModelAndView mav = new ModelAndView("cap4/magic/config/selectMagicSources", params);
        return mav;
    }

    public ModelAndView switchProvider(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        Long serviceId = ReqUtil.getLong((HttpServletRequest)request, (String)"serviceId", (long)0L);
        MagicServiceSummary entity = this.magicServiceSummaryDao.loadServiceInfo(serviceId);
        HashMap result = new HashMap();
        ModelAndView mav = new ModelAndView("cap4/magic/interface/switchProviders");
        if (entity != null) {
            MagicServiceProviderPO p = this.magicProviderDao.loadProviders(entity.getBusinessId(), entity.getBusinessVersion(), MagicEnums.ProviderStatus.ON);
            if (p != null) {
                mav.addObject("providerId", (Object)String.valueOf(p.getId()));
            }
            List<Map<String, Object>> resultData = this.magicAjaxHandleService.showProvidersSummarys(entity);
            mav.addObject("data", resultData);
            mav.addObject("serviceName", (Object)entity.getNameDisplay());
            mav.addObject("serviceId", (Object)String.valueOf(serviceId));
        }
        return mav;
    }

    public ModelAndView selectBizConfig(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceType", "bizCofig");
        ModelAndView mav = new ModelAndView("cap4/magic/config/selectMagicSources", params);
        return mav;
    }

    public ModelAndView createAttribute(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        String pageIndex = ReqUtil.getString((HttpServletRequest)request, (String)"pageIndex", (String)"");
        params.put("pageIndex", pageIndex);
        ModelAndView mav = new ModelAndView("cap4/magic/interface/paramSetting", params);
        return mav;
    }

    public ModelAndView attributeSort(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        String pageIndex = ReqUtil.getString((HttpServletRequest)request, (String)"pageIndex", (String)"");
        params.put("pageIndex", pageIndex);
        ModelAndView mav = new ModelAndView("cap4/magic/interface/sort", params);
        return mav;
    }

    public ModelAndView contactSetting(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap params = new HashMap();
        ModelAndView mav = new ModelAndView("cap4/magic/interface/contactSetting", params);
        return mav;
    }

    public ModelAndView methodSetting(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap params = new HashMap();
        ModelAndView mav = new ModelAndView("cap4/magic/interface/methodSetting", params);
        return mav;
    }

    public ModelAndView selectFormByBizId(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceType", "bizCofigForm");
        ModelAndView mav = new ModelAndView("cap4/magic/config/selectMagicSources", params);
        return mav;
    }

    public ModelAndView selectFormField(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("cap4/magic/config/magicSelectFormField");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L);
        String formType = ReqUtil.getString((HttpServletRequest)request, (String)"formType", (String)"");
        if (MagicEnums.ServiceOwnerType.DEFAULT_FORM.getType().equals(formType)) {
            com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            if (formBean != null) {
                ArrayList<Left2RightVO> result = new ArrayList<Left2RightVO>();
                for (FormFieldBean ffb : formBean.getAllFieldBeans()) {
                    if (ffb.isCustomerCtrl()) continue;
                    Left2RightVO item = new Left2RightVO();
                    item.setFieldType(ffb.getFinalFieldType());
                    item.setInputType(ffb.getFinalInputType());
                    item.setName(ffb.getDisplay());
                    item.setValue(ffb.getName());
                    item.setOwnerTable(ffb.getOwnerTableName());
                    if (ffb.isMasterField()) {
                        item.setOwnerTableDisplay(ffb.getOwnerTableName());
                    } else {
                        item.setOwnerTableDisplay(ResourceUtil.getString((String)"form.detail.table.label") + ffb.getOwnerTableIndex());
                    }
                    result.add(item);
                }
                mav.addObject("fieldList", result);
            }
        } else if (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(formType)) {
            FormBean fb = this.formCacheManager.getForm(formId.longValue());
            if (fb == null) {
                mav.addObject("fieldList", Collections.emptyList());
            } else {
                String type = ReqUtil.getString((HttpServletRequest)request, (String)"type", (String)"relation");
                mav.addObject("fieldList", CapInterFlowRelationUtils.convertFields(fb, "relation", false));
            }
        }
        return mav;
    }

    public ModelAndView showInterfaceInfo(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        String type = ReqUtil.getString((HttpServletRequest)request, (String)"type", (String)MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey());
        Long interfaceId = ReqUtil.getLong((HttpServletRequest)request, (String)"interfaceId", (long)0L);
        MagicServiceSummary summary = this.magicServiceSummaryDao.loadServiceInfo(interfaceId);
        if (summary != null) {
            type = summary.getBusinessType();
        }
        if (Strings.isBlank((String)type)) {
            type = MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey();
        }
        String serviceOwnerType = ReqUtil.getString((HttpServletRequest)request, (String)"serviceOwnerType");
        if (summary != null) {
            params.put("serviceOwnerType", summary.getOwnerType());
        } else {
            params.put("serviceOwnerType", serviceOwnerType);
        }
        params.put("businessType", type);
        params.put("interfaceId", String.valueOf(interfaceId));
        params.put("certificateType", ParamUtil.getString(MagicPrivateUtils.checkPrivilege(), (String)"certificateType", (String)"private"));
        ModelAndView mav = new ModelAndView("cap4/magic/interface/interfaceInfo", params);
        return mav;
    }

    public ModelAndView showMethodInfo(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        String type = ReqUtil.getString((HttpServletRequest)request, (String)"type", (String)MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey());
        params.put("businessType", type);
        String methodType = ReqUtil.getString((HttpServletRequest)request, (String)"methodType", (String)"");
        params.put("methodType", methodType);
        String defaultMethodName = GenerateUtils.generateRandomMD5((String)"m");
        params.put("defaultMethodName", defaultMethodName);
        ModelAndView mav = new ModelAndView("cap4/magic/interface/methodInfo", params);
        return mav;
    }

    public ModelAndView test(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        this.cap4MagicManager.updateMagic();
        return null;
    }

    public ModelAndView interfaceOutManager(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        String type = ReqUtil.getString((HttpServletRequest)request, (String)"type", (String)MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey());
        String bizConfigId = ReqUtil.getString((HttpServletRequest)request, (String)"bizConfigId");
        params.put("businessType", type);
        params.put("bizConfigId", bizConfigId);
        ModelAndView mav = new ModelAndView("cap4/magic/interface/interfaceOutManager", params);
        return mav;
    }

    public ModelAndView selectFormTemplate(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceType", "formTemplate");
        ModelAndView mav = new ModelAndView("cap4/magic/config/selectMagicSources", params);
        return mav;
    }

    public ModelAndView selectMagicService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result = new ModelAndView("cap4/magic/config/selectServices");
        return result;
    }

    public ModelAndView checkMagicFieldChange(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView view = new ModelAndView("cap4/magic/management/showCheckMagicResult");
        Long bizConfigId = ReqUtil.getLong((HttpServletRequest)request, (String)"bizConfigId", (long)0L);
        List<com.seeyon.cap4.form.bean.FormBean> fbList = this.businessManager4.getFormBeanListByBizId(bizConfigId);
        LinkedList<Map<String, String>> checkResult = new LinkedList<Map<String, String>>();
        HashMap<String, MagicInterfaceDefineEntity> cacheService = new HashMap<String, MagicInterfaceDefineEntity>();
        HashMap<Long, MagicServiceProviderPO> cacheProvider = new HashMap<Long, MagicServiceProviderPO>();
        for (com.seeyon.cap4.form.bean.FormBean fb : fbList) {
            MagicServiceProviderPO providerPO;
            MagicInterfaceDefineEntity entity;
            String methodName;
            String vid;
            String bid;
            Map params;
            List relations = fb.getFormRelationshipIdList();
            for (Long r : relations) {
                FormRelationshipBean ship = this.cap4FormCacheManager.getFormRelationshipBean(r);
                if (ship == null || !FormRelationEnums.relationApplicationType.inner.getKey().equals(ship.getApplicationType()) || FormRelationEnums.RelationObjType.RELATION_CURRENT_FORM.getKey().equals(ship.getRelationObjType())) continue;
                for (FormRelationshipMapBean shipMap : ship.getRelationMapList()) {
                    params = shipMap.getParams();
                    bid = ParamUtil.getString((Map)params, (String)"businessId", (String)"");
                    vid = ParamUtil.getString((Map)params, (String)"versionId", (String)"");
                    methodName = ParamUtil.getString((Map)params, (String)"methodName", (String)"");
                    entity = (MagicInterfaceDefineEntity)cacheService.get(bid + "_" + vid + "_" + methodName);
                    if (entity == null) {
                        this.magicInterfaceDefineDao.loadDefineById(bid, vid, methodName);
                    }
                    if (entity == null) {
                        entity = ship.getRelationType() == 1 ? this.cap4MagicManager.getServiceEntryByCallPoint(ship.getId() + "_" + shipMap.getSelectedField(), MagicEnums.BusinessMethodType.RELATION_USER) : this.cap4MagicManager.getServiceEntryByCallPoint(ship.getId() + "_" + shipMap.getConditionFormulaId(), MagicEnums.BusinessMethodType.RELATION_SYS);
                    }
                    if (entity == null) continue;
                    cacheService.put(bid + "_" + vid + "_" + methodName, entity);
                    if (!MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(entity.getSubType()) && !MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(entity.getSubType())) continue;
                    providerPO = (MagicServiceProviderPO)cacheProvider.get(entity.getId());
                    if (providerPO == null && (providerPO = this.magicProviderDao.loadProviders(bid, vid, MagicEnums.ProviderStatus.ON)) != null) {
                        cacheProvider.put(entity.getId(), providerPO);
                    }
                    checkResult.addAll(this.checkMagicChangeFormRelation(fb, shipMap, entity, providerPO));
                }
            }
            relations = fb.getFormTriggerIdList();
            for (Long r : relations) {
                FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(r);
                if (!FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(triggerBean.getType()) && !FormTriggerBean.TriggerBusinessType.DataInterface.getKey().equals(triggerBean.getType())) continue;
                for (FormTriggerActionBean action : triggerBean.getActionList()) {
                    params = action.getParam();
                    bid = ParamUtil.getString((Map)params, (String)"businessId", (String)"");
                    vid = ParamUtil.getString((Map)params, (String)"versionId", (String)"");
                    methodName = ParamUtil.getString((Map)params, (String)"methodName", (String)"");
                    entity = (MagicInterfaceDefineEntity)cacheService.get(bid + "_" + vid + "_" + methodName);
                    if (entity == null) {
                        entity = this.magicInterfaceDefineDao.loadDefineById(bid, vid, methodName);
                    }
                    if (entity == null) continue;
                    cacheService.put(bid + "_" + vid + "_" + methodName, entity);
                    if (!MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(entity.getSubType()) && !MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(entity.getSubType())) continue;
                    providerPO = (MagicServiceProviderPO)cacheProvider.get(entity.getId());
                    if (providerPO == null && (providerPO = this.magicProviderDao.loadProviders(bid, vid, MagicEnums.ProviderStatus.ON)) != null) {
                        cacheProvider.put(entity.getId(), providerPO);
                    }
                    checkResult.addAll(this.checkMagicChangeFormTrigger(fb, action, entity, providerPO));
                }
            }
        }
        view.addObject("checkResult", checkResult);
        return view;
    }

    private CheckMagicResult checkMagicByField(Map<String, Object> itemLists, MagicFormFieldBean fieldBean) {
        CheckMagicResult result = new CheckMagicResult();
        if (fieldBean.isNull()) {
            result.setChangeType("\u5b57\u6bb5\u5df2\u88ab\u5220\u9664");
            result.setOldValue("");
            result.setNewValue("");
            return result;
        }
        result.setTargetFieldName(fieldBean.getDisplay());
        String inputType = ParamUtil.getString(itemLists, (String)"inputType", (String)"");
        String inputTypeText = ParamUtil.getString(itemLists, (String)"inputTypeText", (String)"");
        String fieldType = ParamUtil.getString(itemLists, (String)"fieldType", (String)"");
        String enumLevel = ParamUtil.getString(itemLists, (String)"enumLevel", (String)"");
        String isFinalChild = ParamUtil.getString(itemLists, (String)"isFinalChild", (String)"");
        String fieldLength = ParamUtil.getString(itemLists, (String)"fieldLength", (String)"");
        String digitNum = ParamUtil.getString(itemLists, (String)"digitNum", (String)"");
        String enumId = ParamUtil.getString(itemLists, (String)"value", (String)"");
        if (!inputType.equals(fieldBean.getInputType())) {
            result.setChangeType(ResourceUtil.getString((String)"cap4.form.business.opera.controltype"));
            result.setOldValue(inputTypeText);
            result.setNewValue(fieldBean.getInputTypeText());
            return result;
        }
        if (!fieldType.equals(fieldBean.getFieldType())) {
            result.setChangeType(ResourceUtil.getString((String)"cap4.form.business.opera.fieldtype"));
            Enums.FieldType oldType = Enums.FieldType.getEnumByKey((String)fieldType);
            Enums.FieldType newType = Enums.FieldType.getEnumByKey((String)fieldBean.getFieldType());
            result.setOldValue(oldType == null ? fieldType : oldType.getText());
            result.setNewValue(newType == null ? fieldBean.getFieldType() : newType.getText());
            return result;
        }
        if (!fieldLength.equals(fieldBean.getFieldLength())) {
            result.setChangeType(ResourceUtil.getString((String)"cap4.form.business.opera.fieldlength"));
            result.setOldValue(fieldLength);
            result.setNewValue(fieldBean.getFieldLength());
            return result;
        }
        if ("select".equalsIgnoreCase(inputType) || "imageselect".equalsIgnoreCase(inputType) || "radio".equalsIgnoreCase(inputType) || "imageradio".equalsIgnoreCase(inputType)) {
            CtpEnumBean oldEnum = this.enumManagerNew.getEnum(Long.valueOf(Long.parseLong(enumId)));
            CtpEnumBean newEnum = this.enumManagerNew.getEnum(Long.valueOf(fieldBean.getEnumId()));
            if (!enumId.equals(fieldBean.getEnumId() + "")) {
                result.setChangeType(ResourceUtil.getString((String)"cap.bizSetup.basedata.enums") + "ID");
                result.setOldValue(oldEnum != null ? oldEnum.getLabel() : enumId);
                result.setNewValue(newEnum != null ? newEnum.getLabel() : fieldBean.getEnumId() + "");
                return result;
            }
            if (!enumLevel.equals(fieldBean.getEnumLevel() + "")) {
                result.setChangeType(ResourceUtil.getString((String)"form.formenum.enumlevel"));
                result.setOldValue(oldEnum != null ? oldEnum.getLabel() + "[\u5c42\u7ea7]\u4e3a" + enumLevel : enumId + "[\u5c42\u7ea7]\u4e3a" + enumLevel);
                result.setNewValue(newEnum != null ? newEnum.getLabel() + "[\u5c42\u7ea7]\u4e3a" + fieldBean.getEnumLevel() : fieldBean.getEnumId() + "[\u5c42\u7ea7]\u4e3a" + enumLevel);
                return result;
            }
            if (!isFinalChild.equals(fieldBean.getIsFinalChild() ? "1" : "0")) {
                result.setChangeType("\u662f\u5426\u672b\u7ea7\u679a\u4e3e");
                result.setOldValue((oldEnum != null ? oldEnum.getLabel() : enumId) + ("1".equals(isFinalChild) ? "\u662f\u672b\u7ea7\u679a\u4e3e" : "\u4e0d\u662f\u672b\u7ea7\u679a\u4e3e"));
                result.setNewValue((newEnum != null ? newEnum.getLabel() : Long.valueOf(fieldBean.getEnumId())) + (fieldBean.getIsFinalChild() ? "\u662f\u672b\u7ea7\u679a\u4e3e" : "\u4e0d\u662f\u672b\u7ea7\u679a\u4e3e"));
                return result;
            }
        }
        if ("DECIMAL".equalsIgnoreCase(fieldType) && !digitNum.equals(fieldBean.getDigitNum())) {
            result.setChangeType("\u5c0f\u6570\u4f4d\u957f\u5ea6");
            result.setOldValue(fieldLength);
            result.setNewValue(fieldBean.getFieldLength());
            return result;
        }
        return null;
    }

    private List<Map<String, String>> checkMagicChangeFormTrigger(com.seeyon.cap4.form.bean.FormBean sourceFormBean, FormTriggerActionBean actionBean, MagicInterfaceDefineEntity entity, MagicServiceProviderPO providerPO) throws BusinessException {
        MagicFormFieldBean fieldBean;
        Map itemLists;
        String limitStr;
        LinkedList<Map<String, String>> result = new LinkedList<Map<String, String>>();
        List fillBackList = (List)actionBean.getParam(FormTriggerBean.ActionParam.FillBack.getKey());
        Map extMapper = (Map)JSONUtil.parseJSONString((String)entity.getExt1(), Map.class);
        if (extMapper == null) {
            return result;
        }
        Map fieldLimit = (Map)extMapper.get("fieldLimit");
        if (fieldLimit == null) {
            return result;
        }
        if (providerPO == null || !MagicPrivateUtils.isNumeric(providerPO.getSource())) {
            return result;
        }
        MagicFormBean fb = new MagicFormBean(MagicEnums.ServiceOwnerType.getEnumByType((String)providerPO.getSourceType()), Long.parseLong(providerPO.getSource()));
        if (fb.isNull()) {
            return result;
        }
        for (SimpleObjectBean fill : fillBackList) {
            String name = fill.getName();
            String string = name.split("[.]")[1];
            String type = fill.getType();
            limitStr = ParamUtil.getString((Map)fieldLimit, (String)string, null);
            if (Strings.isBlank((String)limitStr) || (itemLists = (Map)JSONUtil.parseJSONString((String)limitStr, Map.class)) == null) continue;
            fieldBean = fb.getFieldBeanByName(string);
            String display = ParamUtil.getString((Map)itemLists, (String)"displayName", (String)"");
            CheckMagicResult cmr = this.checkMagicByField(itemLists, fieldBean);
            if (cmr == null) continue;
            cmr.setSourceFormName(sourceFormBean.getFormName());
            cmr.setSourceFormID(sourceFormBean.getId());
            cmr.setRelationType(ResourceUtil.getString((String)"form.businesstype.type.trigger"));
            cmr.setRelationName(actionBean.getFormTriggerBean().getName());
            cmr.setTargetFormName(fb.getFormName() + (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(fb.getType().getType()) ? "(CAP3)" : ""));
            if (FormTriggerBean.FillBackType.formula.getKey().equals(type)) {
                FormFormulaBean formula = (FormFormulaBean)fill.getExtraAttr(fill.getValue());
                if (formula == null) {
                    formula = this.cap4FormCacheManager.loadFormFormulaBean(sourceFormBean, Long.valueOf(fill.getValue()));
                }
                if (formula != null) {
                    cmr.setSourceFieldName(formula.getFormulaForDisplay());
                }
                cmr.setSourceFieldType("\u8ba1\u7b97\u516c\u5f0f");
            } else {
                String fieldValue = fill.getValue().split("[.]")[1];
                FormFieldBean ffb = sourceFormBean.getFieldBeanByName(fieldValue);
                cmr.setSourceFieldName(ffb != null ? ffb.getDisplay() : fieldValue);
                cmr.setSourceFieldType(ffb != null ? ffb.getInputTypeEnum().getText() : "");
            }
            cmr.setServiceFieldName(display);
            result.add(cmr.toJson());
        }
        String type = ParamUtil.getString((Map)actionBean.getParam(), (String)"triggerType");
        if (FormTriggerBean.TriggerType.Update.getKey().equals(type) || FormTriggerBean.TriggerType.Cap4UpdateCap3.getKey().equals(type)) {
            List holdingFields;
            Map relationCondition = actionBean.getRelationConditionMap();
            if (relationCondition != null) {
                for (Map.Entry entry : relationCondition.entrySet()) {
                    CheckMagicResult cmr;
                    String fieldNames = (String)entry.getKey();
                    limitStr = ParamUtil.getString((Map)fieldLimit, (String)fieldNames, null);
                    if (Strings.isBlank((String)limitStr) || (itemLists = (Map)JSONUtil.parseJSONString((String)limitStr, Map.class)) == null || (cmr = this.checkMagicByField(itemLists, fieldBean = fb.getFieldBeanByName(fieldNames))) == null) continue;
                    String display = ParamUtil.getString((Map)itemLists, (String)"displayName", (String)"");
                    cmr.setSourceFormName(sourceFormBean.getFormName());
                    cmr.setSourceFormID(sourceFormBean.getId());
                    cmr.setRelationType("\u89e6\u53d1");
                    cmr.setRelationName(actionBean.getFormTriggerBean().getName());
                    cmr.setTargetFormName(fb.getFormName() + (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(fb.getType().getType()) ? "(CAP3)" : ""));
                    FormFieldBean ffb = sourceFormBean.getFieldBeanByName((String)entry.getValue());
                    cmr.setSourceFieldName(ffb != null ? ffb.getDisplay() : (String)entry.getValue());
                    cmr.setSourceFieldType(ffb != null ? ffb.getInputTypeEnum().getText() : "");
                    cmr.setServiceFieldName(display);
                    result.add(cmr.toJson());
                }
            }
            if ((holdingFields = actionBean.getWithHoldingFields()) != null && !holdingFields.isEmpty()) {
                for (SimpleObjectBean sob : holdingFields) {
                    MagicFormFieldBean fieldBean2;
                    CheckMagicResult cmr;
                    Map itemLists2;
                    String name = sob.getName();
                    String[] nameArray = name.split("[.]");
                    String limitStr2 = ParamUtil.getString((Map)fieldLimit, (String)nameArray[1], null);
                    if (Strings.isBlank((String)limitStr2) || (itemLists2 = (Map)JSONUtil.parseJSONString((String)limitStr2, Map.class)) == null || (cmr = this.checkMagicByField(itemLists2, fieldBean2 = fb.getFieldBeanByName(nameArray[1]))) == null) continue;
                    String display = ParamUtil.getString((Map)itemLists2, (String)"displayName", (String)"");
                    cmr.setSourceFormName(sourceFormBean.getFormName());
                    cmr.setSourceFormID(sourceFormBean.getId());
                    cmr.setRelationType("\u89e6\u53d1");
                    cmr.setRelationName(actionBean.getFormTriggerBean().getName());
                    cmr.setTargetFormName(fb.getFormName() + (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(fb.getType().getType()) ? "(CAP3)" : ""));
                    cmr.setSourceFieldName("\u9884\u63d0");
                    cmr.setServiceFieldName(display);
                    result.add(cmr.toJson());
                }
            }
        }
        return result;
    }

    private List<Map<String, String>> checkMagicChangeFormRelation(com.seeyon.cap4.form.bean.FormBean sourceFormBean, FormRelationshipMapBean shipMap, MagicInterfaceDefineEntity entity, MagicServiceProviderPO providerPO) {
        CheckMagicResult cmr;
        String display;
        MagicFormFieldBean fieldBean;
        FormFieldBean sourceFieldBean;
        Map itemLists;
        String limitStr;
        LinkedList<Map<String, String>> result = new LinkedList<Map<String, String>>();
        Map extMapper = (Map)JSONUtil.parseJSONString((String)entity.getExt1(), Map.class);
        Map fieldLimit = (Map)extMapper.get("fieldLimit");
        if (providerPO == null || !MagicPrivateUtils.isNumeric(providerPO.getSource())) {
            return result;
        }
        MagicFormBean fb = new MagicFormBean(MagicEnums.ServiceOwnerType.getEnumByType((String)providerPO.getSourceType()), Long.parseLong(providerPO.getSource()));
        if (fb.isNull()) {
            return result;
        }
        if (shipMap.getRelationshipBean().getRelationType() == 2) {
            Map conditionMap = FormUtil.getRelationFormulaFieldMap((FormFormulaBean)shipMap.getConditionFormula());
            for (Map.Entry entry : conditionMap.entrySet()) {
                String fieldName = (String)entry.getValue();
                limitStr = ParamUtil.getString((Map)fieldLimit, (String)fieldName, null);
                if (Strings.isBlank((String)limitStr) || (itemLists = (Map)JSONUtil.parseJSONString((String)limitStr, Map.class)) == null) continue;
                sourceFieldBean = sourceFormBean.getFieldBeanByName((String)entry.getKey());
                fieldBean = fb.getFieldBeanByName(fieldName);
                display = ParamUtil.getString((Map)itemLists, (String)"displayName", (String)"");
                cmr = this.checkMagicByField(itemLists, fieldBean);
                if (cmr == null) continue;
                cmr.setSourceFormName(sourceFormBean.getFormName());
                cmr.setSourceFieldType(sourceFieldBean != null ? sourceFieldBean.getInputTypeEnum().getText() : "");
                cmr.setSourceFieldName(sourceFieldBean != null ? sourceFieldBean.getDisplay() : "");
                cmr.setTargetFormName(fb.getFormName() + (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(fb.getType().getType()) ? "(CAP3)" : ""));
                cmr.setSourceFormID(sourceFormBean.getId());
                cmr.setRelationType(ResourceUtil.getString((String)"form.businesstype.type.relation"));
                cmr.setRelationName(shipMap.getRelationshipBean().getName());
                cmr.setServiceFieldName(display);
                result.add(cmr.toJson());
            }
        }
        Map relationFieldMap = shipMap.getFormRelationFieldMap();
        for (Map.Entry temp : relationFieldMap.entrySet()) {
            String v = (String)temp.getValue();
            limitStr = ParamUtil.getString((Map)fieldLimit, (String)v, null);
            if (Strings.isBlank((String)limitStr) || (itemLists = (Map)JSONUtil.parseJSONString((String)limitStr, Map.class)) == null) continue;
            sourceFieldBean = sourceFormBean.getFieldBeanByName((String)temp.getKey());
            fieldBean = fb.getFieldBeanByName(v);
            display = ParamUtil.getString((Map)itemLists, (String)"displayName", (String)"");
            cmr = this.checkMagicByField(itemLists, fieldBean);
            if (cmr == null) continue;
            cmr.setSourceFormName(sourceFormBean.getFormName());
            cmr.setSourceFieldName(sourceFieldBean != null ? sourceFieldBean.getDisplay() : "");
            cmr.setSourceFieldType(sourceFieldBean == null ? "" : sourceFieldBean.getInputTypeEnum().getText());
            cmr.setTargetFormName(fb.getFormName() + (MagicEnums.ServiceOwnerType.DEFAULT_FORM_CAP3.getType().equals(fb.getType().getType()) ? "(CAP3)" : ""));
            cmr.setSourceFormID(sourceFormBean.getId());
            cmr.setRelationType(ResourceUtil.getString((String)"form.businesstype.type.relation"));
            cmr.setRelationName(shipMap.getRelationshipBean().getName());
            cmr.setServiceFieldName(display);
            result.add(cmr.toJson());
        }
        return result;
    }

    public ModelAndView setRelationSelector(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result = new ModelAndView("cap4/magic/config/setRelationSelector");
        return result;
    }

    public ModelAndView interfaceShopList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result = new ModelAndView("cap4/magic/interface/shopList");
        return result;
    }

    public ModelAndView interfaceShopDetail(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result = new ModelAndView("cap4/magic/interface/shopDetail");
        return result;
    }

    public ModelAndView setAttributeValue(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/magic/config/setAttributeValue");
        long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L);
        com.seeyon.cap4.form.bean.FormBean form = this.cap4FormManager.getForm(formId);
        LinkedList<FormFieldBean> fieldList = new LinkedList<FormFieldBean>();
        for (FormFieldBean f : form.getAllFieldBeans()) {
            if (f.isCustomerCtrl()) continue;
            fieldList.add(f);
        }
        LinkedHashMap<String, String> org = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> date = new LinkedHashMap<String, String>();
        for (FormulaEnums.FormulaVar e : FormulaEnums.FormulaVar.values()) {
            if (e.getKey().startsWith("org_")) {
                org.put(e.getKey(), e.getText());
                continue;
            }
            if (!e.getKey().startsWith("date_")) continue;
            date.put(e.getKey(), e.getText());
        }
        LinkedHashMap<String, String> sys = new LinkedHashMap<String, String>();
        int formType = form.getFormType();
        for (FormulaEnums.SystemDataField e : FormulaEnums.SystemDataField.values()) {
            if (e == FormulaEnums.SystemDataField.approvalState || e == FormulaEnums.SystemDataField.ratifyState || e == FormulaEnums.SystemDataField.flowState || !e.isSupport(formType)) continue;
            sys.put(e.getKey(), e.getText());
        }
        List numberList = this.formCacheManager.getAccountUnuseSerialNumberList(form.getId().longValue());
        String tipStr = "";
        for (FormFieldComEnum e : FormFieldComEnum.values()) {
            FormFieldCtrl tempCtrl = FormFieldUtil.getFormFieldCtrl((String)e.getKey());
            if (null == tempCtrl || !tempCtrl.canExtend()) continue;
            tipStr = tipStr + ResourceUtil.getStringByParams((String)e.getText(), (Object[])new Object[0]) + "\u3001";
        }
        tipStr = tipStr.substring(0, tipStr.length() - 1);
        modelAndView.addObject("form", (Object)form);
        modelAndView.addObject("formId", (Object)formId);
        modelAndView.addObject("fieldList", fieldList);
        modelAndView.addObject("org", org);
        modelAndView.addObject("date", date);
        modelAndView.addObject("sys", sys);
        modelAndView.addObject("numberList", (Object)numberList);
        modelAndView.addObject("tipStr", (Object)tipStr);
        modelAndView.addObject("isAdvanced", (Object)true);
        modelAndView.addObject("qsType", (Object)ReqUtil.getString((HttpServletRequest)request, (String)"qsType", (String)"0"));
        return modelAndView;
    }

    private void download(HttpServletResponse response, File toFile) throws Exception {
        FileInputStream fis = new FileInputStream(toFile);
        String filename = toFile.getName();
        response.reset();
        response.addHeader("content-disposition", "attachment; filename=" + filename);
        response.addHeader("Content-Length", "" + toFile.length());
        response.setContentType("application/octet-stream");
        IOUtility.copy((InputStream)fis, (OutputStream)response.getOutputStream());
    }

    public ModelAndView downloadCodeZip(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long serviceId = ReqUtil.getLong((HttpServletRequest)request, (String)"serviceId", (long)0L);
        IMagicCompilerManager magicCompilerManager = (IMagicCompilerManager)AppContext.getBean((String)"magicCompilerManager");
        MagicServiceSummary summary = AbstractMagicHandleService.getCacheServiceSummary(serviceId);
        List<MagicInterfaceDefineEntity> methodList = AbstractMagicHandleService.getCacheMethodList(serviceId);
        if (summary != null || methodList != null) {
            String toFileName = magicCompilerManager.createCodeZip(summary, methodList);
            File toFile = new File(toFileName);
            this.download(response, toFile);
        }
        AbstractMagicHandleService.removeCacheByServiceID(serviceId);
        return null;
    }

    public ModelAndView countDetail(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        HashMap params = new HashMap();
        ModelAndView mav = new ModelAndView("cap4/magic/interface/countDetail", params);
        return mav;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public CAP4FormCustomFunctionManager getCap4FormCustomFunctionManager() {
        return this.cap4FormCustomFunctionManager;
    }

    public void setCap4FormCustomFunctionManager(CAP4FormCustomFunctionManager cap4FormCustomFunctionManager) {
        this.cap4FormCustomFunctionManager = cap4FormCustomFunctionManager;
    }

    public FormCacheManager getFormCacheManager() {
        return this.formCacheManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public BusinessManager getBusinessManager4() {
        return this.businessManager4;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public ICAP4MagicManager getCap4MagicManager() {
        return this.cap4MagicManager;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }

    public EnumManager getEnumManagerNew() {
        return this.enumManagerNew;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }

    public IMagicAjaxHandleService getMagicAjaxHandleService() {
        return this.magicAjaxHandleService;
    }

    public void setMagicAjaxHandleService(IMagicAjaxHandleService magicAjaxHandleService) {
        this.magicAjaxHandleService = magicAjaxHandleService;
    }

    public IMagicExportManager getMagicExternalExportManager() {
        return this.magicExternalExportManager;
    }

    public void setMagicExternalExportManager(IMagicExportManager magicExternalExportManager) {
        this.magicExternalExportManager = magicExternalExportManager;
    }

    class CheckMagicResult {
        private String sourceFormName;
        private String targetFormName;
        private String sourceFieldType;
        private Long sourceFormID;
        private String relationType;
        private String relationName;
        private String oldValue;
        private String newValue;
        private String changeType;
        private String sourceFieldName;
        private String serviceFieldName;
        private String targetFieldName;

        CheckMagicResult() {
        }

        public String getSourceFormName() {
            return this.sourceFormName;
        }

        public void setSourceFormName(String sourceFormName) {
            this.sourceFormName = sourceFormName;
        }

        public String getChangeType() {
            return this.changeType;
        }

        public void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        public Long getSourceFormID() {
            return this.sourceFormID;
        }

        public void setSourceFormID(Long sourceFormID) {
            this.sourceFormID = sourceFormID;
        }

        public String getRelationType() {
            return this.relationType;
        }

        public void setRelationType(String relationType) {
            this.relationType = relationType;
        }

        public String getRelationName() {
            return this.relationName;
        }

        public void setRelationName(String relationName) {
            this.relationName = relationName;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public void setOldValue(String oldValue) {
            this.oldValue = oldValue;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public void setNewValue(String newValue) {
            this.newValue = newValue;
        }

        public String getSourceFieldName() {
            return this.sourceFieldName;
        }

        public void setSourceFieldName(String sourceFieldName) {
            this.sourceFieldName = sourceFieldName;
        }

        public String getServiceFieldName() {
            return this.serviceFieldName;
        }

        public void setServiceFieldName(String serviceFieldName) {
            this.serviceFieldName = serviceFieldName;
        }

        public String getTargetFieldName() {
            return this.targetFieldName;
        }

        public void setTargetFieldName(String targetFieldName) {
            this.targetFieldName = targetFieldName;
        }

        public String getTargetFormName() {
            return this.targetFormName;
        }

        public void setTargetFormName(String targetFormName) {
            this.targetFormName = targetFormName;
        }

        public String getSourceFieldType() {
            return this.sourceFieldType;
        }

        public void setSourceFieldType(String sourceFieldType) {
            this.sourceFieldType = sourceFieldType;
        }

        public Map<String, String> toJson() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sourceFormName", this.sourceFormName);
            map.put("targetFormName", this.targetFormName);
            map.put("sourceFormID", String.valueOf(this.sourceFormID));
            map.put("relationType", this.relationType);
            map.put("relationName", this.relationName);
            map.put("oldValue", this.oldValue);
            map.put("newValue", this.newValue);
            map.put("changeType", this.changeType);
            map.put("sourceFieldName", this.sourceFieldName);
            map.put("serviceFieldName", this.serviceFieldName);
            map.put("targetFieldName", this.targetFieldName);
            map.put("sourceFieldType", this.sourceFieldType);
            return map;
        }
    }
}

