/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.convertor;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.magic.convertor.ConvertResult;
import com.seeyon.cap4.magic.convertor.ConvertorEnums;
import com.seeyon.cap4.magic.convertor.ConvertorException;
import com.seeyon.cap4.magic.convertor.ConvertorType;
import com.seeyon.cap4.magic.convertor.MagicConvertor;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicServiceDetail;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.lbs.manager.LbsManager;
import com.seeyon.ctp.common.lbs.vo.AttendanceListItem;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumBean;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgEntity;
import com.seeyon.ctp.organization.bo.V3xOrgLevel;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgPost;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public abstract class MagicConvertorFactory
implements MagicConvertor {
    private EnumManager enumManagerNew;
    private OrgManager orgManager;
    private LbsManager lbsManager;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private MagicServiceDetail detail;
    private CAP4FormCacheManager cap4FormCacheManager;
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private static final Log LOGGER = CtpLogFactory.getLog(MagicConvertorFactory.class);
    Map<String, ConvertorType> targetConvertDataType = new HashMap<String, ConvertorType>();

    protected MagicConvertorFactory(String businessID, String versionID, String methodName) {
        this.enumManagerNew = (EnumManager)AppContext.getBean((String)"enumManagerNew");
        this.orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        this.lbsManager = (LbsManager)AppContext.getBean((String)"lbsManager");
        this.magicInterfaceDefineDao = (IMagicInterfaceDefineDao)AppContext.getBean((String)"magicInterfaceDefineDao");
        this.cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        this.magicServiceSummaryDao = (IMagicServiceSummaryDao)AppContext.getBean((String)"magicServiceSummaryDao");
        try {
            MagicInterfaceDefineEntity entity = this.magicInterfaceDefineDao.loadDefineById(businessID, versionID, methodName);
            if (entity != null) {
                this.detail = MagicPrivateUtils.convert(this.magicServiceSummaryDao.loadServiceInfo(businessID, versionID), entity);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e);
        }
    }

    protected void initTargetFieldMapper(long formId) {
        FormBean targetFormBean = this.cap4FormCacheManager.getForm(formId);
        if (targetFormBean != null) {
            List allFieldBean = targetFormBean.getAllFieldBeans();
            for (FormFieldBean ffb : allFieldBean) {
                ConvertorType ct = new ConvertorType();
                ct.setInputType(ffb.getInputType());
                ct.setFieldType(ffb.getFieldType());
                ct.setEnumLevel(String.valueOf(ffb.getEnumLevel()));
                ct.setEnumValue(String.valueOf(ffb.getEnumId()));
                String digitNum = ffb.getDigitNum();
                if (Strings.isBlank((String)digitNum)) {
                    ct.setDigitNum(0);
                } else {
                    ct.setDigitNum(Integer.parseInt(digitNum));
                }
                String length = ffb.getFieldLength();
                if (Strings.isBlank((String)length)) {
                    ct.setLength(0);
                } else {
                    ct.setLength(Integer.parseInt(length));
                }
                this.targetConvertDataType.put(ffb.getName(), ct);
            }
        }
    }

    protected boolean needConvert(ConvertorType rawDataType, ConvertorType targetDataType) {
        if (rawDataType == null || targetDataType == null) {
            return false;
        }
        int rawDigitNum = rawDataType.getDigitNum();
        String rawFieldType = rawDataType.getFieldType();
        String rawInputType = rawDataType.getInputType();
        int rawlength = rawDataType.getLength();
        int targetDigitNum = targetDataType.getDigitNum();
        String targetFieldType = targetDataType.getFieldType();
        String targetInputType = targetDataType.getInputType();
        int targetlength = targetDataType.getLength();
        if (Strings.isBlank((String)rawFieldType) || Strings.isBlank((String)targetFieldType) || Strings.isBlank((String)rawInputType) || Strings.isBlank((String)targetInputType)) {
            return false;
        }
        if (!targetFieldType.equals(rawFieldType)) {
            return true;
        }
        if (!targetInputType.equals(rawInputType)) {
            return true;
        }
        if (FormFieldComEnum.RADIO.getKey().equals(targetInputType) || FormFieldComEnum.IMAGE_RADIO.getKey().equals(targetInputType) || FormFieldComEnum.SELECT.getKey().equals(targetInputType) || FormFieldComEnum.IMAGE_SELECT.getKey().equals(targetInputType)) {
            String targetEnumValue = targetDataType.getEnumValue();
            String rawEnumValue = rawDataType.getEnumValue();
            return rawEnumValue == null || !rawEnumValue.equals(targetEnumValue);
        }
        if (targetlength < rawlength) {
            return true;
        }
        return "DECIMAL".equals(targetFieldType) && targetDigitNum < rawDigitNum;
    }

    protected Object convertToEnum(Object rawData, ConvertorType rawDataType, ConvertorType targetDataType) throws ConvertorException, BusinessException {
        if (rawData == null) {
            return null;
        }
        String inputType = rawDataType.getInputType();
        String enumValue = targetDataType.getEnumValue();
        FormFieldComEnum ffcm = FormFieldComEnum.getEnumByKey((String)inputType);
        Object result = null;
        if (ffcm == null) {
            return result;
        }
        switch (ffcm) {
            case TEXT: 
            case TEXTAREA: {
                Long enumId = 0L;
                try {
                    enumId = Long.parseLong(enumValue);
                    CtpEnumBean allEnums = this.enumManagerNew.getEnum(enumId);
                    if (allEnums == null) break;
                    for (CtpEnumItem items : allEnums.getItems()) {
                        if (!items.getShowvalue().equals(rawData.toString()) && !items.getId().toString().equals(rawData.toString())) continue;
                        result = items.getId();
                    }
                }
                catch (Exception allEnums) {}
                break;
            }
            case CHECKBOX: {
                break;
            }
            case RADIO: 
            case IMAGE_RADIO: 
            case SELECT: 
            case IMAGE_SELECT: {
                if (rawDataType.getEnumValue() != null && rawDataType.getEnumValue().equals(targetDataType.getEnumValue())) {
                    result = rawData;
                    break;
                }
                CtpEnumItem item = this.enumManagerNew.getEnumItem(Long.valueOf(Long.parseLong(rawData.toString())));
                try {
                    Long enumId = Long.parseLong(enumValue);
                    CtpEnumBean allEnums = this.enumManagerNew.getEnum(enumId);
                    if (allEnums == null || item == null) break;
                    for (CtpEnumItem items : allEnums.getItems()) {
                        if (!items.getShowvalue().equals(item.getShowvalue())) continue;
                        result = items.getId();
                    }
                }
                catch (Exception exception) {}
                break;
            }
        }
        return result;
    }

    protected Object convertToDate(Object rawData, ConvertorType rawDataType, ConvertorType targetDataType) throws ConvertorException {
        if (rawData == null) {
            return null;
        }
        String inputType = rawDataType.getInputType();
        FormFieldComEnum ffcm = FormFieldComEnum.getEnumByKey((String)inputType);
        Object result = null;
        if (ffcm == null) {
            return result;
        }
        switch (ffcm) {
            case TEXT: 
            case TEXTAREA: 
            case CHECKBOX: 
            case RADIO: 
            case IMAGE_RADIO: 
            case SELECT: 
            case IMAGE_SELECT: {
                break;
            }
            case EXTEND_DATE: 
            case EXTEND_DATETIME: {
                result = rawData;
                break;
            }
        }
        return result;
    }

    protected Object convertToOrg(Object rawData, ConvertorType rawDataType, ConvertorType targetDataType) throws BusinessException {
        if (rawData == null) {
            return null;
        }
        String targetInputType = targetDataType.getInputType();
        String inputType = rawDataType.getInputType();
        FormFieldComEnum ffcm = FormFieldComEnum.getEnumByKey((String)inputType);
        Object result = null;
        if (ffcm == null) {
            return result;
        }
        block0 : switch (ffcm) {
            case TEXT: 
            case TEXTAREA: {
                if (FormFieldComEnum.EXTEND_MEMBER.getKey().equals(targetInputType)) {
                    List members = this.orgManager.getMemberByName(rawData.toString());
                    if (members == null) break;
                    result = ((V3xOrgMember)members.get(0)).getId();
                    break;
                }
                if (FormFieldComEnum.EXTEND_MULTI_MEMBER.getKey().equals(targetInputType)) {
                    List members = this.orgManager.getMemberByName(rawData.toString());
                    if (members == null) break;
                    ArrayList<Long> ids = new ArrayList<Long>();
                    for (V3xOrgMember m : members) {
                        ids.add(m.getId());
                    }
                    result = Strings.join(ids, (String)",");
                    break;
                }
                if (FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(targetInputType)) {
                    List accounts = this.orgManager.getAllAccounts();
                    for (V3xOrgAccount a : accounts) {
                        if (!a.getName().equals(rawData.toString())) continue;
                        result = a.getId();
                        break block0;
                    }
                    break;
                }
                if (FormFieldComEnum.EXTEND_MULTI_ACCOUNT.getKey().equals(targetInputType)) {
                    List accounts = this.orgManager.getAllAccounts();
                    ArrayList<Long> ids = new ArrayList<Long>();
                    for (V3xOrgAccount a : accounts) {
                        if (!a.getName().equals(rawData.toString())) continue;
                        ids.add(a.getId());
                    }
                    result = Strings.join(ids, (String)",");
                    break;
                }
                if (FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equals(targetInputType)) {
                    List departs = this.orgManager.getDepartmentsByName(rawData.toString(), Long.valueOf(AppContext.currentAccountId()));
                    if (departs.isEmpty()) break;
                    result = ((V3xOrgDepartment)departs.get(0)).getId();
                    break;
                }
                if (FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getKey().equals(targetInputType)) {
                    List departs = this.orgManager.getDepartmentsByName(rawData.toString(), Long.valueOf(AppContext.currentAccountId()));
                    ArrayList<Long> ids = new ArrayList<Long>();
                    for (V3xOrgDepartment d : departs) {
                        ids.add(d.getId());
                    }
                    result = Strings.join(ids, (String)",");
                    break;
                }
                if (FormFieldComEnum.EXTEND_POST.getKey().equals(targetInputType)) {
                    List posts = this.orgManager.getAllPosts(Long.valueOf(AppContext.currentAccountId()));
                    for (V3xOrgPost p : posts) {
                        if (!p.getName().equals(rawData.toString())) continue;
                        result = p.getId();
                        break block0;
                    }
                    break;
                }
                if (FormFieldComEnum.EXTEND_MULTI_POST.getKey().equals(targetInputType)) {
                    ArrayList<Long> ids = new ArrayList<Long>();
                    List posts = this.orgManager.getAllPosts(Long.valueOf(AppContext.currentAccountId()));
                    for (V3xOrgPost p : posts) {
                        if (!p.getName().equals(rawData.toString())) continue;
                        ids.add(p.getId());
                    }
                    result = Strings.join(ids, (String)",");
                    break;
                }
                if (FormFieldComEnum.EXTEND_LEVEL.getKey().equals(targetInputType)) {
                    List levels = this.orgManager.getAllLevels(Long.valueOf(AppContext.currentAccountId()));
                    for (V3xOrgLevel l : levels) {
                        if (!l.getName().equals(rawData.toString())) continue;
                        result = l.getId();
                        break block0;
                    }
                    break;
                }
                if (!FormFieldComEnum.EXTEND_MULTI_LEVEL.getKey().equals(targetInputType)) break;
                ArrayList<Long> ids = new ArrayList<Long>();
                List levels = this.orgManager.getAllLevels(Long.valueOf(AppContext.currentAccountId()));
                for (V3xOrgLevel l : levels) {
                    if (!l.getName().equals(rawData.toString())) continue;
                    ids.add(l.getId());
                }
                result = Strings.join(ids, (String)",");
                break;
            }
            case CHECKBOX: {
                break;
            }
            case RADIO: 
            case IMAGE_RADIO: 
            case SELECT: 
            case IMAGE_SELECT: 
            case EXTEND_DATE: 
            case EXTEND_DATETIME: 
            case FLOWDEALOPITION: 
            case LINE_NUMBER: {
                break;
            }
            case EXTEND_MEMBER: {
                if (FormFieldComEnum.EXTEND_MEMBER.getKey().equals(targetInputType) || FormFieldComEnum.EXTEND_MULTI_MEMBER.getKey().equals(targetInputType)) {
                    result = rawData;
                    break;
                }
                result = null;
                break;
            }
            case EXTEND_MULTI_MEMBER: {
                if (FormFieldComEnum.EXTEND_MULTI_MEMBER.getKey().equals(targetInputType)) {
                    result = rawData;
                    break;
                }
                if (FormFieldComEnum.EXTEND_MEMBER.getKey().equals(targetInputType)) {
                    result = rawData.toString().split(",")[0];
                    break;
                }
                result = null;
                break;
            }
            case EXTEND_ACCOUNT: {
                if (FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(targetInputType) || FormFieldComEnum.EXTEND_MULTI_ACCOUNT.getKey().equals(targetInputType)) {
                    result = rawData;
                    break;
                }
                result = null;
                break;
            }
            case EXTEND_MULTI_ACCOUNT: {
                if (FormFieldComEnum.EXTEND_MULTI_ACCOUNT.getKey().equals(targetInputType)) {
                    result = rawData;
                    break;
                }
                if (FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(targetInputType)) {
                    result = rawData.toString().split(",")[0];
                    break;
                }
                result = null;
                break;
            }
            case EXTEND_DEPARTMENT: {
                if (FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equals(targetInputType) || FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getKey().equals(targetInputType)) {
                    result = rawData;
                    break;
                }
                result = null;
                break;
            }
            case EXTEND_MULTI_DEPARTMENT: {
                if (FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getKey().equals(targetInputType)) {
                    result = rawData;
                    break;
                }
                if (FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equals(targetInputType)) {
                    result = rawData.toString().split(",")[0];
                    break;
                }
                result = null;
                break;
            }
            case EXTEND_POST: {
                if (FormFieldComEnum.EXTEND_POST.getKey().equals(targetInputType) || FormFieldComEnum.EXTEND_MULTI_POST.getKey().equals(targetInputType)) {
                    result = rawData;
                    break;
                }
                result = null;
                break;
            }
            case EXTEND_MULTI_POST: {
                if (FormFieldComEnum.EXTEND_MULTI_POST.getKey().equals(targetInputType)) {
                    result = rawData;
                    break;
                }
                if (FormFieldComEnum.EXTEND_POST.getKey().equals(targetInputType)) {
                    result = rawData.toString().split(",")[0];
                    break;
                }
                result = null;
                break;
            }
            case EXTEND_LEVEL: {
                if (FormFieldComEnum.EXTEND_LEVEL.getKey().equals(targetInputType) || FormFieldComEnum.EXTEND_MULTI_LEVEL.getKey().equals(targetInputType)) {
                    result = rawData;
                    break;
                }
                result = null;
                break;
            }
            case EXTEND_MULTI_LEVEL: {
                if (FormFieldComEnum.EXTEND_MULTI_LEVEL.getKey().equals(targetInputType)) {
                    result = rawData;
                    break;
                }
                if (FormFieldComEnum.EXTEND_LEVEL.getKey().equals(targetInputType)) {
                    result = rawData.toString().split(",")[0];
                    break;
                }
                result = null;
                break;
            }
            case EXTEND_ATTACHMENT: 
            case EXTEND_IMAGE: 
            case EXTEND_DOCUMENT: {
                break;
            }
        }
        return result;
    }

    protected Object convertToNumber(Object rawData, ConvertorType rawDataType, ConvertorType targetDataType) throws ConvertorException {
        if (rawData == null) {
            return null;
        }
        String inputType = rawDataType.getInputType();
        int targetDigitNum = targetDataType.getDigitNum();
        FormFieldComEnum ffcm = FormFieldComEnum.getEnumByKey((String)inputType);
        BigDecimal result = null;
        if (ffcm == null) {
            return result;
        }
        switch (ffcm) {
            case TEXT: 
            case TEXTAREA: {
                try {
                    BigDecimal b = new BigDecimal(rawData.toString());
                    result = b.setScale(targetDigitNum, 1);
                    break;
                }
                catch (NumberFormatException e) {
                    ConvertorEnums.ErrorType type = ConvertorEnums.ErrorType.CONVERT_ERROR;
                    throw new ConvertorException(type, "\u65e0\u6cd5\u5c06 " + rawData + "\u8f6c\u6362\u6210\u6570\u5b57");
                }
            }
            case CHECKBOX: 
            case RADIO: 
            case IMAGE_RADIO: 
            case SELECT: 
            case IMAGE_SELECT: {
                result = new BigDecimal(rawData.toString());
                break;
            }
            case EXTEND_DATE: 
            case EXTEND_DATETIME: 
            case FLOWDEALOPITION: 
            case LINE_NUMBER: {
                break;
            }
            case EXTEND_MEMBER: {
                result = new BigDecimal(rawData.toString());
                break;
            }
            case EXTEND_MULTI_MEMBER: {
                break;
            }
            case EXTEND_ACCOUNT: {
                result = new BigDecimal(rawData.toString());
                break;
            }
            case EXTEND_MULTI_ACCOUNT: {
                break;
            }
            case EXTEND_DEPARTMENT: {
                result = new BigDecimal(rawData.toString());
                break;
            }
            case EXTEND_MULTI_DEPARTMENT: {
                break;
            }
            case EXTEND_POST: {
                result = new BigDecimal(rawData.toString());
                break;
            }
            case EXTEND_MULTI_POST: {
                result = new BigDecimal(rawData.toString());
                break;
            }
            case EXTEND_LEVEL: {
                result = new BigDecimal(rawData.toString());
                break;
            }
            case EXTEND_MULTI_LEVEL: {
                break;
            }
            case EXTEND_ATTACHMENT: 
            case EXTEND_IMAGE: 
            case EXTEND_DOCUMENT: {
                break;
            }
            case MAP_MARKED: 
            case MAP_LOCATE: 
            case MAP_PHOTO: {
                result = new BigDecimal(rawData.toString());
                break;
            }
        }
        return result;
    }

    protected Object convertToText(Object rawData, ConvertorType rawDataType, ConvertorType targetDataType) throws BusinessException {
        if (rawData == null) {
            return null;
        }
        int targetLength = targetDataType.getLength();
        int rawLength = rawDataType.getLength();
        String inputType = rawDataType.getInputType();
        FormFieldComEnum ffcm = FormFieldComEnum.getEnumByKey((String)inputType);
        Object result = rawData;
        if (ffcm == null) {
            return result;
        }
        switch (ffcm) {
            case TEXT: 
            case TEXTAREA: {
                String temp = rawData.toString();
                if (temp.length() < targetLength) {
                    result = temp;
                    break;
                }
                if (targetLength >= rawLength) break;
                result = temp.substring(0, targetLength);
                break;
            }
            case CHECKBOX: {
                result = rawData.toString();
                break;
            }
            case RADIO: 
            case IMAGE_RADIO: 
            case SELECT: 
            case IMAGE_SELECT: {
                String data = this.enumManagerNew.getEItemNameById(Long.valueOf(Long.parseLong(rawData.toString())));
                if (data != null && data.length() > targetLength) {
                    result = data.substring(0, targetLength);
                    break;
                }
                result = data;
                break;
            }
            case EXTEND_DATE: 
            case EXTEND_DATETIME: {
                result = rawData instanceof Date ? DateUtil.format((Date)((Date)rawData)) : (rawData instanceof Long ? DateUtil.format((Date)new Date((Long)rawData)) : rawData.toString());
                if (result == null || result.toString().length() <= targetLength) break;
                result = result.toString().substring(0, targetLength);
                break;
            }
            case FLOWDEALOPITION: 
            case LINE_NUMBER: {
                if (rawData.toString().length() > targetLength) {
                    result = rawData.toString().substring(0, targetLength);
                    break;
                }
                result = rawData.toString();
                break;
            }
            case EXTEND_MEMBER: 
            case EXTEND_MULTI_MEMBER: 
            case EXTEND_ACCOUNT: 
            case EXTEND_MULTI_ACCOUNT: 
            case EXTEND_DEPARTMENT: 
            case EXTEND_MULTI_DEPARTMENT: 
            case EXTEND_POST: 
            case EXTEND_MULTI_POST: 
            case EXTEND_LEVEL: 
            case EXTEND_MULTI_LEVEL: {
                String ids = rawData.toString();
                String[] idsArray = ids.split(",");
                ArrayList<String> names = new ArrayList<String>(idsArray.length);
                for (int x = 0; x < idsArray.length; ++x) {
                    Long id = Long.parseLong(idsArray[x]);
                    V3xOrgEntity e = this.orgManager.getEntityOnlyById(id);
                    if (e == null) continue;
                    names.add(e.getName());
                }
                result = Strings.join(names, (String)",");
                if (result == null || result.toString().length() <= targetLength) break;
                result = result.toString().substring(0, targetLength);
                break;
            }
            case EXTEND_ATTACHMENT: 
            case EXTEND_IMAGE: 
            case EXTEND_DOCUMENT: {
                result = null;
                break;
            }
            case MAP_MARKED: 
            case MAP_LOCATE: {
                String id = rawData.toString();
                AttendanceListItem lbsItem = this.lbsManager.getAttendanceInfoById(Long.parseLong(id));
                if (lbsItem != null) {
                    result = lbsItem.getLbsAddr();
                    if (result == null || result.toString().length() <= targetLength) break;
                    result = result.toString().substring(0, targetLength);
                    break;
                }
                result = null;
                break;
            }
            case MAP_PHOTO: 
            case CUSTOM_CONTROL: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public void init(String businessId, String versionId, String methodName) {
    }

    @Override
    public ConvertResult convertArgs(Object rawData, ConvertorType rawDataType, String fieldName) throws ConvertorException {
        ConvertorType targetType = this.targetConvertDataType.get(fieldName);
        boolean needConvert = this.needConvert(rawDataType, targetType);
        ConvertResult result = new ConvertResult();
        result.setSource(rawData);
        result.setRawDataType(rawDataType);
        result.setTargetDataType(targetType);
        result.setNeedConvert(needConvert);
        result.setData(rawData);
        if (needConvert) {
            return this.convert(rawData, rawDataType, targetType);
        }
        return result;
    }

    @Override
    public ConvertResult convertResult(Object rawData, String fieldName, ConvertorType targetFieldType) throws ConvertorException {
        ConvertorType rawDataType = this.targetConvertDataType.get(fieldName);
        boolean needConvert = this.needConvert(rawDataType, targetFieldType);
        ConvertResult result = new ConvertResult();
        result.setRawDataType(rawDataType);
        result.setTargetDataType(targetFieldType);
        result.setNeedConvert(needConvert);
        result.setSource(rawData);
        if (needConvert) {
            return this.convert(rawData, rawDataType, targetFieldType);
        }
        result.setData(rawData);
        return result;
    }

    @Override
    public ConvertResult convert(Object rawData, ConvertorType rawDataType, ConvertorType targetDataType) throws ConvertorException {
        ConvertResult results = new ConvertResult();
        results.setRawDataType(rawDataType);
        results.setTargetDataType(targetDataType);
        results.setNeedConvert(true);
        results.setSource(rawData);
        if (rawData == null || !this.needConvert(rawDataType, targetDataType)) {
            results.setData(rawData);
            return results;
        }
        String inputType = targetDataType.getInputType();
        String targetFieldType = targetDataType.getFieldType();
        FormFieldComEnum ffcm = FormFieldComEnum.getEnumByKey((String)inputType);
        Object result = rawData;
        if (ffcm == null) {
            return results;
        }
        try {
            switch (ffcm) {
                case TEXT: 
                case TEXTAREA: {
                    if ("DECIMAL".equals(targetFieldType)) {
                        result = this.convertToNumber(rawData, rawDataType, targetDataType);
                        break;
                    }
                    result = this.convertToText(rawData, rawDataType, targetDataType);
                    break;
                }
                case CHECKBOX: 
                case RADIO: 
                case IMAGE_RADIO: 
                case SELECT: 
                case IMAGE_SELECT: {
                    result = this.convertToEnum(rawData, rawDataType, targetDataType);
                    break;
                }
                case EXTEND_DATE: 
                case EXTEND_DATETIME: {
                    result = this.convertToDate(rawData, rawDataType, targetDataType);
                    break;
                }
                case FLOWDEALOPITION: 
                case LINE_NUMBER: 
                case EXTEND_MEMBER: 
                case EXTEND_MULTI_MEMBER: 
                case EXTEND_ACCOUNT: 
                case EXTEND_MULTI_ACCOUNT: 
                case EXTEND_DEPARTMENT: 
                case EXTEND_MULTI_DEPARTMENT: 
                case EXTEND_POST: 
                case EXTEND_MULTI_POST: 
                case EXTEND_LEVEL: 
                case EXTEND_MULTI_LEVEL: {
                    result = this.convertToOrg(rawData, rawDataType, targetDataType);
                    break;
                }
                case EXTEND_ATTACHMENT: 
                case EXTEND_IMAGE: 
                case EXTEND_DOCUMENT: 
                case MAP_MARKED: 
                case MAP_LOCATE: 
                case MAP_PHOTO: 
                case CUSTOM_CONTROL: {
                    result = null;
                }
            }
        }
        catch (Exception e) {
            ConvertorEnums.ErrorType type = ConvertorEnums.ErrorType.CONVERT_ERROR;
            throw new ConvertorException(type, e.getMessage());
        }
        results.setData(result);
        return results;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public MagicServiceDetail getMagicServiceDetail() {
        return this.detail;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }
}

