/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.convertor;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.magic.convertor.ConvertResult;
import com.seeyon.cap4.magic.convertor.ConvertorException;
import com.seeyon.cap4.magic.convertor.ConvertorType;
import com.seeyon.cap4.magic.convertor.MagicConvertor;
import com.seeyon.cap4.magic.convertor.MagicConvertorFactory;
import com.seeyon.cap4.magic.convertor.log.dao.MagicConvertorLogDao;
import com.seeyon.cap4.magic.vo.AttributeType;
import com.seeyon.cap4.magic.vo.MagicServiceDetail;
import com.seeyon.cap4.magic.vo.ResultConfig;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class MagicInvokerDefaultConvertor
extends MagicConvertorFactory {
    private Map<String, ConvertorType> rawDataType = new HashMap<String, ConvertorType>();
    private Map<String, ConvertorType> resultDataType = new HashMap<String, ConvertorType>();
    private MagicConvertorLogDao magicConvertorLogDao = (MagicConvertorLogDao)AppContext.getBean((String)"magicConvertorLogDao");
    private MagicConvertor mc = null;
    private FormBean sourceFormBean;
    private static final Log LOGGER = CtpLogFactory.getLog(MagicInvokerDefaultConvertor.class);

    public static MagicInvokerDefaultConvertor getConvertor(String businessID, String versionID, String methodName, long sourceFormId) {
        MagicInvokerDefaultConvertor mpdc = new MagicInvokerDefaultConvertor(businessID, versionID, methodName, sourceFormId);
        mpdc.setMc(mpdc);
        mpdc.getMc().init(businessID, versionID, methodName);
        return mpdc;
    }

    protected MagicInvokerDefaultConvertor(String businessID, String versionID, String methodName, long sourceFormId) {
        super(businessID, versionID, methodName);
        MagicServiceDetail msd = super.getMagicServiceDetail();
        if (msd != null) {
            List resultAt;
            ResultConfig resultConfig;
            Map argsMapper = msd.getArgsMapper();
            if (argsMapper != null) {
                for (Map.Entry temp1 : argsMapper.entrySet()) {
                    List atList = (List)temp1.getValue();
                    if (atList == null || atList.isEmpty()) continue;
                    for (AttributeType at : atList) {
                        this.rawDataType.put(at.getName(), new ConvertorType(at.getLimitConfig()));
                    }
                }
            }
            if ((resultConfig = msd.getResultConfig()) != null && (resultAt = resultConfig.getAttrs()) != null && !resultAt.isEmpty()) {
                for (AttributeType at : resultAt) {
                    this.resultDataType.put(at.getName(), new ConvertorType(at.getLimitConfig()));
                }
            }
            super.initTargetFieldMapper(sourceFormId);
            this.sourceFormBean = super.getCap4FormCacheManager().getForm(sourceFormId);
        }
    }

    public Object convertArgsData(Object rawData, String rawFieldName, String targetFieldName) {
        ConvertorType ct = (ConvertorType)this.targetConvertDataType.get(rawFieldName);
        try {
            ConvertorType targetDataType = this.rawDataType.get(targetFieldName);
            ConvertResult result = this.mc.convert(rawData, ct, targetDataType);
            this.saveArgsLog(result, rawFieldName, targetFieldName);
            return result.getData();
        }
        catch (ConvertorException e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    public Object convertResultData(Object rawData, String rawFieldName, String targetFieldName) {
        ConvertorType ct = (ConvertorType)this.targetConvertDataType.get(targetFieldName);
        try {
            ConvertorType targetDataType = this.resultDataType.get(rawFieldName);
            ConvertResult result = this.mc.convert(rawData, targetDataType, ct);
            this.saveArgsLog(result, rawFieldName, targetFieldName);
            return result.getData();
        }
        catch (ConvertorException e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    public MagicConvertor getMc() {
        return this.mc;
    }

    private void setMc(MagicConvertor mc) {
        this.mc = mc;
    }

    protected void saveResultLog(ConvertResult result, String rawFieldName, String targetFieldName) {
        this.saveArgsLog(result, rawFieldName, targetFieldName);
    }

    protected void saveArgsLog(ConvertResult result, String rawFieldName, String targetFieldName) {
    }
}

