/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.convertor;

import com.seeyon.cap4.magic.convertor.ConvertResult;
import com.seeyon.cap4.magic.convertor.ConvertorException;
import com.seeyon.cap4.magic.convertor.ConvertorType;
import com.seeyon.cap4.magic.convertor.MagicConvertor;
import com.seeyon.cap4.magic.convertor.MagicConvertorFactory;
import com.seeyon.cap4.magic.convertor.log.dao.MagicConvertorLogDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.AttributeType;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicServiceDetail;
import com.seeyon.cap4.magic.vo.ResultConfig;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class MagicProviderDefaultConvertor
extends MagicConvertorFactory {
    private MagicConvertorLogDao magicConvertorLogDao;
    private MagicConvertor mc = null;
    private static final Log LOGGER = CtpLogFactory.getLog(MagicProviderDefaultConvertor.class);
    private Map<String, ConvertorType> rawDataType = new HashMap<String, ConvertorType>();
    private Map<String, ConvertorType> resultDataType = new HashMap<String, ConvertorType>();

    public static MagicProviderDefaultConvertor getConvertor(String businessID, String versionID, String methodName) {
        MagicProviderDefaultConvertor mpdc = new MagicProviderDefaultConvertor(businessID, versionID, methodName);
        mpdc.setMc(mpdc);
        mpdc.getMc().init(businessID, versionID, methodName);
        return mpdc;
    }

    private MagicProviderDefaultConvertor(String businessID, String versionID, String methodName) {
        super(businessID, versionID, methodName);
        MagicServiceDetail detail;
        if (this.magicConvertorLogDao == null) {
            this.magicConvertorLogDao = (MagicConvertorLogDao)AppContext.getBean((String)"magicConvertorLogDao");
        }
        if ((detail = this.getMagicServiceDetail()) != null) {
            List resultAt;
            ResultConfig resultConfig;
            Map argsMapper = detail.getArgsMapper();
            if (argsMapper != null) {
                for (Map.Entry temp1 : argsMapper.entrySet()) {
                    List atList = (List)temp1.getValue();
                    if (atList == null || atList.isEmpty()) continue;
                    Iterator iterator = atList.iterator();
                    while (iterator.hasNext()) {
                        AttributeType at = (AttributeType)iterator.next();
                        this.rawDataType.put(at.getName(), new ConvertorType(at.getLimitConfig()));
                    }
                }
            }
            if ((resultConfig = detail.getResultConfig()) != null && (resultAt = resultConfig.getAttrs()) != null && !resultAt.isEmpty()) {
                for (AttributeType at : resultAt) {
                    this.resultDataType.put(at.getName(), new ConvertorType(at.getLimitConfig()));
                }
            }
            try {
                IMagicProviderDao magicProviderDao = (IMagicProviderDao)AppContext.getBean((String)"magicProviderDao");
                MagicServiceProviderPO currentProvider = magicProviderDao.loadProviders(businessID, versionID, MagicEnums.ProviderStatus.ON);
                if (currentProvider != null && MagicPrivateUtils.isNumeric(currentProvider.getSource())) {
                    super.initTargetFieldMapper(Long.parseLong(currentProvider.getSource()));
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public Object convertArgsData(Object rawData, String rawFieldName, String targetFieldName) {
        ConvertorType rawFieldType = this.rawDataType.get(rawFieldName);
        try {
            ConvertResult result = this.mc.convertArgs(rawData, rawFieldType, targetFieldName);
            this.saveArgsLog(result, rawFieldName, targetFieldName);
            return result.getData();
        }
        catch (ConvertorException e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    public Object convertResultData(Object rawData, String rawFieldName, String targetFieldName) {
        ConvertorType rawFieldType = this.resultDataType.get(targetFieldName);
        try {
            ConvertResult result = this.mc.convertResult(rawData, rawFieldName, rawFieldType);
            result.setSource(rawData);
            this.saveResultLog(result, rawFieldName, targetFieldName);
            return result.getData();
        }
        catch (ConvertorException e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    protected void saveResultLog(ConvertResult result, String rawFieldName, String targetFieldName) {
        this.saveArgsLog(result, rawFieldName, targetFieldName);
    }

    protected void saveArgsLog(ConvertResult result, String rawFieldName, String targetFieldName) {
        ConvertorType targetDataType;
        ConvertorType rawDataTypes = result.getRawDataType();
        if (rawDataTypes == null) {
            rawDataTypes = new ConvertorType();
        }
        if ((targetDataType = result.getTargetDataType()) == null) {
            targetDataType = new ConvertorType();
        }
        Object rawData = result.getSource();
        Object data = result.getData();
        MagicServiceDetail msd = this.getMagicServiceDetail();
        String msg = "";
        if (result.isNeedConvert()) {
            if (msd != null) {
                msg = " \u4e1a\u52a1ID\u4e3a  " + msd.getBusinessId() + " \u7248\u672c\u53f7\u4e3a " + msd.getVersionId() + "  \u65b9\u6cd5\u540d\u4e3a " + msd.getName() + "\u7684\u53c2\u6570\u503c  " + rawFieldName + ":";
            }
            msg = msg + rawData + " \u4ece:inputType =" + rawDataTypes.getInputType() + ",fieldType = " + rawDataTypes.getFieldType() + ",digitNum=" + rawDataTypes.getDigitNum() + ",length=" + rawDataTypes.getLength() + " \u8f6c\u6362\u5230\u76ee\u5f55\u7c7b\u578b :inputType =" + targetDataType.getInputType() + ",fieldType = " + targetDataType.getFieldType() + ",digitNum=" + targetDataType.getDigitNum() + ",length=" + targetDataType.getLength() + "\u8f6c\u6362\u7ed3\u679c\u4e3a " + data;
            LOGGER.warn((Object)msg);
        }
    }

    private void setMc(MagicConvertor mc) {
        this.mc = mc;
    }

    public MagicConvertor getMc() {
        return this.mc;
    }
}

