/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.dao;

import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.initializer.CAP4MagicCacheInitializer;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.SQLWildcardUtil;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MagicInterfaceDefineDaoImpl
implements IMagicInterfaceDefineDao {
    private static Map<Long, MagicInterfaceDefineEntity> entityCacheMapper = new HashMap<Long, MagicInterfaceDefineEntity>();

    @Override
    public boolean initAll() throws BusinessException {
        return true;
    }

    @Override
    public boolean init(long formId) throws BusinessException {
        return false;
    }

    @Override
    public boolean saveDefine(MagicInterfaceDefineEntity entity) throws BusinessException {
        DBAgent.save((Object)entity);
        return true;
    }

    @Override
    public boolean saveDefine(List<MagicInterfaceDefineEntity> entity) throws BusinessException {
        if (entity != null && !entity.isEmpty()) {
            DBAgent.saveAll(entity);
        }
        return true;
    }

    @Override
    public boolean update(MagicInterfaceDefineEntity entity) throws BusinessException {
        if (entity != null) {
            DBAgent.merge((Object)entity);
        }
        return true;
    }

    @Override
    public boolean updateList(List<MagicInterfaceDefineEntity> entity) throws BusinessException {
        if (entity != null && !entity.isEmpty()) {
            DBAgent.mergeAll(entity);
        }
        return true;
    }

    @Override
    public List<MagicInterfaceDefineEntity> findByIds(Collection<Long> ids) throws BusinessException {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<MagicInterfaceDefineEntity>(0);
        }
        String sql = "from MagicInterfaceDefineEntity where id in (:ids)";
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put("ids", ids);
        return DBAgent.find((String)sql, params);
    }

    @Override
    public List<MagicInterfaceDefineEntity> loadDefines(List<MagicEnums.BusinessMethodType> serviceType, List<String> businssIds, String conditon) throws BusinessException {
        if (serviceType == null || serviceType.isEmpty() || businssIds == null || businssIds.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        ArrayList<String> conditionSql = new ArrayList<String>(serviceType.size());
        param.put("latestVersion", String.valueOf(CAP4MagicCacheInitializer.getLatestUpdateVersion()));
        for (int x = 0; x < serviceType.size(); ++x) {
            MagicEnums.BusinessMethodType st = serviceType.get(x);
            param.put("serviceType" + x, st.getType());
            conditionSql.add("serviceType=:serviceType" + x);
        }
        String sql = "from MagicInterfaceDefineEntity where ext3 =:latestVersion and (" + Strings.join(conditionSql, (String)" or ") + ")";
        if (businssIds.size() == 1) {
            param.put("businessId", businssIds.get(0));
            sql = sql + " and businessId=:businessId";
        } else {
            param.put("businessId", businssIds);
            sql = sql + " and businessId in(:businessId)";
        }
        if (Strings.isNotBlank((String)conditon)) {
            param.put("name", "%" + conditon + "%");
            sql = sql + " and name like :name";
        }
        sql = sql + " order by createDate desc";
        List entitys = DBAgent.find((String)sql, param);
        return entitys;
    }

    @Override
    public List<MagicInterfaceDefineEntity> loadDefines(List<MagicEnums.BusinessMethodType> serviceType, String conditon) throws BusinessException {
        if (serviceType == null || serviceType.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        ArrayList<String> conditionSql = new ArrayList<String>(serviceType.size());
        param.put("latestVersion", String.valueOf(CAP4MagicCacheInitializer.getLatestUpdateVersion()));
        for (int x = 0; x < serviceType.size(); ++x) {
            MagicEnums.BusinessMethodType st = serviceType.get(x);
            param.put("serviceType" + x, st.getType());
            conditionSql.add("serviceType=:serviceType" + x);
        }
        String sql = "from MagicInterfaceDefineEntity where ext3 =:latestVersion and (" + Strings.join(conditionSql, (String)" or ") + ")";
        if (Strings.isNotBlank((String)conditon)) {
            param.put("name", "%" + SQLWildcardUtil.escape((String)conditon) + "%");
            sql = sql + " and name like :name";
        }
        List entitys = DBAgent.find((String)sql, param);
        return entitys;
    }

    @Override
    public MagicInterfaceDefineEntity loadDefineById(String businessId, String version, String methodName) throws BusinessException {
        String sql = "from MagicInterfaceDefineEntity where businessId=:businessId and versionId=:businessVersion and methodName=:methodName";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("businessId", businessId);
        param.put("businessVersion", version);
        param.put("methodName", methodName);
        List entitys = DBAgent.find((String)sql, param);
        if (!entitys.isEmpty()) {
            return (MagicInterfaceDefineEntity)entitys.get(0);
        }
        return null;
    }

    @Override
    public List<MagicInterfaceDefineEntity> loadAllEntitys() throws BusinessException {
        return DBAgent.loadAll(MagicInterfaceDefineEntity.class);
    }

    @Override
    public List<MagicInterfaceDefineEntity> loadAllEntitys(FlipInfo info, Map<String, Object> condition) throws BusinessException {
        ArrayList<String> hqlArray = new ArrayList<String>();
        String sql = "from MagicInterfaceDefineEntity where  serviceType !=" + MagicEnums.BusinessMethodType.QUERY.getType() + " and serviceType !=" + MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK.getType();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (condition != null && !condition.isEmpty()) {
            sql = sql + " and ";
            for (Map.Entry<String, Object> entry : condition.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if ("formId".equals(key)) {
                    hqlArray.add(" formId in (:formId) ");
                    params.put("formId", value);
                    continue;
                }
                if ("name".equals(key)) {
                    hqlArray.add(" name like :name");
                    params.put("name", "%" + SQLWildcardUtil.escape((String)value.toString()) + "%");
                    continue;
                }
                if (!"serviceType".equals(key)) continue;
                hqlArray.add(" subType  = :subType ");
                params.put("subType", value);
            }
            sql = sql + Strings.join(hqlArray, (String)" and ");
        }
        List entitys = DBAgent.find((String)sql, params, (FlipInfo)info);
        info.setData(entitys);
        return entitys;
    }

    @Override
    public List<MagicInterfaceDefineEntity> loadAllEntitys(String businessID, String version) throws BusinessException {
        String sql = "from MagicInterfaceDefineEntity where businessId=:businessId and versionId=:businessVersion";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("businessId", businessID);
        param.put("businessVersion", version);
        List entitys = DBAgent.find((String)sql, param);
        return entitys;
    }

    @Override
    public List<MagicInterfaceDefineEntity> loadAllEntitys(String businessID, String version, MagicEnums.BusinessMethodType st) throws BusinessException {
        String sql = "from MagicInterfaceDefineEntity where businessId=:businessId and versionId=:businessVersion and serviceType=:serviceType";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("businessId", businessID);
        param.put("businessVersion", version);
        if (st != null) {
            param.put("serviceType", st.getType());
        }
        return DBAgent.find((String)sql, param);
    }

    @Override
    public List<MagicInterfaceDefineEntity> loadAllNeedUpdateEntitys(int currentUpdateversion) throws BusinessException {
        List<MagicInterfaceDefineEntity> all = this.loadAllEntitys();
        if (all == null || all.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<MagicInterfaceDefineEntity> needUpdate = new LinkedList<MagicInterfaceDefineEntity>();
        for (MagicInterfaceDefineEntity e : all) {
            if (!Strings.isBlank((String)e.getExt3()) && currentUpdateversion <= Integer.parseInt(e.getExt3())) continue;
            needUpdate.add(e);
        }
        return needUpdate;
    }

    @Override
    public MagicInterfaceDefineEntity loadDefineById(long id) throws BusinessException {
        return (MagicInterfaceDefineEntity)DBAgent.get(MagicInterfaceDefineEntity.class, (Serializable)Long.valueOf(id));
    }

    @Override
    public List<MagicInterfaceDefineEntity> loadDefines(long formId, int ... type) throws BusinessException {
        String sql = "from MagicInterfaceDefineEntity where formId=:formId";
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        param.put("formId", Long.valueOf(formId));
        if (type.length == 1) {
            sql = sql + " and serviceType=:serviceType order by createDate desc";
            param.put("serviceType", Integer.valueOf(type[0]));
        } else {
            ArrayList<Integer> typeList = new ArrayList<Integer>(type.length);
            for (int x = 0; x < type.length; ++x) {
                typeList.add(type[x]);
            }
            sql = sql + " and serviceType in(:serviceType) order by createDate desc";
            param.put("serviceType", typeList);
        }
        List entitys = DBAgent.find((String)sql, param);
        return entitys;
    }

    @Override
    public List<MagicInterfaceDefineEntity> loadDefines(List<Long> formId) throws BusinessException {
        if (formId == null || formId.isEmpty()) {
            return Collections.emptyList();
        }
        String sql = "from MagicInterfaceDefineEntity where formId in (:formId) ";
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("formId", formId);
        return DBAgent.find((String)sql, param);
    }

    @Override
    public boolean checkNameRepetition(String name, long currentId) throws BusinessException {
        List<MagicInterfaceDefineEntity> allEntity = this.loadAllEntitys();
        for (int x = 0; x < allEntity.size(); ++x) {
            MagicInterfaceDefineEntity ee = allEntity.get(x);
            String i18nN = ee.getName(AppContext.getLocale());
            if (Strings.isBlank((String)i18nN) || !i18nN.equals(name) || currentId == ee.getId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(String businessID, String version) throws BusinessException {
        String sql = "from MagicInterfaceDefineEntity where businessId=:businessId and versionId=:businessVersion";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("businessId", businessID);
        param.put("businessVersion", version);
        List entitys = DBAgent.find((String)sql, param);
        if (entitys != null && !entitys.isEmpty()) {
            DBAgent.deleteAll((List)entitys);
        }
        return true;
    }

    @Override
    public boolean delete(List<MagicInterfaceDefineEntity> entitys) throws BusinessException {
        if (entitys != null && !entitys.isEmpty()) {
            DBAgent.deleteAll(entitys);
        }
        return true;
    }

    @Override
    public void saveEntityInCache(MagicInterfaceDefineEntity entity) {
        entityCacheMapper.put(entity.getId(), entity);
    }

    @Override
    public MagicInterfaceDefineEntity getEntityFormCache(String bId, String version, String methodName) {
        for (MagicInterfaceDefineEntity e : entityCacheMapper.values()) {
            String vid = e.getVersionId();
            String bid = e.getBusinessId();
            String mn = e.getMethodName();
            if (!vid.equals(version) || !bid.equals(bId) || !mn.equals(methodName)) continue;
            return e;
        }
        return null;
    }
}

