/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.dao;

import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DBAgent;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;

public class MagicProviderDaoImpl
implements IMagicProviderDao {
    private static final Log LOGGER = CtpLogFactory.getLog(MagicProviderDaoImpl.class);
    private static final CacheAccessable cacheFactory = CacheFactory.getInstance(MagicProviderDaoImpl.class);
    private static CacheMap<Long, MagicServiceProviderPO> providerCache = cacheFactory.createMap("magicProviderCacheMap");

    @Override
    public List<MagicServiceProviderPO> loadProviders(String businessId, String versionId) {
        LinkedList<MagicServiceProviderPO> result = new LinkedList<MagicServiceProviderPO>();
        for (MagicServiceProviderPO p : providerCache.values()) {
            if (!p.getBusinessId().equals(businessId) || !p.getVersionId().equals(versionId)) continue;
            result.add(p);
        }
        return result;
    }

    @Override
    public List<MagicServiceProviderPO> loadProviders(String businessId, String versionId, String sourceId, String sourceType) {
        String hql = "from MagicServiceProviderPO where businessId =:businessId and versionId =:versionId and source=:sourceId and sourceType=:sourceType";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessId", businessId);
        params.put("versionId", versionId);
        params.put("sourceId", sourceId);
        params.put("sourceType", sourceType);
        return DBAgent.find((String)hql, params);
    }

    @Override
    public MagicServiceProviderPO loadProviders(String businessId, String versionId, MagicEnums.ProviderStatus status) {
        for (MagicServiceProviderPO p : providerCache.values()) {
            if (p.getStatus() != status.getType() || !p.getBusinessId().equals(businessId) || !p.getVersionId().equals(versionId)) continue;
            return p;
        }
        return null;
    }

    @Override
    public List<MagicServiceProviderPO> loadAllProviders(MagicEnums.ProviderStatus status) {
        if (status == null) {
            return Collections.emptyList();
        }
        LinkedList<MagicServiceProviderPO> result = new LinkedList<MagicServiceProviderPO>();
        for (MagicServiceProviderPO p : providerCache.values()) {
            if (p.getStatus() != status.getType()) continue;
            result.add(p);
        }
        return result;
    }

    @Override
    public List<MagicServiceProviderPO> loadAllProviders() {
        return DBAgent.loadAll(MagicServiceProviderPO.class);
    }

    @Override
    public void saveProvider(MagicServiceProviderPO provider) {
        DBAgent.save((Object)provider);
        providerCache.put((Serializable)provider.getId(), (Serializable)provider);
    }

    @Override
    public void saveProviders(List<MagicServiceProviderPO> providersList) {
        if (providersList != null && !providersList.isEmpty()) {
            DBAgent.saveAll(providersList);
            this.addProviderToCache(providersList);
        }
    }

    @Override
    public void updateProviders(List<MagicServiceProviderPO> providersList) {
        if (providersList != null && !providersList.isEmpty()) {
            DBAgent.mergeAll(providersList);
            this.addProviderToCache(providersList);
        }
    }

    private void addProviderToCache(List<MagicServiceProviderPO> providerPOList) {
        for (MagicServiceProviderPO p : providerPOList) {
            providerCache.put((Serializable)p.getId(), (Serializable)p);
        }
    }

    private void deleteProviderForCache(List<MagicServiceProviderPO> providerPOList) {
        for (MagicServiceProviderPO p : providerPOList) {
            providerCache.remove((Serializable)p.getId());
        }
    }

    @Override
    public void deleteProvides(String businessId, String versionId) {
        List<MagicServiceProviderPO> providers = this.loadProviders(businessId, versionId);
        if (!providers.isEmpty()) {
            DBAgent.deleteAll(providers);
            this.deleteProviderForCache(providers);
        }
    }

    @Override
    public void deleteProvides(List<MagicServiceProviderPO> providersList) {
        if (providersList != null && !providersList.isEmpty()) {
            DBAgent.deleteAll(providersList);
            this.deleteProviderForCache(providersList);
        }
    }

    @Override
    public void deleteProvidesBySource(String source, MagicEnums.ProviderType type) {
        String hql = "from MagicServiceProviderPO where  source = :source and sourceType=:sourceType";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", source);
        params.put("sourceType", type.getType());
        List data = DBAgent.find((String)hql, params);
        if (!data.isEmpty()) {
            DBAgent.deleteAll((List)data);
            this.deleteProviderForCache(data);
        }
    }

    @Override
    public List<MagicServiceProviderPO> switchProvider(String businessId, String version, long id) {
        List<MagicServiceProviderPO> all = this.loadProviders(businessId, version);
        if (all != null && !all.isEmpty()) {
            for (MagicServiceProviderPO p : all) {
                if (p.getId().equals(id)) {
                    p.setStatus(MagicEnums.ProviderStatus.ON.getType());
                    DBAgent.merge((Object)p);
                } else if (p.getStatus() == MagicEnums.ProviderStatus.ON.getType()) {
                    p.setStatus(MagicEnums.ProviderStatus.OFF.getType());
                    DBAgent.merge((Object)p);
                }
                providerCache.put((Serializable)p.getId(), (Serializable)p);
            }
        }
        return all;
    }

    @Override
    public List<MagicServiceProviderPO> getProvidersBySource(String source, MagicEnums.ProviderStatus status, MagicEnums.ProviderType type) {
        String hql = "from MagicServiceProviderPO where status=:status and source = :source and sourceType=:sourceType";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("status", status.getType());
        params.put("source", source);
        params.put("sourceType", type.getType());
        return DBAgent.find((String)hql, params);
    }

    @Override
    public MagicServiceProviderPO getById(Long id) {
        return (MagicServiceProviderPO)providerCache.get((Serializable)id);
    }

    @Override
    public void init() {
        List<MagicServiceProviderPO> allProviders = this.loadAllProviders();
        this.addProviderToCache(allProviders);
    }
}

