/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.dao;

import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class MagicReflectionRelationDaoImpl
implements IMagicReflectionRelationDao {
    @Override
    public MagicReflectionRelationPO getRecordById(long id) throws BusinessException {
        String sql = "from MagicReflectionRelationPO where id=:id";
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", id);
        List data = DBAgent.find((String)sql, params);
        if (data != null && !data.isEmpty()) {
            return (MagicReflectionRelationPO)data.get(0);
        }
        return null;
    }

    @Override
    public boolean save(MagicReflectionRelationPO po) throws BusinessException {
        DBAgent.save((Object)po);
        return true;
    }

    @Override
    public boolean saveAll(List<MagicReflectionRelationPO> poList) throws BusinessException {
        if (poList != null && !poList.isEmpty()) {
            DBAgent.saveAll(poList);
        }
        return false;
    }

    @Override
    public boolean deleteById(long id) throws BusinessException {
        String sql = "from MagicReflectionRelationPO where id=:id";
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", id);
        List data = DBAgent.find((String)sql, params);
        if (data != null && !data.isEmpty()) {
            DBAgent.deleteAll((List)data);
        }
        return false;
    }

    @Override
    public boolean deleteByPoint(String point) throws BusinessException {
        String sql = "from MagicReflectionRelationPO where callingPoint=:point";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("point", point);
        List data = DBAgent.find((String)sql, params);
        if (data != null && !data.isEmpty()) {
            DBAgent.deleteAll((List)data);
        }
        return true;
    }

    @Override
    public boolean deleteByActionOrShipId(String actionId) throws BusinessException {
        String sql = "from MagicReflectionRelationPO where callingPoint like :point";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("point", actionId + "%");
        List data = DBAgent.find((String)sql, params);
        if (data != null && !data.isEmpty()) {
            DBAgent.deleteAll((List)data);
        }
        return true;
    }

    @Override
    public boolean deleteByTriggerOrRelationIds(List<Long> ids) throws BusinessException {
        if (ids == null || ids.isEmpty()) {
            return true;
        }
        ArrayList<String> sqlCondition = new ArrayList<String>(ids.size());
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < ids.size(); ++i) {
            sqlCondition.add("callingPoint like :point" + i);
            params.put("point" + i, ids.get(i) + "%");
        }
        String sql = "from MagicReflectionRelationPO where " + Strings.join(sqlCondition, (String)" or ");
        List data = DBAgent.find((String)sql, params);
        if (data != null && !data.isEmpty()) {
            DBAgent.deleteAll((List)data);
        }
        return true;
    }

    @Override
    public boolean deleteByPoints(List<String> point) throws BusinessException {
        if (point != null && !point.isEmpty()) {
            if (point.size() == 1) {
                return this.deleteByPoint(point.get(0));
            }
            String sql = "from MagicReflectionRelationPO where callingPoint in (:point)";
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("point", point);
            List data = DBAgent.find((String)sql, params);
            if (data != null && !data.isEmpty()) {
                DBAgent.deleteAll((List)data);
            }
        }
        return true;
    }

    @Override
    public boolean deleteEntrys(List<MagicReflectionRelationPO> entrys) throws BusinessException {
        if (entrys != null && !entrys.isEmpty()) {
            DBAgent.deleteAll(entrys);
        }
        return true;
    }

    @Override
    public List<MagicReflectionRelationPO> getReflectionByBids(Collection<String> bid) throws BusinessException {
        if (bid == null || bid.isEmpty()) {
            return Collections.emptyList();
        }
        String sql = "from MagicReflectionRelationPO where calleeBusinessId in (:calleeBusinessId)";
        HashMap params = new HashMap();
        ArrayList<String> id = new ArrayList<String>();
        id.addAll(bid);
        params.put("calleeBusinessId", id);
        return DBAgent.find((String)sql, params);
    }

    @Override
    public List<MagicReflectionRelationPO> getReflectionRelationByCallPoint(String point) throws BusinessException {
        String sql = "from MagicReflectionRelationPO where callingPoint=:callingPoint";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callingPoint", point);
        List data = DBAgent.find((String)sql, params);
        if (data != null && !data.isEmpty()) {
            Collections.sort(data, new Comparator<MagicReflectionRelationPO>(){

                @Override
                public int compare(MagicReflectionRelationPO o1, MagicReflectionRelationPO o2) {
                    if (o1.getInvokeSort() > o2.getInvokeSort()) {
                        return 1;
                    }
                    return -1;
                }
            });
            return data;
        }
        return Collections.emptyList();
    }

    @Override
    public List<MagicReflectionRelationPO> getReflectionByCallPoints(List<String> points) throws BusinessException {
        if (points == null || points.isEmpty()) {
            return Collections.emptyList();
        }
        if (points.size() == 1) {
            return this.getReflectionRelationByCallPoint(points.get(0));
        }
        String sql = "from MagicReflectionRelationPO where callingPoint in (:callingPoint)";
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("callingPoint", points);
        return DBAgent.find((String)sql, params);
    }

    @Override
    public List<MagicReflectionRelationPO> getReflectionByCallPoints(List<String> points, FlipInfo flipInfo) throws BusinessException {
        flipInfo.setData(Collections.emptyList());
        flipInfo.setTotal(0);
        if (points == null || points.isEmpty()) {
            return Collections.emptyList();
        }
        if (points.size() == 1) {
            List<MagicReflectionRelationPO> data = this.getReflectionRelationByCallPoint(points.get(0));
            flipInfo.setData(data);
            flipInfo.setSize(data.size());
            return data;
        }
        String sql = "from MagicReflectionRelationPO where callingPoint in (:callingPoint)";
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("callingPoint", points);
        return DBAgent.find((String)sql, params, (FlipInfo)flipInfo);
    }

    @Override
    public List<MagicReflectionRelationPO> getReflectionByFormIdList(List<Long> formId) throws BusinessException {
        if (formId != null && !formId.isEmpty()) {
            String sql = "from MagicReflectionRelationPO where formId in (:formId)";
            HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
            params.put("formId", formId);
            return DBAgent.find((String)sql, params);
        }
        return Collections.emptyList();
    }

    @Override
    public List<MagicReflectionRelationPO> getReflectionByCallId(String bid, String version) throws BusinessException {
        String sql = "from MagicReflectionRelationPO where calleeBusinessId =:bid and calleeVersionId =:version";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bid", bid);
        params.put("version", version);
        List data = DBAgent.find((String)sql, params);
        if (data != null && !data.isEmpty()) {
            Collections.sort(data, new Comparator<MagicReflectionRelationPO>(){

                @Override
                public int compare(MagicReflectionRelationPO o1, MagicReflectionRelationPO o2) {
                    if (o1.getInvokeSort() > o2.getInvokeSort()) {
                        return 1;
                    }
                    return -1;
                }
            });
            return data;
        }
        return Collections.emptyList();
    }

    @Override
    public List<MagicReflectionRelationPO> getReflectionByFormRelationId(Long formRelationId) throws BusinessException {
        String sql = "from MagicReflectionRelationPO where callingPoint like :point";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("point", String.valueOf(formRelationId) + "%");
        return DBAgent.find((String)sql, params);
    }
}

