/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.dao;

import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.SQLWildcardUtil;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MagicServiceSummaryDaoImpl
implements IMagicServiceSummaryDao {
    @Override
    public boolean save(MagicServiceSummary summary) {
        DBAgent.save((Object)summary);
        return true;
    }

    @Override
    public MagicServiceSummary loadServiceInfo(String businessId, String version) {
        String hql = "from MagicServiceSummary where businessId=:businessId and businessVersion=:businessVersion";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessId", businessId);
        params.put("businessVersion", version);
        List datas = DBAgent.find((String)hql, params);
        if (datas != null && !datas.isEmpty()) {
            return (MagicServiceSummary)datas.get(0);
        }
        return null;
    }

    @Override
    public MagicServiceSummary loadServiceInfo(Long id) {
        return (MagicServiceSummary)DBAgent.get(MagicServiceSummary.class, (Serializable)id);
    }

    @Override
    public List<MagicServiceSummary> loadAllServices() {
        return DBAgent.loadAll(MagicServiceSummary.class);
    }

    @Override
    public List<MagicServiceSummary> searchServicesByCreater(List<String> businessIds, List<Long> creaters) {
        String hql = "from MagicServiceSummary where ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (businessIds == null || businessIds.isEmpty() || creaters == null || creaters.isEmpty()) {
            return Collections.emptyList();
        }
        if (businessIds.size() == 1) {
            params.put("businessId", businessIds.get(0));
            hql = hql + " businessId=:businessId";
        } else {
            params.put("businessId", businessIds);
            hql = hql + " businessId in(:businessId)";
        }
        if (creaters.size() == 1) {
            params.put("createId", creaters.get(0));
            hql = hql + " and createId =:createId";
        } else if (creaters.size() < 1000) {
            params.put("createId", creaters);
            hql = hql + " and createId in(:createId)";
        } else {
            List[] array = Strings.splitList(creaters, (int)1000);
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                List list = array[i];
                hql = hql + " and (createId in (:createId" + i + ")";
                if (i < len - 1) {
                    hql = hql + " or ";
                }
                if (i == len - 1) {
                    hql = hql + ")";
                }
                params.put("createId" + i, list);
            }
        }
        return DBAgent.find((String)hql, params);
    }

    @Override
    public List<MagicServiceSummary> searchServicesByBusiness(List<String> businessIds) {
        String hql = "from MagicServiceSummary where ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (businessIds == null || businessIds.isEmpty()) {
            return Collections.emptyList();
        }
        if (businessIds.size() == 1) {
            params.put("businessId", businessIds.get(0));
            hql = hql + " businessId=:businessId";
        } else {
            params.put("businessId", businessIds);
            hql = hql + " businessId in(:businessId)";
        }
        return DBAgent.find((String)hql, params);
    }

    @Override
    public List<MagicServiceSummary> searchServicesByName(List<String> businessIds, String searchName) {
        String hql = "from MagicServiceSummary where ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (businessIds == null || businessIds.isEmpty()) {
            return Collections.emptyList();
        }
        if (businessIds.size() == 1) {
            params.put("businessId", businessIds.get(0));
            hql = hql + "businessId=:businessId";
        } else {
            params.put("businessId", businessIds);
            hql = hql + " businessId in(:businessId)";
        }
        if (Strings.isNotBlank((String)searchName)) {
            params.put("nameDisplay", "%" + SQLWildcardUtil.escape((String)searchName) + "%");
            hql = hql + " and nameDisplay like :nameDisplay";
        }
        return DBAgent.find((String)hql, params);
    }

    @Override
    public boolean saveAll(Collection<MagicServiceSummary> summarys) {
        if (summarys != null && !summarys.isEmpty()) {
            ArrayList<MagicServiceSummary> all = new ArrayList<MagicServiceSummary>(summarys.size());
            all.addAll(summarys);
            DBAgent.saveAll(all);
        }
        return true;
    }

    @Override
    public boolean delete(MagicServiceSummary summary) {
        DBAgent.delete((Object)summary);
        return false;
    }

    @Override
    public boolean deleteAll(Collection<MagicServiceSummary> summary) {
        if (summary != null && !summary.isEmpty()) {
            ArrayList<MagicServiceSummary> saveList = new ArrayList<MagicServiceSummary>();
            saveList.addAll(summary);
            DBAgent.deleteAll(saveList);
        }
        return false;
    }

    @Override
    public boolean update(MagicServiceSummary summary) {
        if (summary != null) {
            DBAgent.merge((Object)summary);
        }
        return false;
    }

    @Override
    public boolean updateAll(Collection<MagicServiceSummary> summarys) {
        if (summarys != null && !summarys.isEmpty()) {
            ArrayList<MagicServiceSummary> saveList = new ArrayList<MagicServiceSummary>();
            saveList.addAll(summarys);
            DBAgent.mergeAll(saveList);
        }
        return false;
    }

    @Override
    public List<MagicServiceSummary> findExternalServices(List<MagicEnums.CertificateType> certificateTypes, String name, FlipInfo info, Map<String, Object> condition, boolean filterBizExternal) {
        String hql = "from MagicServiceSummary  where businessType=:businessType and ownerType !=:ownerType1 and ownerType !=:ownerType2 ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ownerType1", MagicEnums.ServiceOwnerType.DEFAULT_DEE.getType());
        params.put("ownerType2", MagicEnums.ServiceOwnerType.DEFAULT_REPORT.getType());
        params.put("businessType", MagicEnums.BusinessType.EXTERNAL_BUSINESS.getKey());
        if (filterBizExternal) {
            hql = hql + " and ownerType !=:ownerType3";
            params.put("ownerType3", MagicEnums.ServiceOwnerType.DEFAULT_CAP4_BIZ.getType());
        }
        if (Strings.isNotBlank((String)name)) {
            hql = hql + " and nameDisplay like :name";
            params.put("name", "%" + name + "%");
        }
        if (certificateTypes != null && certificateTypes.size() == 1) {
            hql = hql + " and certificateType =:certificateType";
            params.put("certificateType", certificateTypes.get(0).getKey());
        }
        if (condition != null && condition.containsKey("creater")) {
            Object data = condition.get("creater");
            if (data != null && data instanceof List) {
                if (!((List)data).isEmpty()) {
                    params.put("createId", data);
                    hql = hql + " and createId in (:createId)";
                }
            } else if (data != null) {
                params.put("createId", data);
                hql = hql + " and createId=:createId";
            }
        }
        hql = hql + " order by modifyDate desc";
        if (info == null) {
            return DBAgent.find((String)hql, params);
        }
        return DBAgent.find((String)hql, params, (FlipInfo)info);
    }

    @Override
    public List<MagicServiceSummary> findServices(Map<String, Object> condition, FlipInfo info) {
        String hql = "from MagicServiceSummary  ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> whereSql = new ArrayList<String>();
        if (condition != null) {
            Object data;
            if (condition.containsKey("certificateType")) {
                params.put("certificateType", ParamUtil.getInt(condition, (String)"certificateType"));
                whereSql.add("certificateType=:certificateType");
            }
            if (condition.containsKey("businessType")) {
                params.put("businessType", ParamUtil.getString(condition, (String)"businessType"));
                whereSql.add("businessType=:businessType");
            }
            if (condition.containsKey("name")) {
                params.put("nameDisplay", "%" + SQLWildcardUtil.escape((String)ParamUtil.getString(condition, (String)"name")) + "%");
                whereSql.add("nameDisplay like :nameDisplay");
            }
            if (condition.containsKey("ownerType")) {
                Object ownerType = condition.get("ownerType");
                if (ownerType instanceof List) {
                    params.put("ownerType", ownerType);
                    whereSql.add("ownerType in(:ownerType)");
                } else {
                    params.put("ownerType", ParamUtil.getString(condition, (String)"ownerType"));
                    whereSql.add("ownerType=:ownerType");
                }
            }
            if (condition.containsKey("ownerId")) {
                data = condition.get("ownerId");
                if (data != null && data instanceof List) {
                    if (!((List)data).isEmpty()) {
                        params.put("owner", data);
                        whereSql.add("owner in (:owner)");
                    }
                } else if (data != null) {
                    params.put("owner", data);
                    whereSql.add("owner=:owner");
                }
            }
            if (condition.containsKey("creater")) {
                data = condition.get("creater");
                if (data != null && data instanceof List) {
                    if (!((List)data).isEmpty()) {
                        params.put("createId", data);
                        whereSql.add(" createId in (:createId)");
                    }
                } else if (data != null) {
                    params.put("createId", data);
                    whereSql.add(" createId=:createId");
                }
            }
        }
        if (!whereSql.isEmpty()) {
            hql = hql + " where " + Strings.join(whereSql, (String)" and ");
        }
        hql = hql + " order by modifyDate desc";
        if (info == null) {
            return DBAgent.find((String)hql, params);
        }
        return DBAgent.find((String)hql, params, (FlipInfo)info);
    }
}

