/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.event;

import com.seeyon.cap4.form.api.FormApi4Cap4;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManager;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.magic.dao.IMagicTriggerRecordInfoDao;
import com.seeyon.cap4.magic.po.MagicTriggerRecordInfo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.lock.manager.LockManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.lock.Lock;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.event.UpdateMemberEvent;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.ListenEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class OrganizationListener {
    private IMagicTriggerRecordInfoDao magicTriggerRecordInfoDao;
    private CAP4FormCacheManager cap4FormCacheManager;
    private LockManager lockManager;
    private CAP4FormManager cap4FormManager;
    private CAP4FormDataManager cap4FormDataManager;
    private CAPFormDataCacheManager capFormDataCacheManager;
    private FormApi4Cap4 formApi4Cap4;
    private CAP4FormTriggerManager cap4FormTriggerManager;
    private static final Log LOGGER = CtpLogFactory.getLog(OrganizationListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={BusinessException.class})
    @ListenEvent(event=UpdateMemberEvent.class, async=true)
    public void onUpdateMember(UpdateMemberEvent event) {
        Long dataId = 0L;
        try {
            V3xOrgMember member = event.getMember();
            MagicTriggerRecordInfo recordInfo = this.magicTriggerRecordInfoDao.getRecordByTargetInfo(member.getId(), "member", "", "");
            if (recordInfo != null) {
                FormTriggerBean bean = this.cap4FormCacheManager.getFormTriggerBean(recordInfo.getTriggerId());
                if (bean == null) {
                    return;
                }
                bean = new FormTriggerBean(recordInfo.getTriggerJson());
                if (bean == null) {
                    return;
                }
                FormTriggerActionBean actionBean = bean.getActionBean(recordInfo.getActionId());
                if (actionBean == null) {
                    return;
                }
                FormBean formBean = this.cap4FormCacheManager.getForm(bean.getSourceFormId());
                if (formBean == null) {
                    return;
                }
                FormDataMasterBean formDataMasterBean = this.capFormDataCacheManager.get4Data(recordInfo.getSourceId(), formBean.getId());
                if (formDataMasterBean == null) {
                    return;
                }
                Lock lock = this.cap4FormManager.getLock(formDataMasterBean.getId());
                if (lock != null) {
                    return;
                }
                dataId = formDataMasterBean.getId();
                this.lockManager.lock(member.getId().longValue(), formDataMasterBean.getId().longValue());
                List fillBackList = (List)actionBean.getParam(FormTriggerBean.ActionParam.FeedBack.getKey());
                if (fillBackList == null || fillBackList.isEmpty()) {
                    return;
                }
                for (SimpleObjectBean simpleObjectBean : fillBackList) {
                    String formFieldName = simpleObjectBean.getName();
                    String string = simpleObjectBean.getValue();
                }
                FormDataMasterBean oldMasterBean = this.cap4FormManager.getDataMasterBeanById(formDataMasterBean.getId(), formBean, null);
                ArrayList<String> changeFieldList = new ArrayList<String>();
                ArrayList<FormDataMasterBean> masterBeans = new ArrayList<FormDataMasterBean>();
                masterBeans.add(formDataMasterBean);
                AppContext.putThreadContext((String)"CALC_FROM_TRIGGER", (Object)"CALC_FROM_TRIGGER");
                this.cap4FormDataManager.calcAll(formBean, formDataMasterBean, null, false, true, true, true);
                String validateResult = this.formApi4Cap4.validateCheckRule(formBean, formDataMasterBean);
                if (Strings.isBlank((String)validateResult)) {
                    changeFieldList.addAll(formDataMasterBean.getModifiedFields((FormDataBean)oldMasterBean));
                    this.cap4FormDataManager.insertOrUpdateMasterData(formDataMasterBean);
                    validateResult = this.formApi4Cap4.validateDataUnique(formBean, masterBeans);
                    if (Strings.isNotBlank((String)validateResult)) {
                        this.cap4FormDataManager.insertOrUpdateMasterData(oldMasterBean);
                    }
                }
                if (Strings.isBlank((String)validateResult)) {
                    // empty if block
                }
                this.cap4FormTriggerManager.doTrigger(ModuleType.cap4UnflowForm.getKey(), (long)formDataMasterBean.getId(), (long)formBean.getId(), "0", changeFieldList, true);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
        finally {
            if (dataId != 0L) {
                this.lockManager.unlock(dataId.longValue());
            }
        }
    }

    void checkAndLockData(Long dataId, long millis) throws BusinessException, SQLException {
        boolean label = true;
        while (label) {
            boolean result = this.lockManager.lock(AppContext.currentUserId(), dataId.longValue());
            if (!result) {
                Lock lock = this.cap4FormManager.getLock(dataId);
                if (lock == null) {
                    LOGGER.info((Object)("\u76ee\u6807\u6570\u636e" + dataId + "\u88ab\u5176\u4ed6\u4eba\u9501\u4f4f\uff0c\u4f46\u9501\u5df2\u5931\u6548\uff0c\u76f4\u63a5\u91ca\u653e\u65e0\u6548\u9501"));
                    label = false;
                    continue;
                }
                LOGGER.info((Object)("\u76ee\u6807\u6570\u636e" + dataId + "\u88abuserId:" + lock.getOwner() + "\u9501\u4f4f\uff0c\u6682\u7f13\u6267\u884c\uff0c\u7b49\u5f85\u9501\u91ca\u653e"));
                try {
                    Thread.sleep(millis);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)"\u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38", (Throwable)e);
                }
                continue;
            }
            label = false;
            LOGGER.info((Object)("\u7528\u6237 " + AppContext.currentUserId() + " \u5bf9\u76ee\u6807\u6570\u636e\u52a0\u9501\uff1a\u6570\u636eid " + dataId));
        }
    }

    public IMagicTriggerRecordInfoDao getMagicTriggerRecordInfoDao() {
        return this.magicTriggerRecordInfoDao;
    }

    public void setMagicTriggerRecordInfoDao(IMagicTriggerRecordInfoDao magicTriggerRecordInfoDao) {
        this.magicTriggerRecordInfoDao = magicTriggerRecordInfoDao;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public CAP4FormDataManager getCap4FormDataManager() {
        return this.cap4FormDataManager;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public FormApi4Cap4 getFormApi4Cap4() {
        return this.formApi4Cap4;
    }

    public void setFormApi4Cap4(FormApi4Cap4 formApi4Cap4) {
        this.formApi4Cap4 = formApi4Cap4;
    }

    public CAP4FormTriggerManager getCap4FormTriggerManager() {
        return this.cap4FormTriggerManager;
    }

    public void setCap4FormTriggerManager(CAP4FormTriggerManager cap4FormTriggerManager) {
        this.cap4FormTriggerManager = cap4FormTriggerManager;
    }

    public CAPFormDataCacheManager getCapFormDataCacheManager() {
        return this.capFormDataCacheManager;
    }

    public void setCapFormDataCacheManager(CAPFormDataCacheManager capFormDataCacheManager) {
        this.capFormDataCacheManager = capFormDataCacheManager;
    }
}

