/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.event;

import com.seeyon.cap4.magic.business.create.utils.MagicCreateServiceUtils;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.execute.MagicProviderExecuteManager;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.JSONUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.report.engine.api.events.DesignWarp;
import com.seeyon.ctp.report.engine.api.events.RemoveReportEvent;
import com.seeyon.ctp.report.engine.api.events.UpdateReportEvent;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.annotation.ListenEvent;
import com.seeyon.datamagic.engine.domain.service.ServiceConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceMethodConfig;
import com.seeyon.datamagic.engine.out.service.OutService;
import com.seeyon.datamagic.engine.out.service.entry.ServiceProvider;
import com.seeyon.datamagic.engine.out.service.entry.ServiceSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class ReportListener {
    private OutService magicReportOutService;
    private IMagicProviderDao magicProviderDao;
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private static final Log LOGGER = CtpLogFactory.getLog(ReportListener.class);

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={BusinessException.class})
    @ListenEvent(event=RemoveReportEvent.class, async=true)
    public void onRemoveReportEvent(RemoveReportEvent event) throws BusinessException {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("ownerType", MagicEnums.ServiceOwnerType.DEFAULT_REPORT.getType());
        condition.put("ownerId", String.valueOf(event.getDesign().getId()));
        List<MagicServiceSummary> serviceSummaries = this.magicServiceSummaryDao.findServices(condition, null);
        if (serviceSummaries == null || serviceSummaries.isEmpty()) {
            return;
        }
        String userName = "";
        if (event.getCurrentUser() != null) {
            userName = event.getCurrentUser().getName();
        }
        LOGGER.info((Object)(userName + " delete " + event.getDesign().getTitle()));
        MagicServiceSummary serviceSummary = serviceSummaries.get(0);
        this.magicProviderDao.deleteProvides(serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion());
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={BusinessException.class})
    @ListenEvent(event=UpdateReportEvent.class, async=true)
    public void onUpdateReportEvent(UpdateReportEvent event) throws BusinessException {
        DesignWarp designWarp = event.getDesign();
        ServiceSummary ss = new ServiceSummary();
        ss.setId(String.valueOf(designWarp.getId()));
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("ownerType", MagicEnums.ServiceOwnerType.DEFAULT_REPORT.getType());
        condition.put("ownerId", String.valueOf(designWarp.getId()));
        List<MagicServiceSummary> serviceSummaries = this.magicServiceSummaryDao.findServices(condition, null);
        if (serviceSummaries == null || serviceSummaries.isEmpty()) {
            return;
        }
        for (MagicServiceSummary serviceSummary : serviceSummaries) {
            List<MagicInterfaceDefineEntity> methodList = this.magicInterfaceDefineDao.loadAllEntitys(serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion());
            if (methodList == null || methodList.isEmpty()) continue;
            MagicInterfaceDefineEntity method = methodList.get(0);
            ServiceConfig sc = this.magicReportOutService.convert(1, ss);
            serviceSummary.setNameDisplay(designWarp.getTitle());
            serviceSummary.setMetadata(JSONUtils.getJSonString(sc.getMetadata().getMetadatas()));
            this.magicServiceSummaryDao.update(serviceSummary);
            MagicInterfaceDefineEntity needUpdateEntity = MagicCreateServiceUtils.convertMethodToPoForOutService(sc.getBusinessId(), sc.getVersion(), "", 0L, (ServiceMethodConfig)sc.getMethodConfig().get(0));
            method.setName(needUpdateEntity.getName());
            method.setExt1(needUpdateEntity.getExt1());
            method.setArgsConfig(needUpdateEntity.getArgsConfig());
            method.setArgsConfigGuide(needUpdateEntity.getArgsConfigGuide());
            method.setResultConfig(needUpdateEntity.getResultConfig());
            method.setResultConfigGuide(needUpdateEntity.getResultConfigGuide());
            this.magicInterfaceDefineDao.update(method);
            this.magicProviderDao.deleteProvides(serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion());
            ServiceProvider provider = this.magicReportOutService.provider(serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion(), method.getMethodName(), ss);
            ArrayList<Map> extMapper = new ArrayList<Map>();
            extMapper.add(provider.getOtherSet());
            MagicServiceProviderPO po = new MagicServiceProviderPO();
            po.setIdIfNew();
            po.setDisplayName(needUpdateEntity.getName());
            po.setBusinessId(serviceSummary.getBusinessId());
            po.setSourceType(MagicEnums.ServiceOwnerType.DEFAULT_REPORT.getType());
            po.setStatus(MagicEnums.ProviderStatus.ON.getType());
            po.setExt1(JSONUtils.getJSonString(extMapper));
            po.setVersionId(serviceSummary.getBusinessVersion());
            po.setCreater(Long.valueOf(AppContext.currentUserId()));
            po.setCreateDate(DateUtil.currentDate());
            this.magicProviderDao.saveProvider(po);
            MagicProviderExecuteManager magicExternalExceuteManager = (MagicProviderExecuteManager)AppContext.getBean((String)"magicExternalExceuteManager");
            magicExternalExceuteManager.removeCacheExecute(serviceSummary.getBusinessId(), serviceSummary.getBusinessVersion());
            String userName = "";
            if (event.getCurrentUser() != null) {
                userName = event.getCurrentUser().getName();
            }
            LOGGER.info((Object)(userName + " update " + event.getDesign().getTitle()));
        }
    }

    public OutService getMagicReportOutService() {
        return this.magicReportOutService;
    }

    public void setMagicReportOutService(OutService magicReportOutService) {
        this.magicReportOutService = magicReportOutService;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }
}

