/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.event.service;

import com.seeyon.cap4.magic.business.importandexport.IMagicExternalExportManager;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.event.MagicEventExecuteService;
import com.seeyon.cap4.magic.event.dao.MagicEventRegisterDao;
import com.seeyon.cap4.magic.po.MagicEventRegisterInfo;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.PrivateFileUtils;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.event.DeleteDepartmentEvent;
import com.seeyon.ctp.organization.event.DeleteLevelEvent;
import com.seeyon.ctp.organization.event.DeleteMemberEvent;
import com.seeyon.ctp.organization.event.DeletePostEvent;
import com.seeyon.ctp.organization.event.UpdateDepartmentEvent;
import com.seeyon.ctp.organization.event.UpdateLevelEvent;
import com.seeyon.ctp.organization.event.UpdateMemberEvent;
import com.seeyon.ctp.organization.event.UpdatePostEvent;
import com.seeyon.ctp.util.annotation.ListenEvent;
import com.seeyon.datamagic.engine.loader.PrivateClassLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;

public class MagicEventListener {
    private static final Log LOGGER = CtpLogFactory.getLog(MagicEventListener.class);
    private MagicEventRegisterDao magicEventRegisterDao;
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private IMagicExternalExportManager magicExternalExportManager;

    public IMagicExternalExportManager getMagicExternalExportManager() {
        return this.magicExternalExportManager;
    }

    public void setMagicExternalExportManager(IMagicExternalExportManager magicExternalExportManager) {
        this.magicExternalExportManager = magicExternalExportManager;
    }

    public MagicEventRegisterDao getMagicEventRegisterDao() {
        return this.magicEventRegisterDao;
    }

    public void setMagicEventRegisterDao(MagicEventRegisterDao magicEventRegisterDao) {
        this.magicEventRegisterDao = magicEventRegisterDao;
    }

    private List<ExecuteEntry> loadEventInfoByEventName(String eventName) throws BusinessException {
        List<MagicEventRegisterInfo> infos = this.magicEventRegisterDao.loadEventInfoByEventName(eventName);
        ArrayList<ExecuteEntry> result = new ArrayList<ExecuteEntry>(infos.size());
        for (MagicEventRegisterInfo info : infos) {
            String version;
            String businessId = info.getBusinessId();
            MagicServiceSummary serviceSummary = this.magicServiceSummaryDao.loadServiceInfo(businessId, version = info.getVersion());
            if (serviceSummary == null) {
                LOGGER.info((Object)(businessId + " " + version + "\u6ca1\u6709\u627e\u5230\u5bf9\u4e8e\u7684\u63a5\u53e3\u5b9a\u4e49\u4fe1\u606f \u4e0d\u6267\u884c\u4e8b\u4ef6" + eventName));
                continue;
            }
            ExecuteEntry e = this.loadEventByServices(info, serviceSummary, true);
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    private ExecuteEntry loadEventByServices(MagicEventRegisterInfo info, MagicServiceSummary serviceSummary, boolean first) throws BusinessException {
        String businessId = info.getBusinessId();
        String version = info.getVersion();
        try {
            MagicEventExecuteService executeService;
            PrivateClassLoader pcl = this.getClassLoader(serviceSummary.getId());
            Class classz = pcl.loadClass(info.getExecutePath());
            if (classz != null && (executeService = (MagicEventExecuteService)classz.newInstance()) != null) {
                ExecuteEntry executeEntry = new ExecuteEntry(executeService, info);
                LOGGER.info((Object)(businessId + " " + version + " \u52a0\u8f7d " + info.getExecutePath() + " \u6210\u529f "));
                return executeEntry;
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn((Object)(businessId + " " + version + " \u52a0\u8f7d " + info.getExecutePath() + " \u5931\u8d25 " + e.getLocalizedMessage()));
            if (first) {
                File zipFile = new File(SystemEnvironment.getClusterPublicFolder((String)"interface"), serviceSummary.getBusinessId() + ".zip");
                HashMap<String, Object> params = new HashMap<String, Object>();
                this.magicExternalExportManager.reinstall(zipFile, params, false);
                return this.loadEventByServices(info, serviceSummary, false);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)(businessId + " " + version + " \u52a0\u8f7d " + info.getExecutePath() + " \u5931\u8d25 " + e.getLocalizedMessage()));
        }
        return null;
    }

    private PrivateClassLoader getClassLoader(Long serviceConfigId) {
        PrivateClassLoader temp = new PrivateClassLoader(PrivateFileUtils.class.getClassLoader());
        File compilerPath = new File(SystemEnvironment.getClassCacheFolder(), "magic/execute" + File.separator + serviceConfigId);
        temp.addClassPath(compilerPath.getPath());
        return temp;
    }

    private void execute(List<ExecuteEntry> executeServices, Object eventEntry) throws BusinessException {
        for (ExecuteEntry es : executeServices) {
            try {
                es.getExecuteService().executeEvent(eventEntry);
            }
            catch (BusinessException e) {
                MagicEventRegisterInfo registerInfo = es.getRegisterInfoInfo();
                LOGGER.warn((Object)(registerInfo.getBusinessId() + " execute " + registerInfo.getEventName() + " error, " + e.getLocalizedMessage()));
            }
        }
    }

    private void execute(String eventName, Object eventEntry) throws BusinessException {
        try {
            List<ExecuteEntry> allServices = this.loadEventInfoByEventName(eventName);
            this.execute(allServices, eventEntry);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
    }

    @ListenEvent(event=UpdateMemberEvent.class, async=true)
    public void onUpdateMember(UpdateMemberEvent event) {
        try {
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)event.getCurrentUser());
            this.execute(event.getClass().getSimpleName(), (Object)event);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
    }

    @ListenEvent(event=DeleteMemberEvent.class, async=true)
    public void onDeleteMember(DeleteMemberEvent event) {
        try {
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)event.getCurrentUser());
            this.execute(event.getClass().getSimpleName(), (Object)event);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
    }

    @ListenEvent(event=UpdateDepartmentEvent.class, async=true)
    public void onUpdateDepartment(UpdateDepartmentEvent event) {
        try {
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)event.getCurrentUser());
            this.execute(event.getClass().getSimpleName(), (Object)event);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
    }

    @ListenEvent(event=DeleteDepartmentEvent.class, async=true)
    public void onDeleteDepartment(DeleteDepartmentEvent event) {
        try {
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)event.getCurrentUser());
            this.execute(event.getClass().getSimpleName(), (Object)event);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
    }

    @ListenEvent(event=UpdatePostEvent.class, async=true)
    public void onUpdatePost(UpdatePostEvent event) {
        try {
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)event.getCurrentUser());
            this.execute(event.getClass().getSimpleName(), (Object)event);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
    }

    @ListenEvent(event=DeletePostEvent.class, async=true)
    public void onDeletePost(DeletePostEvent event) {
        try {
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)event.getCurrentUser());
            this.execute(event.getClass().getSimpleName(), (Object)event);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
    }

    @ListenEvent(event=UpdateLevelEvent.class, async=true)
    public void onUpdateLevel(UpdateLevelEvent event) {
        try {
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)event.getCurrentUser());
            this.execute(event.getClass().getSimpleName(), (Object)event);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
    }

    @ListenEvent(event=DeleteLevelEvent.class, async=true)
    public void onDeleteLevel(DeleteLevelEvent event) {
        try {
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)event.getCurrentUser());
            this.execute(event.getClass().getSimpleName(), (Object)event);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e.getLocalizedMessage());
        }
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }

    class ExecuteEntry {
        private MagicEventExecuteService executeService;
        private MagicEventRegisterInfo registerInfoInfo;

        public ExecuteEntry(MagicEventExecuteService executeService, MagicEventRegisterInfo registerInfoInfo) {
            this.executeService = executeService;
            this.registerInfoInfo = registerInfoInfo;
        }

        public MagicEventExecuteService getExecuteService() {
            return this.executeService;
        }

        public void setExecuteService(MagicEventExecuteService executeService) {
            this.executeService = executeService;
        }

        public MagicEventRegisterInfo getRegisterInfoInfo() {
            return this.registerInfoInfo;
        }

        public void setRegisterInfoInfo(MagicEventRegisterInfo registerInfoInfo) {
            this.registerInfoInfo = registerInfoInfo;
        }
    }
}

