/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.magic.event.service;

import com.seeyon.cap4.form.api.FormApi4Cap4;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.magic.dao.IMagicTriggerRecordInfoDao;
import com.seeyon.cap4.magic.event.MagicOuterTriggerManager;
import com.seeyon.cap4.magic.po.MagicTriggerRecordInfo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public class MagicOuterTriggerManagerImpl
implements MagicOuterTriggerManager {
    private CAP4FormManager cap4FormManager;
    private CAP4FormDataManager cap4FormDataManager;
    private FormApi4Cap4 formApi4Cap4;
    private CAP4FormTriggerManager cap4FormTriggerManager;
    private IMagicTriggerRecordInfoDao magicTriggerRecordInfoDao;
    private static final Log LOGGER = CtpLogFactory.getLog(MagicOuterTriggerManagerImpl.class);

    public MagicTriggerRecordInfo getRecordByTargetInfo(long targetInfo, String targetInfoType, String businessId, String version) throws BusinessException {
        return this.magicTriggerRecordInfoDao.getRecordByTargetInfo(targetInfo, targetInfoType, businessId, version);
    }

    public List<MagicTriggerRecordInfo> getRecordBySourceInfo(long sourceMasterId, String sourceInfoType) throws BusinessException {
        return this.magicTriggerRecordInfoDao.getRecordBySourceInfo(sourceMasterId, sourceInfoType);
    }

    public void saveOrUpdateRecordInfo(MagicTriggerRecordInfo info) {
        this.magicTriggerRecordInfoDao.saveOrUpdateTriggerRecordInfo(info);
    }

    public void saveOrUpdateRecordInfos(List<MagicTriggerRecordInfo> info) {
        if (info != null && !info.isEmpty()) {
            this.magicTriggerRecordInfoDao.saveOrUpdateTriggerRecordInfos(info);
        }
    }

    public void saveOrUpdateMasterBean(FormDataMasterBean formDataMasterBean, FormBean formBean) throws BusinessException {
        try {
            FormDataMasterBean oldMasterBean = this.cap4FormManager.getDataMasterBeanById(formDataMasterBean.getId(), formBean, null);
            ArrayList<String> changeFieldList = new ArrayList<String>();
            ArrayList<FormDataMasterBean> masterBeans = new ArrayList<FormDataMasterBean>();
            masterBeans.add(formDataMasterBean);
            AppContext.putThreadContext((String)"CALC_FROM_TRIGGER", (Object)"CALC_FROM_TRIGGER");
            this.cap4FormDataManager.calcAll(formBean, formDataMasterBean, null, false, true, true, true);
            String validateResult = this.formApi4Cap4.validateCheckRule(formBean, formDataMasterBean);
            if (Strings.isBlank((String)validateResult)) {
                changeFieldList.addAll(formDataMasterBean.getModifiedFields((FormDataBean)oldMasterBean));
                this.cap4FormDataManager.insertOrUpdateMasterData(formDataMasterBean);
                validateResult = this.formApi4Cap4.validateDataUnique(formBean, masterBeans);
                if (Strings.isNotBlank((String)validateResult)) {
                    this.cap4FormDataManager.insertOrUpdateMasterData(oldMasterBean);
                }
            }
            if (Strings.isNotBlank((String)validateResult)) {
                // empty if block
            }
            if (formBean.isFlowForm()) {
                this.cap4FormTriggerManager.doTrigger(ModuleType.cap4Form.getKey(), (long)formDataMasterBean.getId(), (long)formBean.getId(), "0", changeFieldList, true);
            } else {
                this.cap4FormTriggerManager.doTrigger(ModuleType.cap4UnflowForm.getKey(), (long)formDataMasterBean.getId(), (long)formBean.getId(), "0", changeFieldList, true);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public CAP4FormDataManager getCap4FormDataManager() {
        return this.cap4FormDataManager;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public FormApi4Cap4 getFormApi4Cap4() {
        return this.formApi4Cap4;
    }

    public void setFormApi4Cap4(FormApi4Cap4 formApi4Cap4) {
        this.formApi4Cap4 = formApi4Cap4;
    }

    public CAP4FormTriggerManager getCap4FormTriggerManager() {
        return this.cap4FormTriggerManager;
    }

    public void setCap4FormTriggerManager(CAP4FormTriggerManager cap4FormTriggerManager) {
        this.cap4FormTriggerManager = cap4FormTriggerManager;
    }

    public IMagicTriggerRecordInfoDao getMagicTriggerRecordInfoDao() {
        return this.magicTriggerRecordInfoDao;
    }

    public void setMagicTriggerRecordInfoDao(IMagicTriggerRecordInfoDao magicTriggerRecordInfoDao) {
        this.magicTriggerRecordInfoDao = magicTriggerRecordInfoDao;
    }
}

